/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets;

import com.gemstone.gemfire.internal.cache.tier.sockets.RedundancyLevelTestBase;
import dunit.DistributedTestCase;
import dunit.Host;

public class RedundancyLevelPart1DUnitTest
extends RedundancyLevelTestBase {
    public RedundancyLevelPart1DUnitTest(String name) {
        super(name);
    }

    public static void caseSetUp() throws Exception {
        DistributedTestCase.disconnectAllFromDS();
    }

    private void waitConnectedServers(final int expected) {
        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return expected == RedundancyLevelTestBase.pool.getConnectedServerCount();
            }

            @Override
            public String description() {
                return "Connected server count (" + RedundancyLevelTestBase.pool.getConnectedServerCount() + ") never became " + expected;
            }
        };
        DistributedTestCase.waitForCriterion(wc, 60000L, 1000L, true);
    }

    public void testRedundancyNotSpecifiedNonPrimaryServerFail() {
        try {
            RedundancyLevelPart1DUnitTest.createClientCache(RedundancyLevelPart1DUnitTest.getServerHostName(Host.getHost(0)), PORT1, PORT2, PORT3, PORT4, 0);
            RedundancyLevelPart1DUnitTest.verifyOrderOfEndpoints();
            this.server2.invoke(RedundancyLevelTestBase.class, "stopServer");
            RedundancyLevelPart1DUnitTest.verifyLiveAndRedundantServers(3, 0);
            RedundancyLevelPart1DUnitTest.verifyOrderOfEndpoints();
            DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

                @Override
                public boolean done() {
                    return !RedundancyLevelTestBase.pool.getCurrentServerNames().contains(RedundancyLevelTestBase.SERVER3);
                }

                @Override
                public String description() {
                    return "pool still contains " + RedundancyLevelTestBase.SERVER3;
                }
            };
            DistributedTestCase.waitForCriterion(wc, 30000L, 1000L, true);
        }
        catch (Exception ex) {
            RedundancyLevelPart1DUnitTest.fail("test failed due to exception in test RedundancyNotSpecifiedNonPrimaryServerFail ", ex);
        }
    }

    public void testRedundancyNotSpecifiedPrimaryServerFails() {
        try {
            RedundancyLevelPart1DUnitTest.createClientCache(RedundancyLevelPart1DUnitTest.getServerHostName(Host.getHost(0)), PORT1, PORT2, PORT3, PORT4, 0, 3000, 100);
            RedundancyLevelPart1DUnitTest.assertTrue((boolean)pool.getPrimaryName().equals(SERVER1));
            RedundancyLevelPart1DUnitTest.verifyOrderOfEndpoints();
            this.server0.invoke(RedundancyLevelTestBase.class, "stopServer");
            RedundancyLevelPart1DUnitTest.verifyLiveAndRedundantServers(3, 0);
            RedundancyLevelPart1DUnitTest.verifyOrderOfEndpoints();
            DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

                @Override
                public boolean done() {
                    return !RedundancyLevelTestBase.pool.getCurrentServerNames().contains(RedundancyLevelTestBase.SERVER1);
                }

                @Override
                public String description() {
                    return "pool still contains " + RedundancyLevelTestBase.SERVER1;
                }
            };
            DistributedTestCase.waitForCriterion(wc, 30000L, 1000L, true);
            RedundancyLevelPart1DUnitTest.assertFalse((boolean)pool.getPrimaryName().equals(SERVER1));
            RedundancyLevelPart1DUnitTest.assertEquals((String)SERVER2, (String)pool.getPrimaryName());
        }
        catch (Exception ex) {
            RedundancyLevelPart1DUnitTest.fail("test failed due to exception in test RedundancyNotSpecifiedPrimaryServerFails ", ex);
        }
    }

    public void testRedundancySpecifiedNonFailoverEPFails() {
        try {
            RedundancyLevelPart1DUnitTest.createClientCache(RedundancyLevelPart1DUnitTest.getServerHostName(Host.getHost(0)), PORT1, PORT2, PORT3, PORT4, 1);
            this.waitConnectedServers(4);
            RedundancyLevelPart1DUnitTest.assertEquals((int)1, (int)pool.getRedundantNames().size());
            RedundancyLevelPart1DUnitTest.assertTrue((boolean)pool.getRedundantNames().contains(SERVER2));
            RedundancyLevelPart1DUnitTest.verifyOrderOfEndpoints();
            this.server2.invoke(RedundancyLevelTestBase.class, "stopServer");
            RedundancyLevelPart1DUnitTest.verifyDeadServers(1);
            RedundancyLevelPart1DUnitTest.verifyRedundantServersContain(SERVER2);
            RedundancyLevelPart1DUnitTest.verifyLiveAndRedundantServers(3, 1);
            RedundancyLevelPart1DUnitTest.verifyOrderOfEndpoints();
        }
        catch (Exception ex) {
            RedundancyLevelPart1DUnitTest.fail("test failed due to exception in test testRedundancySpecifiedNonFailoverEPFails ", ex);
        }
    }

    public void _testRedundancySpecifiedNonFailoverEPFailsDetectionByCCU() {
        try {
            FailOverDetectionByCCU = true;
            RedundancyLevelPart1DUnitTest.createClientCache(RedundancyLevelPart1DUnitTest.getServerHostName(Host.getHost(0)), PORT1, PORT2, PORT3, PORT4, 1, 250, 500);
            this.waitConnectedServers(4);
            RedundancyLevelPart1DUnitTest.assertEquals((int)1, (int)pool.getRedundantNames().size());
            RedundancyLevelPart1DUnitTest.assertTrue((boolean)pool.getRedundantNames().contains(SERVER4));
            RedundancyLevelPart1DUnitTest.verifyOrderOfEndpoints();
            this.server2.invoke(RedundancyLevelTestBase.class, "stopServer");
            RedundancyLevelPart1DUnitTest.verifyDeadServers(1);
            RedundancyLevelPart1DUnitTest.verifyRedundantServersContain(SERVER4);
            RedundancyLevelPart1DUnitTest.verifyLiveAndRedundantServers(3, 1);
            RedundancyLevelPart1DUnitTest.verifyOrderOfEndpoints();
        }
        catch (Exception ex) {
            RedundancyLevelPart1DUnitTest.fail("test failed due to exception in test testRedundancySpecifiedNonFailoverEPFailsDetectionByCCU ", ex);
        }
    }

    public void _testRedundancySpecifiedNonFailoverEPFailsDetectionByRegisterInterest() {
        try {
            RedundancyLevelPart1DUnitTest.createClientCache(RedundancyLevelPart1DUnitTest.getServerHostName(Host.getHost(0)), PORT1, PORT2, PORT3, PORT4, 1, 250, 500);
            this.waitConnectedServers(4);
            RedundancyLevelPart1DUnitTest.assertEquals((int)1, (int)pool.getRedundantNames().size());
            RedundancyLevelPart1DUnitTest.assertTrue((boolean)pool.getRedundantNames().contains(SERVER4));
            RedundancyLevelPart1DUnitTest.verifyOrderOfEndpoints();
            this.server2.invoke(RedundancyLevelTestBase.class, "stopServer");
            RedundancyLevelPart1DUnitTest.createEntriesK1andK2();
            RedundancyLevelPart1DUnitTest.registerK1AndK2();
            RedundancyLevelPart1DUnitTest.verifyDeadServers(1);
            RedundancyLevelPart1DUnitTest.verifyRedundantServersContain(SERVER4);
            RedundancyLevelPart1DUnitTest.verifyLiveAndRedundantServers(3, 1);
            RedundancyLevelPart1DUnitTest.verifyOrderOfEndpoints();
        }
        catch (Exception ex) {
            RedundancyLevelPart1DUnitTest.fail("test failed due to exception in test testRedundancySpecifiedNonFailoverEPFailsDetectionByRegisterInterest ", ex);
        }
    }

    public void _testRedundancySpecifiedNonFailoverEPFailsDetectionByUnregisterInterest() {
        try {
            RedundancyLevelPart1DUnitTest.createClientCache(RedundancyLevelPart1DUnitTest.getServerHostName(Host.getHost(0)), PORT1, PORT2, PORT3, PORT4, 1, 250, 500);
            this.waitConnectedServers(4);
            RedundancyLevelPart1DUnitTest.assertEquals((int)1, (int)pool.getRedundantNames().size());
            RedundancyLevelPart1DUnitTest.assertTrue((boolean)pool.getRedundantNames().contains(SERVER4));
            RedundancyLevelPart1DUnitTest.verifyOrderOfEndpoints();
            this.server2.invoke(RedundancyLevelTestBase.class, "stopServer");
            RedundancyLevelPart1DUnitTest.unregisterInterest();
            RedundancyLevelPart1DUnitTest.verifyDeadServers(1);
            RedundancyLevelPart1DUnitTest.verifyRedundantServersContain(SERVER4);
            RedundancyLevelPart1DUnitTest.verifyLiveAndRedundantServers(3, 1);
            RedundancyLevelPart1DUnitTest.verifyOrderOfEndpoints();
        }
        catch (Exception ex) {
            RedundancyLevelPart1DUnitTest.fail("test failed due to exception in test testRedundancySpecifiedNonFailoverEPFailsDetectionByUnregisterInterest ", ex);
        }
    }

    public void testRedundancySpecifiedNonFailoverEPFailsDetectionByPut() {
        try {
            RedundancyLevelPart1DUnitTest.createClientCache(RedundancyLevelPart1DUnitTest.getServerHostName(Host.getHost(0)), PORT1, PORT2, PORT3, PORT4, 1, 500, 1000);
            this.waitConnectedServers(4);
            RedundancyLevelPart1DUnitTest.assertEquals((int)1, (int)pool.getRedundantNames().size());
            RedundancyLevelPart1DUnitTest.assertTrue((boolean)pool.getRedundantNames().contains(SERVER2));
            RedundancyLevelPart1DUnitTest.verifyOrderOfEndpoints();
            this.server2.invoke(RedundancyLevelTestBase.class, "stopServer");
            RedundancyLevelPart1DUnitTest.doPuts();
            RedundancyLevelPart1DUnitTest.verifyDeadServers(1);
            RedundancyLevelPart1DUnitTest.verifyRedundantServersContain(SERVER2);
            RedundancyLevelPart1DUnitTest.verifyLiveAndRedundantServers(3, 1);
            RedundancyLevelPart1DUnitTest.verifyOrderOfEndpoints();
        }
        catch (Exception ex) {
            RedundancyLevelPart1DUnitTest.fail("test failed due to exception in test testRedundancySpecifiedNonFailoverEPFailsDetectionByPut ", ex);
        }
    }

    public void testRedundancySpecifiedNonPrimaryEPFails() {
        try {
            RedundancyLevelPart1DUnitTest.createClientCache(RedundancyLevelPart1DUnitTest.getServerHostName(Host.getHost(0)), PORT1, PORT2, PORT3, PORT4, 1);
            this.waitConnectedServers(4);
            RedundancyLevelPart1DUnitTest.assertEquals((int)1, (int)pool.getRedundantNames().size());
            RedundancyLevelPart1DUnitTest.assertTrue((boolean)pool.getPrimaryName().equals(SERVER1));
            RedundancyLevelPart1DUnitTest.assertTrue((boolean)pool.getRedundantNames().contains(SERVER2));
            RedundancyLevelPart1DUnitTest.verifyOrderOfEndpoints();
            this.server1.invoke(RedundancyLevelTestBase.class, "stopServer");
            RedundancyLevelPart1DUnitTest.verifyDeadServers(1);
            RedundancyLevelPart1DUnitTest.verifyRedundantServersContain(SERVER3);
            RedundancyLevelPart1DUnitTest.verifyLiveAndRedundantServers(3, 1);
            RedundancyLevelPart1DUnitTest.verifyOrderOfEndpoints();
            this.server2.invoke(RedundancyLevelTestBase.class, "verifyInterestRegistration");
        }
        catch (Exception ex) {
            RedundancyLevelPart1DUnitTest.fail("test failed due to exception in test testRedundancySpecifiedNonFailoverEPFails ", ex);
        }
    }

    public void testRedundancySpecifiedNonPrimaryEPFailsDetectionByCCU() {
        try {
            FailOverDetectionByCCU = true;
            RedundancyLevelPart1DUnitTest.createClientCache(RedundancyLevelPart1DUnitTest.getServerHostName(Host.getHost(0)), PORT1, PORT2, PORT3, PORT4, 1, 250, 500);
            this.waitConnectedServers(4);
            RedundancyLevelPart1DUnitTest.assertEquals((int)1, (int)pool.getRedundantNames().size());
            RedundancyLevelPart1DUnitTest.assertTrue((boolean)pool.getPrimaryName().equals(SERVER1));
            RedundancyLevelPart1DUnitTest.assertTrue((boolean)pool.getRedundantNames().contains(SERVER2));
            RedundancyLevelPart1DUnitTest.verifyOrderOfEndpoints();
            this.server1.invoke(RedundancyLevelTestBase.class, "stopServer");
            RedundancyLevelPart1DUnitTest.verifyDeadServers(1);
            RedundancyLevelPart1DUnitTest.verifyRedundantServersContain(SERVER3);
            RedundancyLevelPart1DUnitTest.verifyLiveAndRedundantServers(3, 1);
            RedundancyLevelPart1DUnitTest.verifyOrderOfEndpoints();
            this.server2.invoke(RedundancyLevelTestBase.class, "verifyInterestRegistration");
        }
        catch (Exception ex) {
            RedundancyLevelPart1DUnitTest.fail("test failed due to exception in test testRedundancySpecifiedNonPrimaryEPFailsDetectionByCCU ", ex);
        }
    }

    public void testRedundancySpecifiedNonPrimaryEPFailsDetectionByRegisterInterest() {
        try {
            RedundancyLevelPart1DUnitTest.createClientCache(RedundancyLevelPart1DUnitTest.getServerHostName(Host.getHost(0)), PORT1, PORT2, PORT3, PORT4, 1, 250, 500);
            this.waitConnectedServers(4);
            RedundancyLevelPart1DUnitTest.assertEquals((int)1, (int)pool.getRedundantNames().size());
            RedundancyLevelPart1DUnitTest.assertTrue((boolean)pool.getPrimaryName().equals(SERVER1));
            RedundancyLevelPart1DUnitTest.assertTrue((boolean)pool.getRedundantNames().contains(SERVER2));
            RedundancyLevelPart1DUnitTest.verifyOrderOfEndpoints();
            this.server1.invoke(RedundancyLevelTestBase.class, "stopServer");
            RedundancyLevelPart1DUnitTest.createEntriesK1andK2();
            RedundancyLevelPart1DUnitTest.registerK1AndK2();
            RedundancyLevelPart1DUnitTest.verifyDeadServers(1);
            RedundancyLevelPart1DUnitTest.verifyRedundantServersContain(SERVER3);
            RedundancyLevelPart1DUnitTest.verifyLiveAndRedundantServers(3, 1);
            RedundancyLevelPart1DUnitTest.verifyOrderOfEndpoints();
            this.server2.invoke(RedundancyLevelTestBase.class, "verifyInterestRegistration");
        }
        catch (Exception ex) {
            RedundancyLevelPart1DUnitTest.fail("test failed due to exception in test testRedundancySpecifiedNonPrimaryEPFailsDetectionByRegisterInterest ", ex);
        }
    }

    public void testRedundancySpecifiedNonPrimaryEPFailsDetectionByUnregisterInterest() {
        try {
            RedundancyLevelPart1DUnitTest.createClientCache(RedundancyLevelPart1DUnitTest.getServerHostName(Host.getHost(0)), PORT1, PORT2, PORT3, PORT4, 1, 250, 500);
            this.waitConnectedServers(4);
            RedundancyLevelPart1DUnitTest.assertEquals((int)1, (int)pool.getRedundantNames().size());
            RedundancyLevelPart1DUnitTest.assertTrue((boolean)pool.getPrimaryName().equals(SERVER1));
            RedundancyLevelPart1DUnitTest.assertTrue((boolean)pool.getRedundantNames().contains(SERVER2));
            RedundancyLevelPart1DUnitTest.verifyOrderOfEndpoints();
            this.server1.invoke(RedundancyLevelTestBase.class, "stopServer");
            RedundancyLevelPart1DUnitTest.unregisterInterest();
            RedundancyLevelPart1DUnitTest.verifyDeadServers(1);
            RedundancyLevelPart1DUnitTest.verifyRedundantServersContain(SERVER3);
            RedundancyLevelPart1DUnitTest.verifyLiveAndRedundantServers(3, 1);
            RedundancyLevelPart1DUnitTest.verifyOrderOfEndpoints();
        }
        catch (Exception ex) {
            RedundancyLevelPart1DUnitTest.fail("test failed due to exception in test testRedundancySpecifiedNonPrimaryEPFailsDetectionByUnregisterInterest ", ex);
        }
    }

    public void testRedundancySpecifiedNonPrimaryEPFailsDetectionByPut() {
        try {
            RedundancyLevelPart1DUnitTest.createClientCache(RedundancyLevelPart1DUnitTest.getServerHostName(Host.getHost(0)), PORT1, PORT2, PORT3, PORT4, 1, 250, 500);
            this.waitConnectedServers(4);
            RedundancyLevelPart1DUnitTest.assertEquals((int)1, (int)pool.getRedundantNames().size());
            RedundancyLevelPart1DUnitTest.assertTrue((boolean)pool.getPrimaryName().equals(SERVER1));
            RedundancyLevelPart1DUnitTest.assertTrue((boolean)pool.getRedundantNames().contains(SERVER2));
            RedundancyLevelPart1DUnitTest.verifyOrderOfEndpoints();
            this.server1.invoke(RedundancyLevelTestBase.class, "stopServer");
            RedundancyLevelPart1DUnitTest.doPuts();
            RedundancyLevelPart1DUnitTest.verifyDeadServers(1);
            RedundancyLevelPart1DUnitTest.verifyRedundantServersContain(SERVER3);
            RedundancyLevelPart1DUnitTest.verifyLiveAndRedundantServers(3, 1);
            RedundancyLevelPart1DUnitTest.verifyOrderOfEndpoints();
            this.server2.invoke(RedundancyLevelTestBase.class, "verifyInterestRegistration");
        }
        catch (Exception ex) {
            RedundancyLevelPart1DUnitTest.fail("test failed due to exception in test testRedundancySpecifiedNonPrimaryEPFailsDetectionByPut ", ex);
        }
    }
}

