/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.InterestResultPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.util.BridgeServer;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.BridgeObserver;
import com.gemstone.gemfire.internal.cache.BridgeObserverAdapter;
import com.gemstone.gemfire.internal.cache.BridgeObserverHolder;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.util.Properties;

public class DurableResponseMatrixDUnitTest
extends DistributedTestCase {
    protected static Cache cache = null;
    VM server1 = null;
    private static Integer PORT1;
    private static final String REGION_NAME = "DurableResponseMatrixDUnitTest_region";
    public static final String KEY = "KeyMatrix1";

    public DurableResponseMatrixDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Host host = Host.getHost(0);
        this.server1 = host.getVM(0);
        PORT1 = (Integer)this.server1.invoke(DurableResponseMatrixDUnitTest.class, "createServerCache");
        this.createCacheClient(DurableResponseMatrixDUnitTest.getServerHostName(this.server1.getHost()));
    }

    public void testRegisterInterestResponse_NonExistent_Invalid() throws Exception {
        this.server1.invoke(DurableResponseMatrixDUnitTest.class, "invalidateEntry", new Object[]{KEY});
        Region r = cache.getRegion("/DurableResponseMatrixDUnitTest_region");
        r.registerInterest((Object)KEY, InterestResultPolicy.KEYS_VALUES);
        DurableResponseMatrixDUnitTest.assertFalse((boolean)r.containsValueForKey((Object)KEY));
        DurableResponseMatrixDUnitTest.assertEquals(null, (Object)r.getEntry((Object)KEY).getValue());
    }

    public void testRegisterInterestResponse_NonExistent_Valid() throws Exception {
        this.server1.invoke(DurableResponseMatrixDUnitTest.class, "updateEntry", new Object[]{KEY, "ValueMatrix1"});
        Region r = cache.getRegion("/DurableResponseMatrixDUnitTest_region");
        r.registerInterest((Object)KEY, InterestResultPolicy.KEYS_VALUES);
        DurableResponseMatrixDUnitTest.assertEquals((Object)"ValueMatrix1", (Object)r.getEntry((Object)KEY).getValue());
    }

    public void BROKEN_testRegisterInterestResponse_Valid_Invalid() throws Exception {
        Region r = cache.getRegion("/DurableResponseMatrixDUnitTest_region");
        r.put((Object)KEY, (Object)"ValueMatrix1");
        this.server1.invoke(DurableResponseMatrixDUnitTest.class, "invalidateEntry", new Object[]{KEY});
        r.registerInterest((Object)KEY, InterestResultPolicy.KEYS_VALUES);
        DurableResponseMatrixDUnitTest.assertEquals((Object)"ValueMatrix1", (Object)r.getEntry((Object)KEY).getValue());
    }

    public void testRegisterInterestResponse_Valid_Valid() throws Exception {
        Region r = cache.getRegion("/DurableResponseMatrixDUnitTest_region");
        r.put((Object)KEY, (Object)"ValueMatrix1");
        r.registerInterest((Object)KEY, InterestResultPolicy.KEYS_VALUES);
        DurableResponseMatrixDUnitTest.assertEquals((Object)"ValueMatrix1", (Object)r.getEntry((Object)KEY).getValue());
    }

    public void testRegisterInterestResponse_Invalid_Invalid() throws Exception {
        Region r = cache.getRegion("/DurableResponseMatrixDUnitTest_region");
        DurableResponseMatrixDUnitTest.invalidateEntry(KEY);
        this.server1.invoke(DurableResponseMatrixDUnitTest.class, "invalidateEntry", new Object[]{KEY});
        r.registerInterest((Object)KEY, InterestResultPolicy.KEYS_VALUES);
        DurableResponseMatrixDUnitTest.assertEquals(null, (Object)r.getEntry((Object)KEY).getValue());
    }

    public void BROKEN_testRegisterInterestResponse_Invalid_Valid() throws Exception {
        Region r = cache.getRegion("/DurableResponseMatrixDUnitTest_region");
        DurableResponseMatrixDUnitTest.invalidateEntry(KEY);
        this.server1.invoke(DurableResponseMatrixDUnitTest.class, "updateEntry", new Object[]{KEY, "ValueMatrix1"});
        r.registerInterest((Object)KEY, InterestResultPolicy.KEYS_VALUES);
        DurableResponseMatrixDUnitTest.assertEquals((Object)"ValueMatrix1", (Object)r.getEntry((Object)KEY).getValue());
    }

    public void testRegisterInterestResponse_Destroyed_Invalid() throws Exception {
        Region r = cache.getRegion("/DurableResponseMatrixDUnitTest_region");
        r.put((Object)KEY, (Object)"DummyValue");
        r.destroy((Object)KEY);
        this.server1.invoke(DurableResponseMatrixDUnitTest.class, "invalidateEntry", new Object[]{KEY});
        r.registerInterest((Object)KEY, InterestResultPolicy.KEYS_VALUES);
        DurableResponseMatrixDUnitTest.assertFalse((boolean)r.containsValueForKey((Object)KEY));
        DurableResponseMatrixDUnitTest.assertEquals(null, (Object)r.getEntry((Object)KEY).getValue());
    }

    public void testRegisterInterestResponse_Destroyed_Valid() throws Exception {
        Region r = cache.getRegion("/DurableResponseMatrixDUnitTest_region");
        r.put((Object)KEY, (Object)"DummyValue");
        r.destroy((Object)KEY);
        this.server1.invoke(DurableResponseMatrixDUnitTest.class, "updateEntry", new Object[]{KEY, "ValueMatrix1"});
        r.registerInterest((Object)KEY, InterestResultPolicy.KEYS_VALUES);
        DurableResponseMatrixDUnitTest.assertEquals((Object)"ValueMatrix1", (Object)r.getEntry((Object)KEY).getValue());
    }

    public void testRegisterInterest_Destroy_Concurrent() throws Exception {
        PoolImpl.BEFORE_REGISTER_CALLBACK_FLAG = true;
        BridgeObserverHolder.setInstance((BridgeObserver)new BridgeObserverAdapter(){

            public void beforeInterestRegistration() {
                Region r = cache.getRegion("/DurableResponseMatrixDUnitTest_region");
                r.put((Object)DurableResponseMatrixDUnitTest.KEY, (Object)"AgainDummyValue");
                r.destroy((Object)DurableResponseMatrixDUnitTest.KEY);
                PoolImpl.BEFORE_REGISTER_CALLBACK_FLAG = false;
            }
        });
        Region r = cache.getRegion("/DurableResponseMatrixDUnitTest_region");
        r.put((Object)KEY, (Object)"DummyValue");
        this.server1.invoke(DurableResponseMatrixDUnitTest.class, "updateEntry", new Object[]{KEY, "ValueMatrix1"});
        r.registerInterest((Object)KEY, InterestResultPolicy.KEYS_VALUES);
        DurableResponseMatrixDUnitTest.assertEquals(null, (Object)r.getEntry((Object)KEY));
    }

    private void waitForValue(final Region r, final Object key, final Object expected) {
        DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                Region.Entry entry = r.getEntry((Object)DurableResponseMatrixDUnitTest.KEY);
                return expected == null ? !r.containsValueForKey(key) : entry != null && expected.equals(entry.getValue());
            }

            @Override
            public String description() {
                return null;
            }
        };
        DistributedTestCase.waitForCriterion(ev, 120000L, 200L, true);
    }

    public void testNotification_NonExistent_Create() throws Exception {
        Region r = cache.getRegion("/DurableResponseMatrixDUnitTest_region");
        r.registerInterest((Object)"ALL_KEYS", InterestResultPolicy.NONE);
        this.server1.invoke(DurableResponseMatrixDUnitTest.class, "updateEntry", new Object[]{KEY, "ValueMatrix1"});
        this.waitForValue(r, KEY, "ValueMatrix1");
    }

    public void testNotification_NonExistent_Update() throws Exception {
        Region r = cache.getRegion("/DurableResponseMatrixDUnitTest_region");
        r.registerInterest((Object)"ALL_KEYS", InterestResultPolicy.NONE);
        this.server1.invoke(DurableResponseMatrixDUnitTest.class, "updateEntry", new Object[]{KEY, "ValueMatrix1"});
        this.server1.invoke(DurableResponseMatrixDUnitTest.class, "updateEntry", new Object[]{KEY, "ValueMatrix2"});
        this.waitForValue(r, KEY, "ValueMatrix2");
    }

    public void testNotification_NonExistent_Invalid() throws Exception {
        Region r = cache.getRegion("/DurableResponseMatrixDUnitTest_region");
        this.server1.invoke(DurableResponseMatrixDUnitTest.class, "updateEntry", new Object[]{KEY, "ValueMatrix1"});
        r.registerInterest((Object)"ALL_KEYS", InterestResultPolicy.NONE);
        this.server1.invoke(DurableResponseMatrixDUnitTest.class, "invalidateEntryOnly", new Object[]{KEY});
        this.waitForValue(r, KEY, null);
    }

    public void testNotification_NonExistent_Destroy() throws Exception {
        Region r = cache.getRegion("/DurableResponseMatrixDUnitTest_region");
        this.server1.invoke(DurableResponseMatrixDUnitTest.class, "updateEntry", new Object[]{KEY, "ValueMatrix1"});
        r.registerInterest((Object)"ALL_KEYS", InterestResultPolicy.NONE);
        this.server1.invoke(DurableResponseMatrixDUnitTest.class, "destroyEntry", new Object[]{KEY});
        this.waitForValue(r, KEY, null);
    }

    public void testNotification_Valid_Create() throws Exception {
        Region r = cache.getRegion("/DurableResponseMatrixDUnitTest_region");
        r.put((Object)KEY, (Object)"DummyValue");
        r.registerInterest((Object)"ALL_KEYS", InterestResultPolicy.NONE);
        this.server1.invoke(DurableResponseMatrixDUnitTest.class, "updateEntry", new Object[]{KEY, "ValueMatrix1"});
        this.waitForValue(r, KEY, "ValueMatrix1");
    }

    public void testNotification_Valid_Update() throws Exception {
        Region r = cache.getRegion("/DurableResponseMatrixDUnitTest_region");
        r.put((Object)KEY, (Object)"DummyValue");
        r.registerInterest((Object)"ALL_KEYS", InterestResultPolicy.NONE);
        this.server1.invoke(DurableResponseMatrixDUnitTest.class, "updateEntry", new Object[]{KEY, "ValueMatrix2"});
        this.waitForValue(r, KEY, "ValueMatrix2");
    }

    public void BROKEN_testNotification_Valid_Invalid() throws Exception {
        Region r = cache.getRegion("/DurableResponseMatrixDUnitTest_region");
        r.put((Object)KEY, (Object)"DummyValue");
        r.registerInterest((Object)"ALL_KEYS", InterestResultPolicy.NONE);
        this.server1.invoke(DurableResponseMatrixDUnitTest.class, "invalidateEntryOnly", new Object[]{KEY});
        this.waitForValue(r, KEY, null);
    }

    public void testNotification_Valid_Destroy() throws Exception {
        Region r = cache.getRegion("/DurableResponseMatrixDUnitTest_region");
        r.put((Object)KEY, (Object)"DummyValue");
        r.registerInterest((Object)"ALL_KEYS", InterestResultPolicy.NONE);
        this.server1.invoke(DurableResponseMatrixDUnitTest.class, "destroyEntry", new Object[]{KEY});
        this.waitForValue(r, KEY, null);
    }

    public void testNotification_Invalid_Create() throws Exception {
        Region r = cache.getRegion("/DurableResponseMatrixDUnitTest_region");
        DurableResponseMatrixDUnitTest.invalidateEntry(KEY);
        r.registerInterest((Object)"ALL_KEYS", InterestResultPolicy.NONE);
        this.server1.invoke(DurableResponseMatrixDUnitTest.class, "updateEntry", new Object[]{KEY, "ValueMatrix1"});
        this.waitForValue(r, KEY, "ValueMatrix1");
    }

    public void testNotification_Invalid_Update() throws Exception {
        Region r = cache.getRegion("/DurableResponseMatrixDUnitTest_region");
        DurableResponseMatrixDUnitTest.invalidateEntry(KEY);
        r.registerInterest((Object)"ALL_KEYS", InterestResultPolicy.NONE);
        this.server1.invoke(DurableResponseMatrixDUnitTest.class, "updateEntry", new Object[]{KEY, "ValueMatrix1"});
        this.waitForValue(r, KEY, "ValueMatrix1");
    }

    public void BROKEN_testNotification_Invalid_Invalid() throws Exception {
        Region r = cache.getRegion("/DurableResponseMatrixDUnitTest_region");
        DurableResponseMatrixDUnitTest.invalidateEntry(KEY);
        r.registerInterest((Object)"ALL_KEYS", InterestResultPolicy.NONE);
        this.server1.invoke(DurableResponseMatrixDUnitTest.class, "invalidateEntryOnly", new Object[]{KEY});
        this.waitForValue(r, KEY, null);
    }

    public void testNotification_Invalid_Destroy() throws Exception {
        Region r = cache.getRegion("/DurableResponseMatrixDUnitTest_region");
        DurableResponseMatrixDUnitTest.invalidateEntry(KEY);
        r.registerInterest((Object)"ALL_KEYS", InterestResultPolicy.NONE);
        this.server1.invoke(DurableResponseMatrixDUnitTest.class, "destroyEntry", new Object[]{KEY});
        this.waitForValue(r, KEY, null);
    }

    public void testNotification_LocalInvalid_Create() throws Exception {
        Region r = cache.getRegion("/DurableResponseMatrixDUnitTest_region");
        DurableResponseMatrixDUnitTest.localInvalidateEntry(KEY);
        r.registerInterest((Object)"ALL_KEYS", InterestResultPolicy.NONE);
        this.server1.invoke(DurableResponseMatrixDUnitTest.class, "updateEntry", new Object[]{KEY, "ValueMatrix1"});
        this.waitForValue(r, KEY, "ValueMatrix1");
    }

    public void testNotification_LocalInvalid_Update() throws Exception {
        Region r = cache.getRegion("/DurableResponseMatrixDUnitTest_region");
        DurableResponseMatrixDUnitTest.localInvalidateEntry(KEY);
        r.registerInterest((Object)"ALL_KEYS", InterestResultPolicy.NONE);
        this.server1.invoke(DurableResponseMatrixDUnitTest.class, "updateEntry", new Object[]{KEY, "ValueMatrix1"});
        this.waitForValue(r, KEY, "ValueMatrix1");
    }

    public void BROKEN_testNotification_LocalInvalid_Invalid() throws Exception {
        Region r = cache.getRegion("/DurableResponseMatrixDUnitTest_region");
        DurableResponseMatrixDUnitTest.localInvalidateEntry(KEY);
        r.registerInterest((Object)"ALL_KEYS", InterestResultPolicy.NONE);
        this.server1.invoke(DurableResponseMatrixDUnitTest.class, "invalidateEntryOnly", new Object[]{KEY});
        this.waitForValue(r, KEY, null);
    }

    public void testNotification_LocalInvalid_Destroy() throws Exception {
        Region r = cache.getRegion("/DurableResponseMatrixDUnitTest_region");
        DurableResponseMatrixDUnitTest.invalidateEntry(KEY);
        r.registerInterest((Object)"ALL_KEYS", InterestResultPolicy.NONE);
        this.server1.invoke(DurableResponseMatrixDUnitTest.class, "destroyEntry", new Object[]{KEY});
        this.waitForValue(r, KEY, null);
    }

    public static void updateEntry(String key, String value) throws Exception {
        try {
            Region r = cache.getRegion("/DurableResponseMatrixDUnitTest_region");
            DurableResponseMatrixDUnitTest.assertNotNull((Object)r);
            r.put((Object)key, (Object)value);
        }
        catch (Exception e) {
            DurableResponseMatrixDUnitTest.fail("test failed due to ", e);
        }
    }

    public static void destroyEntry(String key) throws Exception {
        try {
            Region r = cache.getRegion("/DurableResponseMatrixDUnitTest_region");
            DurableResponseMatrixDUnitTest.assertNotNull((Object)r);
            r.destroy((Object)key);
        }
        catch (Exception e) {
            DurableResponseMatrixDUnitTest.fail("test failed due to ", e);
        }
    }

    public static void invalidateEntryOnly(String key) throws Exception {
        try {
            Region r = cache.getRegion("/DurableResponseMatrixDUnitTest_region");
            DurableResponseMatrixDUnitTest.assertNotNull((Object)r);
            r.invalidate((Object)key);
        }
        catch (Exception e) {
            DurableResponseMatrixDUnitTest.fail("test failed due to ", e);
        }
    }

    public static void invalidateEntry(String key) throws Exception {
        try {
            Region r = cache.getRegion("/DurableResponseMatrixDUnitTest_region");
            DurableResponseMatrixDUnitTest.assertNotNull((Object)r);
            r.put((Object)key, (Object)"DummyValue");
            r.invalidate((Object)key);
        }
        catch (Exception e) {
            DurableResponseMatrixDUnitTest.fail("test failed due to ", e);
        }
    }

    public static void localInvalidateEntry(String key) throws Exception {
        try {
            Region r = cache.getRegion("/DurableResponseMatrixDUnitTest_region");
            DurableResponseMatrixDUnitTest.assertNotNull((Object)r);
            r.put((Object)key, (Object)"DummyValue");
            r.localInvalidate((Object)key);
        }
        catch (Exception e) {
            DurableResponseMatrixDUnitTest.fail("test failed due to ", e);
        }
    }

    private void createCache(Properties props) {
        try {
            InternalDistributedSystem ds = this.getSystem(props);
            DurableResponseMatrixDUnitTest.assertNotNull((Object)ds);
            ds.disconnect();
            ds = this.getSystem(props);
            cache = CacheFactory.create((DistributedSystem)ds);
            DurableResponseMatrixDUnitTest.assertNotNull((Object)cache);
        }
        catch (Exception e) {
            DurableResponseMatrixDUnitTest.fail("test failed due to ", e);
        }
    }

    private void createCacheClient(String host) {
        try {
            String durableClientId = "DurableResponseMatrixDUnitTest_client";
            int durableClientTimeout = 60;
            Properties props = this.getClientDistributedSystemProperties("DurableResponseMatrixDUnitTest_client", 60);
            new DurableResponseMatrixDUnitTest("temp").createCache(props);
            Pool p = PoolManager.createFactory().addServer(host, PORT1.intValue()).setSubscriptionEnabled(true).setSubscriptionRedundancy(1).setReadTimeout(10000).setMinConnections(2).create("DurableResponseMatrixDUnitTestPool");
            AttributesFactory factory = new AttributesFactory();
            factory.setScope(Scope.LOCAL);
            factory.setPoolName(p.getName());
            RegionAttributes attrs = factory.create();
            Region r = cache.createRegion(REGION_NAME, attrs);
            DurableResponseMatrixDUnitTest.assertNotNull((Object)r);
            cache.readyForEvents();
        }
        catch (Exception e) {
            DurableResponseMatrixDUnitTest.fail("test failed due to ", e);
        }
    }

    public static Integer createServerCache() throws Exception {
        Properties props = new Properties();
        new DurableResponseMatrixDUnitTest("temp").createCache(props);
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setDataPolicy(DataPolicy.REPLICATE);
        RegionAttributes attrs = factory.create();
        Region r = cache.createRegion(REGION_NAME, attrs);
        DurableResponseMatrixDUnitTest.assertNotNull((Object)r);
        BridgeServer server1 = cache.addBridgeServer();
        int port = AvailablePort.getRandomAvailablePort((int)0);
        server1.setPort(port);
        server1.setNotifyBySubscription(true);
        server1.start();
        return new Integer(server1.getPort());
    }

    private Properties getClientDistributedSystemProperties(String durableClientId, int durableClientTimeout) {
        Properties properties = new Properties();
        properties.setProperty("mcast-port", "0");
        properties.setProperty("locators", "");
        properties.setProperty("durable-client-id", durableClientId);
        properties.setProperty("durable-client-timeout", String.valueOf(durableClientTimeout));
        return properties;
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        DurableResponseMatrixDUnitTest.closeCache();
        this.server1.invoke(DurableResponseMatrixDUnitTest.class, "closeCache");
    }

    public static void closeCache() {
        if (cache != null && !cache.isClosed()) {
            cache.close();
            cache.getDistributedSystem().disconnect();
        }
    }
}

