/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.client.internal.Connection;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.client.internal.ServerRegionProxy;
import com.gemstone.gemfire.cache.util.BridgeServer;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CertifiableTestCacheListener;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerTestUtil;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import junit.framework.TestCase;
import util.TestException;

public class DestroyEntryPropagationDUnitTest
extends DistributedTestCase {
    VM vm0 = null;
    VM vm1 = null;
    VM vm2 = null;
    VM vm3 = null;
    private static int PORT1;
    private static int PORT2;
    protected static Cache cache;
    private static final String REGION_NAME = "DestroyEntryPropagationDUnitTest_region";
    private static final String WAIT_PROPERTY = "DestroyEntryPropagationDUnitTest.maxWaitTime";
    private static final int WAIT_DEFAULT = 120000;

    public DestroyEntryPropagationDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        DestroyEntryPropagationDUnitTest.disconnectAllFromDS();
        Host host = Host.getHost(0);
        this.vm0 = host.getVM(0);
        this.vm1 = host.getVM(1);
        this.vm2 = host.getVM(2);
        this.vm3 = host.getVM(3);
        PORT1 = (Integer)this.vm0.invoke(DestroyEntryPropagationDUnitTest.class, "createServerCache");
        PORT2 = (Integer)this.vm1.invoke(DestroyEntryPropagationDUnitTest.class, "createServerCache");
        this.vm2.invoke(DestroyEntryPropagationDUnitTest.class, "createClientCache", new Object[]{DestroyEntryPropagationDUnitTest.getServerHostName(Host.getHost(0)), new Integer(PORT1), new Integer(PORT2)});
        this.vm3.invoke(DestroyEntryPropagationDUnitTest.class, "createClientCache", new Object[]{DestroyEntryPropagationDUnitTest.getServerHostName(Host.getHost(0)), new Integer(PORT1), new Integer(PORT2)});
    }

    private void createCache(Properties props) throws Exception {
        InternalDistributedSystem ds = this.getSystem(props);
        cache = CacheFactory.create((DistributedSystem)ds);
        DestroyEntryPropagationDUnitTest.assertNotNull((Object)cache);
    }

    public void testDestroyPropagation() {
        this.vm2.invoke(DestroyEntryPropagationDUnitTest.class, "createEntriesK1andK2");
        this.vm3.invoke(DestroyEntryPropagationDUnitTest.class, "createEntriesK1andK2");
        this.vm2.invoke(DestroyEntryPropagationDUnitTest.class, "registerKey1");
        this.vm3.invoke(DestroyEntryPropagationDUnitTest.class, "registerKey1");
        this.vm2.invoke(DestroyEntryPropagationDUnitTest.class, "destroyEntriesK1andK2");
        this.vm0.invoke(DestroyEntryPropagationDUnitTest.class, "verifyEntriesAreDestroyed");
        this.vm1.invoke(DestroyEntryPropagationDUnitTest.class, "verifyEntriesAreDestroyed");
        this.vm2.invoke(DestroyEntryPropagationDUnitTest.class, "verifyEntriesAreDestroyed");
        this.vm3.invoke(DestroyEntryPropagationDUnitTest.class, "verifyOnlyRegisteredEntriesAreDestroyed");
    }

    public void testDestroyOnServerPropagation() {
        this.vm2.invoke(DestroyEntryPropagationDUnitTest.class, "createEntriesK1andK2");
        this.vm3.invoke(DestroyEntryPropagationDUnitTest.class, "createEntriesK1andK2");
        this.vm2.invoke(DestroyEntryPropagationDUnitTest.class, "registerKey1");
        this.vm3.invoke(DestroyEntryPropagationDUnitTest.class, "registerKey1");
        this.vm0.invoke(DestroyEntryPropagationDUnitTest.class, "destroyEntriesK1andK2");
        this.vm0.invoke(DestroyEntryPropagationDUnitTest.class, "verifyEntriesAreDestroyed");
        this.vm1.invoke(DestroyEntryPropagationDUnitTest.class, "verifyEntriesAreDestroyed");
        this.vm2.invoke(DestroyEntryPropagationDUnitTest.class, "verifyOnlyRegisteredEntriesAreDestroyed");
        this.vm3.invoke(DestroyEntryPropagationDUnitTest.class, "verifyOnlyRegisteredEntriesAreDestroyed");
    }

    public void testVerifyDestroyNotReceivedBySender() {
        final int maxWaitTime = Integer.getInteger(WAIT_PROPERTY, 120000);
        this.vm2.invoke(DestroyEntryPropagationDUnitTest.class, "createEntriesK1andK2");
        this.vm3.invoke(DestroyEntryPropagationDUnitTest.class, "createEntriesK1andK2");
        this.vm2.invoke(DestroyEntryPropagationDUnitTest.class, "registerKey1");
        this.vm3.invoke(DestroyEntryPropagationDUnitTest.class, "registerKey1");
        this.vm0.invoke(DestroyEntryPropagationDUnitTest.class, "killServer", new Object[]{new Integer(PORT1)});
        this.vm2.invoke(new CacheSerializableRunnable("Wait for server on port1 to be dead"){

            @Override
            public void run2() throws CacheException {
                Region r = cache.getRegion(DestroyEntryPropagationDUnitTest.REGION_NAME);
                try {
                    r.put((Object)"ping", (Object)"pong1");
                }
                catch (CacheWriterException cacheWriterException) {
                    // empty catch block
                }
                try {
                    r.put((Object)"ping", (Object)"pong1");
                }
                catch (CacheWriterException cacheWriterException) {
                    // empty catch block
                }
                String poolName = r.getAttributes().getPoolName();
                TestCase.assertNotNull((Object)poolName);
                final PoolImpl pool = (PoolImpl)PoolManager.find((String)poolName);
                TestCase.assertNotNull((Object)pool);
                DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        return pool.getConnectedServerCount() != 2;
                    }

                    @Override
                    public String description() {
                        return null;
                    }
                };
                DistributedTestCase.waitForCriterion(ev, maxWaitTime, 200L, true);
            }
        });
        this.vm0.invoke(DestroyEntryPropagationDUnitTest.class, "startServer", new Object[]{new Integer(PORT1)});
        this.vm2.invoke(new CacheSerializableRunnable("Wait for server on port1 to spring to life"){

            @Override
            public void run2() throws CacheException {
                Region r = cache.getRegion(DestroyEntryPropagationDUnitTest.REGION_NAME);
                String poolName = r.getAttributes().getPoolName();
                TestCase.assertNotNull((Object)poolName);
                final PoolImpl pool = (PoolImpl)PoolManager.find((String)poolName);
                TestCase.assertNotNull((Object)pool);
                DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        return pool.getConnectedServerCount() == 2;
                    }

                    @Override
                    public String description() {
                        return null;
                    }
                };
                DistributedTestCase.waitForCriterion(ev, maxWaitTime, 200L, true);
            }
        });
        this.vm2.invoke(DestroyEntryPropagationDUnitTest.class, "acquireConnectionsAndDestroyEntriesK1andK2");
        this.vm0.invoke(DestroyEntryPropagationDUnitTest.class, "verifyEntriesAreDestroyed");
        this.vm1.invoke(DestroyEntryPropagationDUnitTest.class, "verifyEntriesAreDestroyed");
        this.vm2.invoke(DestroyEntryPropagationDUnitTest.class, "verifyNoDestroyEntryInSender");
    }

    public static void acquireConnectionsAndDestroyEntriesK1andK2() {
        try {
            Region r1 = cache.getRegion("/DestroyEntryPropagationDUnitTest_region");
            DestroyEntryPropagationDUnitTest.assertNotNull((Object)r1);
            String poolName = r1.getAttributes().getPoolName();
            DestroyEntryPropagationDUnitTest.assertNotNull((Object)poolName);
            PoolImpl pool = (PoolImpl)PoolManager.find((String)poolName);
            DestroyEntryPropagationDUnitTest.assertNotNull((Object)pool);
            Connection conn = pool.acquireConnection();
            Connection conn1 = conn.getServer().getPort() != PORT2 ? pool.acquireConnection() : conn;
            DestroyEntryPropagationDUnitTest.assertNotNull((Object)conn1);
            DestroyEntryPropagationDUnitTest.assertEquals((int)PORT2, (int)conn1.getServer().getPort());
            ServerRegionProxy srp = new ServerRegionProxy("/DestroyEntryPropagationDUnitTest_region", pool);
            srp.destroyOnForTestsOnly(conn1, (Object)"key1", null, Operation.DESTROY, new EntryEventImpl(new EventID(new byte[]{1}, 100000L, 1L)), null);
            srp.destroyOnForTestsOnly(conn1, (Object)"key2", null, Operation.DESTROY, new EntryEventImpl(new EventID(new byte[]{1}, 100000L, 2L)), null);
        }
        catch (Exception ex) {
            throw new TestException("Failed while setting acquireConnectionsAndDestroyEntry  ", ex);
        }
    }

    public static void killServer(Integer port) {
        try {
            Iterator iter = cache.getBridgeServers().iterator();
            DestroyEntryPropagationDUnitTest.getLogWriter().fine("Asif: servers running = " + cache.getBridgeServers().size());
            if (iter.hasNext()) {
                BridgeServer server = (BridgeServer)iter.next();
                DestroyEntryPropagationDUnitTest.getLogWriter().fine("asif : server running on port=" + server.getPort() + " asked to kill serevre onport=" + port);
                if (port.intValue() == server.getPort()) {
                    server.stop();
                }
            }
        }
        catch (Exception ex) {
            DestroyEntryPropagationDUnitTest.fail((String)("while killing Server  " + ex));
        }
    }

    public static void startServer(Integer port) {
        try {
            BridgeServer server1 = cache.addBridgeServer();
            server1.setPort(port.intValue());
            server1.setNotifyBySubscription(true);
            server1.start();
        }
        catch (Exception ex) {
            DestroyEntryPropagationDUnitTest.fail((String)("while killServer  " + ex));
        }
    }

    public static void createEntriesK1andK2() {
        try {
            Region r1 = cache.getRegion("/DestroyEntryPropagationDUnitTest_region");
            DestroyEntryPropagationDUnitTest.assertNotNull((Object)r1);
            if (!r1.containsKey((Object)"key1")) {
                r1.create((Object)"key1", (Object)"key-1");
            }
            if (!r1.containsKey((Object)"key2")) {
                r1.create((Object)"key2", (Object)"key-2");
            }
            DestroyEntryPropagationDUnitTest.assertEquals((Object)r1.getEntry((Object)"key1").getValue(), (Object)"key-1");
            DestroyEntryPropagationDUnitTest.assertEquals((Object)r1.getEntry((Object)"key2").getValue(), (Object)"key-2");
        }
        catch (Exception ex) {
            DestroyEntryPropagationDUnitTest.fail("failed while createEntries()", ex);
        }
    }

    public static void destroyEntriesK1andK2() {
        try {
            Region r = cache.getRegion("/DestroyEntryPropagationDUnitTest_region");
            DestroyEntryPropagationDUnitTest.assertNotNull((Object)r);
            r.destroy((Object)"key1");
            r.destroy((Object)"key2");
        }
        catch (Exception ex) {
            DestroyEntryPropagationDUnitTest.fail("failed while destroyEntry()", ex);
        }
    }

    public static void verifyNoDestroyEntryInSender() {
        try {
            Region r = cache.getRegion("/DestroyEntryPropagationDUnitTest_region");
            DestroyEntryPropagationDUnitTest.assertNotNull((Object)r);
            DestroyEntryPropagationDUnitTest.assertNotNull((Object)r.getEntry((Object)"key1"));
            DestroyEntryPropagationDUnitTest.assertNotNull((Object)r.getEntry((Object)"key2"));
        }
        catch (Exception ex) {
            DestroyEntryPropagationDUnitTest.fail("failed while verifyDestroyEntry in C1", ex);
        }
    }

    public static void verifyEntriesAreDestroyed() {
        try {
            Region r = cache.getRegion("/DestroyEntryPropagationDUnitTest_region");
            DestroyEntryPropagationDUnitTest.assertNotNull((Object)r);
            DestroyEntryPropagationDUnitTest.waitForDestroyEvent(r, "key1");
            DestroyEntryPropagationDUnitTest.assertNull((Object)r.getEntry((Object)"key1"));
            DestroyEntryPropagationDUnitTest.assertNull((Object)r.getEntry((Object)"key2"));
        }
        catch (Exception ex) {
            DestroyEntryPropagationDUnitTest.fail("failed while verifyDestroyEntry in C1", ex);
        }
    }

    public static void verifyOnlyRegisteredEntriesAreDestroyed() {
        try {
            Region r = cache.getRegion("/DestroyEntryPropagationDUnitTest_region");
            DestroyEntryPropagationDUnitTest.assertNotNull((Object)r);
            DestroyEntryPropagationDUnitTest.waitForDestroyEvent(r, "key1");
            DestroyEntryPropagationDUnitTest.assertNull((Object)r.getEntry((Object)"key1"));
            DestroyEntryPropagationDUnitTest.assertNotNull((Object)r.getEntry((Object)"key2"));
        }
        catch (Exception ex) {
            DestroyEntryPropagationDUnitTest.fail("failed while verifyDestroyEntry for key1", ex);
        }
    }

    public static void waitForDestroyEvent(Region r, final Object key) {
        final CertifiableTestCacheListener ccl = (CertifiableTestCacheListener)r.getAttributes().getCacheListener();
        DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return ccl.destroys.contains(key);
            }

            @Override
            public String description() {
                return "waiting for destroy event for " + key;
            }
        };
        DistributedTestCase.waitForCriterion(ev, 10000L, 200L, true);
        ccl.destroys.remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createClientCache(String host, Integer port1, Integer port2) throws Exception {
        Pool p;
        PORT1 = port1;
        PORT2 = port2;
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        new DestroyEntryPropagationDUnitTest("temp").createCache(props);
        CacheServerTestUtil.disableShufflingOfEndpoints();
        try {
            p = PoolManager.createFactory().addServer(host, PORT1).addServer(host, PORT2).setSubscriptionEnabled(true).setSubscriptionRedundancy(-1).setReadTimeout(2000).setSocketBufferSize(1000).setMinConnections(4).create("EntryPropagationDUnitTestPool");
        }
        finally {
            CacheServerTestUtil.enableShufflingOfEndpoints();
        }
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setPoolName(p.getName());
        factory.setCacheListener((CacheListener)new CertifiableTestCacheListener(DestroyEntryPropagationDUnitTest.getLogWriter()));
        RegionAttributes attrs = factory.create();
        cache.createRegion(REGION_NAME, attrs);
    }

    public static Integer createServerCache() throws Exception {
        new DestroyEntryPropagationDUnitTest("temp").createCache(new Properties());
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setDataPolicy(DataPolicy.REPLICATE);
        factory.setCacheListener((CacheListener)new CertifiableTestCacheListener(DestroyEntryPropagationDUnitTest.getLogWriter()));
        RegionAttributes attrs = factory.create();
        cache.createRegion(REGION_NAME, attrs);
        BridgeServer server = cache.addBridgeServer();
        int port = AvailablePort.getRandomAvailablePort((int)0);
        server.setPort(port);
        server.setNotifyBySubscription(true);
        server.start();
        return new Integer(server.getPort());
    }

    public static void registerKey1() {
        try {
            Region r = cache.getRegion("/DestroyEntryPropagationDUnitTest_region");
            DestroyEntryPropagationDUnitTest.assertNotNull((Object)r);
            ArrayList<String> list = new ArrayList<String>();
            list.add("key1");
            r.registerInterest(list);
        }
        catch (Exception ex) {
            DestroyEntryPropagationDUnitTest.fail("failed while registering interest", ex);
        }
    }

    public static void closeCache() {
        if (cache != null && !cache.isClosed()) {
            cache.close();
            cache.getDistributedSystem().disconnect();
        }
    }

    @Override
    public void tearDown2() throws Exception {
        this.vm2.invoke(DestroyEntryPropagationDUnitTest.class, "closeCache");
        this.vm3.invoke(DestroyEntryPropagationDUnitTest.class, "closeCache");
        this.vm0.invoke(DestroyEntryPropagationDUnitTest.class, "closeCache");
        this.vm1.invoke(DestroyEntryPropagationDUnitTest.class, "closeCache");
    }

    static {
        cache = null;
    }
}

