/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Declarable;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.ClientCache;
import com.gemstone.gemfire.cache.client.ClientCacheFactory;
import com.gemstone.gemfire.cache.client.ClientRegionShortcut;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.client.internal.ConnectionImpl;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.query.CqEvent;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.cache.util.BridgeServer;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.cache.util.CqListenerAdapter;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.PoolFactoryImpl;
import dunit.DistributedTestCase;
import java.io.File;
import java.net.InetSocketAddress;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import junit.framework.TestCase;

public class CacheServerTestUtil
extends DistributedTestCase {
    private static Cache cache = null;
    private static PoolImpl pool = null;
    protected static final int TYPE_CREATE = 0;
    protected static final int TYPE_UPDATE = 1;
    protected static final int TYPE_INVALIDATE = 2;
    protected static final int TYPE_DESTROY = 3;

    public CacheServerTestUtil(String name) {
        super(name);
    }

    public static void createCacheClient(Pool poolAttr, String regionName) throws Exception {
        CacheServerTestUtil.createCacheClient(poolAttr, regionName, CacheServerTestUtil.getClientProperties(), Boolean.FALSE);
    }

    public static void createCacheClient(Pool poolAttr, String regionName, Properties dsProperties) throws Exception {
        CacheServerTestUtil.createCacheClient(poolAttr, regionName, dsProperties, Boolean.FALSE);
    }

    public static void createClientCache(Pool poolAttr, String regionName) throws Exception {
        CacheServerTestUtil.createClientCache(poolAttr, regionName, CacheServerTestUtil.getClientProperties());
    }

    public static void createClientCache(Pool poolAttr, String regionName, Properties dsProperties) throws Exception {
        ClientCacheFactory ccf = new ClientCacheFactory(dsProperties);
        if (poolAttr != null) {
            ccf.setPoolFreeConnectionTimeout(poolAttr.getFreeConnectionTimeout()).setPoolLoadConditioningInterval(poolAttr.getLoadConditioningInterval()).setPoolSocketBufferSize(poolAttr.getSocketBufferSize()).setPoolMinConnections(poolAttr.getMinConnections()).setPoolMaxConnections(poolAttr.getMaxConnections()).setPoolIdleTimeout(poolAttr.getIdleTimeout()).setPoolPingInterval(poolAttr.getPingInterval()).setPoolStatisticInterval(poolAttr.getStatisticInterval()).setPoolRetryAttempts(poolAttr.getRetryAttempts()).setPoolThreadLocalConnections(poolAttr.getThreadLocalConnections()).setPoolReadTimeout(poolAttr.getReadTimeout()).setPoolSubscriptionEnabled(poolAttr.getSubscriptionEnabled()).setPoolPRSingleHopEnabled(poolAttr.getPRSingleHopEnabled()).setPoolSubscriptionRedundancy(poolAttr.getSubscriptionRedundancy()).setPoolSubscriptionMessageTrackingTimeout(poolAttr.getSubscriptionMessageTrackingTimeout()).setPoolSubscriptionAckInterval(poolAttr.getSubscriptionAckInterval()).setPoolServerGroup(poolAttr.getServerGroup()).setPoolMultiuserAuthentication(poolAttr.getMultiuserAuthentication());
            for (InetSocketAddress locator : poolAttr.getLocators()) {
                ccf.addPoolLocator(locator.getHostName(), locator.getPort());
            }
            for (InetSocketAddress server : poolAttr.getServers()) {
                ccf.addPoolServer(server.getHostName(), server.getPort());
            }
        }
        new CacheServerTestUtil("temp").createClientCache(dsProperties, ccf);
        ClientCache cc = (ClientCache)cache;
        cc.createClientRegionFactory(ClientRegionShortcut.CACHING_PROXY).create(regionName);
        pool = (PoolImpl)((GemFireCacheImpl)cc).getDefaultPool();
    }

    public static void createPool(PoolFactoryImpl.PoolAttributes poolAttr) throws Exception {
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        InternalDistributedSystem ds = new CacheServerTestUtil("tmp").getSystem(props);
        PoolFactoryImpl pf = (PoolFactoryImpl)PoolManager.createFactory();
        pf.init((Pool)poolAttr);
        PoolImpl p = (PoolImpl)pf.create("CacheServerTestUtil");
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        factory.setPoolName(p.getName());
        RegionAttributes attrs = factory.create();
        pool = p;
    }

    public static void createCacheClient(Pool poolAttr, String regionName, Properties dsProperties, Boolean addControlListener) throws Exception {
        new CacheServerTestUtil("temp").createCache(dsProperties);
        PoolFactoryImpl pf = (PoolFactoryImpl)PoolManager.createFactory();
        pf.init(poolAttr);
        PoolImpl p = (PoolImpl)pf.create("CacheServerTestUtil");
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        factory.setPoolName(p.getName());
        if (addControlListener.booleanValue()) {
            factory.addCacheListener((CacheListener)new ControlListener());
        }
        RegionAttributes attrs = factory.create();
        cache.createRegion(regionName, attrs);
        pool = p;
    }

    public static void createCacheClient(Pool poolAttr, String regionName1, String regionName2) throws Exception {
        new CacheServerTestUtil("temp").createCache(CacheServerTestUtil.getClientProperties());
        PoolFactoryImpl pf = (PoolFactoryImpl)PoolManager.createFactory();
        pf.init(poolAttr);
        PoolImpl p = (PoolImpl)pf.create("CacheServerTestUtil");
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        factory.setPoolName(p.getName());
        RegionAttributes attrs = factory.create();
        cache.createRegion(regionName1, attrs);
        cache.createRegion(regionName2, attrs);
        pool = p;
    }

    public static void createCacheClientFromXmlN(URL url, String poolName, String durableClientId, int timeout, Boolean addControlListener) {
        ClientCacheFactory ccf = new ClientCacheFactory();
        try {
            File cacheXmlFile = new File(url.toURI().getPath());
            ccf.set("cache-xml-file", cacheXmlFile.toURI().getPath());
        }
        catch (URISyntaxException e) {
            throw new ExceptionInInitializerError(e);
        }
        ccf.set("mcast-port", "0");
        ccf.set("durable-client-id", durableClientId);
        ccf.set("durable-client-timeout", String.valueOf(timeout));
        ccf.set("log-file", "abs_client_system.log");
        ccf.set("log-level", CacheServerTestUtil.getDUnitLogLevel());
        cache = (Cache)ccf.create();
        pool = (PoolImpl)PoolManager.find((String)poolName);
    }

    public static void createCacheClientFromXml(URL url, String poolName, String durableClientId, int timeout, Boolean addControlListener) {
        ClientCacheFactory ccf = new ClientCacheFactory();
        try {
            File cacheXmlFile = new File(url.toURI().getPath());
            ccf.set("cache-xml-file", cacheXmlFile.toURI().getPath());
        }
        catch (URISyntaxException e) {
            throw new ExceptionInInitializerError(e);
        }
        ccf.set("mcast-port", "0");
        ccf.set("durable-client-id", durableClientId);
        ccf.set("durable-client-timeout", String.valueOf(timeout));
        cache = (Cache)ccf.create();
        pool = (PoolImpl)PoolManager.find((String)poolName);
    }

    public static Integer createCacheServerFromXmlN(URL url) {
        CacheFactory ccf = new CacheFactory();
        try {
            File cacheXmlFile = new File(url.toURI().getPath());
            ccf.set("cache-xml-file", cacheXmlFile.toURI().getPath());
            ccf.set("mcast-port", "0");
            ccf.set("locators", "localhost[" + DistributedTestCase.getDUnitLocatorPort() + "]");
            ccf.set("log-file", "abs_server_system.log");
            ccf.set("log-level", CacheServerTestUtil.getDUnitLogLevel());
        }
        catch (URISyntaxException e) {
            throw new ExceptionInInitializerError(e);
        }
        cache = ccf.create();
        return new Integer(((CacheServer)cache.getCacheServers().get(0)).getPort());
    }

    public static Integer createCacheServerFromXml(URL url) {
        CacheFactory ccf = new CacheFactory();
        try {
            File cacheXmlFile = new File(url.toURI().getPath());
            ccf.set("cache-xml-file", cacheXmlFile.toURI().getPath());
            ccf.set("mcast-port", "0");
            ccf.set("locators", "localhost[" + DistributedTestCase.getDUnitLocatorPort() + "]");
        }
        catch (URISyntaxException e) {
            throw new ExceptionInInitializerError(e);
        }
        cache = ccf.create();
        return new Integer(((CacheServer)cache.getCacheServers().get(0)).getPort());
    }

    public static void createCacheClients(Pool poolAttr, String regionName1, String regionName2, Properties dsProperties) throws Exception {
        new CacheServerTestUtil("temp").createCache(dsProperties);
        PoolFactoryImpl pf = (PoolFactoryImpl)PoolManager.createFactory();
        pf.init(poolAttr);
        Pool p = pf.create("CacheServerTestUtil1");
        AttributesFactory factory1 = new AttributesFactory();
        factory1.setScope(Scope.LOCAL);
        factory1.setPoolName(p.getName());
        cache.createRegion(regionName1, factory1.create());
        p = pf.create("CacheServerTestUtil2");
        AttributesFactory factory2 = new AttributesFactory();
        factory2.setScope(Scope.LOCAL);
        factory2.setPoolName(p.getName());
        cache.createRegion(regionName2, factory2.create());
    }

    private static Properties getClientProperties() {
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        return props;
    }

    private static Properties getClientProperties(boolean durable) {
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        return props;
    }

    public static Integer createCacheServer(String regionName, Boolean notifyBySubscription) throws Exception {
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + DistributedTestCase.getDUnitLocatorPort() + "]");
        new CacheServerTestUtil("temp").createCache(props);
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setEnableBridgeConflation(true);
        factory.setDataPolicy(DataPolicy.REPLICATE);
        RegionAttributes attrs = factory.create();
        cache.createRegion(regionName, attrs);
        BridgeServer server1 = cache.addBridgeServer();
        int port = AvailablePort.getRandomAvailablePort((int)0);
        server1.setPort(port);
        server1.setNotifyBySubscription(notifyBySubscription.booleanValue());
        server1.start();
        return new Integer(server1.getPort());
    }

    public static Integer[] createCacheServerReturnPorts(String regionName, Boolean notifyBySubscription) throws Exception {
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + DistributedTestCase.getDUnitLocatorPort() + "]");
        new CacheServerTestUtil("temp").createCache(props);
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setEnableBridgeConflation(true);
        factory.setDataPolicy(DataPolicy.REPLICATE);
        RegionAttributes attrs = factory.create();
        cache.createRegion(regionName, attrs);
        BridgeServer server1 = cache.addBridgeServer();
        int port = AvailablePort.getRandomAvailablePort((int)0);
        server1.setPort(port);
        server1.setNotifyBySubscription(notifyBySubscription.booleanValue());
        server1.start();
        return new Integer[]{port, 0};
    }

    public static Integer createCacheServer(String regionName, Boolean notifyBySubscription, Integer mcastPort) throws Exception {
        Integer serverPort = new Integer(AvailablePort.getRandomAvailablePort((int)0));
        CacheServerTestUtil.createCacheServer(regionName, notifyBySubscription, mcastPort, serverPort);
        return serverPort;
    }

    public static void createCacheServer(String regionName, Boolean notifyBySubscription, Integer mcastPort, Integer serverPort) throws Exception {
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "localhost[" + DistributedTestCase.getDUnitLocatorPort() + "]");
        new CacheServerTestUtil("temp").createCache(props);
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setEnableBridgeConflation(true);
        factory.setDataPolicy(DataPolicy.REPLICATE);
        RegionAttributes attrs = factory.create();
        cache.createRegion(regionName, attrs);
        BridgeServer server = cache.addBridgeServer();
        server.setPort(serverPort.intValue());
        server.setNotifyBySubscription(notifyBySubscription.booleanValue());
        server.start();
    }

    public static Integer createCacheServer(String regionName1, String regionName2, Boolean notifyBySubscription) throws Exception {
        new CacheServerTestUtil("temp").createCache(new Properties());
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setEnableBridgeConflation(true);
        factory.setDataPolicy(DataPolicy.REPLICATE);
        RegionAttributes attrs = factory.create();
        if (!regionName1.equals("")) {
            cache.createRegion(regionName1, attrs);
        }
        if (!regionName2.equals("")) {
            cache.createRegion(regionName2, attrs);
        }
        BridgeServer server1 = cache.addBridgeServer();
        int port = AvailablePort.getRandomAvailablePort((int)0);
        server1.setPort(port);
        server1.setNotifyBySubscription(notifyBySubscription.booleanValue());
        server1.start();
        return new Integer(server1.getPort());
    }

    private void createCache(Properties props) throws Exception {
        InternalDistributedSystem ds = this.getSystem(props);
        CacheServerTestUtil.assertNotNull((Object)ds);
        ds.disconnect();
        ds = this.getSystem(props);
        cache = CacheFactory.create((DistributedSystem)ds);
        CacheServerTestUtil.assertNotNull((Object)cache);
    }

    private void createClientCache(Properties props, ClientCacheFactory ccf) throws Exception {
        InternalDistributedSystem ds = this.getSystem(props);
        CacheServerTestUtil.assertNotNull((Object)ds);
        ds.disconnect();
        ClientCache cc = ccf.create();
        this.setSystem(props, cc.getDistributedSystem());
        cache = (Cache)cc;
        CacheServerTestUtil.assertNotNull((Object)cache);
    }

    public static void closeCache() {
        if (cache != null && !cache.isClosed()) {
            cache.close();
            cache.getDistributedSystem().disconnect();
        }
    }

    public static void closeCache(boolean keepalive) {
        if (cache != null && !cache.isClosed()) {
            cache.close(keepalive);
            cache.getDistributedSystem().disconnect();
        }
    }

    public static void clearCacheReference() {
        cache = null;
    }

    public static void setClientCrash(boolean crashOnClose) {
        ConnectionImpl.setTEST_DURABLE_CLIENT_CRASH((boolean)crashOnClose);
    }

    public static void disconnectClient() {
        pool.endpointsNetDownForDUnitTest();
    }

    public static void reconnectClient() {
        if (pool != null) {
            pool.endpointsNetUpForDUnitTest();
        }
    }

    public static void stopCacheServers() {
        Iterator iter = CacheServerTestUtil.getCache().getBridgeServers().iterator();
        if (iter.hasNext()) {
            BridgeServer server = (BridgeServer)iter.next();
            server.stop();
            CacheServerTestUtil.assertFalse((boolean)server.isRunning());
        }
    }

    public static void restartCacheServers() {
        Iterator iter = CacheServerTestUtil.getCache().getBridgeServers().iterator();
        if (iter.hasNext()) {
            BridgeServer server = (BridgeServer)iter.next();
            try {
                server.start();
            }
            catch (Exception e) {
                CacheServerTestUtil.fail("Unexpected exception", e);
            }
            CacheServerTestUtil.assertTrue((boolean)server.isRunning());
        }
    }

    public static Cache getCache() {
        return cache;
    }

    public static PoolImpl getPool() {
        return pool;
    }

    public static void disableShufflingOfEndpoints() {
        System.setProperty("gemfire.PoolImpl.DISABLE_RANDOM", "true");
        System.setProperty("gemfire.bridge.disableShufflingOfEndpoints", "true");
    }

    public static void enableShufflingOfEndpoints() {
        System.setProperty("gemfire.PoolImpl.DISABLE_RANDOM", "false");
        System.setProperty("gemfire.bridge.disableShufflingOfEndpoints", "false");
    }

    public static void resetDisableShufflingOfEndpointsFlag() {
        System.setProperty("gemfire.bridge.disableShufflingOfEndpoints", "false");
    }

    public static class ControlCqListener
    extends CqListenerAdapter {
        public final LinkedList events = new LinkedList();
        public final Object CONTROL_LOCK = new Object();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean waitWhileNotEnoughEvents(long sleepMs, int eventCount) {
            long maxMillis = System.currentTimeMillis() + sleepMs;
            Object object = this.CONTROL_LOCK;
            synchronized (object) {
                try {
                    long waitMillis;
                    while (this.events.size() < eventCount && (waitMillis = maxMillis - System.currentTimeMillis()) >= 10L) {
                        this.CONTROL_LOCK.wait(waitMillis);
                    }
                }
                catch (InterruptedException abort) {
                    TestCase.fail((String)"interrupted");
                }
                return !this.events.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onEvent(CqEvent aCqEvent) {
            Object object = this.CONTROL_LOCK;
            synchronized (object) {
                this.events.add(aCqEvent);
                this.CONTROL_LOCK.notifyAll();
            }
        }
    }

    public static class ControlListener
    extends CacheListenerAdapter
    implements Declarable {
        public final LinkedList events = new LinkedList();
        public final Object CONTROL_LOCK = new Object();

        public void init(Properties props) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean waitWhileNotEnoughEvents(long sleepMs, int eventCount) {
            long maxMillis = System.currentTimeMillis() + sleepMs;
            Object object = this.CONTROL_LOCK;
            synchronized (object) {
                try {
                    long waitMillis;
                    while (this.events.size() < eventCount && (waitMillis = maxMillis - System.currentTimeMillis()) >= 10L) {
                        this.CONTROL_LOCK.wait(waitMillis);
                    }
                }
                catch (InterruptedException abort) {
                    TestCase.fail((String)"interrupted");
                }
                return !this.events.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterCreate(EntryEvent e) {
            Object object = this.CONTROL_LOCK;
            synchronized (object) {
                this.events.add(new EventWrapper(e, 0));
                this.CONTROL_LOCK.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterUpdate(EntryEvent e) {
            Object object = this.CONTROL_LOCK;
            synchronized (object) {
                this.events.add(new EventWrapper(e, 1));
                this.CONTROL_LOCK.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterInvalidate(EntryEvent e) {
            Object object = this.CONTROL_LOCK;
            synchronized (object) {
                this.events.add(new EventWrapper(e, 2));
                this.CONTROL_LOCK.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterDestroy(EntryEvent e) {
            Object object = this.CONTROL_LOCK;
            synchronized (object) {
                this.events.add(new EventWrapper(e, 3));
                this.CONTROL_LOCK.notifyAll();
            }
        }
    }

    public static class EventWrapper {
        public final EntryEvent event;
        public final Object key;
        public final Object val;
        public final Object arg;
        public final int type;

        public EventWrapper(EntryEvent ee, int type) {
            this.event = ee;
            this.key = ee.getKey();
            this.val = ee.getNewValue();
            this.arg = ee.getCallbackArgument();
            this.type = type;
        }

        public String toString() {
            return "EventWrapper: event=" + this.event + ", type=" + this.type;
        }
    }
}

