/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.util.BridgeServer;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.BridgeObserver;
import com.gemstone.gemfire.internal.cache.BridgeObserverAdapter;
import com.gemstone.gemfire.internal.cache.BridgeObserverHolder;
import com.gemstone.gemfire.internal.cache.tier.ConnectionProxy;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientProxy;
import com.gemstone.gemfire.internal.cache.tier.sockets.CommandInitializer;
import com.gemstone.gemfire.internal.cache.tier.sockets.HandShake;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;
import com.gemstone.gemfire.internal.shared.Version;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class BackwardCompatibilityMessageDUnitTest
extends DistributedTestCase {
    private static Cache cache = null;
    private static VM server1 = null;
    private static VM client1 = null;
    private static VM client2 = null;
    private static VM client3 = null;
    private static final String REGION_NAME = "BackwardCompatibilityMessageDUnitTest_Region";
    static int CLIENT_ACK_INTERVAL = 5000;
    private static final String k1 = "k1";
    private static final String k2 = "k2";
    private static final String client_k1 = "client-k1";
    private static final String client_k2 = "client-k2";
    private static BridgeObserver origObserver;

    public BackwardCompatibilityMessageDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Host host = Host.getHost(0);
        server1 = host.getVM(0);
        client1 = host.getVM(1);
        client2 = host.getVM(2);
        client3 = host.getVM(3);
    }

    private void createCache(Properties props) throws Exception {
        InternalDistributedSystem ds = this.getSystem(props);
        ds.disconnect();
        ds = this.getSystem(props);
        BackwardCompatibilityMessageDUnitTest.assertNotNull((Object)ds);
        cache = CacheFactory.create((DistributedSystem)ds);
        BackwardCompatibilityMessageDUnitTest.assertNotNull((Object)cache);
    }

    public static void createClientCache(String host, Integer port1) throws Exception {
        new BackwardCompatibilityMessageDUnitTest("temp");
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        new BackwardCompatibilityMessageDUnitTest("temp").createCache(props);
        PoolImpl p = (PoolImpl)PoolManager.createFactory().addServer(host, port1.intValue()).setSubscriptionEnabled(true).setSubscriptionRedundancy(1).setThreadLocalConnections(true).setMinConnections(6).setReadTimeout(20000).setPingInterval(10000L).setRetryAttempts(1).setSubscriptionAckInterval(CLIENT_ACK_INTERVAL).create("BackwardCompatibilityMessageDUnitTest");
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setPoolName(p.getName());
        RegionAttributes attrs = factory.create();
        Region region = cache.createRegion(REGION_NAME, attrs);
        region.registerInterest((Object)"ALL_KEYS");
    }

    public static Integer createServerCache(String host) throws Exception {
        new BackwardCompatibilityMessageDUnitTest("temp").createCache(new Properties());
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setDataPolicy(DataPolicy.REPLICATE);
        RegionAttributes attrs = factory.create();
        cache.createRegion(REGION_NAME, attrs);
        int port = AvailablePort.getRandomAvailablePort((int)0);
        BridgeServer server1 = cache.addBridgeServer();
        server1.setBindAddress(host);
        server1.setPort(port);
        server1.setNotifyBySubscription(true);
        server1.start();
        return new Integer(server1.getPort());
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        client2.invoke(BackwardCompatibilityMessageDUnitTest.class, "unsetHandshakeVersionForTesting");
        client3.invoke(BackwardCompatibilityMessageDUnitTest.class, "unsetHandshakeVersionForTesting");
        server1.invoke(BackwardCompatibilityMessageDUnitTest.class, "unsetBridgeObserverForAfterMessageCreation");
        client1.invoke(BackwardCompatibilityMessageDUnitTest.class, "closeCache");
        client2.invoke(BackwardCompatibilityMessageDUnitTest.class, "closeCache");
        client3.invoke(BackwardCompatibilityMessageDUnitTest.class, "closeCache");
        server1.invoke(BackwardCompatibilityMessageDUnitTest.class, "closeCache");
    }

    public static void closeCache() {
        CacheClientProxy.AFTER_MESSAGE_CREATION_FLAG = false;
        if (cache != null && !cache.isClosed()) {
            cache.close();
            cache.getDistributedSystem().disconnect();
        }
    }

    public void testMessage() throws Exception {
        String serverHostName = BackwardCompatibilityMessageDUnitTest.getServerHostName(server1.getHost());
        server1.invoke(BackwardCompatibilityMessageDUnitTest.class, "setTestCommands");
        Integer port1 = (Integer)server1.invoke(BackwardCompatibilityMessageDUnitTest.class, "createServerCache", new Object[]{serverHostName});
        client1.invoke(BackwardCompatibilityMessageDUnitTest.class, "createClientCache", new Object[]{serverHostName, port1});
        client2.invoke(BackwardCompatibilityMessageDUnitTest.class, "setHandshakeVersionForTesting");
        client2.invoke(BackwardCompatibilityMessageDUnitTest.class, "createClientCache", new Object[]{serverHostName, port1});
        client3.invoke(BackwardCompatibilityMessageDUnitTest.class, "setHandshakeVersionForTesting");
        client3.invoke(BackwardCompatibilityMessageDUnitTest.class, "createClientCache", new Object[]{serverHostName, port1});
        server1.invoke(BackwardCompatibilityMessageDUnitTest.class, "setBridgeObserverForAfterMessageCreation");
        client2.invoke(BackwardCompatibilityMessageDUnitTest.class, "put");
        Thread.sleep(10000L);
        client1.invoke(BackwardCompatibilityMessageDUnitTest.class, "checkCache");
        client3.invoke(BackwardCompatibilityMessageDUnitTest.class, "checkCache");
    }

    public static void setTestCommands() throws Exception {
        BackwardCompatibilityMessageDUnitTest.getLogWriter().info("setTestCommands invoked");
        HashMap testCommands = new HashMap();
        testCommands.putAll((Map)CommandInitializer.ALL_COMMANDS.get(Version.GFE_57));
        CommandInitializer.testSetCommands(testCommands);
        BackwardCompatibilityMessageDUnitTest.getLogWriter().info("end of setTestCommands");
    }

    public static void setHandshakeVersionForTesting() throws Exception {
        HandShake.setVersionForTesting((short)Version.TEST_VERSION.ordinal());
    }

    public static void setBridgeObserverForAfterMessageCreation() throws Exception {
        CacheClientProxy.AFTER_MESSAGE_CREATION_FLAG = true;
        origObserver = BridgeObserverHolder.setInstance((BridgeObserver)new BridgeObserverAdapter(){

            public void afterMessageCreation(Message msg) {
                DistributedTestCase.getLogWriter().info("afterMessageCreation invoked");
                Assert.assertTrue((msg != null ? 1 : 0) != 0, (Object)"Valid Message not created for current client");
                DistributedTestCase.getLogWriter().info("end of afterMessageCreation");
            }
        });
    }

    public static void put() {
        try {
            Region r1 = cache.getRegion("/BackwardCompatibilityMessageDUnitTest_Region");
            BackwardCompatibilityMessageDUnitTest.assertNotNull((Object)r1);
            r1.put((Object)k1, (Object)client_k1);
            BackwardCompatibilityMessageDUnitTest.assertEquals((Object)r1.getEntry((Object)k1).getValue(), (Object)client_k1);
            r1.put((Object)k2, (Object)client_k2);
            BackwardCompatibilityMessageDUnitTest.assertEquals((Object)r1.getEntry((Object)k2).getValue(), (Object)client_k2);
        }
        catch (Exception ex) {
            BackwardCompatibilityMessageDUnitTest.fail("failed while put", ex);
        }
    }

    public static void checkCache() {
        try {
            final Region r1 = cache.getRegion("/BackwardCompatibilityMessageDUnitTest_Region");
            BackwardCompatibilityMessageDUnitTest.assertNotNull((Object)r1);
            DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

                @Override
                public boolean done() {
                    Region.Entry e = r1.getEntry((Object)BackwardCompatibilityMessageDUnitTest.k1);
                    return e != null;
                }

                @Override
                public String description() {
                    return null;
                }
            };
            DistributedTestCase.waitForCriterion(ev, 120000L, 200L, true);
            Region.Entry e = r1.getEntry((Object)k1);
            BackwardCompatibilityMessageDUnitTest.assertEquals((Object)e.getValue(), (Object)client_k1);
            ev = new DistributedTestCase.WaitCriterion(){

                @Override
                public boolean done() {
                    Region.Entry e2 = r1.getEntry((Object)BackwardCompatibilityMessageDUnitTest.k2);
                    return e2 != null;
                }

                @Override
                public String description() {
                    return null;
                }
            };
            DistributedTestCase.waitForCriterion(ev, 120000L, 200L, true);
            e = r1.getEntry((Object)k2);
            BackwardCompatibilityMessageDUnitTest.assertEquals((Object)e.getValue(), (Object)client_k2);
        }
        catch (Exception ex) {
            BackwardCompatibilityMessageDUnitTest.fail("failed while checkCache", ex);
        }
    }

    public static void unsetHandshakeVersionForTesting() throws Exception {
        HandShake.setVersionForTesting((short)ConnectionProxy.VERSION.ordinal());
    }

    public static void unsetBridgeObserverForAfterMessageCreation() throws Exception {
        CacheClientProxy.AFTER_MESSAGE_CREATION_FLAG = false;
    }
}

