/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.util.BridgeServer;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.tier.ConnectionProxy;
import com.gemstone.gemfire.internal.cache.tier.sockets.AcceptorImpl;
import com.gemstone.gemfire.internal.cache.tier.sockets.CommandInitializer;
import com.gemstone.gemfire.internal.cache.tier.sockets.HandShake;
import com.gemstone.gemfire.internal.cache.tier.sockets.TestPut;
import com.gemstone.gemfire.internal.shared.Version;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class BackwardCompatibilityCommandDUnitTest
extends DistributedTestCase {
    private static Cache cache = null;
    private static VM server1 = null;
    private static VM client1 = null;
    private static VM client2 = null;
    private static final String REGION_NAME = "BackwardCompatibilityCommandDUnitTest_Region";
    static int CLIENT_ACK_INTERVAL = 5000;
    private static final String k1 = "k1";
    private static final String k2 = "k2";
    private static final String client_k1 = "client-k1";
    private static final String client_k2 = "client-k2";
    public static boolean TEST_PUT_COMMAND_INVOKED = false;

    public BackwardCompatibilityCommandDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Host host = Host.getHost(0);
        server1 = host.getVM(0);
        client1 = host.getVM(1);
        client2 = host.getVM(2);
    }

    private void createCache(Properties props) throws Exception {
        InternalDistributedSystem ds = this.getSystem(props);
        ds.disconnect();
        ds = this.getSystem(props);
        BackwardCompatibilityCommandDUnitTest.assertNotNull((Object)ds);
        cache = CacheFactory.create((DistributedSystem)ds);
        BackwardCompatibilityCommandDUnitTest.assertNotNull((Object)cache);
    }

    public static void createClientCache(String host, Integer port1) throws Exception {
        new BackwardCompatibilityCommandDUnitTest("temp");
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        new BackwardCompatibilityCommandDUnitTest("temp").createCache(props);
        PoolImpl p = (PoolImpl)PoolManager.createFactory().addServer(host, port1.intValue()).setSubscriptionEnabled(false).setThreadLocalConnections(true).setMinConnections(1).setReadTimeout(20000).setPingInterval(10000L).setRetryAttempts(1).create("BackwardCompatibilityCommandDUnitTest");
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setPoolName(p.getName());
        RegionAttributes attrs = factory.create();
        Region region = cache.createRegion(REGION_NAME, attrs);
    }

    public static Integer createServerCache(String hostName) throws Exception {
        new BackwardCompatibilityCommandDUnitTest("temp").createCache(new Properties());
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setDataPolicy(DataPolicy.REPLICATE);
        RegionAttributes attrs = factory.create();
        cache.createRegion(REGION_NAME, attrs);
        int port = AvailablePort.getRandomAvailablePort((int)0);
        BridgeServer server1 = cache.addBridgeServer();
        server1.setBindAddress(hostName);
        server1.setPort(port);
        server1.setNotifyBySubscription(true);
        server1.start();
        return new Integer(server1.getPort());
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        client2.invoke(BackwardCompatibilityCommandDUnitTest.class, "unsetHandshakeVersionForTesting");
        client1.invoke(BackwardCompatibilityCommandDUnitTest.class, "closeCache");
        client2.invoke(BackwardCompatibilityCommandDUnitTest.class, "closeCache");
        server1.invoke(BackwardCompatibilityCommandDUnitTest.class, "closeCache");
    }

    public static void closeCache() {
        if (cache != null && !cache.isClosed()) {
            cache.close();
            cache.getDistributedSystem().disconnect();
        }
    }

    public void testCommand() {
        server1.invoke(BackwardCompatibilityCommandDUnitTest.class, "setTestCommands");
        String serverHostName = BackwardCompatibilityCommandDUnitTest.getServerHostName(server1.getHost());
        Integer port1 = (Integer)server1.invoke(BackwardCompatibilityCommandDUnitTest.class, "createServerCache", new Object[]{serverHostName});
        client1.invoke(BackwardCompatibilityCommandDUnitTest.class, "createClientCache", new Object[]{serverHostName, port1});
        client2.invoke(BackwardCompatibilityCommandDUnitTest.class, "setHandshakeVersionForTesting");
        client2.invoke(BackwardCompatibilityCommandDUnitTest.class, "createClientCache", new Object[]{serverHostName, port1});
        client1.invoke(BackwardCompatibilityCommandDUnitTest.class, "put");
        server1.invoke(BackwardCompatibilityCommandDUnitTest.class, "checkTestPutCommandNotInvoked");
        client2.invoke(BackwardCompatibilityCommandDUnitTest.class, "put");
        server1.invoke(BackwardCompatibilityCommandDUnitTest.class, "checkTestPutCommandInvoked");
    }

    public static void setTestCommands() throws Exception {
        BackwardCompatibilityCommandDUnitTest.getLogWriter().info("setTestCommands invoked");
        HashMap<Integer, TestPut> testCommands = new HashMap<Integer, TestPut>();
        testCommands.putAll((Map)CommandInitializer.ALL_COMMANDS.get(AcceptorImpl.VERSION));
        testCommands.put(new Integer(7), new TestPut());
        CommandInitializer.testSetCommands(testCommands);
        BackwardCompatibilityCommandDUnitTest.getLogWriter().info("end of setTestCommands");
    }

    public static void setHandshakeVersionForTesting() throws Exception {
        HandShake.setVersionForTesting((short)Version.TEST_VERSION.ordinal());
    }

    public static void put() {
        try {
            Region r1 = cache.getRegion("/BackwardCompatibilityCommandDUnitTest_Region");
            BackwardCompatibilityCommandDUnitTest.assertNotNull((Object)r1);
            r1.put((Object)k1, (Object)client_k1);
            BackwardCompatibilityCommandDUnitTest.assertEquals((Object)r1.getEntry((Object)k1).getValue(), (Object)client_k1);
            r1.put((Object)k2, (Object)client_k2);
            BackwardCompatibilityCommandDUnitTest.assertEquals((Object)r1.getEntry((Object)k2).getValue(), (Object)client_k2);
        }
        catch (Exception ex) {
            BackwardCompatibilityCommandDUnitTest.fail("failed while put", ex);
        }
    }

    public static void unsetHandshakeVersionForTesting() throws Exception {
        HandShake.setVersionForTesting((short)ConnectionProxy.VERSION.ordinal());
    }

    public static void checkTestPutCommandNotInvoked() {
        BackwardCompatibilityCommandDUnitTest.assertTrue((String)"TestPut command got invoked for GFE57 versioned client", (!TEST_PUT_COMMAND_INVOKED ? 1 : 0) != 0);
    }

    public static void checkTestPutCommandInvoked() {
        BackwardCompatibilityCommandDUnitTest.assertTrue((String)"TestPut command did not get invoked for higher versioned client", (boolean)TEST_PUT_COMMAND_INVOKED);
    }
}

