/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.rollingupgrade;

import com.gemstone.gemfire.cache.RegionShortcut;
import com.gemstone.gemfire.cache.client.ClientRegionShortcut;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import com.gemstone.gemfire.internal.FileUtil;
import com.gemstone.gemfire.internal.cache.rollingupgrade.ChildFirstClassLoader;
import com.gemstone.gemfire.internal.shared.Version;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.RMIException;
import dunit.VM;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;

public class RollingUpgradeDUnitTest
extends DistributedTestCase {
    private boolean turnOffBounce = false;
    private File[] testingDirs = new File[3];
    private static ClassLoader classLoader;
    private static String diskDir;
    protected static LocationAndOrdinal[] gemfireLocations;
    private static Object cache;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        System.out.println("RollingUpgradeDUnitTest.setUp invoked");
        String jarRootDir = "/gcm/where";
        String osDir = "/Linux";
        String os = System.getProperty("os.name");
        if (os != null) {
            if (os.indexOf("Windows") != -1) {
                jarRootDir = "J:/where";
                osDir = "/Windows_NT";
            } else if (os.indexOf("SunOS") != -1) {
                osDir = "Solaris";
            }
        }
        gemfireLocations = new LocationAndOrdinal[]{new LocationAndOrdinal(jarRootDir + "/gemfireXD/releases/GemFireXD1.0.0-all/product", Version.GFXD_10.ordinal())};
    }

    protected void basicSetUp() throws Exception {
        super.setUp();
    }

    public RollingUpgradeDUnitTest(String name) {
        super(name);
    }

    public void bounceAll(VM ... vms) {
        if (!this.turnOffBounce) {
            for (VM vm : vms) {
                vm.bounce();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOldMemberCantJoin() throws Exception {
        VM oldServer = Host.getHost(0).getVM(1);
        int length = gemfireLocations.length;
        Properties props = this.getSystemProperties();
        for (int i = 0; i < length; ++i) {
            if (RollingUpgradeDUnitTest.gemfireLocations[i].ordinal >= Version.CURRENT_ORDINAL) continue;
            oldServer.invoke(this.configureClassLoader(RollingUpgradeDUnitTest.gemfireLocations[i].gemfireLocation));
            try {
                oldServer.invoke(this.invokeCreateCache(props));
                continue;
            }
            catch (RMIException e) {
                Throwable cause = e.getCause();
                if (cause == null || !(cause instanceof AssertionFailedError)) continue;
                if ((cause = cause.getCause()) != null && !cause.getMessage().startsWith("Rejecting the attempt of a member using an older version")) {
                    throw e;
                }
                RollingUpgradeDUnitTest.getLogWriter().info("found rejection message in throwable");
                continue;
            }
            finally {
                oldServer.invoke(this.configureClassLoaderForCurrent());
            }
        }
    }

    public void testRollSingleLocatorWithMultipleServersReplicatedRegion() throws Exception {
        System.out.println("gemfireLocations[0].version=" + RollingUpgradeDUnitTest.gemfireLocations[0].ordinal);
        int length = gemfireLocations.length;
        for (int i = 0; i < length; ++i) {
            this.doTestRollSingleLocatorWithMultipleServers(false, gemfireLocations[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTestRollSingleLocatorWithMultipleServers(boolean partitioned, LocationAndOrdinal oldLocationAndOrdinal) throws Exception {
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM server2 = host.getVM(1);
        VM server3 = host.getVM(2);
        VM server4 = host.getVM(3);
        String objectType = "strings";
        String regionName = "aRegion";
        String shortcutName = RegionShortcut.REPLICATE.name();
        if (partitioned) {
            shortcutName = RegionShortcut.PARTITION_REDUNDANT.name();
        }
        String oldVersionLocation = oldLocationAndOrdinal.gemfireLocation;
        short oldOrdinal = oldLocationAndOrdinal.ordinal;
        int[] locatorPorts = AvailablePortHelper.getRandomAvailableTCPPorts(1);
        server1.invoke(this.configureClassLoader(oldVersionLocation));
        server2.invoke(this.configureClassLoader(oldVersionLocation));
        server3.invoke(this.configureClassLoader(oldVersionLocation));
        server4.invoke(this.configureClassLoader(oldVersionLocation));
        String hostName = RollingUpgradeDUnitTest.getServerHostName(host);
        String locatorString = RollingUpgradeDUnitTest.getLocatorString(locatorPorts);
        try {
            server1.invoke(this.invokeStartLocator(hostName, locatorPorts[0], testName, locatorString));
            this.invokeRunnableInVMs(this.invokeCreateCache(this.getSystemProperties(locatorPorts)), server2, server3, server4);
            this.invokeRunnableInVMs(this.invokeAssertVersion(oldOrdinal), server2, server3, server4);
            this.invokeRunnableInVMs(this.invokeCreateRegion("aRegion", shortcutName), server2, server3, server4);
            this.putAndVerify("strings", server2, "aRegion", 0, 10, server3, server4);
            this.rollLocatorToCurrent(server1, hostName, locatorPorts[0], testName, locatorString);
            this.rollServerToCurrentAndCreateRegion(server2, shortcutName, "aRegion", locatorPorts);
            this.putAndVerify("strings", server2, "aRegion", 5, 15, server3, server4);
            this.putAndVerify("strings", server3, "aRegion", 10, 20, server2, server4);
            this.rollServerToCurrentAndCreateRegion(server3, shortcutName, "aRegion", locatorPorts);
            this.putAndVerify("strings", server2, "aRegion", 15, 25, server3, server4);
            this.putAndVerify("strings", server3, "aRegion", 20, 30, server2, server4);
            this.rollServerToCurrentAndCreateRegion(server4, shortcutName, "aRegion", locatorPorts);
            this.putAndVerify("strings", server4, "aRegion", 25, 35, server3, server2);
            this.putAndVerify("strings", server3, "aRegion", 30, 40, server2, server4);
        }
        catch (Throwable throwable) {
            this.invokeRunnableInVMs(true, this.invokeStopLocator(), server1);
            this.invokeRunnableInVMs(true, this.invokeCloseCache(), server2, server3, server4);
            this.invokeRunnableInVMs(true, this.resetClassLoader(), server1, server2, server3, server4);
            this.bounceAll(server1, server2, server3, server4);
            throw throwable;
        }
        this.invokeRunnableInVMs(true, this.invokeStopLocator(), server1);
        this.invokeRunnableInVMs(true, this.invokeCloseCache(), server2, server3, server4);
        this.invokeRunnableInVMs(true, this.resetClassLoader(), server1, server2, server3, server4);
        this.bounceAll(server1, server2, server3, server4);
    }

    public void testRollTwoLocatorsWithTwoServers() throws Exception {
        int length = gemfireLocations.length;
        for (int i = 0; i < length; ++i) {
            this.doTestRollTwoLocatorsWithTwoServers(false, gemfireLocations[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTestRollTwoLocatorsWithTwoServers(boolean partitioned, LocationAndOrdinal oldLocationAndOrdinal) throws Exception {
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM server2 = host.getVM(1);
        VM server3 = host.getVM(2);
        VM server4 = host.getVM(3);
        String objectType = "strings";
        String regionName = "aRegion";
        String shortcutName = RegionShortcut.REPLICATE.name();
        if (partitioned) {
            shortcutName = RegionShortcut.PARTITION_REDUNDANT.name();
        }
        String oldVersionLocation = oldLocationAndOrdinal.gemfireLocation;
        short oldOrdinal = oldLocationAndOrdinal.ordinal;
        int[] locatorPorts = AvailablePortHelper.getRandomAvailableTCPPorts(2);
        server1.invoke(this.configureClassLoader(oldVersionLocation));
        server2.invoke(this.configureClassLoader(oldVersionLocation));
        server3.invoke(this.configureClassLoader(oldVersionLocation));
        server4.invoke(this.configureClassLoader(oldVersionLocation));
        String hostName = RollingUpgradeDUnitTest.getServerHostName(host);
        String locatorString = RollingUpgradeDUnitTest.getLocatorString(locatorPorts);
        try {
            server1.invoke(this.invokeStartLocator(hostName, locatorPorts[0], testName, locatorString));
            server2.invoke(this.invokeStartLocator(hostName, locatorPorts[1], testName, locatorString));
            this.invokeRunnableInVMs(this.invokeCreateCache(this.getSystemProperties(locatorPorts)), server3, server4);
            this.invokeRunnableInVMs(this.invokeAssertVersion(oldOrdinal), server3, server4);
            this.invokeRunnableInVMs(this.invokeCreateRegion("aRegion", shortcutName), server3, server4);
            this.putAndVerify("strings", server3, "aRegion", 0, 10, server3, server4);
            this.rollLocatorToCurrent(server1, hostName, locatorPorts[0], testName, locatorString);
            this.rollLocatorToCurrent(server2, hostName, locatorPorts[1], testName, locatorString);
            this.rollServerToCurrentAndCreateRegion(server3, shortcutName, "aRegion", locatorPorts);
            this.putAndVerify("strings", server4, "aRegion", 15, 25, server3, server4);
            this.putAndVerify("strings", server3, "aRegion", 20, 30, server3, server4);
            this.rollServerToCurrentAndCreateRegion(server4, shortcutName, "aRegion", locatorPorts);
            this.putAndVerify("strings", server4, "aRegion", 25, 35, server3, server4);
            this.putAndVerify("strings", server3, "aRegion", 30, 40, server3, server4);
        }
        catch (Throwable throwable) {
            this.invokeRunnableInVMs(true, this.invokeStopLocator(), server1, server2);
            this.invokeRunnableInVMs(true, this.invokeCloseCache(), server3, server4);
            this.invokeRunnableInVMs(true, this.resetClassLoader(), server1, server2, server3, server4);
            this.bounceAll(server1, server2, server3, server4);
            throw throwable;
        }
        this.invokeRunnableInVMs(true, this.invokeStopLocator(), server1, server2);
        this.invokeRunnableInVMs(true, this.invokeCloseCache(), server3, server4);
        this.invokeRunnableInVMs(true, this.resetClassLoader(), server1, server2, server3, server4);
        this.bounceAll(server1, server2, server3, server4);
    }

    public void testClients() throws Exception {
        int length = gemfireLocations.length;
        for (int i = 0; i < length; ++i) {
            this.doTestClients(false, gemfireLocations[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTestClients(boolean partitioned, LocationAndOrdinal oldLocationAndOrdinal) throws Exception {
        Host host = Host.getHost(0);
        VM locator = host.getVM(0);
        VM server2 = host.getVM(1);
        VM server3 = host.getVM(2);
        VM client = host.getVM(3);
        String objectType = "strings";
        String regionName = "aRegion";
        String shortcutName = RegionShortcut.REPLICATE.name();
        if (partitioned) {
            shortcutName = RegionShortcut.PARTITION_REDUNDANT.name();
        }
        String oldVersionLocation = oldLocationAndOrdinal.gemfireLocation;
        short oldOrdinal = oldLocationAndOrdinal.ordinal;
        int[] ports = AvailablePortHelper.getRandomAvailableTCPPorts(3);
        int[] locatorPorts = new int[]{ports[0]};
        int[] csPorts = new int[]{ports[1], ports[2]};
        locator.invoke(this.configureClassLoader(oldVersionLocation));
        server2.invoke(this.configureClassLoader(oldVersionLocation));
        server3.invoke(this.configureClassLoader(oldVersionLocation));
        client.invoke(this.configureClassLoader(oldVersionLocation));
        String hostName = RollingUpgradeDUnitTest.getServerHostName(host);
        String[] hostNames = new String[]{hostName};
        String locatorString = RollingUpgradeDUnitTest.getLocatorString(locatorPorts);
        try {
            locator.invoke(this.invokeStartLocator(hostName, locatorPorts[0], testName, locatorString));
            this.invokeRunnableInVMs(this.invokeCreateCache(this.getSystemProperties(locatorPorts)), server2, server3);
            this.invokeRunnableInVMs(this.invokeStartCacheServer(csPorts[0]), server2);
            this.invokeRunnableInVMs(this.invokeStartCacheServer(csPorts[1]), server3);
            this.invokeRunnableInVMs(this.invokeCreateClientCache(this.getClientSystemProperties(), hostNames, locatorPorts), client);
            this.invokeRunnableInVMs(this.invokeAssertVersion(oldOrdinal), server2, server3, client);
            this.invokeRunnableInVMs(this.invokeCreateRegion("aRegion", shortcutName), server2, server3);
            this.invokeRunnableInVMs(this.invokeCreateClientRegion("aRegion", ClientRegionShortcut.PROXY.name()), client);
            this.putAndVerify("strings", client, "aRegion", 0, 10, server3, client);
            this.putAndVerify("strings", server3, "aRegion", 100, 110, server3, client);
            this.rollLocatorToCurrent(locator, hostName, locatorPorts[0], testName, locatorString);
            this.rollServerToCurrentAndCreateRegion(server3, shortcutName, "aRegion", locatorPorts);
            this.invokeRunnableInVMs(this.invokeStartCacheServer(csPorts[1]), server3);
            this.putAndVerify("strings", client, "aRegion", 15, 25, server3, client);
            this.putAndVerify("strings", server3, "aRegion", 20, 30, server3, client);
            this.rollServerToCurrentAndCreateRegion(server2, shortcutName, "aRegion", locatorPorts);
            this.invokeRunnableInVMs(this.invokeStartCacheServer(csPorts[0]), server2);
            this.putAndVerify("strings", client, "aRegion", 25, 35, server2, client);
            this.putAndVerify("strings", server2, "aRegion", 30, 40, server3, client);
            this.rollClientToCurrentAndCreateRegion(client, ClientRegionShortcut.PROXY.name(), "aRegion", hostNames, locatorPorts);
            this.putAndVerify("strings", client, "aRegion", 35, 45, server2, server3);
            this.putAndVerify("strings", server2, "aRegion", 40, 50, server3, client);
        }
        catch (Throwable throwable) {
            this.invokeRunnableInVMs(true, this.invokeStopLocator(), locator);
            this.invokeRunnableInVMs(true, this.invokeCloseCache(), server2, server3, client);
            this.invokeRunnableInVMs(true, this.resetClassLoader(), locator, server2, server3, client);
            this.bounceAll(locator, server2, server3, client);
            throw throwable;
        }
        this.invokeRunnableInVMs(true, this.invokeStopLocator(), locator);
        this.invokeRunnableInVMs(true, this.invokeCloseCache(), server2, server3, client);
        this.invokeRunnableInVMs(true, this.resetClassLoader(), locator, server2, server3, client);
        this.bounceAll(locator, server2, server3, client);
    }

    public void testRollLocatorsWithOldServer() throws Exception {
        int length = gemfireLocations.length;
        for (int i = 0; i < length; ++i) {
            this.doTestRollLocatorsWithOldServer(gemfireLocations[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTestRollLocatorsWithOldServer(LocationAndOrdinal oldLocationAndOrdinal) throws Exception {
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM server2 = host.getVM(1);
        VM server3 = host.getVM(2);
        VM server4 = host.getVM(3);
        String oldVersionLocation = oldLocationAndOrdinal.gemfireLocation;
        short oldOrdinal = oldLocationAndOrdinal.ordinal;
        int[] locatorPorts = AvailablePortHelper.getRandomAvailableTCPPorts(3);
        server1.invoke(this.configureClassLoader(oldVersionLocation));
        server2.invoke(this.configureClassLoader(oldVersionLocation));
        server3.invoke(this.configureClassLoader(oldVersionLocation));
        server4.invoke(this.configureClassLoader(oldVersionLocation));
        String hostName = RollingUpgradeDUnitTest.getServerHostName(host);
        String locatorString = RollingUpgradeDUnitTest.getLocatorString(locatorPorts);
        try {
            server1.invoke(this.invokeStartLocator(hostName, locatorPorts[0], testName, locatorString));
            server2.invoke(this.invokeStartLocator(hostName, locatorPorts[1], testName, locatorString));
            server3.invoke(this.invokeStartLocator(hostName, locatorPorts[2], testName, locatorString));
            this.invokeRunnableInVMs(this.invokeCreateCache(this.getSystemProperties(locatorPorts)), server4);
            this.invokeRunnableInVMs(this.invokeAssertVersion(oldOrdinal), server4);
            this.rollLocatorToCurrent(server1, hostName, locatorPorts[0], testName, locatorString);
            this.rollLocatorToCurrent(server2, hostName, locatorPorts[1], testName, locatorString);
            this.rollLocatorToCurrent(server3, hostName, locatorPorts[2], testName, locatorString);
        }
        catch (Throwable throwable) {
            this.invokeRunnableInVMs(true, this.invokeStopLocator(), server1, server2, server3);
            this.invokeRunnableInVMs(true, this.invokeCloseCache(), server4);
            this.invokeRunnableInVMs(true, this.resetClassLoader(), server1, server2, server3, server4);
            this.bounceAll(server1, server2, server3, server4);
            throw throwable;
        }
        this.invokeRunnableInVMs(true, this.invokeStopLocator(), server1, server2, server3);
        this.invokeRunnableInVMs(true, this.invokeCloseCache(), server4);
        this.invokeRunnableInVMs(true, this.resetClassLoader(), server1, server2, server3, server4);
        this.bounceAll(server1, server2, server3, server4);
    }

    public void testRollLocators() throws Exception {
        int length = gemfireLocations.length;
        for (int i = 0; i < length; ++i) {
            this.doTestRollLocators(gemfireLocations[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTestRollLocators(LocationAndOrdinal oldLocationAndOrdinal) throws Exception {
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM server2 = host.getVM(1);
        VM server3 = host.getVM(2);
        VM server4 = host.getVM(3);
        String oldVersionLocation = oldLocationAndOrdinal.gemfireLocation;
        int[] locatorPorts = AvailablePortHelper.getRandomAvailableTCPPorts(4);
        server1.invoke(this.configureClassLoader(oldVersionLocation));
        server2.invoke(this.configureClassLoader(oldVersionLocation));
        server3.invoke(this.configureClassLoader(oldVersionLocation));
        server4.invoke(this.configureClassLoader(oldVersionLocation));
        String hostName = RollingUpgradeDUnitTest.getServerHostName(host);
        String locatorString = RollingUpgradeDUnitTest.getLocatorString(locatorPorts);
        try {
            server1.invoke(this.invokeStartLocator(hostName, locatorPorts[0], testName, locatorString));
            server2.invoke(this.invokeStartLocator(hostName, locatorPorts[1], testName, locatorString));
            server3.invoke(this.invokeStartLocator(hostName, locatorPorts[2], testName, locatorString));
            server4.invoke(this.invokeStartLocator(hostName, locatorPorts[3], testName, locatorString));
            this.rollLocatorToCurrent(server1, hostName, locatorPorts[0], testName, locatorString);
            this.rollLocatorToCurrent(server2, hostName, locatorPorts[1], testName, locatorString);
            this.rollLocatorToCurrent(server3, hostName, locatorPorts[2], testName, locatorString);
            this.rollLocatorToCurrent(server4, hostName, locatorPorts[3], testName, locatorString);
        }
        catch (Throwable throwable) {
            this.invokeRunnableInVMs(true, this.invokeStopLocator(), server1, server2, server3, server4);
            this.invokeRunnableInVMs(true, this.resetClassLoader(), server1, server2, server3, server4);
            this.bounceAll(server1, server2, server3, server4);
            throw throwable;
        }
        this.invokeRunnableInVMs(true, this.invokeStopLocator(), server1, server2, server3, server4);
        this.invokeRunnableInVMs(true, this.resetClassLoader(), server1, server2, server3, server4);
        this.bounceAll(server1, server2, server3, server4);
    }

    public void testConcurrentPutsReplicated() throws Exception {
        int length = gemfireLocations.length;
        for (int i = 0; i < length; ++i) {
            this.doTestConcurrent(false, gemfireLocations[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTestConcurrent(boolean partitioned, LocationAndOrdinal oldLocationAndOrdinal) throws Exception {
        Host host = Host.getHost(0);
        VM locator = host.getVM(1);
        VM server1 = host.getVM(2);
        VM server2 = host.getVM(3);
        String objectType = "strings";
        String regionName = "aRegion";
        String shortcutName = RegionShortcut.REPLICATE.name();
        if (partitioned) {
            shortcutName = RegionShortcut.PARTITION_REDUNDANT.name();
        }
        String oldVersionLocation = oldLocationAndOrdinal.gemfireLocation;
        short oldOrdinal = oldLocationAndOrdinal.ordinal;
        int[] locatorPorts = AvailablePortHelper.getRandomAvailableTCPPorts(1);
        String hostName = RollingUpgradeDUnitTest.getServerHostName(host);
        String locatorString = RollingUpgradeDUnitTest.getLocatorString(locatorPorts);
        locator.invoke(this.configureClassLoader(oldVersionLocation));
        server1.invoke(this.configureClassLoader(oldVersionLocation));
        server2.invoke(this.configureClassLoader(oldVersionLocation));
        try {
            locator.invoke(this.invokeStartLocator(hostName, locatorPorts[0], testName, locatorString, this.getLocatorProperties(locatorString)));
            this.invokeRunnableInVMs(this.invokeCreateCache(this.getSystemProperties(locatorPorts)), server1, server2);
            this.invokeRunnableInVMs(this.invokeAssertVersion(oldOrdinal), server1, server2);
            this.invokeRunnableInVMs(this.invokeCreateRegion("aRegion", shortcutName), server1, server2);
            AsyncInvocation asyncPutsThroughOld = server2.invokeAsync(new CacheSerializableRunnable("async puts"){

                @Override
                public void run2() {
                    try {
                        for (int i = 0; i < 500; ++i) {
                            RollingUpgradeDUnitTest.put(cache, "aRegion", "" + i, "VALUE(" + i + ")");
                        }
                    }
                    catch (Exception e) {
                        TestCase.fail((String)"error putting");
                    }
                }
            });
            this.rollLocatorToCurrent(locator, hostName, locatorPorts[0], testName, locatorString);
            this.rollServerToCurrentAndCreateRegion(server1, shortcutName, "aRegion", locatorPorts);
            DistributedTestCase.join(asyncPutsThroughOld, 30000L, RollingUpgradeDUnitTest.getLogWriter());
            this.verifyValues("strings", "aRegion", 0, 500, server1);
            AsyncInvocation asyncPutsThroughNew = server1.invokeAsync(new CacheSerializableRunnable("async puts"){

                @Override
                public void run2() {
                    try {
                        for (int i = 250; i < 750; ++i) {
                            RollingUpgradeDUnitTest.put(cache, "aRegion", "" + i, "VALUE(" + i + ")");
                        }
                    }
                    catch (Exception e) {
                        TestCase.fail((String)"error putting");
                    }
                }
            });
            this.rollServerToCurrentAndCreateRegion(server2, shortcutName, "aRegion", locatorPorts);
            DistributedTestCase.join(asyncPutsThroughNew, 30000L, RollingUpgradeDUnitTest.getLogWriter());
            this.verifyValues("strings", "aRegion", 250, 750, server2);
        }
        catch (Throwable throwable) {
            this.invokeRunnableInVMs(true, this.invokeStopLocator(), locator);
            this.invokeRunnableInVMs(true, this.invokeCloseCache(), server1, server2);
            this.invokeRunnableInVMs(true, this.resetClassLoader(), server1, server2);
            this.bounceAll(server1, server2, locator);
            throw throwable;
        }
        this.invokeRunnableInVMs(true, this.invokeStopLocator(), locator);
        this.invokeRunnableInVMs(true, this.invokeCloseCache(), server1, server2);
        this.invokeRunnableInVMs(true, this.resetClassLoader(), server1, server2);
        this.bounceAll(server1, server2, locator);
    }

    public void testRollServersOnReplicatedRegion() throws Exception {
        int length = gemfireLocations.length;
        for (int i = 0; i < length; ++i) {
            this.doTestRollAll("replicate", "strings", gemfireLocations[i]);
            this.doTestRollAll("replicate", "serializable", gemfireLocations[i]);
            this.doTestRollAll("replicate", "dataserializable", gemfireLocations[i]);
        }
    }

    public void testRollServersOnPartitionedRegion() throws Exception {
        int length = gemfireLocations.length;
        for (int i = 0; i < length; ++i) {
            this.doTestRollAll("partitionedRedundant", "strings", gemfireLocations[i]);
            this.doTestRollAll("partitionedRedundant", "serializable", gemfireLocations[i]);
            this.doTestRollAll("partitionedRedundant", "dataserializable", gemfireLocations[i]);
        }
    }

    public void testRollServersOnPersistentRegion() throws Exception {
        int length = gemfireLocations.length;
        for (int i = 0; i < length; ++i) {
            this.doTestRollAll("persistentReplicate", "strings", gemfireLocations[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTestRollAll(String regionType, String objectType, LocationAndOrdinal oldLocationAndOrdinal) throws Exception {
        Host host = Host.getHost(0);
        VM server1 = host.getVM(0);
        VM server2 = host.getVM(1);
        VM server3 = host.getVM(2);
        VM locator = host.getVM(3);
        String regionName = "aRegion";
        String shortcutName = RegionShortcut.REPLICATE.name();
        if (regionType.equals("replicate")) {
            shortcutName = RegionShortcut.REPLICATE.name();
        } else if (regionType.equals("partitionedRedundant")) {
            shortcutName = RegionShortcut.PARTITION_REDUNDANT.name();
        } else if (regionType.equals("persistentReplicate")) {
            shortcutName = RegionShortcut.PARTITION_PERSISTENT.name();
            for (int i = 0; i < this.testingDirs.length; ++i) {
                this.testingDirs[i] = new File(diskDir, "diskStoreVM_" + String.valueOf(host.getVM(i).getPid())).getAbsoluteFile();
                if (this.testingDirs[i].exists()) continue;
                System.out.println(" Creating diskdir for server: " + i);
                this.testingDirs[i].mkdirs();
            }
        }
        String oldVersionLocation = oldLocationAndOrdinal.gemfireLocation;
        short oldOrdinal = oldLocationAndOrdinal.ordinal;
        int[] locatorPorts = AvailablePortHelper.getRandomAvailableTCPPorts(1);
        String hostName = RollingUpgradeDUnitTest.getServerHostName(host);
        String locatorString = RollingUpgradeDUnitTest.getLocatorString(locatorPorts);
        Properties locatorProps = new Properties();
        locator.invoke(this.configureClassLoader(oldVersionLocation));
        server1.invoke(this.configureClassLoader(oldVersionLocation));
        server2.invoke(this.configureClassLoader(oldVersionLocation));
        server3.invoke(this.configureClassLoader(oldVersionLocation));
        try {
            locator.invoke(this.invokeStartLocator(hostName, locatorPorts[0], testName, locatorString, locatorProps));
            this.invokeRunnableInVMs(this.invokeCreateCache(this.getSystemProperties(locatorPorts)), server1, server2, server3);
            this.invokeRunnableInVMs(this.invokeAssertVersion(oldOrdinal), server1, server2, server3);
            if (regionType.equals("persistentReplicate")) {
                for (int i = 0; i < this.testingDirs.length; ++i) {
                    CacheSerializableRunnable runnable = this.invokeCreatePersistentReplicateRegion(regionName, this.testingDirs[i]);
                    this.invokeRunnableInVMs(runnable, host.getVM(i));
                }
            } else {
                this.invokeRunnableInVMs(this.invokeCreateRegion(regionName, shortcutName), server1, server2, server3);
            }
            this.putAndVerify(objectType, server1, regionName, 0, 10, server2, server3);
            this.rollLocatorToCurrent(locator, hostName, locatorPorts[0], testName, locatorString);
            this.rollServerToCurrentAndCreateRegion(server1, regionType, this.testingDirs[0], shortcutName, regionName, locatorPorts);
            this.verifyValues(objectType, regionName, 0, 10, server1);
            this.putAndVerify(objectType, server1, regionName, 5, 15, server2, server3);
            this.putAndVerify(objectType, server2, regionName, 10, 20, server1, server3);
            this.rollServerToCurrentAndCreateRegion(server2, regionType, this.testingDirs[1], shortcutName, regionName, locatorPorts);
            this.verifyValues(objectType, regionName, 0, 10, server2);
            this.putAndVerify(objectType, server2, regionName, 15, 25, server1, server3);
            this.putAndVerify(objectType, server3, regionName, 20, 30, server2, server3);
            this.rollServerToCurrentAndCreateRegion(server3, regionType, this.testingDirs[2], shortcutName, regionName, locatorPorts);
            this.verifyValues(objectType, regionName, 0, 10, server3);
            this.putAndVerify(objectType, server3, regionName, 15, 25, server1, server2);
            this.putAndVerify(objectType, server1, regionName, 20, 30, server1, server2, server3);
        }
        catch (Throwable throwable) {
            this.invokeRunnableInVMs(true, this.invokeStopLocator(), locator);
            this.invokeRunnableInVMs(true, this.invokeCloseCache(), server1, server2, server3);
            this.invokeRunnableInVMs(true, this.resetClassLoader(), server1, server2, server3);
            this.bounceAll(server1, server2, server3, locator);
            if (regionType.equals("persistentReplicate")) {
                this.deleteDiskStores();
            }
            throw throwable;
        }
        this.invokeRunnableInVMs(true, this.invokeStopLocator(), locator);
        this.invokeRunnableInVMs(true, this.invokeCloseCache(), server1, server2, server3);
        this.invokeRunnableInVMs(true, this.resetClassLoader(), server1, server2, server3);
        this.bounceAll(server1, server2, server3, locator);
        if (regionType.equals("persistentReplicate")) {
            this.deleteDiskStores();
        }
    }

    public void testPutAndGetMixedServersReplicateRegion() throws Exception {
        int length = gemfireLocations.length;
        for (int i = 0; i < length; ++i) {
            this.doTestPutAndGetMixedServers("strings", false, gemfireLocations[i]);
            this.doTestPutAndGetMixedServers("serializable", false, gemfireLocations[i]);
            this.doTestPutAndGetMixedServers("dataserializable", false, gemfireLocations[i]);
        }
    }

    public void testPutAndGetMixedServerPartitionedRegion() throws Exception {
        int length = gemfireLocations.length;
        for (int i = 0; i < length; ++i) {
            this.doTestPutAndGetMixedServers("strings", true, gemfireLocations[i]);
            this.doTestPutAndGetMixedServers("serializable", true, gemfireLocations[i]);
            this.doTestPutAndGetMixedServers("dataserializable", true, gemfireLocations[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTestPutAndGetMixedServers(String objectType, boolean partitioned, LocationAndOrdinal oldLocationAndOrdinal) throws Exception {
        Host host = Host.getHost(0);
        VM currentServer1 = host.getVM(0);
        VM oldServer = host.getVM(1);
        VM currentServer2 = host.getVM(2);
        VM oldServer2 = host.getVM(3);
        String regionName = "aRegion";
        String oldVersionLocation = oldLocationAndOrdinal.gemfireLocation;
        short oldOrdinal = oldLocationAndOrdinal.ordinal;
        String shortcutName = RegionShortcut.REPLICATE.name();
        if (partitioned) {
            shortcutName = RegionShortcut.PARTITION.name();
        }
        currentServer1.invoke(this.configureClassLoaderForCurrent());
        currentServer2.invoke(this.configureClassLoaderForCurrent());
        oldServer.invoke(this.configureClassLoader(oldVersionLocation));
        oldServer2.invoke(this.configureClassLoader(oldVersionLocation));
        try {
            Properties props = this.getSystemProperties();
            int port = AvailablePort.getRandomAvailablePort((int)0);
            props.put("locators", host.getHostName() + "[" + port + "]");
            this.invokeRunnableInVMs(this.invokeStartLocatorAndServer(host.getHostName(), port, testName, props), oldServer);
            this.invokeRunnableInVMs(this.invokeCreateCache(props), currentServer1, currentServer2, oldServer2);
            currentServer1.invoke(this.invokeAssertVersion(Version.CURRENT_ORDINAL));
            currentServer2.invoke(this.invokeAssertVersion(Version.CURRENT_ORDINAL));
            oldServer.invoke(this.invokeAssertVersion(oldOrdinal));
            oldServer2.invoke(this.invokeAssertVersion(oldOrdinal));
            this.invokeRunnableInVMs(this.invokeCreateRegion(regionName, shortcutName), currentServer1, currentServer2, oldServer, oldServer2);
            this.putAndVerify(objectType, currentServer1, regionName, 0, 10, currentServer2, oldServer, oldServer2);
            this.putAndVerify(objectType, oldServer, regionName, 5, 15, currentServer1, currentServer2, oldServer2);
        }
        catch (Throwable throwable) {
            this.invokeRunnableInVMs(true, this.invokeCloseCache(), currentServer1, currentServer2, oldServer, oldServer2);
            this.invokeRunnableInVMs(true, this.resetClassLoader(), currentServer1, currentServer2, oldServer, oldServer2);
            this.bounceAll(currentServer1, oldServer, currentServer2, oldServer2);
            throw throwable;
        }
        this.invokeRunnableInVMs(true, this.invokeCloseCache(), currentServer1, currentServer2, oldServer, oldServer2);
        this.invokeRunnableInVMs(true, this.resetClassLoader(), currentServer1, currentServer2, oldServer, oldServer2);
        this.bounceAll(currentServer1, oldServer, currentServer2, oldServer2);
    }

    public void testQueryMixedServersOnReplicatedRegions() throws Exception {
        int length = gemfireLocations.length;
        for (int i = 0; i < length; ++i) {
            this.doTestQueryMixedServers(false, gemfireLocations[i]);
        }
    }

    public void testQueryMixedServersOnPartitionedRegions() throws Exception {
        int length = gemfireLocations.length;
        for (int i = 0; i < length; ++i) {
            this.doTestQueryMixedServers(true, gemfireLocations[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTestQueryMixedServers(boolean partitioned, LocationAndOrdinal oldLocationAndOrdinal) throws Exception {
        Host host = Host.getHost(0);
        VM currentServer1 = host.getVM(0);
        VM oldServer = host.getVM(1);
        VM currentServer2 = host.getVM(2);
        VM oldServerAndLocator = host.getVM(3);
        String regionName = "cqs";
        String oldVersionLocation = oldLocationAndOrdinal.gemfireLocation;
        short oldOrdinal = oldLocationAndOrdinal.ordinal;
        String shortcutName = RegionShortcut.REPLICATE.name();
        if (partitioned) {
            shortcutName = RegionShortcut.PARTITION.name();
        }
        currentServer1.invoke(this.configureClassLoaderForCurrent());
        currentServer2.invoke(this.configureClassLoaderForCurrent());
        oldServer.invoke(this.configureClassLoader(oldVersionLocation));
        oldServerAndLocator.invoke(this.configureClassLoader(oldVersionLocation));
        String serverHostName = RollingUpgradeDUnitTest.getServerHostName(Host.getHost(0));
        int port = AvailablePortHelper.getRandomAvailableTCPPort();
        try {
            Properties props = this.getSystemProperties();
            props.remove("locators");
            props.put("license-data-management", "Y150V-00XD3-08J8Z-04YUV-Z4PFV,4H65K-FUH9Q-H8J90-01396-CJQKG,156DH-AN0D7-M8R10-0J2F6-3TZHG");
            this.invokeRunnableInVMs(this.invokeStartLocatorAndServer(serverHostName, port, shortcutName, props), oldServerAndLocator);
            props.put("locators", serverHostName + "[" + port + "]");
            this.invokeRunnableInVMs(this.invokeCreateCache(props), currentServer1, currentServer2, oldServer);
            currentServer1.invoke(this.invokeAssertVersion(Version.CURRENT_ORDINAL));
            currentServer2.invoke(this.invokeAssertVersion(Version.CURRENT_ORDINAL));
            oldServer.invoke(this.invokeAssertVersion(oldOrdinal));
            oldServerAndLocator.invoke(this.invokeAssertVersion(oldOrdinal));
            this.invokeRunnableInVMs(this.invokeCreateRegion(regionName, shortcutName), currentServer1, currentServer2, oldServer, oldServerAndLocator);
            this.putDataSerializableAndVerify(currentServer1, regionName, 0, 100, currentServer2, oldServer, oldServerAndLocator);
            this.query("Select * from /" + regionName + " p where p.timeout > 0L", 99, currentServer1, currentServer2, oldServer, oldServerAndLocator);
        }
        catch (Throwable throwable) {
            this.invokeRunnableInVMs(this.invokeCloseCache(), currentServer1, currentServer2, oldServer, oldServerAndLocator);
            this.invokeRunnableInVMs(true, this.resetClassLoader(), currentServer1, currentServer2, oldServer, oldServerAndLocator);
            this.bounceAll(currentServer1, oldServer, currentServer2, oldServerAndLocator);
            throw throwable;
        }
        this.invokeRunnableInVMs(this.invokeCloseCache(), currentServer1, currentServer2, oldServer, oldServerAndLocator);
        this.invokeRunnableInVMs(true, this.resetClassLoader(), currentServer1, currentServer2, oldServer, oldServerAndLocator);
        this.bounceAll(currentServer1, oldServer, currentServer2, oldServerAndLocator);
    }

    public Properties getLocatorProperties(String locatorsString) {
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", locatorsString);
        props.setProperty("log-level", RollingUpgradeDUnitTest.getDUnitLogLevel());
        return props;
    }

    private void putAndVerify(String objectType, VM putter, String regionName, int start, int end, VM check1, VM check2, VM check3) throws Exception {
        if (objectType.equals("strings")) {
            this.putStringsAndVerify(putter, regionName, start, end, check1, check2, check3);
        } else if (objectType.equals("serializable")) {
            this.putSerializableAndVerify(putter, regionName, start, end, check1, check2, check3);
        } else if (objectType.equals("dataserializable")) {
            this.putDataSerializableAndVerify(putter, regionName, start, end, check1, check2, check3);
        } else {
            throw new Error("Not a valid test object type");
        }
    }

    private void putAndVerify(String objectType, VM putter, String regionName, int start, int end, VM check1, VM check2) throws Exception {
        if (objectType.equals("strings")) {
            this.putStringsAndVerify(putter, regionName, start, end, check1, check2);
        } else if (objectType.equals("serializable")) {
            this.putSerializableAndVerify(putter, regionName, start, end, check1, check2);
        } else if (objectType.equals("dataserializable")) {
            this.putDataSerializableAndVerify(putter, regionName, start, end, check1, check2);
        } else {
            throw new Error("Not a valid test object type");
        }
    }

    private void putStringsAndVerify(VM putter, String regionName, int start, int end, VM ... vms) {
        for (int i = start; i < end; ++i) {
            putter.invoke(this.invokePut(regionName, "" + i, "VALUE(" + i + ")"));
        }
        for (VM vm : vms) {
            vm.invoke(this.invokeAssertEntriesEqual(regionName, start, end));
        }
    }

    private void putSerializableAndVerify(VM putter, String regionName, int start, int end, VM ... vms) {
        for (int i = start; i < end; ++i) {
            putter.invoke(this.invokePut(regionName, "" + i, new Properties()));
        }
        for (VM vm : vms) {
            vm.invoke(this.invokeAssertEntriesExist(regionName, start, end));
        }
    }

    private void putDataSerializableAndVerify(VM putter, String regionName, int start, int end, VM ... vms) throws Exception {
        for (int i = start; i < end; ++i) {
            Class<?> aClass = Thread.currentThread().getContextClassLoader().loadClass("com.gemstone.gemfire.cache.ExpirationAttributes");
            Constructor<?> constructor = aClass.getConstructor(Integer.TYPE);
            Object testDataSerializable = constructor.newInstance(i);
            putter.invoke(this.invokePut(regionName, "" + i, testDataSerializable));
        }
        for (VM vm : vms) {
            vm.invoke(this.invokeAssertEntriesExist(regionName, start, end));
        }
    }

    private void verifyValues(String objectType, String regionName, int start, int end, VM ... vms) {
        block4: {
            block5: {
                block3: {
                    if (!objectType.equals("strings")) break block3;
                    for (VM vm : vms) {
                        vm.invoke(this.invokeAssertEntriesEqual(regionName, start, end));
                    }
                    break block4;
                }
                if (!objectType.equals("serializable")) break block5;
                for (VM vm : vms) {
                    vm.invoke(this.invokeAssertEntriesExist(regionName, start, end));
                }
                break block4;
            }
            if (!objectType.equals("dataserializable")) break block4;
            for (VM vm : vms) {
                vm.invoke(this.invokeAssertEntriesExist(regionName, start, end));
            }
        }
    }

    private void query(String queryString, int numExpectedResults, VM ... vms) {
        for (VM vm : vms) {
            vm.invoke(this.invokeAssertQueryResults(queryString, numExpectedResults));
        }
    }

    private void invokeRunnableInVMs(CacheSerializableRunnable runnable, VM ... vms) throws Exception {
        for (VM vm : vms) {
            vm.invoke(runnable);
        }
    }

    private void invokeRunnableInVMs(boolean catchErrors, CacheSerializableRunnable runnable, VM ... vms) throws Exception {
        for (VM vm : vms) {
            try {
                vm.invoke(runnable);
            }
            catch (Exception e) {
                if (catchErrors) continue;
                throw e;
            }
        }
    }

    private void rollServerToCurrent(VM rollServer, int[] locatorPorts) throws Exception {
        rollServer.invoke(this.invokeCloseCache());
        if (!this.turnOffBounce) {
            rollServer.bounce();
        }
        rollServer.invoke(this.setClassLoaderToCurrentVersionClassLoader());
        rollServer.invoke(this.invokeCreateCache(locatorPorts == null ? this.getSystemProperties() : this.getSystemProperties(locatorPorts)));
        rollServer.invoke(this.invokeAssertVersion(Version.CURRENT_ORDINAL));
    }

    private void rollClientToCurrent(VM rollClient, String[] hostNames, int[] locatorPorts) throws Exception {
        rollClient.invoke(this.invokeCloseCache());
        if (!this.turnOffBounce) {
            rollClient.bounce();
        }
        rollClient.invoke(this.setClassLoaderToCurrentVersionClassLoader());
        rollClient.invoke(this.invokeCreateClientCache(this.getClientSystemProperties(), hostNames, locatorPorts));
        rollClient.invoke(this.invokeAssertVersion(Version.CURRENT_ORDINAL));
    }

    private void rollServerToCurrentAndCreateRegion(VM rollServer, String shortcutName, String regionName, int[] locatorPorts) throws Exception {
        this.rollServerToCurrent(rollServer, locatorPorts);
        this.invokeRunnableInVMs(this.invokeCreateRegion(regionName, shortcutName), rollServer);
        rollServer.invoke(this.invokeRebalance());
    }

    private void rollServerToCurrentAndCreateRegion(VM rollServer, String regionType, File diskdir, String shortcutName, String regionName, int[] locatorPorts) throws Exception {
        this.rollServerToCurrent(rollServer, locatorPorts);
        if (regionType.equals("persistentReplicate")) {
            CacheSerializableRunnable runnable = this.invokeCreatePersistentReplicateRegion(regionName, diskdir);
            this.invokeRunnableInVMs(runnable, rollServer);
        } else {
            this.invokeRunnableInVMs(this.invokeCreateRegion(regionName, shortcutName), rollServer);
        }
        rollServer.invoke(this.invokeRebalance());
    }

    private void rollClientToCurrentAndCreateRegion(VM rollClient, String shortcutName, String regionName, String[] hostNames, int[] locatorPorts) throws Exception {
        this.rollClientToCurrent(rollClient, hostNames, locatorPorts);
        this.invokeRunnableInVMs(this.invokeCreateClientRegion(regionName, shortcutName), rollClient);
    }

    private void rollLocatorToCurrent(VM rollLocator, String serverHostName, int port, String testName, String locatorString) throws Exception {
        rollLocator.invoke(this.invokeStopLocator());
        if (!this.turnOffBounce) {
            rollLocator.bounce();
        }
        rollLocator.invoke(this.setClassLoaderToCurrentVersionClassLoader());
        rollLocator.invoke(this.invokeStartLocator(serverHostName, port, testName, locatorString));
    }

    private CacheSerializableRunnable resetClassLoader() {
        return new CacheSerializableRunnable("reset class loader"){

            @Override
            public void run2() {
                classLoader = null;
                System.gc();
                System.gc();
            }
        };
    }

    public Properties getSystemProperties() {
        return super.getAllDistributedSystemProperties(new Properties());
    }

    public Properties getSystemProperties(int[] locatorPorts) {
        Properties p = new Properties();
        String locatorString = RollingUpgradeDUnitTest.getLocatorString(locatorPorts);
        p.setProperty("locators", locatorString);
        p.setProperty("mcast-port", "0");
        p.setProperty("log-level", "fine");
        return p;
    }

    public Properties getClientSystemProperties() {
        Properties p = new Properties();
        p.setProperty("mcast-port", "0");
        p.setProperty("log-level", "fine");
        return p;
    }

    public static String getLocatorString(int locatorPort) {
        return "localhost[" + locatorPort + "]";
    }

    public static String getLocatorString(int[] locatorPorts) {
        String locatorString = "";
        int numLocators = locatorPorts.length;
        for (int i = 0; i < numLocators; ++i) {
            locatorString = locatorString + RollingUpgradeDUnitTest.getLocatorString(locatorPorts[i]);
            if (i + 1 >= numLocators) continue;
            locatorString = locatorString + ",";
        }
        System.out.println("Locator string is:" + locatorString);
        return locatorString;
    }

    private CacheSerializableRunnable setClassLoaderToCurrentVersionClassLoader() {
        return new CacheSerializableRunnable("setClassLoaderToCurrentVersionClassLoader"){

            @Override
            public void run2() {
                classLoader = null;
                classLoader = Thread.currentThread().getContextClassLoader();
                System.gc();
                System.gc();
            }
        };
    }

    private CacheSerializableRunnable configureClassLoaderForCurrent() {
        return new CacheSerializableRunnable("configure class loader for current"){

            @Override
            public void run2() {
                classLoader = Thread.currentThread().getContextClassLoader();
            }
        };
    }

    private CacheSerializableRunnable configureClassLoader(final String gemfireLocation) {
        return new CacheSerializableRunnable("configure class loader"){

            @Override
            public void run2() {
                try {
                    List urlList = RollingUpgradeDUnitTest.this.addFile(new File(gemfireLocation));
                    URL[] urls = new URL[urlList.size()];
                    int i = 0;
                    for (URL url : urlList) {
                        urls[i++] = url;
                    }
                    ChildFirstClassLoader loader = new ChildFirstClassLoader(urls, null);
                    classLoader = loader;
                }
                catch (MalformedURLException e) {
                    TestCase.fail((String)("Failed in initializing class loader:" + e));
                }
            }
        };
    }

    private List<URL> addFile(File file) throws MalformedURLException {
        ArrayList<URL> urls = new ArrayList<URL>();
        if (file.isDirectory()) {
            File[] files;
            if (file.getName().contains("SampleCode")) {
                return urls;
            }
            for (File afile : files = file.listFiles()) {
                urls.addAll(this.addFile(afile));
            }
        } else {
            URL url = file.toURI().toURL();
            urls.add(url);
        }
        return urls;
    }

    private CacheSerializableRunnable invokeStartLocator(final String serverHostName, final int port, final String testName, final String locatorsString, final Properties props) {
        return new CacheSerializableRunnable("execute: startLocator"){

            @Override
            public void run2() {
                ClassLoader ogLoader = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(classLoader);
                    RollingUpgradeDUnitTest.startLocator(serverHostName, port, testName, locatorsString, props);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    TestCase.fail((String)"Error starting locators");
                }
                finally {
                    Thread.currentThread().setContextClassLoader(ogLoader);
                }
            }
        };
    }

    private CacheSerializableRunnable invokeStartLocator(final String serverHostName, final int port, final String testName, final String locatorsString) {
        return new CacheSerializableRunnable("execute: startLocator"){

            @Override
            public void run2() {
                ClassLoader ogLoader = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(classLoader);
                    RollingUpgradeDUnitTest.startLocator(serverHostName, port, testName, locatorsString);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DistributedTestCase.fail("Error starting locators", e);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(ogLoader);
                }
            }
        };
    }

    public static void startLocator(String serverHostName, int port, String testName, String locatorsString, Properties props) throws Exception {
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", locatorsString);
        props.setProperty("log-level", RollingUpgradeDUnitTest.getDUnitLogLevel());
        InetAddress bindAddr = null;
        try {
            bindAddr = InetAddress.getByName(serverHostName);
        }
        catch (UnknownHostException uhe) {
            throw new Error("While resolving bind address ", uhe);
        }
        File logFile = new File(testName + "-locator" + port + ".log");
        Class<?> locatorClass = Thread.currentThread().getContextClassLoader().loadClass("com.gemstone.gemfire.distributed.Locator");
        Method startLocatorAndDSMethod = locatorClass.getMethod("startLocatorAndDS", Integer.TYPE, File.class, InetAddress.class, Properties.class, Boolean.TYPE, Boolean.TYPE, String.class);
        startLocatorAndDSMethod.setAccessible(true);
        startLocatorAndDSMethod.invoke(null, port, logFile, bindAddr, props, true, true, null);
    }

    private CacheSerializableRunnable invokeStartLocatorAndServer(final String serverHostName, final int port, String testName, final Properties systemProperties) {
        return new CacheSerializableRunnable("execute: startLocator"){

            @Override
            public void run2() {
                ClassLoader ogLoader = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(classLoader);
                    systemProperties.put("start-locator", "" + serverHostName + "[" + port + "]");
                    cache = RollingUpgradeDUnitTest.createCache(systemProperties);
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Error starting locators", e);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(ogLoader);
                }
            }
        };
    }

    private CacheSerializableRunnable invokeCreateCache(final Properties systemProperties) {
        return new CacheSerializableRunnable("execute: createCache"){

            @Override
            public void run2() {
                ClassLoader ogLoader = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(classLoader);
                    cache = RollingUpgradeDUnitTest.createCache(systemProperties);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DistributedTestCase.fail("Error creating cache", e);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(ogLoader);
                }
            }
        };
    }

    private CacheSerializableRunnable invokeCreateClientCache(final Properties systemProperties, final String[] hosts, final int[] ports) {
        return new CacheSerializableRunnable("execute: createCache"){

            @Override
            public void run2() {
                ClassLoader ogLoader = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(classLoader);
                    cache = RollingUpgradeDUnitTest.createClientCache(systemProperties, hosts, ports);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DistributedTestCase.fail("Error creating client cache", e);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(ogLoader);
                }
            }
        };
    }

    private CacheSerializableRunnable invokeStartCacheServer(final int port) {
        return new CacheSerializableRunnable("execute: startCacheServer"){

            @Override
            public void run2() {
                ClassLoader ogLoader = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(classLoader);
                    RollingUpgradeDUnitTest.startCacheServer(cache, port);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DistributedTestCase.fail("Error creating cache", e);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(ogLoader);
                }
            }
        };
    }

    private CacheSerializableRunnable invokeAssertVersion(final short version) {
        return new CacheSerializableRunnable("execute: assertVersion"){

            @Override
            public void run2() {
                ClassLoader ogLoader = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(classLoader);
                    RollingUpgradeDUnitTest.assertVersion(cache, version);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DistributedTestCase.fail("Error asserting version", e);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(ogLoader);
                }
            }
        };
    }

    private CacheSerializableRunnable invokeCreateRegion(final String regionName, final String shortcutName) {
        return new CacheSerializableRunnable("execute: createRegion"){

            @Override
            public void run2() {
                ClassLoader ogLoader = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(classLoader);
                    RollingUpgradeDUnitTest.createRegion(cache, regionName, shortcutName);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DistributedTestCase.fail("Error createRegion", e);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(ogLoader);
                }
            }
        };
    }

    private CacheSerializableRunnable invokeCreatePersistentReplicateRegion(final String regionName, final File diskstore) {
        return new CacheSerializableRunnable("execute: createPersistentReplicateRegion"){

            @Override
            public void run2() {
                ClassLoader ogLoader = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(classLoader);
                    RollingUpgradeDUnitTest.createPersistentReplicateRegion(cache, regionName, diskstore);
                    Thread.currentThread().setContextClassLoader(ogLoader);
                }
                catch (Exception e) {
                    DistributedTestCase.fail("Error createPersistentReplicateRegion", e);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(ogLoader);
                }
            }
        };
    }

    private CacheSerializableRunnable invokeCreateClientRegion(final String regionName, final String shortcutName) {
        return new CacheSerializableRunnable("execute: createClientRegion"){

            @Override
            public void run2() {
                ClassLoader ogLoader = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(classLoader);
                    RollingUpgradeDUnitTest.createClientRegion(cache, regionName, shortcutName);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DistributedTestCase.fail("Error creating client region", e);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(ogLoader);
                }
            }
        };
    }

    private CacheSerializableRunnable invokePut(final String regionName, final Object key, final Object value) {
        return new CacheSerializableRunnable("execute: put"){

            @Override
            public void run2() {
                ClassLoader ogLoader = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(classLoader);
                    RollingUpgradeDUnitTest.put(cache, regionName, key, value);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DistributedTestCase.fail("Error put", e);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(ogLoader);
                }
            }
        };
    }

    private CacheSerializableRunnable invokeAssertEntriesEqual(final String regionName, final int start, final int end) {
        return new CacheSerializableRunnable("execute: assertEntriesEqual"){

            @Override
            public void run2() {
                ClassLoader ogLoader = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(classLoader);
                    for (int i = start; i < end; ++i) {
                        RollingUpgradeDUnitTest.assertEntryEquals(cache, regionName, "" + i, "VALUE(" + i + ")");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DistributedTestCase.fail("Error asserting equals", e);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(ogLoader);
                }
            }
        };
    }

    private CacheSerializableRunnable invokeAssertEntriesExist(final String regionName, final int start, final int end) {
        return new CacheSerializableRunnable("execute: assertEntryExists"){

            @Override
            public void run2() {
                ClassLoader ogLoader = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(classLoader);
                    for (int i = start; i < end; ++i) {
                        RollingUpgradeDUnitTest.assertEntryExists(cache, regionName, "" + i);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DistributedTestCase.fail("Error asserting exists", e);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(ogLoader);
                }
            }
        };
    }

    private CacheSerializableRunnable invokeStopLocator() {
        return new CacheSerializableRunnable("execute: stopLocator"){

            @Override
            public void run2() {
                ClassLoader ogLoader = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(classLoader);
                    RollingUpgradeDUnitTest.stopLocator();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DistributedTestCase.fail("Error stopping locator", e);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(ogLoader);
                }
            }
        };
    }

    private CacheSerializableRunnable invokeCloseCache() {
        return new CacheSerializableRunnable("execute: closeCache"){

            @Override
            public void run2() {
                ClassLoader ogLoader = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(classLoader);
                    RollingUpgradeDUnitTest.closeCache(cache);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DistributedTestCase.fail("Error closing cache", e);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(ogLoader);
                }
            }
        };
    }

    private CacheSerializableRunnable invokeRebalance() {
        return new CacheSerializableRunnable("execute: rebalance"){

            @Override
            public void run2() {
                ClassLoader ogLoader = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(classLoader);
                    RollingUpgradeDUnitTest.rebalance(cache);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DistributedTestCase.fail("Error rebalancing", e);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(ogLoader);
                }
            }
        };
    }

    private CacheSerializableRunnable invokeAssertQueryResults(final String queryString, final int numExpected) {
        return new CacheSerializableRunnable("execute: assertQueryResults"){

            @Override
            public void run2() {
                ClassLoader ogLoader = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(classLoader);
                    RollingUpgradeDUnitTest.assertQueryResults(cache, queryString, numExpected);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DistributedTestCase.fail("Error asserting query results", e);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(ogLoader);
                }
            }
        };
    }

    public void deleteDiskStores() throws Exception {
        try {
            FileUtil.delete((File)new File(diskDir).getAbsoluteFile());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Error("Error deleting files", e);
        }
    }

    public static Object createCache(Properties systemProperties) throws Exception {
        systemProperties.put("log-file", "rollingUpgradeCacheVM" + VM.getCurrentVMNum() + ".log");
        Class<?> aClass = Thread.currentThread().getContextClassLoader().loadClass("com.gemstone.gemfire.cache.CacheFactory");
        Constructor<?> constructor = aClass.getConstructor(Properties.class);
        Object cacheFactory = constructor.newInstance(systemProperties);
        Method createMethod = aClass.getMethod("create", new Class[0]);
        Object cache = createMethod.invoke(cacheFactory, new Object[0]);
        return cache;
    }

    public static void startCacheServer(Object cache, int port) throws Exception {
        Method addCacheServerMethod = cache.getClass().getMethod("addCacheServer", new Class[0]);
        Object cacheServer = addCacheServerMethod.invoke(cache, new Object[0]);
        Method setPortMethod = cacheServer.getClass().getMethod("setPort", Integer.TYPE);
        setPortMethod.invoke(cacheServer, port);
        Method startMethod = cacheServer.getClass().getMethod("start", new Class[0]);
        startMethod.invoke(cacheServer, new Object[0]);
    }

    public static Object createClientCache(Properties systemProperties, String[] hosts, int[] ports) throws Exception {
        Class<?> aClass = Thread.currentThread().getContextClassLoader().loadClass("com.gemstone.gemfire.cache.client.ClientCacheFactory");
        Constructor<?> constructor = aClass.getConstructor(Properties.class);
        Object ccf = constructor.newInstance(systemProperties);
        Method addPoolLocatorMethod = aClass.getMethod("addPoolLocator", String.class, Integer.TYPE);
        int hostsLength = hosts.length;
        for (int i = 0; i < hostsLength; ++i) {
            addPoolLocatorMethod.invoke(ccf, hosts[i], ports[i]);
        }
        Method createMethod = aClass.getMethod("create", new Class[0]);
        Object cache = createMethod.invoke(ccf, new Object[0]);
        return cache;
    }

    public static boolean assertRegionExists(Object cache, String regionName) throws Exception {
        Object region = cache.getClass().getMethod("getRegion", String.class).invoke(cache, regionName);
        if (region == null) {
            throw new Error("Region: " + regionName + " does not exist");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getRegion(Object cache, String regionName) throws Exception {
        ClassLoader ogLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(classLoader);
        try {
            Object object = cache.getClass().getMethod("getRegion", String.class).invoke(cache, regionName);
            return object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(ogLoader);
        }
    }

    public static boolean assertEntryEquals(Object cache, String regionName, Object key, Object value) throws Exception {
        RollingUpgradeDUnitTest.assertRegionExists(cache, regionName);
        Object region = RollingUpgradeDUnitTest.getRegion(cache, regionName);
        Object regionValue = region.getClass().getMethod("get", Object.class).invoke(region, key);
        if (regionValue == null) {
            RollingUpgradeDUnitTest.getLogWriter().info("region value does not exist for key: " + key);
            region.getClass().getMethod("dumpBackingMap", new Class[0]).invoke(region, new Object[0]);
            throw new Error("Region value does not exist for key: " + key);
        }
        if (!regionValue.equals(value)) {
            RollingUpgradeDUnitTest.getLogWriter().info("Entry for key: " + key + " does not equal value: " + value);
            throw new Error("Entry for key: " + key + " does not equal value: " + value + "(got=" + regionValue + ')');
        }
        return true;
    }

    public static boolean assertEntryExists(Object cache, String regionName, Object key) throws Exception {
        RollingUpgradeDUnitTest.assertRegionExists(cache, regionName);
        Object region = RollingUpgradeDUnitTest.getRegion(cache, regionName);
        Object regionValue = region.getClass().getMethod("get", Object.class).invoke(region, key);
        if (regionValue == null) {
            System.out.println("Entry for key:" + key + " does not exist");
            throw new Error("Entry for key:" + key + " does not exist");
        }
        return true;
    }

    public static Object put(Object cache, String regionName, Object key, Object value) throws Exception {
        Object region = RollingUpgradeDUnitTest.getRegion(cache, regionName);
        return region.getClass().getMethod("put", Object.class, Object.class).invoke(region, key, value);
    }

    public static void createRegion(Object cache, String regionName, String shortcutName) throws Exception {
        Class<?> aClass = Thread.currentThread().getContextClassLoader().loadClass("com.gemstone.gemfire.cache.RegionShortcut");
        ?[] enumConstants = aClass.getEnumConstants();
        Object shortcut = null;
        for (Object constant : enumConstants) {
            if (!((Enum)constant).name().equals(shortcutName)) continue;
            shortcut = constant;
            break;
        }
        Object regionFactory = cache.getClass().getMethod("createRegionFactory", aClass).invoke(cache, shortcut);
        regionFactory.getClass().getMethod("create", String.class).invoke(regionFactory, regionName);
    }

    public static void createPartitionedRegion(Object cache, String regionName) throws Exception {
        RollingUpgradeDUnitTest.createRegion(cache, regionName, RegionShortcut.PARTITION.name());
    }

    public static void createPartitionedRedundantRegion(Object cache, String regionName) throws Exception {
        RollingUpgradeDUnitTest.createRegion(cache, regionName, RegionShortcut.PARTITION_REDUNDANT.name());
    }

    public static void createReplicatedRegion(Object cache, String regionName) throws Exception {
        RollingUpgradeDUnitTest.createRegion(cache, regionName, RegionShortcut.REPLICATE.name());
    }

    public static void createClientRegion(Object cache, String regionName, String shortcutName) throws Exception {
        Class<?> aClass = Thread.currentThread().getContextClassLoader().loadClass("com.gemstone.gemfire.cache.client.ClientRegionShortcut");
        ?[] enumConstants = aClass.getEnumConstants();
        Object shortcut = null;
        for (Object constant : enumConstants) {
            if (!((Enum)constant).name().equals(shortcutName)) continue;
            shortcut = constant;
            break;
        }
        Object clientRegionFactory = cache.getClass().getMethod("createClientRegionFactory", shortcut.getClass()).invoke(cache, shortcut);
        clientRegionFactory.getClass().getMethod("create", String.class).invoke(clientRegionFactory, regionName);
    }

    public static void createRegion(String regionName, Object regionFactory) throws Exception {
        regionFactory.getClass().getMethod("create", String.class).invoke(regionFactory, regionName);
    }

    public static void createPersistentReplicateRegion(Object cache, String regionName, File diskStore) throws Exception {
        Object store = cache.getClass().getMethod("findDiskStore", String.class).invoke(cache, "store");
        Class<?> dataPolicyObject = Thread.currentThread().getContextClassLoader().loadClass("com.gemstone.gemfire.cache.DataPolicy");
        Object dataPolicy = dataPolicyObject.getField("PERSISTENT_REPLICATE").get(null);
        if (store == null) {
            Object dsf = cache.getClass().getMethod("createDiskStoreFactory", new Class[0]).invoke(cache, new Object[0]);
            dsf.getClass().getMethod("setMaxOplogSize", Long.TYPE).invoke(dsf, 1L);
            dsf.getClass().getMethod("setDiskDirs", File[].class).invoke(dsf, new Object[]{new File[]{diskStore.getAbsoluteFile()}});
            dsf.getClass().getMethod("create", String.class).invoke(dsf, "store");
        }
        Object rf = cache.getClass().getMethod("createRegionFactory", new Class[0]).invoke(cache, new Object[0]);
        rf.getClass().getMethod("setDiskStoreName", String.class).invoke(rf, "store");
        rf.getClass().getMethod("setDataPolicy", dataPolicy.getClass()).invoke(rf, dataPolicy);
        rf.getClass().getMethod("create", String.class).invoke(rf, regionName);
    }

    public static void assertVersion(Object cache, short ordinal) throws Exception {
        Class<?> idmClass = Thread.currentThread().getContextClassLoader().loadClass("com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember");
        Object ds = cache.getClass().getMethod("getDistributedSystem", new Class[0]).invoke(cache, new Object[0]);
        Object member = ds.getClass().getMethod("getDistributedMember", new Class[0]).invoke(ds, new Object[0]);
        short thisVersion = (Short)member.getClass().getMethod("getVersionOrdinal", new Class[0]).invoke(member, new Object[0]);
        if (ordinal != thisVersion) {
            throw new Error("Version ordinal:" + thisVersion + " was not the expected ordinal of:" + ordinal);
        }
    }

    public static void assertQueryResults(Object cache, String queryString, int numExpectedResults) {
        ClassLoader ogLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(classLoader);
        try {
            Object qs = cache.getClass().getMethod("getQueryService", new Class[0]).invoke(cache, new Object[0]);
            Object query = qs.getClass().getMethod("newQuery", String.class).invoke(qs, queryString);
            Object results = query.getClass().getMethod("execute", new Class[0]).invoke(query, new Object[0]);
            int numResults = (Integer)results.getClass().getMethod("size", new Class[0]).invoke(results, new Object[0]);
            if (numResults != numExpectedResults) {
                System.out.println("Num Results was:" + numResults);
                throw new Error("Num results:" + numResults + " != num expected:" + numExpectedResults);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Error("Query Exception " + e, e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(ogLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopCacheServers(Object cache) throws Exception {
        ClassLoader ogLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(classLoader);
        try {
            List cacheServers = (List)cache.getClass().getMethod("getCacheServers", new Class[0]).invoke(cache, new Object[0]);
            Method stopMethod = null;
            for (Object cs : cacheServers) {
                if (stopMethod == null) {
                    stopMethod = cs.getClass().getMethod("stop", new Class[0]);
                }
                stopMethod.invoke(cs, new Object[0]);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(ogLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeCache(Object cache) throws Exception {
        ClassLoader ogLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(classLoader);
        try {
            boolean cacheClosed;
            if (cache != null && !(cacheClosed = ((Boolean)cache.getClass().getMethod("isClosed", new Class[0]).invoke(cache, new Object[0])).booleanValue())) {
                RollingUpgradeDUnitTest.stopCacheServers(cache);
                cache.getClass().getMethod("close", new Class[0]).invoke(cache, new Object[0]);
                long startTime = System.currentTimeMillis();
                while (!cacheClosed && System.currentTimeMillis() - startTime < 30000L) {
                    try {
                        Thread.sleep(1000L);
                        cacheClosed = (Boolean)cache.getClass().getMethod("isClosed", new Class[0]).invoke(cache, new Object[0]);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
            cache = null;
            System.gc();
            System.gc();
        }
        finally {
            Thread.currentThread().setContextClassLoader(ogLoader);
        }
    }

    public static void rebalance(Object cache) throws Exception {
        try {
            Object manager = cache.getClass().getMethod("getResourceManager", new Class[0]).invoke(cache, new Object[0]);
            Object rebalanceFactory = manager.getClass().getMethod("createRebalanceFactory", new Class[0]).invoke(manager, new Object[0]);
            rebalanceFactory.getClass().getMethod("start", new Class[0]);
            Object op = null;
            Method m = rebalanceFactory.getClass().getMethod("start", new Class[0]);
            m.setAccessible(true);
            op = m.invoke(rebalanceFactory, new Object[0]);
            Object results = op.getClass().getMethod("getResults", new Class[0]).invoke(op, new Object[0]);
            Method getTotalTimeMethod = results.getClass().getMethod("getTotalTime", new Class[0]);
            getTotalTimeMethod.setAccessible(true);
            Method getTotalBucketTransferBytesMethod = results.getClass().getMethod("getTotalBucketTransferBytes", new Class[0]);
            getTotalBucketTransferBytesMethod.setAccessible(true);
            System.out.println("Took " + getTotalTimeMethod.invoke(results, new Object[0]) + " milliseconds\n");
            System.out.println("Transfered " + getTotalBucketTransferBytesMethod.invoke(results, new Object[0]) + "bytes\n");
        }
        catch (Exception e) {
            e.printStackTrace();
            Thread.currentThread().interrupt();
            throw e;
        }
    }

    public static void startLocator(String serverHostName, int port, String testName, String locatorsString) throws Exception {
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", locatorsString);
        props.setProperty("log-level", RollingUpgradeDUnitTest.getDUnitLogLevel());
        InetAddress bindAddr = null;
        try {
            bindAddr = InetAddress.getByName(serverHostName);
        }
        catch (UnknownHostException uhe) {
            throw new Error("While resolving bind address ", uhe);
        }
        File logFile = new File(testName + "-locator" + port + ".log");
        Class<?> locatorClass = Thread.currentThread().getContextClassLoader().loadClass("com.gemstone.gemfire.distributed.Locator");
        locatorClass.getMethod("startLocatorAndDS", Integer.TYPE, File.class, InetAddress.class, Properties.class, Boolean.TYPE, Boolean.TYPE, String.class).invoke(null, port, logFile, bindAddr, props, true, true, null);
    }

    public static void stopLocator() throws Exception {
        Class<?> internalLocatorClass = Thread.currentThread().getContextClassLoader().loadClass("com.gemstone.gemfire.distributed.internal.InternalLocator");
        Object locator = internalLocatorClass.getMethod("getLocator", new Class[0]).invoke(null, new Object[0]);
        locator.getClass().getMethod("stop", new Class[0]).invoke(locator, new Object[0]);
    }

    static {
        diskDir = "RollingUpgradeDUnitTest";
    }

    protected static class LocationAndOrdinal {
        protected String gemfireLocation;
        protected short ordinal;

        protected LocationAndOrdinal(String gemfireLocation, short ordinal) {
            this.gemfireLocation = gemfireLocation;
            this.ordinal = ordinal;
        }
    }
}

