/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.persistence;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.DiskAccessException;
import com.gemstone.gemfire.cache.DiskStore;
import com.gemstone.gemfire.cache.DiskStoreFactory;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionFactory;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.DistributionMessage;
import com.gemstone.gemfire.distributed.internal.DistributionMessageObserver;
import com.gemstone.gemfire.internal.HeapDataOutputStream;
import com.gemstone.gemfire.internal.cache.CacheObserver;
import com.gemstone.gemfire.internal.cache.CacheObserverAdapter;
import com.gemstone.gemfire.internal.cache.CacheObserverHolder;
import com.gemstone.gemfire.internal.cache.DiskRegion;
import com.gemstone.gemfire.internal.cache.DiskStoreFactoryImpl;
import com.gemstone.gemfire.internal.cache.DiskStoreImpl;
import com.gemstone.gemfire.internal.cache.DiskStoreObserver;
import com.gemstone.gemfire.internal.cache.EntrySnapshot;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.InitialImageOperation;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.RegionEntryContext;
import com.gemstone.gemfire.internal.cache.Token;
import com.gemstone.gemfire.internal.cache.TombstoneService;
import com.gemstone.gemfire.internal.cache.persistence.PersistentRecoveryOrderDUnitTest;
import com.gemstone.gemfire.internal.cache.persistence.PersistentReplicatedTestBase;
import com.gemstone.gemfire.internal.cache.versions.RegionVersionVector;
import com.gemstone.gemfire.internal.cache.versions.VersionTag;
import com.gemstone.gemfire.internal.shared.Version;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.SerializableRunnable;
import dunit.VM;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import junit.framework.TestCase;
import util.TestException;

public class PersistentRVVRecoveryDUnitTest
extends PersistentReplicatedTestBase {
    private static final int TEST_REPLICATED_TOMBSTONE_TIMEOUT = 1000;

    public PersistentRVVRecoveryDUnitTest(String name) {
        super(name);
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        PersistentRVVRecoveryDUnitTest.invokeInEveryVM(PersistentRecoveryOrderDUnitTest.class, "resetAckWaitThreshold");
    }

    public void testNoConcurrencyChecks() {
        Cache cache = this.getCache();
        RegionFactory rf = new RegionFactory();
        rf.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
        rf.setConcurrencyChecksEnabled(false);
        try {
            LocalRegion region = (LocalRegion)rf.create(REGION_NAME);
            PersistentRVVRecoveryDUnitTest.fail((String)"Expected to get an IllegalStateException because concurrency checks can't be disabled");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testRecoveryWithKRF() throws Throwable {
        this.doTestRecovery(new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    public void testRecoveryWithoutKRF() throws Throwable {
        this.doTestRecovery(new Runnable(){

            @Override
            public void run() {
                Host host = Host.getHost(0);
                VM vm0 = host.getVM(0);
                VM vm1 = host.getVM(1);
                VM vm2 = host.getVM(2);
                PersistentRVVRecoveryDUnitTest.this.deleteKRFs(vm0);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLotsOfTombstones() throws Throwable {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        LocalRegion region = this.createRegion(vm0);
        int initialCount = this.getTombstoneCount(region);
        PersistentRVVRecoveryDUnitTest.assertEquals((int)0, (int)initialCount);
        int entryCount = 20;
        for (int i = 0; i < 20; ++i) {
            region.put((Object)i, (Object)new byte[100]);
            region.destroy((Object)i);
        }
        PersistentRVVRecoveryDUnitTest.assertEquals((int)20, (int)this.getTombstoneCount(region));
        region.getDiskStore().forceRoll();
        region.getDiskStore().forceCompaction();
        PersistentRVVRecoveryDUnitTest.assertEquals((int)0, (int)region.getDiskStore().numCompactableOplogs());
        PersistentRVVRecoveryDUnitTest.assertEquals((int)20, (int)this.getTombstoneCount(region));
        this.getCache().close();
        region = this.createRegion(vm0);
        PersistentRVVRecoveryDUnitTest.assertEquals((int)20, (int)this.getTombstoneCount(region));
        GemFireCacheImpl cache = (GemFireCacheImpl)this.getCache();
        TombstoneService tombstoneService = cache.getTombstoneService();
        PersistentRVVRecoveryDUnitTest.assertEquals((int)0, (int)region.getDiskStore().numCompactableOplogs());
        region.getDiskStore().forceCompaction();
        PersistentRVVRecoveryDUnitTest.assertTrue((boolean)tombstoneService.forceBatchExpirationForTests(10));
        PersistentRVVRecoveryDUnitTest.assertEquals((int)10, (int)this.getTombstoneCount(region));
        PersistentRVVRecoveryDUnitTest.assertEquals((int)1, (int)region.getDiskStore().numCompactableOplogs());
        this.getCache().close();
        region = this.createRegion(vm0);
        PersistentRVVRecoveryDUnitTest.assertEquals((int)10, (int)this.getTombstoneCount(region));
        PersistentRVVRecoveryDUnitTest.assertEquals((int)1, (int)region.getDiskStore().numCompactableOplogs());
        region.getDiskStore().forceCompaction();
        PersistentRVVRecoveryDUnitTest.assertEquals((int)0, (int)region.getDiskStore().numCompactableOplogs());
        this.getCache().close();
        region = this.createRegion(vm0);
        PersistentRVVRecoveryDUnitTest.assertEquals((int)10, (int)this.getTombstoneCount(region));
        cache = (GemFireCacheImpl)this.getCache();
        DiskStoreObserver.setInstance((DiskStoreObserver)new DiskStoreObserver(){

            public void afterWriteGCRVV(DiskRegion dr) {
                throw new DiskAccessException();
            }
        });
        DistributedTestCase.ExpectedException ex = PersistentRVVRecoveryDUnitTest.addExpectedException("DiskAccessException");
        try {
            tombstoneService = cache.getTombstoneService();
            tombstoneService.forceBatchExpirationForTests(5);
            this.getCache().close();
            PersistentRVVRecoveryDUnitTest.assertTrue((boolean)cache.isClosed());
            region = this.createRegion(vm0);
            PersistentRVVRecoveryDUnitTest.assertEquals((int)5, (int)this.getTombstoneCount(region));
        }
        finally {
            ex.remove();
        }
    }

    public void testLotsOfTombstonesExpiration() throws Throwable {
        Host host = Host.getHost(0);
        final VM vm0 = host.getVM(0);
        vm0.invoke(new CacheSerializableRunnable(""){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run2() throws CacheException {
                long replicatedTombstoneTomeout = TombstoneService.REPLICATED_TOMBSTONE_TIMEOUT;
                long expiriredTombstoneLimit = TombstoneService.EXPIRED_TOMBSTONE_LIMIT;
                try {
                    LocalRegion region = PersistentRVVRecoveryDUnitTest.this.createRegion(vm0);
                    int initialCount = PersistentRVVRecoveryDUnitTest.this.getTombstoneCount(region);
                    TestCase.assertEquals((int)0, (int)initialCount);
                    int entryCount = 20;
                    for (int i = 0; i < 20; ++i) {
                        region.put((Object)i, (Object)new byte[100]);
                        region.destroy((Object)i);
                    }
                    TestCase.assertEquals((int)20, (int)PersistentRVVRecoveryDUnitTest.this.getTombstoneCount(region));
                    region.getDiskStore().forceRoll();
                    region.getDiskStore().forceCompaction();
                    TestCase.assertEquals((int)0, (int)region.getDiskStore().numCompactableOplogs());
                    TestCase.assertEquals((int)20, (int)PersistentRVVRecoveryDUnitTest.this.getTombstoneCount(region));
                    PersistentRVVRecoveryDUnitTest.this.getCache().close();
                    DistributedTestCase.pause(1000);
                    TombstoneService.REPLICATED_TOMBSTONE_TIMEOUT = 1000L;
                    TombstoneService.EXPIRED_TOMBSTONE_LIMIT = 20L;
                    TombstoneService.VERBOSE = true;
                    region = PersistentRVVRecoveryDUnitTest.this.createRegion(vm0);
                    TestCase.assertEquals((int)20, (int)PersistentRVVRecoveryDUnitTest.this.getTombstoneCount(region));
                    PersistentRVVRecoveryDUnitTest.this.getCache().getLogger().fine("Waiting for maximumSleepTime ms");
                    DistributedTestCase.pause(10000);
                    TestCase.assertEquals((int)0, (int)PersistentRVVRecoveryDUnitTest.this.getTombstoneCount(region));
                    region.getDiskStore().forceCompaction();
                    TestCase.assertEquals((int)0, (int)region.getDiskStore().numCompactableOplogs());
                    PersistentRVVRecoveryDUnitTest.this.getCache().close();
                    region = PersistentRVVRecoveryDUnitTest.this.createRegion(vm0);
                    TestCase.assertEquals((int)0, (int)PersistentRVVRecoveryDUnitTest.this.getTombstoneCount(region));
                    TestCase.assertEquals((int)0, (int)region.getDiskStore().numCompactableOplogs());
                    GemFireCacheImpl cache = (GemFireCacheImpl)PersistentRVVRecoveryDUnitTest.this.getCache();
                    cache.close();
                }
                finally {
                    TombstoneService.REPLICATED_TOMBSTONE_TIMEOUT = replicatedTombstoneTomeout;
                    TombstoneService.EXPIRED_TOMBSTONE_LIMIT = expiriredTombstoneLimit;
                    TombstoneService.VERBOSE = false;
                }
            }
        });
    }

    public void testConflictChecksDuringConcurrentDeltaGIIAndOtherOp() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        vm0.invoke(new CacheSerializableRunnable("Create PR and put an entry"){

            @Override
            public void run2() throws CacheException {
                Cache cache = PersistentRVVRecoveryDUnitTest.this.getCache();
                PartitionAttributes attrs = new PartitionAttributesFactory().setRedundantCopies(1).setTotalNumBuckets(1).create();
                AttributesFactory factory = new AttributesFactory();
                factory.setPartitionAttributes(attrs);
                RegionAttributes rAttrs = factory.create();
                Region region = cache.createRegionFactory(rAttrs).create("prRegion");
                region.put((Object)"testKey", (Object)"testValue");
                TestCase.assertEquals((int)1, (int)region.size());
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Create PR and put an entry"){

            @Override
            public void run2() throws CacheException {
                Cache cache = PersistentRVVRecoveryDUnitTest.this.getCache();
                PartitionAttributes attrs = new PartitionAttributesFactory().setRedundantCopies(1).setTotalNumBuckets(1).create();
                AttributesFactory factory = new AttributesFactory();
                factory.setPartitionAttributes(attrs);
                RegionAttributes rAttrs = factory.create();
                Region region = cache.createRegionFactory(rAttrs).create("prRegion");
                region.put((Object)"testKey", (Object)"testValue2");
                cache.close();
                cache = PersistentRVVRecoveryDUnitTest.this.getCache();
                region = cache.createRegionFactory(rAttrs).create("prRegion");
            }
        });
        AsyncInvocation async = vm0.invokeAsync(new CacheSerializableRunnable("Detroy entry in region"){

            @Override
            public void run2() throws CacheException {
                Cache cache = PersistentRVVRecoveryDUnitTest.this.getCache();
                Region region = cache.getRegion("prRegion");
                while (!region.get((Object)"testKey").equals("testValue2")) {
                    DistributedTestCase.pause(100);
                }
                region.destroy((Object)"testKey");
            }
        });
        try {
            async.join(3000L);
        }
        catch (InterruptedException e) {
            new TestException("VM1 entry destroy did not finish in 3000 ms");
        }
        vm1.invoke(new CacheSerializableRunnable("Verifying entry version in new node VM1"){

            @Override
            public void run2() throws CacheException {
                Cache cache = PersistentRVVRecoveryDUnitTest.this.getCache();
                Region region = cache.getRegion("prRegion");
                Region.Entry entry = ((PartitionedRegion)region).getEntry((Object)"testKey", null, true);
                RegionEntry re = ((EntrySnapshot)entry).getRegionEntry();
                DistributedTestCase.getLogWriter().fine("RegionEntry for testKey: " + re.getKey() + " " + re.getValueInVM((RegionEntryContext)((LocalRegion)region)));
                TestCase.assertTrue((boolean)(re.getValueInVM((RegionEntryContext)((LocalRegion)region)) instanceof Token.Tombstone));
                VersionTag tag = re.getVersionStamp().asVersionTag();
                TestCase.assertEquals((int)3, (int)tag.getEntryVersion());
            }
        });
        this.closeCache(vm0);
        this.closeCache(vm1);
    }

    private LocalRegion createRegion(VM vm0) {
        Cache cache = this.getCache();
        DiskStoreFactory dsf = cache.createDiskStoreFactory();
        File dir = this.getDiskDirForVM(vm0);
        dir.mkdirs();
        dsf.setDiskDirs(new File[]{dir});
        dsf.setMaxOplogSize(1L);
        dsf.setAllowForceCompaction(true);
        dsf.setAutoCompact(false);
        dsf.setCompactionThreshold(40);
        DiskStore ds = dsf.create(REGION_NAME);
        RegionFactory rf = new RegionFactory();
        rf.setDiskStoreName(ds.getName());
        rf.setDiskSynchronous(true);
        rf.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
        rf.setScope(Scope.DISTRIBUTED_ACK);
        LocalRegion region = (LocalRegion)rf.create(REGION_NAME);
        return region;
    }

    private int getTombstoneCount(LocalRegion region) {
        int regionCount = region.getTombstoneCount();
        int actualCount = 0;
        for (RegionEntry entry : region.entries.regionEntries()) {
            if (!entry.isTombstone()) continue;
            ++actualCount;
        }
        PersistentRVVRecoveryDUnitTest.assertEquals((int)actualCount, (int)regionCount);
        return actualCount;
    }

    public void doTestRecovery(Runnable doWhileOffline) throws Throwable {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        this.createPersistentRegion(vm0);
        this.createPersistentRegion(vm1);
        this.createPersistentRegion(vm2);
        this.createData(vm0, 0, 5, "value1");
        this.createData(vm1, 3, 8, "value2");
        this.createData(vm2, 6, 11, "value3");
        this.delete(vm1, 0, 1);
        this.delete(vm0, 10, 11);
        RegionVersionVector vm0RVV = this.getRVV(vm0);
        RegionVersionVector vm1RVV = this.getRVV(vm1);
        RegionVersionVector vm2RVV = this.getRVV(vm2);
        this.assertSameRVV(vm0RVV, vm1RVV);
        this.assertSameRVV(vm0RVV, vm2RVV);
        this.closeCache(vm2);
        this.closeCache(vm1);
        this.closeCache(vm0);
        doWhileOffline.run();
        this.createPersistentRegion(vm0);
        RegionVersionVector new0RVV = this.getRVV(vm0);
        this.assertSameRVV(vm0RVV, new0RVV);
        PersistentRVVRecoveryDUnitTest.assertEquals((Object)vm0RVV.getOwnerId(), (Object)new0RVV.getOwnerId());
        this.createData(vm0, 12, 15, "value");
        new0RVV = this.getRVV(vm0);
        this.assertSameRVV(new0RVV, this.getDiskRVV(vm0));
        this.createPersistentRegion(vm1);
        this.assertSameRVV(new0RVV, this.getRVV(vm1));
        this.assertSameRVV(new0RVV, this.getDiskRVV(vm1));
        this.closeCache(vm0);
        this.closeCache(vm1);
        doWhileOffline.run();
        this.createPersistentRegion(vm1);
        RegionVersionVector new1RVV = this.getRVV(vm1);
        this.assertSameRVV(new0RVV, this.getRVV(vm1));
    }

    public void testSkipConflictChecksForGIIdEntries() throws Throwable {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        this.createPersistentRegion(vm0);
        this.createPersistentRegion(vm1);
        this.createData(vm0, 0, 1, "value1");
        this.createData(vm0, 0, 2, "value2");
        this.closeCache(vm1);
        SerializableRunnable createData = new SerializableRunnable("rollEntryVersion"){

            @Override
            public void run() {
                Cache cache = PersistentRVVRecoveryDUnitTest.this.getCache();
                LocalRegion region = (LocalRegion)cache.getRegion(PersistentReplicatedTestBase.REGION_NAME);
                region.put((Object)0, (Object)"value3");
                RegionEntry entry = region.getRegionEntry((Object)0);
                entry = region.getRegionEntry((Object)0);
                VersionTag tag = entry.getVersionStamp().asVersionTag();
                tag.setEntryVersion(tag.getEntryVersion() - 2);
                entry.getVersionStamp().setVersions(tag);
            }
        };
        vm0.invoke(createData);
        this.createPersistentRegion(vm1);
        this.checkData(vm0, 0, 1, "value3");
        this.checkData(vm1, 0, 1, "value3");
    }

    public void testSkipConflictChecksForConcurrentOps() throws Throwable {
        Host host = Host.getHost(0);
        final VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        this.createPersistentRegion(vm0);
        this.createPersistentRegion(vm1);
        this.createData(vm0, 0, 1, "value1");
        this.createData(vm0, 0, 1, "value2");
        this.createData(vm0, 0, 1, "value2");
        this.closeCache(vm1);
        SerializableRunnable createData = new SerializableRunnable("rollEntryVersion"){

            @Override
            public void run() {
                Cache cache = PersistentRVVRecoveryDUnitTest.this.getCache();
                LocalRegion region = (LocalRegion)cache.getRegion(PersistentReplicatedTestBase.REGION_NAME);
                region.put((Object)0, (Object)"value3");
                RegionEntry entry = region.getRegionEntry((Object)0);
                entry = region.getRegionEntry((Object)0);
                VersionTag tag = entry.getVersionStamp().asVersionTag();
                tag.setEntryVersion(tag.getEntryVersion() - 2);
                entry.getVersionStamp().setVersions(tag);
            }
        };
        vm0.invoke(createData);
        vm0.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                DistributionMessageObserver.setInstance((DistributionMessageObserver)new DistributionMessageObserver(){

                    public void beforeProcessMessage(DistributionManager dm, DistributionMessage msg) {
                        if (msg instanceof InitialImageOperation.RequestImageMessage && ((InitialImageOperation.RequestImageMessage)msg).regionPath.contains(PersistentReplicatedTestBase.REGION_NAME)) {
                            PersistentRVVRecoveryDUnitTest.this.createData(vm0, 0, 1, "value4");
                            DistributionMessageObserver.setInstance(null);
                        }
                    }
                });
            }
        });
        this.createPersistentRegion(vm1);
        this.checkData(vm0, 0, 1, "value4");
        this.checkData(vm1, 0, 1, "value4");
    }

    public void testUpdateRVVWithAsyncPersistence() throws Throwable {
        Host host = Host.getHost(0);
        final VM vm0 = host.getVM(1);
        SerializableRunnable createRegion = new SerializableRunnable("Create persistent region"){

            @Override
            public void run() {
                Cache cache = PersistentRVVRecoveryDUnitTest.this.getCache();
                DiskStoreFactory dsf = cache.createDiskStoreFactory();
                File dir = PersistentRVVRecoveryDUnitTest.this.getDiskDirForVM(vm0);
                dir.mkdirs();
                dsf.setDiskDirs(new File[]{dir});
                dsf.setMaxOplogSize(1L);
                dsf.setQueueSize(100);
                dsf.setTimeInterval(1000L);
                DiskStore ds = dsf.create(PersistentReplicatedTestBase.REGION_NAME);
                RegionFactory rf = new RegionFactory();
                rf.setDiskStoreName(ds.getName());
                rf.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
                rf.setScope(Scope.DISTRIBUTED_ACK);
                rf.setDiskSynchronous(false);
                rf.create(PersistentReplicatedTestBase.REGION_NAME);
            }
        };
        vm0.invoke(createRegion);
        AsyncInvocation ins0 = vm0.invokeAsync(new SerializableRunnable("change the entry at vm0"){

            @Override
            public void run() {
                Cache cache = PersistentRVVRecoveryDUnitTest.this.getCache();
                Region region = cache.getRegion(PersistentReplicatedTestBase.REGION_NAME);
                for (int i = 0; i < 500; ++i) {
                    region.put((Object)"A", (Object)("vm0-" + i));
                }
            }
        });
        AsyncInvocation ins1 = vm0.invokeAsync(new SerializableRunnable("change the entry at vm1"){

            @Override
            public void run() {
                Cache cache = PersistentRVVRecoveryDUnitTest.this.getCache();
                Region region = cache.getRegion(PersistentReplicatedTestBase.REGION_NAME);
                for (int i = 0; i < 500; ++i) {
                    region.put((Object)"A", (Object)("vm1-" + i));
                }
            }
        });
        ins0.getResult(60000L);
        ins1.getResult(60000L);
        vm0.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = PersistentRVVRecoveryDUnitTest.this.getCache();
                DiskStore ds = cache.findDiskStore(PersistentReplicatedTestBase.REGION_NAME);
                ds.flush();
            }
        });
        RegionVersionVector rvv = this.getRVV(vm0);
        RegionVersionVector diskRVV = this.getDiskRVV(vm0);
        this.assertSameRVV(rvv, diskRVV);
        this.closeCache(vm0);
        vm0.invoke(createRegion);
        RegionVersionVector rvv2 = this.getRVV(vm0);
        this.assertSameRVV(rvv, rvv2);
        RegionVersionVector diskRVV2 = this.getDiskRVV(vm0);
        this.assertSameRVV(rvv2, diskRVV2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWriteCorrectVersionToKrf() throws Throwable {
        int i2;
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(1);
        final LocalRegion region = (LocalRegion)this.createAsyncRegionWithSmallQueue(vm0);
        DistributedTestCase.ExpectedException ex = PersistentRVVRecoveryDUnitTest.addExpectedException("DiskAccessException");
        LocalRegion.ISSUE_CALLBACKS_TO_CACHE_OBSERVER = true;
        try {
            final CountDownLatch krfCreated = new CountDownLatch(1);
            final AtomicBoolean oplogSwitched = new AtomicBoolean(false);
            CacheObserverHolder.setInstance((CacheObserver)new CacheObserverAdapter(){

                public void afterKrfCreated() {
                    krfCreated.countDown();
                }

                public void afterWritingBytes() {
                    if (oplogSwitched.get()) {
                        try {
                            if (!krfCreated.await(3000L, TimeUnit.SECONDS)) {
                                TestCase.fail((String)"KRF was not created in 30 seconds!");
                            }
                        }
                        catch (InterruptedException e) {
                            TestCase.fail((String)"interrupted");
                        }
                        throw new DiskAccessException();
                    }
                }

                public void afterSwitchingOplog() {
                    oplogSwitched.set(true);
                }
            });
            region.put((Object)"testkey", (Object)"key");
            try {
                i2 = 1;
                while (krfCreated.getCount() > 0L) {
                    region.put((Object)("key" + ++i2 % 3), (Object)i2);
                    Thread.sleep(2L);
                }
            }
            catch (CacheClosedException i2) {
                // empty catch block
            }
            PersistentRVVRecoveryDUnitTest.waitForCriterion(new DistributedTestCase.WaitCriterion(){

                @Override
                public boolean done() {
                    return region.isDestroyed();
                }

                @Override
                public String description() {
                    return "Region was not destroyed : " + region.isDestroyed();
                }
            }, 3000000L, 100L, true);
            PersistentRVVRecoveryDUnitTest.closeCache();
        }
        finally {
            ex.remove();
            LocalRegion.ISSUE_CALLBACKS_TO_CACHE_OBSERVER = false;
            CacheObserverHolder.setInstance(null);
        }
        LocalRegion recoveredRegion = (LocalRegion)this.createAsyncRegionWithSmallQueue(vm0);
        VersionTag[] tagsFromKrf = new VersionTag[3];
        for (i2 = 0; i2 < 3; ++i2) {
            LocalRegion.NonTXEntry entry = (LocalRegion.NonTXEntry)recoveredRegion.getEntry((Object)("key" + i2));
            tagsFromKrf[i2] = entry.getRegionEntry().getVersionStamp().asVersionTag();
            PersistentRVVRecoveryDUnitTest.getLogWriter().info("krfTag[" + i2 + "]=" + tagsFromKrf[i2] + ",value=" + entry.getValue());
        }
        PersistentRVVRecoveryDUnitTest.closeCache();
        System.setProperty(DiskStoreImpl.RECOVER_VALUES_SYNC_PROPERTY_NAME, "true");
        try {
            int i3;
            recoveredRegion = (LocalRegion)this.createAsyncRegionWithSmallQueue(vm0);
            VersionTag[] tagsFromCrf = new VersionTag[3];
            for (i3 = 0; i3 < 3; ++i3) {
                LocalRegion.NonTXEntry entry = (LocalRegion.NonTXEntry)recoveredRegion.getEntry((Object)("key" + i3));
                tagsFromCrf[i3] = entry.getRegionEntry().getVersionStamp().asVersionTag();
                PersistentRVVRecoveryDUnitTest.getLogWriter().info("crfTag[" + i3 + "]=" + tagsFromCrf[i3] + ",value=" + entry.getValue());
            }
            for (i3 = 0; i3 < 3; ++i3) {
                PersistentRVVRecoveryDUnitTest.assertEquals((Object)tagsFromCrf[i3], (Object)tagsFromKrf[i3]);
            }
        }
        finally {
            System.setProperty(DiskStoreImpl.RECOVER_VALUES_SYNC_PROPERTY_NAME, "false");
        }
    }

    private Region createAsyncRegionWithSmallQueue(VM vm0) {
        Cache cache = this.getCache();
        DiskStoreFactoryImpl dsf = (DiskStoreFactoryImpl)cache.createDiskStoreFactory();
        File dir = this.getDiskDirForVM(vm0);
        dir.mkdirs();
        dsf.setDiskDirs(new File[]{dir});
        dsf.setMaxOplogSizeInBytes(500L);
        dsf.setQueueSize(1000);
        dsf.setTimeInterval(1000L);
        DiskStore ds = dsf.create(REGION_NAME);
        RegionFactory rf = new RegionFactory();
        rf.setDiskStoreName(ds.getName());
        rf.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
        rf.setScope(Scope.DISTRIBUTED_ACK);
        rf.setDiskSynchronous(false);
        Region region = rf.create(REGION_NAME);
        return region;
    }

    private void deleteKRFs(final VM vm0) {
        vm0.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                File file = PersistentRVVRecoveryDUnitTest.this.getDiskDirForVM(vm0);
                File[] krfs = file.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.endsWith(".krf");
                    }
                });
                TestCase.assertTrue((krfs.length > 0 ? 1 : 0) != 0);
                for (File krf : krfs) {
                    TestCase.assertTrue((boolean)krf.delete());
                }
            }
        });
    }

    private void assertSameRVV(RegionVersionVector rvv1, RegionVersionVector rvv2) {
        if (!rvv1.sameAs(rvv2)) {
            PersistentRVVRecoveryDUnitTest.fail((String)("Expected " + rvv1 + " but was " + rvv2));
        }
    }

    protected void createData(VM vm, final int startKey, final int endKey, final String value) {
        SerializableRunnable createData = new SerializableRunnable("createData"){

            @Override
            public void run() {
                Cache cache = PersistentRVVRecoveryDUnitTest.this.getCache();
                Region region = cache.getRegion(PersistentReplicatedTestBase.REGION_NAME);
                for (int i = startKey; i < endKey; ++i) {
                    region.put((Object)i, (Object)value);
                }
            }
        };
        vm.invoke(createData);
    }

    protected void checkData(VM vm0, final int startKey, final int endKey, final String value) {
        SerializableRunnable checkData = new SerializableRunnable("CheckData"){

            @Override
            public void run() {
                Cache cache = PersistentRVVRecoveryDUnitTest.this.getCache();
                Region region = cache.getRegion(PersistentReplicatedTestBase.REGION_NAME);
                for (int i = startKey; i < endKey; ++i) {
                    TestCase.assertEquals((String)("For key " + i), (Object)value, (Object)region.get((Object)i));
                }
            }
        };
        vm0.invoke(checkData);
    }

    protected void delete(VM vm, final int startKey, final int endKey) {
        SerializableRunnable createData = new SerializableRunnable("destroy"){

            @Override
            public void run() {
                Cache cache = PersistentRVVRecoveryDUnitTest.this.getCache();
                Region region = cache.getRegion(PersistentReplicatedTestBase.REGION_NAME);
                for (int i = startKey; i < endKey; ++i) {
                    region.destroy((Object)i);
                }
            }
        };
        vm.invoke(createData);
    }

    protected RegionVersionVector getRVV(VM vm) throws IOException, ClassNotFoundException {
        SerializableCallable createData = new SerializableCallable("getRVV"){

            public Object call() throws Exception {
                Cache cache = PersistentRVVRecoveryDUnitTest.this.getCache();
                LocalRegion region = (LocalRegion)cache.getRegion(PersistentReplicatedTestBase.REGION_NAME);
                RegionVersionVector rvv = region.getVersionVector();
                rvv = rvv.getCloneForTransmission();
                HeapDataOutputStream hdos = new HeapDataOutputStream(Version.CURRENT);
                DataSerializer.writeObject((Object)rvv, (DataOutput)hdos);
                return hdos.toByteArray();
            }
        };
        byte[] result = (byte[])vm.invoke(createData);
        ByteArrayInputStream bais = new ByteArrayInputStream(result);
        return (RegionVersionVector)DataSerializer.readObject((DataInput)new DataInputStream(bais));
    }

    protected RegionVersionVector getDiskRVV(VM vm) throws IOException, ClassNotFoundException {
        SerializableCallable createData = new SerializableCallable("getRVV"){

            public Object call() throws Exception {
                Cache cache = PersistentRVVRecoveryDUnitTest.this.getCache();
                LocalRegion region = (LocalRegion)cache.getRegion(PersistentReplicatedTestBase.REGION_NAME);
                RegionVersionVector rvv = region.getDiskRegion().getRegionVersionVector();
                rvv = rvv.getCloneForTransmission();
                HeapDataOutputStream hdos = new HeapDataOutputStream(Version.CURRENT);
                DataSerializer.writeObject((Object)rvv, (DataOutput)hdos);
                return hdos.toByteArray();
            }
        };
        byte[] result = (byte[])vm.invoke(createData);
        ByteArrayInputStream bais = new ByteArrayInputStream(result);
        return (RegionVersionVector)DataSerializer.readObject((DataInput)new DataInputStream(bais));
    }
}

