/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.partitioned.fixed;

import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.EntryOperation;
import com.gemstone.gemfire.cache.FixedPartitionResolver;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.internal.cache.partitioned.fixed.QuarterPartitionResolver;
import com.gemstone.gemfire.internal.cache.xmlcache.Declarable2;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class SingleHopQuarterPartitionResolver
implements FixedPartitionResolver,
Declarable2,
DataSerializable {
    private Properties resolveProps;
    Object[][] months = new Object[12][12];
    int numBuckets;

    public SingleHopQuarterPartitionResolver() {
        this.resolveProps = new Properties();
        this.resolveProps.setProperty("routingType", "key");
    }

    public String getPartitionName(EntryOperation opDetails, Set allAvailablePartitions) {
        Date date = (Date)opDetails.getKey();
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int month = cal.get(2);
        if (month == 0 || month == 1 || month == 2) {
            return "Q1";
        }
        if (month == 3 || month == 4 || month == 5) {
            return "Q2";
        }
        if (month == 6 || month == 7 || month == 8) {
            return "Q3";
        }
        if (month == 9 || month == 10 || month == 11) {
            return "Q4";
        }
        return "Invalid Quarter";
    }

    public String getName() {
        return "QuarterPartitionResolver";
    }

    public Serializable getRoutingObject(EntryOperation opDetails) {
        Date date = (Date)opDetails.getKey();
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int month = cal.get(2);
        switch (month) {
            case 0: {
                return "January";
            }
            case 1: {
                return "February";
            }
            case 2: {
                return "March";
            }
            case 3: {
                return "April";
            }
            case 4: {
                return "May";
            }
            case 5: {
                return "June";
            }
            case 6: {
                return "July";
            }
            case 7: {
                return "August";
            }
            case 8: {
                return "September";
            }
            case 9: {
                return "October";
            }
            case 10: {
                return "November";
            }
            case 11: {
                return "December";
            }
        }
        return null;
    }

    public void close() {
    }

    public void setnumBuckets(int numBukcets) {
        this.numBuckets = numBukcets;
    }

    public int getNumBuckets(String partitionName, String regionName, PartitionAttributes partitionAttributes) {
        return this.numBuckets;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        QuarterPartitionResolver other = (QuarterPartitionResolver)obj;
        return this.resolveProps.equals(other.getConfig());
    }

    public Properties getConfig() {
        return this.resolveProps;
    }

    public void init(Properties props) {
        this.resolveProps.putAll((Map<?, ?>)props);
    }

    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.resolveProps = DataSerializer.readProperties((DataInput)in);
        this.numBuckets = in.readInt();
    }

    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeProperties((Properties)this.resolveProps, (DataOutput)out);
        out.writeInt(this.numBuckets);
    }
}

