/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.partitioned;

import com.gemstone.gemfire.InternalGemFireError;
import com.gemstone.gemfire.admin.AdminDistributedSystemFactory;
import com.gemstone.gemfire.admin.AdminException;
import com.gemstone.gemfire.admin.DistributedSystemConfig;
import com.gemstone.gemfire.admin.internal.AdminDistributedSystemImpl;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.DiskStore;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.EvictionAction;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.cache.DiskRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.control.InternalResourceManager;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.RMIException;
import dunit.SerializableCallable;
import dunit.SerializableRunnable;
import dunit.VM;
import java.io.IOException;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;

public class ShutdownAllDUnitTest
extends CacheTestCase {
    protected static HangingCacheListener listener;
    final String expectedExceptions = InternalGemFireError.class.getName() + "||ShutdownAllRequest: disconnect distributed without response";
    private static final int MAX_WAIT = 600000;

    public ShutdownAllDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        DistributedTestCase.disconnectAllFromDS();
    }

    public void testShutdownAll2Servers() throws Throwable {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        int numBuckets = 50;
        this.createRegion(vm0, "region", "disk", true, 1);
        this.createRegion(vm1, "region", "disk", true, 1);
        this.createData(vm0, 0, numBuckets, "a", "region");
        Set<Integer> vm0Buckets = this.getBucketList(vm0, "region");
        Set<Integer> vm1Buckets = this.getBucketList(vm1, "region");
        ShutdownAllDUnitTest.assertEquals(vm0Buckets, vm1Buckets);
        this.shutDownAllMembers(vm2, 2);
        ShutdownAllDUnitTest.assertTrue((boolean)InternalDistributedSystem.getExistingSystems().isEmpty());
        AsyncInvocation a0 = this.createRegionAsync(vm0, "region", "disk", true, 1);
        AsyncInvocation a1 = this.createRegionAsync(vm1, "region", "disk", true, 1);
        a0.getResult(600000L);
        a1.getResult(600000L);
        ShutdownAllDUnitTest.assertEquals(vm0Buckets, this.getBucketList(vm0, "region"));
        this.checkData(vm0, 0, numBuckets, "a", "region");
        this.checkData(vm1, 0, numBuckets, "a", "region");
        this.createData(vm0, numBuckets, 113, "b", "region");
        this.checkData(vm0, numBuckets, 113, "b", "region");
    }

    public void testShutdownAllWithEncounterIGE1() throws Throwable {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        int numBuckets = 50;
        this.createRegion(vm0, "region", "disk", true, 1);
        this.createData(vm0, 0, numBuckets, "a", "region");
        vm0.invoke(this.addExceptionTag1(this.expectedExceptions));
        ShutdownAllDUnitTest.invokeInEveryVM(new SerializableRunnable("set TestInternalGemFireError"){

            @Override
            public void run() {
                System.setProperty("TestInternalGemFireError", "true");
            }
        });
        this.shutDownAllMembers(vm0, 1);
        ShutdownAllDUnitTest.assertTrue((boolean)InternalDistributedSystem.getExistingSystems().isEmpty());
        ShutdownAllDUnitTest.invokeInEveryVM(new SerializableRunnable("reset TestInternalGemFireError"){

            @Override
            public void run() {
                System.setProperty("TestInternalGemFireError", "false");
            }
        });
        vm0.invoke(this.removeExceptionTag1(this.expectedExceptions));
    }

    public void testShutdownAllWithEncounterIGE2() throws Throwable {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        int numBuckets = 50;
        this.createRegion(vm0, "region", "disk", true, 1);
        this.createRegion(vm1, "region", "disk", true, 1);
        this.createData(vm0, 0, numBuckets, "a", "region");
        Set<Integer> vm0Buckets = this.getBucketList(vm0, "region");
        Set<Integer> vm1Buckets = this.getBucketList(vm1, "region");
        ShutdownAllDUnitTest.assertEquals(vm0Buckets, vm1Buckets);
        vm0.invoke(this.addExceptionTag1(this.expectedExceptions));
        vm1.invoke(this.addExceptionTag1(this.expectedExceptions));
        ShutdownAllDUnitTest.invokeInEveryVM(new SerializableRunnable("set TestInternalGemFireError"){

            @Override
            public void run() {
                System.setProperty("TestInternalGemFireError", "true");
            }
        });
        this.shutDownAllMembers(vm2, 0);
        ShutdownAllDUnitTest.assertTrue((boolean)InternalDistributedSystem.getExistingSystems().isEmpty());
        ShutdownAllDUnitTest.invokeInEveryVM(new SerializableRunnable("reset TestInternalGemFireError"){

            @Override
            public void run() {
                System.setProperty("TestInternalGemFireError", "false");
            }
        });
        vm0.invoke(this.removeExceptionTag1(this.expectedExceptions));
        vm1.invoke(this.removeExceptionTag1(this.expectedExceptions));
    }

    public void testShutdownAllOneServerAndRecover() throws Throwable {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm2 = host.getVM(2);
        this.createRegion(vm0, "region", "disk", true, 0);
        this.createData(vm0, 0, 1, "a", "region");
        this.shutDownAllMembers(vm2, 1);
        ShutdownAllDUnitTest.assertTrue((boolean)InternalDistributedSystem.getExistingSystems().isEmpty());
        this.createRegion(vm0, "region", "disk", true, 0);
        this.checkPRRecoveredFromDisk(vm0, "region", 0, true);
        this.createData(vm0, 1, 10, "b", "region");
    }

    public void testPRWithDR() throws Throwable {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm2 = host.getVM(2);
        this.createRegion(vm0, "region_pr", "disk", true, 0);
        this.createRegion(vm0, "region_dr", "disk", false, 0);
        this.createData(vm0, 0, 1, "a", "region_pr");
        this.createData(vm0, 0, 1, "c", "region_dr");
        this.shutDownAllMembers(vm2, 1);
        ShutdownAllDUnitTest.assertTrue((boolean)InternalDistributedSystem.getExistingSystems().isEmpty());
        this.createRegion(vm0, "region_pr", "disk", true, 0);
        this.createRegion(vm0, "region_dr", "disk", false, 0);
        this.checkPRRecoveredFromDisk(vm0, "region_pr", 0, true);
        this.checkData(vm0, 0, 1, "a", "region_pr");
        this.checkData(vm0, 0, 1, "c", "region_dr");
    }

    public void testShutdownAllFromServer() throws Throwable {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        int numBuckets = 50;
        this.createRegion(vm0, "region", "disk", true, 1);
        this.createRegion(vm1, "region", "disk", true, 1);
        this.createRegion(vm2, "region", "disk", true, 1);
        this.createData(vm0, 0, numBuckets, "a", "region");
        this.shutDownAllMembers(vm2, 3);
        ShutdownAllDUnitTest.assertTrue((boolean)InternalDistributedSystem.getExistingSystems().isEmpty());
        AsyncInvocation a0 = this.createRegionAsync(vm0, "region", "disk", true, 1);
        AsyncInvocation a1 = this.createRegionAsync(vm1, "region", "disk", true, 1);
        AsyncInvocation a2 = this.createRegionAsync(vm2, "region", "disk", true, 1);
        a0.getResult(600000L);
        a1.getResult(600000L);
        a2.getResult(600000L);
        this.createData(vm0, 0, numBuckets, "a", "region");
        this.createData(vm1, 0, numBuckets, "a", "region");
        this.createData(vm2, 0, numBuckets, "a", "region");
        this.createData(vm0, numBuckets, 113, "b", "region");
        this.checkData(vm0, numBuckets, 113, "b", "region");
    }

    public void testCleanStop() throws Throwable {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        this.createRegion(vm0, "region", "disk", true, 1);
        this.createRegion(vm1, "region", "disk", true, 1);
        this.createData(vm0, 0, 1, "a", "region");
        this.shutDownAllMembers(vm2, 2);
        AsyncInvocation a0 = this.createRegionAsync(vm0, "region", "disk", true, 1);
        Thread.sleep(500L);
        ShutdownAllDUnitTest.assertTrue((boolean)a0.isAlive());
        AsyncInvocation a1 = this.createRegionAsync(vm1, "region", "disk", true, 1);
        a0.getResult(600000L);
        a1.getResult(600000L);
        this.checkData(vm0, 0, 1, "a", "region");
        this.checkData(vm1, 0, 1, "a", "region");
        this.checkPRRecoveredFromDisk(vm0, "region", 0, true);
        this.checkPRRecoveredFromDisk(vm1, "region", 0, true);
        this.closeRegion(vm0, "region");
        this.closeRegion(vm1, "region");
        a0 = this.createRegionAsync(vm0, "region", "disk", true, 1);
        a1 = this.createRegionAsync(vm1, "region", "disk", true, 1);
        a0.getResult(600000L);
        a1.getResult(600000L);
        this.checkData(vm0, 0, 1, "a", "region");
        this.checkData(vm1, 0, 1, "a", "region");
        this.checkPRRecoveredFromDisk(vm0, "region", 0, false);
        this.checkPRRecoveredFromDisk(vm1, "region", 0, true);
    }

    public void testCleanStopWithConflictCachePort() throws Throwable {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        this.createRegion(vm0, "region", "disk", true, 1);
        this.createRegion(vm1, "region", "disk", true, 1);
        this.addCacheServer(vm0, 34505);
        this.addCacheServer(vm1, 34505);
        this.createData(vm0, 0, 1, "a", "region");
        this.shutDownAllMembers(vm2, 2);
        AsyncInvocation a0 = this.createRegionAsync(vm0, "region", "disk", true, 1);
        Thread.sleep(500L);
        ShutdownAllDUnitTest.assertTrue((boolean)a0.isAlive());
        AsyncInvocation a1 = this.createRegionAsync(vm1, "region", "disk", true, 1);
        a0.getResult(600000L);
        a1.getResult(600000L);
        this.addCacheServer(vm0, 34505);
        this.addCacheServer(vm1, 34506);
        this.checkData(vm0, 0, 1, "a", "region");
        this.checkData(vm1, 0, 1, "a", "region");
        this.checkPRRecoveredFromDisk(vm0, "region", 0, true);
        this.checkPRRecoveredFromDisk(vm1, "region", 0, true);
    }

    public void testMultiPRDR() throws Throwable {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm2 = host.getVM(2);
        this.createRegion(vm0, "region_pr1", "disk1", true, 0);
        this.createRegion(vm0, "region_pr2", "disk1", true, 0);
        this.createRegion(vm0, "region_pr3", "disk1", true, 0);
        this.createRegion(vm0, "region_dr1", "disk2", false, 0);
        this.createRegion(vm0, "region_dr2", "disk2", false, 0);
        this.createData(vm0, 0, 1, "a", "region_pr1");
        this.createData(vm0, 0, 1, "b", "region_pr2");
        this.createData(vm0, 0, 1, "c", "region_pr3");
        this.createData(vm0, 0, 1, "d", "region_dr1");
        this.createData(vm0, 0, 1, "e", "region_dr2");
        this.shutDownAllMembers(vm2, 1);
        ShutdownAllDUnitTest.assertTrue((boolean)InternalDistributedSystem.getExistingSystems().isEmpty());
        this.createRegion(vm0, "region_pr1", "disk1", true, 0);
        this.createRegion(vm0, "region_pr2", "disk1", true, 0);
        this.createRegion(vm0, "region_pr3", "disk1", true, 0);
        this.createRegion(vm0, "region_dr1", "disk2", false, 0);
        this.createRegion(vm0, "region_dr2", "disk2", false, 0);
        this.checkData(vm0, 0, 1, "a", "region_pr1");
        this.checkData(vm0, 0, 1, "b", "region_pr2");
        this.checkData(vm0, 0, 1, "c", "region_pr3");
        this.checkData(vm0, 0, 1, "d", "region_dr1");
        this.checkData(vm0, 0, 1, "e", "region_dr2");
    }

    public void testShutdownAllTimeout() throws Throwable {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        int numBuckets = 50;
        this.createRegion(vm0, "region", "disk", true, 1);
        this.createRegion(vm1, "region", "disk", true, 1);
        this.createData(vm0, 0, 50, "a", "region");
        Set<Integer> vm0Buckets = this.getBucketList(vm0, "region");
        Set<Integer> vm1Buckets = this.getBucketList(vm1, "region");
        ShutdownAllDUnitTest.assertEquals(vm0Buckets, vm1Buckets);
        AsyncInvocation async1 = vm0.invokeAsync(new SerializableRunnable(){

            @Override
            public void run() {
                Region region = ShutdownAllDUnitTest.this.getCache().getRegion("region");
                listener = new HangingCacheListener();
                region.getAttributesMutator().addCacheListener((CacheListener)listener);
                for (int i = 0; i < 50; ++i) {
                    region.put((Object)i, (Object)"a");
                }
            }
        });
        async1.join(1000L);
        ShutdownAllDUnitTest.assertTrue((boolean)async1.isAlive());
        long start = System.nanoTime();
        this.shutDownAllMembers(vm2, 0, 2000L);
        long end = System.nanoTime();
        ShutdownAllDUnitTest.assertTrue((end - start > TimeUnit.MILLISECONDS.toNanos(1500L) ? 1 : 0) != 0);
        vm0.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                ShutdownAllDUnitTest.listener.latch.countDown();
                listener = null;
            }
        });
        ShutdownAllDUnitTest.pause(10000);
        AsyncInvocation a0 = this.createRegionAsync(vm0, "region", "disk", true, 1);
        AsyncInvocation a1 = this.createRegionAsync(vm1, "region", "disk", true, 1);
        a0.getResult(600000L);
        a1.getResult(600000L);
        ShutdownAllDUnitTest.assertEquals(vm0Buckets, this.getBucketList(vm0, "region"));
        this.checkData(vm0, 0, 50, "a", "region");
        this.checkData(vm1, 0, 50, "a", "region");
        this.createData(vm0, 50, 113, "b", "region");
        this.checkData(vm0, 50, 113, "b", "region");
    }

    public void testShutdownAllWithMembersWaiting() throws Throwable {
        AsyncInvocation a0;
        Set<Integer> vm0Buckets;
        VM vm1;
        VM vm0;
        block3: {
            Host host = Host.getHost(0);
            vm0 = host.getVM(0);
            vm1 = host.getVM(1);
            VM vm2 = host.getVM(2);
            int numBuckets = 5;
            this.createRegion(vm0, "region", "disk", true, 1);
            this.createRegion(vm1, "region", "disk", true, 1);
            this.createData(vm0, 0, 5, "a", "region");
            vm0Buckets = this.getBucketList(vm0, "region");
            Set<Integer> vm1Buckets = this.getBucketList(vm1, "region");
            this.shutDownAllMembers(vm2, 2);
            a0 = this.createRegionAsync(vm0, "region", "disk", true, 1);
            ShutdownAllDUnitTest.pause(5000);
            ShutdownAllDUnitTest.assertTrue((boolean)a0.isAlive());
            this.shutDownAllMembers(vm2, 1);
            try {
                a0.getResult(600000L);
                ShutdownAllDUnitTest.fail((String)"should have received a cache closed exception");
            }
            catch (Exception e) {
                if (!(e.getCause() instanceof RMIException)) {
                    throw e;
                }
                RMIException cause = (RMIException)((Object)e.getCause());
                if (cause.getCause() instanceof CacheClosedException) break block3;
                throw e;
            }
        }
        a0 = this.createRegionAsync(vm0, "region", "disk", true, 1);
        AsyncInvocation a1 = this.createRegionAsync(vm1, "region", "disk", true, 1);
        a0.getResult(600000L);
        a1.getResult(600000L);
        ShutdownAllDUnitTest.assertEquals(vm0Buckets, this.getBucketList(vm0, "region"));
        this.checkData(vm0, 0, 5, "a", "region");
        this.checkData(vm1, 0, 5, "a", "region");
        this.createData(vm0, 5, 10, "b", "region");
        this.checkData(vm0, 5, 10, "b", "region");
    }

    private void shutDownAllMembers(VM vm, final int expnum) {
        vm.invoke(new SerializableRunnable("Shutdown all the members"){

            @Override
            public void run() {
                AdminDistributedSystemImpl adminDS = null;
                try {
                    DistributedSystemConfig config = AdminDistributedSystemFactory.defineDistributedSystem((DistributedSystem)ShutdownAllDUnitTest.this.getSystem(), (String)"");
                    adminDS = (AdminDistributedSystemImpl)AdminDistributedSystemFactory.getDistributedSystem((DistributedSystemConfig)config);
                    adminDS.connect();
                    Set members = adminDS.shutDownAllMembers();
                    int num = members == null ? 0 : members.size();
                    TestCase.assertEquals((int)expnum, (int)num);
                }
                catch (AdminException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    if (adminDS != null) {
                        adminDS.disconnect();
                    }
                }
            }
        });
        System.setProperty("TestInternalGemFireError", "false");
    }

    private SerializableRunnable getCreateDRRunnable(final String regionName, final String diskStoreName) {
        SerializableRunnable createDR = new SerializableRunnable("create DR"){
            Cache cache;

            @Override
            public void run() {
                this.cache = ShutdownAllDUnitTest.this.getCache();
                DiskStore ds = this.cache.findDiskStore(diskStoreName);
                if (ds == null) {
                    ds = this.cache.createDiskStoreFactory().setDiskDirs(CacheTestCase.getDiskDirs()).create(diskStoreName);
                }
                AttributesFactory af = new AttributesFactory();
                af.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
                af.setDiskStoreName(diskStoreName);
                this.cache.createRegion(regionName, af.create());
            }
        };
        return createDR;
    }

    protected void addCacheServer(VM vm, final int port) {
        vm.invoke(new SerializableRunnable("add Cache Server"){

            @Override
            public void run() {
                Cache cache = ShutdownAllDUnitTest.this.getCache();
                CacheServer cs = cache.addCacheServer();
                cs.setPort(port);
                try {
                    cs.start();
                }
                catch (IOException e) {
                    System.out.println("Received expected " + e.getMessage());
                }
            }
        });
    }

    protected void createRegion(VM vm, String regionName, String diskStoreName, boolean isPR, int redundancy) {
        if (isPR) {
            SerializableRunnable createPR = this.getCreatePRRunnable(regionName, diskStoreName, redundancy);
            vm.invoke(createPR);
        } else {
            SerializableRunnable createPR = this.getCreateDRRunnable(regionName, diskStoreName);
            vm.invoke(createPR);
        }
    }

    protected AsyncInvocation createRegionAsync(VM vm, String regionName, String diskStoreName, boolean isPR, int redundancy) {
        if (isPR) {
            SerializableRunnable createPR = this.getCreatePRRunnable(regionName, diskStoreName, redundancy);
            return vm.invokeAsync(createPR);
        }
        SerializableRunnable createDR = this.getCreateDRRunnable(regionName, diskStoreName);
        return vm.invokeAsync(createDR);
    }

    private SerializableRunnable getCreatePRRunnable(final String regionName, final String diskStoreName, final int redundancy) {
        SerializableRunnable createPR = new SerializableRunnable("create pr"){

            @Override
            public void run() {
                DiskStore ds;
                CountDownLatch recoveryDone;
                if (redundancy > 0) {
                    recoveryDone = new CountDownLatch(1);
                    InternalResourceManager.ResourceObserverAdapter observer = new InternalResourceManager.ResourceObserverAdapter(){

                        public void recoveryFinished(Region region) {
                            recoveryDone.countDown();
                        }
                    };
                    InternalResourceManager.setResourceObserver((InternalResourceManager.ResourceObserver)observer);
                } else {
                    recoveryDone = null;
                }
                Cache cache = ShutdownAllDUnitTest.this.getCache();
                if (diskStoreName != null && (ds = cache.findDiskStore(diskStoreName)) == null) {
                    ds = cache.createDiskStoreFactory().setDiskDirs(CacheTestCase.getDiskDirs()).create(diskStoreName);
                }
                AttributesFactory af = new AttributesFactory();
                af.setDiskSynchronous(false);
                af.setEvictionAttributes(EvictionAttributes.createLRUEntryAttributes((int)100, (EvictionAction)EvictionAction.OVERFLOW_TO_DISK));
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setRedundantCopies(redundancy);
                af.setPartitionAttributes(paf.create());
                if (diskStoreName != null) {
                    af.setDataPolicy(DataPolicy.PERSISTENT_PARTITION);
                    af.setDiskStoreName(diskStoreName);
                } else {
                    af.setDataPolicy(DataPolicy.PARTITION);
                }
                cache.createRegion(regionName, af.create());
                if (recoveryDone != null) {
                    try {
                        recoveryDone.await();
                    }
                    catch (InterruptedException e) {
                        DistributedTestCase.fail("Interrupted", e);
                    }
                }
            }
        };
        return createPR;
    }

    protected void createData(VM vm, final int startKey, final int endKey, final String value, final String regionName) {
        SerializableRunnable createData = new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = ShutdownAllDUnitTest.this.getCache();
                Region region = cache.getRegion(regionName);
                for (int i = startKey; i < endKey; ++i) {
                    region.put((Object)i, (Object)value);
                }
            }
        };
        vm.invoke(createData);
    }

    protected Set<Integer> getBucketList(VM vm, final String regionName) {
        SerializableCallable getBuckets = new SerializableCallable("get buckets"){

            public Object call() throws Exception {
                Cache cache = ShutdownAllDUnitTest.this.getCache();
                Region region = cache.getRegion(regionName);
                if (region instanceof PartitionedRegion) {
                    PartitionedRegion pr = (PartitionedRegion)region;
                    return new TreeSet(pr.getDataStore().getAllLocalBucketIds());
                }
                return null;
            }
        };
        return (Set)vm.invoke(getBuckets);
    }

    protected void checkData(VM vm, final int startKey, final int endKey, final String value, final String regionName) {
        SerializableRunnable checkData = new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = ShutdownAllDUnitTest.this.getCache();
                Region region = cache.getRegion(regionName);
                for (int i = startKey; i < endKey; ++i) {
                    TestCase.assertEquals((Object)value, (Object)region.get((Object)i));
                }
            }
        };
        vm.invoke(checkData);
    }

    protected void checkPRRecoveredFromDisk(VM vm, final String regionName, final int bucketId, final boolean recoveredLocally) {
        vm.invoke(new SerializableRunnable("check PR recovered from disk"){

            @Override
            public void run() {
                Cache cache = ShutdownAllDUnitTest.this.getCache();
                PartitionedRegion region = (PartitionedRegion)cache.getRegion(regionName);
                DiskRegion disk = region.getRegionAdvisor().getBucket(bucketId).getDiskRegion();
                if (recoveredLocally) {
                    TestCase.assertEquals((int)0, (int)disk.getStats().getRemoteInitializations());
                    TestCase.assertEquals((int)1, (int)disk.getStats().getLocalInitializations());
                } else {
                    TestCase.assertEquals((int)1, (int)disk.getStats().getRemoteInitializations());
                    TestCase.assertEquals((int)0, (int)disk.getStats().getLocalInitializations());
                }
            }
        });
    }

    protected void closeRegion(VM vm, final String regionName) {
        SerializableRunnable close = new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = ShutdownAllDUnitTest.this.getCache();
                Region region = cache.getRegion(regionName);
                region.close();
            }
        };
        vm.invoke(close);
    }

    private void shutDownAllMembers(VM vm, final int expnum, final long timeout) {
        vm.invoke(new SerializableRunnable("Shutdown all the members"){

            @Override
            public void run() {
                AdminDistributedSystemImpl adminDS = null;
                try {
                    DistributedSystemConfig config = AdminDistributedSystemFactory.defineDistributedSystem((DistributedSystem)ShutdownAllDUnitTest.this.getSystem(), (String)"");
                    adminDS = (AdminDistributedSystemImpl)AdminDistributedSystemFactory.getDistributedSystem((DistributedSystemConfig)config);
                    adminDS.connect();
                    Set members = adminDS.shutDownAllMembers(timeout);
                    int num = members == null ? 0 : members.size();
                    TestCase.assertEquals((int)expnum, (int)num);
                }
                catch (AdminException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    if (adminDS != null) {
                        adminDS.disconnect();
                    }
                }
            }
        });
    }

    private static class HangingCacheListener
    extends CacheListenerAdapter {
        CountDownLatch latch = new CountDownLatch(1);

        private HangingCacheListener() {
        }

        public void afterUpdate(EntryEvent event) {
            try {
                this.latch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

