/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.partitioned;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheTransactionManager;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.cache.DiskStoreImpl;
import com.gemstone.gemfire.internal.cache.TXManagerImpl;
import com.gemstone.gemfire.internal.cache.partitioned.PersistentPartitionedRegionTestBase;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import junit.framework.TestCase;

public class PersistentPartitionedRegionWithTransactionDUnitTest
extends PersistentPartitionedRegionTestBase {
    private static final long MAX_WAIT = 0L;

    public PersistentPartitionedRegionWithTransactionDUnitTest(String name) {
        super(name);
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        PersistentPartitionedRegionWithTransactionDUnitTest.invokeInEveryVM(new SerializableRunnable(){

            @Override
            public void run() {
                TXManagerImpl.ALLOW_PERSISTENT_TRANSACTIONS = false;
                System.setProperty(DiskStoreImpl.RECOVER_VALUES_SYNC_PROPERTY_NAME, "false");
            }
        });
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        PersistentPartitionedRegionWithTransactionDUnitTest.invokeInEveryVM(new SerializableRunnable(){

            @Override
            public void run() {
                TXManagerImpl.ALLOW_PERSISTENT_TRANSACTIONS = true;
                System.setProperty(DiskStoreImpl.RECOVER_VALUES_SYNC_PROPERTY_NAME, "true");
            }
        });
    }

    public void testDummy() {
    }

    public void DISABLED_MERGE_testRollback() throws Throwable {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        int redundancy = 1;
        int numBuckets = 50;
        this.createPR(vm0, redundancy);
        this.createPR(vm1, redundancy);
        this.createPR(vm2, redundancy);
        this.createData(vm0, 0, numBuckets, "a");
        this.createDataWithRollback(vm0, 0, numBuckets, "b");
        this.closeCache(vm0);
        this.closeCache(vm1);
        this.closeCache(vm2);
        AsyncInvocation a1 = this.createPRAsync(vm0, redundancy);
        AsyncInvocation a2 = this.createPRAsync(vm1, redundancy);
        AsyncInvocation a3 = this.createPRAsync(vm2, redundancy);
        a1.getResult(0L);
        a2.getResult(0L);
        a3.getResult(0L);
        this.checkData(vm0, 0, numBuckets, "a");
        this.checkData(vm1, 0, numBuckets, "a");
        this.checkData(vm2, 0, numBuckets, "a");
        this.createData(vm0, 0, numBuckets, "b");
        this.checkData(vm0, 0, numBuckets, "b");
        this.checkData(vm1, 0, numBuckets, "b");
        this.checkData(vm2, 0, numBuckets, "b");
    }

    private void createDataWithRollback(VM vm, final int startKey, final int endKey, final String value) {
        SerializableRunnable createData = new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = PersistentPartitionedRegionWithTransactionDUnitTest.this.getCache();
                CacheTransactionManager tx = cache.getCacheTransactionManager();
                Region region = cache.getRegion(PersistentPartitionedRegionTestBase.PR_REGION_NAME);
                for (int i = startKey; i < endKey; ++i) {
                    tx.begin();
                    region.put((Object)i, (Object)value);
                    region.destroy((Object)(i + 113), (Object)value);
                    region.invalidate((Object)(i + 226), (Object)value);
                    tx.rollback();
                }
            }
        };
        vm.invoke(createData);
    }

    @Override
    protected void createData(VM vm, final int startKey, final int endKey, final String value, final String regionName) {
        PersistentPartitionedRegionWithTransactionDUnitTest.getLogWriter().info("creating runnable to create data for region " + regionName);
        SerializableRunnable createData = new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = PersistentPartitionedRegionWithTransactionDUnitTest.this.getCache();
                DistributedTestCase.getLogWriter().info("getting region " + regionName);
                Region region = cache.getRegion(regionName);
                for (int i = startKey; i < endKey; ++i) {
                    CacheTransactionManager tx = cache.getCacheTransactionManager();
                    tx.begin();
                    region.put((Object)i, (Object)value);
                    region.put((Object)(i + 113), (Object)value);
                    region.put((Object)(i + 226), (Object)value);
                    tx.commit();
                }
                CacheTransactionManager tx = cache.getCacheTransactionManager();
                tx.begin();
                region.put((Object)(endKey + 339), (Object)value);
                tx.commit();
                tx.begin();
                region.remove((Object)(endKey + 339));
                tx.commit();
            }
        };
        vm.invoke(createData);
    }

    @Override
    protected void checkData(VM vm0, final int startKey, final int endKey, final String value, final String regionName) {
        SerializableRunnable checkData = new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = PersistentPartitionedRegionWithTransactionDUnitTest.this.getCache();
                DistributedTestCase.getLogWriter().info("checking data in " + regionName);
                Region region = cache.getRegion(regionName);
                for (int i = startKey; i < endKey; ++i) {
                    TestCase.assertEquals((Object)value, (Object)region.get((Object)i));
                    TestCase.assertEquals((Object)value, (Object)region.get((Object)(i + 113)));
                    TestCase.assertEquals((Object)value, (Object)region.get((Object)(i + 226)));
                }
                TestCase.assertEquals(null, (Object)region.get((Object)(endKey + 339)));
            }
        };
        vm0.invoke(checkData);
    }
}

