/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.partitioned;

import com.gemstone.gemfire.admin.AdminDistributedSystem;
import com.gemstone.gemfire.admin.AdminDistributedSystemFactory;
import com.gemstone.gemfire.admin.AdminException;
import com.gemstone.gemfire.admin.BackupStatus;
import com.gemstone.gemfire.admin.DistributedSystemConfig;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.DiskStore;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.control.RebalanceFactory;
import com.gemstone.gemfire.cache.partition.PartitionRegionHelper;
import com.gemstone.gemfire.cache.partition.PartitionRegionInfo;
import com.gemstone.gemfire.cache.persistence.PersistentID;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.FileUtil;
import com.gemstone.gemfire.internal.SocketCreator;
import com.gemstone.gemfire.internal.cache.DiskRegion;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionDataStore;
import com.gemstone.gemfire.internal.cache.control.InternalResourceManager;
import com.gemstone.gemfire.internal.cache.persistence.PersistenceAdvisor;
import com.gemstone.gemfire.internal.cache.persistence.PersistentMemberID;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import dunit.SerializableCallable;
import dunit.SerializableRunnable;
import dunit.VM;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;

public abstract class PersistentPartitionedRegionTestBase
extends CacheTestCase {
    public static String PR_REGION_NAME = "region";
    private static final int MAX_WAIT = 70000;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        PersistentPartitionedRegionTestBase.invokeInEveryVM(PersistentPartitionedRegionTestBase.class, "setRegionName", new Object[]{this.getUniqueName()});
        PersistentPartitionedRegionTestBase.setRegionName(this.getUniqueName());
    }

    public static void setRegionName(String testName) {
        PR_REGION_NAME = testName + "Region";
    }

    public PersistentPartitionedRegionTestBase(String name) {
        super(name);
    }

    protected void checkRecoveredFromDisk(VM vm, final int bucketId, final boolean recoveredLocally) {
        vm.invoke(new SerializableRunnable("check recovered from disk"){

            @Override
            public void run() {
                Cache cache = PersistentPartitionedRegionTestBase.this.getCache();
                PartitionedRegion region = (PartitionedRegion)cache.getRegion(PR_REGION_NAME);
                DiskRegion disk = region.getRegionAdvisor().getBucket(bucketId).getDiskRegion();
                if (recoveredLocally) {
                    TestCase.assertEquals((int)0, (int)disk.getStats().getRemoteInitializations());
                    TestCase.assertEquals((int)1, (int)disk.getStats().getLocalInitializations());
                } else {
                    TestCase.assertEquals((int)1, (int)disk.getStats().getRemoteInitializations());
                    TestCase.assertEquals((int)0, (int)disk.getStats().getLocalInitializations());
                }
            }
        });
    }

    protected void fakeCleanShutdown(VM vm, final int bucketId) {
        vm.invoke(new SerializableRunnable("mark clean"){

            @Override
            public void run() {
                Cache cache = PersistentPartitionedRegionTestBase.this.getCache();
                PartitionedRegion region = (PartitionedRegion)cache.getRegion(PR_REGION_NAME);
                DiskRegion disk = region.getRegionAdvisor().getBucket(bucketId).getDiskRegion();
                for (PersistentMemberID id : disk.getOnlineMembers()) {
                    disk.memberOfflineAndEqual(id);
                }
                for (PersistentMemberID id : disk.getOfflineMembers()) {
                    disk.memberOfflineAndEqual(id);
                }
                cache.close();
            }
        });
    }

    private PersistentMemberID getPersistentID(VM vm, final int bucketId) {
        Object id = vm.invoke(new SerializableCallable("get bucket persistent id"){

            public Object call() {
                Cache cache = PersistentPartitionedRegionTestBase.this.getCache();
                PartitionedRegion region = (PartitionedRegion)cache.getRegion(PR_REGION_NAME);
                PersistenceAdvisor advisor = region.getRegionAdvisor().getBucket(bucketId).getPersistenceAdvisor();
                return advisor.getPersistentID();
            }
        });
        return (PersistentMemberID)id;
    }

    private void forceRecovery(VM vm) {
        vm.invoke(new SerializableRunnable("force recovery"){

            @Override
            public void run() {
                Cache cache = PersistentPartitionedRegionTestBase.this.getCache();
                RebalanceFactory rf = cache.getResourceManager().createRebalanceFactory();
                try {
                    rf.start().getResults();
                }
                catch (Exception e) {
                    DistributedTestCase.fail("interupted", e);
                }
            }
        });
    }

    protected void checkData(VM vm0, int startKey, int endKey, String value) {
        this.checkData(vm0, startKey, endKey, value, PR_REGION_NAME);
    }

    protected void checkData(VM vm0, final int startKey, final int endKey, final String value, final String regionName) {
        SerializableRunnable checkData = new SerializableRunnable("CheckData"){

            @Override
            public void run() {
                Cache cache = PersistentPartitionedRegionTestBase.this.getCache();
                Region region = cache.getRegion(regionName);
                for (int i = startKey; i < endKey; ++i) {
                    TestCase.assertEquals((String)("For key " + i), (Object)value, (Object)region.get((Object)i));
                }
            }
        };
        vm0.invoke(checkData);
    }

    protected void removeData(VM vm, final int startKey, final int endKey) {
        SerializableRunnable createData = new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = PersistentPartitionedRegionTestBase.this.getCache();
                Region region = cache.getRegion(PR_REGION_NAME);
                for (int i = startKey; i < endKey; ++i) {
                    region.destroy((Object)i);
                }
            }
        };
        vm.invoke(createData);
    }

    protected void createData(VM vm, int startKey, int endKey, String value) {
        PersistentPartitionedRegionTestBase.getLogWriter().info("createData invoked.  PR_REGION_NAME is " + PR_REGION_NAME);
        this.createData(vm, startKey, endKey, value, PR_REGION_NAME);
    }

    protected void createData(VM vm, final int startKey, final int endKey, final String value, final String regionName) {
        SerializableRunnable createData = new SerializableRunnable("createData"){

            @Override
            public void run() {
                Cache cache = PersistentPartitionedRegionTestBase.this.getCache();
                DistributedTestCase.getLogWriter().info("creating data in " + regionName);
                Region region = cache.getRegion(regionName);
                for (int i = startKey; i < endKey; ++i) {
                    region.put((Object)i, (Object)value);
                }
            }
        };
        vm.invoke(createData);
    }

    protected void closeCache(VM vm0) {
        SerializableRunnable close = new SerializableRunnable("Close Cache"){

            @Override
            public void run() {
                Cache cache = PersistentPartitionedRegionTestBase.this.getCache();
                cache.close();
            }
        };
        vm0.invoke(close);
    }

    protected AsyncInvocation closeCacheAsync(VM vm0) {
        SerializableRunnable close = new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = PersistentPartitionedRegionTestBase.this.getCache();
                cache.close();
            }
        };
        return vm0.invokeAsync(close);
    }

    protected void closePR(VM vm0) {
        SerializableRunnable close = new SerializableRunnable("Close Cache"){

            @Override
            public void run() {
                Cache cache = PersistentPartitionedRegionTestBase.this.getCache();
                Region region = cache.getRegion(PR_REGION_NAME);
                region.close();
            }
        };
        vm0.invoke(close);
    }

    protected void destroyPR(VM vm0) {
        SerializableRunnable destroy = new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = PersistentPartitionedRegionTestBase.this.getCache();
                Region region = cache.getRegion(PR_REGION_NAME);
                region.localDestroyRegion();
            }
        };
        vm0.invoke(destroy);
    }

    protected void localDestroyPR(VM vm0) {
        SerializableRunnable destroyPR = new SerializableRunnable("destroy pr"){

            @Override
            public void run() {
                Cache cache = PersistentPartitionedRegionTestBase.this.getCache();
                Region region = cache.getRegion(PR_REGION_NAME);
                region.localDestroyRegion();
            }
        };
        vm0.invoke(destroyPR);
    }

    protected void createPR(VM vm0, int redundancy, int recoveryDelay, int numBuckets) {
        SerializableRunnable createPR = this.getCreatePRRunnable(redundancy, recoveryDelay, numBuckets);
        vm0.invoke(createPR);
    }

    protected void createPR(VM vm0, int redundancy, int recoveryDelay, int numBuckets, boolean synchronous) {
        SerializableRunnable createPR = this.getCreatePRRunnable(redundancy, recoveryDelay, numBuckets, synchronous);
        vm0.invoke(createPR);
    }

    protected void createPR(VM vm0, int redundancy, int recoveryDelay) {
        SerializableRunnable createPR = this.getCreatePRRunnable(redundancy, recoveryDelay);
        vm0.invoke(createPR);
    }

    protected void createPR(VM vm0, int redundancy) {
        SerializableRunnable createPR = this.getCreatePRRunnable(redundancy, -1);
        vm0.invoke(createPR);
    }

    protected void createNestedPR(VM vm) {
        SerializableRunnable createPR = this.getNestedPRRunnable();
        vm.invoke(createPR);
    }

    protected AsyncInvocation createNestedPRAsync(VM vm) {
        SerializableRunnable createPR = this.getNestedPRRunnable();
        return vm.invokeAsync(createPR);
    }

    private SerializableRunnable getNestedPRRunnable() {
        SerializableRunnable createPR = new SerializableRunnable("create pr"){

            @Override
            public void run() {
                Cache cache = PersistentPartitionedRegionTestBase.this.getCache();
                final CountDownLatch recoveryDone = new CountDownLatch(2);
                InternalResourceManager.ResourceObserverAdapter observer = new InternalResourceManager.ResourceObserverAdapter(){

                    public void recoveryFinished(Region region) {
                        recoveryDone.countDown();
                    }
                };
                InternalResourceManager.setResourceObserver((InternalResourceManager.ResourceObserver)observer);
                DiskStore ds = cache.findDiskStore("disk");
                if (ds == null) {
                    ds = cache.createDiskStoreFactory().setDiskDirs(CacheTestCase.getDiskDirs()).create("disk");
                }
                AttributesFactory af = new AttributesFactory();
                af.setDataPolicy(DataPolicy.REPLICATE);
                Region parent1 = cache.createRegion("parent1", af.create());
                AttributesFactory af2 = new AttributesFactory();
                af2.setDataPolicy(DataPolicy.REPLICATE);
                Region parent2 = cache.createRegion("parent2", af2.create());
                af2 = new AttributesFactory();
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setRedundantCopies(1);
                af2.setPartitionAttributes(paf.create());
                af2.setDataPolicy(DataPolicy.PERSISTENT_PARTITION);
                af2.setDiskStoreName("disk");
                parent1.createSubregion(PR_REGION_NAME, af2.create());
                af2 = new AttributesFactory();
                paf = new PartitionAttributesFactory();
                paf.setRedundantCopies(1);
                af2.setPartitionAttributes(paf.create());
                af2.setDataPolicy(DataPolicy.PERSISTENT_PARTITION);
                af2.setDiskStoreName("disk");
                parent2.createSubregion(PR_REGION_NAME, af2.create());
                try {
                    recoveryDone.await(70000L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    DistributedTestCase.fail("interrupted", e);
                }
            }
        };
        return createPR;
    }

    private SerializableRunnable getCreatePRRunnable(int redundancy, int recoveryDelay) {
        return this.getCreatePRRunnable(redundancy, recoveryDelay, 113);
    }

    private SerializableRunnable getCreatePRRunnable(int redundancy, int recoveryDelay, int numBuckets) {
        return this.getCreatePRRunnable(redundancy, recoveryDelay, numBuckets, true);
    }

    private SerializableRunnable getCreatePRRunnable(final int redundancy, final int recoveryDelay, final int numBuckets, final boolean synchronous) {
        SerializableRunnable createPR = new SerializableRunnable("create pr"){

            @Override
            public void run() {
                CountDownLatch recoveryDone;
                if (redundancy > 0) {
                    recoveryDone = new CountDownLatch(1);
                    InternalResourceManager.ResourceObserverAdapter observer = new InternalResourceManager.ResourceObserverAdapter(){

                        public void recoveryFinished(Region region) {
                            recoveryDone.countDown();
                        }
                    };
                    InternalResourceManager.setResourceObserver((InternalResourceManager.ResourceObserver)observer);
                } else {
                    recoveryDone = null;
                }
                Cache cache = PersistentPartitionedRegionTestBase.this.getCache();
                RegionAttributes attr = PersistentPartitionedRegionTestBase.this.getPersistentPRAttributes(redundancy, recoveryDelay, cache, numBuckets, synchronous);
                cache.createRegion(PR_REGION_NAME, attr);
                if (recoveryDone != null) {
                    try {
                        recoveryDone.await();
                    }
                    catch (InterruptedException e) {
                        DistributedTestCase.fail("Interrupted", e);
                    }
                }
            }
        };
        return createPR;
    }

    protected RegionAttributes getPersistentPRAttributes(int redundancy, int recoveryDelay, Cache cache, int numBuckets, boolean synchronous) {
        DiskStore ds = cache.findDiskStore("disk");
        if (ds == null) {
            ds = cache.createDiskStoreFactory().setDiskDirs(PersistentPartitionedRegionTestBase.getDiskDirs()).create("disk");
        }
        AttributesFactory af = new AttributesFactory();
        PartitionAttributesFactory paf = new PartitionAttributesFactory();
        paf.setRedundantCopies(redundancy);
        paf.setRecoveryDelay((long)recoveryDelay);
        paf.setTotalNumBuckets(numBuckets);
        paf.setLocalMaxMemory(500);
        af.setPartitionAttributes(paf.create());
        af.setDataPolicy(DataPolicy.PERSISTENT_PARTITION);
        af.setDiskStoreName("disk");
        af.setDiskSynchronous(synchronous);
        RegionAttributes attr = af.create();
        return attr;
    }

    protected AsyncInvocation createPRAsync(VM vm0, int redundancy, int recoveryDelay, int numBuckets) {
        SerializableRunnable createPR = this.getCreatePRRunnable(redundancy, recoveryDelay, numBuckets);
        return vm0.invokeAsync(createPR);
    }

    protected AsyncInvocation createPRAsync(VM vm0, int redundancy) {
        SerializableRunnable createPR = this.getCreatePRRunnable(redundancy, -1);
        return vm0.invokeAsync(createPR);
    }

    protected Set<Integer> getBucketList(VM vm0) {
        return this.getBucketList(vm0, PR_REGION_NAME);
    }

    protected Set<Integer> getBucketList(VM vm0, final String regionName) {
        SerializableCallable getBuckets = new SerializableCallable("get buckets"){

            public Object call() throws Exception {
                Cache cache = PersistentPartitionedRegionTestBase.this.getCache();
                PartitionedRegion region = (PartitionedRegion)cache.getRegion(regionName);
                return new TreeSet(region.getDataStore().getAllLocalBucketIds());
            }
        };
        return (Set)vm0.invoke(getBuckets);
    }

    protected void waitForBuckets(VM vm, final Set<Integer> expectedBuckets, final String regionName) {
        new SerializableCallable("get buckets"){

            public Object call() throws Exception {
                Cache cache = PersistentPartitionedRegionTestBase.this.getCache();
                final PartitionedRegion region = (PartitionedRegion)cache.getRegion(regionName);
                DistributedTestCase.waitForCriterion(new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        return expectedBuckets.equals(this.getActualBuckets());
                    }

                    @Override
                    public String description() {
                        return "Buckets on vm " + this.getActualBuckets() + " never became equal to expected " + expectedBuckets;
                    }

                    public TreeSet<Integer> getActualBuckets() {
                        return new TreeSet<Integer>(region.getDataStore().getAllLocalBucketIds());
                    }
                }, 30000L, 100L, true);
                return null;
            }
        };
    }

    protected Set<Integer> getPrimaryBucketList(VM vm0) {
        return this.getPrimaryBucketList(vm0, PR_REGION_NAME);
    }

    protected Set<Integer> getPrimaryBucketList(VM vm0, final String regionName) {
        SerializableCallable getPrimaryBuckets = new SerializableCallable("get primary buckets"){

            public Object call() throws Exception {
                Cache cache = PersistentPartitionedRegionTestBase.this.getCache();
                PartitionedRegion region = (PartitionedRegion)cache.getRegion(regionName);
                return new TreeSet(region.getDataStore().getAllLocalPrimaryBucketIds());
            }
        };
        return (Set)vm0.invoke(getPrimaryBuckets);
    }

    protected void revokeKnownMissingMembers(VM vm2, final int numExpectedMissing) {
        vm2.invoke(new SerializableRunnable("Revoke the member"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    DistributedSystemConfig config = AdminDistributedSystemFactory.defineDistributedSystem((DistributedSystem)PersistentPartitionedRegionTestBase.this.getSystem(), (String)"");
                    final AdminDistributedSystem adminDS = AdminDistributedSystemFactory.getDistributedSystem((DistributedSystemConfig)config);
                    adminDS.connect();
                    adminDS.waitToBeConnected(70000L);
                    try {
                        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

                            @Override
                            public boolean done() {
                                try {
                                    Set missingIds = adminDS.getMissingPersistentMembers();
                                    if (missingIds.size() != numExpectedMissing) {
                                        return false;
                                    }
                                    for (PersistentID missingId : missingIds) {
                                        adminDS.revokePersistentMember(missingId.getUUID());
                                    }
                                    return true;
                                }
                                catch (AdminException ae) {
                                    throw new RuntimeException(ae);
                                }
                            }

                            @Override
                            public String description() {
                                try {
                                    return "expected " + numExpectedMissing + " missing members for revocation, current: " + adminDS.getMissingPersistentMembers();
                                }
                                catch (AdminException ae) {
                                    throw new RuntimeException(ae);
                                }
                            }
                        };
                        DistributedTestCase.waitForCriterion(wc, 70000L, 500L, true);
                    }
                    finally {
                        adminDS.disconnect();
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    protected void revokeAllMembers(VM vm) {
        vm.invoke(new SerializableRunnable("Revoke the member"){

            @Override
            public void run() {
                PersistentPartitionedRegionTestBase.this.getCache();
                AdminDistributedSystem adminDS = null;
                try {
                    DistributedSystemConfig config = AdminDistributedSystemFactory.defineDistributedSystem((DistributedSystem)PersistentPartitionedRegionTestBase.this.getSystem(), (String)"");
                    adminDS = AdminDistributedSystemFactory.getDistributedSystem((DistributedSystemConfig)config);
                    adminDS.connect();
                    adminDS.waitToBeConnected(70000L);
                    adminDS.revokePersistentMember(SocketCreator.getLocalHost(), null);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                finally {
                    if (adminDS != null) {
                        adminDS.disconnect();
                    }
                }
            }
        });
    }

    protected void revokeMember(VM vm, final File directory) {
        vm.invoke(new SerializableRunnable("Revoke the member"){

            @Override
            public void run() {
                GemFireCacheImpl cache = (GemFireCacheImpl)PersistentPartitionedRegionTestBase.this.getCache();
                AdminDistributedSystem adminDS = null;
                try {
                    DistributedSystemConfig config = AdminDistributedSystemFactory.defineDistributedSystem((DistributedSystem)PersistentPartitionedRegionTestBase.this.getSystem(), (String)"");
                    adminDS = AdminDistributedSystemFactory.getDistributedSystem((DistributedSystemConfig)config);
                    adminDS.connect();
                    adminDS.waitToBeConnected(70000L);
                    adminDS.revokePersistentMember(SocketCreator.getLocalHost(), directory.getCanonicalPath());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                finally {
                    if (adminDS != null) {
                        adminDS.disconnect();
                    }
                }
            }
        });
    }

    protected void moveBucket(final int bucketId, VM source, VM target) {
        SerializableCallable getId = new SerializableCallable("Get Id"){

            public Object call() throws Exception {
                Cache cache = PersistentPartitionedRegionTestBase.this.getCache();
                return cache.getDistributedSystem().getDistributedMember();
            }
        };
        final InternalDistributedMember sourceId = (InternalDistributedMember)source.invoke(getId);
        SerializableRunnable move = new SerializableRunnable("move bucket"){

            @Override
            public void run() {
                Cache cache = PersistentPartitionedRegionTestBase.this.getCache();
                PartitionedRegion region = (PartitionedRegion)cache.getRegion(PR_REGION_NAME);
                region.getDataStore().moveBucket(bucketId, sourceId, false);
            }
        };
        target.invoke(move);
    }

    protected Set<PersistentMemberID> getOfflineMembers(final int bucketId, VM vm) {
        SerializableCallable getId = new SerializableCallable("Get Id"){

            public Object call() throws Exception {
                Cache cache = PersistentPartitionedRegionTestBase.this.getCache();
                PartitionedRegion region = (PartitionedRegion)cache.getRegion(PR_REGION_NAME);
                return region.getRegionAdvisor().getProxyBucketArray()[bucketId].getPersistenceAdvisor().getMembershipView().getOfflineMembers();
            }
        };
        return (Set)vm.invoke(getId);
    }

    protected Set<PersistentMemberID> getOnlineMembers(final int bucketId, VM vm) {
        SerializableCallable getId = new SerializableCallable("Get Id"){

            public Object call() throws Exception {
                Cache cache = PersistentPartitionedRegionTestBase.this.getCache();
                PartitionedRegion region = (PartitionedRegion)cache.getRegion(PR_REGION_NAME);
                return region.getRegionAdvisor().getProxyBucketArray()[bucketId].getPersistenceAdvisor().getPersistedOnlineOrEqualMembers();
            }
        };
        return (Set)vm.invoke(getId);
    }

    protected void waitForBucketRecovery(VM vm2, Set<Integer> lostBuckets) {
        this.waitForBucketRecovery(vm2, lostBuckets, PR_REGION_NAME);
    }

    protected void waitForBucketRecovery(VM vm2, final Set<Integer> lostBuckets, final String regionName) {
        vm2.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = PersistentPartitionedRegionTestBase.this.getCache();
                PartitionedRegion region = (PartitionedRegion)cache.getRegion(regionName);
                final PartitionedRegionDataStore dataStore = region.getDataStore();
                DistributedTestCase.waitForCriterion(new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        Set vm2Buckets = dataStore.getAllLocalBucketIds();
                        return lostBuckets.equals(vm2Buckets);
                    }

                    @Override
                    public String description() {
                        return "expected to recover " + lostBuckets + " buckets, now have " + dataStore.getAllLocalBucketIds();
                    }
                }, 70000L, 100L, true);
            }
        });
    }

    protected void waitForRedundancyRecovery(VM vm, final int expectedRedundancy, final String regionName) {
        vm.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = PersistentPartitionedRegionTestBase.this.getCache();
                final Region region = cache.getRegion(regionName);
                DistributedTestCase.waitForCriterion(new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        PartitionRegionInfo info = PartitionRegionHelper.getPartitionRegionInfo((Region)region);
                        return info.getActualRedundantCopies() == expectedRedundancy;
                    }

                    @Override
                    public String description() {
                        PartitionRegionInfo info = PartitionRegionHelper.getPartitionRegionInfo((Region)region);
                        return "Did not reach expected redundancy " + expectedRedundancy + " redundancy info = " + info.getActualRedundantCopies();
                    }
                }, 30000L, 100L, true);
            }
        });
    }

    protected void invalidateData(VM vm, final int startKey, final int endKey) {
        SerializableRunnable createData = new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = PersistentPartitionedRegionTestBase.this.getCache();
                Region region = cache.getRegion(PR_REGION_NAME);
                for (int i = startKey; i < endKey; ++i) {
                    region.destroy((Object)i);
                    region.create((Object)i, null);
                    region.invalidate((Object)i);
                }
            }
        };
        vm.invoke(createData);
    }

    protected BackupStatus backup(VM vm) {
        return (BackupStatus)vm.invoke(new SerializableCallable("Backup all members"){

            public Object call() {
                AdminDistributedSystem adminDS = null;
                try {
                    DistributedSystemConfig config = AdminDistributedSystemFactory.defineDistributedSystem((DistributedSystem)PersistentPartitionedRegionTestBase.this.getSystem(), (String)"");
                    adminDS = AdminDistributedSystemFactory.getDistributedSystem((DistributedSystemConfig)config);
                    adminDS.connect();
                    adminDS.waitToBeConnected(70000L);
                    BackupStatus backupStatus = adminDS.backupAllMembers(PersistentPartitionedRegionTestBase.getBackupDir());
                    return backupStatus;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                finally {
                    if (adminDS != null) {
                        adminDS.disconnect();
                    }
                }
            }
        });
    }

    protected void restoreBackup(int expectedNumScripts) throws IOException, InterruptedException {
        List restoreScripts = FileUtil.findAll((File)PersistentPartitionedRegionTestBase.getBackupDir(), (String)".*restore.*");
        PersistentPartitionedRegionTestBase.assertEquals((String)("Restore scripts " + restoreScripts), (int)expectedNumScripts, (int)restoreScripts.size());
        for (File script : restoreScripts) {
            this.execute(script);
        }
    }

    private void execute(File script) throws IOException, InterruptedException {
        String line;
        ProcessBuilder pb = new ProcessBuilder(script.getAbsolutePath());
        pb.redirectErrorStream(true);
        Process process = pb.start();
        InputStream is = process.getInputStream();
        byte[] buffer = new byte[1024];
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        while ((line = br.readLine()) != null) {
            PersistentPartitionedRegionTestBase.getLogWriter().fine("OUTPUT:" + line);
        }
        PersistentPartitionedRegionTestBase.assertEquals((int)0, (int)process.waitFor());
    }

    protected static File getBackupDir() {
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        File dir = new File(tmpDir, "backupDir");
        dir.mkdirs();
        return dir;
    }
}

