/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.partitioned;

import com.gemstone.gemfire.admin.internal.AdminDistributedSystemImpl;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.DiskStore;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.PartitionedRegionStorageException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.control.RebalanceOperation;
import com.gemstone.gemfire.cache.control.RebalanceResults;
import com.gemstone.gemfire.cache.persistence.PartitionOfflineException;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.DistributionMessage;
import com.gemstone.gemfire.distributed.internal.DistributionMessageObserver;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.FileUtil;
import com.gemstone.gemfire.internal.cache.InitialImageOperation;
import com.gemstone.gemfire.internal.cache.control.InternalResourceManager;
import com.gemstone.gemfire.internal.cache.partitioned.PersistentPartitionedRegionTestBase;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.SerializableRunnable;
import dunit.VM;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;

public class PersistentColocatedPartitionedRegionDUnitTest
extends PersistentPartitionedRegionTestBase {
    private static final int NUM_BUCKETS = 15;
    private static final int MAX_WAIT = 30000;

    public PersistentColocatedPartitionedRegionDUnitTest(String name) {
        super(name);
    }

    @Override
    public void tearDown2() throws Exception {
        FileUtil.delete((File)PersistentColocatedPartitionedRegionDUnitTest.getBackupDir());
        super.tearDown2();
    }

    public void testColocatedPRAttributes() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(1);
        vm0.invoke(new SerializableRunnable("create"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Cache cache = PersistentColocatedPartitionedRegionDUnitTest.this.getCache();
                DiskStore ds = cache.findDiskStore("disk");
                if (ds == null) {
                    ds = cache.createDiskStoreFactory().setDiskDirs(CacheTestCase.getDiskDirs()).create("disk");
                }
                AttributesFactory af = new AttributesFactory();
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setRedundantCopies(0);
                af.setPartitionAttributes(paf.create());
                af.setDataPolicy(DataPolicy.PERSISTENT_PARTITION);
                af.setDiskStoreName("disk");
                cache.createRegion("persistentLeader", af.create());
                af.setDataPolicy(DataPolicy.PARTITION);
                af.setDiskStoreName(null);
                cache.createRegion("nonPersistentLeader", af.create());
                af.setDataPolicy(DataPolicy.PERSISTENT_PARTITION);
                af.setDiskStoreName("disk");
                paf.setColocatedWith("nonPersistentLeader");
                af.setPartitionAttributes(paf.create());
                DistributedTestCase.ExpectedException exp = DistributedTestCase.addExpectedException("IllegalStateException");
                try {
                    cache.createRegion("colocated", af.create());
                    TestCase.fail((String)"should not have been able to create a persistent region colocated with a non persistent region");
                }
                catch (IllegalStateException illegalStateException) {
                }
                finally {
                    exp.remove();
                }
                paf.setColocatedWith("persistentLeader");
                af.setPartitionAttributes(paf.create());
                cache.createRegion("colocated", af.create());
                af.setDataPolicy(DataPolicy.PARTITION);
                af.setDiskStoreName(null);
                paf.setColocatedWith("persistentLeader");
                af.setPartitionAttributes(paf.create());
                cache.createRegion("colocated2", af.create());
            }
        });
    }

    public void testColocatedPRs() throws Throwable {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        SerializableRunnable createPRs = new SerializableRunnable("region1"){

            @Override
            public void run() {
                Cache cache = PersistentColocatedPartitionedRegionDUnitTest.this.getCache();
                DiskStore ds = cache.findDiskStore("disk");
                if (ds == null) {
                    ds = cache.createDiskStoreFactory().setDiskDirs(CacheTestCase.getDiskDirs()).create("disk");
                }
                AttributesFactory af = new AttributesFactory();
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setRedundantCopies(0);
                af.setPartitionAttributes(paf.create());
                af.setDataPolicy(DataPolicy.PERSISTENT_PARTITION);
                af.setDiskStoreName("disk");
                cache.createRegion(PersistentPartitionedRegionTestBase.PR_REGION_NAME, af.create());
                paf.setColocatedWith(PersistentPartitionedRegionTestBase.PR_REGION_NAME);
                af.setPartitionAttributes(paf.create());
                cache.createRegion("region2", af.create());
                paf.setColocatedWith("region2");
                af.setPartitionAttributes(paf.create());
                af.setDataPolicy(DataPolicy.PARTITION);
                af.setDiskStoreName(null);
                cache.createRegion("region3", af.create());
            }
        };
        vm0.invoke(createPRs);
        vm1.invoke(createPRs);
        vm2.invoke(createPRs);
        this.createData(vm0, 0, 15, "a");
        this.createData(vm0, 0, 15, "b", "region2");
        this.createData(vm0, 0, 15, "c", "region3");
        Set<Integer> vm0Buckets = this.getBucketList(vm0, PR_REGION_NAME);
        PersistentColocatedPartitionedRegionDUnitTest.assertEquals(vm0Buckets, this.getBucketList(vm0, "region2"));
        PersistentColocatedPartitionedRegionDUnitTest.assertEquals(vm0Buckets, this.getBucketList(vm0, "region3"));
        Set<Integer> vm1Buckets = this.getBucketList(vm1, PR_REGION_NAME);
        PersistentColocatedPartitionedRegionDUnitTest.assertEquals(vm1Buckets, this.getBucketList(vm1, "region2"));
        PersistentColocatedPartitionedRegionDUnitTest.assertEquals(vm1Buckets, this.getBucketList(vm1, "region3"));
        Set<Integer> vm2Buckets = this.getBucketList(vm2, PR_REGION_NAME);
        PersistentColocatedPartitionedRegionDUnitTest.assertEquals(vm2Buckets, this.getBucketList(vm2, "region2"));
        PersistentColocatedPartitionedRegionDUnitTest.assertEquals(vm2Buckets, this.getBucketList(vm2, "region3"));
        this.closeCache(vm0);
        this.closeCache(vm1);
        this.closeCache(vm2);
        AsyncInvocation async0 = vm0.invokeAsync(createPRs);
        AsyncInvocation async1 = vm1.invokeAsync(createPRs);
        AsyncInvocation async2 = vm2.invokeAsync(createPRs);
        async0.getResult(30000L);
        async1.getResult(30000L);
        async2.getResult(30000L);
        this.waitForBuckets(vm0, vm0Buckets, PR_REGION_NAME);
        this.waitForBuckets(vm0, vm0Buckets, "region2");
        this.waitForBuckets(vm1, vm1Buckets, PR_REGION_NAME);
        this.waitForBuckets(vm1, vm1Buckets, "region2");
        this.checkData(vm0, 0, 15, "a");
        this.checkData(vm0, 0, 15, "b", "region2");
        this.checkData(vm0, 0, 15, null, "region3");
        this.createData(vm0, 0, 15, "c", "region3");
        this.checkData(vm0, 0, 15, "c", "region3");
        PersistentColocatedPartitionedRegionDUnitTest.assertEquals(vm0Buckets, this.getBucketList(vm0, "region3"));
        PersistentColocatedPartitionedRegionDUnitTest.assertEquals(vm1Buckets, this.getBucketList(vm1, "region3"));
        PersistentColocatedPartitionedRegionDUnitTest.assertEquals(vm2Buckets, this.getBucketList(vm2, "region3"));
    }

    public void testColocatedPRsRecoveryOnePRAtATime() throws Throwable {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        SerializableRunnable createParentPR = new SerializableRunnable("createParentPR"){

            @Override
            public void run() {
                Cache cache = PersistentColocatedPartitionedRegionDUnitTest.this.getCache();
                DiskStore ds = cache.findDiskStore("disk");
                if (ds == null) {
                    ds = cache.createDiskStoreFactory().setDiskDirs(CacheTestCase.getDiskDirs()).create("disk");
                }
                AttributesFactory af = new AttributesFactory();
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setRedundantCopies(1);
                af.setPartitionAttributes(paf.create());
                af.setDataPolicy(DataPolicy.PERSISTENT_PARTITION);
                af.setDiskStoreName("disk");
                cache.createRegion(PersistentPartitionedRegionTestBase.PR_REGION_NAME, af.create());
            }
        };
        SerializableRunnable createChildPR = this.getCreateChildPRRunnable();
        vm0.invoke(createParentPR);
        vm1.invoke(createParentPR);
        vm2.invoke(createParentPR);
        vm0.invoke(createChildPR);
        vm1.invoke(createChildPR);
        vm2.invoke(createChildPR);
        this.createData(vm0, 0, 15, "a");
        this.createData(vm0, 0, 15, "b", "region2");
        Set<Integer> vm0Buckets = this.getBucketList(vm0, PR_REGION_NAME);
        PersistentColocatedPartitionedRegionDUnitTest.assertEquals(vm0Buckets, this.getBucketList(vm0, "region2"));
        Set<Integer> vm1Buckets = this.getBucketList(vm1, PR_REGION_NAME);
        PersistentColocatedPartitionedRegionDUnitTest.assertEquals(vm1Buckets, this.getBucketList(vm1, "region2"));
        Set<Integer> vm2Buckets = this.getBucketList(vm2, PR_REGION_NAME);
        PersistentColocatedPartitionedRegionDUnitTest.assertEquals(vm2Buckets, this.getBucketList(vm2, "region2"));
        Set<Integer> vm0PrimaryBuckets = this.getPrimaryBucketList(vm0, PR_REGION_NAME);
        PersistentColocatedPartitionedRegionDUnitTest.assertEquals(vm0PrimaryBuckets, this.getPrimaryBucketList(vm0, "region2"));
        Set<Integer> vm1PrimaryBuckets = this.getPrimaryBucketList(vm1, PR_REGION_NAME);
        PersistentColocatedPartitionedRegionDUnitTest.assertEquals(vm1PrimaryBuckets, this.getPrimaryBucketList(vm1, "region2"));
        Set<Integer> vm2PrimaryBuckets = this.getPrimaryBucketList(vm2, PR_REGION_NAME);
        PersistentColocatedPartitionedRegionDUnitTest.assertEquals(vm2PrimaryBuckets, this.getPrimaryBucketList(vm2, "region2"));
        this.closeCache(vm0);
        this.closeCache(vm1);
        this.closeCache(vm2);
        AsyncInvocation async0 = vm0.invokeAsync(createParentPR);
        AsyncInvocation async1 = vm1.invokeAsync(createParentPR);
        AsyncInvocation async2 = vm2.invokeAsync(createParentPR);
        async0.getResult(30000L);
        async1.getResult(30000L);
        async2.getResult(30000L);
        vm0.invoke(createChildPR);
        vm1.invoke(createChildPR);
        vm2.invoke(createChildPR);
        PersistentColocatedPartitionedRegionDUnitTest.pause(4000);
        PersistentColocatedPartitionedRegionDUnitTest.assertEquals(vm0Buckets, this.getBucketList(vm0, PR_REGION_NAME));
        PersistentColocatedPartitionedRegionDUnitTest.assertEquals(vm0Buckets, this.getBucketList(vm0, "region2"));
        PersistentColocatedPartitionedRegionDUnitTest.assertEquals(vm1Buckets, this.getBucketList(vm1, PR_REGION_NAME));
        PersistentColocatedPartitionedRegionDUnitTest.assertEquals(vm1Buckets, this.getBucketList(vm1, "region2"));
        PersistentColocatedPartitionedRegionDUnitTest.assertEquals(vm2Buckets, this.getBucketList(vm2, PR_REGION_NAME));
        PersistentColocatedPartitionedRegionDUnitTest.assertEquals(vm2Buckets, this.getBucketList(vm2, "region2"));
        vm0PrimaryBuckets = this.getPrimaryBucketList(vm0, PR_REGION_NAME);
        PersistentColocatedPartitionedRegionDUnitTest.assertEquals(vm0PrimaryBuckets, this.getPrimaryBucketList(vm0, "region2"));
        vm1PrimaryBuckets = this.getPrimaryBucketList(vm1, PR_REGION_NAME);
        PersistentColocatedPartitionedRegionDUnitTest.assertEquals(vm1PrimaryBuckets, this.getPrimaryBucketList(vm1, "region2"));
        vm2PrimaryBuckets = this.getPrimaryBucketList(vm2, PR_REGION_NAME);
        PersistentColocatedPartitionedRegionDUnitTest.assertEquals(vm2PrimaryBuckets, this.getPrimaryBucketList(vm2, "region2"));
        this.checkData(vm0, 0, 15, "a");
        this.checkData(vm0, 0, 15, null, "region2");
        this.createData(vm0, 0, 15, "c", "region2");
        this.checkData(vm0, 0, 15, "c", "region2");
        PersistentColocatedPartitionedRegionDUnitTest.assertEquals(vm0Buckets, this.getBucketList(vm0, "region2"));
        PersistentColocatedPartitionedRegionDUnitTest.assertEquals(vm1Buckets, this.getBucketList(vm1, "region2"));
        PersistentColocatedPartitionedRegionDUnitTest.assertEquals(vm2Buckets, this.getBucketList(vm2, "region2"));
    }

    private SerializableRunnable getCreateChildPRRunnable() {
        return new SerializableRunnable("createChildPR"){

            @Override
            public void run() {
                Cache cache = PersistentColocatedPartitionedRegionDUnitTest.this.getCache();
                final CountDownLatch recoveryDone = new CountDownLatch(1);
                InternalResourceManager.ResourceObserverAdapter observer = new InternalResourceManager.ResourceObserverAdapter(){

                    public void recoveryFinished(Region region) {
                        if (region.getName().equals("region2")) {
                            recoveryDone.countDown();
                        }
                    }
                };
                InternalResourceManager.setResourceObserver((InternalResourceManager.ResourceObserver)observer);
                AttributesFactory af = new AttributesFactory();
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setRedundantCopies(1);
                paf.setColocatedWith(PersistentPartitionedRegionTestBase.PR_REGION_NAME);
                af.setPartitionAttributes(paf.create());
                cache.createRegion("region2", af.create());
                try {
                    recoveryDone.await(30000L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    DistributedTestCase.fail("interrupted", e);
                }
            }
        };
    }

    public void testColocatedPRsRecoveryOneMemberLater() throws Throwable {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        SerializableRunnable createParentPR = new SerializableRunnable("createParentPR"){

            @Override
            public void run() {
                Cache cache = PersistentColocatedPartitionedRegionDUnitTest.this.getCache();
                DiskStore ds = cache.findDiskStore("disk");
                if (ds == null) {
                    ds = cache.createDiskStoreFactory().setDiskDirs(CacheTestCase.getDiskDirs()).create("disk");
                }
                AttributesFactory af = new AttributesFactory();
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setRedundantCopies(1);
                af.setPartitionAttributes(paf.create());
                af.setDataPolicy(DataPolicy.PERSISTENT_PARTITION);
                af.setDiskStoreName("disk");
                cache.createRegion(PersistentPartitionedRegionTestBase.PR_REGION_NAME, af.create());
            }
        };
        SerializableRunnable createChildPR = this.getCreateChildPRRunnable();
        vm0.invoke(createParentPR);
        vm1.invoke(createParentPR);
        vm2.invoke(createParentPR);
        vm0.invoke(createChildPR);
        vm1.invoke(createChildPR);
        vm2.invoke(createChildPR);
        this.createData(vm0, 0, 15, "a");
        this.createData(vm0, 0, 15, "b", "region2");
        Set<Integer> vm0Buckets = this.getBucketList(vm0, PR_REGION_NAME);
        PersistentColocatedPartitionedRegionDUnitTest.assertEquals(vm0Buckets, this.getBucketList(vm0, "region2"));
        Set<Integer> vm1Buckets = this.getBucketList(vm1, PR_REGION_NAME);
        PersistentColocatedPartitionedRegionDUnitTest.assertEquals(vm1Buckets, this.getBucketList(vm1, "region2"));
        Set<Integer> vm2Buckets = this.getBucketList(vm2, PR_REGION_NAME);
        PersistentColocatedPartitionedRegionDUnitTest.assertEquals(vm2Buckets, this.getBucketList(vm2, "region2"));
        Set<Integer> vm0PrimaryBuckets = this.getPrimaryBucketList(vm0, PR_REGION_NAME);
        PersistentColocatedPartitionedRegionDUnitTest.assertEquals(vm0PrimaryBuckets, this.getPrimaryBucketList(vm0, "region2"));
        Set<Integer> vm1PrimaryBuckets = this.getPrimaryBucketList(vm1, PR_REGION_NAME);
        PersistentColocatedPartitionedRegionDUnitTest.assertEquals(vm1PrimaryBuckets, this.getPrimaryBucketList(vm1, "region2"));
        Set<Integer> vm2PrimaryBuckets = this.getPrimaryBucketList(vm2, PR_REGION_NAME);
        PersistentColocatedPartitionedRegionDUnitTest.assertEquals(vm2PrimaryBuckets, this.getPrimaryBucketList(vm2, "region2"));
        this.closeCache(vm2);
        Thread.sleep(4000L);
        this.closeCache(vm0);
        this.closeCache(vm1);
        AsyncInvocation async0 = vm0.invokeAsync(createParentPR);
        AsyncInvocation async1 = vm1.invokeAsync(createParentPR);
        async0.getResult(30000L);
        async1.getResult(30000L);
        vm0.invoke(createChildPR);
        vm1.invoke(createChildPR);
        this.waitForBucketRecovery(vm0, vm0Buckets);
        this.waitForBucketRecovery(vm1, vm1Buckets);
        this.checkData(vm0, 0, 15, "a");
        this.checkData(vm0, 0, 15, null, "region2");
        this.createData(vm0, 0, 15, "c", "region2");
        this.checkData(vm0, 0, 15, "c", "region2");
        vm2.invoke(createParentPR);
        PersistentColocatedPartitionedRegionDUnitTest.assertEquals(Collections.emptySet(), this.getBucketList(vm2, PR_REGION_NAME));
        vm2.invoke(createChildPR);
        PersistentColocatedPartitionedRegionDUnitTest.assertEquals(vm2Buckets, this.getBucketList(vm2, PR_REGION_NAME));
        PersistentColocatedPartitionedRegionDUnitTest.assertEquals(vm2Buckets, this.getBucketList(vm2, "region2"));
        vm0PrimaryBuckets = this.getPrimaryBucketList(vm0, PR_REGION_NAME);
        PersistentColocatedPartitionedRegionDUnitTest.assertEquals(vm0PrimaryBuckets, this.getPrimaryBucketList(vm0, "region2"));
        vm1PrimaryBuckets = this.getPrimaryBucketList(vm1, PR_REGION_NAME);
        PersistentColocatedPartitionedRegionDUnitTest.assertEquals(vm1PrimaryBuckets, this.getPrimaryBucketList(vm1, "region2"));
        vm2PrimaryBuckets = this.getPrimaryBucketList(vm2, PR_REGION_NAME);
        PersistentColocatedPartitionedRegionDUnitTest.assertEquals(vm2PrimaryBuckets, this.getPrimaryBucketList(vm2, "region2"));
    }

    public void testReplaceOfflineMemberAndRestart() throws Throwable {
        SerializableRunnable createPRs = new SerializableRunnable("region1"){

            @Override
            public void run() {
                Cache cache = PersistentColocatedPartitionedRegionDUnitTest.this.getCache();
                DiskStore ds = cache.findDiskStore("disk");
                if (ds == null) {
                    ds = cache.createDiskStoreFactory().setDiskDirs(CacheTestCase.getDiskDirs()).create("disk");
                }
                final CountDownLatch recoveryDone = new CountDownLatch(2);
                InternalResourceManager.ResourceObserverAdapter observer = new InternalResourceManager.ResourceObserverAdapter(){

                    public void recoveryFinished(Region region) {
                        recoveryDone.countDown();
                    }
                };
                InternalResourceManager.setResourceObserver((InternalResourceManager.ResourceObserver)observer);
                AttributesFactory af = new AttributesFactory();
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setRedundantCopies(1);
                paf.setRecoveryDelay(0L);
                af.setPartitionAttributes(paf.create());
                af.setDataPolicy(DataPolicy.PERSISTENT_PARTITION);
                af.setDiskStoreName("disk");
                cache.createRegion(PersistentPartitionedRegionTestBase.PR_REGION_NAME, af.create());
                paf.setColocatedWith(PersistentPartitionedRegionTestBase.PR_REGION_NAME);
                af.setPartitionAttributes(paf.create());
                cache.createRegion("region2", af.create());
                try {
                    if (!recoveryDone.await(30000L, TimeUnit.MILLISECONDS)) {
                        TestCase.fail((String)"timed out");
                    }
                }
                catch (InterruptedException e) {
                    DistributedTestCase.fail("interrupted", e);
                }
            }
        };
        this.replaceOfflineMemberAndRestart(createPRs);
    }

    public void testReplaceOfflineMemberAndRestartTwoDiskStores() throws Throwable {
        SerializableRunnable createPRs = new SerializableRunnable("region1"){

            @Override
            public void run() {
                Cache cache = PersistentColocatedPartitionedRegionDUnitTest.this.getCache();
                DiskStore ds = cache.findDiskStore("disk");
                if (ds == null) {
                    ds = cache.createDiskStoreFactory().setDiskDirs(CacheTestCase.getDiskDirs()).create("disk");
                }
                final CountDownLatch recoveryDone = new CountDownLatch(2);
                InternalResourceManager.ResourceObserverAdapter observer = new InternalResourceManager.ResourceObserverAdapter(){

                    public void recoveryFinished(Region region) {
                        recoveryDone.countDown();
                    }
                };
                InternalResourceManager.setResourceObserver((InternalResourceManager.ResourceObserver)observer);
                AttributesFactory af = new AttributesFactory();
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setRedundantCopies(1);
                paf.setRecoveryDelay(0L);
                af.setPartitionAttributes(paf.create());
                af.setDataPolicy(DataPolicy.PERSISTENT_PARTITION);
                af.setDiskStoreName("disk");
                cache.createRegion(PersistentPartitionedRegionTestBase.PR_REGION_NAME, af.create());
                DiskStore ds2 = cache.findDiskStore("disk2");
                if (ds2 == null) {
                    ds2 = cache.createDiskStoreFactory().setDiskDirs(CacheTestCase.getDiskDirs()).create("disk2");
                }
                paf.setColocatedWith(PersistentPartitionedRegionTestBase.PR_REGION_NAME);
                af.setPartitionAttributes(paf.create());
                af.setDiskStoreName("disk2");
                cache.createRegion("region2", af.create());
                try {
                    if (!recoveryDone.await(30000L, TimeUnit.MILLISECONDS)) {
                        TestCase.fail((String)"timed out");
                    }
                }
                catch (InterruptedException e) {
                    DistributedTestCase.fail("interrupted", e);
                }
            }
        };
        this.replaceOfflineMemberAndRestart(createPRs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceOfflineMemberAndRestart(SerializableRunnable createPRs) throws Throwable {
        PersistentColocatedPartitionedRegionDUnitTest.disconnectAllFromDS();
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        vm0.invoke(createPRs);
        vm1.invoke(createPRs);
        vm2.invoke(createPRs);
        this.createData(vm0, 0, 15, "a");
        this.createData(vm0, 0, 15, "a", "region2");
        this.closeCache(vm2);
        this.waitForRedundancyRecovery(vm0, 1, PR_REGION_NAME);
        this.waitForRedundancyRecovery(vm0, 1, "region2");
        this.createData(vm0, 0, 15, "b");
        this.createData(vm0, 0, 15, "b", "region2");
        DistributedTestCase.ExpectedException expected = PersistentColocatedPartitionedRegionDUnitTest.addExpectedException("PartitionOfflineException");
        try {
            vm0.invoke(new SerializableCallable(){

                public Object call() throws Exception {
                    InternalDistributedSystem ds = (InternalDistributedSystem)PersistentColocatedPartitionedRegionDUnitTest.this.getCache().getDistributedSystem();
                    AdminDistributedSystemImpl.shutDownAllMembers((DM)ds.getDistributionManager(), (long)600000L);
                    return null;
                }
            });
            vm1.invoke(new SerializableRunnable(){

                @Override
                public void run() {
                    DistributedTestCase.system.disconnect();
                }
            });
            AsyncInvocation async0 = vm0.invokeAsync(createPRs);
            AsyncInvocation async1 = vm1.invokeAsync(createPRs);
            PersistentColocatedPartitionedRegionDUnitTest.pause(2000);
            AsyncInvocation async2 = vm2.invokeAsync(createPRs);
            async0.getResult(30000L);
            async1.getResult(30000L);
            async2.getResult(30000L);
            this.checkData(vm0, 0, 15, "b");
            this.checkData(vm0, 0, 15, "b", "region2");
            this.waitForRedundancyRecovery(vm0, 1, PR_REGION_NAME);
            this.waitForRedundancyRecovery(vm0, 1, "region2");
            int totalBucketCount = this.getBucketList(vm0).size();
            totalBucketCount += this.getBucketList(vm1).size();
            PersistentColocatedPartitionedRegionDUnitTest.assertEquals((int)30, (int)(totalBucketCount += this.getBucketList(vm2).size()));
            totalBucketCount = this.getBucketList(vm0, "region2").size();
            totalBucketCount += this.getBucketList(vm1, "region2").size();
            PersistentColocatedPartitionedRegionDUnitTest.assertEquals((int)30, (int)(totalBucketCount += this.getBucketList(vm2, "region2").size()));
        }
        finally {
            expected.remove();
        }
    }

    public void testReplaceOfflineMemberAndRestartCreateColocatedPRLate() throws Throwable {
        SerializableRunnable createParentPR = new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = PersistentColocatedPartitionedRegionDUnitTest.this.getCache();
                DiskStore ds = cache.findDiskStore("disk");
                if (ds == null) {
                    ds = cache.createDiskStoreFactory().setDiskDirs(CacheTestCase.getDiskDirs()).create("disk");
                }
                AttributesFactory af = new AttributesFactory();
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setRedundantCopies(1);
                paf.setRecoveryDelay(0L);
                af.setPartitionAttributes(paf.create());
                af.setDataPolicy(DataPolicy.PERSISTENT_PARTITION);
                af.setDiskStoreName("disk");
                cache.createRegion(PersistentPartitionedRegionTestBase.PR_REGION_NAME, af.create());
            }
        };
        SerializableRunnable createChildPR = new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = PersistentColocatedPartitionedRegionDUnitTest.this.getCache();
                final CountDownLatch recoveryDone = new CountDownLatch(1);
                InternalResourceManager.ResourceObserverAdapter observer = new InternalResourceManager.ResourceObserverAdapter(){

                    public void recoveryFinished(Region region) {
                        if (region.getName().contains("region2")) {
                            recoveryDone.countDown();
                        }
                    }
                };
                InternalResourceManager.setResourceObserver((InternalResourceManager.ResourceObserver)observer);
                AttributesFactory af = new AttributesFactory();
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setRedundantCopies(1);
                paf.setRecoveryDelay(0L);
                paf.setColocatedWith(PersistentPartitionedRegionTestBase.PR_REGION_NAME);
                af.setDataPolicy(DataPolicy.PERSISTENT_PARTITION);
                af.setDiskStoreName("disk");
                af.setPartitionAttributes(paf.create());
                cache.createRegion("region2", af.create());
                try {
                    if (!recoveryDone.await(30000L, TimeUnit.MILLISECONDS)) {
                        TestCase.fail((String)"timed out");
                    }
                }
                catch (InterruptedException e) {
                    DistributedTestCase.fail("interrupted", e);
                }
            }
        };
        this.replaceOfflineMemberAndRestartCreateColocatedPRLate(createParentPR, createChildPR);
    }

    public void testReplaceOfflineMemberAndRestartCreateColocatedPRLateTwoDiskStores() throws Throwable {
        SerializableRunnable createParentPR = new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = PersistentColocatedPartitionedRegionDUnitTest.this.getCache();
                DiskStore ds = cache.findDiskStore("disk");
                if (ds == null) {
                    ds = cache.createDiskStoreFactory().setDiskDirs(CacheTestCase.getDiskDirs()).create("disk");
                }
                AttributesFactory af = new AttributesFactory();
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setRedundantCopies(1);
                paf.setRecoveryDelay(0L);
                af.setPartitionAttributes(paf.create());
                af.setDataPolicy(DataPolicy.PERSISTENT_PARTITION);
                af.setDiskStoreName("disk");
                cache.createRegion(PersistentPartitionedRegionTestBase.PR_REGION_NAME, af.create());
            }
        };
        SerializableRunnable createChildPR = new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = PersistentColocatedPartitionedRegionDUnitTest.this.getCache();
                final CountDownLatch recoveryDone = new CountDownLatch(1);
                InternalResourceManager.ResourceObserverAdapter observer = new InternalResourceManager.ResourceObserverAdapter(){

                    public void recoveryFinished(Region region) {
                        if (region.getName().contains("region2")) {
                            recoveryDone.countDown();
                        }
                    }
                };
                InternalResourceManager.setResourceObserver((InternalResourceManager.ResourceObserver)observer);
                DiskStore ds2 = cache.findDiskStore("disk2");
                if (ds2 == null) {
                    ds2 = cache.createDiskStoreFactory().setDiskDirs(CacheTestCase.getDiskDirs()).create("disk2");
                }
                AttributesFactory af = new AttributesFactory();
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setRedundantCopies(1);
                paf.setRecoveryDelay(0L);
                paf.setColocatedWith(PersistentPartitionedRegionTestBase.PR_REGION_NAME);
                af.setDataPolicy(DataPolicy.PERSISTENT_PARTITION);
                af.setDiskStoreName("disk2");
                af.setPartitionAttributes(paf.create());
                cache.createRegion("region2", af.create());
                try {
                    if (!recoveryDone.await(30000L, TimeUnit.MILLISECONDS)) {
                        TestCase.fail((String)"timed out");
                    }
                }
                catch (InterruptedException e) {
                    DistributedTestCase.fail("interrupted", e);
                }
            }
        };
        this.replaceOfflineMemberAndRestartCreateColocatedPRLate(createParentPR, createChildPR);
    }

    public void replaceOfflineMemberAndRestartCreateColocatedPRLate(SerializableRunnable createParentPR, SerializableRunnable createChildPR) throws Throwable {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        vm0.invoke(createParentPR);
        vm1.invoke(createParentPR);
        vm2.invoke(createParentPR);
        vm0.invoke(createChildPR);
        vm1.invoke(createChildPR);
        vm2.invoke(createChildPR);
        this.createData(vm0, 0, 15, "a");
        this.createData(vm0, 0, 15, "a", "region2");
        this.closeCache(vm2);
        this.waitForRedundancyRecovery(vm0, 1, PR_REGION_NAME);
        this.waitForRedundancyRecovery(vm0, 1, "region2");
        this.createData(vm0, 0, 15, "b");
        this.createData(vm0, 0, 15, "b", "region2");
        vm0.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                InternalDistributedSystem ds = (InternalDistributedSystem)PersistentColocatedPartitionedRegionDUnitTest.this.getCache().getDistributedSystem();
                AdminDistributedSystemImpl.shutDownAllMembers((DM)ds.getDistributionManager(), (long)0L);
                return null;
            }
        });
        vm1.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                DistributedTestCase.system.disconnect();
            }
        });
        AsyncInvocation async2 = vm2.invokeAsync(createParentPR);
        AsyncInvocation async1 = vm1.invokeAsync(createParentPR);
        PersistentColocatedPartitionedRegionDUnitTest.pause(2000);
        AsyncInvocation async0 = vm0.invokeAsync(createParentPR);
        async0.getResult(30000L);
        async1.getResult(30000L);
        async2.getResult(30000L);
        PersistentColocatedPartitionedRegionDUnitTest.pause(2000);
        async2 = vm2.invokeAsync(createChildPR);
        async1 = vm1.invokeAsync(createChildPR);
        async0 = vm0.invokeAsync(createChildPR);
        async0.getResult(30000L);
        async1.getResult(30000L);
        async2.getResult(30000L);
        this.checkData(vm0, 0, 15, "b");
        this.checkData(vm0, 0, 15, "b", "region2");
        this.createData(vm0, 0, 15, "c", "region2");
        this.waitForRedundancyRecovery(vm0, 1, PR_REGION_NAME);
        this.waitForRedundancyRecovery(vm0, 1, "region2");
        int totalBucketCount = this.getBucketList(vm0).size();
        totalBucketCount += this.getBucketList(vm1).size();
        PersistentColocatedPartitionedRegionDUnitTest.assertEquals((int)30, (int)(totalBucketCount += this.getBucketList(vm2).size()));
        totalBucketCount = this.getBucketList(vm0, "region2").size();
        totalBucketCount += this.getBucketList(vm1, "region2").size();
        PersistentColocatedPartitionedRegionDUnitTest.assertEquals((int)30, (int)(totalBucketCount += this.getBucketList(vm2, "region2").size()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCrashDuringRedundancySatisfaction() throws Throwable {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        SerializableRunnable createPRs = new SerializableRunnable("region1"){

            @Override
            public void run() {
                Cache cache = PersistentColocatedPartitionedRegionDUnitTest.this.getCache();
                DiskStore ds = cache.findDiskStore("disk");
                if (ds == null) {
                    ds = cache.createDiskStoreFactory().setDiskDirs(CacheTestCase.getDiskDirs()).create("disk");
                }
                AttributesFactory af = new AttributesFactory();
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setRedundantCopies(1);
                paf.setRecoveryDelay(-1L);
                paf.setStartupRecoveryDelay(-1L);
                af.setPartitionAttributes(paf.create());
                af.setDataPolicy(DataPolicy.PERSISTENT_PARTITION);
                af.setDiskStoreName("disk");
                cache.createRegion(PersistentPartitionedRegionTestBase.PR_REGION_NAME, af.create());
                paf.setColocatedWith(PersistentPartitionedRegionTestBase.PR_REGION_NAME);
                af.setPartitionAttributes(paf.create());
                cache.createRegion("region2", af.create());
            }
        };
        vm0.invoke(createPRs);
        this.createData(vm0, 0, 15, "a");
        this.createData(vm0, 0, 15, "a", "region2");
        vm1.invoke(createPRs);
        PersistentColocatedPartitionedRegionDUnitTest.assertEquals(Collections.emptySet(), this.getBucketList(vm1));
        vm0.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                DistributionMessageObserver.setInstance((DistributionMessageObserver)new DistributionMessageObserver(){

                    public void beforeProcessMessage(DistributionManager dm, DistributionMessage message) {
                        if (message instanceof InitialImageOperation.RequestImageMessage && ((InitialImageOperation.RequestImageMessage)message).regionPath.contains("region2")) {
                            DistributionMessageObserver.setInstance(null);
                            CacheTestCase.disconnectFromDS();
                        }
                    }
                });
            }
        });
        DistributedTestCase.ExpectedException ex = PersistentColocatedPartitionedRegionDUnitTest.addExpectedException("PartitionOfflineException", vm1);
        try {
            block5: {
                try {
                    RebalanceResults rebalanceResults = this.rebalance(vm1);
                }
                catch (Exception expected) {
                    if (expected.getCause() instanceof PartitionOfflineException) break block5;
                    throw expected;
                }
            }
            vm0.invoke(new SerializableCallable(){

                public Object call() throws Exception {
                    DistributedTestCase.waitForCriterion(new DistributedTestCase.WaitCriterion(){

                        @Override
                        public boolean done() {
                            InternalDistributedSystem ds = DistributedTestCase.system;
                            return ds == null || !ds.isConnected();
                        }

                        @Override
                        public String description() {
                            return "DS did not disconnect";
                        }
                    }, 30000L, 100L, true);
                    return null;
                }
            });
            SerializableCallable disconnectFromDS = new SerializableCallable(){

                public Object call() throws Exception {
                    CacheTestCase.disconnectFromDS();
                    return null;
                }
            };
            vm1.invoke(disconnectFromDS);
            vm0.invoke(disconnectFromDS);
        }
        finally {
            ex.remove();
        }
        AsyncInvocation async0 = vm0.invokeAsync(createPRs);
        AsyncInvocation async1 = vm1.invokeAsync(createPRs);
        async0.getResult(30000L);
        async1.getResult(30000L);
        this.checkData(vm0, 0, 15, "a");
        this.checkData(vm0, 0, 15, "a", "region2");
    }

    public void testRecoverySystemWithConcurrentPutter() throws Throwable {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        SerializableRunnable createAccessor = new SerializableRunnable("createAccessor"){

            @Override
            public void run() {
                Cache cache = PersistentColocatedPartitionedRegionDUnitTest.this.getCache();
                AttributesFactory af = new AttributesFactory();
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setRedundantCopies(1);
                paf.setLocalMaxMemory(0);
                af.setPartitionAttributes(paf.create());
                af.setDataPolicy(DataPolicy.PARTITION);
                cache.createRegion(PersistentPartitionedRegionTestBase.PR_REGION_NAME, af.create());
                paf.setColocatedWith(PersistentPartitionedRegionTestBase.PR_REGION_NAME);
                af.setPartitionAttributes(paf.create());
                cache.createRegion("region2", af.create());
            }
        };
        SerializableRunnable createPRs = new SerializableRunnable("region1"){

            @Override
            public void run() {
                Cache cache = PersistentColocatedPartitionedRegionDUnitTest.this.getCache();
                DiskStore ds = cache.findDiskStore("disk");
                if (ds == null) {
                    ds = cache.createDiskStoreFactory().setDiskDirs(CacheTestCase.getDiskDirs()).create("disk");
                }
                AttributesFactory af = new AttributesFactory();
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setRedundantCopies(1);
                af.setPartitionAttributes(paf.create());
                af.setDataPolicy(DataPolicy.PERSISTENT_PARTITION);
                af.setDiskStoreName("disk");
                cache.createRegion(PersistentPartitionedRegionTestBase.PR_REGION_NAME, af.create());
                paf.setColocatedWith(PersistentPartitionedRegionTestBase.PR_REGION_NAME);
                af.setPartitionAttributes(paf.create());
                cache.createRegion("region2", af.create());
            }
        };
        SerializableRunnable closeCache = new SerializableRunnable("region1"){

            @Override
            public void run() {
                CacheTestCase.closeCache();
            }
        };
        SerializableRunnable doABunchOfPuts = new SerializableRunnable("region1"){

            @Override
            public void run() {
                Cache cache = PersistentColocatedPartitionedRegionDUnitTest.this.getCache();
                Region region = cache.getRegion(PersistentPartitionedRegionTestBase.PR_REGION_NAME);
                try {
                    int i = 0;
                    while (true) {
                        try {
                            region.get((Object)(i % 15));
                        }
                        catch (PartitionOfflineException partitionOfflineException) {
                        }
                        catch (PartitionedRegionStorageException partitionedRegionStorageException) {
                            // empty catch block
                        }
                        Thread.yield();
                        ++i;
                    }
                }
                catch (CacheClosedException cacheClosedException) {
                    return;
                }
            }
        };
        SerializableRunnable cleanDiskDirs = new SerializableRunnable("Clean disk dirs"){

            @Override
            public void run() {
                try {
                    CacheTestCase.cleanDiskDirs();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        vm1.invoke(createPRs);
        vm2.invoke(createPRs);
        vm0.invoke(createAccessor);
        this.createData(vm0, 0, 15, "a");
        this.createData(vm0, 0, 15, "a", "region2");
        this.backup(vm3);
        vm1.invoke(closeCache);
        vm2.invoke(closeCache);
        vm1.invoke(cleanDiskDirs);
        vm2.invoke(cleanDiskDirs);
        this.restoreBackup(2);
        AsyncInvocation async0 = vm0.invokeAsync(doABunchOfPuts);
        AsyncInvocation async1 = vm1.invokeAsync(createPRs);
        AsyncInvocation async2 = vm2.invokeAsync(createPRs);
        async1.getResult(30000L);
        async2.getResult(30000L);
        vm0.invoke(closeCache);
        async0.getResult(30000L);
    }

    public void testRebalanceWithOfflineChildRegion() throws Throwable {
        SerializableRunnable createParentPR = new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = PersistentColocatedPartitionedRegionDUnitTest.this.getCache();
                DiskStore ds = cache.findDiskStore("disk");
                if (ds == null) {
                    ds = cache.createDiskStoreFactory().setDiskDirs(CacheTestCase.getDiskDirs()).create("disk");
                }
                AttributesFactory af = new AttributesFactory();
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setRedundantCopies(0);
                paf.setRecoveryDelay(0L);
                af.setPartitionAttributes(paf.create());
                af.setDataPolicy(DataPolicy.PERSISTENT_PARTITION);
                af.setDiskStoreName("disk");
                cache.createRegion(PersistentPartitionedRegionTestBase.PR_REGION_NAME, af.create());
            }
        };
        SerializableRunnable createChildPR = new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = PersistentColocatedPartitionedRegionDUnitTest.this.getCache();
                AttributesFactory af = new AttributesFactory();
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setRedundantCopies(0);
                paf.setRecoveryDelay(0L);
                paf.setColocatedWith(PersistentPartitionedRegionTestBase.PR_REGION_NAME);
                af.setDataPolicy(DataPolicy.PERSISTENT_PARTITION);
                af.setDiskStoreName("disk");
                af.setPartitionAttributes(paf.create());
                cache.createRegion("region2", af.create());
            }
        };
        this.rebalanceWithOfflineChildRegion(createParentPR, createChildPR);
    }

    public void testRebalanceWithOfflineChildRegionTwoDiskStores() throws Throwable {
        SerializableRunnable createParentPR = new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = PersistentColocatedPartitionedRegionDUnitTest.this.getCache();
                DiskStore ds = cache.findDiskStore("disk");
                if (ds == null) {
                    ds = cache.createDiskStoreFactory().setDiskDirs(CacheTestCase.getDiskDirs()).create("disk");
                }
                AttributesFactory af = new AttributesFactory();
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setRedundantCopies(0);
                paf.setRecoveryDelay(0L);
                af.setPartitionAttributes(paf.create());
                af.setDataPolicy(DataPolicy.PERSISTENT_PARTITION);
                af.setDiskStoreName("disk");
                cache.createRegion(PersistentPartitionedRegionTestBase.PR_REGION_NAME, af.create());
            }
        };
        SerializableRunnable createChildPR = new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = PersistentColocatedPartitionedRegionDUnitTest.this.getCache();
                DiskStore ds2 = cache.findDiskStore("disk2");
                if (ds2 == null) {
                    ds2 = cache.createDiskStoreFactory().setDiskDirs(CacheTestCase.getDiskDirs()).create("disk2");
                }
                AttributesFactory af = new AttributesFactory();
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setRedundantCopies(0);
                paf.setRecoveryDelay(0L);
                paf.setColocatedWith(PersistentPartitionedRegionTestBase.PR_REGION_NAME);
                af.setDataPolicy(DataPolicy.PERSISTENT_PARTITION);
                af.setDiskStoreName("disk2");
                af.setPartitionAttributes(paf.create());
                cache.createRegion("region2", af.create());
            }
        };
        this.rebalanceWithOfflineChildRegion(createParentPR, createChildPR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testModifyColocation() throws Throwable {
        this.createColocatedPRs("region1");
        PersistentColocatedPartitionedRegionDUnitTest.closeCache();
        DistributedTestCase.ExpectedException ex = PersistentColocatedPartitionedRegionDUnitTest.addExpectedException("DiskAccessException|IllegalStateException");
        try {
            this.createColocatedPRs("region2");
            PersistentColocatedPartitionedRegionDUnitTest.fail((String)"Should have received an illegal state exception");
        }
        catch (IllegalStateException illegalStateException) {
        }
        finally {
            ex.remove();
        }
        PersistentColocatedPartitionedRegionDUnitTest.closeCache();
        this.createColocatedPRs("/region1");
        PersistentColocatedPartitionedRegionDUnitTest.closeCache();
        ex = PersistentColocatedPartitionedRegionDUnitTest.addExpectedException("DiskAccessException|IllegalStateException");
        try {
            this.createColocatedPRs(null);
            PersistentColocatedPartitionedRegionDUnitTest.fail((String)"Should have received an illegal state exception");
        }
        catch (IllegalStateException illegalStateException) {
        }
        finally {
            ex.remove();
        }
        PersistentColocatedPartitionedRegionDUnitTest.closeCache();
    }

    private void createColocatedPRs(String colocatedWith) {
        Cache cache = this.getCache();
        DiskStore ds = cache.findDiskStore("disk");
        if (ds == null) {
            ds = cache.createDiskStoreFactory().setDiskDirs(PersistentColocatedPartitionedRegionDUnitTest.getDiskDirs()).create("disk");
        }
        AttributesFactory af = new AttributesFactory();
        PartitionAttributesFactory paf = new PartitionAttributesFactory();
        paf.setRedundantCopies(0);
        af.setPartitionAttributes(paf.create());
        af.setDataPolicy(DataPolicy.PERSISTENT_PARTITION);
        af.setDiskStoreName("disk");
        cache.createRegion("region1", af.create());
        cache.createRegion("region2", af.create());
        if (colocatedWith != null) {
            paf.setColocatedWith(colocatedWith);
        }
        af.setPartitionAttributes(paf.create());
        cache.createRegion("region3", af.create());
    }

    public void rebalanceWithOfflineChildRegion(SerializableRunnable createParentPR, SerializableRunnable createChildPR) throws Throwable {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        vm0.invoke(createParentPR);
        vm1.invoke(createParentPR);
        vm0.invoke(createChildPR);
        vm1.invoke(createChildPR);
        this.createData(vm0, 0, 15, "a");
        this.createData(vm0, 0, 15, "a", "region2");
        this.closeCache(vm1);
        this.closeCache(vm0);
        AsyncInvocation async0 = vm0.invokeAsync(createParentPR);
        AsyncInvocation async1 = vm1.invokeAsync(createParentPR);
        async0.getResult(30000L);
        async1.getResult(30000L);
        vm2.invoke(createParentPR);
        RebalanceResults rebalanceResults = this.rebalance(vm2);
        PersistentColocatedPartitionedRegionDUnitTest.assertEquals((int)0, (int)rebalanceResults.getTotalBucketTransfersCompleted());
        async1 = vm1.invokeAsync(createChildPR);
        async0 = vm0.invokeAsync(createChildPR);
        AsyncInvocation async2 = vm2.invokeAsync(createChildPR);
        async0.getResult(30000L);
        async1.getResult(30000L);
        async2.getResult(30000L);
        this.checkData(vm0, 0, 15, "a");
        this.checkData(vm0, 0, 15, "a", "region2");
        this.createData(vm0, 0, 15, "c", "region2");
    }

    private RebalanceResults rebalance(VM vm) {
        return (RebalanceResults)vm.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                RebalanceOperation op = PersistentColocatedPartitionedRegionDUnitTest.this.getCache().getResourceManager().createRebalanceFactory().start();
                return op.getResults();
            }
        });
    }
}

