/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.partitioned;

import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheWriter;
import com.gemstone.gemfire.cache.Declarable;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.util.CacheWriterAdapter;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.internal.cache.DiskStoreImpl;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.partitioned.PersistentPartitionedRegionTestBase;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.util.Properties;
import junit.framework.TestCase;

public class PersistPRKRFDUnitTest
extends PersistentPartitionedRegionTestBase {
    private static final int NUM_BUCKETS = 15;
    private static final int MAX_WAIT = 30000;
    static Object lockObject = new Object();

    public PersistPRKRFDUnitTest(String name) {
        super(name);
    }

    public void testCloseDiskStoreWhenPut() {
        String title = "testCloseDiskStoreWhenPut:";
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        this.createPR(vm0, 0);
        this.createData(vm0, 0, 10, "a");
        vm0.invoke(new CacheSerializableRunnable("testCloseDiskStoreWhenPut:server add writer"){

            @Override
            public void run2() throws CacheException {
                Region region = PersistPRKRFDUnitTest.this.getRootRegion(PersistentPartitionedRegionTestBase.PR_REGION_NAME);
                if (!DiskStoreImpl.KRF_DEBUG) {
                    region.getAttributesMutator().setCacheWriter((CacheWriter)new MyWriter());
                }
            }
        });
        AsyncInvocation async1 = vm0.invokeAsync(new CacheSerializableRunnable("testCloseDiskStoreWhenPut:async create"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run2() throws CacheException {
                Region region = PersistPRKRFDUnitTest.this.getRootRegion(PersistentPartitionedRegionTestBase.PR_REGION_NAME);
                DistributedTestCase.ExpectedException expect = DistributedTestCase.addExpectedException("CacheClosedException");
                try {
                    region.put((Object)10, (Object)"b");
                    TestCase.fail((String)"Expect CacheClosedException here");
                }
                catch (CacheClosedException cce) {
                    System.out.println("testCloseDiskStoreWhenPut:" + cce.getMessage());
                    if (DiskStoreImpl.KRF_DEBUG ? !$assertionsDisabled && !cce.getMessage().contains("The disk store is closed.") : !$assertionsDisabled && !cce.getMessage().contains("The disk store is closed")) {
                        throw new AssertionError();
                    }
                }
                finally {
                    expect.remove();
                }
            }
        });
        vm0.invoke(new CacheSerializableRunnable("testCloseDiskStoreWhenPut:close disk store"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run2() throws CacheException {
                GemFireCacheImpl gfc = (GemFireCacheImpl)PersistPRKRFDUnitTest.this.getCache();
                DistributedTestCase.pause(500);
                gfc.closeDiskStores();
                Object object = lockObject;
                synchronized (object) {
                    lockObject.notify();
                }
            }
        });
        DistributedTestCase.join(async1, 30000L, PersistPRKRFDUnitTest.getLogWriter());
        this.closeCache(vm0);
        this.createPR(vm0, 0);
        vm0.invoke(new CacheSerializableRunnable("testCloseDiskStoreWhenPut:server add writer"){

            @Override
            public void run2() throws CacheException {
                Region region = PersistPRKRFDUnitTest.this.getRootRegion(PersistentPartitionedRegionTestBase.PR_REGION_NAME);
                if (!DiskStoreImpl.KRF_DEBUG) {
                    region.getAttributesMutator().setCacheWriter((CacheWriter)new MyWriter());
                }
            }
        });
        async1 = vm0.invokeAsync(new CacheSerializableRunnable("testCloseDiskStoreWhenPut:async update"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run2() throws CacheException {
                Region region = PersistPRKRFDUnitTest.this.getRootRegion(PersistentPartitionedRegionTestBase.PR_REGION_NAME);
                DistributedTestCase.ExpectedException expect = DistributedTestCase.addExpectedException("CacheClosedException");
                try {
                    region.put((Object)1, (Object)"b");
                    TestCase.fail((String)"Expect CacheClosedException here");
                }
                catch (CacheClosedException cce) {
                    System.out.println("testCloseDiskStoreWhenPut:" + cce.getMessage());
                    if (DiskStoreImpl.KRF_DEBUG ? !$assertionsDisabled && !cce.getMessage().contains("The disk store is closed.") : !$assertionsDisabled && !cce.getMessage().contains("The disk store is closed")) {
                        throw new AssertionError();
                    }
                }
                finally {
                    expect.remove();
                }
            }
        });
        vm0.invoke(new CacheSerializableRunnable("testCloseDiskStoreWhenPut:close disk store"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run2() throws CacheException {
                GemFireCacheImpl gfc = (GemFireCacheImpl)PersistPRKRFDUnitTest.this.getCache();
                DistributedTestCase.pause(500);
                gfc.closeDiskStores();
                Object object = lockObject;
                synchronized (object) {
                    lockObject.notify();
                }
            }
        });
        DistributedTestCase.join(async1, 30000L, PersistPRKRFDUnitTest.getLogWriter());
        this.closeCache(vm0);
        this.createPR(vm0, 0);
        vm0.invoke(new CacheSerializableRunnable("testCloseDiskStoreWhenPut:server add writer"){

            @Override
            public void run2() throws CacheException {
                Region region = PersistPRKRFDUnitTest.this.getRootRegion(PersistentPartitionedRegionTestBase.PR_REGION_NAME);
                if (!DiskStoreImpl.KRF_DEBUG) {
                    region.getAttributesMutator().setCacheWriter((CacheWriter)new MyWriter());
                }
            }
        });
        async1 = vm0.invokeAsync(new CacheSerializableRunnable("testCloseDiskStoreWhenPut:async destroy"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run2() throws CacheException {
                Region region = PersistPRKRFDUnitTest.this.getRootRegion(PersistentPartitionedRegionTestBase.PR_REGION_NAME);
                DistributedTestCase.ExpectedException expect = DistributedTestCase.addExpectedException("CacheClosedException");
                try {
                    region.destroy((Object)2, (Object)"b");
                    TestCase.fail((String)"Expect CacheClosedException here");
                }
                catch (CacheClosedException cce) {
                    System.out.println("testCloseDiskStoreWhenPut:" + cce.getMessage());
                    if (DiskStoreImpl.KRF_DEBUG ? !$assertionsDisabled && !cce.getMessage().contains("The disk store is closed.") : !$assertionsDisabled && !cce.getMessage().contains("The disk store is closed")) {
                        throw new AssertionError();
                    }
                }
                finally {
                    expect.remove();
                }
            }
        });
        vm0.invoke(new CacheSerializableRunnable("testCloseDiskStoreWhenPut:close disk store"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run2() throws CacheException {
                GemFireCacheImpl gfc = (GemFireCacheImpl)PersistPRKRFDUnitTest.this.getCache();
                DistributedTestCase.pause(500);
                gfc.closeDiskStores();
                Object object = lockObject;
                synchronized (object) {
                    lockObject.notify();
                }
            }
        });
        DistributedTestCase.join(async1, 30000L, PersistPRKRFDUnitTest.getLogWriter());
        this.checkData(vm0, 0, 10, "a");
        this.checkData(vm0, 10, 11, null);
        this.closeCache(vm0);
    }

    private static class MyWriter
    extends CacheWriterAdapter
    implements Declarable {
        public void init(Properties props) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void beforeCreate(EntryEvent event) {
            try {
                Object object = lockObject;
                synchronized (object) {
                    lockObject.wait();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void beforeUpdate(EntryEvent event) {
            try {
                Object object = lockObject;
                synchronized (object) {
                    lockObject.wait();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void beforeDestroy(EntryEvent event) {
            try {
                Object object = lockObject;
                synchronized (object) {
                    lockObject.wait();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

