/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.partitioned;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionShortcut;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.internal.cache.DistributedPutAllOperation;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.EntrySnapshot;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.tier.sockets.VersionedObjectList;
import com.gemstone.gemfire.internal.cache.versions.ConcurrentCacheModificationException;
import com.gemstone.gemfire.internal.cache.versions.VersionTag;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.util.HashMap;
import junit.framework.TestCase;

public class ElidedPutAllDUnitTest
extends CacheTestCase {
    private static final long serialVersionUID = -184003583877999750L;

    public ElidedPutAllDUnitTest(String name) {
        super(name);
    }

    public void testElidedPutAllOnPR() throws Exception {
        final String regionName = this.getUniqueName() + "Region";
        String key = "key-1";
        Cache cache = this.getCache();
        PartitionedRegion region = (PartitionedRegion)cache.createRegionFactory(RegionShortcut.PARTITION).create(regionName);
        region.put((Object)"key-1", (Object)"value-1");
        region.put((Object)"key-1", (Object)"value-2");
        Region.Entry entry = region.getEntry((Object)"key-1");
        ElidedPutAllDUnitTest.assertTrue((String)"expected entry to be in this vm", (entry != null ? 1 : 0) != 0);
        VM vm1 = Host.getHost(0).getVM(1);
        vm1.invoke(new SerializableRunnable("perform conflicting update"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Cache cache = ElidedPutAllDUnitTest.this.getCache();
                PartitionedRegion region = (PartitionedRegion)cache.createRegionFactory(RegionShortcut.PARTITION).create(regionName);
                try {
                    Region.Entry entry = region.getEntry((Object)"key-1");
                    TestCase.assertTrue((boolean)(entry instanceof EntrySnapshot));
                    RegionEntry regionEntry = ((EntrySnapshot)entry).getRegionEntry();
                    VersionTag tag = regionEntry.getVersionStamp().asVersionTag();
                    tag.setEntryVersion(tag.getEntryVersion() - 1);
                    tag.setRegionVersion(1L);
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("key-1", "value-3");
                    DistributedPutAllOperation dpao = region.newPutAllOperation(map);
                    EntryEventImpl event = EntryEventImpl.create((LocalRegion)region, (Operation)Operation.PUTALL_CREATE, null, null, null, (boolean)true, (DistributedMember)((DistributedMember)tag.getMemberID()));
                    event.setOldValue((Object)"value-1");
                    event.setVersionTag(tag);
                    event.setEventId(new EventID(cache.getDistributedSystem()));
                    event.setKeyInfo(region.getKeyInfo((Object)"key-1"));
                    dpao.addEntry(event, Integer.valueOf(event.getBucketId()));
                    VersionedObjectList successfulPuts = new VersionedObjectList(1, true, true);
                    successfulPuts.addKeyAndVersion((Object)"key-1", tag);
                    try {
                        region.postPutAllSend(dpao, null, successfulPuts);
                    }
                    catch (ConcurrentCacheModificationException e) {
                        DistributedTestCase.fail("Should not have received an exception for an elided operation", e);
                    }
                    finally {
                        event.release();
                        dpao.getBaseEvent().release();
                        dpao.freeOffHeapResources();
                    }
                }
                catch (Exception e) {
                    DistributedTestCase.fail("caught unexpected exception", e);
                }
            }
        });
        entry = region.getEntry((Object)"key-1");
        ElidedPutAllDUnitTest.assertTrue((String)("expected value-2: " + entry.getValue()), (boolean)entry.getValue().equals("value-2"));
        RegionEntry regionEntry = ((EntrySnapshot)entry).getRegionEntry();
        VersionTag tag = regionEntry.getVersionStamp().asVersionTag();
        ElidedPutAllDUnitTest.assertTrue((tag.getEntryVersion() == 2 ? 1 : 0) != 0);
    }
}

