/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.execute;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.client.internal.ClientMetadataService;
import com.gemstone.gemfire.cache.client.internal.ClientPartitionAdvisor;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.execute.PRClientServerTestBase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SingleHopGetAllPutAllDUnitTest
extends PRClientServerTestBase {
    private static final long serialVersionUID = 3873751456134028508L;

    public SingleHopGetAllPutAllDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    public void testServerGetAllFunction() {
        this.createScenario();
        client.invoke(SingleHopGetAllPutAllDUnitTest.class, "getAll");
    }

    private void createScenario() {
        ArrayList commonAttributes = this.createCommonServerAttributes("TestPartitionedRegion", null, 1, 13, null);
        this.createClientServerScenarioSingleHop(commonAttributes, 20, 20, 20);
    }

    public static void getAll() {
        Region region = cache.getRegion(PartitionedRegionName);
        SingleHopGetAllPutAllDUnitTest.assertNotNull((Object)region);
        ArrayList<String> testKeysList = new ArrayList<String>();
        for (int i = totalNumBuckets * 3; i > 0; --i) {
            testKeysList.add("execKey-" + i);
        }
        DistributedSystem.setThreadsSocketPolicy((boolean)false);
        try {
            int j = 0;
            HashMap origVals = new HashMap();
            Iterator i = testKeysList.iterator();
            while (i.hasNext()) {
                Integer val = new Integer(j++);
                Object key = i.next();
                origVals.put(key, val);
                region.put(key, (Object)val);
            }
            SingleHopGetAllPutAllDUnitTest.verifyMetadata();
            Map resultMap = region.getAll(testKeysList);
            SingleHopGetAllPutAllDUnitTest.assertTrue((boolean)resultMap.equals(origVals));
            SingleHopGetAllPutAllDUnitTest.pause(2000);
            Map secondResultMap = region.getAll(testKeysList);
            SingleHopGetAllPutAllDUnitTest.assertTrue((boolean)secondResultMap.equals(origVals));
        }
        catch (Exception e) {
            SingleHopGetAllPutAllDUnitTest.fail("Test failed after the getAll operation", e);
        }
    }

    private static void verifyMetadata() {
        Region region = cache.getRegion(PartitionedRegionName);
        ClientMetadataService cms = ((GemFireCacheImpl)cache).getClientMetadataService();
        Map regionMetaData = cms.getClientPRMetadata_TEST_ONLY();
        SingleHopGetAllPutAllDUnitTest.assertEquals((int)1, (int)regionMetaData.size());
        SingleHopGetAllPutAllDUnitTest.assertTrue((boolean)regionMetaData.containsKey(region.getFullPath()));
        ClientPartitionAdvisor prMetaData = (ClientPartitionAdvisor)regionMetaData.get(region.getFullPath());
        SingleHopGetAllPutAllDUnitTest.assertEquals((int)13, (int)prMetaData.getBucketServerLocationsMap_TEST_ONLY().size());
        for (Map.Entry entry : prMetaData.getBucketServerLocationsMap_TEST_ONLY().entrySet()) {
            SingleHopGetAllPutAllDUnitTest.assertEquals((int)2, (int)((List)entry.getValue()).size());
        }
    }

    public void testServerPutAllFunction() {
        this.createScenario();
        client.invoke(SingleHopGetAllPutAllDUnitTest.class, "putAll");
    }

    public static void putAll() {
        Region region = cache.getRegion(PartitionedRegionName);
        SingleHopGetAllPutAllDUnitTest.assertNotNull((Object)region);
        HashMap<String, String> keysValuesMap = new HashMap<String, String>();
        ArrayList<String> testKeysList = new ArrayList<String>();
        for (int i = totalNumBuckets * 3; i > 0; --i) {
            testKeysList.add("execKey-" + i);
            keysValuesMap.put("execKey-" + i, "values-" + i);
        }
        DistributedSystem.setThreadsSocketPolicy((boolean)false);
        try {
            region.putAll(keysValuesMap);
            SingleHopGetAllPutAllDUnitTest.pause(2000);
            region.putAll(keysValuesMap);
            SingleHopGetAllPutAllDUnitTest.verifyMetadata();
            Map resultMap = region.getAll(testKeysList);
            SingleHopGetAllPutAllDUnitTest.assertTrue((boolean)resultMap.equals(keysValuesMap));
            SingleHopGetAllPutAllDUnitTest.pause(2000);
            Map secondResultMap = region.getAll(testKeysList);
            SingleHopGetAllPutAllDUnitTest.assertTrue((boolean)secondResultMap.equals(keysValuesMap));
        }
        catch (Exception e) {
            SingleHopGetAllPutAllDUnitTest.fail("Test failed after the putAll operation", e);
        }
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
    }
}

