/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.execute;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.execute.RegionFunctionContext;
import com.gemstone.gemfire.internal.cache.execute.data.Order;
import com.gemstone.gemfire.internal.cache.execute.data.OrderId;
import com.gemstone.gemfire.internal.cache.execute.data.Shipment;
import com.gemstone.gemfire.internal.cache.execute.data.ShipmentId;
import java.util.ArrayList;

public class PerfFunction
implements Function {
    public void execute(FunctionContext context) {
        RegionFunctionContext ctx = (RegionFunctionContext)context;
        Region customerPR = ctx.getDataSet();
        Region orderPR = customerPR.getCache().getRegion("OrderPartitionedRegion");
        Region shipmentPR = customerPR.getCache().getRegion("ShipmentPartitionedRegion");
        ArrayList args = (ArrayList)ctx.getArguments();
        for (int i = 0; i < args.size() / 4; ++i) {
            OrderId orderId = (OrderId)args.get(i * 4);
            Order order = (Order)args.get(i * 4 + 1);
            ShipmentId shipmentId = (ShipmentId)args.get(i * 4 + 2);
            Shipment shipment = (Shipment)args.get(i * 4 + 3);
            orderPR.put((Object)orderId, (Object)order);
            shipmentPR.put((Object)shipmentId, (Object)shipment);
        }
        context.getResultSender().lastResult(null);
    }

    public boolean optimizeForWrite() {
        return true;
    }

    public String getId() {
        return "perfFunction";
    }

    public boolean hasResult() {
        return true;
    }

    public boolean isHA() {
        return false;
    }
}

