/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.execute;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.PartitionResolver;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.execute.Execution;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionAdapter;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.execute.RegionFunctionContext;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.ColocationHelper;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.TXStateInterface;
import com.gemstone.gemfire.internal.cache.control.InternalResourceManager;
import com.gemstone.gemfire.internal.cache.execute.CustomerIDPartitionResolver;
import com.gemstone.gemfire.internal.cache.execute.DummyKeyBasedRoutingResolver;
import com.gemstone.gemfire.internal.cache.execute.data.CustId;
import com.gemstone.gemfire.internal.cache.execute.data.Customer;
import com.gemstone.gemfire.internal.cache.execute.data.Order;
import com.gemstone.gemfire.internal.cache.execute.data.OrderId;
import com.gemstone.gemfire.internal.cache.execute.data.Shipment;
import com.gemstone.gemfire.internal.cache.execute.data.ShipmentId;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.SerializableRunnable;
import dunit.VM;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;

public class PRColocationDUnitTest
extends CacheTestCase {
    VM accessor = null;
    VM dataStore1 = null;
    VM dataStore2 = null;
    VM dataStore3 = null;
    protected static Cache cache = null;
    protected static int totalNumBucketsInTest = 0;
    protected static int defaultStringSize = 0;
    static final String CustomerPartitionedRegionName = "CustomerPartitionedRegion";
    static final String OrderPartitionedRegionName = "OrderPartitionedRegion";
    static final String ShipmentPartitionedRegionName = "ShipmentPartitionedRegion";
    String regionName = null;
    Integer redundancy = null;
    Integer localMaxmemory = null;
    Integer totalNumBuckets = null;
    String colocatedWith = null;
    Boolean isPartitionResolver = null;
    Object[] attributeObjects = null;

    public PRColocationDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Host host = Host.getHost(0);
        this.dataStore1 = host.getVM(0);
        this.dataStore2 = host.getVM(1);
        this.dataStore3 = host.getVM(2);
        this.accessor = host.getVM(3);
    }

    public void testDestroyColocatedPartitionedRegion() throws Throwable {
        this.createCacheInAllVms();
        this.redundancy = new Integer(0);
        this.localMaxmemory = new Integer(50);
        this.totalNumBuckets = new Integer(11);
        this.regionName = "A";
        this.colocatedWith = null;
        this.isPartitionResolver = new Boolean(true);
        this.attributeObjects = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, this.colocatedWith, this.isPartitionResolver};
        this.createPartitionedRegion(this.attributeObjects);
        this.regionName = "B";
        this.colocatedWith = "/A";
        this.isPartitionResolver = new Boolean(true);
        this.attributeObjects = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, this.colocatedWith, this.isPartitionResolver};
        this.createPartitionedRegion(this.attributeObjects);
        this.regionName = "C";
        this.colocatedWith = "/A";
        this.isPartitionResolver = new Boolean(true);
        this.attributeObjects = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, this.colocatedWith, this.isPartitionResolver};
        this.createPartitionedRegion(this.attributeObjects);
        this.attributeObjects = new Object[]{"/A"};
        this.dataStore1.invoke(PRColocationDUnitTest.class, "destroyPR", this.attributeObjects);
    }

    public void testColocatedPartitionedRegion() throws Throwable {
        this.createCacheInAllVms();
        this.redundancy = new Integer(0);
        this.localMaxmemory = new Integer(50);
        this.totalNumBuckets = new Integer(11);
        this.regionName = "A";
        this.colocatedWith = null;
        this.isPartitionResolver = new Boolean(true);
        this.attributeObjects = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, this.colocatedWith, this.isPartitionResolver};
        this.createPartitionedRegion(this.attributeObjects);
        this.regionName = "B";
        this.colocatedWith = "/A";
        this.isPartitionResolver = new Boolean(true);
        this.attributeObjects = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, this.colocatedWith, this.isPartitionResolver};
        this.createPartitionedRegion(this.attributeObjects);
        this.regionName = "C";
        this.colocatedWith = "/A";
        this.isPartitionResolver = new Boolean(true);
        this.attributeObjects = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, this.colocatedWith, this.isPartitionResolver};
        this.createPartitionedRegion(this.attributeObjects);
        this.regionName = "D";
        this.colocatedWith = "/B";
        this.attributeObjects = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, this.colocatedWith, this.isPartitionResolver};
        this.createPartitionedRegion(this.attributeObjects);
        this.regionName = "E";
        this.colocatedWith = "/B";
        this.isPartitionResolver = new Boolean(true);
        this.attributeObjects = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, this.colocatedWith, this.isPartitionResolver};
        this.createPartitionedRegion(this.attributeObjects);
        this.regionName = "F";
        this.colocatedWith = "/B";
        this.isPartitionResolver = new Boolean(true);
        this.attributeObjects = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, this.colocatedWith, this.isPartitionResolver};
        this.createPartitionedRegion(this.attributeObjects);
        this.regionName = "G";
        this.colocatedWith = "/C";
        this.isPartitionResolver = new Boolean(true);
        this.attributeObjects = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, this.colocatedWith, this.isPartitionResolver};
        this.createPartitionedRegion(this.attributeObjects);
        this.regionName = "H";
        this.colocatedWith = "/C";
        this.isPartitionResolver = new Boolean(true);
        this.attributeObjects = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, this.colocatedWith, this.isPartitionResolver};
        this.createPartitionedRegion(this.attributeObjects);
        this.regionName = "I";
        this.colocatedWith = "/C";
        this.isPartitionResolver = new Boolean(true);
        this.attributeObjects = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, this.colocatedWith, this.isPartitionResolver};
        this.createPartitionedRegion(this.attributeObjects);
        this.regionName = "J";
        this.colocatedWith = "/D";
        this.isPartitionResolver = new Boolean(true);
        this.attributeObjects = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, this.colocatedWith, this.isPartitionResolver};
        this.createPartitionedRegion(this.attributeObjects);
        this.regionName = "K";
        this.colocatedWith = "/D";
        this.isPartitionResolver = new Boolean(true);
        this.attributeObjects = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, this.colocatedWith, this.isPartitionResolver};
        this.createPartitionedRegion(this.attributeObjects);
        this.regionName = "L";
        this.colocatedWith = "/E";
        this.isPartitionResolver = new Boolean(true);
        this.attributeObjects = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, this.colocatedWith, this.isPartitionResolver};
        this.createPartitionedRegion(this.attributeObjects);
        this.regionName = "M";
        this.colocatedWith = "/F";
        this.isPartitionResolver = new Boolean(true);
        this.attributeObjects = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, this.colocatedWith, this.isPartitionResolver};
        this.createPartitionedRegion(this.attributeObjects);
        this.regionName = "N";
        this.colocatedWith = "/G";
        this.isPartitionResolver = new Boolean(true);
        this.attributeObjects = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, this.colocatedWith, this.isPartitionResolver};
        this.createPartitionedRegion(this.attributeObjects);
        this.regionName = "O";
        this.colocatedWith = "/I";
        this.isPartitionResolver = new Boolean(true);
        this.attributeObjects = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, this.colocatedWith, this.isPartitionResolver};
        this.createPartitionedRegion(this.attributeObjects);
        this.accessor.invoke(PRColocationDUnitTest.class, "validateColocatedRegions", new Object[]{"A"});
        this.accessor.invoke(PRColocationDUnitTest.class, "validateColocatedRegions", new Object[]{"D"});
        this.accessor.invoke(PRColocationDUnitTest.class, "validateColocatedRegions", new Object[]{"H"});
        this.accessor.invoke(PRColocationDUnitTest.class, "validateColocatedRegions", new Object[]{"B"});
        this.accessor.invoke(PRColocationDUnitTest.class, "validateColocatedRegions", new Object[]{"K"});
    }

    public void testColocatedPartitionedRegion_NoFullPath() throws Throwable {
        this.createCacheInAllVms();
        this.redundancy = new Integer(0);
        this.localMaxmemory = new Integer(50);
        this.totalNumBuckets = new Integer(11);
        this.regionName = "A";
        this.colocatedWith = null;
        this.isPartitionResolver = new Boolean(true);
        this.attributeObjects = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, this.colocatedWith, this.isPartitionResolver};
        this.createPartitionedRegion(this.attributeObjects);
        this.regionName = "B";
        this.colocatedWith = "A";
        this.isPartitionResolver = new Boolean(true);
        this.attributeObjects = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, this.colocatedWith, this.isPartitionResolver};
        this.createPartitionedRegion(this.attributeObjects);
        this.regionName = "C";
        this.colocatedWith = "A";
        this.isPartitionResolver = new Boolean(true);
        this.attributeObjects = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, this.colocatedWith, this.isPartitionResolver};
        this.createPartitionedRegion(this.attributeObjects);
        this.regionName = "D";
        this.colocatedWith = "B";
        this.attributeObjects = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, this.colocatedWith, this.isPartitionResolver};
        this.createPartitionedRegion(this.attributeObjects);
        this.regionName = "E";
        this.colocatedWith = "B";
        this.isPartitionResolver = new Boolean(true);
        this.attributeObjects = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, this.colocatedWith, this.isPartitionResolver};
        this.createPartitionedRegion(this.attributeObjects);
        this.regionName = "F";
        this.colocatedWith = "B";
        this.isPartitionResolver = new Boolean(true);
        this.attributeObjects = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, this.colocatedWith, this.isPartitionResolver};
        this.createPartitionedRegion(this.attributeObjects);
        this.regionName = "G";
        this.colocatedWith = "C";
        this.isPartitionResolver = new Boolean(true);
        this.attributeObjects = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, this.colocatedWith, this.isPartitionResolver};
        this.createPartitionedRegion(this.attributeObjects);
        this.regionName = "H";
        this.colocatedWith = "C";
        this.isPartitionResolver = new Boolean(true);
        this.attributeObjects = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, this.colocatedWith, this.isPartitionResolver};
        this.createPartitionedRegion(this.attributeObjects);
        this.regionName = "I";
        this.colocatedWith = "C";
        this.isPartitionResolver = new Boolean(true);
        this.attributeObjects = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, this.colocatedWith, this.isPartitionResolver};
        this.createPartitionedRegion(this.attributeObjects);
        this.regionName = "J";
        this.colocatedWith = "D";
        this.isPartitionResolver = new Boolean(true);
        this.attributeObjects = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, this.colocatedWith, this.isPartitionResolver};
        this.createPartitionedRegion(this.attributeObjects);
        this.regionName = "K";
        this.colocatedWith = "D";
        this.isPartitionResolver = new Boolean(true);
        this.attributeObjects = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, this.colocatedWith, this.isPartitionResolver};
        this.createPartitionedRegion(this.attributeObjects);
        this.regionName = "L";
        this.colocatedWith = "E";
        this.isPartitionResolver = new Boolean(true);
        this.attributeObjects = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, this.colocatedWith, this.isPartitionResolver};
        this.createPartitionedRegion(this.attributeObjects);
        this.regionName = "M";
        this.colocatedWith = "F";
        this.isPartitionResolver = new Boolean(true);
        this.attributeObjects = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, this.colocatedWith, this.isPartitionResolver};
        this.createPartitionedRegion(this.attributeObjects);
        this.regionName = "N";
        this.colocatedWith = "G";
        this.isPartitionResolver = new Boolean(true);
        this.attributeObjects = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, this.colocatedWith, this.isPartitionResolver};
        this.createPartitionedRegion(this.attributeObjects);
        this.regionName = "O";
        this.colocatedWith = "I";
        this.isPartitionResolver = new Boolean(true);
        this.attributeObjects = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, this.colocatedWith, this.isPartitionResolver};
        this.createPartitionedRegion(this.attributeObjects);
        this.accessor.invoke(PRColocationDUnitTest.class, "validateColocatedRegions", new Object[]{"A"});
        this.accessor.invoke(PRColocationDUnitTest.class, "validateColocatedRegions", new Object[]{"D"});
        this.accessor.invoke(PRColocationDUnitTest.class, "validateColocatedRegions", new Object[]{"H"});
        this.accessor.invoke(PRColocationDUnitTest.class, "validateColocatedRegions", new Object[]{"B"});
        this.accessor.invoke(PRColocationDUnitTest.class, "validateColocatedRegions", new Object[]{"K"});
    }

    public void testColocatedSubPartitionedRegion() throws Throwable {
        this.createCacheInAllVms();
        this.redundancy = new Integer(1);
        this.localMaxmemory = new Integer(50);
        this.totalNumBuckets = new Integer(11);
        this.regionName = "A";
        this.colocatedWith = null;
        this.isPartitionResolver = new Boolean(true);
        this.attributeObjects = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, this.colocatedWith, this.isPartitionResolver};
        this.createSubPartitionedRegion(this.attributeObjects);
        this.regionName = "B";
        this.colocatedWith = "/rootA/A";
        this.isPartitionResolver = new Boolean(true);
        this.attributeObjects = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, this.colocatedWith, this.isPartitionResolver};
        this.createSubPartitionedRegion(this.attributeObjects);
        this.regionName = "C";
        this.colocatedWith = "/rootA/A";
        this.isPartitionResolver = new Boolean(true);
        this.attributeObjects = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, this.colocatedWith, this.isPartitionResolver};
        this.createSubPartitionedRegion(this.attributeObjects);
        this.regionName = "D";
        this.colocatedWith = "/rootB/B";
        this.attributeObjects = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, this.colocatedWith, this.isPartitionResolver};
        this.createSubPartitionedRegion(this.attributeObjects);
        this.regionName = "E";
        this.colocatedWith = "/rootB/B";
        this.isPartitionResolver = new Boolean(true);
        this.attributeObjects = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, this.colocatedWith, this.isPartitionResolver};
        this.createSubPartitionedRegion(this.attributeObjects);
        this.regionName = "F";
        this.colocatedWith = "/rootB/B";
        this.isPartitionResolver = new Boolean(true);
        this.attributeObjects = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, this.colocatedWith, this.isPartitionResolver};
        this.createSubPartitionedRegion(this.attributeObjects);
        this.regionName = "G";
        this.colocatedWith = "/rootC/C";
        this.isPartitionResolver = new Boolean(true);
        this.attributeObjects = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, this.colocatedWith, this.isPartitionResolver};
        this.createSubPartitionedRegion(this.attributeObjects);
        this.regionName = "H";
        this.colocatedWith = "/rootC/C";
        this.isPartitionResolver = new Boolean(true);
        this.attributeObjects = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, this.colocatedWith, this.isPartitionResolver};
        this.createSubPartitionedRegion(this.attributeObjects);
        this.regionName = "I";
        this.colocatedWith = "/rootC/C";
        this.isPartitionResolver = new Boolean(true);
        this.attributeObjects = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, this.colocatedWith, this.isPartitionResolver};
        this.createSubPartitionedRegion(this.attributeObjects);
        this.regionName = "J";
        this.colocatedWith = "/rootD/D";
        this.isPartitionResolver = new Boolean(true);
        this.attributeObjects = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, this.colocatedWith, this.isPartitionResolver};
        this.createSubPartitionedRegion(this.attributeObjects);
        this.regionName = "K";
        this.colocatedWith = "/rootD/D";
        this.isPartitionResolver = new Boolean(true);
        this.attributeObjects = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, this.colocatedWith, this.isPartitionResolver};
        this.createSubPartitionedRegion(this.attributeObjects);
        this.regionName = "L";
        this.colocatedWith = "/rootE/E";
        this.isPartitionResolver = new Boolean(true);
        this.attributeObjects = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, this.colocatedWith, this.isPartitionResolver};
        this.createSubPartitionedRegion(this.attributeObjects);
        this.regionName = "M";
        this.colocatedWith = "/rootF/F";
        this.isPartitionResolver = new Boolean(true);
        this.attributeObjects = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, this.colocatedWith, this.isPartitionResolver};
        this.createSubPartitionedRegion(this.attributeObjects);
        this.regionName = "N";
        this.colocatedWith = "/rootG/G";
        this.isPartitionResolver = new Boolean(true);
        this.attributeObjects = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, this.colocatedWith, this.isPartitionResolver};
        this.createSubPartitionedRegion(this.attributeObjects);
        this.regionName = "O";
        this.colocatedWith = "/rootI/I";
        this.isPartitionResolver = new Boolean(true);
        this.attributeObjects = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, this.colocatedWith, this.isPartitionResolver};
        this.createSubPartitionedRegion(this.attributeObjects);
        this.accessor.invoke(PRColocationDUnitTest.class, "validateColocatedRegions", new Object[]{"rootA/A"});
        this.accessor.invoke(PRColocationDUnitTest.class, "validateColocatedRegions", new Object[]{"rootD/D"});
        this.accessor.invoke(PRColocationDUnitTest.class, "validateColocatedRegions", new Object[]{"rootH/H"});
        this.accessor.invoke(PRColocationDUnitTest.class, "validateColocatedRegions", new Object[]{"rootB/B"});
        this.accessor.invoke(PRColocationDUnitTest.class, "validateColocatedRegions", new Object[]{"rootK/K"});
    }

    public void testColocatedSubPartitionedRegion_NoFullPath() throws Throwable {
        this.createCacheInAllVms();
        this.redundancy = new Integer(1);
        this.localMaxmemory = new Integer(50);
        this.totalNumBuckets = new Integer(11);
        this.regionName = "A";
        this.colocatedWith = null;
        this.isPartitionResolver = new Boolean(true);
        this.attributeObjects = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, this.colocatedWith, this.isPartitionResolver};
        this.createSubPartitionedRegion(this.attributeObjects);
        this.regionName = "B";
        this.colocatedWith = "rootA/A";
        this.isPartitionResolver = new Boolean(true);
        this.attributeObjects = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, this.colocatedWith, this.isPartitionResolver};
        this.createSubPartitionedRegion(this.attributeObjects);
        this.regionName = "C";
        this.colocatedWith = "rootA/A";
        this.isPartitionResolver = new Boolean(true);
        this.attributeObjects = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, this.colocatedWith, this.isPartitionResolver};
        this.createSubPartitionedRegion(this.attributeObjects);
        this.regionName = "D";
        this.colocatedWith = "rootB/B";
        this.attributeObjects = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, this.colocatedWith, this.isPartitionResolver};
        this.createSubPartitionedRegion(this.attributeObjects);
        this.regionName = "E";
        this.colocatedWith = "rootB/B";
        this.isPartitionResolver = new Boolean(true);
        this.attributeObjects = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, this.colocatedWith, this.isPartitionResolver};
        this.createSubPartitionedRegion(this.attributeObjects);
        this.regionName = "F";
        this.colocatedWith = "rootB/B";
        this.isPartitionResolver = new Boolean(true);
        this.attributeObjects = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, this.colocatedWith, this.isPartitionResolver};
        this.createSubPartitionedRegion(this.attributeObjects);
        this.regionName = "G";
        this.colocatedWith = "rootC/C";
        this.isPartitionResolver = new Boolean(true);
        this.attributeObjects = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, this.colocatedWith, this.isPartitionResolver};
        this.createSubPartitionedRegion(this.attributeObjects);
        this.regionName = "H";
        this.colocatedWith = "rootC/C";
        this.isPartitionResolver = new Boolean(true);
        this.attributeObjects = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, this.colocatedWith, this.isPartitionResolver};
        this.createSubPartitionedRegion(this.attributeObjects);
        this.regionName = "I";
        this.colocatedWith = "rootC/C";
        this.isPartitionResolver = new Boolean(true);
        this.attributeObjects = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, this.colocatedWith, this.isPartitionResolver};
        this.createSubPartitionedRegion(this.attributeObjects);
        this.regionName = "J";
        this.colocatedWith = "rootD/D";
        this.isPartitionResolver = new Boolean(true);
        this.attributeObjects = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, this.colocatedWith, this.isPartitionResolver};
        this.createSubPartitionedRegion(this.attributeObjects);
        this.regionName = "K";
        this.colocatedWith = "rootD/D";
        this.isPartitionResolver = new Boolean(true);
        this.attributeObjects = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, this.colocatedWith, this.isPartitionResolver};
        this.createSubPartitionedRegion(this.attributeObjects);
        this.regionName = "L";
        this.colocatedWith = "rootE/E";
        this.isPartitionResolver = new Boolean(true);
        this.attributeObjects = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, this.colocatedWith, this.isPartitionResolver};
        this.createSubPartitionedRegion(this.attributeObjects);
        this.regionName = "M";
        this.colocatedWith = "rootF/F";
        this.isPartitionResolver = new Boolean(true);
        this.attributeObjects = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, this.colocatedWith, this.isPartitionResolver};
        this.createSubPartitionedRegion(this.attributeObjects);
        this.regionName = "N";
        this.colocatedWith = "rootG/G";
        this.isPartitionResolver = new Boolean(true);
        this.attributeObjects = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, this.colocatedWith, this.isPartitionResolver};
        this.createSubPartitionedRegion(this.attributeObjects);
        this.regionName = "O";
        this.colocatedWith = "rootI/I";
        this.isPartitionResolver = new Boolean(true);
        this.attributeObjects = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, this.colocatedWith, this.isPartitionResolver};
        this.createSubPartitionedRegion(this.attributeObjects);
        this.accessor.invoke(PRColocationDUnitTest.class, "validateColocatedRegions", new Object[]{"rootA/A"});
        this.accessor.invoke(PRColocationDUnitTest.class, "validateColocatedRegions", new Object[]{"rootD/D"});
        this.accessor.invoke(PRColocationDUnitTest.class, "validateColocatedRegions", new Object[]{"rootH/H"});
        this.accessor.invoke(PRColocationDUnitTest.class, "validateColocatedRegions", new Object[]{"rootB/B"});
        this.accessor.invoke(PRColocationDUnitTest.class, "validateColocatedRegions", new Object[]{"rootK/K"});
    }

    public void testColocatedPRWithAccessorOnDifferentNode1() throws Throwable {
        this.createCacheInAllVms();
        this.dataStore1.invoke(new CacheSerializableRunnable("testColocatedPRwithAccessorOnDifferentNode"){

            @Override
            public void run2() {
                String partitionedRegionName = PRColocationDUnitTest.CustomerPartitionedRegionName;
                PRColocationDUnitTest.this.colocatedWith = null;
                PRColocationDUnitTest.this.isPartitionResolver = new Boolean(false);
                PRColocationDUnitTest.this.redundancy = new Integer(0);
                PRColocationDUnitTest.this.localMaxmemory = new Integer(50);
                PRColocationDUnitTest.this.totalNumBuckets = new Integer(11);
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setRedundantCopies(PRColocationDUnitTest.this.redundancy.intValue()).setLocalMaxMemory(PRColocationDUnitTest.this.localMaxmemory.intValue()).setTotalNumBuckets(PRColocationDUnitTest.this.totalNumBuckets.intValue()).setColocatedWith(PRColocationDUnitTest.this.colocatedWith);
                if (PRColocationDUnitTest.this.isPartitionResolver.booleanValue()) {
                    paf.setPartitionResolver((PartitionResolver)new CustomerIDPartitionResolver("CustomerIDPartitionResolver"));
                }
                PartitionAttributes prAttr = paf.create();
                AttributesFactory attr = new AttributesFactory();
                attr.setPartitionAttributes(prAttr);
                TestCase.assertNotNull((Object)CacheTestCase.basicGetCache());
                Region pr = CacheTestCase.basicGetCache().createRegion(partitionedRegionName, attr.create());
                TestCase.assertNotNull((Object)pr);
                DistributedTestCase.getLogWriter().info("Partitioned Region " + partitionedRegionName + " created Successfully :" + pr.toString());
            }
        });
        DistributedTestCase.ExpectedException ex = PRColocationDUnitTest.addExpectedException("Colocated regions should have accessors at the same node", this.dataStore1);
        this.dataStore1.invoke(new CacheSerializableRunnable("Colocated PR with Accessor on different nodes"){

            @Override
            public void run2() {
                PRColocationDUnitTest.this.regionName = PRColocationDUnitTest.OrderPartitionedRegionName;
                PRColocationDUnitTest.this.colocatedWith = PRColocationDUnitTest.CustomerPartitionedRegionName;
                PRColocationDUnitTest.this.isPartitionResolver = new Boolean(false);
                PRColocationDUnitTest.this.localMaxmemory = new Integer(0);
                PRColocationDUnitTest.this.redundancy = new Integer(0);
                PRColocationDUnitTest.this.totalNumBuckets = new Integer(11);
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setRedundantCopies(PRColocationDUnitTest.this.redundancy.intValue()).setLocalMaxMemory(PRColocationDUnitTest.this.localMaxmemory.intValue()).setTotalNumBuckets(PRColocationDUnitTest.this.totalNumBuckets.intValue()).setColocatedWith(PRColocationDUnitTest.this.colocatedWith);
                if (PRColocationDUnitTest.this.isPartitionResolver.booleanValue()) {
                    paf.setPartitionResolver((PartitionResolver)new CustomerIDPartitionResolver("CustomerIDPartitionResolver"));
                }
                PartitionAttributes prAttr = paf.create();
                AttributesFactory attr = new AttributesFactory();
                attr.setPartitionAttributes(prAttr);
                TestCase.assertNotNull((Object)CacheTestCase.basicGetCache());
                try {
                    CacheTestCase.basicGetCache().createRegion(PRColocationDUnitTest.this.regionName, attr.create());
                    TestCase.fail((String)"It should have failed with Exception: Colocated regions should have accessors at the same node");
                }
                catch (Exception Expected) {
                    Expected.printStackTrace();
                    DistributedTestCase.getLogWriter().info("Expected Message : " + Expected.getMessage());
                    TestCase.assertTrue((boolean)Expected.getMessage().startsWith("Colocated regions should have accessors at the same node"));
                }
            }
        });
        ex.remove();
    }

    public void testColocatedPRWithAccessorOnDifferentNode2() throws Throwable {
        this.createCacheInAllVms();
        this.dataStore1.invoke(new CacheSerializableRunnable("testColocatedPRWithAccessorOnDifferentNode2"){

            @Override
            public void run2() {
                String partitionedRegionName = PRColocationDUnitTest.CustomerPartitionedRegionName;
                PRColocationDUnitTest.this.colocatedWith = null;
                PRColocationDUnitTest.this.isPartitionResolver = new Boolean(false);
                PRColocationDUnitTest.this.redundancy = new Integer(0);
                PRColocationDUnitTest.this.localMaxmemory = new Integer(0);
                PRColocationDUnitTest.this.totalNumBuckets = new Integer(11);
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setRedundantCopies(PRColocationDUnitTest.this.redundancy.intValue()).setLocalMaxMemory(PRColocationDUnitTest.this.localMaxmemory.intValue()).setTotalNumBuckets(PRColocationDUnitTest.this.totalNumBuckets.intValue()).setColocatedWith(PRColocationDUnitTest.this.colocatedWith);
                if (PRColocationDUnitTest.this.isPartitionResolver.booleanValue()) {
                    paf.setPartitionResolver((PartitionResolver)new CustomerIDPartitionResolver("CustomerIDPartitionResolver"));
                }
                PartitionAttributes prAttr = paf.create();
                AttributesFactory attr = new AttributesFactory();
                attr.setPartitionAttributes(prAttr);
                TestCase.assertNotNull((Object)CacheTestCase.basicGetCache());
                Region pr = CacheTestCase.basicGetCache().createRegion(partitionedRegionName, attr.create());
                TestCase.assertNotNull((Object)pr);
                DistributedTestCase.getLogWriter().info("Partitioned Region " + partitionedRegionName + " created Successfully :" + pr.toString());
            }
        });
        DistributedTestCase.ExpectedException ex = PRColocationDUnitTest.addExpectedException("Colocated regions should have accessors at the same node", this.dataStore1);
        this.dataStore1.invoke(new CacheSerializableRunnable("Colocated PR with accessor on different nodes"){

            @Override
            public void run2() {
                PRColocationDUnitTest.this.regionName = PRColocationDUnitTest.OrderPartitionedRegionName;
                PRColocationDUnitTest.this.colocatedWith = PRColocationDUnitTest.CustomerPartitionedRegionName;
                PRColocationDUnitTest.this.isPartitionResolver = new Boolean(false);
                PRColocationDUnitTest.this.redundancy = new Integer(0);
                PRColocationDUnitTest.this.localMaxmemory = new Integer(50);
                PRColocationDUnitTest.this.totalNumBuckets = new Integer(11);
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setRedundantCopies(PRColocationDUnitTest.this.redundancy.intValue()).setLocalMaxMemory(PRColocationDUnitTest.this.localMaxmemory.intValue()).setTotalNumBuckets(PRColocationDUnitTest.this.totalNumBuckets.intValue()).setColocatedWith(PRColocationDUnitTest.this.colocatedWith);
                if (PRColocationDUnitTest.this.isPartitionResolver.booleanValue()) {
                    paf.setPartitionResolver((PartitionResolver)new CustomerIDPartitionResolver("CustomerIDPartitionResolver"));
                }
                PartitionAttributes prAttr = paf.create();
                AttributesFactory attr = new AttributesFactory();
                attr.setPartitionAttributes(prAttr);
                TestCase.assertNotNull((Object)CacheTestCase.basicGetCache());
                try {
                    CacheTestCase.basicGetCache().createRegion(PRColocationDUnitTest.this.regionName, attr.create());
                    TestCase.fail((String)"It should have failed with Exception: Colocated regions should have accessors at the same node");
                }
                catch (Exception Expected) {
                    DistributedTestCase.getLogWriter().info("Expected Message : " + Expected.getMessage());
                    TestCase.assertTrue((boolean)Expected.getMessage().startsWith("Colocated regions should have accessors at the same node"));
                }
            }
        });
        ex.remove();
    }

    public void testColocatedPRWithPROnDifferentNode1() throws Throwable {
        this.createCacheInAllVms();
        this.dataStore1.invoke(new CacheSerializableRunnable("TestColocatedPRWithPROnDifferentNode"){

            @Override
            public void run2() {
                String partitionedRegionName = PRColocationDUnitTest.CustomerPartitionedRegionName;
                PRColocationDUnitTest.this.colocatedWith = null;
                PRColocationDUnitTest.this.isPartitionResolver = new Boolean(false);
                PRColocationDUnitTest.this.redundancy = new Integer(0);
                PRColocationDUnitTest.this.localMaxmemory = new Integer(20);
                PRColocationDUnitTest.this.totalNumBuckets = new Integer(11);
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setRedundantCopies(PRColocationDUnitTest.this.redundancy.intValue()).setLocalMaxMemory(PRColocationDUnitTest.this.localMaxmemory.intValue()).setTotalNumBuckets(PRColocationDUnitTest.this.totalNumBuckets.intValue()).setColocatedWith(PRColocationDUnitTest.this.colocatedWith);
                if (PRColocationDUnitTest.this.isPartitionResolver.booleanValue()) {
                    paf.setPartitionResolver((PartitionResolver)new CustomerIDPartitionResolver("CustomerIDPartitionResolver"));
                }
                PartitionAttributes prAttr = paf.create();
                AttributesFactory attr = new AttributesFactory();
                attr.setPartitionAttributes(prAttr);
                TestCase.assertNotNull((Object)CacheTestCase.basicGetCache());
                Region pr = CacheTestCase.basicGetCache().createRegion(partitionedRegionName, attr.create());
                TestCase.assertNotNull((Object)pr);
                DistributedTestCase.getLogWriter().info("Partitioned Region " + partitionedRegionName + " created Successfully :" + pr.toString());
            }
        });
        this.dataStore2.invoke(new CacheSerializableRunnable("testColocatedPRwithPROnDifferentNode"){

            @Override
            public void run2() {
                String partitionedRegionName = PRColocationDUnitTest.CustomerPartitionedRegionName;
                PRColocationDUnitTest.this.colocatedWith = null;
                PRColocationDUnitTest.this.isPartitionResolver = new Boolean(false);
                PRColocationDUnitTest.this.redundancy = new Integer(0);
                PRColocationDUnitTest.this.localMaxmemory = new Integer(20);
                PRColocationDUnitTest.this.totalNumBuckets = new Integer(11);
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setRedundantCopies(PRColocationDUnitTest.this.redundancy.intValue()).setLocalMaxMemory(PRColocationDUnitTest.this.localMaxmemory.intValue()).setTotalNumBuckets(PRColocationDUnitTest.this.totalNumBuckets.intValue()).setColocatedWith(PRColocationDUnitTest.this.colocatedWith);
                if (PRColocationDUnitTest.this.isPartitionResolver.booleanValue()) {
                    paf.setPartitionResolver((PartitionResolver)new CustomerIDPartitionResolver("CustomerIDPartitionResolver"));
                }
                PartitionAttributes prAttr = paf.create();
                AttributesFactory attr = new AttributesFactory();
                attr.setPartitionAttributes(prAttr);
                TestCase.assertNotNull((Object)CacheTestCase.basicGetCache());
                Region pr = CacheTestCase.basicGetCache().createRegion(partitionedRegionName, attr.create());
                TestCase.assertNotNull((Object)pr);
                DistributedTestCase.getLogWriter().info("Partitioned Region " + partitionedRegionName + " created Successfully :" + pr.toString());
            }
        });
        DistributedTestCase.ExpectedException ex = PRColocationDUnitTest.addExpectedException("Cannot create buckets", this.dataStore2);
        this.dataStore2.invoke(new CacheSerializableRunnable("Colocated PR with PR on different node"){

            @Override
            public void run2() {
                PRColocationDUnitTest.this.regionName = PRColocationDUnitTest.OrderPartitionedRegionName;
                PRColocationDUnitTest.this.colocatedWith = PRColocationDUnitTest.CustomerPartitionedRegionName;
                PRColocationDUnitTest.this.isPartitionResolver = new Boolean(false);
                PRColocationDUnitTest.this.redundancy = new Integer(0);
                PRColocationDUnitTest.this.localMaxmemory = new Integer(50);
                PRColocationDUnitTest.this.totalNumBuckets = new Integer(11);
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setRedundantCopies(PRColocationDUnitTest.this.redundancy.intValue()).setLocalMaxMemory(PRColocationDUnitTest.this.localMaxmemory.intValue()).setTotalNumBuckets(PRColocationDUnitTest.this.totalNumBuckets.intValue()).setColocatedWith(PRColocationDUnitTest.this.colocatedWith);
                if (PRColocationDUnitTest.this.isPartitionResolver.booleanValue()) {
                    paf.setPartitionResolver((PartitionResolver)new CustomerIDPartitionResolver("CustomerIDPartitionResolver"));
                }
                PartitionAttributes prAttr = paf.create();
                AttributesFactory attr = new AttributesFactory();
                attr.setPartitionAttributes(prAttr);
                TestCase.assertNotNull((Object)CacheTestCase.basicGetCache());
                try {
                    Region r = CacheTestCase.basicGetCache().createRegion(PRColocationDUnitTest.this.regionName, attr.create());
                    r.put((Object)"key", (Object)"value");
                    TestCase.fail((String)"Failed because we did not receive the exception - : Cannot create buckets, as colocated regions are not configured to be at the same nodes.");
                }
                catch (Exception Expected) {
                    DistributedTestCase.getLogWriter().info("Expected Message : " + Expected.getMessage());
                    TestCase.assertTrue((boolean)Expected.getMessage().contains("Cannot create buckets, as colocated regions are not configured to be at the same nodes."));
                }
            }
        });
        ex.remove();
        this.dataStore1.invoke(new CacheSerializableRunnable("Colocated PR with PR on different node"){

            @Override
            public void run2() {
                PRColocationDUnitTest.this.regionName = PRColocationDUnitTest.OrderPartitionedRegionName;
                PRColocationDUnitTest.this.colocatedWith = PRColocationDUnitTest.CustomerPartitionedRegionName;
                PRColocationDUnitTest.this.isPartitionResolver = new Boolean(false);
                PRColocationDUnitTest.this.redundancy = new Integer(0);
                PRColocationDUnitTest.this.localMaxmemory = new Integer(50);
                PRColocationDUnitTest.this.totalNumBuckets = new Integer(11);
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setRedundantCopies(PRColocationDUnitTest.this.redundancy.intValue()).setLocalMaxMemory(PRColocationDUnitTest.this.localMaxmemory.intValue()).setTotalNumBuckets(PRColocationDUnitTest.this.totalNumBuckets.intValue()).setColocatedWith(PRColocationDUnitTest.this.colocatedWith);
                if (PRColocationDUnitTest.this.isPartitionResolver.booleanValue()) {
                    paf.setPartitionResolver((PartitionResolver)new CustomerIDPartitionResolver("CustomerIDPartitionResolver"));
                }
                PartitionAttributes prAttr = paf.create();
                AttributesFactory attr = new AttributesFactory();
                attr.setPartitionAttributes(prAttr);
                TestCase.assertNotNull((Object)CacheTestCase.basicGetCache());
                try {
                    Region r = CacheTestCase.basicGetCache().createRegion(PRColocationDUnitTest.this.regionName, attr.create());
                    r.put((Object)"key", (Object)"value");
                    TestCase.assertEquals((String)"value", (String)((String)r.get((Object)"key")));
                }
                catch (Exception NotExpected) {
                    NotExpected.printStackTrace();
                    DistributedTestCase.getLogWriter().info("Unexpected Exception Message : " + NotExpected.getMessage());
                    DistributedTestCase.fail("Unpexpected Exception", NotExpected);
                }
            }
        });
    }

    public void testColocatedPRWithLocalDestroy() throws Throwable {
        this.createCacheInAllVms();
        this.redundancy = new Integer(0);
        this.localMaxmemory = new Integer(50);
        this.totalNumBuckets = new Integer(11);
        this.regionName = CustomerPartitionedRegionName;
        this.colocatedWith = null;
        this.isPartitionResolver = new Boolean(false);
        this.attributeObjects = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, this.colocatedWith, this.isPartitionResolver};
        this.createPartitionedRegion(this.attributeObjects);
        this.regionName = OrderPartitionedRegionName;
        this.colocatedWith = CustomerPartitionedRegionName;
        this.isPartitionResolver = new Boolean(false);
        this.attributeObjects = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, this.colocatedWith, this.isPartitionResolver};
        this.createPartitionedRegion(this.attributeObjects);
        this.accessor.invoke(PRColocationDUnitTest.class, "putCustomerPartitionedRegion", new Object[]{CustomerPartitionedRegionName});
        this.accessor.invoke(PRColocationDUnitTest.class, "putOrderPartitionedRegion", new Object[]{OrderPartitionedRegionName});
        String expectedExMessage = "Any Region in colocation chain cannot be destroyed locally.";
        DistributedTestCase.ExpectedException ex = PRColocationDUnitTest.addExpectedException("Any Region in colocation chain cannot be destroyed locally.", this.dataStore1);
        this.dataStore1.invoke(new CacheSerializableRunnable("PR with Local destroy"){

            @Override
            public void run2() {
                Region partitionedregion = CacheTestCase.basicGetCache().getRegion("/OrderPartitionedRegion");
                try {
                    partitionedregion.localDestroyRegion();
                    TestCase.fail((String)"It should have thrown an Exception saying: Any Region in colocation chain cannot be destroyed locally.");
                }
                catch (Exception Expected) {
                    DistributedTestCase.getLogWriter().info("Expected Messageee : " + Expected.getMessage());
                    TestCase.assertTrue((boolean)Expected.getMessage().contains("Any Region in colocation chain cannot be destroyed locally."));
                }
            }
        });
        this.dataStore1.invoke(new CacheSerializableRunnable("PR with Local Destroy"){

            @Override
            public void run2() {
                Region partitionedregion = CacheTestCase.basicGetCache().getRegion("/CustomerPartitionedRegion");
                try {
                    partitionedregion.localDestroyRegion();
                    TestCase.fail((String)"It should have thrown an Exception saying: Any Region in colocation chain cannot be destroyed locally.");
                }
                catch (Exception Expected) {
                    DistributedTestCase.getLogWriter().info("Expected Messageee : " + Expected.getMessage());
                    TestCase.assertTrue((boolean)Expected.getMessage().contains("Any Region in colocation chain cannot be destroyed locally."));
                }
            }
        });
        ex.remove();
    }

    public void testColocatedPRWithDestroy() throws Throwable {
        this.createCacheInAllVms();
        this.redundancy = new Integer(0);
        this.localMaxmemory = new Integer(50);
        this.totalNumBuckets = new Integer(11);
        try {
            this.regionName = CustomerPartitionedRegionName;
            this.colocatedWith = null;
            this.isPartitionResolver = new Boolean(false);
            this.attributeObjects = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, this.colocatedWith, this.isPartitionResolver};
            this.createPartitionedRegion(this.attributeObjects);
            this.regionName = OrderPartitionedRegionName;
            this.colocatedWith = CustomerPartitionedRegionName;
            this.isPartitionResolver = new Boolean(false);
            this.attributeObjects = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, this.colocatedWith, this.isPartitionResolver};
            this.createPartitionedRegion(this.attributeObjects);
        }
        catch (Exception Expected) {
            PRColocationDUnitTest.assertTrue((boolean)(Expected instanceof IllegalStateException));
        }
        this.accessor.invoke(PRColocationDUnitTest.class, "putCustomerPartitionedRegion", new Object[]{CustomerPartitionedRegionName});
        this.accessor.invoke(PRColocationDUnitTest.class, "putOrderPartitionedRegion", new Object[]{OrderPartitionedRegionName});
        String expectedExMessage = "colocation chain cannot be destroyed, unless all its children";
        DistributedTestCase.ExpectedException ex = PRColocationDUnitTest.addExpectedException("colocation chain cannot be destroyed, unless all its children", this.dataStore1);
        this.dataStore1.invoke(new CacheSerializableRunnable("PR with destroy"){

            @Override
            public void run2() {
                Region partitionedregion = CacheTestCase.basicGetCache().getRegion("/CustomerPartitionedRegion");
                try {
                    partitionedregion.destroyRegion();
                    TestCase.fail((String)"It should have thrown an Exception saying: colocation chain cannot be destroyed, unless all its children");
                }
                catch (IllegalStateException expected) {
                    DistributedTestCase.getLogWriter().info("Got message: " + expected.getMessage());
                    TestCase.assertTrue((boolean)expected.getMessage().contains("colocation chain cannot be destroyed, unless all its children"));
                }
            }
        });
        ex.remove();
        this.dataStore1.invoke(new CacheSerializableRunnable("PR with destroy"){

            @Override
            public void run2() {
                Region partitionedregion = CacheTestCase.basicGetCache().getRegion("/OrderPartitionedRegion");
                try {
                    partitionedregion.destroyRegion();
                }
                catch (Exception unexpected) {
                    unexpected.printStackTrace();
                    DistributedTestCase.getLogWriter().info("Unexpected Message: " + unexpected.getMessage());
                    TestCase.fail((String)"Could not destroy the child region.");
                }
            }
        });
        this.dataStore1.invoke(new CacheSerializableRunnable("PR with destroy"){

            @Override
            public void run2() {
                Region partitionedregion = CacheTestCase.basicGetCache().getRegion("/CustomerPartitionedRegion");
                try {
                    partitionedregion.destroyRegion();
                }
                catch (Exception unexpected) {
                    unexpected.printStackTrace();
                    DistributedTestCase.getLogWriter().info("Unexpected Message: " + unexpected.getMessage());
                    TestCase.fail((String)"Could not destroy the parent region.");
                }
            }
        });
    }

    public void Bug47502_testColocatedPRWithClose() throws Throwable {
        this.createCacheInAllVms();
        this.redundancy = new Integer(0);
        this.localMaxmemory = new Integer(50);
        this.totalNumBuckets = new Integer(20);
        this.regionName = CustomerPartitionedRegionName;
        this.colocatedWith = null;
        this.isPartitionResolver = new Boolean(true);
        this.attributeObjects = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, this.colocatedWith, this.isPartitionResolver};
        this.createPartitionedRegion(this.attributeObjects);
        this.regionName = OrderPartitionedRegionName;
        this.colocatedWith = CustomerPartitionedRegionName;
        this.isPartitionResolver = new Boolean(true);
        this.attributeObjects = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, this.colocatedWith, this.isPartitionResolver};
        this.createPartitionedRegion(this.attributeObjects);
        this.accessor.invoke(PRColocationDUnitTest.class, "putCustomerPartitionedRegion", new Object[]{CustomerPartitionedRegionName});
        this.accessor.invoke(PRColocationDUnitTest.class, "putOrderPartitionedRegion", new Object[]{OrderPartitionedRegionName});
        this.accessor.invoke(PRColocationDUnitTest.class, "closeRegion", new Object[]{CustomerPartitionedRegionName});
        this.accessor.invoke(PRColocationDUnitTest.class, "putOrderPartitionedRegion2", new Object[]{OrderPartitionedRegionName});
    }

    public void testPartitionResolverPartitionedRegion() throws Throwable {
        this.createCacheInAllVms();
        this.redundancy = new Integer(0);
        this.localMaxmemory = new Integer(50);
        this.totalNumBuckets = new Integer(11);
        try {
            this.regionName = CustomerPartitionedRegionName;
            this.colocatedWith = null;
            this.isPartitionResolver = new Boolean(false);
            this.attributeObjects = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, this.colocatedWith, this.isPartitionResolver};
            this.createPartitionedRegion(this.attributeObjects);
            this.regionName = OrderPartitionedRegionName;
            this.colocatedWith = CustomerPartitionedRegionName;
            this.isPartitionResolver = new Boolean(false);
            this.attributeObjects = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, this.colocatedWith, this.isPartitionResolver};
            this.createPartitionedRegion(this.attributeObjects);
            this.accessor.invoke(new SerializableCallable("Create data, invoke exectuable"){

                public Object call() throws Exception {
                    PartitionedRegion prForCustomer = (PartitionedRegion)CacheTestCase.basicGetCache().getRegion(PRColocationDUnitTest.CustomerPartitionedRegionName);
                    TestCase.assertNotNull((Object)prForCustomer);
                    DummyKeyBasedRoutingResolver dummy = new DummyKeyBasedRoutingResolver(1);
                    prForCustomer.put((Object)dummy, (Object)new Integer(100));
                    TestCase.assertEquals((Object)prForCustomer.get((Object)dummy), (Object)new Integer(100));
                    DistributedTestCase.getLogWriter().info("Key :" + dummy.dummyID + " Value :" + prForCustomer.get((Object)dummy));
                    PartitionedRegion prForOrder = (PartitionedRegion)CacheTestCase.basicGetCache().getRegion(PRColocationDUnitTest.OrderPartitionedRegionName);
                    TestCase.assertNotNull((Object)prForOrder);
                    prForOrder.put((Object)dummy, (Object)new Integer(200));
                    TestCase.assertEquals((Object)prForOrder.get((Object)dummy), (Object)new Integer(200));
                    DistributedTestCase.getLogWriter().info("Key :" + dummy.dummyID + " Value :" + prForOrder.get((Object)dummy));
                    return null;
                }
            });
        }
        catch (Exception unexpected) {
            unexpected.printStackTrace();
            PRColocationDUnitTest.getLogWriter().info("Unexpected Message: " + unexpected.getMessage());
            PRColocationDUnitTest.fail((String)"Test failed");
        }
    }

    public void testColocationPartitionedRegion() throws Throwable {
        this.createCacheInAllVms();
        this.redundancy = new Integer(0);
        this.localMaxmemory = new Integer(50);
        this.totalNumBuckets = new Integer(11);
        this.regionName = CustomerPartitionedRegionName;
        this.colocatedWith = null;
        this.isPartitionResolver = new Boolean(true);
        this.attributeObjects = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, this.colocatedWith, this.isPartitionResolver};
        this.createPartitionedRegion(this.attributeObjects);
        this.regionName = OrderPartitionedRegionName;
        this.colocatedWith = CustomerPartitionedRegionName;
        this.isPartitionResolver = new Boolean(true);
        this.attributeObjects = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, this.colocatedWith, this.isPartitionResolver};
        this.createPartitionedRegion(this.attributeObjects);
        this.regionName = ShipmentPartitionedRegionName;
        this.colocatedWith = OrderPartitionedRegionName;
        this.isPartitionResolver = new Boolean(true);
        this.attributeObjects = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, this.colocatedWith, this.isPartitionResolver};
        this.createPartitionedRegion(this.attributeObjects);
        this.accessor.invoke(PRColocationDUnitTest.class, "validateBeforePutCustomerPartitionedRegion", new Object[]{CustomerPartitionedRegionName});
        this.accessor.invoke(PRColocationDUnitTest.class, "putCustomerPartitionedRegion", new Object[]{CustomerPartitionedRegionName});
        this.accessor.invoke(PRColocationDUnitTest.class, "putOrderPartitionedRegion", new Object[]{OrderPartitionedRegionName});
        this.accessor.invoke(PRColocationDUnitTest.class, "putShipmentPartitionedRegion", new Object[]{ShipmentPartitionedRegionName});
        Integer totalBucketsInDataStore1 = (Integer)this.dataStore1.invoke(PRColocationDUnitTest.class, "validateDataStore", new Object[]{CustomerPartitionedRegionName, OrderPartitionedRegionName, ShipmentPartitionedRegionName});
        Integer totalBucketsInDataStore2 = (Integer)this.dataStore2.invoke(PRColocationDUnitTest.class, "validateDataStore", new Object[]{CustomerPartitionedRegionName, OrderPartitionedRegionName, ShipmentPartitionedRegionName});
        Integer totalBucketsInDataStore3 = (Integer)this.dataStore3.invoke(PRColocationDUnitTest.class, "validateDataStore", new Object[]{CustomerPartitionedRegionName, OrderPartitionedRegionName, ShipmentPartitionedRegionName});
        totalNumBucketsInTest = totalBucketsInDataStore1 + totalBucketsInDataStore2 + totalBucketsInDataStore3;
        PRColocationDUnitTest.assertEquals((int)totalNumBucketsInTest, (int)30);
        this.accessor.invoke(PRColocationDUnitTest.class, "validateAfterPutPartitionedRegion", new Object[]{CustomerPartitionedRegionName, OrderPartitionedRegionName, ShipmentPartitionedRegionName});
    }

    public void testColocationPartitionedRegionWithNullColocationSpecifiedOnOneNode() throws Throwable {
        try {
            this.createCacheInAllVms();
            this.getCache().getLogger().info("<ExpectedException action=add>IllegalStateException</ExpectedException>");
            this.redundancy = new Integer(1);
            this.localMaxmemory = new Integer(50);
            this.totalNumBuckets = new Integer(11);
            this.regionName = CustomerPartitionedRegionName;
            this.colocatedWith = null;
            this.isPartitionResolver = new Boolean(true);
            this.attributeObjects = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, null, this.isPartitionResolver};
            this.dataStore1.invoke(PRColocationDUnitTest.class, "createPR", this.attributeObjects);
            PRColocationDUnitTest.createPR(this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, null, this.isPartitionResolver, false);
            this.regionName = OrderPartitionedRegionName;
            this.colocatedWith = CustomerPartitionedRegionName;
            this.isPartitionResolver = new Boolean(true);
            this.attributeObjects = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, this.colocatedWith, this.isPartitionResolver};
            this.dataStore1.invoke(PRColocationDUnitTest.class, "createPR", this.attributeObjects);
            PRColocationDUnitTest.createPR(this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, null, this.isPartitionResolver, false);
            PRColocationDUnitTest.fail((String)"test failed due to illgal colocation settings did not thorw expected exception");
        }
        catch (IllegalStateException expected) {
            PRColocationDUnitTest.assertTrue((boolean)expected.getMessage().contains("The colocatedWith="));
        }
        finally {
            this.getCache().getLogger().info("<ExpectedException action=remove>IllegalStateException</ExpectedException>");
        }
    }

    public void testColocationPartitionedRegionWithRedundancy() throws Throwable {
        this.createCacheInAllVms();
        this.redundancy = new Integer(1);
        this.localMaxmemory = new Integer(50);
        this.totalNumBuckets = new Integer(11);
        this.regionName = CustomerPartitionedRegionName;
        this.colocatedWith = null;
        this.isPartitionResolver = new Boolean(true);
        this.attributeObjects = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, this.colocatedWith, this.isPartitionResolver};
        this.createPartitionedRegion(this.attributeObjects);
        this.regionName = OrderPartitionedRegionName;
        this.colocatedWith = CustomerPartitionedRegionName;
        this.isPartitionResolver = new Boolean(true);
        this.attributeObjects = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, this.colocatedWith, this.isPartitionResolver};
        this.createPartitionedRegion(this.attributeObjects);
        this.regionName = ShipmentPartitionedRegionName;
        this.colocatedWith = OrderPartitionedRegionName;
        this.isPartitionResolver = new Boolean(true);
        this.attributeObjects = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, this.colocatedWith, this.isPartitionResolver};
        this.createPartitionedRegion(this.attributeObjects);
        this.accessor.invoke(PRColocationDUnitTest.class, "validateBeforePutCustomerPartitionedRegion", new Object[]{CustomerPartitionedRegionName});
        this.accessor.invoke(PRColocationDUnitTest.class, "putCustomerPartitionedRegion", new Object[]{CustomerPartitionedRegionName});
        this.accessor.invoke(PRColocationDUnitTest.class, "putOrderPartitionedRegion", new Object[]{OrderPartitionedRegionName});
        this.accessor.invoke(PRColocationDUnitTest.class, "putShipmentPartitionedRegion", new Object[]{ShipmentPartitionedRegionName});
        this.accessor.invoke(PRColocationDUnitTest.class, "validateAfterPutPartitionedRegion", new Object[]{CustomerPartitionedRegionName, OrderPartitionedRegionName, ShipmentPartitionedRegionName});
        Integer totalBucketsInDataStore1 = (Integer)this.dataStore1.invoke(PRColocationDUnitTest.class, "validateDataStore", new Object[]{CustomerPartitionedRegionName, OrderPartitionedRegionName, ShipmentPartitionedRegionName});
        Integer totalBucketsInDataStore2 = (Integer)this.dataStore2.invoke(PRColocationDUnitTest.class, "validateDataStore", new Object[]{CustomerPartitionedRegionName, OrderPartitionedRegionName, ShipmentPartitionedRegionName});
        Integer totalBucketsInDataStore3 = (Integer)this.dataStore3.invoke(PRColocationDUnitTest.class, "validateDataStore", new Object[]{CustomerPartitionedRegionName, OrderPartitionedRegionName, ShipmentPartitionedRegionName});
        if (this.redundancy > 0) {
            this.dataStore1.invoke(PRColocationDUnitTest.class, "validateDataStoreForRedundancy", new Object[]{CustomerPartitionedRegionName, OrderPartitionedRegionName, ShipmentPartitionedRegionName});
            this.dataStore2.invoke(PRColocationDUnitTest.class, "validateDataStoreForRedundancy", new Object[]{CustomerPartitionedRegionName, OrderPartitionedRegionName, ShipmentPartitionedRegionName});
            this.dataStore3.invoke(PRColocationDUnitTest.class, "validateDataStoreForRedundancy", new Object[]{CustomerPartitionedRegionName, OrderPartitionedRegionName, ShipmentPartitionedRegionName});
        }
        totalNumBucketsInTest = totalBucketsInDataStore1 + totalBucketsInDataStore2 + totalBucketsInDataStore3;
        PRColocationDUnitTest.assertEquals((int)totalNumBucketsInTest, (int)60);
    }

    public void testRedundancyRestriction() throws Exception {
        final String rName = this.getUniqueName();
        final Integer red0 = 0;
        final Integer red1 = 1;
        CacheSerializableRunnable createPRsWithRed = new CacheSerializableRunnable("createPrsWithDifferentRedundancy"){

            @Override
            public void run2() throws CacheException {
                PRColocationDUnitTest.this.getCache();
                PRColocationDUnitTest.createPR(rName, red1, 100, 3, null, Boolean.FALSE, Boolean.FALSE);
                try {
                    PRColocationDUnitTest.createPR(rName + "colo", red0, 100, 3, rName, Boolean.FALSE, Boolean.FALSE);
                    TestCase.fail((String)"Expected different redundancy levels to throw.");
                }
                catch (IllegalStateException expected) {
                    TestCase.assertEquals((String)LocalizedStrings.PartitionAttributesImpl_CURRENT_PARTITIONEDREGIONS_REDUNDANCY_SHOULD_BE_SAME_AS_THE_REDUNDANCY_OF_COLOCATED_PARTITIONEDREGION.toLocalizedString(), (String)expected.getMessage());
                }
            }
        };
        this.dataStore1.invoke(createPRsWithRed);
    }

    public void testColocatedPRRedundancyRecovery() throws Throwable {
        this.createCacheInAllVms();
        this.redundancy = new Integer(1);
        this.localMaxmemory = new Integer(50);
        this.totalNumBuckets = new Integer(11);
        this.regionName = CustomerPartitionedRegionName;
        this.colocatedWith = null;
        this.isPartitionResolver = new Boolean(false);
        Object[] attributeObjects1 = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, this.colocatedWith, this.isPartitionResolver};
        this.dataStore1.invoke(PRColocationDUnitTest.class, "createPR", attributeObjects1);
        this.regionName = OrderPartitionedRegionName;
        this.colocatedWith = CustomerPartitionedRegionName;
        this.isPartitionResolver = new Boolean(false);
        Object[] attributeObjects2 = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, this.colocatedWith, this.isPartitionResolver};
        this.dataStore1.invoke(PRColocationDUnitTest.class, "createPR", attributeObjects2);
        this.dataStore1.invoke(new SerializableRunnable("put data in region"){

            @Override
            public void run() {
                Region region1 = CacheTestCase.basicGetCache().getRegion(PRColocationDUnitTest.CustomerPartitionedRegionName);
                Region region2 = CacheTestCase.basicGetCache().getRegion(PRColocationDUnitTest.OrderPartitionedRegionName);
                region1.put((Object)1, (Object)"A");
                region1.put((Object)2, (Object)"A");
                region2.put((Object)1, (Object)"A");
                region2.put((Object)2, (Object)"A");
            }
        });
        this.dataStore2.invoke(new SerializableRunnable("Add recovery listener"){

            @Override
            public void run() {
                InternalResourceManager.setResourceObserver((InternalResourceManager.ResourceObserver)new MyResourceObserver());
            }
        });
        this.dataStore2.invoke(PRColocationDUnitTest.class, "createPR", attributeObjects1);
        SerializableRunnable checkForBuckets = new SerializableRunnable("check for buckets"){

            @Override
            public void run() {
                PartitionedRegion region1 = (PartitionedRegion)CacheTestCase.basicGetCache().getRegion(PRColocationDUnitTest.CustomerPartitionedRegionName);
                MyResourceObserver observer = (MyResourceObserver)InternalResourceManager.getResourceObserver();
                try {
                    observer.waitForRegion((Region)region1, 60000L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                TestCase.assertEquals(Collections.emptyList(), (Object)region1.getLocalBucketsListTestOnly());
                TestCase.assertEquals((int)0, (int)region1.getRegionAdvisor().getBucketRedundancy(1));
            }
        };
        this.dataStore2.invoke(checkForBuckets);
        this.dataStore1.invoke(new SerializableRunnable("put data in region"){

            @Override
            public void run() {
                Region region1 = CacheTestCase.basicGetCache().getRegion(PRColocationDUnitTest.CustomerPartitionedRegionName);
                Region region2 = CacheTestCase.basicGetCache().getRegion(PRColocationDUnitTest.OrderPartitionedRegionName);
                region1.put((Object)3, (Object)"A");
                region2.put((Object)3, (Object)"A");
            }
        });
        this.dataStore2.invoke(checkForBuckets);
        this.dataStore2.invoke(PRColocationDUnitTest.class, "createPR", attributeObjects2);
        this.dataStore2.invoke(new SerializableRunnable("check for bucket creation"){

            @Override
            public void run() {
                PartitionedRegion region1 = (PartitionedRegion)CacheTestCase.basicGetCache().getRegion(PRColocationDUnitTest.CustomerPartitionedRegionName);
                PartitionedRegion region2 = (PartitionedRegion)CacheTestCase.basicGetCache().getRegion(PRColocationDUnitTest.OrderPartitionedRegionName);
                MyResourceObserver observer = (MyResourceObserver)InternalResourceManager.getResourceObserver();
                try {
                    observer.waitForRegion((Region)region2, 60000L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                TestCase.assertEquals((int)3, (int)region1.getLocalBucketsListTestOnly().size());
                TestCase.assertEquals((int)3, (int)region2.getLocalBucketsListTestOnly().size());
            }
        });
    }

    public void testColocationPartitionedRegionWithKeyPartitionResolver() throws Throwable {
        this.createCacheInAllVms();
        this.redundancy = new Integer(0);
        this.localMaxmemory = new Integer(50);
        this.totalNumBuckets = new Integer(11);
        this.regionName = CustomerPartitionedRegionName;
        this.colocatedWith = null;
        this.isPartitionResolver = new Boolean(false);
        this.attributeObjects = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, this.colocatedWith, this.isPartitionResolver};
        this.createPartitionedRegion(this.attributeObjects);
        this.regionName = OrderPartitionedRegionName;
        this.colocatedWith = CustomerPartitionedRegionName;
        this.isPartitionResolver = new Boolean(false);
        this.attributeObjects = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, this.colocatedWith, this.isPartitionResolver};
        this.createPartitionedRegion(this.attributeObjects);
        this.regionName = ShipmentPartitionedRegionName;
        this.colocatedWith = OrderPartitionedRegionName;
        this.isPartitionResolver = new Boolean(false);
        this.attributeObjects = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, this.colocatedWith, this.isPartitionResolver};
        this.createPartitionedRegion(this.attributeObjects);
        this.accessor.invoke(PRColocationDUnitTest.class, "validateBeforePutCustomerPartitionedRegion", new Object[]{CustomerPartitionedRegionName});
        this.accessor.invoke(PRColocationDUnitTest.class, "putData_KeyBasedPartitionResolver");
        this.accessor.invoke(PRColocationDUnitTest.class, "executeFunction");
    }

    public void testColocatedPRRedundancyRecovery2() throws Throwable {
        this.createCacheInAllVms();
        this.dataStore1.invoke(new SerializableRunnable("Add recovery listener"){

            @Override
            public void run() {
                InternalResourceManager.setResourceObserver((InternalResourceManager.ResourceObserver)new MyResourceObserver());
            }
        });
        this.dataStore2.invoke(new SerializableRunnable("Add recovery listener"){

            @Override
            public void run() {
                InternalResourceManager.setResourceObserver((InternalResourceManager.ResourceObserver)new MyResourceObserver());
            }
        });
        this.redundancy = new Integer(1);
        this.localMaxmemory = new Integer(50);
        this.totalNumBuckets = new Integer(11);
        this.regionName = CustomerPartitionedRegionName;
        this.colocatedWith = null;
        this.isPartitionResolver = new Boolean(false);
        Object[] attributeObjects1 = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, this.colocatedWith, this.isPartitionResolver};
        this.dataStore1.invoke(PRColocationDUnitTest.class, "createPR", attributeObjects1);
        this.dataStore1.invoke(new SerializableRunnable("put data in region"){

            @Override
            public void run() {
                Region region1 = CacheTestCase.basicGetCache().getRegion(PRColocationDUnitTest.CustomerPartitionedRegionName);
                region1.put((Object)1, (Object)"A");
                region1.put((Object)2, (Object)"B");
            }
        });
        SerializableRunnable checkForBuckets_ForCustomer = new SerializableRunnable("check for buckets"){

            @Override
            public void run() {
                PartitionedRegion region1 = (PartitionedRegion)CacheTestCase.basicGetCache().getRegion(PRColocationDUnitTest.CustomerPartitionedRegionName);
                MyResourceObserver observer = (MyResourceObserver)InternalResourceManager.getResourceObserver();
                try {
                    observer.waitForRegion((Region)region1, 60000L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                TestCase.assertEquals((int)2, (int)region1.getDataStore().getAllLocalBucketIds().size());
                TestCase.assertEquals((int)2, (int)region1.getDataStore().getAllLocalPrimaryBucketIds().size());
            }
        };
        this.dataStore1.invoke(checkForBuckets_ForCustomer);
        this.regionName = OrderPartitionedRegionName;
        this.colocatedWith = CustomerPartitionedRegionName;
        this.isPartitionResolver = new Boolean(false);
        Object[] attributeObjects2 = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, this.colocatedWith, this.isPartitionResolver};
        this.dataStore1.invoke(PRColocationDUnitTest.class, "createPR", attributeObjects2);
        SerializableRunnable checkForBuckets_ForOrder = new SerializableRunnable("check for buckets"){

            @Override
            public void run() {
                PartitionedRegion region = (PartitionedRegion)CacheTestCase.basicGetCache().getRegion(PRColocationDUnitTest.OrderPartitionedRegionName);
                MyResourceObserver observer = (MyResourceObserver)InternalResourceManager.getResourceObserver();
                try {
                    observer.waitForRegion((Region)region, 60000L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                TestCase.assertEquals((int)2, (int)region.getDataStore().getAllLocalBucketIds().size());
                TestCase.assertEquals((int)2, (int)region.getDataStore().getAllLocalPrimaryBucketIds().size());
            }
        };
        PRColocationDUnitTest.pause(5000);
        this.dataStore1.invoke(checkForBuckets_ForOrder);
        this.dataStore2.invoke(PRColocationDUnitTest.class, "createPR", attributeObjects1);
        SerializableRunnable checkForBuckets = new SerializableRunnable("check for buckets"){

            @Override
            public void run() {
                PartitionedRegion region1 = (PartitionedRegion)CacheTestCase.basicGetCache().getRegion(PRColocationDUnitTest.CustomerPartitionedRegionName);
                MyResourceObserver observer = (MyResourceObserver)InternalResourceManager.getResourceObserver();
                try {
                    observer.waitForRegion((Region)region1, 60000L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                TestCase.assertEquals((int)0, (int)region1.getDataStore().getAllLocalBucketIds().size());
                TestCase.assertEquals((int)0, (int)region1.getDataStore().getAllLocalPrimaryBucketIds().size());
            }
        };
        this.dataStore2.invoke(checkForBuckets);
        this.dataStore1.invoke(new SerializableRunnable("put data in region"){

            @Override
            public void run() {
                Region region1 = CacheTestCase.basicGetCache().getRegion(PRColocationDUnitTest.CustomerPartitionedRegionName);
                region1.put((Object)3, (Object)"C");
            }
        });
        this.dataStore2.invoke(checkForBuckets);
        this.dataStore2.invoke(PRColocationDUnitTest.class, "createPR", attributeObjects2);
        this.dataStore2.invoke(new SerializableRunnable("check for bucket creation"){

            @Override
            public void run() {
                PartitionedRegion region1 = (PartitionedRegion)CacheTestCase.basicGetCache().getRegion(PRColocationDUnitTest.CustomerPartitionedRegionName);
                PartitionedRegion region2 = (PartitionedRegion)CacheTestCase.basicGetCache().getRegion(PRColocationDUnitTest.OrderPartitionedRegionName);
                MyResourceObserver observer = (MyResourceObserver)InternalResourceManager.getResourceObserver();
                try {
                    observer.waitForRegion((Region)region2, 60000L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                TestCase.assertEquals((int)3, (int)region1.getLocalBucketsListTestOnly().size());
                TestCase.assertEquals((int)3, (int)region2.getLocalBucketsListTestOnly().size());
            }
        });
        this.dataStore1.invoke(new SerializableRunnable("check for bucket creation"){

            @Override
            public void run() {
                PartitionedRegion region2 = (PartitionedRegion)CacheTestCase.basicGetCache().getRegion(PRColocationDUnitTest.OrderPartitionedRegionName);
                TestCase.assertEquals((int)3, (int)region2.getLocalBucketsListTestOnly().size());
            }
        });
    }

    public void testSimulaneousChildRegionCreation() throws Throwable {
        this.createCacheInAllVms();
        this.dataStore1.invoke(new SerializableRunnable("Add recovery listener"){

            @Override
            public void run() {
                InternalResourceManager.setResourceObserver((InternalResourceManager.ResourceObserver)new MyResourceObserver());
            }
        });
        this.dataStore2.invoke(new SerializableRunnable("Add recovery listener"){

            @Override
            public void run() {
                InternalResourceManager.setResourceObserver((InternalResourceManager.ResourceObserver)new MyResourceObserver());
            }
        });
        this.redundancy = new Integer(1);
        this.localMaxmemory = new Integer(50);
        this.totalNumBuckets = new Integer(60);
        this.regionName = CustomerPartitionedRegionName;
        this.colocatedWith = null;
        this.isPartitionResolver = new Boolean(false);
        Object[] attributeObjects1 = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, this.colocatedWith, this.isPartitionResolver};
        this.dataStore1.invoke(PRColocationDUnitTest.class, "createPR", attributeObjects1);
        this.dataStore2.invoke(PRColocationDUnitTest.class, "createPR", attributeObjects1);
        this.dataStore1.invoke(new SerializableRunnable("put data in region"){

            @Override
            public void run() {
                Region region1 = CacheTestCase.basicGetCache().getRegion(PRColocationDUnitTest.CustomerPartitionedRegionName);
                for (int i = 0; i < 50; ++i) {
                    region1.put((Object)i, (Object)"A");
                }
            }
        });
        this.regionName = OrderPartitionedRegionName;
        this.colocatedWith = CustomerPartitionedRegionName;
        this.isPartitionResolver = new Boolean(false);
        Object[] attributeObjects2 = new Object[]{this.regionName, this.redundancy, this.localMaxmemory, this.totalNumBuckets, this.colocatedWith, this.isPartitionResolver};
        AsyncInvocation async1 = this.dataStore1.invokeAsync(PRColocationDUnitTest.class, "createPR", attributeObjects2);
        AsyncInvocation async2 = this.dataStore2.invokeAsync(PRColocationDUnitTest.class, "createPR", attributeObjects2);
        async1.join();
        if (async1.exceptionOccurred()) {
            throw async1.getException();
        }
        async2.join();
        if (async2.exceptionOccurred()) {
            throw async2.getException();
        }
        PRColocationDUnitTest.pause(5000);
        SerializableRunnable checkForBuckets_ForOrder = new SerializableRunnable("check for buckets"){

            @Override
            public void run() {
                PartitionedRegion region = (PartitionedRegion)CacheTestCase.basicGetCache().getRegion(PRColocationDUnitTest.OrderPartitionedRegionName);
                MyResourceObserver observer = (MyResourceObserver)InternalResourceManager.getResourceObserver();
                try {
                    observer.waitForRegion((Region)region, 60000L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                TestCase.assertEquals((int)50, (int)region.getDataStore().getAllLocalBucketIds().size());
                TestCase.assertEquals((int)25, (int)region.getDataStore().getAllLocalPrimaryBucketIds().size());
            }
        };
        this.dataStore1.invoke(checkForBuckets_ForOrder);
        this.dataStore2.invoke(checkForBuckets_ForOrder);
    }

    public static void putData_KeyBasedPartitionResolver() {
        PartitionedRegion prForCustomer = (PartitionedRegion)PRColocationDUnitTest.basicGetCache().getRegion(CustomerPartitionedRegionName);
        PRColocationDUnitTest.assertNotNull((Object)prForCustomer);
        PartitionedRegion prForOrder = (PartitionedRegion)PRColocationDUnitTest.basicGetCache().getRegion(OrderPartitionedRegionName);
        PRColocationDUnitTest.assertNotNull((Object)prForOrder);
        PartitionedRegion prForShipment = (PartitionedRegion)PRColocationDUnitTest.basicGetCache().getRegion(ShipmentPartitionedRegionName);
        PRColocationDUnitTest.assertNotNull((Object)prForShipment);
        for (int i = 1; i <= 100; ++i) {
            DummyKeyBasedRoutingResolver dummy = new DummyKeyBasedRoutingResolver(i);
            prForCustomer.put((Object)dummy, (Object)new Integer(1 * i));
            prForOrder.put((Object)dummy, (Object)new Integer(10 * i));
            prForShipment.put((Object)dummy, (Object)new Integer(100 * i));
        }
    }

    public static void executeFunction() {
        FunctionAdapter inlineFunction = new FunctionAdapter(){

            public void execute(FunctionContext context) {
                RegionFunctionContext rfContext = (RegionFunctionContext)context;
                PartitionedRegion pr = (PartitionedRegion)rfContext.getDataSet();
                if (pr.getName().equals(PRColocationDUnitTest.CustomerPartitionedRegionName)) {
                    Map map = ColocationHelper.getColocatedLocalDataSetsForBuckets((PartitionedRegion)pr, new HashSet(), (TXStateInterface)pr.getTXState());
                    TestCase.assertEquals((int)2, (int)map.size());
                    rfContext.getResultSender().sendResult((Object)map.size());
                    map = ColocationHelper.constructAndGetAllColocatedLocalDataSet((PartitionedRegion)pr, new HashSet(), (TXStateInterface)pr.getTXState());
                    TestCase.assertEquals((int)3, (int)map.size());
                    rfContext.getResultSender().lastResult((Object)map.size());
                } else if (pr.getName().equals(PRColocationDUnitTest.OrderPartitionedRegionName)) {
                    Map map = ColocationHelper.getColocatedLocalDataSetsForBuckets((PartitionedRegion)pr, new HashSet(), (TXStateInterface)pr.getTXState());
                    TestCase.assertEquals((int)2, (int)map.size());
                    rfContext.getResultSender().sendResult((Object)map.size());
                    map = ColocationHelper.constructAndGetAllColocatedLocalDataSet((PartitionedRegion)pr, new HashSet(), (TXStateInterface)pr.getTXState());
                    TestCase.assertEquals((int)3, (int)map.size());
                    rfContext.getResultSender().lastResult((Object)map.size());
                } else if (pr.getName().equals(PRColocationDUnitTest.ShipmentPartitionedRegionName)) {
                    Map map = ColocationHelper.getColocatedLocalDataSetsForBuckets((PartitionedRegion)pr, new HashSet(), (TXStateInterface)pr.getTXState());
                    TestCase.assertEquals((int)2, (int)map.size());
                    rfContext.getResultSender().sendResult((Object)map.size());
                    map = ColocationHelper.constructAndGetAllColocatedLocalDataSet((PartitionedRegion)pr, new HashSet(), (TXStateInterface)pr.getTXState());
                    TestCase.assertEquals((int)3, (int)map.size());
                    rfContext.getResultSender().lastResult((Object)map.size());
                }
            }

            public String getId() {
                return "inlineFunction";
            }

            public boolean hasResult() {
                return true;
            }

            public boolean isHA() {
                return false;
            }

            public boolean optimizeForWrite() {
                return false;
            }
        };
        PartitionedRegion prForCustomer = (PartitionedRegion)PRColocationDUnitTest.basicGetCache().getRegion(CustomerPartitionedRegionName);
        HashSet<DummyKeyBasedRoutingResolver> testKeysSet = new HashSet<DummyKeyBasedRoutingResolver>();
        DummyKeyBasedRoutingResolver dummy = new DummyKeyBasedRoutingResolver(10);
        testKeysSet.add(dummy);
        Execution dataSet = FunctionService.onRegion((Region)prForCustomer);
        ResultCollector rc = dataSet.withFilter(testKeysSet).execute((Function)inlineFunction);
        PRColocationDUnitTest.assertEquals((int)2, (int)((List)rc.getResult()).size());
        PartitionedRegion prForOrder = (PartitionedRegion)PRColocationDUnitTest.basicGetCache().getRegion(OrderPartitionedRegionName);
        dataSet = FunctionService.onRegion((Region)prForOrder);
        rc = dataSet.withFilter(testKeysSet).execute((Function)inlineFunction);
        PRColocationDUnitTest.assertEquals((int)2, (int)((List)rc.getResult()).size());
        PartitionedRegion prForShipment = (PartitionedRegion)PRColocationDUnitTest.basicGetCache().getRegion(ShipmentPartitionedRegionName);
        dataSet = FunctionService.onRegion((Region)prForShipment);
        rc = dataSet.withFilter(testKeysSet).execute((Function)inlineFunction);
        PRColocationDUnitTest.assertEquals((int)2, (int)((List)rc.getResult()).size());
    }

    public static void validateDataStoreForRedundancy(String customerPartitionedRegionName, String orderPartitionedRegionName, String shipmentPartitionedRegionName) {
        Iterator primaryBuIterator;
        Map.Entry me2;
        PartitionedRegion customerPartitionedregion = null;
        PartitionedRegion orderPartitionedregion = null;
        PartitionedRegion shipmentPartitionedregion = null;
        try {
            customerPartitionedregion = (PartitionedRegion)PRColocationDUnitTest.basicGetCache().getRegion("/" + customerPartitionedRegionName);
            orderPartitionedregion = (PartitionedRegion)PRColocationDUnitTest.basicGetCache().getRegion("/" + orderPartitionedRegionName);
            shipmentPartitionedregion = (PartitionedRegion)PRColocationDUnitTest.basicGetCache().getRegion("/" + shipmentPartitionedRegionName);
        }
        catch (Exception e) {
            PRColocationDUnitTest.fail((String)"validateDataStore : Failed while getting the region from basicGetCache()");
        }
        ArrayList primaryBucketListForCustomer = null;
        ArrayList secondaryBucketListForCustomer = null;
        ArrayList primaryBucketListForOrder = null;
        ArrayList secondaryBucketListForOrder = null;
        ArrayList primaryBucketListForShipment = null;
        ArrayList secondaryBucketListForShipment = null;
        short totalSizeOfBucketsForCustomer = customerPartitionedregion.getDataStore().getBucketsManaged();
        int sizeOfPrimaryBucketsForCustomer = customerPartitionedregion.getDataStore().getNumberOfPrimaryBucketsManaged();
        int sizeOfSecondaryBucketsForCustomer = totalSizeOfBucketsForCustomer - sizeOfPrimaryBucketsForCustomer;
        primaryBucketListForCustomer = (ArrayList)customerPartitionedregion.getDataStore().getLocalPrimaryBucketsListTestOnly();
        secondaryBucketListForCustomer = new ArrayList(sizeOfSecondaryBucketsForCustomer);
        HashMap localBucket2RegionMap = (HashMap)customerPartitionedregion.getDataStore().getSizeLocally();
        Set customerEntrySet = localBucket2RegionMap.entrySet();
        PRColocationDUnitTest.assertNotNull(customerEntrySet);
        Iterator customerIterator = customerEntrySet.iterator();
        boolean isSecondary = false;
        while (customerIterator.hasNext()) {
            me2 = customerIterator.next();
            primaryBuIterator = primaryBucketListForCustomer.iterator();
            while (primaryBuIterator.hasNext()) {
                if (!me2.getKey().equals(primaryBuIterator.next())) {
                    isSecondary = true;
                    continue;
                }
                isSecondary = false;
                break;
            }
            if (!isSecondary) continue;
            secondaryBucketListForCustomer.add(me2.getKey());
        }
        Iterator primaryBucketIterator = primaryBucketListForCustomer.iterator();
        while (primaryBucketIterator.hasNext()) {
            PRColocationDUnitTest.getLogWriter().info("Primary Bucket : " + primaryBucketIterator.next());
        }
        Iterator SecondaryBucketIterator = secondaryBucketListForCustomer.iterator();
        while (SecondaryBucketIterator.hasNext()) {
            PRColocationDUnitTest.getLogWriter().info("Secondary Bucket : " + SecondaryBucketIterator.next());
        }
        short totalSizeOfBucketsForOrder = orderPartitionedregion.getDataStore().getBucketsManaged();
        int sizeOfPrimaryBucketsForOrder = orderPartitionedregion.getDataStore().getNumberOfPrimaryBucketsManaged();
        int sizeOfSecondaryBucketsForOrder = totalSizeOfBucketsForOrder - sizeOfPrimaryBucketsForOrder;
        primaryBucketListForOrder = (ArrayList)orderPartitionedregion.getDataStore().getLocalPrimaryBucketsListTestOnly();
        secondaryBucketListForOrder = new ArrayList(sizeOfSecondaryBucketsForOrder);
        localBucket2RegionMap = (HashMap)customerPartitionedregion.getDataStore().getSizeLocally();
        customerEntrySet = localBucket2RegionMap.entrySet();
        PRColocationDUnitTest.assertNotNull(customerEntrySet);
        boolean isSecondary2 = false;
        for (Map.Entry me2 : customerEntrySet) {
            primaryBuIterator = primaryBucketListForOrder.iterator();
            while (primaryBuIterator.hasNext()) {
                if (!me2.getKey().equals(primaryBuIterator.next())) {
                    isSecondary2 = true;
                    continue;
                }
                isSecondary2 = false;
                break;
            }
            if (!isSecondary2) continue;
            secondaryBucketListForOrder.add(me2.getKey());
        }
        primaryBucketIterator = primaryBucketListForOrder.iterator();
        while (primaryBucketIterator.hasNext()) {
            PRColocationDUnitTest.getLogWriter().info("Primary Bucket : " + primaryBucketIterator.next());
        }
        SecondaryBucketIterator = secondaryBucketListForOrder.iterator();
        while (SecondaryBucketIterator.hasNext()) {
            PRColocationDUnitTest.getLogWriter().info("Secondary Bucket : " + SecondaryBucketIterator.next());
        }
        short totalSizeOfBucketsForShipment = shipmentPartitionedregion.getDataStore().getBucketsManaged();
        int sizeOfPrimaryBucketsForShipment = shipmentPartitionedregion.getDataStore().getNumberOfPrimaryBucketsManaged();
        int sizeOfSecondaryBucketsForShipment = totalSizeOfBucketsForShipment - sizeOfPrimaryBucketsForShipment;
        primaryBucketListForShipment = (ArrayList)shipmentPartitionedregion.getDataStore().getLocalPrimaryBucketsListTestOnly();
        secondaryBucketListForShipment = new ArrayList(sizeOfSecondaryBucketsForShipment);
        localBucket2RegionMap = (HashMap)shipmentPartitionedregion.getDataStore().getSizeLocally();
        customerEntrySet = localBucket2RegionMap.entrySet();
        PRColocationDUnitTest.assertNotNull(customerEntrySet);
        customerIterator = customerEntrySet.iterator();
        isSecondary = false;
        while (customerIterator.hasNext()) {
            me2 = customerIterator.next();
            primaryBuIterator = primaryBucketListForShipment.iterator();
            while (primaryBuIterator.hasNext()) {
                if (!me2.getKey().equals(primaryBuIterator.next())) {
                    isSecondary = true;
                    continue;
                }
                isSecondary = false;
                break;
            }
            if (!isSecondary) continue;
            secondaryBucketListForShipment.add(me2.getKey());
        }
        primaryBucketIterator = primaryBucketListForShipment.iterator();
        while (primaryBucketIterator.hasNext()) {
            PRColocationDUnitTest.getLogWriter().info("Primary Bucket : " + primaryBucketIterator.next());
        }
        SecondaryBucketIterator = secondaryBucketListForShipment.iterator();
        while (SecondaryBucketIterator.hasNext()) {
            PRColocationDUnitTest.getLogWriter().info("Secondary Bucket : " + SecondaryBucketIterator.next());
        }
        PRColocationDUnitTest.assertTrue((boolean)primaryBucketListForCustomer.containsAll(primaryBucketListForOrder));
        PRColocationDUnitTest.assertTrue((boolean)primaryBucketListForCustomer.containsAll(primaryBucketListForShipment));
        PRColocationDUnitTest.assertTrue((boolean)primaryBucketListForOrder.containsAll(primaryBucketListForOrder));
        PRColocationDUnitTest.assertTrue((boolean)secondaryBucketListForCustomer.containsAll(secondaryBucketListForOrder));
        PRColocationDUnitTest.assertTrue((boolean)secondaryBucketListForCustomer.containsAll(secondaryBucketListForShipment));
        PRColocationDUnitTest.assertTrue((boolean)secondaryBucketListForOrder.containsAll(secondaryBucketListForOrder));
    }

    public static Integer validateDataStore(String customerPartitionedRegionName, String orderPartitionedRegionName, String shipmentPartitionedRegionName) {
        PartitionedRegion customerPartitionedregion = null;
        PartitionedRegion orderPartitionedregion = null;
        PartitionedRegion shipmentPartitionedregion = null;
        try {
            customerPartitionedregion = (PartitionedRegion)PRColocationDUnitTest.basicGetCache().getRegion("/" + customerPartitionedRegionName);
            orderPartitionedregion = (PartitionedRegion)PRColocationDUnitTest.basicGetCache().getRegion("/" + orderPartitionedRegionName);
            shipmentPartitionedregion = (PartitionedRegion)PRColocationDUnitTest.basicGetCache().getRegion("/" + shipmentPartitionedRegionName);
        }
        catch (Exception e) {
            PRColocationDUnitTest.fail((String)"validateDataStore : Failed while getting the region from cache");
        }
        HashMap localBucket2RegionMap = (HashMap)customerPartitionedregion.getDataStore().getSizeLocally();
        int customerBucketSize = localBucket2RegionMap.size();
        PRColocationDUnitTest.getLogWriter().info("Size of the " + customerPartitionedRegionName + " in this VM :- " + localBucket2RegionMap.size());
        PRColocationDUnitTest.getLogWriter().info("Size of primary buckets the " + customerPartitionedRegionName + " in this VM :- " + customerPartitionedregion.getDataStore().getNumberOfPrimaryBucketsManaged());
        Set customerEntrySet = localBucket2RegionMap.entrySet();
        PRColocationDUnitTest.assertNotNull(customerEntrySet);
        for (Map.Entry me : customerEntrySet) {
            Integer size = (Integer)me.getValue();
            PRColocationDUnitTest.assertEquals((int)1, (int)size);
            PRColocationDUnitTest.getLogWriter().info("Size of the Bucket " + me.getKey() + ": - " + size.toString());
        }
        localBucket2RegionMap = (HashMap)orderPartitionedregion.getDataStore().getSizeLocally();
        int orderBucketSize = localBucket2RegionMap.size();
        PRColocationDUnitTest.getLogWriter().info("Size of the " + orderPartitionedRegionName + " in this VM :- " + localBucket2RegionMap.size());
        PRColocationDUnitTest.getLogWriter().info("Size of primary buckets the " + orderPartitionedRegionName + " in this VM :- " + orderPartitionedregion.getDataStore().getNumberOfPrimaryBucketsManaged());
        Set orderEntrySet = localBucket2RegionMap.entrySet();
        PRColocationDUnitTest.assertNotNull(orderEntrySet);
        for (Map.Entry me : orderEntrySet) {
            Integer size = (Integer)me.getValue();
            PRColocationDUnitTest.assertEquals((int)10, (int)size);
            PRColocationDUnitTest.getLogWriter().info("Size of the Bucket " + me.getKey() + ": - " + size.toString());
        }
        localBucket2RegionMap = (HashMap)shipmentPartitionedregion.getDataStore().getSizeLocally();
        int shipmentBucketSize = localBucket2RegionMap.size();
        PRColocationDUnitTest.getLogWriter().info("Size of the " + shipmentPartitionedRegionName + " in this VM :- " + localBucket2RegionMap.size());
        PRColocationDUnitTest.getLogWriter().info("Size of primary buckets the " + shipmentPartitionedRegionName + " in this VM :- " + shipmentPartitionedregion.getDataStore().getNumberOfPrimaryBucketsManaged());
        Set shipmentEntrySet = localBucket2RegionMap.entrySet();
        PRColocationDUnitTest.assertNotNull(shipmentEntrySet);
        for (Map.Entry me : shipmentEntrySet) {
            Integer size = (Integer)me.getValue();
            PRColocationDUnitTest.assertEquals((int)100, (int)size);
            PRColocationDUnitTest.getLogWriter().info("Size of the Bucket " + me.getKey() + ": - " + size.toString());
        }
        return new Integer(customerBucketSize + orderBucketSize + shipmentBucketSize);
    }

    public static void validateColocatedRegions(String partitionedRegionName) {
        PartitionedRegion partitionedRegion = (PartitionedRegion)PRColocationDUnitTest.basicGetCache().getRegion("/" + partitionedRegionName);
        Map colocatedRegions = ColocationHelper.getAllColocationRegions((PartitionedRegion)partitionedRegion);
        if (partitionedRegionName.equals("A")) {
            PRColocationDUnitTest.assertEquals((int)14, (int)colocatedRegions.size());
        }
        if (partitionedRegionName.equals("D")) {
            PRColocationDUnitTest.assertEquals((int)4, (int)colocatedRegions.size());
        }
        if (partitionedRegionName.equals("H")) {
            PRColocationDUnitTest.assertEquals((int)2, (int)colocatedRegions.size());
        }
        if (partitionedRegionName.equals("B")) {
            PRColocationDUnitTest.assertEquals((int)8, (int)colocatedRegions.size());
        }
        if (partitionedRegionName.equals("K")) {
            PRColocationDUnitTest.assertEquals((int)3, (int)colocatedRegions.size());
        }
    }

    public static void validateBeforePutCustomerPartitionedRegion(String partitionedRegionName) {
        PRColocationDUnitTest.assertNotNull((Object)PRColocationDUnitTest.basicGetCache());
        PartitionedRegion partitionedregion = null;
        try {
            partitionedregion = (PartitionedRegion)PRColocationDUnitTest.basicGetCache().getRegion("/" + partitionedRegionName);
        }
        catch (Exception e) {
            PRColocationDUnitTest.fail("validateBeforePutCustomerPartitionedRegion : Failed while getting the region from cache", e);
        }
        PRColocationDUnitTest.assertNotNull(partitionedregion);
        PRColocationDUnitTest.assertTrue((partitionedregion.getRegionAdvisor().getNumProfiles() == 3 ? 1 : 0) != 0);
        PRColocationDUnitTest.assertTrue((partitionedregion.getRegionAdvisor().getNumDataStores() == 3 ? 1 : 0) != 0);
    }

    public static void validateAfterPutPartitionedRegion(String customerPartitionedRegionName, String orderPartitionedRegionName, String shipmentPartitionedRegionName) throws ClassNotFoundException {
        PRColocationDUnitTest.assertNotNull((Object)PRColocationDUnitTest.basicGetCache());
        PartitionedRegion customerPartitionedregion = null;
        PartitionedRegion orderPartitionedregion = null;
        PartitionedRegion shipmentPartitionedregion = null;
        try {
            customerPartitionedregion = (PartitionedRegion)PRColocationDUnitTest.basicGetCache().getRegion("/" + customerPartitionedRegionName);
            orderPartitionedregion = (PartitionedRegion)PRColocationDUnitTest.basicGetCache().getRegion("/" + orderPartitionedRegionName);
            shipmentPartitionedregion = (PartitionedRegion)PRColocationDUnitTest.basicGetCache().getRegion("/" + shipmentPartitionedRegionName);
        }
        catch (Exception e) {
            PRColocationDUnitTest.fail("validateAfterPutPartitionedRegion : failed while getting the region", e);
        }
        PRColocationDUnitTest.assertNotNull(customerPartitionedregion);
        for (int i = 1; i <= 10; ++i) {
            InternalDistributedMember idmForCustomer = customerPartitionedregion.getBucketPrimary(i);
            InternalDistributedMember idmForOrder = orderPartitionedregion.getBucketPrimary(i);
            InternalDistributedMember idmForShipment = shipmentPartitionedregion.getBucketPrimary(i);
            Set customerKey = customerPartitionedregion.getBucketKeys(i);
            PRColocationDUnitTest.assertNotNull((Object)customerKey);
            for (CustId custId : customerKey) {
                PRColocationDUnitTest.assertNotNull((Object)customerPartitionedregion.get((Object)custId));
                Set orderKey = orderPartitionedregion.getBucketKeys(i);
                PRColocationDUnitTest.assertNotNull((Object)orderKey);
                for (OrderId orderId : orderKey) {
                    if (custId.equals(orderId.getCustId())) {
                        PRColocationDUnitTest.assertEquals((Object)idmForCustomer, (Object)idmForOrder);
                    }
                    Set shipmentKey = shipmentPartitionedregion.getBucketKeys(i);
                    PRColocationDUnitTest.assertNotNull((Object)shipmentKey);
                    for (ShipmentId shipmentId : shipmentKey) {
                        if (!orderId.equals(shipmentId.getOrderId())) continue;
                    }
                }
            }
        }
    }

    protected void createCacheInAllVms() {
        this.dataStore1.invoke(PRColocationDUnitTest.class, "createCacheInVm");
        this.dataStore2.invoke(PRColocationDUnitTest.class, "createCacheInVm");
        this.dataStore3.invoke(PRColocationDUnitTest.class, "createCacheInVm");
        this.accessor.invoke(PRColocationDUnitTest.class, "createCacheInVm");
    }

    public static void putInPartitionedRegion(Region pr) {
        PRColocationDUnitTest.assertNotNull((Object)PRColocationDUnitTest.basicGetCache());
        for (int i = 1; i <= 10; ++i) {
            CustId custid = new CustId(i);
            Customer customer = new Customer("name" + i, "Address" + i);
            try {
                pr.put((Object)custid, (Object)customer);
                PRColocationDUnitTest.assertTrue((boolean)pr.containsKey((Object)custid));
                PRColocationDUnitTest.assertEquals((Object)customer, (Object)pr.get((Object)custid));
                continue;
            }
            catch (Exception e) {
                PRColocationDUnitTest.fail("putInPartitionedRegion : failed while doing put operation in " + pr.getFullPath(), e);
            }
        }
    }

    public static void closeRegion(String partitionedRegionName) {
        PRColocationDUnitTest.assertNotNull((Object)PRColocationDUnitTest.basicGetCache());
        Region partitionedregion = PRColocationDUnitTest.basicGetCache().getRegion("/" + partitionedRegionName);
        PRColocationDUnitTest.assertNotNull((Object)partitionedregion);
        try {
            partitionedregion.close();
        }
        catch (Exception e) {
            PRColocationDUnitTest.fail("closeRegion : failed to close region : " + partitionedregion, e);
        }
    }

    public static void putCustomerPartitionedRegion(String partitionedRegionName) {
        PRColocationDUnitTest.assertNotNull((Object)PRColocationDUnitTest.basicGetCache());
        Region partitionedregion = PRColocationDUnitTest.basicGetCache().getRegion("/" + partitionedRegionName);
        PRColocationDUnitTest.assertNotNull((Object)partitionedregion);
        for (int i = 1; i <= 10; ++i) {
            CustId custid = new CustId(i);
            Customer customer = new Customer("name" + i, "Address" + i);
            try {
                partitionedregion.put((Object)custid, (Object)customer);
                PRColocationDUnitTest.assertTrue((boolean)partitionedregion.containsKey((Object)custid));
                PRColocationDUnitTest.assertEquals((Object)customer, (Object)partitionedregion.get((Object)custid));
                continue;
            }
            catch (Exception e) {
                PRColocationDUnitTest.fail("putCustomerPartitionedRegion : failed while doing put operation in CustomerPartitionedRegion ", e);
            }
        }
    }

    public static void putOrderPartitionedRegion(String partitionedRegionName) {
        PRColocationDUnitTest.assertNotNull((Object)PRColocationDUnitTest.basicGetCache());
        Region partitionedregion = PRColocationDUnitTest.basicGetCache().getRegion("/" + partitionedRegionName);
        PRColocationDUnitTest.assertNotNull((Object)partitionedregion);
        for (int i = 1; i <= 10; ++i) {
            CustId custid = new CustId(i);
            for (int j = 1; j <= 10; ++j) {
                int oid = i * 10 + j;
                OrderId orderId = new OrderId(oid, custid);
                Order order = new Order("OREDR" + oid);
                try {
                    partitionedregion.put((Object)orderId, (Object)order);
                    PRColocationDUnitTest.assertTrue((boolean)partitionedregion.containsKey((Object)orderId));
                    PRColocationDUnitTest.assertEquals((Object)order, (Object)partitionedregion.get((Object)orderId));
                    continue;
                }
                catch (Exception e) {
                    PRColocationDUnitTest.fail("putOrderPartitionedRegion : failed while doing put operation in OrderPartitionedRegion ", e);
                }
            }
        }
    }

    public static void putOrderPartitionedRegion2(String partitionedRegionName) {
        PRColocationDUnitTest.assertNotNull((Object)PRColocationDUnitTest.basicGetCache());
        Region partitionedregion = PRColocationDUnitTest.basicGetCache().getRegion("/" + partitionedRegionName);
        PRColocationDUnitTest.assertNotNull((Object)partitionedregion);
        for (int i = 11; i <= 100; ++i) {
            CustId custid = new CustId(i);
            for (int j = 1; j <= 10; ++j) {
                int oid = i * 10 + j;
                OrderId orderId = new OrderId(oid, custid);
                Order order = new Order("OREDR" + oid);
                try {
                    partitionedregion.put((Object)orderId, (Object)order);
                    PRColocationDUnitTest.assertTrue((boolean)partitionedregion.containsKey((Object)orderId));
                    PRColocationDUnitTest.assertEquals((Object)order, (Object)partitionedregion.get((Object)orderId));
                    continue;
                }
                catch (Exception e) {
                    PRColocationDUnitTest.fail("putOrderPartitionedRegion : failed while doing put operation in OrderPartitionedRegion ", e);
                }
            }
        }
    }

    public static void putShipmentPartitionedRegion(String partitionedRegionName) {
        PRColocationDUnitTest.assertNotNull((Object)PRColocationDUnitTest.basicGetCache());
        Region partitionedregion = PRColocationDUnitTest.basicGetCache().getRegion("/" + partitionedRegionName);
        PRColocationDUnitTest.assertNotNull((Object)partitionedregion);
        for (int i = 1; i <= 10; ++i) {
            CustId custid = new CustId(i);
            for (int j = 1; j <= 10; ++j) {
                int oid = i * 10 + j;
                OrderId orderId = new OrderId(oid, custid);
                for (int k = 1; k <= 10; ++k) {
                    int sid = oid * 10 + k;
                    ShipmentId shipmentId = new ShipmentId(sid, orderId);
                    Shipment shipment = new Shipment("Shipment" + sid);
                    try {
                        partitionedregion.put((Object)shipmentId, (Object)shipment);
                        PRColocationDUnitTest.assertTrue((boolean)partitionedregion.containsKey((Object)shipmentId));
                        PRColocationDUnitTest.assertEquals((Object)shipment, (Object)partitionedregion.get((Object)shipmentId));
                        continue;
                    }
                    catch (Exception e) {
                        PRColocationDUnitTest.fail("putShipmentPartitionedRegion : failed while doing put operation in ShipmentPartitionedRegion ", e);
                    }
                }
            }
        }
    }

    protected void createPartitionedRegion(Object[] attributes) {
        this.dataStore1.invoke(PRColocationDUnitTest.class, "createPR", attributes);
        this.dataStore2.invoke(PRColocationDUnitTest.class, "createPR", attributes);
        this.dataStore3.invoke(PRColocationDUnitTest.class, "createPR", attributes);
        attributes[2] = new Integer(0);
        this.accessor.invoke(PRColocationDUnitTest.class, "createPR", attributes);
    }

    private void createSubPartitionedRegion(Object[] attributes) {
        this.dataStore1.invoke(PRColocationDUnitTest.class, "createSubPR", attributes);
        this.dataStore2.invoke(PRColocationDUnitTest.class, "createSubPR", attributes);
        this.dataStore3.invoke(PRColocationDUnitTest.class, "createSubPR", attributes);
        attributes[2] = new Integer(0);
        this.accessor.invoke(PRColocationDUnitTest.class, "createSubPR", attributes);
    }

    private void createPartitionedRegionOnOneVM(Object[] attributes) {
        this.dataStore1.invoke(PRColocationDUnitTest.class, "createPR", attributes);
    }

    public static void destroyPR(String partitionedRegionName) {
        block2: {
            PRColocationDUnitTest.assertNotNull((Object)PRColocationDUnitTest.basicGetCache());
            Region pr = PRColocationDUnitTest.basicGetCache().getRegion(partitionedRegionName);
            PRColocationDUnitTest.assertNotNull((Object)pr);
            try {
                PRColocationDUnitTest.getLogWriter().info("Destroying Partitioned Region " + partitionedRegionName);
                pr.destroyRegion();
                PRColocationDUnitTest.fail((String)"Did not get the expected ISE");
            }
            catch (Exception e) {
                if (e instanceof IllegalStateException) break block2;
                PRColocationDUnitTest.fail("Expected IllegalStateException, but it's not.", e);
            }
        }
    }

    public static void createPR(String partitionedRegionName, Integer redundancy, Integer localMaxMemory, Integer totalNumBuckets, Object colocatedWith, Boolean isPartitionResolver) {
        PRColocationDUnitTest.createPR(partitionedRegionName, redundancy, localMaxMemory, totalNumBuckets, colocatedWith, isPartitionResolver, Boolean.FALSE);
    }

    public static void createPR(String partitionedRegionName, Integer redundancy, Integer localMaxMemory, Integer totalNumBuckets, Object colocatedWith, Boolean isPartitionResolver, Boolean concurrencyChecks) {
        PartitionAttributesFactory paf = new PartitionAttributesFactory();
        paf.setRedundantCopies(redundancy.intValue()).setLocalMaxMemory(localMaxMemory.intValue()).setTotalNumBuckets(totalNumBuckets.intValue()).setColocatedWith((String)colocatedWith);
        if (isPartitionResolver.booleanValue()) {
            paf.setPartitionResolver((PartitionResolver)new CustomerIDPartitionResolver("CustomerIDPartitionResolver"));
        }
        PartitionAttributes prAttr = paf.create();
        AttributesFactory attr = new AttributesFactory();
        attr.setPartitionAttributes(prAttr);
        attr.setConcurrencyChecksEnabled(concurrencyChecks.booleanValue());
        PRColocationDUnitTest.assertNotNull((Object)PRColocationDUnitTest.basicGetCache());
        Region pr = PRColocationDUnitTest.basicGetCache().createRegion(partitionedRegionName, attr.create());
        PRColocationDUnitTest.assertNotNull((Object)pr);
        PRColocationDUnitTest.getLogWriter().info("Partitioned Region " + partitionedRegionName + " created Successfully :" + pr.toString());
    }

    public static void createSubPR(String partitionedRegionName, Integer redundancy, Integer localMaxMemory, Integer totalNumBuckets, Object colocatedWith, Boolean isPartitionResolver) {
        PartitionAttributesFactory paf = new PartitionAttributesFactory();
        paf.setRedundantCopies(redundancy.intValue()).setLocalMaxMemory(localMaxMemory.intValue()).setTotalNumBuckets(totalNumBuckets.intValue()).setColocatedWith((String)colocatedWith);
        if (isPartitionResolver.booleanValue()) {
            paf.setPartitionResolver((PartitionResolver)new CustomerIDPartitionResolver("CustomerIDPartitionResolver"));
        }
        PartitionAttributes prAttr = paf.create();
        AttributesFactory attr = new AttributesFactory();
        PRColocationDUnitTest.assertNotNull((Object)PRColocationDUnitTest.basicGetCache());
        Region root = PRColocationDUnitTest.basicGetCache().createRegion("root" + partitionedRegionName, attr.create());
        attr.setPartitionAttributes(prAttr);
        Region pr = root.createSubregion(partitionedRegionName, attr.create());
        PRColocationDUnitTest.assertNotNull((Object)pr);
        PRColocationDUnitTest.getLogWriter().info("Partitioned sub region " + pr.getName() + " created Successfully :" + pr.toString());
        if (localMaxMemory == 0) {
            PRColocationDUnitTest.putInPartitionedRegion(pr);
        }
    }

    public static void createCacheInVm() {
        new PRColocationDUnitTest("temp").getCache();
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        PRColocationDUnitTest.invokeInEveryVM(new SerializableRunnable(){

            @Override
            public void run() {
                InternalResourceManager.setResourceObserver(null);
            }
        });
        InternalResourceManager.setResourceObserver(null);
    }

    public static String getDefaultAddOnString() {
        if (defaultStringSize == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer(defaultStringSize);
        for (int i = 0; i < defaultStringSize; ++i) {
            buf.append("a");
        }
        return buf.toString();
    }

    private static class MyResourceObserver
    extends InternalResourceManager.ResourceObserverAdapter {
        Set<Region> recoveredRegions = new HashSet<Region>();

        private MyResourceObserver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void rebalancingOrRecoveryFinished(Region region) {
            MyResourceObserver myResourceObserver = this;
            synchronized (myResourceObserver) {
                this.recoveredRegions.add(region);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForRegion(Region region, long timeout) throws InterruptedException {
            long start = System.currentTimeMillis();
            MyResourceObserver myResourceObserver = this;
            synchronized (myResourceObserver) {
                while (!this.recoveredRegions.contains(region)) {
                    long remaining = timeout - (System.currentTimeMillis() - start);
                    TestCase.assertTrue((String)"Timeout waiting for region recovery", (remaining > 0L ? 1 : 0) != 0);
                    ((Object)((Object)this)).wait(remaining);
                }
            }
        }
    }
}

