/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.execute;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.execute.Execution;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.internal.cache.PartitionAttributesImpl;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionDUnitTestCase;
import com.gemstone.gemfire.internal.cache.PartitionedRegionTestHelper;
import com.gemstone.gemfire.internal.cache.execute.MyFunctionExecutionException;
import com.gemstone.gemfire.internal.cache.functions.TestFunction;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.VM;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import junit.framework.TestCase;

public class FunctionExecution_ExceptionDUnitTest
extends PartitionedRegionDUnitTestCase {
    private static final long serialVersionUID = 1L;

    public FunctionExecution_ExceptionDUnitTest(String name) {
        super(name);
    }

    public void testSingleKeyExecution_SendException_Datastore() throws Exception {
        final String rName = this.getUniqueName();
        Host host = Host.getHost(0);
        VM datastore = host.getVM(3);
        this.getCache();
        datastore.invoke(new SerializableCallable("Create PR with Function Factory"){

            public Object call() throws Exception {
                RegionAttributes ra = PartitionedRegionTestHelper.createRegionAttrsForPR((int)0, (int)10);
                AttributesFactory raf = new AttributesFactory(ra);
                PartitionAttributesImpl pa = new PartitionAttributesImpl();
                pa.setAll(ra.getPartitionAttributes());
                raf.setPartitionAttributes((PartitionAttributes)pa);
                FunctionExecution_ExceptionDUnitTest.this.getCache().createRegion(rName, raf.create());
                TestFunction function = new TestFunction(true, "executeFunction_SendException");
                FunctionService.registerFunction((Function)function);
                return Boolean.TRUE;
            }
        });
        Object o = datastore.invoke(new SerializableCallable("Create data, invoke exectuable"){

            public Object call() throws Exception {
                PartitionedRegion pr = (PartitionedRegion)FunctionExecution_ExceptionDUnitTest.this.getCache().getRegion(rName);
                String testKey = "execKey";
                HashSet<String> testKeysSet = new HashSet<String>();
                testKeysSet.add("execKey");
                DistributedSystem.setThreadsSocketPolicy((boolean)false);
                TestFunction function = new TestFunction(true, "executeFunction_SendException");
                FunctionService.registerFunction((Function)function);
                Execution dataSet = FunctionService.onRegion((Region)pr);
                pr.put((Object)"execKey", (Object)new Integer(1));
                ResultCollector rs1 = null;
                rs1 = dataSet.withFilter(testKeysSet).withArgs((Object)Boolean.TRUE).execute((Function)function);
                ArrayList results = (ArrayList)rs1.getResult();
                TestCase.assertTrue((boolean)(results.get(0) instanceof Exception));
                rs1 = dataSet.withFilter(testKeysSet).withArgs((Object)testKeysSet).execute((Function)function);
                results = (ArrayList)rs1.getResult();
                TestCase.assertEquals((int)(testKeysSet.size() + 1), (int)results.size());
                Iterator resultIterator = results.iterator();
                int exceptionCount = 0;
                while (resultIterator.hasNext()) {
                    Object o = resultIterator.next();
                    if (!(o instanceof MyFunctionExecutionException)) continue;
                    ++exceptionCount;
                }
                TestCase.assertEquals((int)1, (int)exceptionCount);
                return Boolean.TRUE;
            }
        });
        FunctionExecution_ExceptionDUnitTest.assertEquals((Object)Boolean.TRUE, (Object)o);
    }

    public void testSingleKeyExecution_SendException_MultipleTimes_Datastore() throws Exception {
        final String rName = this.getUniqueName();
        Host host = Host.getHost(0);
        VM datastore = host.getVM(3);
        this.getCache();
        datastore.invoke(new SerializableCallable("Create PR with Function Factory"){

            public Object call() throws Exception {
                RegionAttributes ra = PartitionedRegionTestHelper.createRegionAttrsForPR((int)0, (int)10);
                AttributesFactory raf = new AttributesFactory(ra);
                PartitionAttributesImpl pa = new PartitionAttributesImpl();
                pa.setAll(ra.getPartitionAttributes());
                raf.setPartitionAttributes((PartitionAttributes)pa);
                FunctionExecution_ExceptionDUnitTest.this.getCache().createRegion(rName, raf.create());
                TestFunction function = new TestFunction(true, "executeFunction_SendException");
                FunctionService.registerFunction((Function)function);
                return Boolean.TRUE;
            }
        });
        Object o = datastore.invoke(new SerializableCallable("Create data, invoke exectuable"){

            public Object call() throws Exception {
                PartitionedRegion pr = (PartitionedRegion)FunctionExecution_ExceptionDUnitTest.this.getCache().getRegion(rName);
                String testKey = "execKey";
                HashSet<String> testKeysSet = new HashSet<String>();
                testKeysSet.add("execKey");
                DistributedSystem.setThreadsSocketPolicy((boolean)false);
                TestFunction function = new TestFunction(true, "executeFunction_SendException");
                FunctionService.registerFunction((Function)function);
                Execution dataSet = FunctionService.onRegion((Region)pr);
                pr.put((Object)"execKey", (Object)new Integer(1));
                ResultCollector rs1 = null;
                rs1 = dataSet.withFilter(testKeysSet).withArgs((Object)"Multiple").execute((Function)function);
                ArrayList results = (ArrayList)rs1.getResult();
                TestCase.assertTrue((boolean)(results.get(0) instanceof Exception));
                return Boolean.TRUE;
            }
        });
        FunctionExecution_ExceptionDUnitTest.assertEquals((Object)Boolean.TRUE, (Object)o);
    }

    public void testRemoteSingleKeyExecution_ThrowException_Datastore() throws Exception {
        final String rName = this.getUniqueName();
        Host host = Host.getHost(0);
        VM datastore = host.getVM(3);
        datastore.invoke(new SerializableCallable("Create PR with Function Factory"){

            public Object call() throws Exception {
                RegionAttributes ra = PartitionedRegionTestHelper.createRegionAttrsForPR((int)0, (int)10);
                AttributesFactory raf = new AttributesFactory(ra);
                PartitionAttributesImpl pa = new PartitionAttributesImpl();
                pa.setAll(ra.getPartitionAttributes());
                raf.setPartitionAttributes((PartitionAttributes)pa);
                FunctionExecution_ExceptionDUnitTest.this.getCache().createRegion(rName, raf.create());
                TestFunction function = new TestFunction(true, "executeFunction_ThrowException");
                FunctionService.registerFunction((Function)function);
                return Boolean.TRUE;
            }
        });
        Object o = datastore.invoke(new SerializableCallable("Create data, invoke exectuable"){

            public Object call() throws Exception {
                PartitionedRegion pr = (PartitionedRegion)FunctionExecution_ExceptionDUnitTest.this.getCache().getRegion(rName);
                String testKey = "execKey";
                HashSet<String> testKeysSet = new HashSet<String>();
                testKeysSet.add("execKey");
                DistributedSystem.setThreadsSocketPolicy((boolean)false);
                TestFunction function = new TestFunction(true, "executeFunction_ThrowException");
                FunctionService.registerFunction((Function)function);
                Execution dataSet = FunctionService.onRegion((Region)pr);
                pr.put((Object)"execKey", (Object)new Integer(1));
                ResultCollector rs1 = null;
                rs1 = dataSet.withFilter(testKeysSet).withArgs((Object)Boolean.TRUE).execute((Function)function);
                try {
                    ArrayList results = (ArrayList)rs1.getResult();
                    TestCase.fail((String)"Expecting Exception");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        });
        FunctionExecution_ExceptionDUnitTest.assertEquals((Object)Boolean.TRUE, (Object)o);
    }

    public void testRemoteSingleKeyExecution_SendException_Accessor() throws Exception {
        final String rName = this.getUniqueName();
        Host host = Host.getHost(0);
        VM accessor = host.getVM(2);
        VM datastore = host.getVM(3);
        this.getCache();
        accessor.invoke(new SerializableCallable("Create PR"){

            public Object call() throws Exception {
                RegionAttributes ra = PartitionedRegionTestHelper.createRegionAttrsForPR((int)0, (int)0);
                FunctionExecution_ExceptionDUnitTest.this.getCache().createRegion(rName, ra);
                return Boolean.TRUE;
            }
        });
        datastore.invoke(new SerializableCallable("Create PR with Function Factory"){

            public Object call() throws Exception {
                RegionAttributes ra = PartitionedRegionTestHelper.createRegionAttrsForPR((int)0, (int)10);
                AttributesFactory raf = new AttributesFactory(ra);
                PartitionAttributesImpl pa = new PartitionAttributesImpl();
                pa.setAll(ra.getPartitionAttributes());
                raf.setPartitionAttributes((PartitionAttributes)pa);
                FunctionExecution_ExceptionDUnitTest.this.getCache().createRegion(rName, raf.create());
                TestFunction function = new TestFunction(true, "executeFunction_SendException");
                FunctionService.registerFunction((Function)function);
                return Boolean.TRUE;
            }
        });
        Object o = accessor.invoke(new SerializableCallable("Create data, invoke exectuable"){

            public Object call() throws Exception {
                PartitionedRegion pr = (PartitionedRegion)FunctionExecution_ExceptionDUnitTest.this.getCache().getRegion(rName);
                String testKey = "execKey";
                HashSet<String> testKeysSet = new HashSet<String>();
                testKeysSet.add("execKey");
                DistributedSystem.setThreadsSocketPolicy((boolean)false);
                TestFunction function = new TestFunction(true, "executeFunction_SendException");
                FunctionService.registerFunction((Function)function);
                Execution dataSet = FunctionService.onRegion((Region)pr);
                pr.put((Object)"execKey", (Object)new Integer(1));
                ResultCollector rs1 = null;
                rs1 = dataSet.withFilter(testKeysSet).withArgs((Object)testKeysSet).execute((Function)function);
                ArrayList results = (ArrayList)rs1.getResult();
                TestCase.assertEquals((int)(testKeysSet.size() + 1), (int)results.size());
                Iterator resultIterator = results.iterator();
                int exceptionCount = 0;
                while (resultIterator.hasNext()) {
                    Object o = resultIterator.next();
                    if (!(o instanceof MyFunctionExecutionException)) continue;
                    ++exceptionCount;
                }
                TestCase.assertEquals((int)1, (int)exceptionCount);
                return Boolean.TRUE;
            }
        });
        FunctionExecution_ExceptionDUnitTest.assertEquals((Object)Boolean.TRUE, (Object)o);
    }

    public void testRemoteSingleKeyExecution_ThrowException_Accessor() throws Exception {
        final String rName = this.getUniqueName();
        Host host = Host.getHost(0);
        VM accessor = host.getVM(2);
        VM datastore = host.getVM(3);
        this.getCache();
        accessor.invoke(new SerializableCallable("Create PR"){

            public Object call() throws Exception {
                RegionAttributes ra = PartitionedRegionTestHelper.createRegionAttrsForPR((int)0, (int)0);
                FunctionExecution_ExceptionDUnitTest.this.getCache().createRegion(rName, ra);
                return Boolean.TRUE;
            }
        });
        datastore.invoke(new SerializableCallable("Create PR with Function Factory"){

            public Object call() throws Exception {
                RegionAttributes ra = PartitionedRegionTestHelper.createRegionAttrsForPR((int)0, (int)10);
                AttributesFactory raf = new AttributesFactory(ra);
                PartitionAttributesImpl pa = new PartitionAttributesImpl();
                pa.setAll(ra.getPartitionAttributes());
                raf.setPartitionAttributes((PartitionAttributes)pa);
                FunctionExecution_ExceptionDUnitTest.this.getCache().createRegion(rName, raf.create());
                TestFunction function = new TestFunction(true, "executeFunction_ThrowException");
                FunctionService.registerFunction((Function)function);
                return Boolean.TRUE;
            }
        });
        Object o = accessor.invoke(new SerializableCallable("Create data, invoke exectuable"){

            public Object call() throws Exception {
                PartitionedRegion pr = (PartitionedRegion)FunctionExecution_ExceptionDUnitTest.this.getCache().getRegion(rName);
                String testKey = "execKey";
                HashSet<String> testKeysSet = new HashSet<String>();
                testKeysSet.add("execKey");
                DistributedSystem.setThreadsSocketPolicy((boolean)false);
                TestFunction function = new TestFunction(true, "executeFunction_ThrowException");
                FunctionService.registerFunction((Function)function);
                Execution dataSet = FunctionService.onRegion((Region)pr);
                pr.put((Object)"execKey", (Object)new Integer(1));
                ResultCollector rs1 = null;
                rs1 = dataSet.withFilter(testKeysSet).withArgs((Object)Boolean.TRUE).execute((Function)function);
                try {
                    ArrayList results = (ArrayList)rs1.getResult();
                    TestCase.fail((String)"Expecting Exception");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        });
        FunctionExecution_ExceptionDUnitTest.assertEquals((Object)Boolean.TRUE, (Object)o);
    }

    public void testRemoteMultiKeyExecution_SendException() throws Exception {
        final String rName = this.getUniqueName();
        Host host = Host.getHost(0);
        VM accessor = host.getVM(3);
        VM datastore0 = host.getVM(0);
        VM datastore1 = host.getVM(1);
        VM datastore2 = host.getVM(2);
        this.getCache();
        accessor.invoke(new SerializableCallable("Create PR"){

            public Object call() throws Exception {
                RegionAttributes ra = PartitionedRegionTestHelper.createRegionAttrsForPR((int)0, (int)0);
                FunctionExecution_ExceptionDUnitTest.this.getCache().createRegion(rName, ra);
                return Boolean.TRUE;
            }
        });
        SerializableCallable dataStoreCreate = new SerializableCallable("Create PR with Function Factory"){

            public Object call() throws Exception {
                RegionAttributes ra = PartitionedRegionTestHelper.createRegionAttrsForPR((int)0, (int)10);
                AttributesFactory raf = new AttributesFactory(ra);
                PartitionAttributesImpl pa = new PartitionAttributesImpl();
                pa.setAll(ra.getPartitionAttributes());
                raf.setPartitionAttributes((PartitionAttributes)pa);
                FunctionExecution_ExceptionDUnitTest.this.getCache().createRegion(rName, raf.create());
                TestFunction function = new TestFunction(true, "executeFunction_SendException");
                FunctionService.registerFunction((Function)function);
                return Boolean.TRUE;
            }
        };
        datastore0.invoke(dataStoreCreate);
        datastore1.invoke(dataStoreCreate);
        datastore2.invoke(dataStoreCreate);
        Object o = accessor.invoke(new SerializableCallable("Create data, invoke exectuable"){

            public Object call() throws Exception {
                PartitionedRegion pr = (PartitionedRegion)FunctionExecution_ExceptionDUnitTest.this.getCache().getRegion(rName);
                DistributedSystem.setThreadsSocketPolicy((boolean)false);
                TestFunction function = new TestFunction(true, "executeFunction_SendException");
                FunctionService.registerFunction((Function)function);
                Execution dataSet = FunctionService.onRegion((Region)pr);
                HashSet<Integer> origVals = new HashSet<Integer>();
                for (int i = 0; i < 3; ++i) {
                    Integer val = new Integer(i);
                    origVals.add(val);
                    pr.put((Object)val, (Object)("MyValue_" + i));
                }
                ResultCollector rs1 = dataSet.withFilter(origVals).withArgs(origVals).execute((Function)function);
                ArrayList results = (ArrayList)rs1.getResult();
                TestCase.assertEquals((int)(origVals.size() * 3 + 3), (int)results.size());
                Iterator resultIterator = results.iterator();
                int exceptionCount = 0;
                while (resultIterator.hasNext()) {
                    Object o = resultIterator.next();
                    if (!(o instanceof MyFunctionExecutionException)) continue;
                    ++exceptionCount;
                }
                TestCase.assertEquals((int)3, (int)exceptionCount);
                return Boolean.TRUE;
            }
        });
        FunctionExecution_ExceptionDUnitTest.assertEquals((Object)Boolean.TRUE, (Object)o);
    }

    public void testRemoteAllKeyExecution_SendException() throws Exception {
        final String rName = this.getUniqueName();
        Host host = Host.getHost(0);
        VM datastore0 = host.getVM(0);
        VM datastore1 = host.getVM(1);
        VM datastore2 = host.getVM(2);
        VM datastore3 = host.getVM(3);
        this.getCache();
        SerializableCallable dataStoreCreate = new SerializableCallable("Create PR with Function Factory"){

            public Object call() throws Exception {
                RegionAttributes ra = PartitionedRegionTestHelper.createRegionAttrsForPR((int)0, (int)10);
                AttributesFactory raf = new AttributesFactory(ra);
                PartitionAttributesImpl pa = new PartitionAttributesImpl();
                pa.setAll(ra.getPartitionAttributes());
                raf.setPartitionAttributes((PartitionAttributes)pa);
                FunctionExecution_ExceptionDUnitTest.this.getCache().createRegion(rName, raf.create());
                TestFunction function = new TestFunction(true, "executeFunction_SendException");
                FunctionService.registerFunction((Function)function);
                return Boolean.TRUE;
            }
        };
        datastore0.invoke(dataStoreCreate);
        datastore1.invoke(dataStoreCreate);
        datastore2.invoke(dataStoreCreate);
        datastore3.invoke(dataStoreCreate);
        Object o = datastore0.invoke(new SerializableCallable("Create data, invoke exectuable"){

            public Object call() throws Exception {
                PartitionedRegion pr = (PartitionedRegion)FunctionExecution_ExceptionDUnitTest.this.getCache().getRegion(rName);
                DistributedSystem.setThreadsSocketPolicy((boolean)false);
                TestFunction function = new TestFunction(true, "executeFunction_SendException");
                FunctionService.registerFunction((Function)function);
                Execution dataSet = FunctionService.onRegion((Region)pr);
                HashSet<Integer> origVals = new HashSet<Integer>();
                for (int i = 0; i < 4; ++i) {
                    Integer val = new Integer(i);
                    origVals.add(val);
                    pr.put((Object)val, (Object)("MyValue_" + i));
                }
                Object rc2 = null;
                ResultCollector rs1 = dataSet.withFilter(origVals).withArgs(origVals).execute((Function)function);
                ArrayList results = (ArrayList)rs1.getResult();
                TestCase.assertEquals((int)(origVals.size() * 4 + 4), (int)results.size());
                Iterator resultIterator = results.iterator();
                int exceptionCount = 0;
                while (resultIterator.hasNext()) {
                    Object o = resultIterator.next();
                    if (!(o instanceof MyFunctionExecutionException)) continue;
                    ++exceptionCount;
                }
                TestCase.assertEquals((int)4, (int)exceptionCount);
                return Boolean.TRUE;
            }
        });
        FunctionExecution_ExceptionDUnitTest.assertEquals((Object)Boolean.TRUE, (Object)o);
    }

    public void testRemoteMultiKeyExecution_ThrowException() throws Exception {
        final String rName = this.getUniqueName();
        Host host = Host.getHost(0);
        VM accessor = host.getVM(3);
        VM datastore0 = host.getVM(0);
        VM datastore1 = host.getVM(1);
        VM datastore2 = host.getVM(2);
        this.getCache();
        accessor.invoke(new SerializableCallable("Create PR"){

            public Object call() throws Exception {
                RegionAttributes ra = PartitionedRegionTestHelper.createRegionAttrsForPR((int)0, (int)0);
                FunctionExecution_ExceptionDUnitTest.this.getCache().createRegion(rName, ra);
                return Boolean.TRUE;
            }
        });
        SerializableCallable dataStoreCreate = new SerializableCallable("Create PR with Function Factory"){

            public Object call() throws Exception {
                RegionAttributes ra = PartitionedRegionTestHelper.createRegionAttrsForPR((int)0, (int)10);
                AttributesFactory raf = new AttributesFactory(ra);
                PartitionAttributesImpl pa = new PartitionAttributesImpl();
                pa.setAll(ra.getPartitionAttributes());
                raf.setPartitionAttributes((PartitionAttributes)pa);
                FunctionExecution_ExceptionDUnitTest.this.getCache().createRegion(rName, raf.create());
                TestFunction function = new TestFunction(true, "executeFunction_ThrowException");
                FunctionService.registerFunction((Function)function);
                return Boolean.TRUE;
            }
        };
        datastore0.invoke(dataStoreCreate);
        datastore1.invoke(dataStoreCreate);
        datastore2.invoke(dataStoreCreate);
        Object o = accessor.invoke(new SerializableCallable("Create data, invoke exectuable"){

            public Object call() throws Exception {
                PartitionedRegion pr = (PartitionedRegion)FunctionExecution_ExceptionDUnitTest.this.getCache().getRegion(rName);
                DistributedSystem.setThreadsSocketPolicy((boolean)false);
                TestFunction function = new TestFunction(true, "executeFunction_ThrowException");
                FunctionService.registerFunction((Function)function);
                Execution dataSet = FunctionService.onRegion((Region)pr);
                HashSet<Integer> origVals = new HashSet<Integer>();
                for (int i = 0; i < 3; ++i) {
                    Integer val = new Integer(i);
                    origVals.add(val);
                    pr.put((Object)val, (Object)("MyValue_" + i));
                }
                ResultCollector rc2 = null;
                rc2 = dataSet.withFilter(origVals).withArgs(origVals).execute(function.getId());
                try {
                    ArrayList results = (ArrayList)rc2.getResult();
                    TestCase.fail((String)"Expecting Exception");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        });
        FunctionExecution_ExceptionDUnitTest.assertEquals((Object)Boolean.TRUE, (Object)o);
    }

    public void testRemoteAllKeyExecution_ThrowException() throws Exception {
        final String rName = this.getUniqueName();
        Host host = Host.getHost(0);
        VM datastore0 = host.getVM(0);
        VM datastore1 = host.getVM(1);
        VM datastore2 = host.getVM(2);
        VM datastore3 = host.getVM(3);
        this.getCache();
        SerializableCallable dataStoreCreate = new SerializableCallable("Create PR with Function Factory"){

            public Object call() throws Exception {
                RegionAttributes ra = PartitionedRegionTestHelper.createRegionAttrsForPR((int)0, (int)10);
                AttributesFactory raf = new AttributesFactory(ra);
                PartitionAttributesImpl pa = new PartitionAttributesImpl();
                pa.setAll(ra.getPartitionAttributes());
                raf.setPartitionAttributes((PartitionAttributes)pa);
                FunctionExecution_ExceptionDUnitTest.this.getCache().createRegion(rName, raf.create());
                TestFunction function = new TestFunction(true, "executeFunction_ThrowException");
                FunctionService.registerFunction((Function)function);
                return Boolean.TRUE;
            }
        };
        datastore0.invoke(dataStoreCreate);
        datastore1.invoke(dataStoreCreate);
        datastore2.invoke(dataStoreCreate);
        datastore3.invoke(dataStoreCreate);
        Object o = datastore0.invoke(new SerializableCallable("Create data, invoke exectuable"){

            public Object call() throws Exception {
                PartitionedRegion pr = (PartitionedRegion)FunctionExecution_ExceptionDUnitTest.this.getCache().getRegion(rName);
                DistributedSystem.setThreadsSocketPolicy((boolean)false);
                TestFunction function = new TestFunction(true, "executeFunction_ThrowException");
                FunctionService.registerFunction((Function)function);
                Execution dataSet = FunctionService.onRegion((Region)pr);
                HashSet<Integer> origVals = new HashSet<Integer>();
                for (int i = 0; i < 4; ++i) {
                    Integer val = new Integer(i);
                    origVals.add(val);
                    pr.put((Object)val, (Object)("MyValue_" + i));
                }
                ResultCollector rc2 = null;
                rc2 = dataSet.withFilter(origVals).withArgs(origVals).execute(function.getId());
                try {
                    ArrayList results = (ArrayList)rc2.getResult();
                    TestCase.fail((String)"Expecting Exception");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        });
        FunctionExecution_ExceptionDUnitTest.assertEquals((Object)Boolean.TRUE, (Object)o);
    }
}

