/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionEvent;
import com.gemstone.gemfire.cache.util.Gateway;
import com.gemstone.gemfire.cache.util.GatewayHub;
import com.gemstone.gemfire.cache.util.GatewayQueueAttributes;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.AvailablePort;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.util.Properties;
import junit.framework.TestCase;

public class WanTXValidationDUnitTest
extends DistributedTestCase {
    private static final String REGION_NAME = "WanTXValidationDUnitTest_region";
    private static Cache cache = null;
    VM accessor1 = null;
    VM accessor2 = null;
    VM datastore1 = null;
    VM datastore2 = null;
    private static String key1 = "key1";
    private static String key2 = "key2";
    private static int lastUpdatedVal = 199;
    static WanTXValidationDUnitTest impl;

    public WanTXValidationDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        WanTXValidationDUnitTest.disconnectAllFromDS();
        WanTXValidationDUnitTest.pause(5000);
        Host host = Host.getHost(0);
        this.datastore1 = host.getVM(0);
        this.datastore2 = host.getVM(1);
        this.accessor1 = host.getVM(2);
        this.accessor2 = host.getVM(3);
    }

    public static void createImpl() {
        impl = new WanTXValidationDUnitTest("temp");
    }

    public void testPutAndCommitInTheDatastoreWithGatewayInDS() {
        this.doBasicTest(this.datastore1, this.datastore2, null, null, this.datastore1, this.datastore2, true);
    }

    public void DISABLED_TILL_NEW_TX_IMPL_COMPLETE_testPutAndCommitInTheDatastoreWithGatewayInAccessor() {
        this.doBasicTest(this.accessor1, this.accessor2, this.datastore1, this.datastore2, this.datastore1, this.datastore2, false);
    }

    public void DISABLED_TILL_NEW_TX_IMPL_COMPLETE_testPutAndCommitInTheAccessorWithGatewayInAccessor() {
        this.doBasicTest(this.accessor1, this.accessor2, this.datastore1, this.datastore2, this.accessor1, this.accessor2, false);
    }

    public void testPutAndCommitInTheAccessorWithGatewayInDatastore() {
        this.doBasicTest(this.datastore1, this.datastore2, this.accessor1, this.accessor2, this.accessor1, this.accessor2, true);
    }

    public void doBasicTest(VM gnode1, VM gnode2, VM anode1, VM anode2, VM doPuts1, VM doPuts2, boolean storageInGateway) {
        gnode1.invoke(this.getClass(), "createImpl", null);
        gnode2.invoke(this.getClass(), "createImpl", null);
        if (anode1 != null) {
            anode1.invoke(this.getClass(), "createImpl", null);
            anode2.invoke(this.getClass(), "createImpl", null);
        }
        int ePort2 = new Integer(AvailablePort.getRandomAvailablePort((int)0));
        int ePort1 = new Integer(AvailablePort.getRandomAvailablePort((int)0));
        int mcast_port1 = AvailablePort.getRandomAvailablePort((int)1);
        int mcast_port2 = AvailablePort.getRandomAvailablePort((int)1);
        gnode1.invoke(this.getClass(), "createServerCache", new Object[]{"EU", "NY", ePort1, ePort2, WanTXValidationDUnitTest.getServerHostName(gnode1.getHost()), mcast_port1, true, storageInGateway});
        if (anode1 != null) {
            anode1.invoke(this.getClass(), "createServerCache", new Object[]{"EU", "NY", ePort1, ePort2, WanTXValidationDUnitTest.getServerHostName(anode1.getHost()), mcast_port1, false, !storageInGateway});
        }
        gnode2.invoke(this.getClass(), "createServerCache", new Object[]{"NY", "EU", ePort2, ePort1, WanTXValidationDUnitTest.getServerHostName(gnode2.getHost()), mcast_port2, true, storageInGateway});
        if (anode2 != null) {
            anode2.invoke(this.getClass(), "createServerCache", new Object[]{"NY", "EU", ePort2, ePort1, WanTXValidationDUnitTest.getServerHostName(anode2.getHost()), mcast_port2, false, !storageInGateway});
        }
        try {
            Thread.sleep(10000L);
            doPuts1.invoke(this.getClass(), "doPuts", new Object[]{key1});
            doPuts2.invoke(this.getClass(), "doPuts", new Object[]{key2});
            Thread.sleep(10000L);
        }
        catch (InterruptedException e) {
            WanTXValidationDUnitTest.fail((String)"interrupted");
        }
        gnode2.invoke(this.getClass(), "doGet", new Object[]{new Integer(2)});
        gnode1.invoke(this.getClass(), "doGet", new Object[]{new Integer(2)});
        if (anode1 != null) {
            anode2.invoke(this.getClass(), "doGet", new Object[]{new Integer(2)});
            anode1.invoke(this.getClass(), "doGet", new Object[]{new Integer(2)});
        }
    }

    public static Object createServerCache(String myHubId, String hubImSendingTo, Integer listenOnPort, Integer sendToPort, String host, int mcast_port, boolean enableStorage, boolean enableGateway) throws Exception {
        Properties props = new Properties();
        props.setProperty("mcast-port", mcast_port + "");
        props.setProperty("locators", "");
        cache = impl.createCache(props);
        AttributesFactory factory = impl.getServerCacheAttributesFactory(enableStorage);
        factory.setEnableGateway(true);
        factory.setCloningEnabled(false);
        factory.setCacheListener(new CacheListener(){

            public void afterCreate(EntryEvent event) {
            }

            public void afterDestroy(EntryEvent event) {
            }

            public void afterInvalidate(EntryEvent event) {
            }

            public void afterRegionClear(RegionEvent event) {
            }

            public void afterRegionCreate(RegionEvent event) {
            }

            public void afterRegionDestroy(RegionEvent event) {
            }

            public void afterRegionInvalidate(RegionEvent event) {
            }

            public void afterRegionLive(RegionEvent event) {
            }

            public void afterUpdate(EntryEvent event) {
            }

            public void close() {
            }
        });
        RegionAttributes attrs = factory.create();
        cache.createRegion(REGION_NAME, attrs);
        if (enableGateway) {
            GatewayHub hub1 = cache.addGatewayHub(myHubId, listenOnPort.intValue());
            Gateway gateway1 = hub1.addGateway(hubImSendingTo);
            gateway1.addEndpoint("dont matter", host, sendToPort.intValue());
            GatewayQueueAttributes queueAttributes = gateway1.getQueueAttributes();
            queueAttributes.setMaximumQueueMemory(1);
            queueAttributes.setBatchSize(1);
            WanTXValidationDUnitTest.setDiskStoreForGateway(cache, gateway1.getId(), queueAttributes);
            hub1.start();
            gateway1.start();
        }
        return new Integer(0);
    }

    protected AttributesFactory getServerCacheAttributesFactory(boolean enableStorage) {
        AttributesFactory factory = new AttributesFactory();
        PartitionAttributesFactory paf = new PartitionAttributesFactory();
        factory.setDataPolicy(DataPolicy.PARTITION);
        paf.setRedundantCopies(0).setTotalNumBuckets(1);
        if (!enableStorage) {
            paf.setLocalMaxMemory(0);
        }
        factory.setPartitionAttributes(paf.create());
        return factory;
    }

    private Cache createCache(Properties props) throws Exception {
        InternalDistributedSystem ds = this.getSystem(props);
        Cache cache = null;
        cache = CacheFactory.create((DistributedSystem)ds);
        if (cache == null) {
            throw new Exception("CacheFactory.create() returned null ");
        }
        return cache;
    }

    @Override
    public void tearDown2() throws Exception {
        this.datastore1.invoke(this.getClass(), "closeCache");
        this.datastore2.invoke(this.getClass(), "closeCache");
    }

    public static void closeCache() {
        if (cache != null && !cache.isClosed()) {
            cache.close();
            cache.getDistributedSystem().disconnect();
        }
    }

    public static void doPuts(String key) throws Exception {
        Region region1 = cache.getRegion("/WanTXValidationDUnitTest_region");
        for (int i = 1; i < 200; ++i) {
            String obj = "sup" + i;
            cache.getLogger().info("put happened value : " + obj);
            region1.getCache().getCacheTransactionManager().begin();
            region1.put((Object)key, (Object)obj);
            region1.getCache().getCacheTransactionManager().commit();
        }
        cache.getLogger().info("put happened for key : " + key);
    }

    public static void doGet(final Integer n) throws Exception {
        final Region reg = cache.getRegion("/WanTXValidationDUnitTest_region");
        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){
            String excuse;

            @Override
            public boolean done() {
                int curSize = reg.keySet().size();
                if (n == curSize) {
                    TestCase.assertTrue((String)("was supposed to be:" + lastUpdatedVal + " but was " + ((String)reg.get((Object)key1)).substring(3)), (boolean)((String)reg.get((Object)key1)).substring(3).equals("" + lastUpdatedVal));
                    TestCase.assertTrue((String)("was supposed to be:" + lastUpdatedVal + " but was " + ((String)reg.get((Object)key2)).substring(3)), (boolean)((String)reg.get((Object)key2)).substring(3).equals("" + lastUpdatedVal));
                    return true;
                }
                this.excuse = "Current size " + curSize + " not expected size " + n;
                return false;
            }

            @Override
            public String description() {
                return this.excuse;
            }
        };
        DistributedTestCase.waitForCriterion(wc, 120000L, 1000L, true);
    }
}

