/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.DiskStore;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionFactory;
import com.gemstone.gemfire.cache.RegionShortcut;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.FileUtil;
import com.gemstone.gemfire.internal.SocketCreator;
import com.gemstone.gemfire.internal.cache.CacheObserver;
import com.gemstone.gemfire.internal.cache.CacheObserverAdapter;
import com.gemstone.gemfire.internal.cache.CacheObserverHolder;
import com.gemstone.gemfire.internal.cache.DiskStoreImpl;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.versions.VersionTag;
import com.gemstone.gemfire.internal.shared.Version;
import dunit.AsyncInvocation;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.VM;
import hydra.HostDescription;
import hydra.HostHelper;
import hydra.HydraConfigException;
import hydra.Log;
import hydra.ProcessMgr;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import hydra.VersionDescription;
import java.io.File;
import java.rmi.RemoteException;
import junit.framework.TestCase;

public class UpgradeDiskStoreDUnitTest
extends CacheTestCase {
    final int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
    final String member1_dir = "member1_dir";
    final String member2_dir = "member2_dir";
    final String member1_dir4test = "member1_dir4test";
    final String member2_dir4test = "member2_dir4test";
    int pid1;
    int pid2;

    public UpgradeDiskStoreDUnitTest(String name) {
        super(name);
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        hydra.FileUtil.rmdir("member1_dir4test", false);
        hydra.FileUtil.rmdir("member2_dir4test", false);
        this.removePID(this.pid1);
        this.removePID(this.pid2);
    }

    public void testPRCases() throws Throwable {
        this.prepPR();
        this.doPRTest();
        this.retryPRTest();
    }

    public void prepPR() throws Throwable {
        this.createTestData("662", true);
    }

    public void doPRTest() throws Throwable {
        UpgradeDiskStoreDUnitTest.disconnectAllFromDS();
        FileUtil.copy((File)new File("member1_dir"), (File)new File("member1_dir4test"));
        FileUtil.copy((File)new File("member2_dir"), (File)new File("member2_dir4test"));
        this.do_normal(true, true, false);
    }

    public void retryPRTest() throws Throwable {
        UpgradeDiskStoreDUnitTest.disconnectAllFromDS();
        FileUtil.copy((File)new File("member1_dir"), (File)new File("member1_dir4test"));
        FileUtil.copy((File)new File("member2_dir"), (File)new File("member2_dir4test"));
        this.do_negative(true, true);
    }

    public void testDRCases() throws Throwable {
        this.prepDR();
        this.doDRTest();
        this.retryDRTest();
        this.doDR_RecoveryOnly();
    }

    public void prepDR() throws Throwable {
        this.createTestData("662", false);
    }

    public void doDRTest() throws Throwable {
        UpgradeDiskStoreDUnitTest.disconnectAllFromDS();
        FileUtil.copy((File)new File("member1_dir"), (File)new File("member1_dir4test"));
        FileUtil.copy((File)new File("member2_dir"), (File)new File("member2_dir4test"));
        this.do_normal(false, true, false);
    }

    public void retryDRTest() throws Throwable {
        UpgradeDiskStoreDUnitTest.disconnectAllFromDS();
        FileUtil.copy((File)new File("member1_dir"), (File)new File("member1_dir4test"));
        FileUtil.copy((File)new File("member2_dir"), (File)new File("member2_dir4test"));
        this.do_negative(false, true);
    }

    public void doDR_RecoveryOnly() throws Throwable {
        UpgradeDiskStoreDUnitTest.disconnectAllFromDS();
        FileUtil.copy((File)new File("member1_dir"), (File)new File("member1_dir4test"));
        FileUtil.copy((File)new File("member2_dir"), (File)new File("member2_dir4test"));
        try {
            DiskStoreImpl.validate((String)"ds1", (File[])this.getDiskDirsForMember("member1_dir4test"));
            UpgradeDiskStoreDUnitTest.fail((String)"Exception was not triggered");
        }
        catch (RuntimeException rte) {
            UpgradeDiskStoreDUnitTest.assertTrue((boolean)rte.getMessage().contains("This disk store is still at version GFE pre-7.0"));
        }
        try {
            DiskStoreImpl.validate((String)"ds2", (File[])this.getDiskDirsForMember("member1_dir4test"));
            UpgradeDiskStoreDUnitTest.fail((String)"Exception was not triggered");
        }
        catch (RuntimeException rte) {
            UpgradeDiskStoreDUnitTest.assertTrue((boolean)rte.getMessage().contains("This disk store is still at version GFE pre-7.0"));
        }
        this.do_normal(false, true, true);
    }

    public void testDR651() throws Throwable {
        this.prepDR651();
        this.doTestDR651();
    }

    public void prepDR651() throws Throwable {
        this.createTestData("651", false);
    }

    public void doTestDR651() throws Throwable {
        UpgradeDiskStoreDUnitTest.disconnectAllFromDS();
        FileUtil.copy((File)new File("member1_dir"), (File)new File("member1_dir4test"));
        FileUtil.copy((File)new File("member2_dir"), (File)new File("member2_dir4test"));
        this.do_normal(false, true, false);
    }

    protected void do_normal(boolean isPR, boolean upgradeVersionOnly, boolean doRecoveryOnly) throws Throwable {
        int i;
        if (!doRecoveryOnly) {
            UpgradeDiskStoreDUnitTest.printDirectory("member1_dir4test", "before do_normal isPR=" + isPR);
            UpgradeDiskStoreDUnitTest.printDirectory("member2_dir4test", "before do_normal isPR=" + isPR);
            DiskStoreImpl ds1_member1 = DiskStoreImpl.offlineCompact((String)"ds1", (File[])this.getDiskDirsForMember("member1_dir4test"), (boolean)upgradeVersionOnly, (long)1L);
            DiskStoreImpl ds2_member1 = DiskStoreImpl.offlineCompact((String)"ds2", (File[])this.getDiskDirsForMember("member1_dir4test"), (boolean)upgradeVersionOnly, (long)1L);
            File drfFile1 = new File("member1_dir4test", "BACKUPds1_2.drf");
            File drfFile2 = new File("member1_dir4test", "BACKUPds2_2.drf");
            UpgradeDiskStoreDUnitTest.assertTrue((!drfFile1.exists() ? 1 : 0) != 0);
            UpgradeDiskStoreDUnitTest.assertTrue((!drfFile2.exists() ? 1 : 0) != 0);
            UpgradeDiskStoreDUnitTest.assertEquals((Object)Version.CURRENT, (Object)ds1_member1.getRecoveredGFVersion());
            UpgradeDiskStoreDUnitTest.assertEquals((Object)Version.CURRENT, (Object)ds2_member1.getRecoveredGFVersion());
            DiskStoreImpl.validate((String)"ds1", (File[])this.getDiskDirsForMember("member1_dir4test"));
            DiskStoreImpl.validate((String)"ds2", (File[])this.getDiskDirsForMember("member1_dir4test"));
            DiskStoreImpl ds1_member2 = DiskStoreImpl.offlineCompact((String)"ds1", (File[])this.getDiskDirsForMember("member2_dir4test"), (boolean)upgradeVersionOnly, (long)1L);
            DiskStoreImpl ds2_member2 = DiskStoreImpl.offlineCompact((String)"ds2", (File[])this.getDiskDirsForMember("member2_dir4test"), (boolean)upgradeVersionOnly, (long)1L);
            File drfFile12 = new File("member2_dir4test", "BACKUPds1_2.drf");
            File drfFile22 = new File("member2_dir4test", "BACKUPds2_2.drf");
            UpgradeDiskStoreDUnitTest.assertTrue((!drfFile12.exists() ? 1 : 0) != 0);
            UpgradeDiskStoreDUnitTest.assertTrue((!drfFile22.exists() ? 1 : 0) != 0);
            UpgradeDiskStoreDUnitTest.assertEquals((Object)Version.CURRENT, (Object)ds1_member2.getRecoveredGFVersion());
            UpgradeDiskStoreDUnitTest.assertEquals((Object)Version.CURRENT, (Object)ds2_member2.getRecoveredGFVersion());
            DiskStoreImpl.validate((String)"ds1", (File[])this.getDiskDirsForMember("member2_dir4test"));
            DiskStoreImpl.validate((String)"ds2", (File[])this.getDiskDirsForMember("member2_dir4test"));
        }
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        AsyncInvocation inst0 = this.createPeerCache(vm0, this.mcastPort, "region1", isPR, "member1_dir4test", "ds1");
        AsyncInvocation inst1 = this.createPeerCache(vm0, this.mcastPort, "region2", isPR, "member1_dir4test", "ds2");
        AsyncInvocation inst2 = this.createPeerCache(vm1, this.mcastPort, "region1", isPR, "member2_dir4test", "ds1");
        AsyncInvocation inst3 = this.createPeerCache(vm1, this.mcastPort, "region2", isPR, "member2_dir4test", "ds2");
        inst0.join(30000L);
        inst1.join(30000L);
        inst2.join(30000L);
        inst3.join(30000L);
        if (doRecoveryOnly) {
            UpgradeDiskStoreDUnitTest.assertTrue((boolean)inst0.exceptionOccurred());
            UpgradeDiskStoreDUnitTest.assertTrue((boolean)inst1.exceptionOccurred());
            UpgradeDiskStoreDUnitTest.assertTrue((boolean)inst2.exceptionOccurred());
            UpgradeDiskStoreDUnitTest.assertTrue((boolean)inst3.exceptionOccurred());
            Throwable t = inst0.getException();
            UpgradeDiskStoreDUnitTest.assertTrue((boolean)t.getMessage().contains("This disk store is still at version GFE pre-7.0"));
        }
        if (inst0.exceptionOccurred() || inst1.exceptionOccurred() || inst2.exceptionOccurred() || inst3.exceptionOccurred()) {
            return;
        }
        VersionTag[] tagsFromVm0 = new VersionTag[4];
        for (int i2 = 0; i2 < 4; ++i2) {
            tagsFromVm0[i2] = this.getVersionTag(vm0, "region1", "key" + (1 + i2));
        }
        VersionTag[] tagsFromVm1 = new VersionTag[4];
        for (int i3 = 0; i3 < 4; ++i3) {
            tagsFromVm1[i3] = this.getVersionTag(vm1, "region1", "key" + (1 + i3));
        }
        int region1size = this.getRegionSize(vm0, "region1");
        int region2size = this.getRegionSize(vm1, "region2");
        UpgradeDiskStoreDUnitTest.assertEquals((int)1027, (int)region1size);
        UpgradeDiskStoreDUnitTest.assertEquals((int)1027, (int)region2size);
        String v1 = this.getValue(vm0, "region1", "key1");
        String v2 = this.getValue(vm0, "region1", "key2");
        String v3 = this.getValue(vm0, "region1", "key3");
        UpgradeDiskStoreDUnitTest.assertNull((Object)v1);
        UpgradeDiskStoreDUnitTest.assertNull((Object)v2);
        UpgradeDiskStoreDUnitTest.assertNull((Object)v3);
        UpgradeDiskStoreDUnitTest.assertNull((Object)tagsFromVm0[0]);
        UpgradeDiskStoreDUnitTest.assertNull((Object)tagsFromVm0[1]);
        UpgradeDiskStoreDUnitTest.assertNull((Object)tagsFromVm1[0]);
        UpgradeDiskStoreDUnitTest.assertNull((Object)tagsFromVm1[1]);
        UpgradeDiskStoreDUnitTest.assertTrue((boolean)tagsFromVm1[2].equals((Object)tagsFromVm0[2]));
        UpgradeDiskStoreDUnitTest.assertTrue((boolean)tagsFromVm1[3].equals((Object)tagsFromVm0[3]));
        UpgradeDiskStoreDUnitTest.assertEquals((int)UpgradeDiskStoreDUnitTest.expectedDummyEntryVersion(), (int)tagsFromVm1[2].getEntryVersion());
        UpgradeDiskStoreDUnitTest.assertEquals((int)UpgradeDiskStoreDUnitTest.expectedDummyEntryVersion(), (int)tagsFromVm1[3].getEntryVersion());
        String v4 = this.getValue(vm0, "region1", "key4");
        String v5 = this.getValue(vm0, "region1", "key5");
        UpgradeDiskStoreDUnitTest.assertTrue((boolean)v4.equals("value4"));
        UpgradeDiskStoreDUnitTest.assertTrue((boolean)v5.equals("value6"));
        v4 = this.getValue(vm1, "region1", "key4");
        v5 = this.getValue(vm1, "region1", "key5");
        UpgradeDiskStoreDUnitTest.assertTrue((boolean)v4.equals("value4"));
        UpgradeDiskStoreDUnitTest.assertTrue((boolean)v5.equals("value6"));
        tagsFromVm0 = new VersionTag[1024];
        for (i = 0; i < 1024; ++i) {
            tagsFromVm0[i] = this.getVersionTag(vm0, "region1", "" + i);
        }
        tagsFromVm1 = new VersionTag[1024];
        for (i = 0; i < 1024; ++i) {
            tagsFromVm1[i] = this.getVersionTag(vm1, "region1", "" + i);
            UpgradeDiskStoreDUnitTest.assertTrue((boolean)tagsFromVm1[i].equals((Object)tagsFromVm0[i]));
        }
        vm0.invoke(new CacheSerializableRunnable("close cache"){

            @Override
            public void run2() throws CacheException {
                Cache cache = UpgradeDiskStoreDUnitTest.this.getCache();
                cache.close();
            }
        });
        vm1.invoke(new CacheSerializableRunnable("close cache"){

            @Override
            public void run2() throws CacheException {
                Cache cache = UpgradeDiskStoreDUnitTest.this.getCache();
                cache.close();
            }
        });
        try {
            DiskStoreImpl.offlineCompact((String)"ds1", (File[])this.getDiskDirsForMember("member1_dir4test"), (boolean)true, (long)1L);
            UpgradeDiskStoreDUnitTest.fail((String)"Did not throw the expected exception");
        }
        catch (RuntimeException rte) {
            UpgradeDiskStoreDUnitTest.assertTrue((boolean)rte.getMessage().contains("This disk store is already at version " + Version.CURRENT));
        }
        try {
            DiskStoreImpl.offlineCompact((String)"ds2", (File[])this.getDiskDirsForMember("member1_dir4test"), (boolean)true, (long)1L);
            UpgradeDiskStoreDUnitTest.fail((String)"Did not throw the expected exception");
        }
        catch (RuntimeException rte) {
            UpgradeDiskStoreDUnitTest.assertTrue((boolean)rte.getMessage().contains("This disk store is already at version " + Version.CURRENT));
        }
        try {
            DiskStoreImpl.offlineCompact((String)"ds1", (File[])this.getDiskDirsForMember("member2_dir4test"), (boolean)true, (long)1L);
            UpgradeDiskStoreDUnitTest.fail((String)"Did not throw the expected exception");
        }
        catch (RuntimeException rte) {
            UpgradeDiskStoreDUnitTest.assertTrue((boolean)rte.getMessage().contains("This disk store is already at version " + Version.CURRENT));
        }
        try {
            DiskStoreImpl.offlineCompact((String)"ds2", (File[])this.getDiskDirsForMember("member2_dir4test"), (boolean)true, (long)1L);
            UpgradeDiskStoreDUnitTest.fail((String)"Did not throw the expected exception");
        }
        catch (RuntimeException rte) {
            UpgradeDiskStoreDUnitTest.assertTrue((boolean)rte.getMessage().contains("This disk store is already at version " + Version.CURRENT));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void do_negative(boolean isPR, boolean upgradeVersionOnly) throws Throwable {
        try {
            LocalRegion.ISSUE_CALLBACKS_TO_CACHE_OBSERVER = true;
            CacheObserverHolder.setInstance((CacheObserver)new CacheObserverAdapter(){

                public void afterSwitchingOplog() {
                    throw new RuntimeException("Abort convertion after switched oplog");
                }
            });
            try {
                DiskStoreImpl.offlineCompact((String)"ds1", (File[])this.getDiskDirsForMember("member1_dir4test"), (boolean)upgradeVersionOnly, (long)1L);
                UpgradeDiskStoreDUnitTest.fail((String)"CacheObserver was not triggered");
            }
            catch (RuntimeException rte) {
                if (!rte.getMessage().contains("Abort convertion after switched oplog")) {
                    UpgradeDiskStoreDUnitTest.getLogWriter().info("expected an exception saying 'Abort converted' but received this instead:", (Throwable)rte);
                }
                UpgradeDiskStoreDUnitTest.assertTrue((boolean)rte.getMessage().contains("Abort convertion after switched oplog"));
            }
            UpgradeDiskStoreDUnitTest.pause(3000);
            try {
                DiskStoreImpl.offlineCompact((String)"ds2", (File[])this.getDiskDirsForMember("member1_dir4test"), (boolean)upgradeVersionOnly, (long)1L);
                UpgradeDiskStoreDUnitTest.fail((String)"CacheObserver was not triggered");
            }
            catch (RuntimeException rte) {
                UpgradeDiskStoreDUnitTest.assertTrue((boolean)rte.getMessage().contains("Abort convertion after switched oplog"));
            }
            UpgradeDiskStoreDUnitTest.printDirectory("member1_dir4test", "after do_negative isPR=" + isPR);
        }
        finally {
            LocalRegion.ISSUE_CALLBACKS_TO_CACHE_OBSERVER = false;
            CacheObserverHolder.setInstance(null);
        }
        this.do_normal(isPR, upgradeVersionOnly, false);
    }

    public File[] getDiskDirsForMember(String member_dir) {
        File dir = new File(member_dir);
        return new File[]{dir};
    }

    protected void createTestData(String version, boolean isPR) throws Throwable {
        hydra.FileUtil.rmdir("member1_dir", false);
        hydra.FileUtil.rmdir("member2_dir", false);
        this.pid1 = this.runScript(version, "member1_dir", isPR, false, false);
        this.pid2 = this.runScript(version, "member2_dir", isPR, true, false);
        String host = HostHelper.getLocalHost();
        int maxWaitSec = 300;
        if (!ProcessMgr.waitForDeath(host, this.pid1, maxWaitSec)) {
            UpgradeDiskStoreDUnitTest.fail((String)("The " + this.pid1 + " is still running"));
        }
        if (!ProcessMgr.waitForDeath(host, this.pid2, maxWaitSec)) {
            UpgradeDiskStoreDUnitTest.fail((String)("The " + this.pid2 + " is still running"));
        }
        File crfFile1 = new File("member1_dir", "BACKUPds1_2.crf");
        File crfFile2 = new File("member1_dir", "BACKUPds2_2.crf");
        File drfFile1 = new File("member1_dir", "BACKUPds1_2.drf");
        File drfFile2 = new File("member1_dir", "BACKUPds2_2.drf");
        UpgradeDiskStoreDUnitTest.assertEquals((boolean)true, (boolean)crfFile1.exists());
        UpgradeDiskStoreDUnitTest.assertEquals((boolean)true, (boolean)crfFile2.exists());
        UpgradeDiskStoreDUnitTest.assertEquals((boolean)true, (boolean)drfFile1.exists());
        UpgradeDiskStoreDUnitTest.assertEquals((boolean)true, (boolean)drfFile2.exists());
    }

    public static String getGemfireLocation(String version) {
        if (version.equals("default")) {
            String gemfire = System.getProperty("gemfire.home");
            if (gemfire == null) {
                gemfire = System.getProperty("JTESTS") + "/../../product";
            }
            return gemfire;
        }
        String gemfireHome = version.equals("default") ? "default" : System.getProperty("RELEASE_DIR", "/export/gcm/where/gemfire/releases") + "/GemFire" + VersionDescription.dotVersionFor(version) + "-all/product";
        return gemfireHome;
    }

    protected int runScript(String version, String diskdir, boolean isPR, boolean doOps, boolean isSDA) throws Throwable {
        String javacmd = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
        String jtests = System.getProperty("JTESTS");
        String userDir = System.getProperty("user.dir");
        String oldgemfire = UpgradeDiskStoreDUnitTest.getGemfireLocation(version);
        String classpath = " -cp " + oldgemfire + File.separator + "lib" + File.separator + "gemfire.jar" + File.pathSeparator + jtests;
        String command = javacmd + classpath + " com.gemstone.gemfire.internal.cache.RunCacheInOldGemfire " + this.mcastPort + " " + diskdir + " " + isPR + " " + doOps + " " + isSDA + " " + SocketCreator.getLocalHost().getHostAddress();
        if (Log.getLogWriter() == null) {
            Log.createLogWriter("script.log", "info");
        }
        Log.getLogWriter().info("Running script: current directory is " + userDir);
        int pid = ProcessMgr.bgexec(command);
        Log.getLogWriter().info("Running script: calling " + command + " at pid " + pid);
        this.recordPID(pid);
        return pid;
    }

    protected void recordPID(int pid) throws RemoteException {
        String gemfireName = System.getProperty("gemfireName");
        if (gemfireName == null) {
            String s = "No gemfire name has been specified";
            throw new HydraConfigException(s);
        }
        HostDescription hd = TestConfig.getInstance().getGemFireDescription(gemfireName).getHostDescription();
        RemoteTestModule.Master.recordPID(hd, pid);
    }

    protected void removePID(int pid) throws RemoteException {
        if (pid <= 0) {
            return;
        }
        String gemfireName = System.getProperty("gemfireName");
        if (gemfireName == null) {
            String s = "No gemfire name has been specified";
            throw new HydraConfigException(s);
        }
        HostDescription hd = TestConfig.getInstance().getGemFireDescription(gemfireName).getHostDescription();
        RemoteTestModule.Master.removePID(hd, pid);
    }

    protected AsyncInvocation createPeerCache(VM server, int mcastPort, final String regionName, final boolean createPR, final String member_dir, final String diskStoreName) {
        AsyncInvocation inst = server.invokeAsync(new CacheSerializableRunnable("Create Cache and Region"){

            @Override
            public void run2() throws CacheException {
                Region region;
                AttributesFactory factory = new AttributesFactory();
                Cache cache = UpgradeDiskStoreDUnitTest.this.getCache();
                if (diskStoreName != null) {
                    DiskStore ds = cache.findDiskStore(diskStoreName);
                    if (ds == null) {
                        ds = cache.createDiskStoreFactory().setDiskDirs(UpgradeDiskStoreDUnitTest.this.getDiskDirsForMember(member_dir)).create(diskStoreName);
                    }
                    if (createPR) {
                        PartitionAttributesFactory paf = new PartitionAttributesFactory();
                        paf.setRedundantCopies(1);
                        factory.setPartitionAttributes(paf.create());
                        factory.setDataPolicy(DataPolicy.PERSISTENT_PARTITION);
                    } else {
                        factory.setScope(Scope.DISTRIBUTED_ACK);
                        factory.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
                    }
                    factory.setConcurrencyChecksEnabled(true);
                    factory.setDiskStoreName(diskStoreName);
                    region = UpgradeDiskStoreDUnitTest.this.createRootRegion(regionName, factory.create());
                } else {
                    RegionFactory rf = createPR ? cache.createRegionFactory(RegionShortcut.PARTITION_REDUNDANT_PERSISTENT) : cache.createRegionFactory(RegionShortcut.REPLICATE_PERSISTENT);
                    rf.setConcurrencyChecksEnabled(true);
                    region = rf.create(regionName);
                }
                if (createPR) {
                    TestCase.assertTrue((boolean)(region instanceof PartitionedRegion));
                } else {
                    TestCase.assertTrue((boolean)(region instanceof DistributedRegion));
                }
            }
        });
        return inst;
    }

    private VersionTag getVersionTag(VM vm, final String regionName, final String key) {
        SerializableCallable getVersionTag = new SerializableCallable("verify version tag for key " + key){

            public Object call() {
                Cache cache = UpgradeDiskStoreDUnitTest.this.getCache();
                LocalRegion region = (LocalRegion)cache.getRegion(regionName);
                VersionTag tag = region.getVersionTag((Object)key);
                return tag;
            }
        };
        return (VersionTag)vm.invoke(getVersionTag);
    }

    private String getValue(VM vm, final String regionName, final String key) {
        SerializableCallable getValue = new SerializableCallable("verify value for key " + key){

            public Object call() {
                Cache cache = UpgradeDiskStoreDUnitTest.this.getCache();
                LocalRegion region = (LocalRegion)cache.getRegion(regionName);
                String value = (String)region.get((Object)key);
                return value;
            }
        };
        return (String)vm.invoke(getValue);
    }

    private int getRegionSize(VM vm, final String regionName) {
        SerializableCallable getRegionSize = new SerializableCallable("get region size for " + regionName){

            public Object call() {
                Cache cache = UpgradeDiskStoreDUnitTest.this.getCache();
                LocalRegion region = (LocalRegion)cache.getRegion(regionName);
                return region.size();
            }
        };
        return (Integer)vm.invoke(getRegionSize);
    }

    private static File[] listFiles(File dir) {
        File[] result = dir.listFiles();
        if (result == null) {
            result = new File[]{};
        }
        return result;
    }

    public static void printDirectory(String dirname, String testcasename) {
        File[] files = UpgradeDiskStoreDUnitTest.listFiles(new File(dirname));
        System.out.println(testcasename + ":list dir:" + dirname);
        for (File f : files) {
            System.out.println("list dir:" + f + ":size=" + f.length());
        }
    }

    private static int expectedDummyEntryVersion() {
        return Version.SQLF_1099.equals(Version.CURRENT) || Version.SQLF_11.equals(Version.CURRENT) ? 0 : 1;
    }
}

