/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.Delta;
import com.gemstone.gemfire.InvalidDeltaException;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.ConflictException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.InterestPolicy;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.PartitionResolver;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.SubscriptionAttributes;
import com.gemstone.gemfire.cache.UnsupportedOperationInTransactionException;
import com.gemstone.gemfire.cache.client.ClientCache;
import com.gemstone.gemfire.cache.client.ClientCacheFactory;
import com.gemstone.gemfire.cache.client.ClientRegionFactory;
import com.gemstone.gemfire.cache.client.ClientRegionShortcut;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.TXManagerImpl;
import com.gemstone.gemfire.internal.cache.TXStateInterface;
import com.gemstone.gemfire.internal.cache.execute.CustomerIDPartitionResolver;
import com.gemstone.gemfire.internal.cache.execute.data.CustId;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.VM;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import junit.framework.TestCase;

public class TransactionsWithDeltaDUnitTest
extends CacheTestCase {
    private static final String D_REFERENCE = "ref";
    private static final String CUSTOMER = "Customer";
    private static final String ORDER = "Order";

    public TransactionsWithDeltaDUnitTest(String name) {
        super(name);
    }

    private Integer createRegionOnServer(VM vm, final boolean startServer, final boolean accessor) {
        return (Integer)vm.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                TransactionsWithDeltaDUnitTest.this.createRegion(accessor, 0, null);
                if (startServer) {
                    int port = AvailablePort.getRandomAvailablePort((int)0);
                    CacheServer s = TransactionsWithDeltaDUnitTest.this.getCache().addCacheServer();
                    s.setPort(port);
                    s.start();
                    return port;
                }
                return 0;
            }
        });
    }

    private void createRegion(boolean accessor, int redundantCopies, InterestPolicy interestPolicy) {
        AttributesFactory af = new AttributesFactory();
        af.setScope(Scope.DISTRIBUTED_ACK);
        af.setDataPolicy(DataPolicy.REPLICATE);
        af.setCloningEnabled(true);
        this.getCache().createRegion(D_REFERENCE, af.create());
        af = new AttributesFactory();
        af.setCloningEnabled(true);
        if (interestPolicy != null) {
            af.setSubscriptionAttributes(new SubscriptionAttributes(interestPolicy));
        }
        af.setPartitionAttributes(new PartitionAttributesFactory().setTotalNumBuckets(4).setLocalMaxMemory(accessor ? 0 : 1).setPartitionResolver((PartitionResolver)new CustomerIDPartitionResolver("resolver1")).setRedundantCopies(redundantCopies).create());
        this.getCache().createRegion(CUSTOMER, af.create());
        af.setPartitionAttributes(new PartitionAttributesFactory().setTotalNumBuckets(4).setLocalMaxMemory(accessor ? 0 : 1).setPartitionResolver((PartitionResolver)new CustomerIDPartitionResolver("resolver2")).setRedundantCopies(redundantCopies).setColocatedWith(CUSTOMER).create());
        this.getCache().createRegion(ORDER, af.create());
    }

    private void createClientRegion(VM vm, final int port, final boolean isEmpty, final boolean ri) {
        vm.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                ClientCacheFactory ccf = new ClientCacheFactory();
                ccf.addPoolServer("localhost", port);
                ccf.setPoolSubscriptionEnabled(false);
                ccf.set("log-level", DistributedTestCase.getDUnitLogLevel());
                ClientCache cCache = TransactionsWithDeltaDUnitTest.this.getClientCache(ccf);
                ClientRegionFactory crf = cCache.createClientRegionFactory(isEmpty ? ClientRegionShortcut.PROXY : ClientRegionShortcut.CACHING_PROXY);
                Region r = crf.create(TransactionsWithDeltaDUnitTest.D_REFERENCE);
                Region customer = crf.create(TransactionsWithDeltaDUnitTest.CUSTOMER);
                Region order = crf.create(TransactionsWithDeltaDUnitTest.ORDER);
                if (ri) {
                    r.registerInterestRegex(".*");
                    customer.registerInterestRegex(".*");
                    order.registerInterestRegex(".*");
                }
                return null;
            }
        });
    }

    public void DISABLED_testTxWithCloning() {
        AttributesFactory af = new AttributesFactory();
        af.setDataPolicy(DataPolicy.REPLICATE);
        af.setScope(Scope.DISTRIBUTED_ACK);
        af.setCloningEnabled(true);
        this.basicTest(af.create());
    }

    public void testExceptionThrown() {
        AttributesFactory af = new AttributesFactory();
        af.setDataPolicy(DataPolicy.REPLICATE);
        af.setScope(Scope.DISTRIBUTED_ACK);
        final RegionAttributes attr = af.create();
        Host host = Host.getHost(0);
        VM vm1 = host.getVM(0);
        VM vm2 = host.getVM(1);
        final String regionName = this.getUniqueName();
        SerializableCallable createRegion = new SerializableCallable(){

            public Object call() throws Exception {
                TransactionsWithDeltaDUnitTest.this.getCache().createRegion(regionName, attr);
                return null;
            }
        };
        vm1.invoke(createRegion);
        vm2.invoke(createRegion);
        String key = "cust1";
        vm1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                TXManagerImpl mgr = TransactionsWithDeltaDUnitTest.this.getGemfireCache().getTxManager();
                Region r = TransactionsWithDeltaDUnitTest.this.getCache().getRegion(regionName);
                Customer cust = new Customer(1, "cust1");
                r.put((Object)"cust1", (Object)cust);
                mgr.begin();
                cust.setName("");
                try {
                    r.put((Object)"cust1", (Object)cust);
                    TestCase.fail((String)"exception not thrown");
                }
                catch (UnsupportedOperationInTransactionException unsupportedOperationInTransactionException) {
                    // empty catch block
                }
                mgr.rollback();
                return null;
            }
        });
    }

    private void basicTest(final RegionAttributes<?, ?> regionAttr) {
        Host host = Host.getHost(0);
        VM vm1 = host.getVM(0);
        VM vm2 = host.getVM(1);
        final String regionName = this.getUniqueName();
        SerializableCallable createRegion = new SerializableCallable(){

            public Object call() throws Exception {
                ((GemFireCacheImpl)TransactionsWithDeltaDUnitTest.this.getCache()).createRegion(regionName, regionAttr);
                return null;
            }
        };
        vm1.invoke(createRegion);
        vm2.invoke(createRegion);
        String key = "cust1";
        String keynd = "cust1NoDelta";
        vm1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                TXManagerImpl mgr = TransactionsWithDeltaDUnitTest.this.getGemfireCache().getTxManager();
                Region r = TransactionsWithDeltaDUnitTest.this.getCache().getRegion(regionName);
                CustomerNoDelta cnd = new CustomerNoDelta(1, "cust1NoDelta");
                Customer cust = new Customer(1, "cust1");
                r.put((Object)"cust1NoDelta", (Object)cnd);
                r.put((Object)"cust1", (Object)cust);
                mgr.begin();
                cnd.setName("cust11NoDelta");
                cust.setName("cust11");
                r.put((Object)"cust1NoDelta", (Object)cnd);
                r.put((Object)"cust1", (Object)cust);
                return null;
            }
        });
        vm2.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                TXManagerImpl mgr = TransactionsWithDeltaDUnitTest.this.getGemfireCache().getTxManager();
                Region r = TransactionsWithDeltaDUnitTest.this.getCache().getRegion(regionName);
                CustomerNoDelta cnd = (CustomerNoDelta)r.get((Object)"cust1NoDelta");
                cnd = new CustomerNoDelta(1, "cust1NoDeltaUpdated");
                Customer c = (Customer)r.get((Object)"cust1");
                mgr.begin();
                try {
                    r.put((Object)"cust1NoDelta", (Object)cnd);
                    mgr.commit();
                    TestCase.fail((String)"expected a ConflictException during put/commit");
                }
                catch (ConflictException conflictException) {
                    // empty catch block
                }
                CustomerNoDelta cnd1 = (CustomerNoDelta)r.get((Object)"cust1NoDelta");
                TestCase.assertEquals((String)"cust1NoDelta", (String)cnd1.getName());
                c.setName("cust1updated");
                mgr.begin();
                try {
                    r.put((Object)"cust1", (Object)c);
                    TestCase.fail((String)"expected a ConflictException during put");
                }
                catch (ConflictException conflictException) {
                    // empty catch block
                }
                mgr.commit();
                return null;
            }
        });
        vm1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                TXManagerImpl mgr = TransactionsWithDeltaDUnitTest.this.getGemfireCache().getTxManager();
                TestCase.assertNotNull((Object)mgr.getTXState());
                mgr.commit();
                Region r = TransactionsWithDeltaDUnitTest.this.getCache().getRegion(regionName);
                CustomerNoDelta cnd = (CustomerNoDelta)r.get((Object)"cust1NoDelta");
                Customer c = (Customer)r.get((Object)"cust1");
                TestCase.assertEquals((String)"cust11NoDelta", (String)cnd.getName());
                TestCase.assertEquals((String)"cust11", (String)c.getName());
                TXManagerImpl.waitForPendingCommitForTest();
                return null;
            }
        });
        vm2.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region r = TransactionsWithDeltaDUnitTest.this.getCache().getRegion(regionName);
                CustomerNoDelta cnd = (CustomerNoDelta)r.get((Object)"cust1NoDelta");
                Customer c = (Customer)r.get((Object)"cust1");
                TestCase.assertEquals((String)"cust11NoDelta", (String)cnd.getName());
                TestCase.assertEquals((String)"cust11", (String)c.getName());
                return null;
            }
        });
    }

    public void DISABLED_TILL_NEW_TX_IMPL_COMPLETE_testClientServerDelta() {
        Host host = Host.getHost(0);
        VM server = host.getVM(0);
        VM client = host.getVM(1);
        int port = this.createRegionOnServer(server, true, false);
        this.createClientRegion(client, port, false, false);
        server.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region pr = TransactionsWithDeltaDUnitTest.this.getCache().getRegion(TransactionsWithDeltaDUnitTest.CUSTOMER);
                CustId cust1 = new CustId(1);
                pr.put((Object)cust1, (Object)new Customer(1, "name1"));
                Iterator it = pr.keySet().iterator();
                while (it.hasNext()) {
                    DistributedTestCase.getLogWriter().info("SWAP:iterator1:" + pr.get(it.next()));
                }
                Customer c = (Customer)pr.get((Object)cust1);
                TestCase.assertNotNull((Object)c);
                return null;
            }
        });
        client.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region pr = TransactionsWithDeltaDUnitTest.this.getCache().getRegion(TransactionsWithDeltaDUnitTest.CUSTOMER);
                TXManagerImpl mgr = TransactionsWithDeltaDUnitTest.this.getGemfireCache().getTxManager();
                CustId cust1 = new CustId(1);
                mgr.begin();
                Customer c = (Customer)pr.get((Object)cust1);
                c.setName("updatedName");
                DistributedTestCase.getLogWriter().info("SWAP:doingPut");
                pr.put((Object)cust1, (Object)c);
                DistributedTestCase.getLogWriter().info("SWAP:getfromtx:" + pr.get((Object)cust1));
                DistributedTestCase.getLogWriter().info("SWAP:doingCommit");
                TestCase.assertEquals((String)"updatedName", (String)((Customer)pr.get((Object)cust1)).getName());
                TXStateInterface tx = mgr.internalSuspend();
                TestCase.assertEquals((String)"name1", (String)((Customer)pr.get((Object)cust1)).getName());
                mgr.resume(tx);
                mgr.commit();
                TestCase.assertTrue((boolean)c.isToDeltaCalled());
                TestCase.assertEquals((Object)c, (Object)pr.get((Object)cust1));
                return null;
            }
        });
        server.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region pr = TransactionsWithDeltaDUnitTest.this.getCache().getRegion(TransactionsWithDeltaDUnitTest.CUSTOMER);
                CustId cust1 = new CustId(1);
                Customer c = (Customer)pr.get((Object)cust1);
                TestCase.assertTrue((boolean)c.isFromDeltaCalled());
                return null;
            }
        });
    }

    static final class Customer
    extends CustomerNoDelta
    implements Delta {
        public Customer(int id, String name) {
            super(id, name);
        }
    }

    static class CustomerNoDelta
    implements Serializable {
        int id;
        String name;
        private boolean idChanged;
        private boolean nameChanged;
        private boolean fromDeltaCalled;
        private boolean toDeltaCalled;

        public CustomerNoDelta(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public void setId(int id) {
            this.idChanged = true;
            this.id = id;
        }

        public void setName(String name) {
            this.nameChanged = true;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public void fromDelta(DataInput in) throws IOException, InvalidDeltaException {
            if (in.readBoolean()) {
                this.id = in.readInt();
            }
            if (in.readBoolean()) {
                this.name = in.readUTF();
            }
            this.fromDeltaCalled = true;
        }

        public boolean hasDelta() {
            return this.idChanged || this.nameChanged;
        }

        public void toDelta(DataOutput out) throws IOException {
            out.writeBoolean(this.idChanged);
            if (this.idChanged) {
                out.writeInt(this.id);
            }
            out.writeBoolean(this.nameChanged);
            if (this.nameChanged) {
                out.writeUTF(this.name);
            }
            this.toDeltaCalled = true;
        }

        public String toString() {
            return " id:" + this.id + " name:" + this.name;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof Customer) {
                Customer other = (Customer)obj;
                return this.id == other.id && this.name.equals(other.name);
            }
            return false;
        }

        public int hashCode() {
            return this.id + this.name.hashCode();
        }

        public boolean isFromDeltaCalled() {
            boolean retVal = this.fromDeltaCalled;
            this.fromDeltaCalled = false;
            return retVal;
        }

        public boolean isToDeltaCalled() {
            boolean retVal = this.toDeltaCalled;
            this.toDeltaCalled = false;
            return retVal;
        }
    }
}

