/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.AttributesMutator;
import com.gemstone.gemfire.cache.CacheEvent;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.CacheLoader;
import com.gemstone.gemfire.cache.CacheLoaderException;
import com.gemstone.gemfire.cache.CacheTransactionManager;
import com.gemstone.gemfire.cache.CacheWriter;
import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.ConflictException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.ExpirationAction;
import com.gemstone.gemfire.cache.ExpirationAttributes;
import com.gemstone.gemfire.cache.IllegalTransactionStateException;
import com.gemstone.gemfire.cache.InterestPolicy;
import com.gemstone.gemfire.cache.InterestResultPolicy;
import com.gemstone.gemfire.cache.LoaderHelper;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.PartitionResolver;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionEvent;
import com.gemstone.gemfire.cache.RegionFactory;
import com.gemstone.gemfire.cache.RegionShortcut;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.SubscriptionAttributes;
import com.gemstone.gemfire.cache.TransactionDataRebalancedException;
import com.gemstone.gemfire.cache.TransactionEvent;
import com.gemstone.gemfire.cache.TransactionException;
import com.gemstone.gemfire.cache.TransactionId;
import com.gemstone.gemfire.cache.TransactionListener;
import com.gemstone.gemfire.cache.TransactionWriter;
import com.gemstone.gemfire.cache.TransactionWriterException;
import com.gemstone.gemfire.cache.UnsupportedOperationInTransactionException;
import com.gemstone.gemfire.cache.client.ClientCache;
import com.gemstone.gemfire.cache.client.ClientCacheFactory;
import com.gemstone.gemfire.cache.client.ClientRegionFactory;
import com.gemstone.gemfire.cache.client.ClientRegionShortcut;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionAdapter;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.execute.FunctionException;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.execute.RegionFunctionContext;
import com.gemstone.gemfire.cache.partition.PartitionRegionHelper;
import com.gemstone.gemfire.cache.query.CqAttributes;
import com.gemstone.gemfire.cache.query.CqAttributesFactory;
import com.gemstone.gemfire.cache.query.CqEvent;
import com.gemstone.gemfire.cache.query.CqListener;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.cache.util.CacheWriterAdapter;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.KeyInfo;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionHelper;
import com.gemstone.gemfire.internal.cache.TXEntryState;
import com.gemstone.gemfire.internal.cache.TXId;
import com.gemstone.gemfire.internal.cache.TXManagerImpl;
import com.gemstone.gemfire.internal.cache.TXRegionState;
import com.gemstone.gemfire.internal.cache.TXState;
import com.gemstone.gemfire.internal.cache.TXStateInterface;
import com.gemstone.gemfire.internal.cache.TXStateProxy;
import com.gemstone.gemfire.internal.cache.execute.CustomerIDPartitionResolver;
import com.gemstone.gemfire.internal.cache.execute.InternalFunctionService;
import com.gemstone.gemfire.internal.cache.execute.data.CustId;
import com.gemstone.gemfire.internal.cache.execute.data.Customer;
import com.gemstone.gemfire.internal.cache.execute.data.Order;
import com.gemstone.gemfire.internal.cache.execute.data.OrderId;
import com.gemstone.gemfire.internal.cache.versions.VersionTag;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.VM;
import hydra.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.transaction.RollbackException;
import javax.transaction.UserTransaction;
import junit.framework.TestCase;

public class RemoteTransactionDUnitTest
extends CacheTestCase {
    protected final String CUSTOMER = "custRegion";
    protected final String ORDER = "orderRegion";
    protected final String D_REFERENCE = "distrReference";
    private final boolean isRepeatableRead = false;
    private final SerializableCallable getNumberOfTXInProgress = new SerializableCallable(){

        public Object call() throws Exception {
            TXManagerImpl mgr = RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager();
            return mgr.hostedTransactionsInProgressForTest();
        }
    };
    private final SerializableCallable verifyNoTxState = new SerializableCallable(){

        public Object call() throws Exception {
            TXManagerImpl mgr = RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager();
            TestCase.assertEquals((String)("unexpected TXns in progress: " + mgr.getHostedTransactionsInProgress()), (int)0, (int)mgr.hostedTransactionsInProgressForTest());
            return null;
        }
    };
    private final SerializableCallable waitForPendingCommit = new SerializableCallable(){

        public Object call() throws Exception {
            TXManagerImpl.waitForPendingCommitForTest();
            return null;
        }
    };
    final CustId expectedCustId = new CustId(6);
    final Customer expectedCustomer = new Customer("customer6", "address6");
    final Customer expectedCustomerUpdate = new Customer("cust6", "addr6");
    final OrderId expectedOrderId = new OrderId(6, this.expectedCustId);
    final Order expectedOrder = new Order("order6");
    final Order expectedOrderUpdate = new Order("o6");
    private static final String EMPTY_REGION = "emptyRegionName";

    public RemoteTransactionDUnitTest(String name) {
        super(name);
    }

    @Override
    public void tearDown2() throws Exception {
        RemoteTransactionDUnitTest.invokeInEveryVM(this.verifyNoTxState);
        this.closeAllCache();
        super.tearDown2();
    }

    void createRegion(boolean accessor, int redundantCopies, InterestPolicy interestPolicy) {
        AttributesFactory af = new AttributesFactory();
        af.setScope(Scope.DISTRIBUTED_ACK);
        af.setDataPolicy(DataPolicy.REPLICATE);
        af.setConcurrencyChecksEnabled(this.getConcurrencyChecksEnabled());
        this.getCache().createRegion("distrReference", af.create());
        af = new AttributesFactory();
        af.setConcurrencyChecksEnabled(this.getConcurrencyChecksEnabled());
        if (interestPolicy != null) {
            af.setSubscriptionAttributes(new SubscriptionAttributes(interestPolicy));
        }
        af.setPartitionAttributes(new PartitionAttributesFactory().setTotalNumBuckets(4).setLocalMaxMemory(accessor ? 0 : 1).setPartitionResolver((PartitionResolver)new CustomerIDPartitionResolver("resolver1")).setRedundantCopies(redundantCopies).create());
        this.getCache().createRegion("custRegion", af.create());
        af.setPartitionAttributes(new PartitionAttributesFactory().setTotalNumBuckets(4).setLocalMaxMemory(accessor ? 0 : 1).setPartitionResolver((PartitionResolver)new CustomerIDPartitionResolver("resolver2")).setRedundantCopies(redundantCopies).setColocatedWith("custRegion").create());
        this.getCache().createRegion("orderRegion", af.create());
    }

    protected boolean getConcurrencyChecksEnabled() {
        return false;
    }

    void populateData() {
        Region custRegion = this.getCache().getRegion("custRegion");
        Region orderRegion = this.getCache().getRegion("orderRegion");
        Region refRegion = this.getCache().getRegion("distrReference");
        for (int i = 0; i < 5; ++i) {
            CustId custId = new CustId(i);
            Customer customer = new Customer("customer" + i, "address" + i);
            OrderId orderId = new OrderId(i, custId);
            Order order = new Order("order" + i);
            custRegion.put((Object)custId, (Object)customer);
            orderRegion.put((Object)orderId, (Object)order);
            refRegion.put((Object)custId, (Object)customer);
        }
    }

    protected void initAccessorAndDataStore(VM accessor, VM datastore, final int redundantCopies) {
        accessor.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                RemoteTransactionDUnitTest.this.createRegion(true, redundantCopies, null);
                return null;
            }
        });
        datastore.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                RemoteTransactionDUnitTest.this.createRegion(false, redundantCopies, null);
                RemoteTransactionDUnitTest.this.populateData();
                return null;
            }
        });
    }

    private void initAccessorAndDataStore(VM accessor, VM datastore1, VM datastore2, final int redundantCopies) {
        datastore2.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                RemoteTransactionDUnitTest.this.createRegion(false, redundantCopies, null);
                return null;
            }
        });
        this.initAccessorAndDataStore(accessor, datastore1, redundantCopies);
    }

    private void initAccessorAndDataStoreWithInterestPolicy(VM accessor, VM datastore1, VM datastore2, final int redundantCopies) {
        datastore2.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                RemoteTransactionDUnitTest.this.createRegion(false, redundantCopies, InterestPolicy.ALL);
                return null;
            }
        });
        this.initAccessorAndDataStore(accessor, datastore1, redundantCopies);
    }

    void validateContains(CustId custId, Set<OrderId> orderId, boolean doesIt) {
        this.validateContains(custId, orderId, doesIt, doesIt);
    }

    void validateContains(CustId custId, Set<OrderId> ordersSet, boolean containsKey, boolean containsValue) {
        Object eC;
        Region custRegion = this.getCache().getRegion("custRegion");
        Region orderRegion = this.getCache().getRegion("orderRegion");
        Region refRegion = this.getCache().getRegion("distrReference");
        boolean rContainsKC = custRegion.containsKey((Object)custId);
        boolean rContainsKO = containsKey;
        for (OrderId o : ordersSet) {
            this.getGemfireCache().getLoggerI18n().fine("SWAP:rContainsKO:" + rContainsKO + " containsKey:" + orderRegion.containsKey((Object)o));
            rContainsKO = rContainsKO && orderRegion.containsKey((Object)o);
        }
        boolean rContainsKR = refRegion.containsKey((Object)custId);
        boolean rContainsVC = custRegion.containsValueForKey((Object)custId);
        boolean rContainsVO = containsValue;
        for (OrderId o : ordersSet) {
            rContainsVO = rContainsVO && orderRegion.containsValueForKey((Object)o);
        }
        boolean rContainsVR = refRegion.containsValueForKey((Object)custId);
        RemoteTransactionDUnitTest.assertEquals((boolean)containsKey, (boolean)rContainsKC);
        RemoteTransactionDUnitTest.assertEquals((boolean)containsKey, (boolean)rContainsKO);
        RemoteTransactionDUnitTest.assertEquals((boolean)containsKey, (boolean)rContainsKR);
        RemoteTransactionDUnitTest.assertEquals((boolean)containsValue, (boolean)rContainsVR);
        RemoteTransactionDUnitTest.assertEquals((boolean)containsValue, (boolean)rContainsVC);
        RemoteTransactionDUnitTest.assertEquals((boolean)containsValue, (boolean)rContainsVO);
        if (containsKey) {
            eC = custRegion.getEntry((Object)custId);
            for (OrderId o : ordersSet) {
                RemoteTransactionDUnitTest.assertNotNull((Object)orderRegion.getEntry((Object)o));
            }
            Region.Entry eR = refRegion.getEntry((Object)custId);
            RemoteTransactionDUnitTest.assertNotNull((Object)eC);
            RemoteTransactionDUnitTest.assertNotNull((Object)eR);
        } else {
            try {
                eC = custRegion.getEntry((Object)custId);
                RemoteTransactionDUnitTest.assertNull((String)("should have had an EntryNotFoundException:" + eC), (Object)eC);
            }
            catch (EntryNotFoundException eC2) {
                // empty catch block
            }
            try {
                for (OrderId o : ordersSet) {
                    RemoteTransactionDUnitTest.assertNull((String)("should have had an EntryNotFoundException:" + orderRegion.getEntry((Object)o)), (Object)orderRegion.getEntry((Object)o));
                }
            }
            catch (EntryNotFoundException eC2) {
                // empty catch block
            }
            try {
                Region.Entry eR = refRegion.getEntry((Object)custId);
                RemoteTransactionDUnitTest.assertNull((String)("should have had an EntryNotFoundException:" + eR), (Object)eR);
            }
            catch (EntryNotFoundException entryNotFoundException) {
                // empty catch block
            }
        }
    }

    void verifyAfterCommit(OP op) {
        Region custRegion = this.getCache().getRegion("custRegion");
        Region refRegion = this.getCache().getRegion("distrReference");
        Region orderRegion = this.getCache().getRegion("orderRegion");
        CustId custId = new CustId(1);
        OrderId orderId = new OrderId(1, custId);
        switch (op) {
            case PUT: {
                Customer expectedCust;
                Customer expectedRef = expectedCust = new Customer("foo", "bar");
                RemoteTransactionDUnitTest.assertNotNull((Object)custRegion.getEntry((Object)custId));
                RemoteTransactionDUnitTest.assertEquals((Object)expectedCust, (Object)custRegion.getEntry((Object)custId).getValue());
                RemoteTransactionDUnitTest.assertNotNull((Object)refRegion.getEntry((Object)custId));
                RemoteTransactionDUnitTest.assertEquals((Object)expectedRef, (Object)refRegion.getEntry((Object)custId).getValue());
                break;
            }
            case GET: {
                Customer expectedCust = (Customer)custRegion.get((Object)custId);
                orderRegion.get((Object)orderId);
                Customer expectedRef = (Customer)refRegion.get((Object)custId);
                this.validateContains(custId, Collections.singleton(orderId), true);
                break;
            }
            case DESTROY: {
                RemoteTransactionDUnitTest.assertTrue((!custRegion.containsKey((Object)custId) ? 1 : 0) != 0);
                RemoteTransactionDUnitTest.assertTrue((!orderRegion.containsKey((Object)orderId) ? 1 : 0) != 0);
                RemoteTransactionDUnitTest.assertTrue((!refRegion.containsKey((Object)custId) ? 1 : 0) != 0);
                this.validateContains(custId, Collections.singleton(orderId), false);
                break;
            }
            case INVALIDATE: {
                boolean validateContainsKey = true;
                if (!((GemFireCacheImpl)custRegion.getCache()).isClient()) {
                    RemoteTransactionDUnitTest.assertTrue((boolean)custRegion.containsKey((Object)custId));
                    RemoteTransactionDUnitTest.assertTrue((boolean)orderRegion.containsKey((Object)orderId));
                    RemoteTransactionDUnitTest.assertTrue((boolean)refRegion.containsKey((Object)custId));
                }
                RemoteTransactionDUnitTest.assertNull((Object)custRegion.get((Object)custId));
                RemoteTransactionDUnitTest.assertNull((Object)orderRegion.get((Object)orderId));
                RemoteTransactionDUnitTest.assertNull((Object)refRegion.get((Object)custId));
                this.validateContains(custId, Collections.singleton(orderId), validateContainsKey, false);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    void verifyAfterRollback(OP op) {
        Region custRegion = this.getCache().getRegion("custRegion");
        Region orderRegion = this.getCache().getRegion("orderRegion");
        Region refRegion = this.getCache().getRegion("distrReference");
        RemoteTransactionDUnitTest.assertNotNull((Object)custRegion);
        RemoteTransactionDUnitTest.assertNotNull((Object)orderRegion);
        RemoteTransactionDUnitTest.assertNotNull((Object)refRegion);
        CustId custId = new CustId(1);
        OrderId orderId = new OrderId(1, custId);
        OrderId orderId2 = new OrderId(2, custId);
        OrderId orderId3 = new OrderId(3, custId);
        switch (op) {
            case PUT: {
                Customer expectedCust = new Customer("customer1", "address1");
                Order expectedOrder = new Order("order1");
                Customer expectedRef = new Customer("customer1", "address1");
                RemoteTransactionDUnitTest.assertEquals((Object)expectedCust, (Object)custRegion.getEntry((Object)custId).getValue());
                RemoteTransactionDUnitTest.assertEquals((Object)expectedOrder, (Object)orderRegion.getEntry((Object)orderId).getValue());
                this.getCache().getLogger().info("SWAP:verifyRollback:" + orderRegion);
                this.getCache().getLogger().info("SWAP:verifyRollback:" + orderRegion.getEntry((Object)orderId2));
                RemoteTransactionDUnitTest.assertNull((Object)this.getGemfireCache().getTxManager().getTXState());
                RemoteTransactionDUnitTest.assertNull((String)("" + orderRegion.getEntry((Object)orderId2)), (Object)orderRegion.getEntry((Object)orderId2));
                RemoteTransactionDUnitTest.assertNull((Object)orderRegion.getEntry((Object)orderId3));
                RemoteTransactionDUnitTest.assertNull((Object)orderRegion.get((Object)orderId2));
                RemoteTransactionDUnitTest.assertNull((Object)orderRegion.get((Object)orderId3));
                RemoteTransactionDUnitTest.assertEquals((Object)expectedRef, (Object)refRegion.getEntry((Object)custId).getValue());
                this.validateContains(custId, Collections.singleton(orderId), true);
                break;
            }
            case GET: {
                Customer expectedCust = (Customer)custRegion.getEntry((Object)custId).getValue();
                Order expectedOrder = (Order)orderRegion.getEntry((Object)orderId).getValue();
                Customer expectedRef = (Customer)refRegion.getEntry((Object)custId).getValue();
                this.validateContains(custId, Collections.singleton(orderId), true);
                break;
            }
            case DESTROY: {
                RemoteTransactionDUnitTest.assertTrue((!custRegion.containsKey((Object)custId) ? 1 : 0) != 0);
                RemoteTransactionDUnitTest.assertTrue((!orderRegion.containsKey((Object)orderId) ? 1 : 0) != 0);
                RemoteTransactionDUnitTest.assertTrue((!refRegion.containsKey((Object)custId) ? 1 : 0) != 0);
                this.validateContains(custId, Collections.singleton(orderId), true);
                break;
            }
            case INVALIDATE: {
                RemoteTransactionDUnitTest.assertTrue((boolean)custRegion.containsKey((Object)custId));
                RemoteTransactionDUnitTest.assertTrue((boolean)orderRegion.containsKey((Object)orderId));
                RemoteTransactionDUnitTest.assertTrue((boolean)refRegion.containsKey((Object)custId));
                RemoteTransactionDUnitTest.assertNull((Object)custRegion.get((Object)custId));
                RemoteTransactionDUnitTest.assertNull((Object)orderRegion.get((Object)orderId));
                RemoteTransactionDUnitTest.assertNull((Object)refRegion.get((Object)custId));
                this.validateContains(custId, Collections.singleton(orderId), true, true);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    public void testDummy() {
    }

    public void Bug44146_testTXCreationAndCleanupAtCommit() throws Exception {
        this.doBasicChecks(true);
    }

    public void Bug44146_testTXCreationAndCleanupAtRollback() throws Exception {
        this.doBasicChecks(false);
    }

    private void doBasicChecks(final boolean commit) throws Exception {
        Host host = Host.getHost(0);
        VM accessor = host.getVM(0);
        VM datastore = host.getVM(1);
        this.initAccessorAndDataStore(accessor, datastore, 0);
        final TXId txId = (TXId)accessor.invoke(new DoOpsInTX(OP.PUT));
        datastore.invoke(new SerializableCallable("verify tx"){

            public Object call() throws Exception {
                TXManagerImpl mgr = RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager();
                TestCase.assertTrue((boolean)mgr.isHostedTxInProgress((TransactionId)txId));
                return null;
            }
        });
        accessor.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                TXManagerImpl mgr = RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager();
                TXStateInterface tx = mgr.internalSuspend();
                TestCase.assertNotNull((Object)tx);
                mgr.resume(tx);
                if (commit) {
                    mgr.commit();
                    TXManagerImpl.waitForPendingCommitForTest();
                } else {
                    mgr.rollback();
                }
                return null;
            }
        });
        datastore.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                TXManagerImpl mgr = RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager();
                TestCase.assertFalse((boolean)mgr.isHostedTxInProgress((TransactionId)txId));
                return null;
            }
        });
        if (commit) {
            accessor.invoke(new SerializableCallable(){

                public Object call() throws Exception {
                    RemoteTransactionDUnitTest.this.verifyAfterCommit(OP.PUT);
                    return null;
                }
            });
        } else {
            accessor.invoke(new SerializableCallable(){

                public Object call() throws Exception {
                    RemoteTransactionDUnitTest.this.verifyAfterRollback(OP.PUT);
                    return null;
                }
            });
        }
    }

    public void Bug44146_testPRTXGet() {
        Host host = Host.getHost(0);
        VM accessor = host.getVM(0);
        VM datastore = host.getVM(1);
        this.initAccessorAndDataStore(accessor, datastore, 0);
        final TXId txId = (TXId)accessor.invoke(new DoOpsInTX(OP.GET));
        accessor.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                TXManagerImpl mgr = RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager();
                TXStateInterface tx = mgr.getTXState();
                TestCase.assertEquals((String)("unexpected regions: " + tx.getRegions()), (int)0, (int)tx.getRegions().size());
                return null;
            }
        });
        datastore.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                TXManagerImpl mgr = RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager();
                TestCase.assertFalse((boolean)mgr.isHostedTxInProgress((TransactionId)txId));
                TXStateProxy tx = mgr.getHostedTXState(txId);
                TestCase.assertNull((Object)tx);
                return null;
            }
        });
        accessor.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                TXManagerImpl mgr = RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager();
                mgr.commit();
                RemoteTransactionDUnitTest.this.verifyAfterCommit(OP.GET);
                return null;
            }
        });
    }

    public void Bug44146_testPRTXGetOnRemoteWithLoader() {
        Host host = Host.getHost(0);
        VM accessor = host.getVM(0);
        VM datastore = host.getVM(1);
        this.initAccessorAndDataStore(accessor, datastore, 0);
        datastore.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                AttributesMutator am = RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion").getAttributesMutator();
                am.setCacheLoader(new CacheLoader(){

                    public Object load(LoaderHelper helper) throws CacheLoaderException {
                        return new Customer("sup dawg", "add");
                    }

                    public void close() {
                    }
                });
                return null;
            }
        });
        accessor.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                TXManagerImpl mgr = RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager();
                mgr.begin();
                Region cust = RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                Customer s = (Customer)cust.get((Object)new CustId(8));
                TestCase.assertTrue((boolean)cust.containsKey((Object)new CustId(8)));
                TXStateInterface tx = mgr.internalSuspend();
                TestCase.assertFalse((boolean)cust.containsKey((Object)new CustId(8)));
                mgr.resume(tx);
                mgr.commit();
                Customer s2 = (Customer)cust.get((Object)new CustId(8));
                Customer ex = new Customer("sup dawg", "add");
                TestCase.assertEquals((Object)ex, (Object)s);
                TestCase.assertEquals((Object)ex, (Object)s2);
                return null;
            }
        });
    }

    public void Bug44146_testPRTXGetEntryOnRemoteSide() {
        Host host = Host.getHost(0);
        VM accessor = host.getVM(0);
        VM datastore = host.getVM(1);
        this.initAccessorAndDataStore(accessor, datastore, 0);
        datastore.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                return null;
            }
        });
        accessor.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region cust = RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                CustId sup = new CustId(7);
                Region.Entry e = cust.getEntry((Object)sup);
                TestCase.assertNull((Object)e);
                CustId custId = new CustId(5);
                cust.put((Object)custId, (Object)new Customer("customer5", "address5"));
                Region.Entry ee = cust.getEntry((Object)custId);
                TestCase.assertNotNull((Object)ee);
                TXManagerImpl mgr = RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager();
                mgr.begin();
                Region.Entry e2 = cust.getEntry((Object)sup);
                TestCase.assertNull((Object)e2);
                mgr.commit();
                Region.Entry e3 = cust.getEntry((Object)sup);
                TestCase.assertNull((Object)e3);
                mgr.begin();
                Customer dawg = new Customer("dawg", "dawgaddr");
                cust.put((Object)sup, (Object)dawg);
                Region.Entry e4 = cust.getEntry((Object)sup);
                TestCase.assertNotNull((Object)e4);
                TestCase.assertEquals((Object)dawg, (Object)e4.getValue());
                mgr.commit();
                Region.Entry e5 = cust.getEntry((Object)sup);
                TestCase.assertNotNull((Object)e5);
                TestCase.assertEquals((Object)dawg, (Object)e5.getValue());
                return null;
            }
        });
    }

    public void Bug44146_testPRTXGetOnLocalWithLoader() {
        Host host = Host.getHost(0);
        VM accessor = host.getVM(0);
        VM datastore = host.getVM(1);
        this.initAccessorAndDataStore(accessor, datastore, 0);
        datastore.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                AttributesMutator am = RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion").getAttributesMutator();
                am.setCacheLoader(new CacheLoader(){

                    public Object load(LoaderHelper helper) throws CacheLoaderException {
                        return new Customer("sup dawg", "addr");
                    }

                    public void close() {
                    }
                });
                TXManagerImpl mgr = RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager();
                mgr.begin();
                Region cust = RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                CustId custId = new CustId(6);
                Customer s = (Customer)cust.get((Object)custId);
                mgr.commit();
                Customer s2 = (Customer)cust.get((Object)custId);
                Customer expectedCust = new Customer("sup dawg", "addr");
                TestCase.assertEquals((Object)s, (Object)expectedCust);
                TestCase.assertEquals((Object)s2, (Object)expectedCust);
                return null;
            }
        });
        accessor.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                return null;
            }
        });
    }

    public void Bug44146_testTXPut() {
        Host host = Host.getHost(0);
        VM acc = host.getVM(0);
        VM datastore = host.getVM(1);
        this.initAccessorAndDataStore(acc, datastore, 0);
        VM accessor = this.getVMForTransactions(acc, datastore);
        final TXId txId = (TXId)accessor.invoke(new DoOpsInTX(OP.PUT));
        datastore.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                TXManagerImpl mgr = RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager();
                TestCase.assertTrue((boolean)mgr.isHostedTxInProgress((TransactionId)txId));
                TXStateProxy tx = mgr.getHostedTXState(txId);
                int n = tx.getProxy().batchingEnabled() ? 2 : 3;
                TestCase.assertEquals((String)("unexpected regions: " + tx.getRegions()), (int)n, (int)tx.getRegions().size());
                for (LocalRegion r : tx.getRegions()) {
                    TestCase.assertTrue((r instanceof BucketRegion || r instanceof DistributedRegion ? 1 : 0) != 0);
                    TXRegionState rs = tx.readRegion(r);
                    for (Object key : rs.getEntryKeys()) {
                        TXEntryState es = (TXEntryState)rs.readEntry(key);
                        TestCase.assertNotNull((Object)es.getValue((Region)r));
                        TestCase.assertTrue((boolean)es.isDirty());
                    }
                }
                return null;
            }
        });
        accessor.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                TXManagerImpl mgr = RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager();
                TXStateInterface tx = mgr.getTXState();
                TestCase.assertNotNull((Object)tx);
                RemoteTransactionDUnitTest.this.getCache().getLogger().fine("SWAP:accessorTXState:" + tx);
                TestCase.assertEquals((String)("unexpected regions: " + tx.getRegions()), (int)3, (int)tx.getRegions().size());
                for (LocalRegion r : tx.getRegions()) {
                    TestCase.assertTrue((r instanceof PartitionedRegion || r instanceof DistributedRegion ? 1 : 0) != 0);
                }
                mgr.commit();
                RemoteTransactionDUnitTest.this.verifyAfterCommit(OP.PUT);
                TestCase.assertNull((Object)mgr.getTXState());
                return null;
            }
        });
    }

    public void Bug44146_testTXInvalidate() {
        Host host = Host.getHost(0);
        VM acc = host.getVM(0);
        VM datastore = host.getVM(1);
        this.initAccessorAndDataStore(acc, datastore, 0);
        VM accessor = this.getVMForTransactions(acc, datastore);
        final TXId txId = (TXId)accessor.invoke(new DoOpsInTX(OP.INVALIDATE));
        datastore.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                TXManagerImpl mgr = RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager();
                TestCase.assertTrue((boolean)mgr.isHostedTxInProgress((TransactionId)txId));
                TXStateProxy tx = mgr.getHostedTXState(txId);
                int n = tx.getProxy().batchingEnabled() ? 2 : 3;
                TestCase.assertEquals((String)("unexpected regions: " + tx.getRegions()), (int)n, (int)tx.getRegions().size());
                for (LocalRegion r : tx.getRegions()) {
                    TestCase.assertTrue((r instanceof BucketRegion || r instanceof DistributedRegion ? 1 : 0) != 0);
                    TXRegionState rs = tx.readRegion(r);
                    for (Object key : rs.getEntryKeys()) {
                        TXEntryState es = (TXEntryState)rs.readEntry(key);
                        Log.getLogWriter().warning("SUP IS IT NULL(" + key + "):" + es.getValue((Region)r));
                        TestCase.assertNotNull((Object)es.getValue((Region)r));
                        TestCase.assertTrue((boolean)es.isDirty());
                    }
                }
                return null;
            }
        });
        accessor.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                TXManagerImpl mgr = RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager();
                TXStateInterface tx = mgr.getTXState();
                TestCase.assertNotNull((Object)tx);
                TestCase.assertEquals((String)("unexpected regions: " + tx.getRegions()), (int)3, (int)tx.getRegions().size());
                for (LocalRegion r : tx.getRegions()) {
                    TestCase.assertTrue((r instanceof PartitionedRegion || r instanceof DistributedRegion ? 1 : 0) != 0);
                }
                mgr.commit();
                RemoteTransactionDUnitTest.this.verifyAfterCommit(OP.INVALIDATE);
                return null;
            }
        });
    }

    public void Bug44146_testTXDestroy() {
        Host host = Host.getHost(0);
        VM acc = host.getVM(0);
        VM datastore = host.getVM(1);
        this.initAccessorAndDataStore(acc, datastore, 0);
        VM accessor = this.getVMForTransactions(acc, datastore);
        final TXId txId = (TXId)accessor.invoke(new DoOpsInTX(OP.DESTROY));
        datastore.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                TXManagerImpl mgr = RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager();
                TestCase.assertTrue((boolean)mgr.isHostedTxInProgress((TransactionId)txId));
                TXStateProxy tx = mgr.getHostedTXState(txId);
                int n = tx.getProxy().batchingEnabled() ? 2 : 3;
                TestCase.assertEquals((String)("unexpected regions: " + tx.getRegions()), (int)n, (int)tx.getRegions().size());
                for (LocalRegion r : tx.getRegions()) {
                    TestCase.assertTrue((r instanceof BucketRegion || r instanceof DistributedRegion ? 1 : 0) != 0);
                    TXRegionState rs = tx.readRegion(r);
                    for (Object key : rs.getEntryKeys()) {
                        TXEntryState es = (TXEntryState)rs.readEntry(key);
                        TestCase.assertNull((Object)es.getValue((Region)r));
                        TestCase.assertTrue((boolean)es.isDirty());
                    }
                }
                return null;
            }
        });
        accessor.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                TXManagerImpl mgr = RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager();
                TXStateInterface tx = mgr.getTXState();
                TestCase.assertNotNull((Object)tx);
                TestCase.assertEquals((String)("unexpected regions: " + tx.getRegions()), (int)3, (int)tx.getRegions().size());
                for (LocalRegion r : tx.getRegions()) {
                    TestCase.assertTrue((r instanceof PartitionedRegion || r instanceof DistributedRegion ? 1 : 0) != 0);
                }
                mgr.commit();
                RemoteTransactionDUnitTest.this.verifyAfterCommit(OP.DESTROY);
                return null;
            }
        });
    }

    public void DISABLED_TILL_NEW_TX_IMPL_COMPLETE_testTxPutIfAbsent() {
        Host host = Host.getHost(0);
        VM acc = host.getVM(0);
        VM datastore = host.getVM(1);
        this.initAccessorAndDataStore(acc, datastore, 0);
        VM accessor = this.getVMForTransactions(acc, datastore);
        final CustId newCustId = new CustId(10);
        final Customer updateCust = new Customer("customer10", "address10");
        final TXId txId = (TXId)accessor.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                TXManagerImpl mgr = RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager();
                mgr.begin();
                Region cust = RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                Region rr = RemoteTransactionDUnitTest.this.getCache().getRegion("distrReference");
                Customer expectedCust = new Customer("customer1", "address1");
                RemoteTransactionDUnitTest.this.getGemfireCache().getLoggerI18n().fine("SWAP:doingPutIfAbsent");
                CustId oldCustId = new CustId(1);
                Customer old = (Customer)cust.putIfAbsent((Object)oldCustId, (Object)updateCust);
                TestCase.assertTrue((String)("expected:" + expectedCust + " but was " + old), (boolean)expectedCust.equals(old));
                old = (Customer)rr.putIfAbsent((Object)oldCustId, (Object)updateCust);
                TestCase.assertTrue((String)("expected:" + expectedCust + " but was " + old), (boolean)expectedCust.equals(old));
                old = (Customer)cust.putIfAbsent((Object)newCustId, (Object)updateCust);
                TestCase.assertNull((Object)old);
                old = (Customer)rr.putIfAbsent((Object)newCustId, (Object)updateCust);
                TestCase.assertNull((Object)old);
                Region order = RemoteTransactionDUnitTest.this.getCache().getRegion("orderRegion");
                Order oldOrder = (Order)order.putIfAbsent((Object)new OrderId(10, newCustId), (Object)new Order("order10"));
                TestCase.assertNull((Object)old);
                TestCase.assertNull((Object)oldOrder);
                TestCase.assertNotNull((Object)cust.get((Object)newCustId));
                TestCase.assertNotNull((Object)rr.get((Object)newCustId));
                TXStateInterface tx = mgr.internalSuspend();
                TestCase.assertNull((Object)cust.get((Object)newCustId));
                TestCase.assertNull((Object)rr.get((Object)newCustId));
                mgr.resume(tx);
                cust.put((Object)oldCustId, (Object)new Customer("foo", "bar"));
                rr.put((Object)oldCustId, (Object)new Customer("foo", "bar"));
                return mgr.getTransactionId();
            }
        });
        datastore.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region cust = RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                int hash1 = PartitionedRegionHelper.getHashKey((PartitionedRegion)((PartitionedRegion)cust), (Object)new CustId(1));
                int hash10 = PartitionedRegionHelper.getHashKey((PartitionedRegion)((PartitionedRegion)cust), (Object)new CustId(10));
                TXManagerImpl mgr = RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager();
                TestCase.assertTrue((boolean)mgr.isHostedTxInProgress((TransactionId)txId));
                TXStateProxy tx = mgr.getHostedTXState(txId);
                TestCase.assertEquals((String)("unexpected regions: " + tx.getRegions()), (int)(3 + (hash1 == hash10 ? 0 : 1)), (int)tx.getRegions().size());
                for (LocalRegion r : tx.getRegions()) {
                    TestCase.assertTrue((r instanceof BucketRegion || r instanceof DistributedRegion ? 1 : 0) != 0);
                    TXRegionState rs = tx.readRegion(r);
                    for (Object key : rs.getEntryKeys()) {
                        TXEntryState es = (TXEntryState)rs.readEntry(key);
                        TestCase.assertNotNull((Object)es.getValue((Region)r));
                        TestCase.assertTrue((String)("key:" + key + " r:" + r.getFullPath()), (boolean)es.isDirty());
                    }
                }
                return null;
            }
        });
        accessor.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                TXManagerImpl mgr = RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager();
                mgr.commit();
                Region cust = RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                Region rr = RemoteTransactionDUnitTest.this.getCache().getRegion("distrReference");
                TestCase.assertEquals((Object)updateCust, (Object)cust.get((Object)newCustId));
                TestCase.assertEquals((Object)updateCust, (Object)rr.get((Object)newCustId));
                mgr.begin();
                CustId conflictCust = new CustId(11);
                cust.putIfAbsent((Object)conflictCust, (Object)new Customer("name11", "address11"));
                TXStateInterface tx = mgr.internalSuspend();
                cust.put((Object)conflictCust, (Object)new Customer("foo", "bar"));
                mgr.resume(tx);
                try {
                    mgr.commit();
                    TestCase.fail((String)"expected exception not thrown");
                }
                catch (ConflictException conflictException) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    public VM getVMForTransactions(VM accessor, VM datastore) {
        return accessor;
    }

    public void Bug44146_testTxRemove() {
        Host host = Host.getHost(0);
        VM acc = host.getVM(0);
        VM datastore = host.getVM(1);
        this.initAccessorAndDataStore(acc, datastore, 0);
        VM accessor = this.getVMForTransactions(acc, datastore);
        final CustId custId = new CustId(1);
        final TXId txId = (TXId)accessor.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region cust = RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                Region ref = RemoteTransactionDUnitTest.this.getCache().getRegion("distrReference");
                TXManagerImpl mgr = RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager();
                mgr.begin();
                Customer customer = new Customer("customer1", "address1");
                Customer fakeCust = new Customer("foo", "bar");
                TestCase.assertFalse((boolean)cust.remove((Object)custId, (Object)fakeCust));
                TestCase.assertTrue((boolean)cust.remove((Object)custId, (Object)customer));
                TestCase.assertFalse((boolean)ref.remove((Object)custId, (Object)fakeCust));
                TestCase.assertTrue((boolean)ref.remove((Object)custId, (Object)customer));
                TXStateInterface tx = mgr.internalSuspend();
                TestCase.assertNotNull((Object)cust.get((Object)custId));
                TestCase.assertNotNull((Object)ref.get((Object)custId));
                mgr.resume(tx);
                return mgr.getTransactionId();
            }
        });
        datastore.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                TXManagerImpl mgr = RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager();
                TestCase.assertTrue((boolean)mgr.isHostedTxInProgress((TransactionId)txId));
                TXStateProxy tx = mgr.getHostedTXState(txId);
                int n = tx.getProxy().batchingEnabled() ? 1 : 2;
                TestCase.assertEquals((String)("unexpected regions: " + tx.getRegions()), (int)n, (int)tx.getRegions().size());
                for (LocalRegion r : tx.getRegions()) {
                    TestCase.assertTrue((r instanceof BucketRegion || r instanceof DistributedRegion ? 1 : 0) != 0);
                    TXRegionState rs = tx.readRegion(r);
                    for (Object key : rs.getEntryKeys()) {
                        TXEntryState es = (TXEntryState)rs.readEntry(key);
                        TestCase.assertNull((Object)es.getValue((Region)r));
                        TestCase.assertTrue((String)("key:" + key + " r:" + r.getFullPath()), (boolean)es.isDirty());
                    }
                }
                return null;
            }
        });
        final CustId conflictCust = new CustId(2);
        accessor.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                TXManagerImpl mgr = RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager();
                TXStateInterface tx = mgr.getTXState();
                TestCase.assertNotNull((Object)tx);
                TestCase.assertEquals((String)("unexpected regions: " + tx.getRegions()), (int)2, (int)tx.getRegions().size());
                for (LocalRegion r : tx.getRegions()) {
                    TestCase.assertTrue((r instanceof PartitionedRegion || r instanceof DistributedRegion ? 1 : 0) != 0);
                }
                mgr.commit();
                Region cust = RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                Region rr = RemoteTransactionDUnitTest.this.getCache().getRegion("distrReference");
                TestCase.assertNull((Object)cust.get((Object)custId));
                TestCase.assertNull((Object)rr.get((Object)custId));
                mgr.begin();
                Customer customer = new Customer("customer2", "address2");
                RemoteTransactionDUnitTest.this.getGemfireCache().getLoggerI18n().fine("SWAP:removeConflict");
                TestCase.assertTrue((boolean)cust.remove((Object)conflictCust, (Object)customer));
                return null;
            }
        });
        datastore.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                TXManagerImpl mgr = RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager();
                Region cust = RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                mgr.begin();
                try {
                    cust.put((Object)conflictCust, (Object)new Customer("foo", "bar"));
                    TestCase.fail((String)"expected exception not thrown");
                }
                catch (ConflictException conflictException) {
                    // empty catch block
                }
                mgr.commit();
                return null;
            }
        });
        accessor.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                TXManagerImpl mgr = RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager();
                mgr.commit();
                return null;
            }
        });
    }

    public void DISABLED_TILL_NEW_TX_IMPL_COMPLETE_testTxReplace() {
        Host host = Host.getHost(0);
        VM acc = host.getVM(0);
        VM datastore = host.getVM(1);
        this.initAccessorAndDataStore(acc, datastore, 0);
        VM accessor = this.getVMForTransactions(acc, datastore);
        final CustId custId = new CustId(1);
        final Customer updatedCust = new Customer("updated", "updated");
        final TXId txId = (TXId)accessor.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region cust = RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                Region ref = RemoteTransactionDUnitTest.this.getCache().getRegion("distrReference");
                TXManagerImpl mgr = RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager();
                mgr.begin();
                Customer customer = new Customer("customer1", "address1");
                Customer fakeCust = new Customer("foo", "bar");
                TestCase.assertFalse((boolean)cust.replace((Object)custId, (Object)fakeCust, (Object)updatedCust));
                TestCase.assertTrue((boolean)cust.replace((Object)custId, (Object)customer, (Object)updatedCust));
                TestCase.assertFalse((boolean)ref.replace((Object)custId, (Object)fakeCust, (Object)updatedCust));
                TestCase.assertTrue((boolean)ref.replace((Object)custId, (Object)customer, (Object)updatedCust));
                TXStateInterface tx = mgr.internalSuspend();
                TestCase.assertEquals((Object)cust.get((Object)custId), (Object)customer);
                TestCase.assertEquals((Object)ref.get((Object)custId), (Object)customer);
                mgr.resume(tx);
                return mgr.getTransactionId();
            }
        });
        datastore.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                TXManagerImpl mgr = RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager();
                TestCase.assertTrue((boolean)mgr.isHostedTxInProgress((TransactionId)txId));
                TXStateProxy tx = mgr.getHostedTXState(txId);
                TestCase.assertEquals((String)("unexpected regions: " + tx.getRegions()), (int)2, (int)tx.getRegions().size());
                for (LocalRegion r : tx.getRegions()) {
                    TestCase.assertTrue((r instanceof BucketRegion || r instanceof DistributedRegion ? 1 : 0) != 0);
                    TXRegionState rs = tx.readRegion(r);
                    for (Object key : rs.getEntryKeys()) {
                        TXEntryState es = (TXEntryState)rs.readEntry(key);
                        TestCase.assertNotNull((Object)es.getValue((Region)r));
                        TestCase.assertTrue((String)("key:" + key + " r:" + r.getFullPath()), (boolean)es.isDirty());
                    }
                }
                return null;
            }
        });
        accessor.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                TXManagerImpl mgr = RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager();
                mgr.commit();
                Region cust = RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                Region rr = RemoteTransactionDUnitTest.this.getCache().getRegion("distrReference");
                TestCase.assertEquals((Object)updatedCust, (Object)cust.get((Object)custId));
                TestCase.assertEquals((Object)updatedCust, (Object)rr.get((Object)custId));
                mgr.begin();
                CustId conflictCust = new CustId(2);
                Customer customer = new Customer("customer2", "address2");
                RemoteTransactionDUnitTest.this.getGemfireCache().getLoggerI18n().fine("SWAP:removeConflict");
                TestCase.assertTrue((boolean)cust.replace((Object)conflictCust, (Object)customer, (Object)new Customer("conflict", "conflict")));
                TXStateInterface tx = mgr.internalSuspend();
                cust.put((Object)conflictCust, (Object)new Customer("foo", "bar"));
                mgr.resume(tx);
                try {
                    mgr.commit();
                    TestCase.fail((String)"expected exception not thrown");
                }
                catch (ConflictException conflictException) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    public void Bug44146_testNonColocatedTX() {
        Host host = Host.getHost(0);
        VM accessor = host.getVM(0);
        VM datastore1 = host.getVM(1);
        VM datastore2 = host.getVM(2);
        datastore2.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                RemoteTransactionDUnitTest.this.createRegion(false, 1, null);
                return null;
            }
        });
        this.initAccessorAndDataStore(accessor, datastore1, 1);
        final TXId txId = (TXId)accessor.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region custRegion = RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                Region orderRegion = RemoteTransactionDUnitTest.this.getCache().getRegion("orderRegion");
                TXManagerImpl mgr = RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager();
                mgr.begin();
                RemoteTransactionDUnitTest.this.put10Entries((Region<CustId, Customer>)custRegion, (Region<OrderId, Order>)orderRegion);
                return mgr.getTransactionId();
            }
        });
        Integer txOnDatastore1 = (Integer)datastore1.invoke(this.getNumberOfTXInProgress);
        Integer txOnDatastore2 = (Integer)datastore2.invoke(this.getNumberOfTXInProgress);
        RemoteTransactionDUnitTest.assertEquals((int)2, (int)(txOnDatastore1 + txOnDatastore2));
        datastore1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                LocalRegion custRegion = (LocalRegion)RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                LocalRegion orderRegion = (LocalRegion)RemoteTransactionDUnitTest.this.getCache().getRegion("orderRegion");
                TXManagerImpl mgr = RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager();
                TXState txState = mgr.getHostedTXState(txId).getLocalTXState();
                TXStateInterface currentTX = mgr.getTXState();
                mgr.masqueradeAs((TXStateInterface)txState);
                for (int index = 0; index < 10; ++index) {
                    CustId custId = new CustId(index);
                    TestCase.assertEquals((Object)new Customer("customer" + index, "address" + index), (Object)txState.getEntry(new KeyInfo((Object)custId, null, null), custRegion, false, false).getValue());
                    TestCase.assertEquals((Object)new Order("order" + index), (Object)txState.getEntry(new KeyInfo((Object)new OrderId(index, custId), null, null), orderRegion, false, false).getValue());
                }
                mgr.masqueradeAs(currentTX);
                return null;
            }
        });
        datastore2.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                LocalRegion custRegion = (LocalRegion)RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                LocalRegion orderRegion = (LocalRegion)RemoteTransactionDUnitTest.this.getCache().getRegion("orderRegion");
                TXManagerImpl mgr = RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager();
                TXState txState = mgr.getHostedTXState(txId).getLocalTXState();
                TXStateInterface currentTX = mgr.getTXState();
                mgr.masqueradeAs((TXStateInterface)txState);
                for (int index = 0; index < 10; ++index) {
                    CustId custId = new CustId(index);
                    TestCase.assertEquals((Object)new Customer("customer" + index, "address" + index), (Object)txState.getEntry(new KeyInfo((Object)custId, null, null), custRegion, false, false).getValue());
                    TestCase.assertEquals((Object)new Order("order" + index), (Object)txState.getEntry(new KeyInfo((Object)new OrderId(index, custId), null, null), orderRegion, false, false).getValue());
                }
                mgr.masqueradeAs(currentTX);
                return null;
            }
        });
        accessor.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                LocalRegion custRegion = (LocalRegion)RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                LocalRegion orderRegion = (LocalRegion)RemoteTransactionDUnitTest.this.getCache().getRegion("orderRegion");
                for (int index = 0; index < 10; ++index) {
                    CustId custId = new CustId(index);
                    TestCase.assertEquals((Object)new Customer("customer" + index, "address" + index), (Object)custRegion.getEntry((Object)custId).getValue());
                    TestCase.assertEquals((Object)new Order("order" + index), (Object)orderRegion.get((Object)new OrderId(index, custId)));
                }
                return null;
            }
        });
        accessor.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                TXManagerImpl mgr = RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager();
                mgr.rollback();
                LocalRegion custRegion = (LocalRegion)RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                LocalRegion orderRegion = (LocalRegion)RemoteTransactionDUnitTest.this.getCache().getRegion("orderRegion");
                for (int index = 0; index < 10; ++index) {
                    CustId custId = new CustId(index);
                    if (index < 5) {
                        TestCase.assertEquals((Object)new Customer("customer" + index, "address" + index), (Object)custRegion.get((Object)custId));
                        TestCase.assertEquals((Object)new Order("order" + index), (Object)orderRegion.getEntry((Object)new OrderId(index, custId)).getValue());
                        continue;
                    }
                    TestCase.assertNull((Object)custRegion.get((Object)custId));
                    TestCase.assertNull((Object)orderRegion.getEntry((Object)new OrderId(index, custId)));
                }
                return null;
            }
        });
        datastore1.invoke(this.verifyNoTxState);
        datastore2.invoke(this.verifyNoTxState);
        datastore1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                LocalRegion custRegion = (LocalRegion)RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                LocalRegion orderRegion = (LocalRegion)RemoteTransactionDUnitTest.this.getCache().getRegion("orderRegion");
                for (int index = 0; index < 10; ++index) {
                    CustId custId = new CustId(index);
                    if (index < 5) {
                        TestCase.assertEquals((Object)new Customer("customer" + index, "address" + index), (Object)custRegion.getEntry((Object)custId).getValue());
                        TestCase.assertEquals((Object)new Order("order" + index), (Object)orderRegion.get((Object)new OrderId(index, custId)));
                        continue;
                    }
                    TestCase.assertNull((Object)custRegion.get((Object)custId));
                    TestCase.assertNull((Object)orderRegion.getEntry((Object)new OrderId(index, custId)));
                }
                return null;
            }
        });
        datastore2.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                LocalRegion custRegion = (LocalRegion)RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                LocalRegion orderRegion = (LocalRegion)RemoteTransactionDUnitTest.this.getCache().getRegion("orderRegion");
                for (int index = 0; index < 10; ++index) {
                    CustId custId = new CustId(index);
                    if (index < 5) {
                        TestCase.assertEquals((Object)new Customer("customer" + index, "address" + index), (Object)custRegion.get((Object)custId));
                        TestCase.assertEquals((Object)new Order("order" + index), (Object)orderRegion.get((Object)new OrderId(index, custId)));
                        continue;
                    }
                    TestCase.assertNull((Object)custRegion.get((Object)custId));
                    TestCase.assertNull((Object)orderRegion.getEntry((Object)new OrderId(index, custId)));
                }
                return null;
            }
        });
        final TXId txId2 = (TXId)accessor.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region custRegion = RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                Region orderRegion = RemoteTransactionDUnitTest.this.getCache().getRegion("orderRegion");
                TXManagerImpl mgr = RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager();
                mgr.begin();
                RemoteTransactionDUnitTest.this.put10Entries((Region<CustId, Customer>)custRegion, (Region<OrderId, Order>)orderRegion);
                return mgr.getTransactionId();
            }
        });
        datastore1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                LocalRegion custRegion = (LocalRegion)RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                LocalRegion orderRegion = (LocalRegion)RemoteTransactionDUnitTest.this.getCache().getRegion("orderRegion");
                TXManagerImpl mgr = RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager();
                TXState txState = mgr.getHostedTXState(txId2).getLocalTXState();
                TXStateInterface currentTX = mgr.getTXState();
                mgr.masqueradeAs((TXStateInterface)txState);
                for (int index = 0; index < 10; ++index) {
                    CustId custId = new CustId(index);
                    TestCase.assertEquals((Object)new Customer("customer" + index, "address" + index), (Object)txState.getEntry(new KeyInfo((Object)custId, null, null), custRegion, false, false).getValue());
                    TestCase.assertEquals((Object)new Order("order" + index), (Object)txState.getEntry(new KeyInfo((Object)new OrderId(index, custId), null, null), orderRegion, false, false).getValue());
                }
                mgr.masqueradeAs(currentTX);
                return null;
            }
        });
        datastore2.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                LocalRegion custRegion = (LocalRegion)RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                LocalRegion orderRegion = (LocalRegion)RemoteTransactionDUnitTest.this.getCache().getRegion("orderRegion");
                TXManagerImpl mgr = RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager();
                TXState txState = mgr.getHostedTXState(txId2).getLocalTXState();
                TXStateInterface currentTX = mgr.getTXState();
                mgr.masqueradeAs((TXStateInterface)txState);
                for (int index = 0; index < 10; ++index) {
                    CustId custId = new CustId(index);
                    TestCase.assertEquals((Object)new Customer("customer" + index, "address" + index), (Object)txState.getEntry(new KeyInfo((Object)custId, null, null), custRegion, false, false).getValue());
                    TestCase.assertEquals((Object)new Order("order" + index), (Object)txState.getEntry(new KeyInfo((Object)new OrderId(index, custId), null, null), orderRegion, false, false).getValue());
                }
                mgr.masqueradeAs(currentTX);
                return null;
            }
        });
        accessor.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                LocalRegion custRegion = (LocalRegion)RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                LocalRegion orderRegion = (LocalRegion)RemoteTransactionDUnitTest.this.getCache().getRegion("orderRegion");
                for (int index = 0; index < 10; ++index) {
                    CustId custId = new CustId(index);
                    TestCase.assertEquals((Object)new Customer("customer" + index, "address" + index), (Object)custRegion.get((Object)custId));
                    TestCase.assertEquals((Object)new Order("order" + index), (Object)orderRegion.getEntry((Object)new OrderId(index, custId)).getValue());
                }
                return null;
            }
        });
        accessor.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                TXManagerImpl mgr = RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager();
                mgr.commit();
                LocalRegion custRegion = (LocalRegion)RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                LocalRegion orderRegion = (LocalRegion)RemoteTransactionDUnitTest.this.getCache().getRegion("orderRegion");
                for (int index = 0; index < 10; ++index) {
                    CustId custId = new CustId(index);
                    TestCase.assertEquals((Object)new Customer("customer" + index, "address" + index), (Object)custRegion.getEntry((Object)custId).getValue());
                    TestCase.assertEquals((Object)new Order("order" + index), (Object)orderRegion.get((Object)new OrderId(index, custId)));
                }
                return null;
            }
        });
        accessor.invoke(this.waitForPendingCommit);
        datastore1.invoke(this.verifyNoTxState);
        datastore2.invoke(this.verifyNoTxState);
        datastore1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                LocalRegion custRegion = (LocalRegion)RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                LocalRegion orderRegion = (LocalRegion)RemoteTransactionDUnitTest.this.getCache().getRegion("orderRegion");
                for (int index = 0; index < 10; ++index) {
                    CustId custId = new CustId(index);
                    TestCase.assertEquals((Object)new Customer("customer" + index, "address" + index), (Object)custRegion.get((Object)custId));
                    TestCase.assertEquals((Object)new Order("order" + index), (Object)orderRegion.getEntry((Object)new OrderId(index, custId)).getValue());
                }
                return null;
            }
        });
        datastore2.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                LocalRegion custRegion = (LocalRegion)RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                LocalRegion orderRegion = (LocalRegion)RemoteTransactionDUnitTest.this.getCache().getRegion("orderRegion");
                for (int index = 0; index < 10; ++index) {
                    CustId custId = new CustId(index);
                    TestCase.assertEquals((Object)new Customer("customer" + index, "address" + index), (Object)custRegion.getEntry((Object)custId).getValue());
                    TestCase.assertEquals((Object)new Order("order" + index), (Object)orderRegion.get((Object)new OrderId(index, custId)));
                }
                return null;
            }
        });
    }

    private void put10Entries(Region<CustId, Customer> custRegion, Region<OrderId, Order> orderRegion) {
        for (int i = 0; i < 10; ++i) {
            CustId custId = new CustId(i);
            Customer customer = new Customer("customer" + i, "address" + i);
            OrderId orderId = new OrderId(i, custId);
            Order order = new Order("order" + i);
            if (i >= 5) {
                custRegion.create((Object)custId, (Object)customer);
                orderRegion.create((Object)orderId, (Object)order);
                continue;
            }
            custRegion.put((Object)custId, (Object)customer);
            orderRegion.put((Object)orderId, (Object)order);
        }
    }

    public void Bug44146_testListenersForPut() {
        this.doTestListeners(OP.PUT);
    }

    public void Bug44146_testListenersForDestroy() {
        this.doTestListeners(OP.DESTROY);
    }

    public void Bug44146_testListenersForInvalidate() {
        this.doTestListeners(OP.INVALIDATE);
    }

    private void doTestListeners(OP op) {
        Host host = Host.getHost(0);
        VM acc = host.getVM(0);
        VM datastore = host.getVM(1);
        this.initAccessorAndDataStore(acc, datastore, 0);
        VM accessor = this.getVMForTransactions(acc, datastore);
        accessor.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region cust = RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                cust.getAttributesMutator().addCacheListener((CacheListener)new TestCacheListener(true));
                cust.getAttributesMutator().setCacheWriter((CacheWriter)new TestCacheWriter(true));
                Region order = RemoteTransactionDUnitTest.this.getCache().getRegion("orderRegion");
                order.getAttributesMutator().addCacheListener((CacheListener)new TestCacheListener(true));
                order.getAttributesMutator().setCacheWriter((CacheWriter)new TestCacheWriter(true));
                RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager().addListener((TransactionListener)new TestTxListener(true));
                if (!RemoteTransactionDUnitTest.this.getGemfireCache().isClient()) {
                    RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager().setWriter((TransactionWriter)new TestTxWriter(true));
                }
                return null;
            }
        });
        datastore.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region cust = RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                cust.getAttributesMutator().addCacheListener((CacheListener)new TestCacheListener(false));
                cust.getAttributesMutator().setCacheWriter((CacheWriter)new TestCacheWriter(false));
                Region order = RemoteTransactionDUnitTest.this.getCache().getRegion("orderRegion");
                order.getAttributesMutator().addCacheListener((CacheListener)new TestCacheListener(false));
                order.getAttributesMutator().setCacheWriter((CacheWriter)new TestCacheWriter(false));
                RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager().addListener((TransactionListener)new TestTxListener(false));
                if (!RemoteTransactionDUnitTest.this.getGemfireCache().isClient()) {
                    RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager().setWriter((TransactionWriter)new TestTxWriter(false));
                }
                return null;
            }
        });
        accessor.invoke(new DoOpsInTX(op));
        accessor.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                TXManagerImpl mgr = RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager();
                mgr.commit();
                TXManagerImpl.waitForPendingCommitForTest();
                return null;
            }
        });
        datastore.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                TestTxListener l = (TestTxListener)RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager().getListener();
                TestCase.assertTrue((boolean)l.isListenerInvoked());
                return null;
            }
        });
        SerializableCallable verifyListeners = new SerializableCallable(){

            public Object call() throws Exception {
                Region cust = RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                Region order = RemoteTransactionDUnitTest.this.getCache().getRegion("orderRegion");
                this.throwListenerException(cust);
                this.throwListenerException(order);
                this.throwWriterException(cust);
                this.throwWriterException(order);
                if (!RemoteTransactionDUnitTest.this.getGemfireCache().isClient()) {
                    this.throwTransactionCallbackException();
                }
                return null;
            }

            private void throwTransactionCallbackException() throws Exception {
                TestTxListener l = (TestTxListener)RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager().getListener();
                if (l.ex != null) {
                    throw l.ex;
                }
                TestTxWriter w = (TestTxWriter)RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager().getWriter();
                if (w.ex != null) {
                    throw w.ex;
                }
            }

            private void throwListenerException(Region r) throws Exception {
                Exception e = null;
                CacheListener listener = r.getAttributes().getCacheListeners()[0];
                if (listener instanceof TestCacheListener) {
                    e = ((TestCacheListener)listener).ex;
                }
                if (e != null) {
                    throw e;
                }
            }

            private void throwWriterException(Region r) throws Exception {
                Exception e = null;
                CacheListener listener = r.getAttributes().getCacheListeners()[0];
                if (listener instanceof TestCacheListener) {
                    e = ((TestCacheListener)listener).ex;
                }
                if (e != null) {
                    throw e;
                }
            }
        };
        accessor.invoke(verifyListeners);
        datastore.invoke(verifyListeners);
    }

    public void DISABLED_TILL_NEW_TX_IMPL_COMPLETE_testRemoteExceptionThrown() {
        Host host = Host.getHost(0);
        VM acc = host.getVM(0);
        VM datastore = host.getVM(1);
        this.initAccessorAndDataStore(acc, datastore, 0);
        VM accessor = this.getVMForTransactions(acc, datastore);
        datastore.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager().setWriter(new TransactionWriter(){

                    public void close() {
                    }

                    public void beforeCommit(TransactionEvent event) throws TransactionWriterException {
                        throw new TransactionWriterException("TestException");
                    }
                });
                return null;
            }
        });
        accessor.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager().begin();
                Region r = RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                r.put((Object)new CustId(8), (Object)new Customer("name8", "address8"));
                try {
                    RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager().commit();
                    TestCase.fail((String)"Expected exception not thrown");
                }
                catch (Exception e) {
                    TestCase.assertEquals((String)"TestException", (String)e.getCause().getMessage());
                }
                return null;
            }
        });
    }

    public void Bug44146testSize() {
        Host host = Host.getHost(0);
        VM accessor = host.getVM(0);
        VM datastore1 = host.getVM(1);
        VM datastore2 = host.getVM(2);
        this.initAccessorAndDataStore(accessor, datastore1, datastore2, 0);
        accessor.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region custRegion = RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                TXManagerImpl mgr = RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager();
                mgr.begin();
                TestCase.assertEquals((int)5, (int)custRegion.size());
                TestCase.assertNotNull((Object)mgr.getTXState());
                return null;
            }
        });
        datastore1.invoke(this.verifyNoTxState);
        datastore2.invoke(this.verifyNoTxState);
        accessor.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region custRegion = RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                Region orderRegion = RemoteTransactionDUnitTest.this.getCache().getRegion("orderRegion");
                TXManagerImpl mgr = RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager();
                TestCase.assertNotNull((Object)mgr.getTXState());
                CustId custId = new CustId(5);
                OrderId orderId = new OrderId(5, custId);
                custRegion.put((Object)custId, (Object)new Customer("customer5", "address5"));
                orderRegion.put((Object)orderId, (Object)new Order("order5"));
                TXStateInterface tx = mgr.internalSuspend();
                Set entries = custRegion.entrySet();
                Collection values = custRegion.values();
                Set keys = custRegion.keySet();
                TestCase.assertEquals((int)5, (int)custRegion.size());
                TestCase.assertEquals((int)5, (int)entries.size());
                TestCase.assertEquals((int)5, (int)values.size());
                TestCase.assertEquals((int)5, (int)keys.size());
                int size = 0;
                for (Object val : entries) {
                    TestCase.assertNotNull(val);
                    TestCase.assertNotNull(((Map.Entry)val).getValue());
                    ++size;
                }
                TestCase.assertEquals((int)5, (int)size);
                size = 0;
                for (Object val : values) {
                    TestCase.assertNotNull(val);
                    ++size;
                }
                TestCase.assertEquals((int)5, (int)size);
                size = 0;
                for (Object val : keys) {
                    TestCase.assertNotNull(val);
                    ++size;
                }
                TestCase.assertEquals((int)5, (int)size);
                mgr.resume(tx);
                entries = custRegion.entrySet();
                values = custRegion.values();
                keys = custRegion.keySet();
                TestCase.assertEquals((int)6, (int)custRegion.size());
                TestCase.assertEquals((int)6, (int)entries.size());
                TestCase.assertEquals((int)6, (int)values.size());
                TestCase.assertEquals((int)6, (int)keys.size());
                size = 0;
                for (Object val : entries) {
                    TestCase.assertNotNull(val);
                    TestCase.assertNotNull(((Map.Entry)val).getValue());
                    ++size;
                }
                TestCase.assertEquals((int)6, (int)size);
                size = 0;
                for (Object val : values) {
                    TestCase.assertNotNull(val);
                    ++size;
                }
                TestCase.assertEquals((int)6, (int)size);
                size = 0;
                for (Object val : keys) {
                    TestCase.assertNotNull(val);
                    ++size;
                }
                TestCase.assertEquals((int)6, (int)size);
                return mgr.getTransactionId();
            }
        });
        Integer txOnDatastore1 = (Integer)datastore1.invoke(this.getNumberOfTXInProgress);
        Integer txOnDatastore2 = (Integer)datastore2.invoke(this.getNumberOfTXInProgress);
        RemoteTransactionDUnitTest.assertEquals((int)1, (int)(txOnDatastore1 + txOnDatastore2));
        accessor.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                TXManagerImpl mgr = RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager();
                mgr.commit();
                TXManagerImpl.waitForPendingCommitForTest();
                return null;
            }
        });
        Integer txOnDatastore1_1 = (Integer)datastore1.invoke(this.getNumberOfTXInProgress);
        Integer txOnDatastore2_2 = (Integer)datastore2.invoke(this.getNumberOfTXInProgress);
        RemoteTransactionDUnitTest.assertEquals((int)0, (int)(txOnDatastore1_1 + txOnDatastore2_2));
    }

    public void Bug44146_testKeysIterator() {
        this.doTestIterator(OP.KEYS, 0, OP.PUT);
    }

    public void Bug44146_testValuesIterator() {
        this.doTestIterator(OP.VALUES, 0, OP.PUT);
    }

    public void Bug44146_testEntriesIterator() {
        this.doTestIterator(OP.ENTRIES, 0, OP.PUT);
    }

    public void Bug44146_testKeysIterator1() {
        this.doTestIterator(OP.KEYS, 1, OP.PUT);
    }

    public void Bug44146_testValuesIterator1() {
        this.doTestIterator(OP.VALUES, 1, OP.PUT);
    }

    public void Bug44146_testEntriesIterator1() {
        this.doTestIterator(OP.ENTRIES, 1, OP.PUT);
    }

    public void Bug44146_testKeysIteratorOnDestroy() {
        this.doTestIterator(OP.KEYS, 0, OP.DESTROY);
    }

    public void Bug44146_testValuesIteratorOnDestroy() {
        this.doTestIterator(OP.VALUES, 0, OP.DESTROY);
    }

    public void Bug44146_testEntriesIteratorOnDestroy() {
        this.doTestIterator(OP.ENTRIES, 0, OP.DESTROY);
    }

    public void Bug44146_testKeysIterator1OnDestroy() {
        this.doTestIterator(OP.KEYS, 1, OP.DESTROY);
    }

    public void Bug44146_testValuesIterator1OnDestroy() {
        this.doTestIterator(OP.VALUES, 1, OP.DESTROY);
    }

    public void Bug44146_testEntriesIterator1OnDestroy() {
        this.doTestIterator(OP.ENTRIES, 1, OP.DESTROY);
    }

    private void doTestIterator(final OP iteratorType, int redundancy, final OP op) {
        Host host = Host.getHost(0);
        VM accessor = host.getVM(0);
        VM datastore1 = host.getVM(1);
        VM datastore2 = host.getVM(2);
        this.initAccessorAndDataStore(accessor, datastore1, datastore2, redundancy);
        accessor.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region custRegion = RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                TXManagerImpl mgr = RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager();
                mgr.begin();
                switch (iteratorType) {
                    case KEYS: {
                        Set<CustId> originalSet = RemoteTransactionDUnitTest.this.getCustIdSet(5);
                        TestCase.assertTrue((boolean)originalSet.containsAll(custRegion.keySet()));
                        TestCase.assertEquals((int)5, (int)custRegion.keySet().size());
                        break;
                    }
                    case VALUES: {
                        Set<Customer> originalSet = RemoteTransactionDUnitTest.this.getCustomerSet(5);
                        TestCase.assertTrue((boolean)originalSet.containsAll(custRegion.values()));
                        TestCase.assertEquals((int)5, (int)custRegion.values().size());
                        break;
                    }
                    case ENTRIES: {
                        Set<CustId> originalKeySet = RemoteTransactionDUnitTest.this.getCustIdSet(5);
                        Set<Customer> originalValueSet = RemoteTransactionDUnitTest.this.getCustomerSet(5);
                        HashSet entrySet = new HashSet();
                        Iterator it = custRegion.entrySet().iterator();
                        while (it.hasNext()) {
                            entrySet.add(it.next());
                        }
                        for (Region.Entry entry : entrySet) {
                            TestCase.assertTrue((boolean)originalKeySet.contains(entry.getKey()));
                            TestCase.assertTrue((boolean)originalValueSet.contains(entry.getValue()));
                        }
                        TestCase.assertEquals((int)5, (int)custRegion.entrySet().size());
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                TestCase.assertNotNull((Object)mgr.getTXState());
                return null;
            }
        });
        if (iteratorType != OP.KEYS) {
            this.getClass();
        }
        datastore1.invoke(this.verifyNoTxState);
        datastore2.invoke(this.verifyNoTxState);
        accessor.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region custRegion = RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                Region orderRegion = RemoteTransactionDUnitTest.this.getCache().getRegion("orderRegion");
                TXManagerImpl mgr = RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager();
                TestCase.assertNotNull((Object)mgr.getTXState());
                int expectedSetSize = 0;
                switch (op) {
                    case PUT: {
                        CustId custId = new CustId(5);
                        OrderId orderId = new OrderId(5, custId);
                        custRegion.put((Object)custId, (Object)new Customer("customer5", "address5"));
                        orderRegion.put((Object)orderId, (Object)new Order("order5"));
                        expectedSetSize = 6;
                        break;
                    }
                    case DESTROY: {
                        CustId custId1 = new CustId(4);
                        OrderId orderId1 = new OrderId(4, custId1);
                        custRegion.destroy((Object)custId1);
                        orderRegion.destroy((Object)orderId1);
                        expectedSetSize = 4;
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                switch (iteratorType) {
                    case KEYS: {
                        Set<Object> expectedSet = RemoteTransactionDUnitTest.this.getCustIdSet(expectedSetSize);
                        TestCase.assertTrue((boolean)expectedSet.containsAll(custRegion.keySet()));
                        TestCase.assertEquals((int)expectedSetSize, (int)custRegion.keySet().size());
                        break;
                    }
                    case VALUES: {
                        Set<Object> expectedSet = RemoteTransactionDUnitTest.this.getCustomerSet(expectedSetSize);
                        TestCase.assertTrue((boolean)expectedSet.containsAll(custRegion.values()));
                        TestCase.assertEquals((int)expectedSetSize, (int)custRegion.values().size());
                        break;
                    }
                    case ENTRIES: {
                        Set<CustId> originalKeySet = RemoteTransactionDUnitTest.this.getCustIdSet(expectedSetSize);
                        Set<Customer> originalValueSet = RemoteTransactionDUnitTest.this.getCustomerSet(expectedSetSize);
                        HashSet entrySet = new HashSet();
                        Iterator it = custRegion.entrySet().iterator();
                        while (it.hasNext()) {
                            entrySet.add(it.next());
                        }
                        for (Region.Entry entry : entrySet) {
                            TestCase.assertTrue((boolean)originalKeySet.contains(entry.getKey()));
                            TestCase.assertTrue((boolean)originalValueSet.contains(entry.getValue()));
                        }
                        TestCase.assertEquals((int)expectedSetSize, (int)custRegion.entrySet().size());
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                return null;
            }
        });
        Integer txOnDatastore1 = (Integer)datastore1.invoke(this.getNumberOfTXInProgress);
        Integer txOnDatastore2 = (Integer)datastore2.invoke(this.getNumberOfTXInProgress);
        if (iteratorType != OP.KEYS) {
            this.getClass();
        }
        RemoteTransactionDUnitTest.assertEquals((int)(1 + redundancy), (int)(txOnDatastore1 + txOnDatastore2));
        accessor.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                TXManagerImpl mgr = RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager();
                mgr.commit();
                TXManagerImpl.waitForPendingCommitForTest();
                return null;
            }
        });
        Integer txOnDatastore1_1 = (Integer)datastore1.invoke(this.getNumberOfTXInProgress);
        Integer txOnDatastore2_2 = (Integer)datastore2.invoke(this.getNumberOfTXInProgress);
        RemoteTransactionDUnitTest.assertEquals((int)0, (int)(txOnDatastore1_1 + txOnDatastore2_2));
        datastore1.invoke(new SerializableCallable(){
            CustId custId;
            Customer customer;
            PartitionedRegion custRegion;
            int originalSetSize;
            int expectedSetSize;

            public Object call() throws Exception {
                TXManagerImpl mgr = RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager();
                this.custRegion = (PartitionedRegion)RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                mgr.begin();
                this.doLocalOp();
                switch (iteratorType) {
                    case KEYS: {
                        Set<CustId> expectedSet = this.getExpectedCustIdSet();
                        TestCase.assertEquals(expectedSet, (Object)this.custRegion.keySet());
                        TestCase.assertEquals((int)this.expectedSetSize, (int)this.custRegion.keySet().size());
                        break;
                    }
                    case VALUES: {
                        Set<Customer> expectedSet = this.getExpectedCustomerSet();
                        TestCase.assertEquals(expectedSet, (Object)this.custRegion.values());
                        TestCase.assertEquals((int)this.expectedSetSize, (int)this.custRegion.values().size());
                        break;
                    }
                    case ENTRIES: {
                        Set<CustId> originalKeySet = this.getExpectedCustIdSet();
                        Set<Customer> originalValueSet = this.getExpectedCustomerSet();
                        HashSet entrySet = new HashSet();
                        Iterator it = this.custRegion.entrySet().iterator();
                        while (it.hasNext()) {
                            entrySet.add(it.next());
                        }
                        for (Region.Entry entry : entrySet) {
                            TestCase.assertTrue((boolean)originalKeySet.contains(entry.getKey()));
                            TestCase.assertTrue((boolean)originalValueSet.contains(entry.getValue()));
                        }
                        TestCase.assertEquals((int)this.expectedSetSize, (int)this.custRegion.entrySet().size());
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                mgr.commit();
                return null;
            }

            private void doLocalOp() {
                switch (op) {
                    case PUT: {
                        int i = 6;
                        while (true) {
                            this.custId = new CustId(i);
                            this.customer = new Customer("customer" + i, "address" + i);
                            int bucketId = PartitionedRegionHelper.getHashKey((PartitionedRegion)this.custRegion, (Object)this.custId);
                            InternalDistributedMember primary = this.custRegion.getBucketPrimary(bucketId);
                            if (primary.equals(RemoteTransactionDUnitTest.this.getGemfireCache().getMyId())) break;
                            ++i;
                        }
                        this.custRegion.put((Object)this.custId, (Object)this.customer);
                        this.originalSetSize = 6;
                        this.expectedSetSize = 7;
                        break;
                    }
                    case DESTROY: {
                        int i = 3;
                        while (true) {
                            this.custId = new CustId(i);
                            this.customer = new Customer("customer" + i, "address" + i);
                            int bucketId = PartitionedRegionHelper.getHashKey((PartitionedRegion)this.custRegion, (Object)this.custId);
                            InternalDistributedMember primary = this.custRegion.getBucketPrimary(bucketId);
                            if (primary.equals(RemoteTransactionDUnitTest.this.getGemfireCache().getMyId())) break;
                            --i;
                        }
                        this.custRegion.destroy((Object)this.custId);
                        this.originalSetSize = 4;
                        this.expectedSetSize = 3;
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }

            private Set<CustId> getExpectedCustIdSet() {
                Set<CustId> retVal = RemoteTransactionDUnitTest.this.getCustIdSet(this.originalSetSize);
                switch (op) {
                    case PUT: {
                        retVal.add(this.custId);
                        break;
                    }
                    case DESTROY: {
                        retVal.remove(this.custId);
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                return retVal;
            }

            private Set<Customer> getExpectedCustomerSet() {
                Set<Customer> retVal = RemoteTransactionDUnitTest.this.getCustomerSet(this.originalSetSize);
                switch (op) {
                    case PUT: {
                        retVal.add(this.customer);
                        break;
                    }
                    case DESTROY: {
                        retVal.remove(this.customer);
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                return retVal;
            }
        });
    }

    public void Bug44146_testKeyIterationOnRR() {
        Host host = Host.getHost(0);
        VM accessor = host.getVM(0);
        VM datastore1 = host.getVM(1);
        VM datastore2 = host.getVM(2);
        this.initAccessorAndDataStore(accessor, datastore1, datastore2, 0);
        accessor.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region custRegion = RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                Region rr = RemoteTransactionDUnitTest.this.getCache().getRegion("distrReference");
                TXManagerImpl mgr = RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager();
                mgr.begin();
                CustId custId = new CustId(5);
                Customer customer = new Customer("customer5", "address5");
                custRegion.put((Object)custId, (Object)customer);
                Set origSet = rr.keySet();
                Set set = new HashSet();
                Iterator it = origSet.iterator();
                int i = 0;
                while (it.hasNext()) {
                    ++i;
                    set.add(it.next());
                }
                TestCase.assertEquals((int)5, (int)i);
                TestCase.assertTrue((boolean)RemoteTransactionDUnitTest.this.getCustIdSet(5).equals(set));
                rr.put((Object)custId, (Object)customer);
                origSet = rr.keySet();
                set.clear();
                it = origSet.iterator();
                i = 0;
                while (it.hasNext()) {
                    ++i;
                    set.add(it.next());
                }
                TestCase.assertEquals((int)6, (int)i);
                TestCase.assertTrue((boolean)RemoteTransactionDUnitTest.this.getCustIdSet(6).equals(set));
                TestCase.assertEquals((Object)customer, (Object)rr.get((Object)custId));
                TXStateInterface tx = mgr.internalSuspend();
                origSet = rr.keySet();
                set.clear();
                it = origSet.iterator();
                i = 0;
                while (it.hasNext()) {
                    ++i;
                    set.add(it.next());
                }
                TestCase.assertEquals((int)5, (int)i);
                TestCase.assertEquals(RemoteTransactionDUnitTest.this.getCustIdSet(5), set);
                TestCase.assertEquals((int)5, (int)set.size());
                TestCase.assertNull((Object)rr.get((Object)custId));
                mgr.resume(tx);
                mgr.commit();
                set = rr.keySet();
                TestCase.assertEquals((int)6, (int)set.size());
                TestCase.assertTrue((boolean)RemoteTransactionDUnitTest.this.getCustIdSet(6).equals(set));
                TestCase.assertEquals((Object)customer, (Object)rr.get((Object)custId));
                return null;
            }
        });
    }

    public void Bug44146_testValuesIterationOnRR() {
        Host host = Host.getHost(0);
        VM accessor = host.getVM(0);
        VM datastore1 = host.getVM(1);
        VM datastore2 = host.getVM(2);
        this.initAccessorAndDataStore(accessor, datastore1, datastore2, 0);
        accessor.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region custRegion = RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                Region rr = RemoteTransactionDUnitTest.this.getCache().getRegion("distrReference");
                TXManagerImpl mgr = RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager();
                mgr.begin();
                CustId custId = new CustId(5);
                Customer customer = new Customer("customer5", "address5");
                custRegion.put((Object)custId, (Object)customer);
                Collection origSet = rr.values();
                Iterator it = origSet.iterator();
                HashSet set = new HashSet();
                int i = 0;
                while (it.hasNext()) {
                    ++i;
                    set.add(it.next());
                }
                TestCase.assertEquals((int)5, (int)i);
                TestCase.assertTrue((boolean)RemoteTransactionDUnitTest.this.getCustomerSet(5).equals(set));
                TestCase.assertEquals((int)5, (int)set.size());
                rr.put((Object)custId, (Object)customer);
                origSet = rr.values();
                it = origSet.iterator();
                set.clear();
                i = 0;
                while (it.hasNext()) {
                    ++i;
                    set.add(it.next());
                }
                TestCase.assertEquals((int)6, (int)i);
                TestCase.assertTrue((boolean)RemoteTransactionDUnitTest.this.getCustomerSet(6).equals(set));
                TestCase.assertEquals((int)6, (int)set.size());
                TestCase.assertEquals((Object)customer, (Object)rr.get((Object)custId));
                TXStateInterface tx = mgr.internalSuspend();
                origSet = rr.values();
                it = origSet.iterator();
                set.clear();
                i = 0;
                while (it.hasNext()) {
                    ++i;
                    set.add(it.next());
                }
                TestCase.assertEquals((int)5, (int)i);
                TestCase.assertTrue((boolean)RemoteTransactionDUnitTest.this.getCustomerSet(5).equals(set));
                TestCase.assertEquals((int)5, (int)set.size());
                TestCase.assertNull((Object)rr.get((Object)custId));
                mgr.resume(tx);
                mgr.commit();
                return null;
            }
        });
        accessor.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region custRegion = RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                Region rr = RemoteTransactionDUnitTest.this.getCache().getRegion("distrReference");
                TestCase.assertTrue((boolean)RemoteTransactionDUnitTest.this.getCustomerSet(6).equals(custRegion.values()));
                TestCase.assertTrue((boolean)RemoteTransactionDUnitTest.this.getCustomerSet(6).equals(rr.values()));
                return null;
            }
        });
    }

    public void Bug44146_testEntriesIterationOnRR() {
        Host host = Host.getHost(0);
        VM accessor = host.getVM(0);
        VM datastore1 = host.getVM(1);
        VM datastore2 = host.getVM(2);
        this.initAccessorAndDataStore(accessor, datastore1, datastore2, 0);
        accessor.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region custRegion = RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                Region rr = RemoteTransactionDUnitTest.this.getCache().getRegion("distrReference");
                TXManagerImpl mgr = RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager();
                mgr.begin();
                CustId custId = new CustId(5);
                Customer customer = new Customer("customer5", "address5");
                custRegion.put((Object)custId, (Object)customer);
                Set set = rr.entrySet();
                Iterator it = set.iterator();
                int i = 0;
                while (it.hasNext()) {
                    ++i;
                    it.next();
                }
                TestCase.assertEquals((int)5, (int)i);
                TestCase.assertEquals((int)5, (int)rr.entrySet().size());
                rr.put((Object)custId, (Object)customer);
                set = rr.entrySet();
                it = set.iterator();
                i = 0;
                while (it.hasNext()) {
                    ++i;
                    it.next();
                }
                TestCase.assertEquals((int)6, (int)i);
                TestCase.assertEquals((int)6, (int)rr.entrySet().size());
                TestCase.assertNotNull((Object)rr.get((Object)custId));
                TXStateInterface tx = mgr.internalSuspend();
                TestCase.assertEquals((int)5, (int)rr.entrySet().size());
                int size = 0;
                for (Object entry : rr.entrySet()) {
                    TestCase.assertNotNull(((Map.Entry)entry).getValue());
                    ++size;
                }
                TestCase.assertEquals((int)5, (int)size);
                TestCase.assertNull((Object)rr.get((Object)custId));
                mgr.resume(tx);
                mgr.commit();
                return null;
            }
        });
    }

    public void Bug44146_testIllegalIteration() {
        Host host = Host.getHost(0);
        VM accessor = host.getVM(0);
        VM datastore1 = host.getVM(1);
        VM datastore2 = host.getVM(2);
        this.initAccessorAndDataStore(accessor, datastore1, datastore2, 0);
        SerializableCallable doIllegalIteration = new SerializableCallable(){

            public Object call() throws Exception {
                Region r = RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                Set keySet = r.keySet();
                Set entrySet = r.entrySet();
                Set valueSet = (Set)r.values();
                TXManagerImpl mgr = RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager();
                mgr.begin();
                keySet.size();
                entrySet.size();
                valueSet.size();
                keySet.iterator();
                entrySet.iterator();
                valueSet.iterator();
                keySet = r.keySet();
                entrySet = r.entrySet();
                valueSet = (Set)r.values();
                mgr.commit();
                try {
                    keySet.size();
                    TestCase.fail((String)"Expected exception not thrown");
                }
                catch (IllegalTransactionStateException illegalTransactionStateException) {
                    // empty catch block
                }
                try {
                    entrySet.size();
                    TestCase.fail((String)"Expected exception not thrown");
                }
                catch (IllegalTransactionStateException illegalTransactionStateException) {
                    // empty catch block
                }
                try {
                    valueSet.size();
                    TestCase.fail((String)"Expected exception not thrown");
                }
                catch (IllegalTransactionStateException illegalTransactionStateException) {
                    // empty catch block
                }
                try {
                    keySet.iterator();
                    TestCase.fail((String)"Expected exception not thrown");
                }
                catch (IllegalTransactionStateException illegalTransactionStateException) {
                    // empty catch block
                }
                try {
                    entrySet.iterator();
                    TestCase.fail((String)"Expected exception not thrown");
                }
                catch (IllegalTransactionStateException illegalTransactionStateException) {
                    // empty catch block
                }
                try {
                    valueSet.iterator();
                    TestCase.fail((String)"Expected exception not thrown");
                }
                catch (IllegalTransactionStateException illegalTransactionStateException) {
                    // empty catch block
                }
                return null;
            }
        };
        accessor.invoke(doIllegalIteration);
        datastore1.invoke(doIllegalIteration);
    }

    public void Bug44146_testTxFunctionOnRegions() {
        this.doTestTxFunction(Executions.OnRegion);
    }

    public void Bug44146_testTxFunctionOnMembers() {
        this.doTestTxFunction(Executions.OnMember);
    }

    private void doTestTxFunction(final Executions e) {
        VM execVM2;
        VM execVM1;
        Host host = Host.getHost(0);
        VM accessor = host.getVM(0);
        VM datastore1 = host.getVM(1);
        VM datastore2 = host.getVM(2);
        this.initAccessorAndDataStore(accessor, datastore1, datastore2, 1);
        SerializableCallable registerFunction = new SerializableCallable(){

            public Object call() throws Exception {
                FunctionService.registerFunction((Function)new TXFunction());
                return null;
            }
        };
        accessor.invoke(registerFunction);
        datastore1.invoke(registerFunction);
        datastore2.invoke(registerFunction);
        final DistributedMember store1Id = (DistributedMember)datastore1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                return RemoteTransactionDUnitTest.this.getGemfireCache().getMyId();
            }
        });
        final DistributedMember store2Id = (DistributedMember)datastore2.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                return RemoteTransactionDUnitTest.this.getGemfireCache().getMyId();
            }
        });
        final TXId txId = (TXId)accessor.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region custRegion = RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                Region orderRegion = RemoteTransactionDUnitTest.this.getCache().getRegion("orderRegion");
                Region refRegion = RemoteTransactionDUnitTest.this.getCache().getRegion("distrReference");
                TXManagerImpl mgr = RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager();
                TXStateInterface tx = null;
                HashSet<Region> regions = new HashSet<Region>();
                regions.add(custRegion);
                regions.add(orderRegion);
                regions.add(refRegion);
                ArrayList<Boolean> expectedList = new ArrayList<Boolean>();
                mgr.begin();
                switch (e) {
                    case OnRegion: {
                        expectedList.add(Boolean.TRUE);
                        expectedList.add(Boolean.TRUE);
                        TestCase.assertEquals(expectedList, (Object)FunctionService.onRegion((Region)custRegion).withArgs((Object)new Object[]{store1Id, store2Id}).execute("TXFunction").getResult());
                        TestCase.assertEquals((Object)RemoteTransactionDUnitTest.this.expectedCustomer, (Object)custRegion.get((Object)RemoteTransactionDUnitTest.this.expectedCustId));
                        TestCase.assertEquals((Object)RemoteTransactionDUnitTest.this.expectedOrder, (Object)orderRegion.get((Object)RemoteTransactionDUnitTest.this.expectedOrderId));
                        TestCase.assertNull((Object)refRegion.get((Object)RemoteTransactionDUnitTest.this.expectedCustId));
                        tx = mgr.internalSuspend();
                        TestCase.assertNull((Object)custRegion.get((Object)RemoteTransactionDUnitTest.this.expectedCustId));
                        TestCase.assertNull((Object)orderRegion.get((Object)RemoteTransactionDUnitTest.this.expectedOrderId));
                        TestCase.assertNull((Object)refRegion.get((Object)RemoteTransactionDUnitTest.this.expectedCustId));
                        mgr.resume(tx);
                        expectedList.add(Boolean.TRUE);
                        break;
                    }
                    case OnMember: {
                        expectedList.add(Boolean.TRUE);
                        expectedList.add(Boolean.TRUE);
                        expectedList.add(Boolean.TRUE);
                        TestCase.assertEquals(expectedList, (Object)FunctionService.onMembers((DistributedSystem)DistributedTestCase.system).withArgs((Object)new Object[]{store1Id, store2Id}).execute("TXFunction").getResult());
                        tx = mgr.internalSuspend();
                        TestCase.assertNull((Object)custRegion.get((Object)RemoteTransactionDUnitTest.this.expectedCustId));
                        TestCase.assertNull((Object)orderRegion.get((Object)RemoteTransactionDUnitTest.this.expectedOrderId));
                        TestCase.assertNull((Object)refRegion.get((Object)RemoteTransactionDUnitTest.this.expectedCustId));
                        mgr.resume(tx);
                        TestCase.assertEquals((Object)RemoteTransactionDUnitTest.this.expectedCustomer, (Object)custRegion.get((Object)RemoteTransactionDUnitTest.this.expectedCustId));
                        TestCase.assertEquals((Object)RemoteTransactionDUnitTest.this.expectedOrder, (Object)orderRegion.get((Object)RemoteTransactionDUnitTest.this.expectedOrderId));
                        TestCase.assertEquals((Object)RemoteTransactionDUnitTest.this.expectedCustomer, (Object)refRegion.get((Object)RemoteTransactionDUnitTest.this.expectedCustId));
                        refRegion.destroy((Object)RemoteTransactionDUnitTest.this.expectedCustId);
                    }
                }
                custRegion.destroy((Object)RemoteTransactionDUnitTest.this.expectedCustId);
                orderRegion.destroy((Object)RemoteTransactionDUnitTest.this.expectedOrderId);
                GemFireCacheImpl.getInstance().getLogger().warning("TX SUSPENDO:" + tx);
                TestCase.assertNull((Object)custRegion.get((Object)RemoteTransactionDUnitTest.this.expectedCustId));
                TestCase.assertNull((Object)orderRegion.get((Object)RemoteTransactionDUnitTest.this.expectedOrderId));
                TestCase.assertNull((Object)refRegion.get((Object)RemoteTransactionDUnitTest.this.expectedCustId));
                TestCase.assertEquals(expectedList, (Object)InternalFunctionService.onRegions(regions).withArgs((Object)new Object[]{store1Id, store2Id}).execute("TXFunction").getResult());
                TestCase.assertEquals((Object)RemoteTransactionDUnitTest.this.expectedCustomer, (Object)custRegion.get((Object)RemoteTransactionDUnitTest.this.expectedCustId));
                TestCase.assertEquals((Object)RemoteTransactionDUnitTest.this.expectedOrder, (Object)orderRegion.get((Object)RemoteTransactionDUnitTest.this.expectedOrderId));
                TestCase.assertEquals((Object)RemoteTransactionDUnitTest.this.expectedCustomer, (Object)refRegion.get((Object)RemoteTransactionDUnitTest.this.expectedCustId));
                tx = mgr.internalSuspend();
                TestCase.assertNull((Object)custRegion.get((Object)RemoteTransactionDUnitTest.this.expectedCustId));
                TestCase.assertNull((Object)orderRegion.get((Object)RemoteTransactionDUnitTest.this.expectedOrderId));
                TestCase.assertNull((Object)refRegion.get((Object)RemoteTransactionDUnitTest.this.expectedCustId));
                mgr.resume(tx);
                return tx.getTransactionId();
            }
        });
        Integer txOnDatastore1 = (Integer)datastore1.invoke(this.getNumberOfTXInProgress);
        Integer txOnDatastore2 = (Integer)datastore2.invoke(this.getNumberOfTXInProgress);
        RemoteTransactionDUnitTest.assertEquals((int)2, (int)(txOnDatastore1 + txOnDatastore2));
        datastore1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region custRegion = RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                Region orderRegion = RemoteTransactionDUnitTest.this.getCache().getRegion("orderRegion");
                Region refRegion = RemoteTransactionDUnitTest.this.getCache().getRegion("distrReference");
                TXManagerImpl mgr = RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager();
                TXStateProxy tx = mgr.getHostedTXState(txId);
                TXStateInterface txOrig = mgr.getTXState();
                mgr.setTXState((TXStateInterface)tx);
                TestCase.assertEquals((Object)RemoteTransactionDUnitTest.this.expectedCustomer, (Object)custRegion.get((Object)RemoteTransactionDUnitTest.this.expectedCustId));
                TestCase.assertEquals((Object)RemoteTransactionDUnitTest.this.expectedOrder, (Object)orderRegion.get((Object)RemoteTransactionDUnitTest.this.expectedOrderId));
                TestCase.assertEquals((Object)RemoteTransactionDUnitTest.this.expectedCustomer, (Object)refRegion.get((Object)RemoteTransactionDUnitTest.this.expectedCustId));
                mgr.internalSuspend();
                TestCase.assertNull((Object)custRegion.get((Object)RemoteTransactionDUnitTest.this.expectedCustId));
                TestCase.assertNull((Object)orderRegion.get((Object)RemoteTransactionDUnitTest.this.expectedOrderId));
                TestCase.assertNull((Object)refRegion.get((Object)RemoteTransactionDUnitTest.this.expectedCustId));
                mgr.setTXState(txOrig);
                return null;
            }
        });
        txOnDatastore1 = (Integer)datastore1.invoke(this.getNumberOfTXInProgress);
        txOnDatastore2 = (Integer)datastore2.invoke(this.getNumberOfTXInProgress);
        RemoteTransactionDUnitTest.assertEquals((int)2, (int)(txOnDatastore1 + txOnDatastore2));
        accessor.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                TXManagerImpl mgr = RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager();
                mgr.commit();
                Region custRegion = RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                Region orderRegion = RemoteTransactionDUnitTest.this.getCache().getRegion("orderRegion");
                Region refRegion = RemoteTransactionDUnitTest.this.getCache().getRegion("distrReference");
                TestCase.assertEquals((Object)RemoteTransactionDUnitTest.this.expectedCustomer, (Object)custRegion.get((Object)RemoteTransactionDUnitTest.this.expectedCustId));
                TestCase.assertEquals((Object)RemoteTransactionDUnitTest.this.expectedOrder, (Object)orderRegion.get((Object)RemoteTransactionDUnitTest.this.expectedOrderId));
                TestCase.assertEquals((Object)RemoteTransactionDUnitTest.this.expectedCustomer, (Object)refRegion.get((Object)RemoteTransactionDUnitTest.this.expectedCustId));
                refRegion.put((Object)RemoteTransactionDUnitTest.this.expectedCustId, (Object)RemoteTransactionDUnitTest.this.expectedCustomerUpdate);
                TestCase.assertEquals((Object)RemoteTransactionDUnitTest.this.expectedCustomerUpdate, (Object)refRegion.get((Object)RemoteTransactionDUnitTest.this.expectedCustId));
                return null;
            }
        });
        accessor.invoke(this.verifyNoTxState);
        datastore1.invoke(this.verifyNoTxState);
        datastore2.invoke(this.verifyNoTxState);
        datastore1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region custRegion = RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                Region orderRegion = RemoteTransactionDUnitTest.this.getCache().getRegion("orderRegion");
                Region refRegion = RemoteTransactionDUnitTest.this.getCache().getRegion("distrReference");
                TestCase.assertEquals((Object)RemoteTransactionDUnitTest.this.expectedCustomer, (Object)custRegion.get((Object)RemoteTransactionDUnitTest.this.expectedCustId));
                TestCase.assertEquals((Object)RemoteTransactionDUnitTest.this.expectedOrder, (Object)orderRegion.get((Object)RemoteTransactionDUnitTest.this.expectedOrderId));
                TestCase.assertEquals((Object)RemoteTransactionDUnitTest.this.expectedCustomerUpdate, (Object)refRegion.get((Object)RemoteTransactionDUnitTest.this.expectedCustId));
                custRegion.put((Object)RemoteTransactionDUnitTest.this.expectedCustId, (Object)RemoteTransactionDUnitTest.this.expectedCustomerUpdate);
                TestCase.assertEquals((Object)RemoteTransactionDUnitTest.this.expectedCustomerUpdate, (Object)custRegion.get((Object)RemoteTransactionDUnitTest.this.expectedCustId));
                return null;
            }
        });
        final TXId txId1 = (TXId)accessor.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                TXManagerImpl mgr = RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager();
                mgr.begin();
                PartitionedRegion custRegion = (PartitionedRegion)RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                HashSet<CustId> filter = new HashSet<CustId>();
                filter.add(RemoteTransactionDUnitTest.this.expectedCustId);
                switch (e) {
                    case OnRegion: {
                        FunctionService.onRegion((Region)custRegion).withFilter(filter).execute("TXFunction").getResult();
                        break;
                    }
                    case OnMember: {
                        DistributedMember owner = custRegion.getOwnerForKey(custRegion.getKeyInfo((Object)RemoteTransactionDUnitTest.this.expectedCustId));
                        FunctionService.onMember((DistributedSystem)DistributedTestCase.system, (DistributedMember)owner).execute("TXFunction").getResult();
                    }
                }
                return mgr.getTransactionId();
            }
        });
        DistributedTestCase.ExpectedException expected = RemoteTransactionDUnitTest.addExpectedException(ConflictException.class.getName(), datastore1);
        datastore1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                TXManagerImpl mgr = RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager();
                mgr.begin();
                PartitionedRegion custRegion = (PartitionedRegion)RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                HashSet<CustId> filter = new HashSet<CustId>();
                filter.add(RemoteTransactionDUnitTest.this.expectedCustId);
                try {
                    switch (e) {
                        case OnRegion: {
                            FunctionService.onRegion((Region)custRegion).withFilter(filter).execute("TXFunction").getResult();
                            break;
                        }
                        case OnMember: {
                            DistributedMember owner = custRegion.getOwnerForKey(custRegion.getKeyInfo((Object)RemoteTransactionDUnitTest.this.expectedCustId));
                            FunctionService.onMember((DistributedSystem)DistributedTestCase.system, (DistributedMember)owner).execute("TXFunction").getResult();
                        }
                    }
                    TestCase.fail((String)"did not get expected exception");
                }
                catch (FunctionException fe) {
                    if (!(fe.getCause() instanceof ConflictException)) {
                        throw fe;
                    }
                    mgr.rollback();
                }
                mgr.begin();
                try {
                    switch (e) {
                        case OnRegion: {
                            FunctionService.onRegion((Region)custRegion).execute("TXFunction").getResult();
                            break;
                        }
                        case OnMember: {
                            FunctionService.onMembers((DistributedSystem)DistributedTestCase.system).execute("TXFunction").getResult();
                        }
                    }
                    TestCase.fail((String)"did not get expected exception");
                }
                catch (FunctionException fe) {
                    if (!(fe.getCause() instanceof ConflictException)) {
                        throw fe;
                    }
                    mgr.rollback();
                }
                mgr.begin();
                try {
                    custRegion.put((Object)RemoteTransactionDUnitTest.this.expectedCustId, (Object)new Customer("Cust6", "updated6"));
                    TestCase.fail((String)"did not get expected exception");
                }
                catch (ConflictException ce) {
                    mgr.rollback();
                }
                TestCase.assertEquals((Object)RemoteTransactionDUnitTest.this.expectedCustomerUpdate, (Object)custRegion.get((Object)RemoteTransactionDUnitTest.this.expectedCustId));
                TXStateProxy tx = mgr.getHostedTXState(txId1);
                TXStateInterface txOrig = mgr.getTXState();
                mgr.setTXState((TXStateInterface)tx);
                TestCase.assertEquals((Object)RemoteTransactionDUnitTest.this.expectedCustomer, (Object)custRegion.get((Object)RemoteTransactionDUnitTest.this.expectedCustId));
                mgr.setTXState(txOrig);
                return null;
            }
        });
        expected.remove();
        datastore2.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                TXManagerImpl mgr = RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager();
                Region custRegion = RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                TestCase.assertEquals((Object)RemoteTransactionDUnitTest.this.expectedCustomerUpdate, (Object)custRegion.get((Object)RemoteTransactionDUnitTest.this.expectedCustId));
                TXStateProxy tx = mgr.getHostedTXState(txId1);
                TXStateInterface txOrig = mgr.getTXState();
                mgr.setTXState((TXStateInterface)tx);
                TestCase.assertEquals((Object)RemoteTransactionDUnitTest.this.expectedCustomer, (Object)custRegion.get((Object)RemoteTransactionDUnitTest.this.expectedCustId));
                mgr.setTXState(txOrig);
                return null;
            }
        });
        accessor.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                TXManagerImpl mgr = RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager();
                Region custRegion = RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                TestCase.assertEquals((Object)RemoteTransactionDUnitTest.this.expectedCustomer, (Object)custRegion.get((Object)RemoteTransactionDUnitTest.this.expectedCustId));
                TXStateInterface tx = mgr.internalSuspend();
                TestCase.assertEquals((Object)RemoteTransactionDUnitTest.this.expectedCustomerUpdate, (Object)custRegion.get((Object)RemoteTransactionDUnitTest.this.expectedCustId));
                mgr.resume(tx);
                mgr.commit();
                TestCase.assertEquals((Object)RemoteTransactionDUnitTest.this.expectedCustomer, (Object)custRegion.get((Object)RemoteTransactionDUnitTest.this.expectedCustId));
                custRegion.destroy((Object)RemoteTransactionDUnitTest.this.expectedCustId);
                TestCase.assertNull((Object)custRegion.get((Object)RemoteTransactionDUnitTest.this.expectedCustId));
                return null;
            }
        });
        accessor.invoke(this.waitForPendingCommit);
        accessor.invoke(this.verifyNoTxState);
        datastore1.invoke(this.verifyNoTxState);
        datastore2.invoke(this.verifyNoTxState);
        switch (PartitionedRegion.rand.nextInt(2)) {
            case 0: {
                execVM1 = accessor;
                execVM2 = datastore1;
                break;
            }
            case 1: {
                execVM1 = datastore1;
                execVM2 = datastore2;
                break;
            }
            default: {
                execVM1 = datastore2;
                execVM2 = accessor;
            }
        }
        final TXId txId2 = (TXId)execVM1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                PartitionedRegion custRegion = (PartitionedRegion)RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                TXManagerImpl mgr = RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager();
                mgr.begin();
                HashSet<CustId> filter = new HashSet<CustId>();
                filter.add(RemoteTransactionDUnitTest.this.expectedCustId);
                switch (e) {
                    case OnRegion: {
                        FunctionService.onRegion((Region)custRegion).withFilter(filter).execute("TXFunction").getResult();
                        break;
                    }
                    case OnMember: {
                        DistributedMember owner = custRegion.getOwnerForKey(custRegion.getKeyInfo((Object)RemoteTransactionDUnitTest.this.expectedCustId));
                        FunctionService.onMember((DistributedSystem)DistributedTestCase.system, (DistributedMember)owner).execute("TXFunction").getResult();
                    }
                }
                TXStateInterface tx = mgr.internalSuspend();
                TestCase.assertNull((Object)custRegion.get((Object)RemoteTransactionDUnitTest.this.expectedCustId));
                mgr.resume(tx);
                return tx.getTransactionId();
            }
        });
        txOnDatastore1 = (Integer)datastore1.invoke(this.getNumberOfTXInProgress);
        txOnDatastore2 = (Integer)datastore2.invoke(this.getNumberOfTXInProgress);
        RemoteTransactionDUnitTest.assertEquals((int)2, (int)(txOnDatastore1 + txOnDatastore2));
        execVM2.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region custRegion = RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                TXManagerImpl mgr = RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager();
                TXStateProxy tx = mgr.getHostedTXState(txId2);
                TXStateInterface txOrig = mgr.getTXState();
                mgr.setTXState((TXStateInterface)tx);
                tx = mgr.internalSuspend();
                TestCase.assertNull((Object)custRegion.get((Object)RemoteTransactionDUnitTest.this.expectedCustId));
                mgr.resume((TXStateInterface)tx);
                TestCase.assertEquals((Object)RemoteTransactionDUnitTest.this.expectedCustomer, (Object)custRegion.get((Object)RemoteTransactionDUnitTest.this.expectedCustId));
                mgr.setTXState(txOrig);
                return null;
            }
        });
        execVM1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                TXManagerImpl mgr = RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager();
                mgr.commit();
                TXManagerImpl.waitForPendingCommitForTest();
                return null;
            }
        });
        execVM2.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region custRegion = RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                TestCase.assertEquals((Object)RemoteTransactionDUnitTest.this.expectedCustomer, (Object)custRegion.get((Object)RemoteTransactionDUnitTest.this.expectedCustId));
                custRegion.put((Object)RemoteTransactionDUnitTest.this.expectedCustId, (Object)RemoteTransactionDUnitTest.this.expectedCustomerUpdate);
                TestCase.assertEquals((Object)RemoteTransactionDUnitTest.this.expectedCustomerUpdate, (Object)custRegion.get((Object)RemoteTransactionDUnitTest.this.expectedCustId));
                return null;
            }
        });
        execVM1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region custRegion = RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                TestCase.assertEquals((Object)RemoteTransactionDUnitTest.this.expectedCustomerUpdate, (Object)custRegion.get((Object)RemoteTransactionDUnitTest.this.expectedCustId));
                return null;
            }
        });
    }

    public void DISABLED_TILL_NEW_TX_IMPL_COMPLETE_testNestedTxFunction() {
        Host host = Host.getHost(0);
        VM accessor = host.getVM(0);
        VM datastore1 = host.getVM(1);
        VM datastore2 = host.getVM(2);
        this.initAccessorAndDataStore(accessor, datastore1, datastore2, 0);
        accessor.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                TXManagerImpl mgr = RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager();
                PartitionedRegion pr = (PartitionedRegion)RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                mgr.begin();
                HashSet<CustId> filter = new HashSet<CustId>();
                filter.add(RemoteTransactionDUnitTest.this.expectedCustId);
                class NestedTxFunction
                extends FunctionAdapter {
                    static final String id = "NestedTXFunction";

                    NestedTxFunction() {
                    }

                    public void execute(FunctionContext context) {
                        Region r = null;
                        r = context instanceof RegionFunctionContext ? PartitionRegionHelper.getLocalDataForContext((RegionFunctionContext)((RegionFunctionContext)context)) : RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                        TestCase.assertNotNull((Object)RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager().getTXState());
                        PartitionedRegion pr = (PartitionedRegion)RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                        HashSet<CustId> filter = new HashSet<CustId>();
                        filter.add(RemoteTransactionDUnitTest.this.expectedCustId);
                        DistributedTestCase.getLogWriter().info("SWAP:inside NestedTxFunc calling func2:");
                        r.put((Object)RemoteTransactionDUnitTest.this.expectedCustId, (Object)RemoteTransactionDUnitTest.this.expectedCustomer);
                        class NestedTxFunction2
                        extends FunctionAdapter {
                            static final String id = "NestedTXFunction2";

                            NestedTxFunction2() {
                            }

                            public void execute(FunctionContext context) {
                                TXManagerImpl mgr = RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager();
                                TestCase.assertNotNull((Object)mgr.getTXState());
                                try {
                                    mgr.commit();
                                    TestCase.fail((String)"expected exception not thrown");
                                }
                                catch (UnsupportedOperationInTransactionException unsupportedOperationInTransactionException) {
                                    // empty catch block
                                }
                                context.getResultSender().lastResult((Object)Boolean.TRUE);
                            }

                            public String getId() {
                                return id;
                            }
                        }
                        FunctionService.onRegion((Region)pr).withFilter(filter).execute((Function)new NestedTxFunction2()).getResult();
                        TestCase.assertNotNull((Object)RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager().getTXState());
                        context.getResultSender().lastResult((Object)Boolean.TRUE);
                    }

                    public boolean optimizeForWrite() {
                        return true;
                    }

                    public String getId() {
                        return id;
                    }
                }
                FunctionService.onRegion((Region)pr).withFilter(filter).execute((Function)new NestedTxFunction()).getResult();
                TestCase.assertNotNull((Object)RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager().getTXState());
                mgr.commit();
                TestCase.assertEquals((Object)RemoteTransactionDUnitTest.this.expectedCustomer, (Object)pr.get((Object)RemoteTransactionDUnitTest.this.expectedCustId));
                return null;
            }
        });
    }

    public void Bug44146_testDRFunctionExecution() {
        Host host = Host.getHost(0);
        VM accessor = host.getVM(0);
        VM datastore1 = host.getVM(1);
        VM datastore2 = host.getVM(2);
        class CreateDR
        extends SerializableCallable {
            private final boolean isAccessor;

            public CreateDR(boolean isAccessor) {
                this.isAccessor = isAccessor;
            }

            public Object call() throws Exception {
                AttributesFactory af = new AttributesFactory();
                af.setDataPolicy(this.isAccessor ? DataPolicy.EMPTY : DataPolicy.REPLICATE);
                af.setScope(Scope.DISTRIBUTED_ACK);
                af.setConcurrencyChecksEnabled(RemoteTransactionDUnitTest.this.getConcurrencyChecksEnabled());
                RemoteTransactionDUnitTest.this.getCache().createRegion("custRegion", af.create());
                if (this.isAccessor) {
                    Region custRegion = RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                    for (int i = 0; i < 5; ++i) {
                        CustId custId = new CustId(i);
                        Customer customer = new Customer("customer" + i, "address" + i);
                        custRegion.put((Object)custId, (Object)customer);
                    }
                }
                return null;
            }
        }
        datastore1.invoke(new CreateDR(false));
        datastore2.invoke(new CreateDR(false));
        accessor.invoke(new CreateDR(true));
        SerializableCallable registerFunction = new SerializableCallable(){

            public Object call() throws Exception {
                FunctionService.registerFunction((Function)new TXFunction());
                return null;
            }
        };
        accessor.invoke(registerFunction);
        datastore1.invoke(registerFunction);
        datastore2.invoke(registerFunction);
        accessor.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region custRegion = RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                TXManagerImpl mgr = RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager();
                mgr.begin();
                FunctionService.onRegion((Region)custRegion).execute("TXFunction").getResult();
                TestCase.assertNotNull((Object)mgr.getTXState());
                TXStateInterface tx = mgr.internalSuspend();
                TestCase.assertNull((Object)mgr.getTXState());
                RemoteTransactionDUnitTest.this.getGemfireCache().getLogger().fine("SWAP:callingget");
                TestCase.assertNull((String)("expected null but was:" + custRegion.get((Object)RemoteTransactionDUnitTest.this.expectedCustId)), (Object)custRegion.get((Object)RemoteTransactionDUnitTest.this.expectedCustId));
                mgr.resume(tx);
                mgr.commit();
                TestCase.assertEquals((Object)RemoteTransactionDUnitTest.this.expectedCustomer, (Object)custRegion.get((Object)RemoteTransactionDUnitTest.this.expectedCustId));
                return null;
            }
        });
        datastore1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                final Region custRegion = RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                TXManagerImpl mgr = RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager();
                mgr.begin();
                FunctionService.onRegion((Region)custRegion).execute((Function)new FunctionAdapter(){

                    public String getId() {
                        return "LocalDS";
                    }

                    public void execute(FunctionContext context) {
                        TestCase.assertNotNull((Object)RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager().getTXState());
                        custRegion.destroy((Object)RemoteTransactionDUnitTest.this.expectedCustId);
                        context.getResultSender().lastResult((Object)Boolean.TRUE);
                    }
                }).getResult();
                TXStateInterface tx = mgr.internalSuspend();
                TestCase.assertEquals((Object)custRegion.get((Object)RemoteTransactionDUnitTest.this.expectedCustId), (Object)RemoteTransactionDUnitTest.this.expectedCustomer);
                mgr.resume(tx);
                mgr.commit();
                TestCase.assertNull((Object)custRegion.get((Object)RemoteTransactionDUnitTest.this.expectedCustId));
                return null;
            }
        });
    }

    public void DISABLED_TILL_NEW_TX_IMPL_COMPLETE_testTxFunctionWithOtherOps() {
        Host host = Host.getHost(0);
        VM accessor = host.getVM(0);
        VM datastore1 = host.getVM(1);
        VM datastore2 = host.getVM(2);
        this.initAccessorAndDataStore(accessor, datastore1, datastore2, 0);
        SerializableCallable registerFunction = new SerializableCallable(){

            public Object call() throws Exception {
                FunctionService.registerFunction((Function)new TXFunction());
                return null;
            }
        };
        accessor.invoke(registerFunction);
        datastore1.invoke(registerFunction);
        datastore2.invoke(registerFunction);
        accessor.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region custRegion = RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                TXManagerImpl mgr = RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager();
                mgr.begin();
                try {
                    FunctionService.onRegion((Region)custRegion).execute("TXFunction").getResult();
                    TestCase.fail((String)"Expected exception not thrown");
                }
                catch (TransactionException transactionException) {
                    // empty catch block
                }
                HashSet<CustId> filter = new HashSet<CustId>();
                filter.add(RemoteTransactionDUnitTest.this.expectedCustId);
                FunctionService.onRegion((Region)custRegion).withFilter(filter).execute("TXFunction").getResult();
                TestCase.assertEquals((Object)RemoteTransactionDUnitTest.this.expectedCustomer, (Object)custRegion.get((Object)RemoteTransactionDUnitTest.this.expectedCustId));
                TXStateInterface tx = mgr.internalSuspend();
                TestCase.assertNull((Object)custRegion.get((Object)RemoteTransactionDUnitTest.this.expectedCustId));
                mgr.resume(tx);
                return null;
            }
        });
        Integer txOnDatastore1 = (Integer)datastore1.invoke(this.getNumberOfTXInProgress);
        Integer txOnDatastore2 = (Integer)datastore2.invoke(this.getNumberOfTXInProgress);
        RemoteTransactionDUnitTest.assertEquals((int)2, (int)(txOnDatastore1 + txOnDatastore2));
        accessor.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region custRegion = RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                TXManagerImpl mgr = RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager();
                mgr.commit();
                TestCase.assertEquals((Object)RemoteTransactionDUnitTest.this.expectedCustomer, (Object)custRegion.get((Object)RemoteTransactionDUnitTest.this.expectedCustId));
                custRegion.destroy((Object)RemoteTransactionDUnitTest.this.expectedCustId);
                return null;
            }
        });
        SerializableCallable getMember = new SerializableCallable(){

            public Object call() throws Exception {
                return RemoteTransactionDUnitTest.this.getGemfireCache().getMyId();
            }
        };
        final InternalDistributedMember ds1 = (InternalDistributedMember)datastore1.invoke(getMember);
        final InternalDistributedMember ds2 = (InternalDistributedMember)datastore2.invoke(getMember);
        accessor.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                PartitionedRegion pr = (PartitionedRegion)RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                DistributedMember owner = pr.getOwnerForKey(pr.getKeyInfo((Object)RemoteTransactionDUnitTest.this.expectedCustId));
                CustId keyOnOwner = null;
                keyOnOwner = RemoteTransactionDUnitTest.this.getKeyOnMember(owner, pr);
                TXManagerImpl mgr = RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager();
                mgr.begin();
                pr.get((Object)keyOnOwner);
                HashSet<InternalDistributedMember> members = new HashSet<InternalDistributedMember>();
                members.add(ds1);
                members.add(ds2);
                try {
                    FunctionService.onMembers((DistributedSystem)DistributedTestCase.system, members).execute("TXFunction").getResult();
                    TestCase.fail((String)"expected exception not thrown");
                }
                catch (TransactionException transactionException) {
                    // empty catch block
                }
                FunctionService.onMember((DistributedSystem)DistributedTestCase.system, (DistributedMember)owner).execute("TXFunction").getResult();
                TestCase.assertEquals((Object)RemoteTransactionDUnitTest.this.expectedCustomer, (Object)pr.get((Object)RemoteTransactionDUnitTest.this.expectedCustId));
                TXStateInterface tx = mgr.internalSuspend();
                TestCase.assertNull((Object)pr.get((Object)RemoteTransactionDUnitTest.this.expectedCustId));
                mgr.resume(tx);
                return null;
            }
        });
        Integer txOnDatastore1_1 = (Integer)datastore1.invoke(this.getNumberOfTXInProgress);
        Integer txOnDatastore2_1 = (Integer)datastore2.invoke(this.getNumberOfTXInProgress);
        RemoteTransactionDUnitTest.assertEquals((int)2, (int)(txOnDatastore1_1 + txOnDatastore2_1));
        accessor.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region custRegion = RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                TXManagerImpl mgr = RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager();
                mgr.commit();
                TestCase.assertEquals((Object)RemoteTransactionDUnitTest.this.expectedCustomer, (Object)custRegion.get((Object)RemoteTransactionDUnitTest.this.expectedCustId));
                custRegion.destroy((Object)RemoteTransactionDUnitTest.this.expectedCustId);
                return null;
            }
        });
        DistributedMember owner = (DistributedMember)accessor.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                PartitionedRegion pr = (PartitionedRegion)RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                return pr.getOwnerForKey(pr.getKeyInfo((Object)RemoteTransactionDUnitTest.this.expectedCustId));
            }
        });
        SerializableCallable testFnOnDs = new SerializableCallable(){

            public Object call() throws Exception {
                TXManagerImpl mgr = RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager();
                PartitionedRegion pr = (PartitionedRegion)RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                CustId keyOnDs = RemoteTransactionDUnitTest.this.getKeyOnMember((DistributedMember)pr.getMyId(), pr);
                mgr.begin();
                pr.get((Object)keyOnDs);
                HashSet<CustId> filter = new HashSet<CustId>();
                filter.add(keyOnDs);
                FunctionService.onRegion((Region)pr).withFilter(filter).execute("TXFunction").getResult();
                TestCase.assertEquals((Object)RemoteTransactionDUnitTest.this.expectedCustomer, (Object)pr.get((Object)RemoteTransactionDUnitTest.this.expectedCustId));
                TXStateInterface tx = mgr.internalSuspend();
                TestCase.assertNull((Object)pr.get((Object)RemoteTransactionDUnitTest.this.expectedCustId));
                mgr.resume(tx);
                return null;
            }
        };
        SerializableCallable closeTx = new SerializableCallable(){

            public Object call() throws Exception {
                Region custRegion = RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                TXManagerImpl mgr = RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager();
                mgr.commit();
                TestCase.assertEquals((Object)RemoteTransactionDUnitTest.this.expectedCustomer, (Object)custRegion.get((Object)RemoteTransactionDUnitTest.this.expectedCustId));
                custRegion.destroy((Object)RemoteTransactionDUnitTest.this.expectedCustId);
                return null;
            }
        };
        if (owner.equals(ds1)) {
            datastore1.invoke(testFnOnDs);
            Integer txOnDatastore1_2 = (Integer)datastore1.invoke(this.getNumberOfTXInProgress);
            Integer txOnDatastore2_2 = (Integer)datastore2.invoke(this.getNumberOfTXInProgress);
            RemoteTransactionDUnitTest.assertEquals((int)0, (int)(txOnDatastore1_2 + txOnDatastore2_2));
            datastore1.invoke(closeTx);
        } else {
            datastore2.invoke(testFnOnDs);
            Integer txOnDatastore1_2 = (Integer)datastore1.invoke(this.getNumberOfTXInProgress);
            Integer txOnDatastore2_2 = (Integer)datastore2.invoke(this.getNumberOfTXInProgress);
            RemoteTransactionDUnitTest.assertEquals((int)0, (int)(txOnDatastore1_2 + txOnDatastore2_2));
            datastore2.invoke(closeTx);
        }
        accessor.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                TXManagerImpl mgr = RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager();
                PartitionedRegion pr = (PartitionedRegion)RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                CustId keyOnDs1 = RemoteTransactionDUnitTest.this.getKeyOnMember((DistributedMember)ds1, pr);
                CustId keyOnDs2 = RemoteTransactionDUnitTest.this.getKeyOnMember((DistributedMember)ds2, pr);
                mgr.begin();
                pr.get((Object)keyOnDs1);
                HashSet<CustId> filter = new HashSet<CustId>();
                filter.add(keyOnDs2);
                try {
                    FunctionService.onRegion((Region)pr).withFilter(filter).execute("TXFunction").getResult();
                    TestCase.fail((String)"expected Exception not thrown");
                }
                catch (TransactionDataRebalancedException transactionDataRebalancedException) {
                    // empty catch block
                }
                FunctionService.onMember((DistributedSystem)DistributedTestCase.system, (DistributedMember)ds2).execute("TXFunction").getResult();
                mgr.commit();
                return null;
            }
        });
    }

    CustId getKeyOnMember(DistributedMember owner, PartitionedRegion pr) {
        CustId retVal = null;
        for (int i = 0; i < 5; ++i) {
            CustId custId = new CustId(i);
            DistributedMember member = pr.getOwnerForKey(pr.getKeyInfo((Object)custId));
            if (!member.equals(owner)) continue;
            retVal = custId;
            break;
        }
        return retVal;
    }

    protected Set<Customer> getCustomerSet(int size) {
        HashSet<Customer> expectedSet = new HashSet<Customer>();
        for (int i = 0; i < size; ++i) {
            expectedSet.add(new Customer("customer" + i, "address" + i));
        }
        return expectedSet;
    }

    Set<CustId> getCustIdSet(int size) {
        HashSet<CustId> expectedSet = new HashSet<CustId>();
        for (int i = 0; i < size; ++i) {
            expectedSet.add(new CustId(i));
        }
        return expectedSet;
    }

    public void Bug44146_testRemoteJTACommit() {
        this.doRemoteJTA(true);
    }

    public void Bug44146_testRemoteJTARollback() {
        this.doRemoteJTA(false);
    }

    private void doRemoteJTA(final boolean isCommit) {
        Host host = Host.getHost(0);
        VM acc = host.getVM(0);
        VM datastore = host.getVM(1);
        this.initAccessorAndDataStore(acc, datastore, 0);
        VM accessor = this.getVMForTransactions(acc, datastore);
        datastore.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager().addListener((TransactionListener)new TestTxListener(false));
                return null;
            }
        });
        final CustId expectedCustId = new CustId(6);
        final Customer expectedCustomer = new Customer("customer6", "address6");
        accessor.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager().addListener((TransactionListener)new TestTxListener(true));
                Region custRegion = RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                Context ctx = RemoteTransactionDUnitTest.this.getCache().getJNDIContext();
                UserTransaction tx = (UserTransaction)ctx.lookup("java:/UserTransaction");
                TestCase.assertEquals((int)6, (int)tx.getStatus());
                tx.begin();
                TestCase.assertEquals((int)0, (int)tx.getStatus());
                custRegion.put((Object)expectedCustId, (Object)expectedCustomer);
                TestCase.assertEquals((Object)expectedCustomer, (Object)custRegion.get((Object)expectedCustId));
                return null;
            }
        });
        datastore.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region custRegion = RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                TestCase.assertNull((Object)custRegion.get((Object)expectedCustId));
                return null;
            }
        });
        accessor.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region custRegion = RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                Context ctx = RemoteTransactionDUnitTest.this.getCache().getJNDIContext();
                UserTransaction tx = (UserTransaction)ctx.lookup("java:/UserTransaction");
                if (isCommit) {
                    tx.commit();
                    TestCase.assertEquals((Object)expectedCustomer, (Object)custRegion.get((Object)expectedCustId));
                } else {
                    tx.rollback();
                    TestCase.assertNull((Object)custRegion.get((Object)expectedCustId));
                }
                return null;
            }
        });
        datastore.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                TestTxListener l = (TestTxListener)RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager().getListener();
                TestCase.assertTrue((boolean)l.isListenerInvoked());
                return null;
            }
        });
    }

    public void Bug44146_testOriginRemoteIsTrueForRemoteReplicatedRegions() {
        Host host = Host.getHost(0);
        VM accessor = host.getVM(0);
        VM datastore = host.getVM(1);
        this.initAccessorAndDataStore(accessor, datastore, 0);
        datastore.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region refRegion = RemoteTransactionDUnitTest.this.getCache().getRegion("distrReference");
                class OriginRemoteRRWriter
                extends CacheWriterAdapter {
                    int fireC = 0;
                    int fireD = 0;
                    int fireU = 0;

                    OriginRemoteRRWriter() {
                    }

                    public void beforeCreate(EntryEvent event) throws CacheWriterException {
                        if (!event.isOriginRemote()) {
                            throw new CacheWriterException("SUP?? This CREATE is supposed to be isOriginRemote");
                        }
                        ++this.fireC;
                    }

                    public void beforeDestroy(EntryEvent event) throws CacheWriterException {
                        RemoteTransactionDUnitTest.this.getGemfireCache().getLoggerI18n().fine("SWAP:writer:createEvent:" + event);
                        if (!event.isOriginRemote()) {
                            throw new CacheWriterException("SUP?? This DESTROY is supposed to be isOriginRemote");
                        }
                        ++this.fireD;
                    }

                    public void beforeUpdate(EntryEvent event) throws CacheWriterException {
                        if (!event.isOriginRemote()) {
                            throw new CacheWriterException("SUP?? This UPDATE is supposed to be isOriginRemote");
                        }
                        ++this.fireU;
                    }
                }
                refRegion.getAttributesMutator().setCacheWriter((CacheWriter)new OriginRemoteRRWriter());
                return null;
            }
        });
        accessor.invoke(new DoOpsInTX(OP.PUT));
        accessor.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                TXManagerImpl mgr = RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager();
                TXStateInterface tx = mgr.internalSuspend();
                TestCase.assertNotNull((Object)tx);
                mgr.resume(tx);
                mgr.commit();
                return null;
            }
        });
        accessor.invoke(new DoOpsInTX(OP.DESTROY));
        accessor.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                TXManagerImpl mgr = RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager();
                TXStateInterface tx = mgr.internalSuspend();
                TestCase.assertNotNull((Object)tx);
                mgr.resume(tx);
                mgr.commit();
                return null;
            }
        });
        accessor.invoke(new DoOpsInTX(OP.PUT));
        accessor.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                TXManagerImpl mgr = RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager();
                TXStateInterface tx = mgr.internalSuspend();
                TestCase.assertNotNull((Object)tx);
                mgr.resume(tx);
                mgr.commit();
                TXManagerImpl.waitForPendingCommitForTest();
                return null;
            }
        });
        datastore.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region refRegion = RemoteTransactionDUnitTest.this.getCache().getRegion("distrReference");
                OriginRemoteRRWriter w = (OriginRemoteRRWriter)refRegion.getAttributes().getCacheWriter();
                TestCase.assertEquals((int)1, (int)w.fireC);
                TestCase.assertEquals((int)1, (int)w.fireD);
                TestCase.assertEquals((int)1, (int)w.fireU);
                return null;
            }
        });
        accessor.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region refRegion = RemoteTransactionDUnitTest.this.getCache().getRegion("distrReference");
                TestCase.assertNull((Object)refRegion.getAttributes().getCacheWriter());
                return null;
            }
        });
    }

    public void Bug44146_testRemoteCreateInReplicatedRegion() {
        Host host = Host.getHost(0);
        VM accessor = host.getVM(0);
        VM datastore = host.getVM(1);
        this.initAccessorAndDataStore(accessor, datastore, 0);
        accessor.invoke(new DoOpsInTX(OP.PUT));
        accessor.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region refRegion = RemoteTransactionDUnitTest.this.getCache().getRegion("distrReference");
                refRegion.create((Object)"sup", (Object)"dawg");
                return null;
            }
        });
        accessor.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                TXManagerImpl mgr = RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager();
                TXStateInterface tx = mgr.internalSuspend();
                TestCase.assertNotNull((Object)tx);
                mgr.resume(tx);
                mgr.commit();
                return null;
            }
        });
        accessor.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region refRegion = RemoteTransactionDUnitTest.this.getCache().getRegion("distrReference");
                TestCase.assertEquals((Object)"dawg", (Object)refRegion.get((Object)"sup"));
                return null;
            }
        });
    }

    public void Bug44146_testRemoteTxCleanupOnCrash() {
        Host host = Host.getHost(0);
        VM accessor = host.getVM(0);
        VM datastore = host.getVM(1);
        this.initAccessorAndDataStore(accessor, datastore, 0);
        accessor.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region cust = RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                TXManagerImpl mgr = RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager();
                mgr.begin();
                cust.put((Object)new CustId(6), (Object)new Customer("customer6", "address6"));
                return null;
            }
        });
        final InternalDistributedMember member = (InternalDistributedMember)accessor.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                return RemoteTransactionDUnitTest.this.getGemfireCache().getMyId();
            }
        });
        datastore.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                TXManagerImpl mgr = RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager();
                TestCase.assertEquals((int)1, (int)mgr.hostedTransactionsInProgressForTest());
                mgr.memberDeparted(member, true);
                TestCase.assertEquals((int)0, (int)mgr.hostedTransactionsInProgressForTest());
                return null;
            }
        });
    }

    public void Bug44146_testNonColocatedPutAll() {
        this.doNonColocatedbulkOp(OP.PUTALL);
    }

    public void Bug44146_testNonColocatedGetAll() {
        this.doNonColocatedbulkOp(OP.GETALL);
    }

    private void doNonColocatedbulkOp(final OP op) {
        Host host = Host.getHost(0);
        VM accessor = host.getVM(0);
        VM datastore1 = host.getVM(1);
        VM datastore2 = host.getVM(2);
        this.initAccessorAndDataStore(accessor, datastore1, datastore2, 0);
        accessor.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Customer c;
                CustId cId;
                int i;
                HashMap<CustId, Customer> custMap = new HashMap<CustId, Customer>();
                HashMap<CustId, Customer> custGetMap = new HashMap<CustId, Customer>();
                HashMap custGetResMap = new HashMap();
                HashMap<CustId, Customer> custOrigMap = new HashMap<CustId, Customer>();
                HashMap<CustId, Customer> custOrigGetMap = new HashMap<CustId, Customer>();
                for (i = 0; i < 10; ++i) {
                    cId = new CustId(i);
                    c = new Customer("name" + i, "addr" + i);
                    custMap.put(cId, c);
                }
                for (i = 3; i < 10; ++i) {
                    cId = new CustId(i);
                    c = new Customer("name" + i, "addr" + i);
                    custGetMap.put(cId, c);
                }
                for (i = 0; i < 5; ++i) {
                    cId = new CustId(i);
                    c = new Customer("customer" + i, "address" + i);
                    custOrigMap.put(cId, c);
                }
                for (i = 3; i < 5; ++i) {
                    cId = new CustId(i);
                    c = new Customer("customer" + i, "address" + i);
                    custOrigGetMap.put(cId, c);
                }
                custGetResMap.putAll(custOrigMap);
                custGetResMap.putAll(custGetMap);
                GemFireCacheImpl cache = RemoteTransactionDUnitTest.this.getGemfireCache();
                TXManagerImpl txMgr = cache.getTxManager();
                txMgr.begin();
                Region r = cache.getRegion("custRegion");
                Region rr = cache.getRegion("distrReference");
                switch (op) {
                    case PUTALL: {
                        r.putAll(custMap);
                        rr.putAll(custMap);
                        RemoteTransactionDUnitTest.assertMapEquals(custMap, r.getAll(custMap.keySet()));
                        RemoteTransactionDUnitTest.assertMapEquals(custMap, rr.getAll(custMap.keySet()));
                        break;
                    }
                    case GETALL: {
                        r.putAll(custGetMap);
                        rr.putAll(custGetMap);
                        RemoteTransactionDUnitTest.assertMapEquals(custGetResMap, r.getAll(custMap.keySet()));
                        RemoteTransactionDUnitTest.assertMapEquals(custGetMap, r.getAll(custGetMap.keySet()));
                        RemoteTransactionDUnitTest.assertMapEquals(custGetResMap, rr.getAll(custMap.keySet()));
                        RemoteTransactionDUnitTest.assertMapEquals(custGetMap, rr.getAll(custGetMap.keySet()));
                        break;
                    }
                }
                TXStateInterface tx = txMgr.internalSuspend();
                switch (op) {
                    case PUTALL: {
                        RemoteTransactionDUnitTest.assertMapEquals(custOrigMap, r.getAll(custMap.keySet()));
                        RemoteTransactionDUnitTest.assertMapEquals(custOrigMap, rr.getAll(custMap.keySet()));
                        break;
                    }
                    case GETALL: {
                        RemoteTransactionDUnitTest.assertMapEquals(custOrigGetMap, r.getAll(custGetMap.keySet()));
                        RemoteTransactionDUnitTest.assertMapEquals(custOrigMap, r.getAll(custMap.keySet()));
                        RemoteTransactionDUnitTest.assertMapEquals(custOrigGetMap, rr.getAll(custGetMap.keySet()));
                        RemoteTransactionDUnitTest.assertMapEquals(custOrigMap, rr.getAll(custMap.keySet()));
                        break;
                    }
                }
                txMgr.resume(tx);
                txMgr.rollback();
                switch (op) {
                    case PUTALL: {
                        RemoteTransactionDUnitTest.assertMapEquals(custOrigMap, r.getAll(custMap.keySet()));
                        RemoteTransactionDUnitTest.assertMapEquals(custOrigMap, rr.getAll(custMap.keySet()));
                        break;
                    }
                    case GETALL: {
                        RemoteTransactionDUnitTest.assertMapEquals(custOrigGetMap, r.getAll(custGetMap.keySet()));
                        RemoteTransactionDUnitTest.assertMapEquals(custOrigMap, r.getAll(custMap.keySet()));
                        RemoteTransactionDUnitTest.assertMapEquals(custOrigGetMap, rr.getAll(custGetMap.keySet()));
                        RemoteTransactionDUnitTest.assertMapEquals(custOrigMap, rr.getAll(custMap.keySet()));
                        break;
                    }
                }
                txMgr.begin();
                switch (op) {
                    case PUTALL: {
                        r.putAll(custMap);
                        rr.putAll(custMap);
                        RemoteTransactionDUnitTest.assertMapEquals(custMap, r.getAll(custMap.keySet()));
                        RemoteTransactionDUnitTest.assertMapEquals(custMap, rr.getAll(custMap.keySet()));
                        break;
                    }
                    case GETALL: {
                        r.putAll(custGetMap);
                        rr.putAll(custGetMap);
                        RemoteTransactionDUnitTest.assertMapEquals(custGetResMap, r.getAll(custMap.keySet()));
                        RemoteTransactionDUnitTest.assertMapEquals(custGetMap, r.getAll(custGetMap.keySet()));
                        RemoteTransactionDUnitTest.assertMapEquals(custGetResMap, rr.getAll(custMap.keySet()));
                        RemoteTransactionDUnitTest.assertMapEquals(custGetMap, rr.getAll(custGetMap.keySet()));
                        break;
                    }
                }
                txMgr.commit();
                switch (op) {
                    case PUTALL: {
                        RemoteTransactionDUnitTest.assertMapEquals(custMap, r.getAll(custMap.keySet()));
                        RemoteTransactionDUnitTest.assertMapEquals(custMap, rr.getAll(custMap.keySet()));
                        break;
                    }
                    case GETALL: {
                        RemoteTransactionDUnitTest.assertMapEquals(custGetResMap, r.getAll(custMap.keySet()));
                        RemoteTransactionDUnitTest.assertMapEquals(custGetMap, r.getAll(custGetMap.keySet()));
                        RemoteTransactionDUnitTest.assertMapEquals(custGetResMap, rr.getAll(custMap.keySet()));
                        RemoteTransactionDUnitTest.assertMapEquals(custGetMap, rr.getAll(custGetMap.keySet()));
                        break;
                    }
                }
                return null;
            }
        });
    }

    public static void assertMapEquals(Map<?, ?> expected, Map<?, ?> result) {
        for (Map.Entry<?, ?> entry : expected.entrySet()) {
            RemoteTransactionDUnitTest.assertEquals(entry.getValue(), result.get(entry.getKey()));
        }
        for (Map.Entry<?, ?> entry : result.entrySet()) {
            if (expected.containsKey(entry.getKey())) continue;
            RemoteTransactionDUnitTest.assertNull((String)("expected no value for key: " + entry.getKey() + ", result: " + result), entry.getValue());
        }
    }

    public void Bug44146_testDestroyCreateConflation() {
        Host host = Host.getHost(0);
        VM accessor = host.getVM(0);
        VM datastore = host.getVM(1);
        this.initAccessorAndDataStore(accessor, datastore, 0);
        datastore.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region cust = RemoteTransactionDUnitTest.this.getCache().getRegion("distrReference");
                cust.put((Object)"meow", (Object)"this is a meow, deal with it");
                cust.getAttributesMutator().addCacheListener((CacheListener)new OneUpdateCacheListener());
                cust.getAttributesMutator().setCacheWriter((CacheWriter)new OneDestroyAndThenOneCreateCacheWriter());
                return null;
            }
        });
        accessor.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region cust = RemoteTransactionDUnitTest.this.getCache().getRegion("distrReference");
                cust.getAttributesMutator().addCacheListener((CacheListener)new OneUpdateCacheListener());
                return null;
            }
        });
        datastore.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                TXManagerImpl mgr = RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager();
                mgr.begin();
                Region cust = RemoteTransactionDUnitTest.this.getCache().getRegion("distrReference");
                cust.destroy((Object)"meow");
                cust.create((Object)"meow", (Object)"this is the new meow, not the old meow");
                mgr.commit();
                TXManagerImpl.waitForPendingCommitForTest();
                return null;
            }
        });
        accessor.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region cust = RemoteTransactionDUnitTest.this.getCache().getRegion("distrReference");
                OneUpdateCacheListener rat = (OneUpdateCacheListener)cust.getAttributes().getCacheListener();
                if (!rat.getSuccess()) {
                    TestCase.fail((String)"The OneUpdateCacheListener didnt get an update");
                }
                return null;
            }
        });
        datastore.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region cust = RemoteTransactionDUnitTest.this.getCache().getRegion("distrReference");
                OneDestroyAndThenOneCreateCacheWriter wri = (OneDestroyAndThenOneCreateCacheWriter)cust.getAttributes().getCacheWriter();
                wri.checkSuccess();
                return null;
            }
        });
    }

    protected Integer startServer(VM vm) {
        return (Integer)vm.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                int port = AvailablePort.getRandomAvailablePort((int)0);
                CacheServer s = RemoteTransactionDUnitTest.this.getCache().addCacheServer();
                s.setPort(port);
                s.start();
                return port;
            }
        });
    }

    protected void createClientRegion(VM vm, final int port, final boolean isEmpty, final boolean ri, final boolean CQ) {
        vm.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                ClientCacheFactory ccf = new ClientCacheFactory();
                ccf.addPoolServer("localhost", port);
                ccf.setPoolSubscriptionEnabled(true);
                ccf.set("log-level", DistributedTestCase.getDUnitLogLevel());
                ClientCache cCache = RemoteTransactionDUnitTest.this.getClientCache(ccf);
                ClientRegionFactory crf = cCache.createClientRegionFactory(isEmpty ? ClientRegionShortcut.PROXY : ClientRegionShortcut.CACHING_PROXY);
                crf.setConcurrencyChecksEnabled(RemoteTransactionDUnitTest.this.getConcurrencyChecksEnabled());
                crf.addCacheListener((CacheListener)new ClientListener());
                Region r = crf.create("distrReference");
                Region cust = crf.create("custRegion");
                Region order = crf.create("orderRegion");
                if (ri) {
                    r.registerInterestRegex(".*");
                    cust.registerInterestRegex(".*");
                    order.registerInterestRegex(".*");
                }
                if (CQ) {
                    CqAttributesFactory cqf = new CqAttributesFactory();
                    cqf.addCqListener((CqListener)new ClientCQListener());
                    CqAttributes ca = cqf.create();
                    cCache.getQueryService().newCq("SELECT * FROM " + cust.getFullPath(), ca).execute();
                }
                return null;
            }
        });
    }

    public void Bug44146_testTXWithRI() throws Exception {
        Host host = Host.getHost(0);
        VM accessor = host.getVM(0);
        VM datastore = host.getVM(1);
        VM client = host.getVM(2);
        this.initAccessorAndDataStore(accessor, datastore, 0);
        int port = this.startServer(datastore);
        this.createClientRegion(client, port, false, true, false);
        accessor.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region custRegion = RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                Region orderRegion = RemoteTransactionDUnitTest.this.getCache().getRegion("orderRegion");
                Region refRegion = RemoteTransactionDUnitTest.this.getCache().getRegion("distrReference");
                CustId custId = new CustId(1);
                OrderId orderId = new OrderId(1, custId);
                RemoteTransactionDUnitTest.this.getCache().getCacheTransactionManager().begin();
                custRegion.put((Object)custId, (Object)new Customer("foo", "bar"));
                orderRegion.put((Object)orderId, (Object)new Order("fooOrder"));
                refRegion.put((Object)custId, (Object)new Customer("foo", "bar"));
                RemoteTransactionDUnitTest.this.getCache().getCacheTransactionManager().commit();
                return null;
            }
        });
        Thread.sleep(10000L);
        client.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region custRegion = RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                RemoteTransactionDUnitTest.this.getCache().getRegion("orderRegion");
                RemoteTransactionDUnitTest.this.getCache().getRegion("distrReference");
                ClientListener cl = (ClientListener)custRegion.getAttributes().getCacheListeners()[0];
                RemoteTransactionDUnitTest.this.getCache().getLogger().info("SWAP:CLIENTinvoked:" + cl.invoked);
                TestCase.assertTrue((boolean)cl.invoked);
                return null;
            }
        });
    }

    public void Bug44146_testBug43176() {
        Host host = Host.getHost(0);
        VM datastore = host.getVM(0);
        VM client = host.getVM(1);
        datastore.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                AttributesFactory af = new AttributesFactory();
                af.setScope(Scope.DISTRIBUTED_ACK);
                af.setDataPolicy(DataPolicy.EMPTY);
                af.setConcurrencyChecksEnabled(RemoteTransactionDUnitTest.this.getConcurrencyChecksEnabled());
                RemoteTransactionDUnitTest.this.getCache().createRegionFactory(af.create()).create(RemoteTransactionDUnitTest.EMPTY_REGION);
                af.setDataPolicy(DataPolicy.REPLICATE);
                RemoteTransactionDUnitTest.this.getCache().createRegionFactory(af.create()).create("distrReference");
                return null;
            }
        });
        final int port = this.startServer(datastore);
        client.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                ClientCacheFactory ccf = new ClientCacheFactory();
                ccf.addPoolServer("localhost", port);
                ccf.setPoolSubscriptionEnabled(true);
                ccf.set("log-level", DistributedTestCase.getDUnitLogLevel());
                ClientCache cCache = RemoteTransactionDUnitTest.this.getClientCache(ccf);
                ClientRegionFactory crf = cCache.createClientRegionFactory(ClientRegionShortcut.CACHING_PROXY);
                crf.addCacheListener((CacheListener)new ClientListener());
                crf.setConcurrencyChecksEnabled(RemoteTransactionDUnitTest.this.getConcurrencyChecksEnabled());
                Region r = crf.create("distrReference");
                Region empty = crf.create(RemoteTransactionDUnitTest.EMPTY_REGION);
                r.registerInterest((Object)"ALL_KEYS", InterestResultPolicy.KEYS_VALUES);
                empty.registerInterest((Object)"ALL_KEYS", InterestResultPolicy.KEYS_VALUES);
                return null;
            }
        });
        datastore.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region ref = RemoteTransactionDUnitTest.this.getCache().getRegion("distrReference");
                Region empty = RemoteTransactionDUnitTest.this.getCache().getRegion(RemoteTransactionDUnitTest.EMPTY_REGION);
                RemoteTransactionDUnitTest.this.getGemfireCache().getCacheTransactionManager().begin();
                ref.put((Object)"one", (Object)"value1");
                empty.put((Object)"eone", (Object)"valueOne");
                RemoteTransactionDUnitTest.this.getCache().getLogger().info("SWAP:callingCommit");
                RemoteTransactionDUnitTest.this.getGemfireCache().getCacheTransactionManager().commit();
                TestCase.assertTrue((boolean)ref.containsKey((Object)"one"));
                TestCase.assertEquals((Object)"value1", (Object)ref.get((Object)"one"));
                TestCase.assertFalse((boolean)empty.containsKey((Object)"eone"));
                TestCase.assertNull((Object)empty.get((Object)"eone"));
                return null;
            }
        });
        client.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region empty = RemoteTransactionDUnitTest.this.getCache().getRegion(RemoteTransactionDUnitTest.EMPTY_REGION);
                final ClientListener l = (ClientListener)empty.getAttributes().getCacheListeners()[0];
                DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        return l.invoked;
                    }

                    @Override
                    public String description() {
                        return "listener invoked:" + l.invoked;
                    }
                };
                DistributedTestCase.waitForCriterion(wc, 10000L, 200L, true);
                return null;
            }
        });
    }

    public void Bug44146_testTXWithRICommitInDatastore() throws Exception {
        Host host = Host.getHost(0);
        VM accessor = host.getVM(0);
        VM datastore = host.getVM(1);
        VM client = host.getVM(2);
        this.initAccessorAndDataStore(accessor, datastore, 0);
        int port = this.startServer(datastore);
        this.createClientRegion(client, port, false, true, false);
        datastore.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region custRegion = RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                Region orderRegion = RemoteTransactionDUnitTest.this.getCache().getRegion("orderRegion");
                Region refRegion = RemoteTransactionDUnitTest.this.getCache().getRegion("distrReference");
                CustId custId = new CustId(1);
                OrderId orderId = new OrderId(1, custId);
                RemoteTransactionDUnitTest.this.getCache().getCacheTransactionManager().begin();
                custRegion.put((Object)custId, (Object)new Customer("foo", "bar"));
                orderRegion.put((Object)orderId, (Object)new Order("fooOrder"));
                refRegion.put((Object)custId, (Object)new Customer("foo", "bar"));
                RemoteTransactionDUnitTest.this.getCache().getCacheTransactionManager().commit();
                return null;
            }
        });
        Thread.sleep(10000L);
        client.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region custRegion = RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                RemoteTransactionDUnitTest.this.getCache().getRegion("orderRegion");
                RemoteTransactionDUnitTest.this.getCache().getRegion("distrReference");
                ClientListener cl = (ClientListener)custRegion.getAttributes().getCacheListeners()[0];
                RemoteTransactionDUnitTest.this.getCache().getLogger().info("SWAP:CLIENTinvoked:" + cl.invoked);
                TestCase.assertTrue((boolean)cl.invoked);
                return null;
            }
        });
    }

    public void Bug44146_testListenersNotInvokedOnSecondary() {
        Host host = Host.getHost(0);
        VM accessor = host.getVM(0);
        VM datastore1 = host.getVM(1);
        VM datastore2 = host.getVM(2);
        this.initAccessorAndDataStoreWithInterestPolicy(accessor, datastore1, datastore2, 1);
        SerializableCallable registerListener = new SerializableCallable(){

            public Object call() throws Exception {
                Region custRegion = RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                custRegion.getAttributesMutator().addCacheListener((CacheListener)new ListenerInvocationCounter());
                return null;
            }
        };
        datastore1.invoke(registerListener);
        datastore2.invoke(registerListener);
        datastore1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region custRegion = RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                RemoteTransactionDUnitTest.this.getCache().getCacheTransactionManager().begin();
                CustId custId = new CustId(1);
                Customer customer = new Customer("customerNew", "addressNew");
                custRegion.put((Object)custId, (Object)customer);
                RemoteTransactionDUnitTest.this.getCache().getCacheTransactionManager().commit();
                return null;
            }
        });
        SerializableCallable getListenerCount = new SerializableCallable(){

            public Object call() throws Exception {
                Region custRegion = RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                ListenerInvocationCounter l = (ListenerInvocationCounter)custRegion.getAttributes().getCacheListeners()[0];
                RemoteTransactionDUnitTest.this.getCache().getLogger().info("SWAP:listenerCount:" + l.invocationCount);
                return l.invocationCount;
            }
        };
        int totalInvocation = (Integer)datastore1.invoke(getListenerCount) + (Integer)datastore2.invoke(getListenerCount);
        RemoteTransactionDUnitTest.assertEquals((int)1, (int)totalInvocation);
    }

    public void DISABLED_TILL_NEW_TX_IMPL_COMPLETE_testTXWithCQCommitInDatastore() throws Exception {
        Host host = Host.getHost(0);
        VM accessor = host.getVM(0);
        VM datastore = host.getVM(1);
        VM client = host.getVM(2);
        this.initAccessorAndDataStore(accessor, datastore, 0);
        int port = this.startServer(datastore);
        this.createClientRegion(client, port, false, true, true);
        datastore.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region custRegion = RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                Region orderRegion = RemoteTransactionDUnitTest.this.getCache().getRegion("orderRegion");
                Region refRegion = RemoteTransactionDUnitTest.this.getCache().getRegion("distrReference");
                CustId custId = new CustId(1);
                OrderId orderId = new OrderId(1, custId);
                RemoteTransactionDUnitTest.this.getCache().getCacheTransactionManager().begin();
                custRegion.put((Object)custId, (Object)new Customer("foo", "bar"));
                orderRegion.put((Object)orderId, (Object)new Order("fooOrder"));
                refRegion.put((Object)custId, (Object)new Customer("foo", "bar"));
                RemoteTransactionDUnitTest.this.getCache().getCacheTransactionManager().commit();
                return null;
            }
        });
        Thread.sleep(10000L);
        client.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region custRegion = RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                RemoteTransactionDUnitTest.this.getCache().getRegion("orderRegion");
                RemoteTransactionDUnitTest.this.getCache().getRegion("distrReference");
                ClientListener cl = (ClientListener)custRegion.getAttributes().getCacheListeners()[0];
                RemoteTransactionDUnitTest.this.getCache().getLogger().info("SWAP:CLIENTinvoked:" + cl.invoked);
                TestCase.assertTrue((boolean)((ClientCQListener)custRegion.getCache().getQueryService().getCqs()[0].getCqAttributes().getCqListener()).invoked);
                TestCase.assertTrue((boolean)cl.invoked);
                return null;
            }
        });
    }

    public void DISABLED_TILL_NEW_TX_IMPL_COMPLETE_testTXWithCQCommitInDatastoreConnectedToAccessor() throws Exception {
        Host host = Host.getHost(0);
        VM accessor = host.getVM(0);
        VM datastore = host.getVM(1);
        VM client = host.getVM(2);
        this.initAccessorAndDataStore(accessor, datastore, 0);
        int port = this.startServer(accessor);
        this.createClientRegion(client, port, false, true, true);
        datastore.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region custRegion = RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                RemoteTransactionDUnitTest.this.getCache().getRegion("orderRegion");
                RemoteTransactionDUnitTest.this.getCache().getRegion("distrReference");
                CustId custId = new CustId(1);
                new OrderId(1, custId);
                RemoteTransactionDUnitTest.this.getCache().getCacheTransactionManager().begin();
                custRegion.put((Object)custId, (Object)new Customer("foo", "bar"));
                RemoteTransactionDUnitTest.this.getCache().getCacheTransactionManager().commit();
                return null;
            }
        });
        Thread.sleep(10000L);
        client.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region custRegion = RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                RemoteTransactionDUnitTest.this.getCache().getRegion("orderRegion");
                RemoteTransactionDUnitTest.this.getCache().getRegion("distrReference");
                ClientListener cl = (ClientListener)custRegion.getAttributes().getCacheListeners()[0];
                RemoteTransactionDUnitTest.this.getCache().getLogger().info("SWAP:CLIENTinvoked:" + cl.invoked);
                TestCase.assertTrue((boolean)cl.invoked);
                TestCase.assertTrue((boolean)((ClientCQListener)custRegion.getCache().getQueryService().getCqs()[0].getCqAttributes().getCqListener()).invoked);
                return null;
            }
        });
    }

    public void DISABLED_TILL_NEW_TX_IMPL_COMPLETE_testTXWithCQCommitInDatastoreConnectedToDatastore() throws Exception {
        Host host = Host.getHost(0);
        VM accessor = host.getVM(0);
        VM datastore = host.getVM(1);
        VM client = host.getVM(2);
        this.initAccessorAndDataStore(accessor, datastore, 0);
        int port = this.startServer(datastore);
        this.createClientRegion(client, port, false, true, true);
        datastore.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region custRegion = RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                RemoteTransactionDUnitTest.this.getCache().getRegion("orderRegion");
                RemoteTransactionDUnitTest.this.getCache().getRegion("distrReference");
                CustId custId = new CustId(1);
                new OrderId(1, custId);
                RemoteTransactionDUnitTest.this.getCache().getCacheTransactionManager().begin();
                custRegion.put((Object)custId, (Object)new Customer("foo", "bar"));
                RemoteTransactionDUnitTest.this.getCache().getCacheTransactionManager().commit();
                return null;
            }
        });
        Thread.sleep(10000L);
        client.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region custRegion = RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                RemoteTransactionDUnitTest.this.getCache().getRegion("orderRegion");
                RemoteTransactionDUnitTest.this.getCache().getRegion("distrReference");
                ClientListener cl = (ClientListener)custRegion.getAttributes().getCacheListeners()[0];
                RemoteTransactionDUnitTest.this.getCache().getLogger().info("SWAP:CLIENTinvoked:" + cl.invoked);
                TestCase.assertTrue((boolean)cl.invoked);
                TestCase.assertTrue((boolean)((ClientCQListener)custRegion.getCache().getQueryService().getCqs()[0].getCqAttributes().getCqListener()).invoked);
                return null;
            }
        });
    }

    public void DISABLED_TILL_NEW_TX_IMPL_COMPLETE_testTXWithCQCommitInAccessorConnectedToDatastore() throws Exception {
        Host host = Host.getHost(0);
        VM accessor = host.getVM(0);
        VM datastore = host.getVM(1);
        VM client = host.getVM(2);
        this.initAccessorAndDataStore(accessor, datastore, 0);
        int port = this.startServer(datastore);
        this.createClientRegion(client, port, false, true, true);
        accessor.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region custRegion = RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                RemoteTransactionDUnitTest.this.getCache().getRegion("orderRegion");
                RemoteTransactionDUnitTest.this.getCache().getRegion("distrReference");
                CustId custId = new CustId(1);
                new OrderId(1, custId);
                RemoteTransactionDUnitTest.this.getCache().getCacheTransactionManager().begin();
                custRegion.put((Object)custId, (Object)new Customer("foo", "bar"));
                RemoteTransactionDUnitTest.this.getCache().getCacheTransactionManager().commit();
                return null;
            }
        });
        Thread.sleep(10000L);
        client.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region custRegion = RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                RemoteTransactionDUnitTest.this.getCache().getRegion("orderRegion");
                RemoteTransactionDUnitTest.this.getCache().getRegion("distrReference");
                ClientListener cl = (ClientListener)custRegion.getAttributes().getCacheListeners()[0];
                RemoteTransactionDUnitTest.this.getCache().getLogger().info("SWAP:CLIENTinvoked:" + cl.invoked);
                TestCase.assertTrue((boolean)cl.invoked);
                TestCase.assertTrue((boolean)((ClientCQListener)custRegion.getCache().getQueryService().getCqs()[0].getCqAttributes().getCqListener()).invoked);
                return null;
            }
        });
    }

    public void DISABLED_TILL_NEW_TX_IMPL_COMPLETE_testTXWithCQCommitInAccessorConnectedToAccessor() throws Exception {
        Host host = Host.getHost(0);
        VM accessor = host.getVM(0);
        VM datastore = host.getVM(1);
        VM client = host.getVM(2);
        this.initAccessorAndDataStore(accessor, datastore, 0);
        int port = this.startServer(accessor);
        this.createClientRegion(client, port, false, true, true);
        accessor.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region custRegion = RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                RemoteTransactionDUnitTest.this.getCache().getRegion("orderRegion");
                RemoteTransactionDUnitTest.this.getCache().getRegion("distrReference");
                CustId custId = new CustId(1);
                new OrderId(1, custId);
                RemoteTransactionDUnitTest.this.getCache().getCacheTransactionManager().begin();
                custRegion.put((Object)custId, (Object)new Customer("foo", "bar"));
                RemoteTransactionDUnitTest.this.getCache().getCacheTransactionManager().commit();
                return null;
            }
        });
        Thread.sleep(10000L);
        client.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region custRegion = RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                RemoteTransactionDUnitTest.this.getCache().getRegion("orderRegion");
                RemoteTransactionDUnitTest.this.getCache().getRegion("distrReference");
                ClientListener cl = (ClientListener)custRegion.getAttributes().getCacheListeners()[0];
                RemoteTransactionDUnitTest.this.getCache().getLogger().info("SWAP:CLIENTinvoked:" + cl.invoked);
                TestCase.assertTrue((boolean)cl.invoked);
                TestCase.assertTrue((boolean)((ClientCQListener)custRegion.getCache().getQueryService().getCqs()[0].getCqAttributes().getCqListener()).invoked);
                return null;
            }
        });
    }

    public void DISABLED_TILL_NEW_TX_IMPL_COMPLETE_testCQCommitInDAtastoreConnectedToAccessor() throws Exception {
        Host host = Host.getHost(0);
        VM accessor = host.getVM(0);
        VM datastore = host.getVM(1);
        VM client = host.getVM(2);
        this.initAccessorAndDataStore(accessor, datastore, 0);
        int port = this.startServer(accessor);
        this.createClientRegion(client, port, false, true, true);
        datastore.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region custRegion = RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                RemoteTransactionDUnitTest.this.getCache().getRegion("orderRegion");
                RemoteTransactionDUnitTest.this.getCache().getRegion("distrReference");
                CustId custId = new CustId(1);
                new OrderId(1, custId);
                RemoteTransactionDUnitTest.this.getCache().getCacheTransactionManager().begin();
                custRegion.put((Object)custId, (Object)new Customer("foo", "bar"));
                RemoteTransactionDUnitTest.this.getCache().getCacheTransactionManager().commit();
                return null;
            }
        });
        Thread.sleep(10000L);
        client.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region custRegion = RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                RemoteTransactionDUnitTest.this.getCache().getRegion("orderRegion");
                RemoteTransactionDUnitTest.this.getCache().getRegion("distrReference");
                ClientListener cl = (ClientListener)custRegion.getAttributes().getCacheListeners()[0];
                RemoteTransactionDUnitTest.this.getCache().getLogger().info("SWAP:CLIENTinvoked:" + cl.invoked);
                TestCase.assertTrue((boolean)cl.invoked);
                TestCase.assertTrue((boolean)((ClientCQListener)custRegion.getCache().getQueryService().getCqs()[0].getCqAttributes().getCqListener()).invoked);
                return null;
            }
        });
    }

    public void DISABLED_TILL_NEW_TX_IMPL_COMPLETE_testBug33073() {
        Host host = Host.getHost(0);
        VM accessor = host.getVM(0);
        VM datastore1 = host.getVM(1);
        VM datastore2 = host.getVM(2);
        this.initAccessorAndDataStore(accessor, datastore1, datastore2, 0);
        final CustId custId = new CustId(19);
        datastore1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region refRegion = RemoteTransactionDUnitTest.this.getCache().getRegion("distrReference");
                TestCase.assertNull((Object)refRegion.get((Object)custId));
                RemoteTransactionDUnitTest.this.getCache().getCacheTransactionManager().begin();
                refRegion.put((Object)custId, (Object)new Customer("name1", "address1"));
                return null;
            }
        });
        datastore2.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region refRegion = RemoteTransactionDUnitTest.this.getCache().getRegion("distrReference");
                TestCase.assertNull((Object)refRegion.get((Object)custId));
                refRegion.put((Object)custId, (Object)new Customer("nameNew", "addressNew"));
                return null;
            }
        });
        datastore1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                try {
                    RemoteTransactionDUnitTest.this.getCache().getCacheTransactionManager().commit();
                    TestCase.fail((String)"expected conflict not thrown");
                }
                catch (ConflictException conflictException) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    public void DISABLED_TILL_NEW_TX_IMPL_COMPLETE_testBug43081() throws Exception {
        this.createRegion(false, 0, null);
        Context ctx = this.getCache().getJNDIContext();
        UserTransaction tx = (UserTransaction)ctx.lookup("java:/UserTransaction");
        RemoteTransactionDUnitTest.assertEquals((int)6, (int)tx.getStatus());
        Region pr = this.getCache().getRegion("custRegion");
        Region rr = this.getCache().getRegion("distrReference");
        for (int i = 0; i < 6; ++i) {
            pr.put((Object)new CustId(1), (Object)new Customer("name1", "address1"));
            rr.put((Object)"key1", (Object)"value1");
            tx.begin();
            switch (i) {
                case 0: {
                    pr.get((Object)new CustId(1));
                    rr.get((Object)"key1");
                    break;
                }
                case 1: {
                    pr.put((Object)new CustId(1), (Object)new Customer("nameNew", "addressNew"));
                    rr.put((Object)"key1", (Object)"valueNew");
                    break;
                }
                case 2: {
                    pr.invalidate((Object)new CustId(1));
                    rr.invalidate((Object)"key1");
                    break;
                }
                case 3: {
                    pr.destroy((Object)new CustId(1));
                    rr.destroy((Object)"key1");
                    break;
                }
                case 4: {
                    HashMap<Object, Object> m = new HashMap<Object, Object>();
                    m.put(new CustId(1), new Customer("nameNew", "addressNew"));
                    pr.putAll(m);
                    m = new HashMap();
                    m.put("key1", "valueNew");
                    rr.putAll(m);
                    break;
                }
                case 5: {
                    HashSet<Object> s = new HashSet<Object>();
                    s.add(new CustId(1));
                    pr.getAll(s);
                    s = new HashSet();
                    s.add("key1");
                    pr.getAll(s);
                    break;
                }
                case 6: {
                    pr.getEntry((Object)new CustId(1));
                    rr.getEntry((Object)"key1");
                    break;
                }
            }
            RemoteTransactionDUnitTest.assertEquals((int)0, (int)tx.getStatus());
            final CountDownLatch latch = new CountDownLatch(1);
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    Context ctx = RemoteTransactionDUnitTest.this.getCache().getJNDIContext();
                    try {
                        ctx.lookup("java:/UserTransaction");
                    }
                    catch (NamingException e) {
                        e.printStackTrace();
                    }
                    Region pr = RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
                    Region rr = RemoteTransactionDUnitTest.this.getCache().getRegion("distrReference");
                    pr.put((Object)new CustId(1), (Object)new Customer("name11", "address11"));
                    rr.put((Object)"key1", (Object)"value1");
                    latch.countDown();
                }
            });
            t.start();
            latch.await();
            try {
                pr.put((Object)new CustId(1), (Object)new Customer("name11", "address11"));
                tx.commit();
                RemoteTransactionDUnitTest.fail((String)"expected exception not thrown");
                continue;
            }
            catch (RollbackException rollbackException) {
                // empty catch block
            }
        }
    }

    public void Bug44146_testBug45556() {
        Host host = Host.getHost(0);
        VM accessor = host.getVM(0);
        VM datastore = host.getVM(1);
        final String name = this.getName();
        accessor.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region r = RemoteTransactionDUnitTest.this.getCache().createRegionFactory(RegionShortcut.REPLICATE_PROXY).create(name);
                class CountingListener
                extends CacheListenerAdapter {
                    private int count;

                    CountingListener() {
                    }

                    public void afterCreate(EntryEvent event) {
                        DistributedTestCase.getLogWriter().info("afterCreate invoked for " + event);
                        ++this.count;
                    }

                    public void afterUpdate(EntryEvent event) {
                        DistributedTestCase.getLogWriter().info("afterUpdate invoked for " + event);
                        ++this.count;
                    }
                }
                r.getAttributesMutator().addCacheListener((CacheListener)new CountingListener());
                return null;
            }
        });
        datastore.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region r = RemoteTransactionDUnitTest.this.getCache().createRegionFactory(RegionShortcut.REPLICATE).create(name);
                r.getAttributesMutator().addCacheListener((CacheListener)new CountingListener());
                r.put((Object)"key1", (Object)"value1");
                return null;
            }
        });
        final TXId txid = (TXId)accessor.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region r = RemoteTransactionDUnitTest.this.getCache().getRegion(name);
                CacheTransactionManager tm = RemoteTransactionDUnitTest.this.getCache().getCacheTransactionManager();
                RemoteTransactionDUnitTest.this.getCache().getLogger().fine("SWAP:BeginTX");
                tm.begin();
                r.put((Object)"txkey", (Object)"txvalue");
                return tm.suspend();
            }
        });
        datastore.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region rgn = RemoteTransactionDUnitTest.this.getCache().getRegion(name);
                TestCase.assertNull((Object)rgn.get((Object)"txkey"));
                TXManagerImpl txMgr = RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager();
                TXStateProxy tx = txMgr.getHostedTXState(txid);
                TestCase.assertEquals((int)1, (int)tx.getRegions().size());
                for (LocalRegion r : tx.getRegions()) {
                    TestCase.assertTrue((boolean)(r instanceof DistributedRegion));
                    TXRegionState rs = tx.readRegion(r);
                    for (Object key : rs.getEntryKeys()) {
                        TXEntryState es = (TXEntryState)rs.readEntry(key);
                        TestCase.assertEquals((Object)"txkey", key);
                        TestCase.assertNotNull((Object)es.getValue((Region)r));
                        if (!key.equals("txkey")) continue;
                        TestCase.assertTrue((boolean)es.isDirty());
                    }
                }
                return null;
            }
        });
        accessor.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region rgn = RemoteTransactionDUnitTest.this.getCache().getRegion(name);
                TestCase.assertNull((Object)rgn.get((Object)"txkey"));
                CacheTransactionManager mgr = RemoteTransactionDUnitTest.this.getCache().getCacheTransactionManager();
                mgr.resume((TransactionId)txid);
                mgr.commit();
                CountingListener cl = (CountingListener)rgn.getAttributes().getCacheListeners()[0];
                TestCase.assertEquals((int)0, (int)cl.count);
                TestCase.assertEquals((Object)"txvalue", (Object)rgn.get((Object)"txkey"));
                return null;
            }
        });
        datastore.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region rgn = RemoteTransactionDUnitTest.this.getCache().getRegion(name);
                CountingListener cl = (CountingListener)rgn.getAttributes().getCacheListeners()[0];
                TestCase.assertEquals((int)2, (int)cl.count);
                return null;
            }
        });
    }

    public void Bug44146_testExpirySuspend_bug45984() {
        Host host = Host.getHost(0);
        VM vm1 = host.getVM(0);
        VM vm2 = host.getVM(1);
        final String regionName = this.getName();
        vm1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                RegionFactory rf = RemoteTransactionDUnitTest.this.getCache().createRegionFactory();
                rf.setEntryTimeToLive(new ExpirationAttributes(1, ExpirationAction.DESTROY));
                rf.setScope(Scope.DISTRIBUTED_ACK);
                rf.create(regionName);
                return null;
            }
        });
        vm2.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                RemoteTransactionDUnitTest.this.getCache().createRegionFactory(RegionShortcut.REPLICATE).create(regionName);
                return null;
            }
        });
        vm1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                final Region r = RemoteTransactionDUnitTest.this.getCache().getRegion(regionName);
                r.put((Object)"key", (Object)"value");
                r.put((Object)"nonTXkey", (Object)"nonTXvalue");
                RemoteTransactionDUnitTest.this.getCache().getCacheTransactionManager().begin();
                r.put((Object)"key", (Object)"newvalue");
                DistributedTestCase.pause(5000);
                TransactionId tx = RemoteTransactionDUnitTest.this.getCache().getCacheTransactionManager().suspend();
                TestCase.assertTrue((boolean)r.containsKey((Object)"key"));
                TestCase.assertTrue((boolean)r.containsKey((Object)"nonTXkey"));
                RemoteTransactionDUnitTest.this.getCache().getCacheTransactionManager().resume(tx);
                RemoteTransactionDUnitTest.this.getCache().getCacheTransactionManager().commit();
                DistributedTestCase.WaitCriterion wc2 = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        return !r.containsKey((Object)"key") && !r.containsKey((Object)"nonTXKey");
                    }

                    @Override
                    public String description() {
                        return "did not expire";
                    }
                };
                DistributedTestCase.waitForCriterion(wc2, 30000L, 5L, true);
                return null;
            }
        });
    }

    public void Bug44146_testRemoteFetchVersionMessage() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        final String regionName = this.getName();
        final VersionTag tag = (VersionTag)vm0.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                LocalRegion r = (LocalRegion)RemoteTransactionDUnitTest.this.getCache().createRegionFactory(RegionShortcut.REPLICATE).create(regionName);
                r.put((Object)"key", (Object)"value");
                return r.getRegionEntry((Object)"key").getVersionStamp().asVersionTag();
            }
        });
        vm1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                AttributesFactory af = new AttributesFactory();
                af.setDataPolicy(DataPolicy.EMPTY);
                af.setScope(Scope.DISTRIBUTED_ACK);
                DistributedRegion r = (DistributedRegion)RemoteTransactionDUnitTest.this.getCache().createRegion(regionName, af.create());
                r.cache.getLogger().info("SWAP:sending:remoteTagRequest");
                VersionTag remote = r.fetchRemoteVersionTag((Object)"key");
                r.cache.getLogger().info("SWAP:remoteTag:" + remote);
                try {
                    remote = r.fetchRemoteVersionTag((Object)"nonExistentKey");
                    TestCase.fail((String)"expected exception not thrown");
                }
                catch (EntryNotFoundException entryNotFoundException) {
                    // empty catch block
                }
                TestCase.assertEquals((Object)tag, (Object)remote);
                return null;
            }
        });
    }

    public void Bug44146_testTransactionWithRemoteVersionFetch() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        final String regionNameNormal = this.getName() + "_normal";
        final String regionName = this.getName();
        vm0.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                RemoteTransactionDUnitTest.this.getCache().createRegionFactory(RegionShortcut.REPLICATE).create(regionName);
                Region n = RemoteTransactionDUnitTest.this.getCache().createRegionFactory(RegionShortcut.REPLICATE).create(regionNameNormal);
                n.put((Object)"key", (Object)"value");
                n.put((Object)"key", (Object)"value1");
                n.put((Object)"key", (Object)"value2");
                return null;
            }
        });
        final VersionTag tag = (VersionTag)vm1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region r = RemoteTransactionDUnitTest.this.getCache().createRegionFactory(RegionShortcut.REPLICATE).create(regionName);
                AttributesFactory af = new AttributesFactory();
                af.setDataPolicy(DataPolicy.NORMAL);
                af.setScope(Scope.DISTRIBUTED_ACK);
                Region n = RemoteTransactionDUnitTest.this.getCache().createRegion(regionNameNormal, af.create());
                TXManagerImpl mgr = RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager();
                mgr.begin();
                r.put((Object)"key", (Object)"value");
                TestCase.assertTrue((mgr.getTXState().getLocalTXState() != null ? 1 : 0) != 0);
                RemoteTransactionDUnitTest.this.getCache().getLogger().fine("SWAP:doingPutInNormalRegion");
                n.put((Object)"key", (Object)"value");
                RemoteTransactionDUnitTest.this.getCache().getLogger().fine("SWAP:commiting");
                mgr.commit();
                return ((LocalRegion)n).getRegionEntry((Object)"key").getVersionStamp().asVersionTag();
            }
        });
        vm0.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region n = RemoteTransactionDUnitTest.this.getCache().getRegion(regionNameNormal);
                VersionTag localTag = ((LocalRegion)n).getRegionEntry((Object)"key").getVersionStamp().asVersionTag();
                TestCase.assertEquals((int)tag.getEntryVersion(), (int)localTag.getEntryVersion());
                TestCase.assertEquals((long)tag.getRegionVersion(), (long)localTag.getRegionVersion());
                return null;
            }
        });
    }

    private class ListenerInvocationCounter
    extends CacheListenerAdapter {
        private int invocationCount = 0;

        private ListenerInvocationCounter() {
        }

        public void afterUpdate(EntryEvent event) {
            ++this.invocationCount;
        }

        public void close() {
            this.invocationCount = 0;
        }
    }

    protected static class ServerWriter
    extends CacheWriterAdapter {
        boolean invoked = false;

        protected ServerWriter() {
        }

        public void beforeCreate(EntryEvent event) throws CacheWriterException {
            this.invoked = true;
            event.getRegion().getCache().getLogger().info("SWAP:writer:" + event);
            TestCase.assertTrue((boolean)event.isOriginRemote());
        }

        public void beforeUpdate(EntryEvent event) throws CacheWriterException {
            this.invoked = true;
            event.getRegion().getCache().getLogger().info("SWAP:writer:" + event);
            TestCase.assertTrue((boolean)event.isOriginRemote());
        }

        public void beforeDestroy(EntryEvent event) throws CacheWriterException {
            this.invoked = true;
            event.getRegion().getCache().getLogger().info("SWAP:writer:" + event);
            TestCase.assertTrue((boolean)event.isOriginRemote());
        }
    }

    protected static class ServerListener
    extends CacheListenerAdapter {
        boolean invoked = false;
        int creates;
        int updates;

        protected ServerListener() {
        }

        public void afterCreate(EntryEvent event) {
            this.invoked = true;
            ++this.creates;
            TestCase.assertTrue((boolean)event.isOriginRemote());
        }

        public void afterUpdate(EntryEvent event) {
            this.invoked = true;
            ++this.updates;
            TestCase.assertTrue((boolean)event.isOriginRemote());
        }

        public void afterDestroy(EntryEvent event) {
            this.invoked = true;
            TestCase.assertTrue((boolean)event.isOriginRemote());
        }

        public void afterInvalidate(EntryEvent event) {
            this.invoked = true;
            TestCase.assertTrue((boolean)event.isOriginRemote());
        }
    }

    protected static class ClientListener
    extends CacheListenerAdapter {
        boolean invoked = false;
        int invokeCount = 0;
        int invalidateCount = 0;
        int putCount = 0;
        boolean putAllOp = false;
        boolean isOriginRemote = false;
        int creates;
        int updates;

        protected ClientListener() {
        }

        public void afterCreate(EntryEvent event) {
            event.getRegion().getCache().getLogger().warning("ZZZ AFTER CREATE:" + event.getKey());
            this.invoked = true;
            ++this.invokeCount;
            ++this.putCount;
            ++this.creates;
            event.getRegion().getCache().getLogger().warning("ZZZ AFTER CREATE:" + event.getKey() + " isPutAll:" + event.getOperation().isPutAll() + " op:" + event.getOperation());
            this.putAllOp = event.getOperation().isPutAll();
            this.isOriginRemote = event.isOriginRemote();
        }

        public void afterUpdate(EntryEvent event) {
            event.getRegion().getCache().getLogger().warning("ZZZ AFTER UPDATE:" + event.getKey() + " isPutAll:" + event.getOperation().isPutAll() + " op:" + event.getOperation());
            this.putAllOp = event.getOperation().isPutAll();
            this.invoked = true;
            ++this.invokeCount;
            ++this.putCount;
            ++this.updates;
            this.isOriginRemote = event.isOriginRemote();
        }

        public void afterInvalidate(EntryEvent event) {
            event.getRegion().getCache().getLogger().warning("ZZZ AFTER UPDATE:" + event.getKey());
            this.invoked = true;
            ++this.invokeCount;
            ++this.invalidateCount;
            this.isOriginRemote = event.isOriginRemote();
        }

        public void reset() {
            this.invoked = false;
            this.invokeCount = 0;
            this.invalidateCount = 0;
            this.putCount = 0;
            this.isOriginRemote = false;
            this.creates = 0;
            this.updates = 0;
        }
    }

    protected class ClientCQListener
    implements CqListener {
        boolean invoked = false;

        protected ClientCQListener() {
        }

        public void onError(CqEvent aCqEvent) {
        }

        public void onEvent(CqEvent aCqEvent) {
            this.invoked = true;
        }

        public void close() {
        }
    }

    class OneDestroyAndThenOneCreateCacheWriter
    extends CacheWriterAdapter {
        private boolean oneDestroy;
        private boolean oneCreate;

        OneDestroyAndThenOneCreateCacheWriter() {
        }

        public void checkSuccess() throws Exception {
            if (!this.oneDestroy || !this.oneCreate) {
                TestCase.fail((String)("Didn't get both events. oneDestroy=" + this.oneDestroy + " oneCreate=" + this.oneCreate));
            }
        }

        public void beforeCreate(EntryEvent event) throws CacheWriterException {
            if (!this.oneDestroy) {
                TestCase.fail((String)"destroy should have arrived in writer before create");
            } else if (this.oneCreate) {
                TestCase.fail((String)"more than one create detected! expecting destroy then create");
            } else {
                this.oneCreate = true;
            }
        }

        public void beforeUpdate(EntryEvent event) throws CacheWriterException {
            TestCase.fail((String)"update not expected");
        }

        public void beforeDestroy(EntryEvent event) throws CacheWriterException {
            if (this.oneDestroy) {
                TestCase.fail((String)"only one destroy expected");
            } else if (this.oneCreate) {
                TestCase.fail((String)"destroy is supposed to precede create");
            } else {
                this.oneDestroy = true;
            }
        }
    }

    class OneUpdateCacheListener
    extends CacheListenerAdapter {
        boolean success = false;

        OneUpdateCacheListener() {
        }

        public boolean getSuccess() {
            return this.success;
        }

        public void afterCreate(EntryEvent event) {
            TestCase.fail((String)"create not expected");
        }

        public void afterUpdate(EntryEvent event) {
            if (!this.success) {
                System.out.println("WE WIN!");
                this.success = true;
            } else {
                TestCase.fail((String)"Should have only had one update");
            }
        }

        public void afterDestroy(EntryEvent event) {
            TestCase.fail((String)"destroy not expected");
        }

        public void afterInvalidate(EntryEvent event) {
            TestCase.fail((String)"invalidate not expected");
        }
    }

    static enum Executions {
        OnRegion,
        OnMember;

    }

    class TXFunction
    implements Function {
        static final String id = "TXFunction";

        TXFunction() {
        }

        public void execute(FunctionContext context) {
            Region custRegion = RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
            Object args = context.getArguments();
            RemoteTransactionDUnitTest.this.getGemfireCache().getLogger().fine("SWAP:callingPut");
            if (args instanceof Object[]) {
                Object[] memberIds = (Object[])args;
                InternalDistributedMember myId = RemoteTransactionDUnitTest.this.getGemfireCache().getMyId();
                if (memberIds[0].equals(myId)) {
                    custRegion.put((Object)RemoteTransactionDUnitTest.this.expectedCustId, (Object)RemoteTransactionDUnitTest.this.expectedCustomer);
                } else if (memberIds[1].equals(myId)) {
                    Region orderRegion = RemoteTransactionDUnitTest.this.getCache().getRegion("orderRegion");
                    orderRegion.put((Object)RemoteTransactionDUnitTest.this.expectedOrderId, (Object)RemoteTransactionDUnitTest.this.expectedOrder);
                } else {
                    Region refRegion = RemoteTransactionDUnitTest.this.getCache().getRegion("distrReference");
                    refRegion.put((Object)RemoteTransactionDUnitTest.this.expectedCustId, (Object)RemoteTransactionDUnitTest.this.expectedCustomer);
                }
            } else {
                custRegion.put((Object)RemoteTransactionDUnitTest.this.expectedCustId, (Object)RemoteTransactionDUnitTest.this.expectedCustomer);
            }
            GemFireCacheImpl.getInstance().getLogger().warning(" XXX DOIN A PUT ", (Throwable)new Exception());
            context.getResultSender().lastResult((Object)Boolean.TRUE);
        }

        public String getId() {
            return id;
        }

        public boolean hasResult() {
            return true;
        }

        public boolean optimizeForWrite() {
            return true;
        }

        public boolean isHA() {
            return false;
        }
    }

    class TestTxWriter
    extends txCallback
    implements TransactionWriter {
        public TestTxWriter(boolean isAccessor) {
            this.isAccessor = isAccessor;
        }

        public void beforeCommit(TransactionEvent event) {
            this.verify(event);
        }

        public void close() {
        }
    }

    class TestTxListener
    extends txCallback
    implements TransactionListener {
        private volatile boolean listenerInvoked;

        TestTxListener(boolean isAccessor) {
            this.isAccessor = isAccessor;
        }

        public void afterCommit(TransactionEvent event) {
            this.listenerInvoked = true;
            this.verify(event);
        }

        public void afterFailedCommit(TransactionEvent event) {
            this.verify(event);
        }

        public void afterRollback(TransactionEvent event) {
            this.listenerInvoked = true;
            this.verify(event);
        }

        public boolean isListenerInvoked() {
            return this.listenerInvoked;
        }

        public void close() {
        }
    }

    abstract class txCallback {
        protected boolean isAccessor;
        protected Exception ex = null;

        txCallback() {
        }

        protected void verify(TransactionEvent txEvent) {
            for (CacheEvent e : txEvent.getEvents()) {
                this.verifyOrigin(e);
                this.verifyPutAll(e);
            }
        }

        private void verifyOrigin(CacheEvent event) {
            try {
                TestCase.assertEquals((!this.isAccessor ? 1 : 0) != 0, (boolean)event.isOriginRemote());
            }
            catch (Exception e) {
                this.ex = e;
            }
        }

        private void verifyPutAll(CacheEvent p_event) {
            if (!(p_event instanceof EntryEvent)) {
                return;
            }
            EntryEvent event = (EntryEvent)p_event;
            CustId knownCustId = new CustId(1);
            OrderId knownOrderId = new OrderId(2, knownCustId);
            if (event.getKey().equals(knownOrderId)) {
                try {
                    TestCase.assertTrue((boolean)event.getOperation().isPutAll());
                    TestCase.assertNotNull((Object)event.getTransactionId());
                }
                catch (Exception e) {
                    this.ex = e;
                }
            }
        }
    }

    class TestCacheWriter
    extends CacheCallback
    implements CacheWriter {
        TestCacheWriter(boolean isAccessor) {
            this.isAccessor = isAccessor;
        }

        public void beforeCreate(EntryEvent event) throws CacheWriterException {
            RemoteTransactionDUnitTest.this.getGemfireCache().getLogger().info("SWAP:beforeCreate:" + event + " op:" + event.getOperation());
            this.verifyOrigin(event);
            this.verifyPutAll(event);
        }

        public void beforeUpdate(EntryEvent event) throws CacheWriterException {
            RemoteTransactionDUnitTest.this.getGemfireCache().getLogger().info("SWAP:beforeCreate:" + event + " op:" + event.getOperation());
            this.verifyOrigin(event);
            this.verifyPutAll(event);
        }

        public void beforeDestroy(EntryEvent event) throws CacheWriterException {
            this.verifyOrigin(event);
        }

        public void beforeRegionClear(RegionEvent event) throws CacheWriterException {
        }

        public void beforeRegionDestroy(RegionEvent event) throws CacheWriterException {
        }

        public void close() {
        }
    }

    class TestCacheListener
    extends CacheCallback
    implements CacheListener {
        TestCacheListener(boolean isAccessor) {
            this.isAccessor = isAccessor;
        }

        public void afterCreate(EntryEvent event) {
            this.verifyOrigin(event);
            this.verifyPutAll(event);
        }

        public void afterUpdate(EntryEvent event) {
            this.verifyOrigin(event);
            this.verifyPutAll(event);
        }

        public void afterDestroy(EntryEvent event) {
            this.verifyOrigin(event);
        }

        public void afterInvalidate(EntryEvent event) {
            this.verifyOrigin(event);
        }

        public void afterRegionClear(RegionEvent event) {
        }

        public void afterRegionCreate(RegionEvent event) {
        }

        public void afterRegionDestroy(RegionEvent event) {
        }

        public void afterRegionInvalidate(RegionEvent event) {
        }

        public void afterRegionLive(RegionEvent event) {
        }

        public void close() {
        }
    }

    abstract class CacheCallback {
        protected boolean isAccessor;
        protected Exception ex = null;

        CacheCallback() {
        }

        protected void verifyOrigin(EntryEvent event) {
            try {
                TestCase.assertEquals((!this.isAccessor ? 1 : 0) != 0, (boolean)event.isOriginRemote());
            }
            catch (Exception e) {
                this.ex = e;
            }
        }

        protected void verifyPutAll(EntryEvent event) {
            CustId knownCustId = new CustId(1);
            OrderId knownOrderId = new OrderId(2, knownCustId);
            if (event.getKey().equals(knownOrderId)) {
                try {
                    TestCase.assertTrue((boolean)event.getOperation().isPutAll());
                    TestCase.assertNotNull((Object)event.getTransactionId());
                }
                catch (Exception e) {
                    this.ex = e;
                }
            }
        }
    }

    protected class DoOpsInTX
    extends SerializableCallable {
        private final OP op;
        Customer expectedCust;
        Customer expectedRefCust = null;
        Order expectedOrder;
        Order expectedOrder2;
        Order expectedOrder3;

        DoOpsInTX(OP op) {
            this.op = op;
        }

        public Object call() throws Exception {
            TXManagerImpl mgr = RemoteTransactionDUnitTest.this.getGemfireCache().getTxManager();
            DistributedTestCase.getLogWriter().fine("testTXPut starting tx");
            mgr.begin();
            Region custRegion = RemoteTransactionDUnitTest.this.getCache().getRegion("custRegion");
            Region orderRegion = RemoteTransactionDUnitTest.this.getCache().getRegion("orderRegion");
            Region refRegion = RemoteTransactionDUnitTest.this.getCache().getRegion("distrReference");
            CustId custId = new CustId(1);
            OrderId orderId = new OrderId(1, custId);
            OrderId orderId2 = new OrderId(2, custId);
            OrderId orderId3 = new OrderId(3, custId);
            switch (this.op) {
                case PUT: {
                    this.expectedCust = new Customer("foo", "bar");
                    this.expectedOrder = new Order("fooOrder");
                    this.expectedOrder2 = new Order("fooOrder2");
                    this.expectedOrder3 = new Order("fooOrder3");
                    custRegion.put((Object)custId, (Object)this.expectedCust);
                    orderRegion.put((Object)orderId, (Object)this.expectedOrder);
                    HashMap<OrderId, Order> orders = new HashMap<OrderId, Order>();
                    orders.put(orderId2, this.expectedOrder2);
                    orders.put(orderId3, this.expectedOrder3);
                    RemoteTransactionDUnitTest.this.getGemfireCache().getLoggerI18n().fine("SWAP:doingPutAll");
                    refRegion.put((Object)custId, (Object)this.expectedCust);
                    HashSet<OrderId> ordersSet = new HashSet<OrderId>();
                    ordersSet.add(orderId);
                    ordersSet.add(orderId2);
                    ordersSet.add(orderId3);
                    break;
                }
                case GET: {
                    this.expectedCust = (Customer)custRegion.get((Object)custId);
                    this.expectedOrder = (Order)orderRegion.get((Object)orderId);
                    this.expectedRefCust = (Customer)refRegion.get((Object)custId);
                    TestCase.assertNotNull((Object)this.expectedCust);
                    TestCase.assertNotNull((Object)this.expectedOrder);
                    TestCase.assertNotNull((Object)this.expectedRefCust);
                    RemoteTransactionDUnitTest.this.validateContains(custId, Collections.singleton(orderId), true, true);
                    break;
                }
                case DESTROY: {
                    RemoteTransactionDUnitTest.this.validateContains(custId, Collections.singleton(orderId), true);
                    custRegion.destroy((Object)custId);
                    orderRegion.destroy((Object)orderId);
                    refRegion.destroy((Object)custId);
                    RemoteTransactionDUnitTest.this.validateContains(custId, Collections.singleton(orderId), false);
                    break;
                }
                case INVALIDATE: {
                    RemoteTransactionDUnitTest.this.validateContains(custId, Collections.singleton(orderId), true);
                    custRegion.invalidate((Object)custId);
                    orderRegion.invalidate((Object)orderId);
                    refRegion.invalidate((Object)custId);
                    RemoteTransactionDUnitTest.this.validateContains(custId, Collections.singleton(orderId), true, false);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            return mgr.getTransactionId();
        }
    }

    protected static enum OP {
        PUT,
        GET,
        DESTROY,
        INVALIDATE,
        KEYS,
        VALUES,
        ENTRIES,
        PUTALL,
        GETALL;

    }
}

