/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.MirrorType;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionExistsException;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionDUnitTestCase;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;

public class PartitionedRegionWithSameNameDUnitTest
extends PartitionedRegionDUnitTestCase {
    private static String prPrefix = null;
    static int MAX_REGIONS = 1;
    int redundancy = 0;
    int localMaxMemory = 200;
    VM[] vm = new VM[4];
    protected static final int DISTRIBUTED_REGION = 0;
    protected static final int PARTITIONED_REGION = 1;

    public PartitionedRegionWithSameNameDUnitTest(String name) {
        super(name);
    }

    public void testNameWithPartitionRegionFirstOnSameVM() {
        Host host = Host.getHost(0);
        this.createVMs(host);
        prPrefix = "testNameWithPartitionRegionFirstOnSameVM";
        int startIndexForRegion = 0;
        int endIndexForRegion = MAX_REGIONS;
        int startIndexForNode = 0;
        int endIndexForNode = 1;
        boolean firstCreationFlag = true;
        boolean multipleVMFlag = false;
        List vmList = this.addNodeToList(startIndexForNode, endIndexForNode);
        this.localMaxMemory = 200;
        this.redundancy = 1;
        firstCreationFlag = true;
        this.createPartitionRegion(vmList, startIndexForRegion, endIndexForRegion, this.localMaxMemory, this.redundancy, firstCreationFlag, multipleVMFlag);
        PartitionedRegionWithSameNameDUnitTest.getLogWriter().info("testNameWithPartitionRegionFirstOnSameVM() - Partition Regions successfully created ");
        startIndexForNode = 0;
        endIndexForNode = 1;
        firstCreationFlag = false;
        vmList = this.addNodeToList(startIndexForNode, endIndexForNode);
        this.createDistributedRegion(vmList, startIndexForRegion, endIndexForRegion, Scope.DISTRIBUTED_ACK, firstCreationFlag, multipleVMFlag);
        PartitionedRegionWithSameNameDUnitTest.getLogWriter().info("testNameWithPartitionRegionFirstOnSameVM() - test completed successfully ");
    }

    public void testNameWithDistributedRegionFirstOnSameVM() {
        Host host = Host.getHost(0);
        this.createVMs(host);
        prPrefix = "testNameWithLocalRegionFirstOnSameVM";
        int startIndexForRegion = 0;
        int endIndexForRegion = MAX_REGIONS;
        int startIndexForNode = 0;
        int endIndexForNode = 1;
        boolean firstCreationFlag = true;
        boolean multipleVMFlag = false;
        List vmList = this.addNodeToList(startIndexForNode, endIndexForNode);
        firstCreationFlag = true;
        this.createDistributedRegion(vmList, startIndexForRegion, endIndexForRegion, Scope.DISTRIBUTED_ACK, firstCreationFlag, multipleVMFlag);
        this.localMaxMemory = 200;
        this.redundancy = 1;
        firstCreationFlag = false;
        this.createPartitionRegion(vmList, startIndexForRegion, endIndexForRegion, this.localMaxMemory, this.redundancy, firstCreationFlag, multipleVMFlag);
        PartitionedRegionWithSameNameDUnitTest.getLogWriter().info("testNameWithPartitionRegionFirstOnSameVM() - test completed successfully ");
    }

    public void testNameWithPartitionRegionFirstOnDifferentVM() {
        Host host = Host.getHost(0);
        this.createVMs(host);
        prPrefix = "testNameWithPartitionRegionFirstOnDifferentVM";
        int startIndexForRegion = 0;
        int endIndexForRegion = MAX_REGIONS;
        int startIndexForNode = 0;
        int endIndexForNode = 1;
        boolean firstCreationFlag = true;
        boolean multipleVMFlag = true;
        List vmList = this.addNodeToList(startIndexForNode, endIndexForNode);
        this.localMaxMemory = 200;
        this.redundancy = 1;
        firstCreationFlag = true;
        this.createPartitionRegion(vmList, startIndexForRegion, endIndexForRegion, this.localMaxMemory, this.redundancy, firstCreationFlag, multipleVMFlag);
        PartitionedRegionWithSameNameDUnitTest.getLogWriter().info("testNameWithPartitionRegionFirstOnDifferentVM() - Partition Regions successfully created ");
        startIndexForRegion = 0;
        endIndexForRegion = MAX_REGIONS;
        startIndexForNode = 1;
        endIndexForNode = 4;
        firstCreationFlag = false;
        vmList = this.addNodeToList(startIndexForNode, endIndexForNode);
        this.createDistributedRegion(vmList, startIndexForRegion, endIndexForRegion, Scope.DISTRIBUTED_ACK, firstCreationFlag, multipleVMFlag);
        PartitionedRegionWithSameNameDUnitTest.getLogWriter().info("testNameWithPartitionRegionFirstOnDifferentVM() - test completed successfully ");
    }

    public void testNameWithDistributedRegionFirstOnDifferentVM() {
        Host host = Host.getHost(0);
        this.createVMs(host);
        prPrefix = "testNameWithLocalRegionFirstOnDifferentVM";
        int startIndexForRegion = 0;
        int endIndexForRegion = MAX_REGIONS;
        int startIndexForNode = 0;
        int endIndexForNode = 1;
        boolean firstCreationFlag = true;
        boolean multipleVMFlag = true;
        List vmList = this.addNodeToList(startIndexForNode, endIndexForNode);
        firstCreationFlag = true;
        this.createDistributedRegion(vmList, startIndexForRegion, endIndexForRegion, Scope.DISTRIBUTED_NO_ACK, firstCreationFlag, multipleVMFlag);
        startIndexForNode = 1;
        endIndexForNode = 4;
        vmList = this.addNodeToList(startIndexForNode, endIndexForNode);
        this.localMaxMemory = 200;
        this.redundancy = 1;
        firstCreationFlag = false;
        this.createPartitionRegion(vmList, startIndexForRegion, endIndexForRegion, this.localMaxMemory, this.redundancy, firstCreationFlag, multipleVMFlag);
        PartitionedRegionWithSameNameDUnitTest.getLogWriter().info("testNameWithLocalRegionFirstOnDifferentVM() - test completed successfully ");
    }

    public void testLocalRegionFirst() {
        Host host = Host.getHost(0);
        this.createVMs(host);
        prPrefix = "testPartitionRegionVsLocalRegionFirst";
        int startIndexForRegion = 0;
        int endIndexForRegion = MAX_REGIONS;
        int startIndexForNode = 0;
        int endIndexForNode = 1;
        boolean firstCreationFlag = true;
        boolean multipleVMFlag = true;
        List vmList = this.addNodeToList(startIndexForNode, endIndexForNode);
        firstCreationFlag = true;
        this.createDistributedRegion(vmList, startIndexForRegion, endIndexForRegion, Scope.LOCAL, firstCreationFlag, multipleVMFlag);
        startIndexForNode = 1;
        endIndexForNode = 4;
        vmList = this.addNodeToList(startIndexForNode, endIndexForNode);
        this.localMaxMemory = 200;
        this.redundancy = 1;
        firstCreationFlag = true;
        this.createPartitionRegion(vmList, startIndexForRegion, endIndexForRegion, this.localMaxMemory, this.redundancy, firstCreationFlag, multipleVMFlag);
        PartitionedRegionWithSameNameDUnitTest.getLogWriter().info("testPartitionRegionVsLocalRegionFirst() - test completed successfully ");
    }

    public void testLocalRegionSecond() {
        Host host = Host.getHost(0);
        this.createVMs(host);
        prPrefix = "testPartitionRegionVsLocalRegionSecond";
        int startIndexForRegion = 0;
        int endIndexForRegion = MAX_REGIONS;
        int startIndexForNode = 0;
        int endIndexForNode = 1;
        boolean firstCreationFlag = true;
        boolean multipleVMFlag = true;
        List vmList = this.addNodeToList(startIndexForNode, endIndexForNode);
        this.localMaxMemory = 200;
        this.redundancy = 1;
        firstCreationFlag = true;
        this.createPartitionRegion(vmList, startIndexForRegion, endIndexForRegion, this.localMaxMemory, this.redundancy, firstCreationFlag, multipleVMFlag);
        startIndexForNode = 1;
        endIndexForNode = 4;
        vmList = this.addNodeToList(startIndexForNode, endIndexForNode);
        firstCreationFlag = true;
        this.createDistributedRegion(vmList, startIndexForRegion, endIndexForRegion, Scope.LOCAL, firstCreationFlag, multipleVMFlag);
        PartitionedRegionWithSameNameDUnitTest.getLogWriter().info("testPartitionRegionVsLocalRegionSecond() - test completed successfully ");
    }

    public void testWithPartitionedRegionAsParentRegionAndDistributedSubRegion() {
        Host host = Host.getHost(0);
        this.createVMs(host);
        prPrefix = "parent_partitioned_region";
        int startIndexForRegion = 0;
        int endIndexForRegion = MAX_REGIONS;
        int startIndexForNode = 0;
        int endIndexForNode = 4;
        boolean firstCreationFlag = true;
        boolean multipleVMFlag = true;
        List vmList = this.addNodeToList(startIndexForNode, endIndexForNode);
        this.localMaxMemory = 200;
        this.redundancy = 1;
        firstCreationFlag = true;
        this.createPartitionRegion(vmList, startIndexForRegion, endIndexForRegion, this.localMaxMemory, this.redundancy, firstCreationFlag, multipleVMFlag);
        PartitionedRegionWithSameNameDUnitTest.getLogWriter().info("testWithPartitionedRegionAsParentRegionAndDistributedSubRegion() - Parent region as partitioned region is created ");
        this.createSubRegionOfPartitionedRegion(vmList, 0);
        PartitionedRegionWithSameNameDUnitTest.getLogWriter().info("testWithPartitionedRegionAsParentRegionAndDistributedSubRegion() completed Successfully ");
    }

    public void testWithPartitionedRegionAsParentRegionAndPartitionedSubRegion() {
        Host host = Host.getHost(0);
        this.createVMs(host);
        prPrefix = "parent_partitioned_region";
        int startIndexForRegion = 0;
        int endIndexForRegion = MAX_REGIONS;
        int startIndexForNode = 0;
        int endIndexForNode = 4;
        boolean firstCreationFlag = true;
        boolean multipleVMFlag = true;
        List vmList = this.addNodeToList(startIndexForNode, endIndexForNode);
        this.localMaxMemory = 200;
        this.redundancy = 1;
        firstCreationFlag = true;
        this.createPartitionRegion(vmList, startIndexForRegion, endIndexForRegion, this.localMaxMemory, this.redundancy, firstCreationFlag, multipleVMFlag);
        PartitionedRegionWithSameNameDUnitTest.getLogWriter().info("testWithPartitionedRegionAsParentRegionAndPartitionedSubRegion() - Parent region as partitioned region is created ");
        this.createSubRegionOfPartitionedRegion(vmList, 1);
        PartitionedRegionWithSameNameDUnitTest.getLogWriter().info("testWithPartitionedRegionAsParentRegionAndPartitionedSubRegion() completed Successfully ");
    }

    public void testWithSubRegionPartitionedRegionFirst() {
        Host host = Host.getHost(0);
        this.createVMs(host);
        prPrefix = "parent_region";
        int startIndexForRegion = 0;
        int endIndexForRegion = MAX_REGIONS;
        int startIndexForNode = 0;
        int endIndexForNode = 4;
        boolean firstCreationFlag = true;
        boolean multipleVMFlag = true;
        List vmList = this.addNodeToList(startIndexForNode, endIndexForNode);
        firstCreationFlag = true;
        this.createDistributedRegion(vmList, startIndexForRegion, endIndexForRegion, Scope.DISTRIBUTED_ACK, firstCreationFlag, multipleVMFlag);
        PartitionedRegionWithSameNameDUnitTest.getLogWriter().info("testWithSubRegionPartitionedRegionFirst() - Parent region is created");
        prPrefix = "child_region";
        startIndexForNode = 0;
        endIndexForNode = 1;
        vmList = this.addNodeToList(startIndexForNode, endIndexForNode);
        this.createPartitionedSubRegion(vmList, firstCreationFlag);
        PartitionedRegionWithSameNameDUnitTest.getLogWriter().info("testWithSubRegionPartitionedRegionFirst() - Partitioned sub region on vm0 ");
        firstCreationFlag = false;
        startIndexForNode = 1;
        endIndexForNode = 4;
        vmList = this.addNodeToList(startIndexForNode, endIndexForNode);
        this.createDistributedSubRegion(vmList, firstCreationFlag);
        PartitionedRegionWithSameNameDUnitTest.getLogWriter().info("testWithSubRegionPartitionedRegionFirst() completed successfully ");
    }

    public void testWithSubRegionDistributedRegionFirst() {
        Host host = Host.getHost(0);
        this.createVMs(host);
        prPrefix = "parent_region";
        int startIndexForRegion = 0;
        int endIndexForRegion = MAX_REGIONS;
        int startIndexForNode = 0;
        int endIndexForNode = 4;
        boolean firstCreationFlag = true;
        boolean multipleVMFlag = true;
        List vmList = this.addNodeToList(startIndexForNode, endIndexForNode);
        firstCreationFlag = true;
        this.createDistributedRegion(vmList, startIndexForRegion, endIndexForRegion, Scope.DISTRIBUTED_ACK, firstCreationFlag, multipleVMFlag);
        PartitionedRegionWithSameNameDUnitTest.getLogWriter().info("testWithSubRegionDistributedRegionFirst() - Parent region is created");
        prPrefix = "child_region";
        startIndexForNode = 0;
        endIndexForNode = 1;
        vmList = this.addNodeToList(startIndexForNode, endIndexForNode);
        this.createDistributedSubRegion(vmList, firstCreationFlag);
        PartitionedRegionWithSameNameDUnitTest.getLogWriter().info("testWithSubRegionDistributedRegionFirst() - Distributed sub region on vm0 ");
        firstCreationFlag = false;
        startIndexForNode = 1;
        endIndexForNode = 4;
        vmList = this.addNodeToList(startIndexForNode, endIndexForNode);
        this.createPartitionedSubRegion(vmList, firstCreationFlag);
        PartitionedRegionWithSameNameDUnitTest.getLogWriter().info("testWithSubRegionDistributedRegionFirst() completed successfully ");
    }

    private void createDistributedSubRegion(List vmList, boolean firstCreationFlag) {
        for (VM vm : vmList) {
            vm.invoke(this.createSubRegion(firstCreationFlag, 0));
        }
    }

    private void createPartitionedSubRegion(List vmList, boolean firstCreationFlag) {
        for (VM vm : vmList) {
            vm.invoke(this.createSubRegion(firstCreationFlag, 1));
        }
    }

    private void createSubRegionOfPartitionedRegion(List vmList, int regionType) {
        for (VM vm : vmList) {
            vm.invoke(this.SubRegionOfPartitonedRegion(regionType));
        }
    }

    private CacheSerializableRunnable SubRegionOfPartitonedRegion(final int regionType) {
        CacheSerializableRunnable subRegionOfPartiotionRegion = new CacheSerializableRunnable("subRegionOfPartiotionRegion"){
            int innerRegionType;
            {
                super(name);
                this.innerRegionType = regionType;
            }

            @Override
            public void run2() throws CacheException {
                Cache cache = PartitionedRegionWithSameNameDUnitTest.this.getCache();
                PartitionedRegion parentRegion = (PartitionedRegion)cache.getRegion("/parent_partitioned_region0");
                TestCase.assertNotNull((String)"Parent region cannot be null ", (Object)parentRegion);
                switch (this.innerRegionType) {
                    case 0: {
                        AttributesFactory af = new AttributesFactory();
                        af.setScope(Scope.DISTRIBUTED_ACK);
                        RegionAttributes ra = af.create();
                        try {
                            parentRegion.createSubregion("/child_region", ra);
                            TestCase.fail((String)"Distributed Subregion of partition region is created ");
                        }
                        catch (UnsupportedOperationException unsupportedOperationException) {}
                        break;
                    }
                    case 1: {
                        try {
                            parentRegion.createSubregion("child_region", PartitionedRegionWithSameNameDUnitTest.createRegionAttrsForPR(0, 200));
                            TestCase.fail((String)"Partitioneed Subregion of partition region is created ");
                            break;
                        }
                        catch (UnsupportedOperationException unsupportedOperationException) {
                            // empty catch block
                        }
                    }
                }
            }
        };
        return subRegionOfPartiotionRegion;
    }

    private CacheSerializableRunnable createSubRegion(final boolean firstCreationFlag, final int regionType) {
        CacheSerializableRunnable createSubRegion = new CacheSerializableRunnable("createSubRegion"){
            boolean innerFirstCreationFlag;
            int innerRegionType;
            {
                super(name);
                this.innerFirstCreationFlag = firstCreationFlag;
                this.innerRegionType = regionType;
            }

            @Override
            public void run2() throws CacheException {
                Cache cache = PartitionedRegionWithSameNameDUnitTest.this.getCache();
                AttributesFactory af = new AttributesFactory();
                af.setScope(Scope.DISTRIBUTED_ACK);
                RegionAttributes ra = af.create();
                Region parentRegion = cache.getRegion("/parent_region0");
                TestCase.assertNotNull((String)"Parent region is not null", (Object)parentRegion);
                if (this.innerFirstCreationFlag) {
                    switch (this.innerRegionType) {
                        case 0: {
                            Region childRegion = parentRegion.createSubregion("child_region", ra);
                            DistributedTestCase.getLogWriter().info("Distributed Subregion is created as : " + childRegion.getName());
                            break;
                        }
                        case 1: {
                            Region childRegion = parentRegion.createSubregion("child_region", PartitionedRegionWithSameNameDUnitTest.createRegionAttrsForPR(0, 200));
                            DistributedTestCase.getLogWriter().info("Partitioned Subregion is created as : " + childRegion.getName());
                        }
                    }
                } else {
                    switch (this.innerRegionType) {
                        case 0: {
                            String expectedExceptions = IllegalStateException.class.getName();
                            PartitionedRegionWithSameNameDUnitTest.this.getCache().getLogger().info("<ExpectedException action=add>" + expectedExceptions + "</ExpectedException>");
                            try {
                                parentRegion.createSubregion("child_region", ra);
                                TestCase.fail((String)"distributed subregion of the same name as partitioned region is created");
                            }
                            catch (IllegalStateException illegalStateException) {
                                // empty catch block
                            }
                            PartitionedRegionWithSameNameDUnitTest.this.getCache().getLogger().info("<ExpectedException action=remove>" + expectedExceptions + "</ExpectedException>");
                            break;
                        }
                        case 1: {
                            String expectedExceptions_pr = IllegalStateException.class.getName();
                            PartitionedRegionWithSameNameDUnitTest.this.getCache().getLogger().info("<ExpectedException action=add>" + expectedExceptions_pr + "</ExpectedException>");
                            try {
                                parentRegion.createSubregion("child_region", PartitionedRegionWithSameNameDUnitTest.createRegionAttrsForPR(0, 200));
                                TestCase.fail((String)"partitioned subregion of the same name as distributed region is created");
                            }
                            catch (IllegalStateException illegalStateException) {
                                // empty catch block
                            }
                            PartitionedRegionWithSameNameDUnitTest.this.getCache().getLogger().info("<ExpectedException action=remove>" + expectedExceptions_pr + "</ExpectedException>");
                        }
                    }
                }
            }
        };
        return createSubRegion;
    }

    private void createPartitionRegion(List vmList, int startIndexForRegion, int endIndexForRegion, int localMaxMemory, int redundancy, boolean firstCreationFlag, boolean multipleVMFlag) {
        for (VM vm : vmList) {
            vm.invoke(this.createMultiplePartitionRegion(prPrefix, startIndexForRegion, endIndexForRegion, redundancy, localMaxMemory, firstCreationFlag, multipleVMFlag));
        }
    }

    private void createDistributedRegion(List vmList, int startIndexForRegion, int endIndexForRegion, Scope scope, boolean firstCreationFlag, boolean multipleVMFlag) {
        for (VM vm : vmList) {
            vm.invoke(this.createMultipleDistributedlRegion(prPrefix, startIndexForRegion, endIndexForRegion, scope, firstCreationFlag, multipleVMFlag));
        }
    }

    CacheSerializableRunnable createMultipleDistributedlRegion(final String prPrefix, final int startIndexForRegion, final int endIndexForRegion, final Scope scope, final boolean firstCreationFlag, final boolean multipleVMFlag) {
        CacheSerializableRunnable createLocalRegion = new CacheSerializableRunnable("createDistributedRegion"){
            String innerPrPrefix;
            int innerStartIndexForRegion;
            int innerEndIndexForRegion;
            Scope innerScope;
            boolean innerFirstCreationFlag;
            {
                super(name);
                this.innerPrPrefix = prPrefix;
                this.innerStartIndexForRegion = startIndexForRegion;
                this.innerEndIndexForRegion = endIndexForRegion;
                this.innerScope = scope;
                this.innerFirstCreationFlag = firstCreationFlag;
            }

            @Override
            public void run2() throws CacheException {
                Cache cache = PartitionedRegionWithSameNameDUnitTest.this.getCache();
                AttributesFactory af = new AttributesFactory();
                af.setScope(this.innerScope);
                RegionAttributes ra = af.create();
                if (firstCreationFlag) {
                    for (int i = this.innerStartIndexForRegion; i < this.innerEndIndexForRegion; ++i) {
                        try {
                            cache.createRegion(this.innerPrPrefix + i, ra);
                            continue;
                        }
                        catch (RegionExistsException ex) {
                            DistributedTestCase.fail("Got incorrect exception because the partition region being created prior to local region", ex);
                        }
                    }
                } else {
                    for (int i = this.innerStartIndexForRegion; i < this.innerEndIndexForRegion; ++i) {
                        if (!multipleVMFlag) {
                            try {
                                cache.createRegion(this.innerPrPrefix + i, ra);
                                TestCase.fail((String)"test failed : Distributed region with same name as Partitioned region gets created");
                            }
                            catch (RegionExistsException ex) {}
                            continue;
                        }
                        String expectedExceptions = IllegalStateException.class.getName();
                        PartitionedRegionWithSameNameDUnitTest.this.getCache().getLogger().info("<ExpectedException action=add>" + expectedExceptions + "</ExpectedException>");
                        try {
                            cache.createRegion(this.innerPrPrefix + i, ra);
                            TestCase.fail((String)"test failed : Distributed region with same name as Partitioned region gets created");
                        }
                        catch (IllegalStateException illegalStateException) {
                            // empty catch block
                        }
                        PartitionedRegionWithSameNameDUnitTest.this.getCache().getLogger().info("<ExpectedException action=remove>" + expectedExceptions + "</ExpectedException>");
                    }
                }
            }
        };
        return createLocalRegion;
    }

    public CacheSerializableRunnable createMultiplePartitionRegion(final String PRPrefix, final int startIndexForRegion, final int endIndexForRegion, final int redundancy, final int localmaxMemory, final boolean firstCreationFlag, final boolean multipleVMFlag) {
        CacheSerializableRunnable createPRs = new CacheSerializableRunnable("createPrRegions"){
            String innerPRPrefix;
            int innerStartIndexForRegion;
            int innerEndIndexForRegion;
            int innerRedundancy;
            int innerlocalmaxMemory;
            {
                super(name);
                this.innerPRPrefix = PRPrefix;
                this.innerStartIndexForRegion = startIndexForRegion;
                this.innerEndIndexForRegion = endIndexForRegion;
                this.innerRedundancy = redundancy;
                this.innerlocalmaxMemory = localmaxMemory;
            }

            @Override
            public void run2() throws CacheException {
                Cache cache = PartitionedRegionWithSameNameDUnitTest.this.getCache();
                if (firstCreationFlag) {
                    for (int i = startIndexForRegion; i < endIndexForRegion; ++i) {
                        cache.createRegion(this.innerPRPrefix + i, PartitionedRegionWithSameNameDUnitTest.createRegionAttrsForPR(this.innerRedundancy, this.innerlocalmaxMemory));
                    }
                } else {
                    for (int i = startIndexForRegion; i < endIndexForRegion; ++i) {
                        if (!multipleVMFlag) {
                            try {
                                cache.createRegion(this.innerPRPrefix + i, PartitionedRegionWithSameNameDUnitTest.createRegionAttrsForPR(this.innerRedundancy, this.innerlocalmaxMemory));
                                TestCase.fail((String)"test failed : partition region with same name as local region is created");
                            }
                            catch (RegionExistsException regionExistsException) {}
                            continue;
                        }
                        String expectedExceptions = IllegalStateException.class.getName();
                        PartitionedRegionWithSameNameDUnitTest.this.getCache().getLogger().info("<ExpectedException action=add>" + expectedExceptions + "</ExpectedException>");
                        try {
                            cache.createRegion(this.innerPRPrefix + i, PartitionedRegionWithSameNameDUnitTest.createRegionAttrsForPR(this.innerRedundancy, this.innerlocalmaxMemory));
                            TestCase.fail((String)"test failed : partition region with same name as distributed region is created");
                        }
                        catch (IllegalStateException illegalStateException) {
                            // empty catch block
                        }
                        PartitionedRegionWithSameNameDUnitTest.this.getCache().getLogger().info("<ExpectedException action=remove>" + expectedExceptions + "</ExpectedException>");
                    }
                }
                DistributedTestCase.getLogWriter().info("createMultiplePartitionRegion() - Partition Regions Successfully Completed ");
            }
        };
        return createPRs;
    }

    public static RegionAttributes createRegionAttrsForPR(int red, int localMaxMem) {
        AttributesFactory attr = new AttributesFactory();
        attr.setMirrorType(MirrorType.NONE);
        PartitionAttributesFactory paf = new PartitionAttributesFactory();
        PartitionAttributes prAttr = paf.setRedundantCopies(red).setLocalMaxMemory(localMaxMem).create();
        attr.setPartitionAttributes(prAttr);
        return attr.create();
    }

    private void createVMs(Host host) {
        for (int i = 0; i < 4; ++i) {
            this.vm[i] = host.getVM(i);
        }
    }

    private List addNodeToList(int startIndexForNode, int endIndexForNode) {
        ArrayList<VM> localvmList = new ArrayList<VM>();
        for (int i = startIndexForNode; i < endIndexForNode; ++i) {
            localvmList.add(this.vm[i]);
        }
        return localvmList;
    }
}

