/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.PartitionResolver;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.client.internal.ClientMetadataService;
import com.gemstone.gemfire.cache.client.internal.ClientPartitionAdvisor;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.Locator;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.CustomerIDPartitionResolver;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.execute.data.CustId;
import com.gemstone.gemfire.internal.cache.execute.data.Customer;
import com.gemstone.gemfire.internal.cache.execute.data.Order;
import com.gemstone.gemfire.internal.cache.execute.data.OrderId;
import com.gemstone.gemfire.internal.cache.execute.data.Shipment;
import com.gemstone.gemfire.internal.cache.execute.data.ShipmentId;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerTestUtil;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public class PartitionedRegionSingleHopWithServerGroupDUnitTest
extends CacheTestCase {
    private static final long serialVersionUID = 1L;
    protected static final String PR_NAME = "single_hop_pr";
    protected static final String PR_NAME2 = "single_hop_pr_2";
    protected static final String PR_NAME3 = "single_hop_pr_3";
    private static final String CUSTOMER = "CUSTOMER";
    private static final String ORDER = "ORDER";
    private static final String SHIPMENT = "SHIPMENT";
    private static final String CUSTOMER2 = "CUSTOMER2";
    private static final String ORDER2 = "ORDER2";
    private static final String SHIPMENT2 = "SHIPMENT2";
    protected VM member0 = null;
    protected VM member1 = null;
    protected VM member2 = null;
    protected VM member3 = null;
    protected static Region region = null;
    protected static Region customerRegion = null;
    protected static Region orderRegion = null;
    protected static Region shipmentRegion = null;
    protected static Region region2 = null;
    protected static Region customerRegion2 = null;
    protected static Region orderRegion2 = null;
    protected static Region shipmentRegion2 = null;
    protected static Cache cache = null;
    protected static final int locatorPort = 12345;
    protected static Locator locator = null;

    public PartitionedRegionSingleHopWithServerGroupDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Host host = Host.getHost(0);
        this.member0 = host.getVM(0);
        this.member1 = host.getVM(1);
        this.member2 = host.getVM(2);
        this.member3 = host.getVM(3);
    }

    @Override
    public void tearDown2() throws Exception {
        try {
            this.member0.invoke(PartitionedRegionSingleHopWithServerGroupDUnitTest.class, "closeCache");
            this.member1.invoke(PartitionedRegionSingleHopWithServerGroupDUnitTest.class, "closeCache");
            this.member2.invoke(PartitionedRegionSingleHopWithServerGroupDUnitTest.class, "closeCache");
            this.member3.invoke(PartitionedRegionSingleHopWithServerGroupDUnitTest.class, "closeCache");
            PartitionedRegionSingleHopWithServerGroupDUnitTest.closeCache();
            super.tearDown2();
            this.member0 = null;
            this.member1 = null;
            this.member2 = null;
            this.member3 = null;
            PartitionedRegionSingleHopWithServerGroupDUnitTest.invokeInEveryVM(new SerializableRunnable(){

                @Override
                public void run() {
                    cache = null;
                    orderRegion = null;
                    orderRegion2 = null;
                    customerRegion = null;
                    customerRegion2 = null;
                    shipmentRegion = null;
                    shipmentRegion2 = null;
                    region = null;
                    region2 = null;
                    locator = null;
                }
            });
        }
        finally {
            PartitionedRegionSingleHopWithServerGroupDUnitTest.unregisterAllDataSerializersFromAllVms();
        }
    }

    public static void closeCache() {
        PartitionedRegionSingleHopWithServerGroupDUnitTest.resetHonourServerGroupsInPRSingleHop();
        if (cache != null && !cache.isClosed()) {
            cache.close();
            cache.getDistributedSystem().disconnect();
        }
    }

    public static void stopServer() {
        for (CacheServer cacheServer : cache.getCacheServers()) {
            cacheServer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_SingleHopWith2ServerGroup() {
        int port3 = AvailablePort.getRandomAvailablePort((int)0);
        String host0 = PartitionedRegionSingleHopWithServerGroupDUnitTest.getServerHostName(this.member3.getHost());
        String locator = host0 + "[" + port3 + "]";
        this.member3.invoke(PartitionedRegionSingleHopWithServerGroupDUnitTest.class, "startLocatorInVM", new Object[]{port3});
        try {
            this.member0.invoke(PartitionedRegionSingleHopWithServerGroupDUnitTest.class, "createServerWithLocatorAndServerGroup", new Object[]{locator, 100, 2, 8, "group1"});
            this.member1.invoke(PartitionedRegionSingleHopWithServerGroupDUnitTest.class, "createServerWithLocatorAndServerGroup", new Object[]{locator, 100, 2, 8, "group2"});
            this.member2.invoke(PartitionedRegionSingleHopWithServerGroupDUnitTest.class, "createServerWithLocatorAndServerGroup", new Object[]{locator, 100, 2, 8, "group2"});
            PartitionedRegionSingleHopWithServerGroupDUnitTest.setHonourServerGroupsInPRSingleHop();
            PartitionedRegionSingleHopWithServerGroupDUnitTest.createClientWithLocator(host0, port3, "group1");
            PartitionedRegionSingleHopWithServerGroupDUnitTest.putIntoPartitionedRegions();
            PartitionedRegionSingleHopWithServerGroupDUnitTest.getFromPartitionedRegions();
            try {
                PartitionedRegionSingleHopWithServerGroupDUnitTest.verifyMetadata(4, 1);
            }
            finally {
                PartitionedRegionSingleHopWithServerGroupDUnitTest.resetHonourServerGroupsInPRSingleHop();
            }
        }
        finally {
            this.member3.invoke(PartitionedRegionSingleHopWithServerGroupDUnitTest.class, "stopLocator");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_SingleHopWith2ServerGroup2() {
        int port3 = AvailablePort.getRandomAvailablePort((int)0);
        String host0 = PartitionedRegionSingleHopWithServerGroupDUnitTest.getServerHostName(this.member3.getHost());
        String locator = host0 + "[" + port3 + "]";
        this.member3.invoke(PartitionedRegionSingleHopWithServerGroupDUnitTest.class, "startLocatorInVM", new Object[]{port3});
        try {
            this.member0.invoke(PartitionedRegionSingleHopWithServerGroupDUnitTest.class, "createServerWithLocatorAndServerGroup", new Object[]{locator, 100, 2, 8, "group1"});
            this.member1.invoke(PartitionedRegionSingleHopWithServerGroupDUnitTest.class, "createServerWithLocatorAndServerGroup", new Object[]{locator, 100, 2, 8, "group1"});
            this.member2.invoke(PartitionedRegionSingleHopWithServerGroupDUnitTest.class, "createServerWithLocatorAndServerGroup", new Object[]{locator, 100, 2, 8, "group2"});
            PartitionedRegionSingleHopWithServerGroupDUnitTest.setHonourServerGroupsInPRSingleHop();
            PartitionedRegionSingleHopWithServerGroupDUnitTest.createClientWithLocator(host0, port3, "group1");
            PartitionedRegionSingleHopWithServerGroupDUnitTest.putIntoPartitionedRegions();
            PartitionedRegionSingleHopWithServerGroupDUnitTest.getFromPartitionedRegions();
            try {
                PartitionedRegionSingleHopWithServerGroupDUnitTest.verifyMetadata(4, 2);
            }
            finally {
                PartitionedRegionSingleHopWithServerGroupDUnitTest.resetHonourServerGroupsInPRSingleHop();
            }
        }
        finally {
            this.member3.invoke(PartitionedRegionSingleHopWithServerGroupDUnitTest.class, "stopLocator");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_SingleHopWith2ServerGroup2WithoutSystemProperty() {
        int port3 = AvailablePort.getRandomAvailablePort((int)0);
        String host0 = PartitionedRegionSingleHopWithServerGroupDUnitTest.getServerHostName(this.member3.getHost());
        String locator = host0 + "[" + port3 + "]";
        this.member3.invoke(PartitionedRegionSingleHopWithServerGroupDUnitTest.class, "startLocatorInVM", new Object[]{port3});
        try {
            this.member0.invoke(PartitionedRegionSingleHopWithServerGroupDUnitTest.class, "createServerWithLocatorAndServerGroup", new Object[]{locator, 100, 2, 8, "group1"});
            this.member1.invoke(PartitionedRegionSingleHopWithServerGroupDUnitTest.class, "createServerWithLocatorAndServerGroup", new Object[]{locator, 100, 2, 8, "group1"});
            this.member2.invoke(PartitionedRegionSingleHopWithServerGroupDUnitTest.class, "createServerWithLocatorAndServerGroup", new Object[]{locator, 100, 2, 8, "group2"});
            PartitionedRegionSingleHopWithServerGroupDUnitTest.createClientWithLocator(host0, port3, "group1");
            PartitionedRegionSingleHopWithServerGroupDUnitTest.putIntoPartitionedRegions();
            PartitionedRegionSingleHopWithServerGroupDUnitTest.getFromPartitionedRegions();
            PartitionedRegionSingleHopWithServerGroupDUnitTest.verifyMetadata(4, 3);
        }
        finally {
            this.member3.invoke(PartitionedRegionSingleHopWithServerGroupDUnitTest.class, "stopLocator");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_SingleHopWithServerGroupAccessor() {
        int port3 = AvailablePort.getRandomAvailablePort((int)0);
        String host0 = PartitionedRegionSingleHopWithServerGroupDUnitTest.getServerHostName(this.member3.getHost());
        String locator = host0 + "[" + port3 + "]";
        this.member3.invoke(PartitionedRegionSingleHopWithServerGroupDUnitTest.class, "startLocatorInVM", new Object[]{port3});
        try {
            this.member0.invoke(PartitionedRegionSingleHopWithServerGroupDUnitTest.class, "createServerWithLocatorAndServerGroup", new Object[]{locator, 0, 2, 8, "group1"});
            this.member1.invoke(PartitionedRegionSingleHopWithServerGroupDUnitTest.class, "createServerWithLocatorAndServerGroup", new Object[]{locator, 100, 2, 8, "group2"});
            this.member2.invoke(PartitionedRegionSingleHopWithServerGroupDUnitTest.class, "createServerWithLocatorAndServerGroup", new Object[]{locator, 100, 2, 8, "group2"});
            PartitionedRegionSingleHopWithServerGroupDUnitTest.setHonourServerGroupsInPRSingleHop();
            PartitionedRegionSingleHopWithServerGroupDUnitTest.createClientWithLocator(host0, port3, "group1");
            PartitionedRegionSingleHopWithServerGroupDUnitTest.putIntoPartitionedRegions();
            PartitionedRegionSingleHopWithServerGroupDUnitTest.getFromPartitionedRegions();
            try {
                PartitionedRegionSingleHopWithServerGroupDUnitTest.verifyMetadata(0, 0);
            }
            finally {
                PartitionedRegionSingleHopWithServerGroupDUnitTest.resetHonourServerGroupsInPRSingleHop();
            }
        }
        finally {
            this.member3.invoke(PartitionedRegionSingleHopWithServerGroupDUnitTest.class, "stopLocator");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_SingleHopWithServerGroupOneServerInTwoGroups() {
        int port3 = AvailablePort.getRandomAvailablePort((int)0);
        String host0 = PartitionedRegionSingleHopWithServerGroupDUnitTest.getServerHostName(this.member3.getHost());
        String locator = host0 + "[" + port3 + "]";
        this.member3.invoke(PartitionedRegionSingleHopWithServerGroupDUnitTest.class, "startLocatorInVM", new Object[]{port3});
        try {
            this.member0.invoke(PartitionedRegionSingleHopWithServerGroupDUnitTest.class, "createServerWithLocatorAndServerGroup", new Object[]{locator, 100, 2, 8, "group1"});
            this.member1.invoke(PartitionedRegionSingleHopWithServerGroupDUnitTest.class, "createServerWithLocatorAndServerGroup", new Object[]{locator, 100, 2, 8, "group1"});
            this.member2.invoke(PartitionedRegionSingleHopWithServerGroupDUnitTest.class, "createServerWithLocatorAndServerGroup", new Object[]{locator, 100, 2, 8, "group1,group2"});
            PartitionedRegionSingleHopWithServerGroupDUnitTest.setHonourServerGroupsInPRSingleHop();
            PartitionedRegionSingleHopWithServerGroupDUnitTest.createClientWithLocator(host0, port3, "group1");
            PartitionedRegionSingleHopWithServerGroupDUnitTest.putIntoPartitionedRegions();
            PartitionedRegionSingleHopWithServerGroupDUnitTest.getFromPartitionedRegions();
            try {
                PartitionedRegionSingleHopWithServerGroupDUnitTest.verifyMetadata(4, 3);
            }
            finally {
                PartitionedRegionSingleHopWithServerGroupDUnitTest.resetHonourServerGroupsInPRSingleHop();
            }
        }
        finally {
            this.member3.invoke(PartitionedRegionSingleHopWithServerGroupDUnitTest.class, "stopLocator");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_SingleHopWithServerGroupWithOneDefaultServer() {
        int port3 = AvailablePort.getRandomAvailablePort((int)0);
        String host0 = PartitionedRegionSingleHopWithServerGroupDUnitTest.getServerHostName(this.member3.getHost());
        String locator = host0 + "[" + port3 + "]";
        this.member3.invoke(PartitionedRegionSingleHopWithServerGroupDUnitTest.class, "startLocatorInVM", new Object[]{port3});
        try {
            this.member0.invoke(PartitionedRegionSingleHopWithServerGroupDUnitTest.class, "createServerWithLocatorAndServerGroup", new Object[]{locator, 100, 2, 8, "group1"});
            this.member1.invoke(PartitionedRegionSingleHopWithServerGroupDUnitTest.class, "createServerWithLocatorAndServerGroup", new Object[]{locator, 100, 2, 8, "group2"});
            this.member2.invoke(PartitionedRegionSingleHopWithServerGroupDUnitTest.class, "createServerWithLocatorAndServerGroup", new Object[]{locator, 100, 2, 8, ""});
            PartitionedRegionSingleHopWithServerGroupDUnitTest.setHonourServerGroupsInPRSingleHop();
            PartitionedRegionSingleHopWithServerGroupDUnitTest.createClientWithLocator(host0, port3, "group1");
            PartitionedRegionSingleHopWithServerGroupDUnitTest.putIntoPartitionedRegions();
            PartitionedRegionSingleHopWithServerGroupDUnitTest.getFromPartitionedRegions();
            try {
                PartitionedRegionSingleHopWithServerGroupDUnitTest.verifyMetadata(4, 2);
            }
            finally {
                PartitionedRegionSingleHopWithServerGroupDUnitTest.resetHonourServerGroupsInPRSingleHop();
            }
        }
        finally {
            this.member3.invoke(PartitionedRegionSingleHopWithServerGroupDUnitTest.class, "stopLocator");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_SingleHopWithServerGroupClientServerGroupNull() {
        int port3 = AvailablePort.getRandomAvailablePort((int)0);
        String host0 = PartitionedRegionSingleHopWithServerGroupDUnitTest.getServerHostName(this.member3.getHost());
        String locator = host0 + "[" + port3 + "]";
        this.member3.invoke(PartitionedRegionSingleHopWithServerGroupDUnitTest.class, "startLocatorInVM", new Object[]{port3});
        try {
            this.member0.invoke(PartitionedRegionSingleHopWithServerGroupDUnitTest.class, "createServerWithLocatorAndServerGroup", new Object[]{locator, 100, 2, 8, "group1"});
            this.member1.invoke(PartitionedRegionSingleHopWithServerGroupDUnitTest.class, "createServerWithLocatorAndServerGroup", new Object[]{locator, 100, 2, 8, "group2"});
            this.member2.invoke(PartitionedRegionSingleHopWithServerGroupDUnitTest.class, "createServerWithLocatorAndServerGroup", new Object[]{locator, 100, 2, 8, "group3"});
            PartitionedRegionSingleHopWithServerGroupDUnitTest.setHonourServerGroupsInPRSingleHop();
            PartitionedRegionSingleHopWithServerGroupDUnitTest.createClientWithLocator(host0, port3, "");
            PartitionedRegionSingleHopWithServerGroupDUnitTest.putIntoPartitionedRegions();
            PartitionedRegionSingleHopWithServerGroupDUnitTest.getFromPartitionedRegions();
            try {
                PartitionedRegionSingleHopWithServerGroupDUnitTest.verifyMetadata(4, 3);
            }
            finally {
                PartitionedRegionSingleHopWithServerGroupDUnitTest.resetHonourServerGroupsInPRSingleHop();
            }
        }
        finally {
            this.member3.invoke(PartitionedRegionSingleHopWithServerGroupDUnitTest.class, "stopLocator");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_SingleHopWithServerGroupTwoClientServerGroup() {
        int port3 = AvailablePort.getRandomAvailablePort((int)0);
        String host0 = PartitionedRegionSingleHopWithServerGroupDUnitTest.getServerHostName(this.member3.getHost());
        String locator = host0 + "[" + port3 + "]";
        this.member3.invoke(PartitionedRegionSingleHopWithServerGroupDUnitTest.class, "startLocatorInVM", new Object[]{port3});
        try {
            this.member0.invoke(PartitionedRegionSingleHopWithServerGroupDUnitTest.class, "createServerWithLocatorAndServerGroup", new Object[]{locator, 100, 2, 8, "group1"});
            this.member1.invoke(PartitionedRegionSingleHopWithServerGroupDUnitTest.class, "createServerWithLocatorAndServerGroup", new Object[]{locator, 100, 2, 8, "group2"});
            this.member2.invoke(PartitionedRegionSingleHopWithServerGroupDUnitTest.class, "setHonourServerGroupsInPRSingleHop", new Object[0]);
            this.member2.invoke(PartitionedRegionSingleHopWithServerGroupDUnitTest.class, "createClientWithLocator", new Object[]{host0, port3, "group1"});
            PartitionedRegionSingleHopWithServerGroupDUnitTest.setHonourServerGroupsInPRSingleHop();
            PartitionedRegionSingleHopWithServerGroupDUnitTest.createClientWithLocator(host0, port3, "");
            this.member2.invoke(PartitionedRegionSingleHopWithServerGroupDUnitTest.class, "putIntoPartitionedRegions", new Object[0]);
            PartitionedRegionSingleHopWithServerGroupDUnitTest.putIntoPartitionedRegions();
            PartitionedRegionSingleHopWithServerGroupDUnitTest.getFromPartitionedRegions();
            this.member2.invoke(PartitionedRegionSingleHopWithServerGroupDUnitTest.class, "getFromPartitionedRegions", new Object[0]);
            try {
                PartitionedRegionSingleHopWithServerGroupDUnitTest.verifyMetadata(4, 2);
                this.member2.invoke(PartitionedRegionSingleHopWithServerGroupDUnitTest.class, "verifyMetadata", new Object[]{new Integer(4), new Integer(1)});
            }
            finally {
                PartitionedRegionSingleHopWithServerGroupDUnitTest.resetHonourServerGroupsInPRSingleHop();
                this.member2.invoke(PartitionedRegionSingleHopWithServerGroupDUnitTest.class, "resetHonourServerGroupsInPRSingleHop", new Object[0]);
            }
        }
        finally {
            this.member3.invoke(PartitionedRegionSingleHopWithServerGroupDUnitTest.class, "stopLocator");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_SingleHopWithServerGroupTwoClientServerGroup2() {
        int port3 = AvailablePort.getRandomAvailablePort((int)0);
        String host0 = PartitionedRegionSingleHopWithServerGroupDUnitTest.getServerHostName(this.member3.getHost());
        String locator = host0 + "[" + port3 + "]";
        this.member3.invoke(PartitionedRegionSingleHopWithServerGroupDUnitTest.class, "startLocatorInVM", new Object[]{port3});
        try {
            this.member0.invoke(PartitionedRegionSingleHopWithServerGroupDUnitTest.class, "createServerWithLocatorAndServerGroup", new Object[]{locator, 100, 2, 8, "group1,group2"});
            this.member1.invoke(PartitionedRegionSingleHopWithServerGroupDUnitTest.class, "createServerWithLocatorAndServerGroup", new Object[]{locator, 100, 2, 8, "group2"});
            this.member2.invoke(PartitionedRegionSingleHopWithServerGroupDUnitTest.class, "setHonourServerGroupsInPRSingleHop", new Object[0]);
            this.member2.invoke(PartitionedRegionSingleHopWithServerGroupDUnitTest.class, "createClientWithLocator", new Object[]{host0, port3, "group1"});
            PartitionedRegionSingleHopWithServerGroupDUnitTest.setHonourServerGroupsInPRSingleHop();
            PartitionedRegionSingleHopWithServerGroupDUnitTest.createClientWithLocator(host0, port3, "group2");
            this.member2.invoke(PartitionedRegionSingleHopWithServerGroupDUnitTest.class, "putIntoPartitionedRegions", new Object[0]);
            PartitionedRegionSingleHopWithServerGroupDUnitTest.putIntoPartitionedRegions();
            this.member2.invoke(PartitionedRegionSingleHopWithServerGroupDUnitTest.class, "getFromPartitionedRegions", new Object[0]);
            PartitionedRegionSingleHopWithServerGroupDUnitTest.getFromPartitionedRegions();
            try {
                PartitionedRegionSingleHopWithServerGroupDUnitTest.verifyMetadata(4, 2);
                this.member2.invoke(PartitionedRegionSingleHopWithServerGroupDUnitTest.class, "verifyMetadata", new Object[]{new Integer(4), new Integer(1)});
            }
            finally {
                PartitionedRegionSingleHopWithServerGroupDUnitTest.resetHonourServerGroupsInPRSingleHop();
                this.member2.invoke(PartitionedRegionSingleHopWithServerGroupDUnitTest.class, "resetHonourServerGroupsInPRSingleHop", new Object[0]);
            }
        }
        finally {
            this.member3.invoke(PartitionedRegionSingleHopWithServerGroupDUnitTest.class, "stopLocator");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_SingleHopWithServerGroupTwoClientOneWithOneWithoutServerGroup() {
        int port3 = AvailablePort.getRandomAvailablePort((int)0);
        String host0 = PartitionedRegionSingleHopWithServerGroupDUnitTest.getServerHostName(this.member3.getHost());
        String locator = host0 + "[" + port3 + "]";
        this.member3.invoke(PartitionedRegionSingleHopWithServerGroupDUnitTest.class, "startLocatorInVM", new Object[]{port3});
        try {
            this.member0.invoke(PartitionedRegionSingleHopWithServerGroupDUnitTest.class, "createServerWithLocatorAndServerGroup", new Object[]{locator, 100, 2, 8, "group1,group2"});
            this.member1.invoke(PartitionedRegionSingleHopWithServerGroupDUnitTest.class, "createServerWithLocatorAndServerGroup", new Object[]{locator, 100, 2, 8, "group2"});
            this.member2.invoke(PartitionedRegionSingleHopWithServerGroupDUnitTest.class, "createClientWithLocator", new Object[]{host0, port3, "group1"});
            PartitionedRegionSingleHopWithServerGroupDUnitTest.setHonourServerGroupsInPRSingleHop();
            PartitionedRegionSingleHopWithServerGroupDUnitTest.createClientWithLocator(host0, port3, "group2");
            this.member2.invoke(PartitionedRegionSingleHopWithServerGroupDUnitTest.class, "putIntoPartitionedRegions", new Object[0]);
            PartitionedRegionSingleHopWithServerGroupDUnitTest.putIntoPartitionedRegions();
            this.member2.invoke(PartitionedRegionSingleHopWithServerGroupDUnitTest.class, "getFromPartitionedRegions", new Object[0]);
            PartitionedRegionSingleHopWithServerGroupDUnitTest.getFromPartitionedRegions();
            try {
                PartitionedRegionSingleHopWithServerGroupDUnitTest.verifyMetadata(4, 2);
                this.member2.invoke(PartitionedRegionSingleHopWithServerGroupDUnitTest.class, "verifyMetadata", new Object[]{new Integer(4), new Integer(2)});
            }
            finally {
                PartitionedRegionSingleHopWithServerGroupDUnitTest.resetHonourServerGroupsInPRSingleHop();
            }
        }
        finally {
            this.member3.invoke(PartitionedRegionSingleHopWithServerGroupDUnitTest.class, "stopLocator");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_SingleHopWithServerGroup2ClientInOneVMServerGroup() {
        int port3 = AvailablePort.getRandomAvailablePort((int)0);
        String host0 = PartitionedRegionSingleHopWithServerGroupDUnitTest.getServerHostName(this.member3.getHost());
        String locator = host0 + "[" + port3 + "]";
        this.member3.invoke(PartitionedRegionSingleHopWithServerGroupDUnitTest.class, "startLocatorInVM", new Object[]{port3});
        try {
            this.member0.invoke(PartitionedRegionSingleHopWithServerGroupDUnitTest.class, "createServerWithLocatorAndServerGroup2Regions", new Object[]{locator, 100, 2, 8, "group1,group2"});
            this.member1.invoke(PartitionedRegionSingleHopWithServerGroupDUnitTest.class, "createServerWithLocatorAndServerGroup2Regions", new Object[]{locator, 100, 2, 8, "group2"});
            this.member2.invoke(PartitionedRegionSingleHopWithServerGroupDUnitTest.class, "setHonourServerGroupsInPRSingleHop", new Object[0]);
            this.member2.invoke(PartitionedRegionSingleHopWithServerGroupDUnitTest.class, "create2ClientWithLocator", new Object[]{host0, port3, "group1", ""});
            PartitionedRegionSingleHopWithServerGroupDUnitTest.setHonourServerGroupsInPRSingleHop();
            PartitionedRegionSingleHopWithServerGroupDUnitTest.create2ClientWithLocator(host0, port3, "group2", "group1");
            this.member2.invoke(PartitionedRegionSingleHopWithServerGroupDUnitTest.class, "putIntoPartitionedRegions2Client", new Object[0]);
            PartitionedRegionSingleHopWithServerGroupDUnitTest.putIntoPartitionedRegions2Client();
            this.member2.invoke(PartitionedRegionSingleHopWithServerGroupDUnitTest.class, "getFromPartitionedRegions2Client", new Object[0]);
            PartitionedRegionSingleHopWithServerGroupDUnitTest.getFromPartitionedRegions2Client();
            try {
                PartitionedRegionSingleHopWithServerGroupDUnitTest.verifyMetadataFor2ClientsInOneVM(8, 2, 1);
                this.member2.invoke(PartitionedRegionSingleHopWithServerGroupDUnitTest.class, "verifyMetadataFor2ClientsInOneVM", new Object[]{new Integer(8), new Integer(1), new Integer(2)});
            }
            finally {
                PartitionedRegionSingleHopWithServerGroupDUnitTest.resetHonourServerGroupsInPRSingleHop();
                this.member2.invoke(PartitionedRegionSingleHopWithServerGroupDUnitTest.class, "resetHonourServerGroupsInPRSingleHop", new Object[0]);
            }
        }
        finally {
            this.member3.invoke(PartitionedRegionSingleHopWithServerGroupDUnitTest.class, "stopLocator");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_SingleHopWithServerGroupColocatedRegionsInDifferentGroup() {
        int port3 = AvailablePort.getRandomAvailablePort((int)0);
        String host0 = PartitionedRegionSingleHopWithServerGroupDUnitTest.getServerHostName(this.member3.getHost());
        String locator = host0 + "[" + port3 + "]";
        this.member3.invoke(PartitionedRegionSingleHopWithServerGroupDUnitTest.class, "startLocatorInVM", new Object[]{port3});
        try {
            this.member0.invoke(PartitionedRegionSingleHopWithServerGroupDUnitTest.class, "createServerWithLocatorAndServerGroup", new Object[]{locator, 100, 2, 8, "group1,group2"});
            this.member1.invoke(PartitionedRegionSingleHopWithServerGroupDUnitTest.class, "createServerWithLocatorAndServerGroup", new Object[]{locator, 100, 2, 8, "group2"});
            this.member2.invoke(PartitionedRegionSingleHopWithServerGroupDUnitTest.class, "createServerWithLocatorAndServerGroup", new Object[]{locator, 100, 2, 8, "group3"});
            PartitionedRegionSingleHopWithServerGroupDUnitTest.setHonourServerGroupsInPRSingleHop();
            PartitionedRegionSingleHopWithServerGroupDUnitTest.createClientWith3PoolLocator(host0, port3, "group2", "group1", "");
            PartitionedRegionSingleHopWithServerGroupDUnitTest.putIntoPartitionedRegions();
            PartitionedRegionSingleHopWithServerGroupDUnitTest.getFromPartitionedRegions();
            try {
                PartitionedRegionSingleHopWithServerGroupDUnitTest.verifyMetadataForColocatedRegionWithDiffPool(4, 2, 1, 3);
            }
            finally {
                PartitionedRegionSingleHopWithServerGroupDUnitTest.resetHonourServerGroupsInPRSingleHop();
            }
        }
        finally {
            this.member3.invoke(PartitionedRegionSingleHopWithServerGroupDUnitTest.class, "stopLocator");
        }
    }

    public static void verifyMetadata(final int numRegions, int numBucketLocations) {
        ClientMetadataService cms = ((GemFireCacheImpl)cache).getClientMetadataService();
        final Map regionMetaData = cms.getClientPRMetadata_TEST_ONLY();
        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return regionMetaData.size() == numRegions;
            }

            @Override
            public String description() {
                return "expected metadata for each region to be" + numRegions + " but it is " + regionMetaData.size() + "Metadata is " + regionMetaData.keySet();
            }
        };
        DistributedTestCase.waitForCriterion(wc, 60000L, 1000L, true);
        if (numRegions != 0) {
            PartitionedRegionSingleHopWithServerGroupDUnitTest.assertTrue((boolean)regionMetaData.containsKey(region.getFullPath()));
            ClientPartitionAdvisor prMetaData = (ClientPartitionAdvisor)regionMetaData.get(region.getFullPath());
            for (Map.Entry e : prMetaData.getBucketServerLocationsMap_TEST_ONLY().entrySet()) {
                cache.getLogger().fine("For bucket id " + e.getKey() + " the locations are " + e.getValue());
            }
            for (Map.Entry entry : prMetaData.getBucketServerLocationsMap_TEST_ONLY().entrySet()) {
                PartitionedRegionSingleHopWithServerGroupDUnitTest.assertEquals((int)numBucketLocations, (int)((List)entry.getValue()).size());
            }
        }
    }

    public static void verifyMetadataForColocatedRegionWithDiffPool(final int numRegions, int numBucketLocations, int numBucketLocations2, int numBucketLocations3) {
        ClientMetadataService cms = ((GemFireCacheImpl)cache).getClientMetadataService();
        final Map regionMetaData = cms.getClientPRMetadata_TEST_ONLY();
        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return regionMetaData.size() == numRegions;
            }

            @Override
            public String description() {
                return "expected metadata for each region to be " + numRegions + " but it is " + regionMetaData.size() + " they are " + regionMetaData.keySet();
            }
        };
        DistributedTestCase.waitForCriterion(wc, 120000L, 1000L, true);
        PartitionedRegionSingleHopWithServerGroupDUnitTest.assertTrue((boolean)regionMetaData.containsKey(region.getFullPath()));
        ClientPartitionAdvisor prMetaData = (ClientPartitionAdvisor)regionMetaData.get(region.getFullPath());
        for (Map.Entry e : prMetaData.getBucketServerLocationsMap_TEST_ONLY().entrySet()) {
            cache.getLogger().fine("For bucket id " + e.getKey() + " the locations are " + e.getValue());
        }
        for (Map.Entry entry : prMetaData.getBucketServerLocationsMap_TEST_ONLY().entrySet()) {
            PartitionedRegionSingleHopWithServerGroupDUnitTest.assertEquals((int)numBucketLocations, (int)((List)entry.getValue()).size());
        }
        PartitionedRegionSingleHopWithServerGroupDUnitTest.assertTrue((boolean)regionMetaData.containsKey(customerRegion.getFullPath()));
        prMetaData = (ClientPartitionAdvisor)regionMetaData.get(customerRegion.getFullPath());
        for (Map.Entry e : prMetaData.getBucketServerLocationsMap_TEST_ONLY().entrySet()) {
            cache.getLogger().fine("For bucket id " + e.getKey() + " the locations are " + e.getValue());
        }
        for (Map.Entry entry : prMetaData.getBucketServerLocationsMap_TEST_ONLY().entrySet()) {
            PartitionedRegionSingleHopWithServerGroupDUnitTest.assertEquals((int)numBucketLocations, (int)((List)entry.getValue()).size());
        }
        PartitionedRegionSingleHopWithServerGroupDUnitTest.assertTrue((boolean)regionMetaData.containsKey(orderRegion.getFullPath()));
        prMetaData = (ClientPartitionAdvisor)regionMetaData.get(orderRegion.getFullPath());
        for (Map.Entry e : prMetaData.getBucketServerLocationsMap_TEST_ONLY().entrySet()) {
            cache.getLogger().fine("For bucket id " + e.getKey() + " the locations are " + e.getValue());
        }
        for (Map.Entry entry : prMetaData.getBucketServerLocationsMap_TEST_ONLY().entrySet()) {
            PartitionedRegionSingleHopWithServerGroupDUnitTest.assertEquals((int)numBucketLocations2, (int)((List)entry.getValue()).size());
        }
        PartitionedRegionSingleHopWithServerGroupDUnitTest.assertTrue((boolean)regionMetaData.containsKey(shipmentRegion.getFullPath()));
        prMetaData = (ClientPartitionAdvisor)regionMetaData.get(shipmentRegion.getFullPath());
        for (Map.Entry e : prMetaData.getBucketServerLocationsMap_TEST_ONLY().entrySet()) {
            cache.getLogger().fine("For bucket id " + e.getKey() + " the locations are " + e.getValue());
        }
        for (Map.Entry entry : prMetaData.getBucketServerLocationsMap_TEST_ONLY().entrySet()) {
            PartitionedRegionSingleHopWithServerGroupDUnitTest.assertEquals((int)numBucketLocations3, (int)((List)entry.getValue()).size());
        }
    }

    public static void verifyMetadataFor2ClientsInOneVM(final int numRegions, int numBucketLocations, int numBucketLocations2) {
        ClientMetadataService cms = ((GemFireCacheImpl)cache).getClientMetadataService();
        final Map regionMetaData = cms.getClientPRMetadata_TEST_ONLY();
        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return regionMetaData.size() == numRegions;
            }

            @Override
            public String description() {
                return "expected metadata for each region to be " + numRegions + " but it is " + regionMetaData.size() + " they are " + regionMetaData.keySet();
            }
        };
        DistributedTestCase.waitForCriterion(wc, 120000L, 1000L, true);
        if (numRegions != 0) {
            PartitionedRegionSingleHopWithServerGroupDUnitTest.assertTrue((boolean)regionMetaData.containsKey(region.getFullPath()));
            ClientPartitionAdvisor prMetaData = (ClientPartitionAdvisor)regionMetaData.get(region.getFullPath());
            for (Map.Entry e : prMetaData.getBucketServerLocationsMap_TEST_ONLY().entrySet()) {
                cache.getLogger().fine("For bucket id " + e.getKey() + " the locations are " + e.getValue());
            }
            for (Map.Entry entry : prMetaData.getBucketServerLocationsMap_TEST_ONLY().entrySet()) {
                PartitionedRegionSingleHopWithServerGroupDUnitTest.assertEquals((int)numBucketLocations, (int)((List)entry.getValue()).size());
            }
            PartitionedRegionSingleHopWithServerGroupDUnitTest.assertTrue((boolean)regionMetaData.containsKey(customerRegion.getFullPath()));
            prMetaData = (ClientPartitionAdvisor)regionMetaData.get(customerRegion.getFullPath());
            for (Map.Entry e : prMetaData.getBucketServerLocationsMap_TEST_ONLY().entrySet()) {
                cache.getLogger().fine("For bucket id " + e.getKey() + " the locations are " + e.getValue());
            }
            for (Map.Entry entry : prMetaData.getBucketServerLocationsMap_TEST_ONLY().entrySet()) {
                PartitionedRegionSingleHopWithServerGroupDUnitTest.assertEquals((int)numBucketLocations, (int)((List)entry.getValue()).size());
            }
            PartitionedRegionSingleHopWithServerGroupDUnitTest.assertTrue((boolean)regionMetaData.containsKey(customerRegion2.getFullPath()));
            prMetaData = (ClientPartitionAdvisor)regionMetaData.get(customerRegion2.getFullPath());
            for (Map.Entry e : prMetaData.getBucketServerLocationsMap_TEST_ONLY().entrySet()) {
                cache.getLogger().fine("For bucket id " + e.getKey() + " the locations are " + e.getValue());
            }
            for (Map.Entry entry : prMetaData.getBucketServerLocationsMap_TEST_ONLY().entrySet()) {
                PartitionedRegionSingleHopWithServerGroupDUnitTest.assertEquals((int)numBucketLocations2, (int)((List)entry.getValue()).size());
            }
        }
    }

    public static int createServer(int redundantCopies, int totalNoofBuckets, String group) {
        PartitionedRegionSingleHopWithServerGroupDUnitTest test = new PartitionedRegionSingleHopWithServerGroupDUnitTest("PartitionedRegionSingleHopWithServerGroupDUnitTest");
        cache = test.getCache();
        CacheServer server = cache.addCacheServer();
        int port = AvailablePort.getRandomAvailablePort((int)0);
        server.setPort(port);
        server.setHostnameForClients("localhost");
        if (group.length() != 0) {
            server.setGroups(new String[]{group});
        }
        try {
            server.start();
        }
        catch (IOException e) {
            PartitionedRegionSingleHopWithServerGroupDUnitTest.fail("Failed to start server ", e);
        }
        PartitionAttributesFactory paf = new PartitionAttributesFactory();
        paf.setRedundantCopies(redundantCopies).setTotalNumBuckets(totalNoofBuckets);
        AttributesFactory attr = new AttributesFactory();
        attr.setPartitionAttributes(paf.create());
        region = cache.createRegion(PR_NAME, attr.create());
        PartitionedRegionSingleHopWithServerGroupDUnitTest.assertNotNull((Object)region);
        PartitionedRegionSingleHopWithServerGroupDUnitTest.getLogWriter().info("Partitioned Region single_hop_pr created Successfully :" + region.toString());
        paf = new PartitionAttributesFactory();
        paf.setRedundantCopies(redundantCopies).setTotalNumBuckets(totalNoofBuckets).setPartitionResolver((PartitionResolver)new CustomerIDPartitionResolver("CustomerIDPartitionResolver"));
        attr = new AttributesFactory();
        attr.setPartitionAttributes(paf.create());
        customerRegion = cache.createRegion(CUSTOMER, attr.create());
        PartitionedRegionSingleHopWithServerGroupDUnitTest.assertNotNull((Object)customerRegion);
        PartitionedRegionSingleHopWithServerGroupDUnitTest.getLogWriter().info("Partitioned Region CUSTOMER created Successfully :" + customerRegion.toString());
        paf = new PartitionAttributesFactory();
        paf.setRedundantCopies(redundantCopies).setTotalNumBuckets(totalNoofBuckets).setColocatedWith(CUSTOMER).setPartitionResolver((PartitionResolver)new CustomerIDPartitionResolver("CustomerIDPartitionResolver"));
        attr = new AttributesFactory();
        attr.setPartitionAttributes(paf.create());
        orderRegion = cache.createRegion(ORDER, attr.create());
        PartitionedRegionSingleHopWithServerGroupDUnitTest.assertNotNull((Object)orderRegion);
        PartitionedRegionSingleHopWithServerGroupDUnitTest.getLogWriter().info("Partitioned Region ORDER created Successfully :" + orderRegion.toString());
        paf = new PartitionAttributesFactory();
        paf.setRedundantCopies(redundantCopies).setTotalNumBuckets(totalNoofBuckets).setColocatedWith(ORDER).setPartitionResolver((PartitionResolver)new CustomerIDPartitionResolver("CustomerIDPartitionResolver"));
        attr = new AttributesFactory();
        attr.setPartitionAttributes(paf.create());
        shipmentRegion = cache.createRegion(SHIPMENT, attr.create());
        PartitionedRegionSingleHopWithServerGroupDUnitTest.assertNotNull((Object)shipmentRegion);
        PartitionedRegionSingleHopWithServerGroupDUnitTest.getLogWriter().info("Partitioned Region SHIPMENT created Successfully :" + shipmentRegion.toString());
        return port;
    }

    public static int createServerWithLocatorAndServerGroup(String locator, int localMaxMemory, int redundantCopies, int totalNoofBuckets, String group) {
        Properties props = new Properties();
        props = new Properties();
        props.setProperty("locators", locator);
        System.setProperty("gemfire.PoolImpl.honourServerGroupsInPRSingleHop", "true");
        PartitionedRegionSingleHopWithServerGroupDUnitTest test = new PartitionedRegionSingleHopWithServerGroupDUnitTest("PartitionedRegionSingleHopWithServerGroupDUnitTest");
        InternalDistributedSystem ds = test.getSystem(props);
        cache = CacheFactory.create((DistributedSystem)ds);
        CacheServer server = cache.addCacheServer();
        if (group.length() != 0) {
            StringTokenizer t = new StringTokenizer(group, ",");
            String[] a = new String[t.countTokens()];
            int i = 0;
            while (t.hasMoreTokens()) {
                a[i] = t.nextToken();
                ++i;
            }
            server.setGroups(a);
        }
        int port = AvailablePort.getRandomAvailablePort((int)0);
        server.setPort(port);
        server.setHostnameForClients("localhost");
        try {
            server.start();
        }
        catch (IOException e) {
            PartitionedRegionSingleHopWithServerGroupDUnitTest.fail("Failed to start server ", e);
        }
        PartitionAttributesFactory paf = new PartitionAttributesFactory();
        paf.setRedundantCopies(redundantCopies).setLocalMaxMemory(localMaxMemory).setTotalNumBuckets(totalNoofBuckets);
        AttributesFactory attr = new AttributesFactory();
        attr.setPartitionAttributes(paf.create());
        region = cache.createRegion(PR_NAME, attr.create());
        PartitionedRegionSingleHopWithServerGroupDUnitTest.assertNotNull((Object)region);
        PartitionedRegionSingleHopWithServerGroupDUnitTest.getLogWriter().info("Partitioned Region single_hop_pr created Successfully :" + region.toString());
        paf = new PartitionAttributesFactory();
        paf.setRedundantCopies(redundantCopies).setLocalMaxMemory(localMaxMemory).setTotalNumBuckets(totalNoofBuckets).setPartitionResolver((PartitionResolver)new CustomerIDPartitionResolver("CustomerIDPartitionResolver"));
        attr = new AttributesFactory();
        attr.setPartitionAttributes(paf.create());
        customerRegion = cache.createRegion(CUSTOMER, attr.create());
        PartitionedRegionSingleHopWithServerGroupDUnitTest.assertNotNull((Object)customerRegion);
        PartitionedRegionSingleHopWithServerGroupDUnitTest.getLogWriter().info("Partitioned Region CUSTOMER created Successfully :" + customerRegion.toString());
        paf = new PartitionAttributesFactory();
        paf.setRedundantCopies(redundantCopies).setLocalMaxMemory(localMaxMemory).setTotalNumBuckets(totalNoofBuckets).setColocatedWith(CUSTOMER).setPartitionResolver((PartitionResolver)new CustomerIDPartitionResolver("CustomerIDPartitionResolver"));
        attr = new AttributesFactory();
        attr.setPartitionAttributes(paf.create());
        orderRegion = cache.createRegion(ORDER, attr.create());
        PartitionedRegionSingleHopWithServerGroupDUnitTest.assertNotNull((Object)orderRegion);
        PartitionedRegionSingleHopWithServerGroupDUnitTest.getLogWriter().info("Partitioned Region ORDER created Successfully :" + orderRegion.toString());
        paf = new PartitionAttributesFactory();
        paf.setRedundantCopies(redundantCopies).setLocalMaxMemory(localMaxMemory).setTotalNumBuckets(totalNoofBuckets).setColocatedWith(ORDER).setPartitionResolver((PartitionResolver)new CustomerIDPartitionResolver("CustomerIDPartitionResolver"));
        attr = new AttributesFactory();
        attr.setPartitionAttributes(paf.create());
        shipmentRegion = cache.createRegion(SHIPMENT, attr.create());
        PartitionedRegionSingleHopWithServerGroupDUnitTest.assertNotNull((Object)shipmentRegion);
        PartitionedRegionSingleHopWithServerGroupDUnitTest.getLogWriter().info("Partitioned Region SHIPMENT created Successfully :" + shipmentRegion.toString());
        return port;
    }

    public static int createServerWithLocatorAndServerGroup2Regions(String locator, int localMaxMemory, int redundantCopies, int totalNoofBuckets, String group) {
        Properties props = new Properties();
        props = new Properties();
        props.setProperty("locators", locator);
        System.setProperty("gemfire.PoolImpl.honourServerGroupsInPRSingleHop", "true");
        PartitionedRegionSingleHopWithServerGroupDUnitTest test = new PartitionedRegionSingleHopWithServerGroupDUnitTest("PartitionedRegionSingleHopWithServerGroupDUnitTest");
        InternalDistributedSystem ds = test.getSystem(props);
        cache = CacheFactory.create((DistributedSystem)ds);
        CacheServer server = cache.addCacheServer();
        if (group.length() != 0) {
            StringTokenizer t = new StringTokenizer(group, ",");
            String[] a = new String[t.countTokens()];
            int i = 0;
            while (t.hasMoreTokens()) {
                a[i] = t.nextToken();
                ++i;
            }
            server.setGroups(a);
        }
        int port = AvailablePort.getRandomAvailablePort((int)0);
        server.setPort(port);
        server.setHostnameForClients("localhost");
        try {
            server.start();
        }
        catch (IOException e) {
            PartitionedRegionSingleHopWithServerGroupDUnitTest.fail("Failed to start server ", e);
        }
        PartitionAttributesFactory paf = new PartitionAttributesFactory();
        paf.setRedundantCopies(redundantCopies).setLocalMaxMemory(localMaxMemory).setTotalNumBuckets(totalNoofBuckets);
        AttributesFactory attr = new AttributesFactory();
        attr.setPartitionAttributes(paf.create());
        region = cache.createRegion(PR_NAME, attr.create());
        PartitionedRegionSingleHopWithServerGroupDUnitTest.assertNotNull((Object)region);
        PartitionedRegionSingleHopWithServerGroupDUnitTest.getLogWriter().info("Partitioned Region single_hop_pr created Successfully :" + region.toString());
        paf = new PartitionAttributesFactory();
        paf.setRedundantCopies(redundantCopies).setLocalMaxMemory(localMaxMemory).setTotalNumBuckets(totalNoofBuckets).setPartitionResolver((PartitionResolver)new CustomerIDPartitionResolver("CustomerIDPartitionResolver"));
        attr = new AttributesFactory();
        attr.setPartitionAttributes(paf.create());
        customerRegion = cache.createRegion(CUSTOMER, attr.create());
        PartitionedRegionSingleHopWithServerGroupDUnitTest.assertNotNull((Object)customerRegion);
        PartitionedRegionSingleHopWithServerGroupDUnitTest.getLogWriter().info("Partitioned Region CUSTOMER created Successfully :" + customerRegion.toString());
        paf = new PartitionAttributesFactory();
        paf.setRedundantCopies(redundantCopies).setLocalMaxMemory(localMaxMemory).setTotalNumBuckets(totalNoofBuckets).setPartitionResolver((PartitionResolver)new CustomerIDPartitionResolver("CustomerIDPartitionResolver"));
        attr = new AttributesFactory();
        attr.setPartitionAttributes(paf.create());
        orderRegion = cache.createRegion(ORDER, attr.create());
        PartitionedRegionSingleHopWithServerGroupDUnitTest.assertNotNull((Object)orderRegion);
        PartitionedRegionSingleHopWithServerGroupDUnitTest.getLogWriter().info("Partitioned Region ORDER created Successfully :" + orderRegion.toString());
        paf = new PartitionAttributesFactory();
        paf.setRedundantCopies(redundantCopies).setLocalMaxMemory(localMaxMemory).setTotalNumBuckets(totalNoofBuckets).setPartitionResolver((PartitionResolver)new CustomerIDPartitionResolver("CustomerIDPartitionResolver"));
        attr = new AttributesFactory();
        attr.setPartitionAttributes(paf.create());
        shipmentRegion = cache.createRegion(SHIPMENT, attr.create());
        PartitionedRegionSingleHopWithServerGroupDUnitTest.assertNotNull((Object)shipmentRegion);
        PartitionedRegionSingleHopWithServerGroupDUnitTest.getLogWriter().info("Partitioned Region SHIPMENT created Successfully :" + shipmentRegion.toString());
        paf = new PartitionAttributesFactory();
        paf.setRedundantCopies(redundantCopies).setLocalMaxMemory(localMaxMemory).setTotalNumBuckets(totalNoofBuckets);
        attr = new AttributesFactory();
        attr.setPartitionAttributes(paf.create());
        region2 = cache.createRegion(PR_NAME2, attr.create());
        PartitionedRegionSingleHopWithServerGroupDUnitTest.assertNotNull((Object)region2);
        PartitionedRegionSingleHopWithServerGroupDUnitTest.getLogWriter().info("Partitioned Region single_hop_pr_2 created Successfully :" + region2.toString());
        paf = new PartitionAttributesFactory();
        paf.setRedundantCopies(redundantCopies).setLocalMaxMemory(localMaxMemory).setTotalNumBuckets(totalNoofBuckets).setPartitionResolver((PartitionResolver)new CustomerIDPartitionResolver("CustomerIDPartitionResolver"));
        attr = new AttributesFactory();
        attr.setPartitionAttributes(paf.create());
        customerRegion2 = cache.createRegion(CUSTOMER2, attr.create());
        PartitionedRegionSingleHopWithServerGroupDUnitTest.assertNotNull((Object)customerRegion2);
        PartitionedRegionSingleHopWithServerGroupDUnitTest.getLogWriter().info("Partitioned Region CUSTOMER2 created Successfully :" + customerRegion2.toString());
        paf = new PartitionAttributesFactory();
        paf.setRedundantCopies(redundantCopies).setLocalMaxMemory(localMaxMemory).setTotalNumBuckets(totalNoofBuckets).setPartitionResolver((PartitionResolver)new CustomerIDPartitionResolver("CustomerIDPartitionResolver"));
        attr = new AttributesFactory();
        attr.setPartitionAttributes(paf.create());
        orderRegion2 = cache.createRegion(ORDER2, attr.create());
        PartitionedRegionSingleHopWithServerGroupDUnitTest.assertNotNull((Object)orderRegion2);
        PartitionedRegionSingleHopWithServerGroupDUnitTest.getLogWriter().info("Partitioned Region ORDER2 created Successfully :" + orderRegion2.toString());
        paf = new PartitionAttributesFactory();
        paf.setRedundantCopies(redundantCopies).setLocalMaxMemory(localMaxMemory).setTotalNumBuckets(totalNoofBuckets).setPartitionResolver((PartitionResolver)new CustomerIDPartitionResolver("CustomerIDPartitionResolver"));
        attr = new AttributesFactory();
        attr.setPartitionAttributes(paf.create());
        shipmentRegion2 = cache.createRegion(SHIPMENT2, attr.create());
        PartitionedRegionSingleHopWithServerGroupDUnitTest.assertNotNull((Object)shipmentRegion2);
        PartitionedRegionSingleHopWithServerGroupDUnitTest.getLogWriter().info("Partitioned Region SHIPMENT2 created Successfully :" + shipmentRegion2.toString());
        return port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createClientWithLocator(String host, int port0, String group) {
        Pool p;
        Properties props = new Properties();
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        PartitionedRegionSingleHopWithServerGroupDUnitTest test = new PartitionedRegionSingleHopWithServerGroupDUnitTest("PartitionedRegionSingleHopWithServerGroupDUnitTest");
        InternalDistributedSystem ds = test.getSystem(props);
        cache = CacheFactory.create((DistributedSystem)ds);
        PartitionedRegionSingleHopWithServerGroupDUnitTest.assertNotNull((Object)cache);
        CacheServerTestUtil.disableShufflingOfEndpoints();
        try {
            p = PoolManager.createFactory().addLocator(host, port0).setServerGroup(group).setPingInterval(250L).setSubscriptionEnabled(true).setSubscriptionRedundancy(-1).setReadTimeout(2000).setSocketBufferSize(1000).setMinConnections(6).setMaxConnections(10).setRetryAttempts(3).create(PR_NAME);
        }
        finally {
            CacheServerTestUtil.enableShufflingOfEndpoints();
        }
        PartitionedRegionSingleHopWithServerGroupDUnitTest.createRegionsInClientCache(p.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void create2ClientWithLocator(String host, int port0, String group1, String group2) {
        Pool p2;
        Pool p1;
        Properties props = new Properties();
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        PartitionedRegionSingleHopWithServerGroupDUnitTest test = new PartitionedRegionSingleHopWithServerGroupDUnitTest("PartitionedRegionSingleHopWithServerGroupDUnitTest");
        InternalDistributedSystem ds = test.getSystem(props);
        cache = CacheFactory.create((DistributedSystem)ds);
        PartitionedRegionSingleHopWithServerGroupDUnitTest.assertNotNull((Object)cache);
        CacheServerTestUtil.disableShufflingOfEndpoints();
        try {
            p1 = PoolManager.createFactory().addLocator(host, port0).setServerGroup(group1).setPingInterval(250L).setSubscriptionEnabled(true).setSubscriptionRedundancy(-1).setReadTimeout(2000).setSocketBufferSize(1000).setMinConnections(6).setMaxConnections(10).setRetryAttempts(3).create(PR_NAME);
            p2 = PoolManager.createFactory().addLocator(host, port0).setServerGroup(group2).setPingInterval(250L).setSubscriptionEnabled(true).setSubscriptionRedundancy(-1).setReadTimeout(2000).setSocketBufferSize(1000).setMinConnections(6).setMaxConnections(10).setRetryAttempts(3).create(PR_NAME2);
        }
        finally {
            CacheServerTestUtil.enableShufflingOfEndpoints();
        }
        PartitionedRegionSingleHopWithServerGroupDUnitTest.create2RegionsInClientCache(p1.getName(), p2.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createClientWith3PoolLocator(String host, int port0, String group1, String group2, String group3) {
        Pool p3;
        Pool p2;
        Pool p1;
        Properties props = new Properties();
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        PartitionedRegionSingleHopWithServerGroupDUnitTest test = new PartitionedRegionSingleHopWithServerGroupDUnitTest("PartitionedRegionSingleHopWithServerGroupDUnitTest");
        InternalDistributedSystem ds = test.getSystem(props);
        cache = CacheFactory.create((DistributedSystem)ds);
        PartitionedRegionSingleHopWithServerGroupDUnitTest.assertNotNull((Object)cache);
        CacheServerTestUtil.disableShufflingOfEndpoints();
        try {
            p1 = PoolManager.createFactory().addLocator(host, port0).setServerGroup(group1).setPingInterval(250L).setSubscriptionEnabled(true).setSubscriptionRedundancy(-1).setReadTimeout(2000).setSocketBufferSize(1000).setMinConnections(6).setMaxConnections(10).setRetryAttempts(3).create(PR_NAME);
            p2 = PoolManager.createFactory().addLocator(host, port0).setServerGroup(group2).setPingInterval(250L).setSubscriptionEnabled(true).setSubscriptionRedundancy(-1).setReadTimeout(2000).setSocketBufferSize(1000).setMinConnections(6).setMaxConnections(10).setRetryAttempts(3).create(PR_NAME2);
            p3 = PoolManager.createFactory().addLocator(host, port0).setServerGroup(group3).setPingInterval(250L).setSubscriptionEnabled(true).setSubscriptionRedundancy(-1).setReadTimeout(2000).setSocketBufferSize(1000).setMinConnections(6).setMaxConnections(10).setRetryAttempts(3).create(PR_NAME3);
        }
        finally {
            CacheServerTestUtil.enableShufflingOfEndpoints();
        }
        PartitionedRegionSingleHopWithServerGroupDUnitTest.createColocatedRegionsInClientCacheWithDiffPool(p1.getName(), p2.getName(), p3.getName());
    }

    private static void createRegionsInClientCache(String poolName) {
        AttributesFactory factory = new AttributesFactory();
        factory.setPoolName(poolName);
        factory.setDataPolicy(DataPolicy.EMPTY);
        RegionAttributes attrs = factory.create();
        region = cache.createRegion(PR_NAME, attrs);
        PartitionedRegionSingleHopWithServerGroupDUnitTest.assertNotNull((Object)region);
        PartitionedRegionSingleHopWithServerGroupDUnitTest.getLogWriter().info("Distributed Region single_hop_pr created Successfully :" + region.toString());
        factory = new AttributesFactory();
        factory.setPoolName(poolName);
        attrs = factory.create();
        customerRegion = cache.createRegion(CUSTOMER, attrs);
        PartitionedRegionSingleHopWithServerGroupDUnitTest.assertNotNull((Object)customerRegion);
        PartitionedRegionSingleHopWithServerGroupDUnitTest.getLogWriter().info("Distributed Region CUSTOMER created Successfully :" + customerRegion.toString());
        factory = new AttributesFactory();
        factory.setPoolName(poolName);
        attrs = factory.create();
        orderRegion = cache.createRegion(ORDER, attrs);
        PartitionedRegionSingleHopWithServerGroupDUnitTest.assertNotNull((Object)orderRegion);
        PartitionedRegionSingleHopWithServerGroupDUnitTest.getLogWriter().info("Distributed Region ORDER created Successfully :" + orderRegion.toString());
        factory = new AttributesFactory();
        factory.setPoolName(poolName);
        attrs = factory.create();
        shipmentRegion = cache.createRegion(SHIPMENT, attrs);
        PartitionedRegionSingleHopWithServerGroupDUnitTest.assertNotNull((Object)shipmentRegion);
        PartitionedRegionSingleHopWithServerGroupDUnitTest.getLogWriter().info("Distributed Region SHIPMENT created Successfully :" + shipmentRegion.toString());
    }

    private static void create2RegionsInClientCache(String poolName1, String poolName2) {
        AttributesFactory factory = new AttributesFactory();
        factory.setPoolName(poolName1);
        factory.setDataPolicy(DataPolicy.EMPTY);
        RegionAttributes attrs = factory.create();
        region = cache.createRegion(PR_NAME, attrs);
        PartitionedRegionSingleHopWithServerGroupDUnitTest.assertNotNull((Object)region);
        PartitionedRegionSingleHopWithServerGroupDUnitTest.getLogWriter().info("Distributed Region single_hop_pr created Successfully :" + region.toString());
        factory = new AttributesFactory();
        factory.setPoolName(poolName1);
        attrs = factory.create();
        customerRegion = cache.createRegion(CUSTOMER, attrs);
        PartitionedRegionSingleHopWithServerGroupDUnitTest.assertNotNull((Object)customerRegion);
        PartitionedRegionSingleHopWithServerGroupDUnitTest.getLogWriter().info("Distributed Region CUSTOMER created Successfully :" + customerRegion.toString());
        factory = new AttributesFactory();
        factory.setPoolName(poolName1);
        attrs = factory.create();
        orderRegion = cache.createRegion(ORDER, attrs);
        PartitionedRegionSingleHopWithServerGroupDUnitTest.assertNotNull((Object)orderRegion);
        PartitionedRegionSingleHopWithServerGroupDUnitTest.getLogWriter().info("Distributed Region ORDER created Successfully :" + orderRegion.toString());
        factory = new AttributesFactory();
        factory.setPoolName(poolName1);
        attrs = factory.create();
        shipmentRegion = cache.createRegion(SHIPMENT, attrs);
        PartitionedRegionSingleHopWithServerGroupDUnitTest.assertNotNull((Object)shipmentRegion);
        PartitionedRegionSingleHopWithServerGroupDUnitTest.getLogWriter().info("Distributed Region SHIPMENT created Successfully :" + shipmentRegion.toString());
        factory = new AttributesFactory();
        factory.setPoolName(poolName2);
        factory.setDataPolicy(DataPolicy.EMPTY);
        attrs = factory.create();
        region2 = cache.createRegion(PR_NAME2, attrs);
        PartitionedRegionSingleHopWithServerGroupDUnitTest.assertNotNull((Object)region2);
        PartitionedRegionSingleHopWithServerGroupDUnitTest.getLogWriter().info("Distributed Region single_hop_pr_2 created Successfully :" + region2.toString());
        factory = new AttributesFactory();
        factory.setPoolName(poolName2);
        attrs = factory.create();
        customerRegion2 = cache.createRegion(CUSTOMER2, attrs);
        PartitionedRegionSingleHopWithServerGroupDUnitTest.assertNotNull((Object)customerRegion2);
        PartitionedRegionSingleHopWithServerGroupDUnitTest.getLogWriter().info("Distributed Region CUSTOMER2 created Successfully :" + customerRegion2.toString());
        factory = new AttributesFactory();
        factory.setPoolName(poolName2);
        attrs = factory.create();
        orderRegion2 = cache.createRegion(ORDER2, attrs);
        PartitionedRegionSingleHopWithServerGroupDUnitTest.assertNotNull((Object)orderRegion2);
        PartitionedRegionSingleHopWithServerGroupDUnitTest.getLogWriter().info("Distributed Region ORDER2 created Successfully :" + orderRegion2.toString());
        factory = new AttributesFactory();
        factory.setPoolName(poolName2);
        attrs = factory.create();
        shipmentRegion2 = cache.createRegion(SHIPMENT2, attrs);
        PartitionedRegionSingleHopWithServerGroupDUnitTest.assertNotNull((Object)shipmentRegion2);
        PartitionedRegionSingleHopWithServerGroupDUnitTest.getLogWriter().info("Distributed Region SHIPMENT2 created Successfully :" + shipmentRegion2.toString());
    }

    private static void createColocatedRegionsInClientCacheWithDiffPool(String poolName1, String poolName2, String poolName3) {
        AttributesFactory factory = new AttributesFactory();
        factory.setPoolName(poolName1);
        factory.setDataPolicy(DataPolicy.EMPTY);
        RegionAttributes attrs = factory.create();
        region = cache.createRegion(PR_NAME, attrs);
        PartitionedRegionSingleHopWithServerGroupDUnitTest.assertNotNull((Object)region);
        PartitionedRegionSingleHopWithServerGroupDUnitTest.getLogWriter().info("Distributed Region single_hop_pr created Successfully :" + region.toString());
        factory = new AttributesFactory();
        factory.setPoolName(poolName1);
        attrs = factory.create();
        customerRegion = cache.createRegion(CUSTOMER, attrs);
        PartitionedRegionSingleHopWithServerGroupDUnitTest.assertNotNull((Object)customerRegion);
        PartitionedRegionSingleHopWithServerGroupDUnitTest.getLogWriter().info("Distributed Region CUSTOMER created Successfully :" + customerRegion.toString());
        factory = new AttributesFactory();
        factory.setPoolName(poolName2);
        attrs = factory.create();
        orderRegion = cache.createRegion(ORDER, attrs);
        PartitionedRegionSingleHopWithServerGroupDUnitTest.assertNotNull((Object)orderRegion);
        PartitionedRegionSingleHopWithServerGroupDUnitTest.getLogWriter().info("Distributed Region ORDER created Successfully :" + orderRegion.toString());
        factory = new AttributesFactory();
        factory.setPoolName(poolName3);
        attrs = factory.create();
        shipmentRegion = cache.createRegion(SHIPMENT, attrs);
        PartitionedRegionSingleHopWithServerGroupDUnitTest.assertNotNull((Object)shipmentRegion);
        PartitionedRegionSingleHopWithServerGroupDUnitTest.getLogWriter().info("Distributed Region SHIPMENT created Successfully :" + shipmentRegion.toString());
    }

    public static int createAccessorServer(int redundantCopies, int numBuckets, String group) {
        PartitionedRegionSingleHopWithServerGroupDUnitTest test = new PartitionedRegionSingleHopWithServerGroupDUnitTest("PartitionedRegionSingleHopWithServerGroupDUnitTest");
        cache = test.getCache();
        CacheServer server = cache.addCacheServer();
        int port = AvailablePort.getRandomAvailablePort((int)0);
        server.setPort(port);
        server.setHostnameForClients("localhost");
        if (group.length() != 0) {
            server.setGroups(new String[]{group});
        }
        try {
            server.start();
        }
        catch (IOException e) {
            PartitionedRegionSingleHopWithServerGroupDUnitTest.fail("Failed to start server ", e);
        }
        PartitionAttributesFactory paf = new PartitionAttributesFactory();
        paf.setRedundantCopies(redundantCopies).setTotalNumBuckets(numBuckets).setLocalMaxMemory(0);
        AttributesFactory attr = new AttributesFactory();
        attr.setPartitionAttributes(paf.create());
        region = cache.createRegion(PR_NAME, attr.create());
        PartitionedRegionSingleHopWithServerGroupDUnitTest.assertNotNull((Object)region);
        PartitionedRegionSingleHopWithServerGroupDUnitTest.getLogWriter().info("Partitioned Region single_hop_pr created Successfully :" + region.toString());
        paf = new PartitionAttributesFactory();
        paf.setRedundantCopies(redundantCopies).setTotalNumBuckets(numBuckets).setLocalMaxMemory(0).setPartitionResolver((PartitionResolver)new CustomerIDPartitionResolver("CustomerIDPartitionResolver"));
        attr = new AttributesFactory();
        attr.setPartitionAttributes(paf.create());
        customerRegion = cache.createRegion(CUSTOMER, attr.create());
        PartitionedRegionSingleHopWithServerGroupDUnitTest.assertNotNull((Object)customerRegion);
        PartitionedRegionSingleHopWithServerGroupDUnitTest.getLogWriter().info("Partitioned Region CUSTOMER created Successfully :" + customerRegion.toString());
        paf = new PartitionAttributesFactory();
        paf.setRedundantCopies(redundantCopies).setTotalNumBuckets(numBuckets).setLocalMaxMemory(0).setColocatedWith(CUSTOMER).setPartitionResolver((PartitionResolver)new CustomerIDPartitionResolver("CustomerIDPartitionResolver"));
        attr = new AttributesFactory();
        attr.setPartitionAttributes(paf.create());
        orderRegion = cache.createRegion(ORDER, attr.create());
        PartitionedRegionSingleHopWithServerGroupDUnitTest.assertNotNull((Object)orderRegion);
        PartitionedRegionSingleHopWithServerGroupDUnitTest.getLogWriter().info("Partitioned Region ORDER created Successfully :" + orderRegion.toString());
        paf = new PartitionAttributesFactory();
        paf.setRedundantCopies(redundantCopies).setTotalNumBuckets(numBuckets).setLocalMaxMemory(0).setColocatedWith(ORDER).setPartitionResolver((PartitionResolver)new CustomerIDPartitionResolver("CustomerIDPartitionResolver"));
        attr = new AttributesFactory();
        attr.setPartitionAttributes(paf.create());
        shipmentRegion = cache.createRegion(SHIPMENT, attr.create());
        PartitionedRegionSingleHopWithServerGroupDUnitTest.assertNotNull((Object)shipmentRegion);
        PartitionedRegionSingleHopWithServerGroupDUnitTest.getLogWriter().info("Partitioned Region SHIPMENT created Successfully :" + shipmentRegion.toString());
        return port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createClientWithLocatorWithoutSystemProperty(String host, int port0, String group) {
        Pool p;
        Properties props = new Properties();
        props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        PartitionedRegionSingleHopWithServerGroupDUnitTest test = new PartitionedRegionSingleHopWithServerGroupDUnitTest("PartitionedRegionSingleHopWithServerGroupDUnitTest");
        InternalDistributedSystem ds = test.getSystem(props);
        cache = CacheFactory.create((DistributedSystem)ds);
        PartitionedRegionSingleHopWithServerGroupDUnitTest.assertNotNull((Object)cache);
        CacheServerTestUtil.disableShufflingOfEndpoints();
        try {
            p = PoolManager.createFactory().addLocator(host, port0).setServerGroup(group).setPingInterval(250L).setSubscriptionEnabled(true).setSubscriptionRedundancy(-1).setReadTimeout(2000).setSocketBufferSize(1000).setMinConnections(6).setMaxConnections(10).setRetryAttempts(3).create(PR_NAME);
        }
        finally {
            CacheServerTestUtil.enableShufflingOfEndpoints();
        }
        PartitionedRegionSingleHopWithServerGroupDUnitTest.createRegionsInClientCache(p.getName());
    }

    public static void putIntoPartitionedRegions() {
        OrderId orderId;
        CustId custid;
        for (int i = 0; i <= 800; ++i) {
            custid = new CustId(i);
            Customer customer = new Customer("name" + i, "Address" + i);
            customerRegion.put((Object)custid, (Object)customer);
        }
        for (int j = 0; j <= 800; ++j) {
            custid = new CustId(j);
            orderId = new OrderId(j, custid);
            Order order = new Order("OREDR" + j);
            orderRegion.put((Object)orderId, (Object)order);
        }
        for (int k = 0; k <= 800; ++k) {
            custid = new CustId(k);
            orderId = new OrderId(k, custid);
            ShipmentId shipmentId = new ShipmentId(k, orderId);
            Shipment shipment = new Shipment("Shipment" + k);
            shipmentRegion.put((Object)shipmentId, (Object)shipment);
        }
        region.put((Object)new Integer(0), (Object)"create0");
        region.put((Object)new Integer(1), (Object)"create1");
        region.put((Object)new Integer(2), (Object)"create2");
        region.put((Object)new Integer(3), (Object)"create3");
        region.put((Object)new Integer(4), (Object)"create0");
        region.put((Object)new Integer(5), (Object)"create1");
        region.put((Object)new Integer(6), (Object)"create2");
        region.put((Object)new Integer(7), (Object)"create3");
        region.put((Object)new Integer(0), (Object)"update0");
        region.put((Object)new Integer(1), (Object)"update1");
        region.put((Object)new Integer(2), (Object)"update2");
        region.put((Object)new Integer(3), (Object)"update3");
        region.put((Object)new Integer(4), (Object)"update0");
        region.put((Object)new Integer(5), (Object)"update1");
        region.put((Object)new Integer(6), (Object)"update2");
        region.put((Object)new Integer(7), (Object)"update3");
        region.put((Object)new Integer(0), (Object)"update00");
        region.put((Object)new Integer(1), (Object)"update11");
        region.put((Object)new Integer(2), (Object)"update22");
        region.put((Object)new Integer(3), (Object)"update33");
        region.put((Object)new Integer(4), (Object)"update00");
        region.put((Object)new Integer(5), (Object)"update11");
        region.put((Object)new Integer(6), (Object)"update22");
        region.put((Object)new Integer(7), (Object)"update33");
    }

    public static void putIntoPartitionedRegions2Client() {
        OrderId orderId;
        CustId custid;
        for (int i = 0; i <= 800; ++i) {
            custid = new CustId(i);
            Customer customer = new Customer("name" + i, "Address" + i);
            customerRegion.put((Object)custid, (Object)customer);
            customerRegion2.put((Object)custid, (Object)customer);
        }
        for (int j = 0; j <= 800; ++j) {
            custid = new CustId(j);
            orderId = new OrderId(j, custid);
            Order order = new Order("OREDR" + j);
            orderRegion.put((Object)orderId, (Object)order);
            orderRegion2.put((Object)orderId, (Object)order);
        }
        for (int k = 0; k <= 800; ++k) {
            custid = new CustId(k);
            orderId = new OrderId(k, custid);
            ShipmentId shipmentId = new ShipmentId(k, orderId);
            Shipment shipment = new Shipment("Shipment" + k);
            shipmentRegion.put((Object)shipmentId, (Object)shipment);
            shipmentRegion2.put((Object)shipmentId, (Object)shipment);
        }
        region.put((Object)new Integer(0), (Object)"create0");
        region.put((Object)new Integer(1), (Object)"create1");
        region.put((Object)new Integer(2), (Object)"create2");
        region.put((Object)new Integer(3), (Object)"create3");
        region.put((Object)new Integer(4), (Object)"create0");
        region.put((Object)new Integer(5), (Object)"create1");
        region.put((Object)new Integer(6), (Object)"create2");
        region.put((Object)new Integer(7), (Object)"create3");
        region.put((Object)new Integer(0), (Object)"update0");
        region.put((Object)new Integer(1), (Object)"update1");
        region.put((Object)new Integer(2), (Object)"update2");
        region.put((Object)new Integer(3), (Object)"update3");
        region.put((Object)new Integer(4), (Object)"update0");
        region.put((Object)new Integer(5), (Object)"update1");
        region.put((Object)new Integer(6), (Object)"update2");
        region.put((Object)new Integer(7), (Object)"update3");
        region.put((Object)new Integer(0), (Object)"update00");
        region.put((Object)new Integer(1), (Object)"update11");
        region.put((Object)new Integer(2), (Object)"update22");
        region.put((Object)new Integer(3), (Object)"update33");
        region.put((Object)new Integer(4), (Object)"update00");
        region.put((Object)new Integer(5), (Object)"update11");
        region.put((Object)new Integer(6), (Object)"update22");
        region.put((Object)new Integer(7), (Object)"update33");
        region2.put((Object)new Integer(0), (Object)"create0");
        region2.put((Object)new Integer(1), (Object)"create1");
        region2.put((Object)new Integer(2), (Object)"create2");
        region2.put((Object)new Integer(3), (Object)"create3");
        region2.put((Object)new Integer(4), (Object)"create0");
        region2.put((Object)new Integer(5), (Object)"create1");
        region2.put((Object)new Integer(6), (Object)"create2");
        region2.put((Object)new Integer(7), (Object)"create3");
        region2.put((Object)new Integer(0), (Object)"update0");
        region2.put((Object)new Integer(1), (Object)"update1");
        region2.put((Object)new Integer(2), (Object)"update2");
        region2.put((Object)new Integer(3), (Object)"update3");
        region2.put((Object)new Integer(4), (Object)"update0");
        region2.put((Object)new Integer(5), (Object)"update1");
        region2.put((Object)new Integer(6), (Object)"update2");
        region2.put((Object)new Integer(7), (Object)"update3");
        region2.put((Object)new Integer(0), (Object)"update00");
        region2.put((Object)new Integer(1), (Object)"update11");
        region2.put((Object)new Integer(2), (Object)"update22");
        region2.put((Object)new Integer(3), (Object)"update33");
        region2.put((Object)new Integer(4), (Object)"update00");
        region2.put((Object)new Integer(5), (Object)"update11");
        region2.put((Object)new Integer(6), (Object)"update22");
        region2.put((Object)new Integer(7), (Object)"update33");
    }

    public static void getFromPartitionedRegions() {
        OrderId orderId;
        CustId custid;
        for (int i = 0; i <= 800; ++i) {
            custid = new CustId(i);
            customerRegion.get((Object)custid);
        }
        for (int j = 0; j <= 800; ++j) {
            custid = new CustId(j);
            orderId = new OrderId(j, custid);
            orderRegion.get((Object)orderId);
        }
        for (int k = 0; k <= 800; ++k) {
            custid = new CustId(k);
            orderId = new OrderId(k, custid);
            ShipmentId shipmentId = new ShipmentId(k, orderId);
            shipmentRegion.get((Object)shipmentId);
        }
        region.get((Object)new Integer(0));
        region.get((Object)new Integer(1));
        region.get((Object)new Integer(2));
        region.get((Object)new Integer(3));
        region.get((Object)new Integer(4));
        region.get((Object)new Integer(5));
        region.get((Object)new Integer(6));
        region.get((Object)new Integer(7));
    }

    public static void getFromPartitionedRegions2Client() {
        OrderId orderId;
        CustId custid;
        for (int i = 0; i <= 800; ++i) {
            custid = new CustId(i);
            customerRegion.get((Object)custid);
            customerRegion2.get((Object)custid);
        }
        for (int j = 0; j <= 800; ++j) {
            custid = new CustId(j);
            orderId = new OrderId(j, custid);
            orderRegion.get((Object)orderId);
            orderRegion2.get((Object)orderId);
        }
        for (int k = 0; k <= 800; ++k) {
            custid = new CustId(k);
            orderId = new OrderId(k, custid);
            ShipmentId shipmentId = new ShipmentId(k, orderId);
            shipmentRegion.get((Object)shipmentId);
            shipmentRegion2.get((Object)shipmentId);
        }
        region.get((Object)new Integer(0));
        region.get((Object)new Integer(1));
        region.get((Object)new Integer(2));
        region.get((Object)new Integer(3));
        region.get((Object)new Integer(4));
        region.get((Object)new Integer(5));
        region.get((Object)new Integer(6));
        region.get((Object)new Integer(7));
        region2.get((Object)new Integer(0));
        region2.get((Object)new Integer(1));
        region2.get((Object)new Integer(2));
        region2.get((Object)new Integer(3));
        region2.get((Object)new Integer(4));
        region2.get((Object)new Integer(5));
        region2.get((Object)new Integer(6));
        region.get((Object)new Integer(7));
    }

    public static void startLocatorInVM(int locatorPort) {
        File logFile = new File("locator-" + locatorPort + ".log");
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        try {
            locator = Locator.startLocatorAndDS((int)locatorPort, (File)logFile, null, (Properties)props);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void stopLocator() {
        locator.stop();
    }

    public static void resetHonourServerGroupsInPRSingleHop() {
        System.setProperty("gemfire.PoolImpl.honourServerGroupsInPRSingleHop", "False");
    }

    public static void setHonourServerGroupsInPRSingleHop() {
        System.setProperty("gemfire.PoolImpl.honourServerGroupsInPRSingleHop", "True");
    }
}

