/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.internal.cache.PartitionRegionConfig;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionDUnitTestCase;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import junit.framework.TestCase;

public class PartitionedRegionPRIDDUnitTest
extends PartitionedRegionDUnitTestCase {
    public static final int MAX_REGIONS = 1;
    int localMaxMemory = 200;
    VM[] vm = new VM[4];

    public PartitionedRegionPRIDDUnitTest(String name) {
        super(name);
    }

    public void testPRIDGenerationInMultiplePartitionRegion() throws Exception {
        int count;
        Host host = Host.getHost(0);
        this.createVMs(host);
        String prPrefix = "testBucketCreationInMultiPlePartitionRegion";
        int startIndexForRegion = 0;
        int endIndexForRegion = 1;
        ArrayList vmList = new ArrayList();
        int startIndexForNode = 0;
        int endIndexForNode = 3;
        this.addNodeToList(vmList, startIndexForNode, endIndexForNode);
        this.localMaxMemory = 200;
        boolean redundancy = false;
        this.createPartitionRegion(vmList, startIndexForRegion, endIndexForRegion, this.localMaxMemory, 0, prPrefix);
        PartitionedRegionPRIDDUnitTest.getLogWriter().info("testPRIDGenerationInMultiplePartitionRegion() - Partition regions on 3 nodes successfully created");
        startIndexForRegion = 1;
        endIndexForRegion = 2;
        startIndexForNode = 0;
        endIndexForNode = 4;
        this.addNodeToList(vmList, startIndexForNode, endIndexForNode);
        this.localMaxMemory = 200;
        boolean pr2_redundancy = true;
        this.createPartitionRegion(vmList, startIndexForRegion, endIndexForRegion, this.localMaxMemory, 1, prPrefix);
        PartitionedRegionPRIDDUnitTest.getLogWriter().info("testPRIDGenerationInMultiplePartitionRegion() - Partition regions on 4 nodes successfully created");
        int AsyncInvocationArrSize = 4;
        AsyncInvocation[] async = new AsyncInvocation[AsyncInvocationArrSize];
        async[0] = this.vm[0].invokeAsync(this.validatePRIDCreation(0, endIndexForRegion, prPrefix));
        async[1] = this.vm[1].invokeAsync(this.validatePRIDCreation(0, endIndexForRegion, prPrefix));
        async[2] = this.vm[2].invokeAsync(this.validatePRIDCreation(0, endIndexForRegion, prPrefix));
        async[3] = this.vm[3].invokeAsync(this.validatePRIDCreation(1, endIndexForRegion, prPrefix));
        for (count = 0; count < AsyncInvocationArrSize; ++count) {
            DistributedTestCase.join(async[count], 30000L, PartitionedRegionPRIDDUnitTest.getLogWriter());
        }
        for (count = 0; count < AsyncInvocationArrSize; ++count) {
            if (!async[count].exceptionOccurred()) continue;
            PartitionedRegionPRIDDUnitTest.fail("VM " + count + " encountered this exception during async invocation", async[count].getException());
        }
    }

    private CacheSerializableRunnable validatePRIDCreation(final int startIndexForRegion, final int endIndexForRegion, final String prPrefix) {
        CacheSerializableRunnable validatePRID = new CacheSerializableRunnable("validatePRIDCreation"){
            String innerPrPrefix;
            {
                super(name);
                this.innerPrPrefix = prPrefix;
            }

            @Override
            public void run2() {
                TreeSet prIdPRSet;
                int noPartitionRegions = endIndexForRegion - startIndexForRegion;
                Cache cache = PartitionedRegionPRIDDUnitTest.this.getCache();
                Region root = cache.getRegion("/__PR");
                TestCase.assertNotNull((String)"Root region can not be null", (Object)root);
                ArrayList<String> prIdList = new ArrayList<String>();
                for (int i = startIndexForRegion; i < endIndexForRegion; ++i) {
                    String rName = "/" + this.innerPrPrefix + i;
                    PartitionedRegion pr = (PartitionedRegion)cache.getRegion(rName);
                    TestCase.assertNotNull((String)("This Partitioned Region " + rName + " cannot be null"), (Object)pr);
                    PartitionRegionConfig prConfig = (PartitionRegionConfig)root.get((Object)pr.getRegionIdentifier());
                    TestCase.assertNotNull((String)("PRConfig for Partitioned Region " + rName + " can not be null"), (Object)prConfig);
                    prIdList.add(Integer.toString(prConfig.getPRId()));
                }
                TreeSet prIdSet = new TreeSet(prIdList);
                if (prIdSet.size() != prIdList.size()) {
                    TestCase.fail((String)"Duplicate PRID are generated");
                }
                Iterator prIdSetItr = prIdSet.iterator();
                while (prIdSetItr.hasNext()) {
                    int val = Integer.parseInt((String)prIdSetItr.next());
                    if (!(val > noPartitionRegions - 1 & val < 0)) continue;
                    TestCase.fail((String)"PRID limit is out of range");
                }
                if (prIdSet.size() != noPartitionRegions) {
                    TestCase.fail((String)("Different PRID generated equal to " + prIdSet.size()));
                }
                if (PartitionedRegion.prIdToPR.size() != noPartitionRegions) {
                    TestCase.fail((String)("number of entries in the prIdToPR is " + PartitionedRegion.prIdToPR.size()));
                }
                if ((prIdPRSet = new TreeSet(PartitionedRegion.prIdToPR.keySet())).size() != PartitionedRegion.prIdToPR.size()) {
                    TestCase.fail((String)"Duplicate PRID are generated in prIdToPR");
                }
                DistributedTestCase.getLogWriter().info("Size of allPartition region : " + prIdSet.size());
                DistributedTestCase.getLogWriter().info("Size of prIdToPR region     : " + prIdPRSet.size());
                DistributedTestCase.getLogWriter().info("PRID generated successfully");
            }
        };
        return validatePRID;
    }

    private void createPartitionRegion(List vmList, int startIndexForRegion, int endIndexForRegion, int localMaxMemory, int redundancy, String prPrefix) throws Exception {
        int i;
        int AsyncInvocationArrSize = 4;
        AsyncInvocation[] async = new AsyncInvocation[AsyncInvocationArrSize];
        int numNodes = 0;
        for (VM vm : vmList) {
            async[numNodes] = vm.invokeAsync(this.createMultiplePartitionRegion(prPrefix, startIndexForRegion, endIndexForRegion, redundancy, localMaxMemory));
            ++numNodes;
        }
        for (i = 0; i < numNodes; ++i) {
            DistributedTestCase.join(async[i], 30000L, PartitionedRegionPRIDDUnitTest.getLogWriter());
        }
        for (i = 0; i < numNodes; ++i) {
            if (!async[i].exceptionOccurred()) continue;
            PartitionedRegionPRIDDUnitTest.fail("VM " + i + " encountered this exception during async invocation", async[i].getException());
        }
    }

    private void addNodeToList(List vmList, int startIndexForNode, int endIndexForNode) {
        vmList.clear();
        for (int i = startIndexForNode; i < endIndexForNode; ++i) {
            vmList.add(this.vm[i]);
        }
    }

    private void createVMs(Host host) {
        for (int i = 0; i < 4; ++i) {
            this.vm[i] = host.getVM(i);
        }
    }
}

