/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.EvictionAction;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.RegionExistsException;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.internal.LogWriterImpl;
import com.gemstone.gemfire.internal.PureLogWriter;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionTestHelper;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import hydra.log.AnyLogWriter;
import junit.framework.TestCase;

public class PartitionedRegionDUnitTestCase
extends CacheTestCase {
    static int oldLogLevel;
    static String oldVerbose;

    public void setVMInfoLogLevel() {
        SerializableRunnable runnable = new SerializableRunnable(){

            @Override
            public void run() {
                oldVerbose = System.getProperty("DistributionManager.VERBOSE", "false");
                DistributionManager.VERBOSE = false;
                System.setProperty("DistributionManager.VERBOSE", "false");
                oldLogLevel = PartitionedRegionDUnitTestCase.setLogLevel(PartitionedRegionDUnitTestCase.this.getCache().getLogger(), 800);
            }
        };
        for (int i = 0; i < 4; ++i) {
            Host.getHost(0).getVM(i).invoke(runnable);
        }
    }

    public void resetVMLogLevel() {
        SerializableRunnable runnable = new SerializableRunnable(){

            @Override
            public void run() {
                System.setProperty("DistributionManager.VERBOSE", oldVerbose);
                DistributionManager.VERBOSE = oldVerbose.equals("true");
                PartitionedRegionDUnitTestCase.setLogLevel(PartitionedRegionDUnitTestCase.this.getCache().getLogger(), oldLogLevel);
            }
        };
        for (int i = 0; i < 4; ++i) {
            Host.getHost(0).getVM(i).invoke(runnable);
        }
    }

    public static int setLogLevel(LogWriter l, int logLevl) {
        int ret = -1;
        l.config("PartitionedRegionDUnitTest attempting to set log level on LogWriter instance class:" + l.getClass().getName());
        if (l instanceof PureLogWriter) {
            PureLogWriter pl = (PureLogWriter)l;
            ret = pl.getLevel();
            l.config("PartitiionedRegionDUnitTest forcing log level to " + LogWriterImpl.levelToString((int)logLevl) + " from " + LogWriterImpl.levelToString((int)ret));
            pl.setLevel(logLevl);
        } else if (l instanceof AnyLogWriter) {
            AnyLogWriter al = (AnyLogWriter)l;
            ret = al.getLevel();
            l.config("PartitiionedRegionDUnitTest forcing log level to " + LogWriterImpl.levelToString((int)logLevl) + " from " + LogWriterImpl.levelToString((int)ret));
            al.setLevel(logLevl);
        }
        return ret;
    }

    public PartitionedRegionDUnitTestCase(String name) {
        super(name);
    }

    @Override
    public void tearDown2() throws Exception {
        try {
            PartitionedRegionDUnitTestCase.closeCache();
            PartitionedRegionDUnitTestCase.invokeInEveryVM(CacheTestCase.class, "closeCache");
        }
        finally {
            super.tearDown2();
        }
    }

    public static void caseSetUp() {
        PartitionedRegionDUnitTestCase.disconnectAllFromDS();
    }

    public static void caseTearDown() {
        PartitionedRegionDUnitTestCase.disconnectAllFromDS();
    }

    public CacheSerializableRunnable createMultiplePartitionRegion(String PRPrefix, int startIndexForRegion, int endIndexForRegion, int redundancy, int localmaxMemory) {
        return this.createMultiplePartitionRegion(PRPrefix, startIndexForRegion, endIndexForRegion, redundancy, localmaxMemory, false);
    }

    public CacheSerializableRunnable createMultiplePartitionRegion(final String PRPrefix, final int startIndexForRegion, final int endIndexForRegion, final int redundancy, final int localmaxMemory, final boolean evict) {
        return new CacheSerializableRunnable("createPrRegions_" + PRPrefix){
            String innerPRPrefix;
            int innerStartIndexForRegion;
            int innerEndIndexForRegion;
            int innerRedundancy;
            int innerlocalmaxMemory;
            {
                super(name);
                this.innerPRPrefix = PRPrefix;
                this.innerStartIndexForRegion = startIndexForRegion;
                this.innerEndIndexForRegion = endIndexForRegion;
                this.innerRedundancy = redundancy;
                this.innerlocalmaxMemory = localmaxMemory;
            }

            @Override
            public void run2() throws CacheException {
                System.setProperty("gemfire.partitionedRegionRetryTimeout", "20000");
                EvictionAttributes evictionAttrs = evict ? EvictionAttributes.createLRUEntryAttributes((int)Integer.MAX_VALUE, (EvictionAction)EvictionAction.LOCAL_DESTROY) : null;
                for (int i = startIndexForRegion; i < endIndexForRegion; ++i) {
                    Region partitionedregion = PartitionedRegionDUnitTestCase.this.getCache().createRegion(this.innerPRPrefix + i, PartitionedRegionDUnitTestCase.this.createRegionAttrsForPR(this.innerRedundancy, this.innerlocalmaxMemory, -1L, evictionAttrs));
                    PartitionedRegionDUnitTestCase.this.getCache().getLogger().info("Successfully created PartitionedRegion = " + partitionedregion);
                }
                System.setProperty("gemfire.partitionedRegionRetryTimeout", Integer.toString(3600000));
                PartitionedRegionDUnitTestCase.this.getCache().getLogger().info("createMultiplePartitionRegion() - Partition Regions Successfully Completed ");
            }
        };
    }

    protected RegionAttributes<?, ?> createRegionAttrsForPR(int red, int localMaxMem, long recoveryDelay, EvictionAttributes evictionAttrs) {
        return PartitionedRegionTestHelper.createRegionAttrsForPR((int)red, (int)localMaxMem, (long)recoveryDelay, (EvictionAttributes)evictionAttrs);
    }

    public CacheSerializableRunnable getCreateMultiplePRregion(final String prPrefix, final int maxIndex, final int redundancy, final int localmaxMemory, final long recoveryDelay) {
        return new CacheSerializableRunnable("getCreateMultiplePRregion"){

            @Override
            public void run2() throws CacheException {
                for (int i = 0; i < maxIndex; ++i) {
                    try {
                        PartitionedRegionDUnitTestCase.this.getCache().createRegion(prPrefix + i, PartitionedRegionTestHelper.createRegionAttrsForPR((int)redundancy, (int)localmaxMemory, (long)recoveryDelay));
                        DistributedTestCase.getLogWriter().info("Created Region  new  --- " + prPrefix + i);
                        continue;
                    }
                    catch (RegionExistsException regionExistsException) {
                        // empty catch block
                    }
                }
                DistributedTestCase.getLogWriter().info("getCreateMultiplePRregion() - Partition Regions Successfully Completed ");
            }
        };
    }

    public CacheSerializableRunnable validateMultiplePartitionRegion(final String PRPrefix, final int startIndexForRegion, final int endIndexForRegion) {
        CacheSerializableRunnable validateAllPRs = new CacheSerializableRunnable("validateAllPRs"){
            String innerPRPrefix;
            int innerStartIndexForRegion;
            int innerEndIndexForRegion;
            {
                super(name);
                this.innerPRPrefix = PRPrefix;
                this.innerStartIndexForRegion = startIndexForRegion;
                this.innerEndIndexForRegion = endIndexForRegion;
            }

            @Override
            public void run2() throws CacheException {
                Region rootRegion = PartitionedRegionDUnitTestCase.this.getCache().getRegion("__PR");
                TestCase.assertNotNull((Object)rootRegion);
                TestCase.assertEquals((String)"PR root size is not correct", (int)this.innerEndIndexForRegion, (int)rootRegion.size());
                TestCase.assertEquals((String)"prIdToPR size is not correct", (int)this.innerEndIndexForRegion, (int)PartitionedRegion.prIdToPR.size());
                PartitionedRegionDUnitTestCase.this.getCache().getLogger().info("validateMultiplePartitionRegion() - Partition Regions Successfully Validated ");
            }
        };
        return validateAllPRs;
    }

    public CacheSerializableRunnable putInMultiplePartitionRegion(final String PRPrefix, final int startIndexForKey, final int endIndexForKey, final int startIndexNumOfRegions, final int endIndexNumOfRegions) {
        CacheSerializableRunnable putInPRs = new CacheSerializableRunnable("doPutOperations"){
            String innerPRPrefix;
            int innerStartIndexForKey;
            int innerEndIndexForKey;
            int innerStartIndexNumOfRegions;
            int innerEndIndexNumOfRegions;
            {
                super(name);
                this.innerPRPrefix = PRPrefix;
                this.innerStartIndexForKey = startIndexForKey;
                this.innerEndIndexForKey = endIndexForKey;
                this.innerStartIndexNumOfRegions = startIndexNumOfRegions;
                this.innerEndIndexNumOfRegions = endIndexNumOfRegions;
            }

            @Override
            public void run2() throws CacheException {
                for (int j = this.innerStartIndexNumOfRegions; j < this.innerEndIndexNumOfRegions; ++j) {
                    Region pr = PartitionedRegionDUnitTestCase.this.getCache().getRegion("/" + this.innerPRPrefix + j);
                    TestCase.assertNotNull((Object)pr);
                    for (int k = this.innerStartIndexForKey; k < this.innerEndIndexForKey; ++k) {
                        pr.put((Object)(j + this.innerPRPrefix + k), (Object)(this.innerPRPrefix + k));
                    }
                    PartitionedRegionDUnitTestCase.this.getCache().getLogger().info("putInMultiplePartitionRegion() - Put() done Successfully in Partition Region " + pr.getName());
                }
            }
        };
        return putInPRs;
    }

    public CacheSerializableRunnable getInMultiplePartitionRegion(final String PRPrefix, final int startIndexForKey, final int endIndexForKey, final int startIndexNumOfRegions, final int endIndexNumOfRegions) {
        CacheSerializableRunnable getInPRs = new CacheSerializableRunnable("doGetOperations"){
            String innerPRPrefix;
            int innerStartIndexForKey;
            int innerEndIndexForKey;
            int innerStartIndexNumOfRegions;
            int innerEndIndexNumOfRegions;
            {
                super(name);
                this.innerPRPrefix = PRPrefix;
                this.innerStartIndexForKey = startIndexForKey;
                this.innerEndIndexForKey = endIndexForKey;
                this.innerStartIndexNumOfRegions = startIndexNumOfRegions;
                this.innerEndIndexNumOfRegions = endIndexNumOfRegions;
            }

            @Override
            public void run2() throws CacheException {
                for (int j = this.innerStartIndexNumOfRegions; j < this.innerEndIndexNumOfRegions; ++j) {
                    Region pr = PartitionedRegionDUnitTestCase.this.getCache().getRegion("/" + this.innerPRPrefix + j);
                    TestCase.assertNotNull((Object)pr);
                    for (int k = this.innerStartIndexForKey; k < this.innerEndIndexForKey; ++k) {
                        Object Obj = pr.get((Object)(j + this.innerPRPrefix + k));
                        TestCase.assertNotNull((Object)Obj);
                        TestCase.assertEquals((String)"Values are not equal", (Object)Obj, (Object)(this.innerPRPrefix + k));
                    }
                    PartitionedRegionDUnitTestCase.this.getCache().getLogger().info("putInMultiplePartitionRegion() - Get() done Successfully in Partition Region " + pr.getName());
                }
            }
        };
        return getInPRs;
    }

    public CacheSerializableRunnable putAfterDestroyInMultiplePartitionedRegion(final String PRPrefix, final int startIndexForKey, final int endIndexForKey, final int startIndexNumOfRegions, final int endIndexNumOfRegions) {
        CacheSerializableRunnable putInPRs = new CacheSerializableRunnable("doPutAfterDestroyOperations"){
            String innerPRPrefix;
            int innerStartIndexForKey;
            int innerEndIndexForKey;
            int innerStartIndexNumOfRegions;
            int innerEndIndexNumOfRegions;
            {
                super(name);
                this.innerPRPrefix = PRPrefix;
                this.innerStartIndexForKey = startIndexForKey;
                this.innerEndIndexForKey = endIndexForKey;
                this.innerStartIndexNumOfRegions = startIndexNumOfRegions;
                this.innerEndIndexNumOfRegions = endIndexNumOfRegions;
            }

            @Override
            public void run2() throws CacheException {
                for (int j = this.innerStartIndexNumOfRegions; j < this.innerEndIndexNumOfRegions; ++j) {
                    Region pr = PartitionedRegionDUnitTestCase.this.getCache().getRegion("/" + this.innerPRPrefix + j);
                    for (int k = this.innerStartIndexForKey; k < this.innerEndIndexForKey; ++k) {
                        try {
                            pr.put((Object)(j + this.innerPRPrefix + k), (Object)(this.innerPRPrefix + k));
                            TestCase.fail((String)"You can not put after the region is destroyed ");
                            continue;
                        }
                        catch (RegionDestroyedException regionDestroyedException) {
                            // empty catch block
                        }
                    }
                }
            }
        };
        return putInPRs;
    }

    public CacheSerializableRunnable getRemovedOrDestroyedInMultiplePartitionRegion(final String PRPrefix, final int startIndexForKey, final int endIndexForKey, final int startIndexNumOfRegions, final int endIndexNumOfRegions, final int afterPutFlag) {
        CacheSerializableRunnable getInPRs = new CacheSerializableRunnable("doDetroyedGetOperations"){
            String innerPRPrefix;
            int innerStartIndexForKey;
            int innerEndIndexForKey;
            int innerStartIndexNumOfRegions;
            int innerEndIndexNumOfRegions;
            int innerAfterPutFlag;
            {
                super(name);
                this.innerPRPrefix = PRPrefix;
                this.innerStartIndexForKey = startIndexForKey;
                this.innerEndIndexForKey = endIndexForKey;
                this.innerStartIndexNumOfRegions = startIndexNumOfRegions;
                this.innerEndIndexNumOfRegions = endIndexNumOfRegions;
                this.innerAfterPutFlag = afterPutFlag;
            }

            @Override
            public void run2() throws CacheException {
                for (int j = this.innerStartIndexNumOfRegions; j < this.innerEndIndexNumOfRegions; ++j) {
                    Region pr = PartitionedRegionDUnitTestCase.this.getCache().getRegion("/" + this.innerPRPrefix + j);
                    TestCase.assertNotNull((Object)pr);
                    for (int k = this.innerStartIndexForKey; k < this.innerEndIndexForKey; ++k) {
                        Object Obj = pr.get((Object)(j + this.innerPRPrefix + k));
                        if (this.innerAfterPutFlag == 0) {
                            TestCase.assertNull((Object)Obj);
                            continue;
                        }
                        TestCase.assertNotNull((Object)Obj);
                    }
                    PartitionedRegionDUnitTestCase.this.getCache().getLogger().info("getRmovedOrDestroyedInMultiplePartitionRegion() - Get() of Destroy Keys done Successfully in Partition Region " + pr.getName());
                }
            }
        };
        return getInPRs;
    }

    public CacheSerializableRunnable destroyRegionInMultiplePartitionRegion(final String PRPrefix, final int startIndexForRegion, final int endIndexForRegion) {
        CacheSerializableRunnable getInPRs = new CacheSerializableRunnable("destroyRegionInMultiplePartitionRegion"){
            String innerPRPrefix;
            int innerStartIndexForRegion;
            int innerEndIndexForRegion;
            {
                super(name);
                this.innerPRPrefix = PRPrefix;
                this.innerStartIndexForRegion = startIndexForRegion;
                this.innerEndIndexForRegion = endIndexForRegion;
            }

            @Override
            public void run2() throws CacheException {
                for (int j = this.innerStartIndexForRegion; j < this.innerEndIndexForRegion; ++j) {
                    Region pr = PartitionedRegionDUnitTestCase.this.getCache().getRegion("/" + this.innerPRPrefix + j);
                    TestCase.assertNotNull((Object)pr);
                    PartitionedRegionDUnitTestCase.this.getCache().getLogger().info("region going to destroy is : " + pr);
                    pr.destroyRegion();
                }
            }
        };
        return getInPRs;
    }

    public CacheSerializableRunnable destroyInMultiplePartitionRegion(final String PRPrefix, final int startIndexForKey, final int endIndexForKey, final int startIndexNumOfRegions, final int endIndexNumOfRegions) {
        CacheSerializableRunnable destroyInPRs = new CacheSerializableRunnable("doDestroyKeyOperations"){
            String innerPRPrefix;
            int innerStartIndexForKey;
            int innerEndIndexForKey;
            int innerStartIndexNumOfRegions;
            int innerEndIndexNumOfRegions;
            {
                super(name);
                this.innerPRPrefix = PRPrefix;
                this.innerStartIndexForKey = startIndexForKey;
                this.innerEndIndexForKey = endIndexForKey;
                this.innerStartIndexNumOfRegions = startIndexNumOfRegions;
                this.innerEndIndexNumOfRegions = endIndexNumOfRegions;
            }

            @Override
            public void run2() throws CacheException {
                for (int j = this.innerStartIndexNumOfRegions; j < this.innerEndIndexNumOfRegions; ++j) {
                    Region pr = PartitionedRegionDUnitTestCase.this.getCache().getRegion("/" + this.innerPRPrefix + j);
                    TestCase.assertNotNull((Object)pr);
                    for (int k = startIndexForKey; k < endIndexForKey; ++k) {
                        try {
                            pr.destroy((Object)(j + this.innerPRPrefix + k));
                            continue;
                        }
                        catch (Exception e) {
                            TestCase.fail((String)("destroyInMultiplePartitionRegion()- Entry not found in the Partition region " + pr.getName()));
                        }
                    }
                    PartitionedRegionDUnitTestCase.this.getCache().getLogger().info("destroyInMultiplePartitionRegion() - destroy() done Successfully in Partition Region " + pr.getName());
                }
            }
        };
        return destroyInPRs;
    }

    public CacheSerializableRunnable invalidatesInMultiplePartitionRegion(final String PRPrefix, final int startIndexForKey, final int endIndexForKey, final int startIndexNumOfRegions, final int endIndexNumOfRegions) {
        CacheSerializableRunnable invalidateInPRs = new CacheSerializableRunnable("doInvalidateKeyOperations"){
            String innerPRPrefix;
            int innerStartIndexForKey;
            int innerEndIndexForKey;
            int innerStartIndexNumOfRegions;
            int innerEndIndexNumOfRegions;
            {
                super(name);
                this.innerPRPrefix = PRPrefix;
                this.innerStartIndexForKey = startIndexForKey;
                this.innerEndIndexForKey = endIndexForKey;
                this.innerStartIndexNumOfRegions = startIndexNumOfRegions;
                this.innerEndIndexNumOfRegions = endIndexNumOfRegions;
            }

            @Override
            public void run2() throws CacheException {
                for (int j = this.innerStartIndexNumOfRegions; j < this.innerEndIndexNumOfRegions; ++j) {
                    Region pr = PartitionedRegionDUnitTestCase.this.getCache().getRegion("/" + this.innerPRPrefix + j);
                    TestCase.assertNotNull((Object)pr);
                    for (int k = startIndexForKey; k < endIndexForKey; ++k) {
                        try {
                            pr.invalidate((Object)(j + this.innerPRPrefix + k));
                            continue;
                        }
                        catch (Exception e) {
                            TestCase.fail((String)("invalidateInMultiplePartitionRegion()- Entry not found in the Partition region " + pr.getName()));
                        }
                    }
                    PartitionedRegionDUnitTestCase.this.getCache().getLogger().info("invalidateInMultiplePartitionRegion() - invalidate() done Successfully in Partition Region " + pr.getName());
                }
            }
        };
        return invalidateInPRs;
    }

    public CacheSerializableRunnable disconnectVM() {
        CacheSerializableRunnable csr = new CacheSerializableRunnable("disconnectVM"){

            @Override
            public void run2() throws CacheException {
                PartitionedRegionDUnitTestCase.this.getCache();
                PartitionedRegionDUnitTestCase.this.getCache().getDistributedSystem().disconnect();
                PartitionedRegionDUnitTestCase.this.getCache().getLogger().info("disconnectVM() completed ..");
            }
        };
        return csr;
    }
}

