/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.EvictionCriteria;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.partition.PartitionRegionHelper;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import dunit.Host;
import dunit.VM;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Iterator;
import junit.framework.TestCase;

public class PartitionedRegionCustomEvictionDUnitTest
extends CacheTestCase {
    public PartitionedRegionCustomEvictionDUnitTest(String name) {
        super(name);
    }

    public void testCustomEvictionOnPR() {
        Host host = Host.getHost(0);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        String uniqName = PartitionedRegionCustomEvictionDUnitTest.getTestName();
        boolean redundantCopies = true;
        int interval = 5000;
        final String name = uniqName + "-PR";
        final long start = System.currentTimeMillis() + 1000L;
        final MyEvictionCriteria criteria = new MyEvictionCriteria();
        CacheSerializableRunnable create = new CacheSerializableRunnable("Partitioned Region with Custom Eviction"){

            @Override
            public void run2() {
                AttributesFactory factory = new AttributesFactory();
                factory.setEnableOffHeapMemory(false);
                factory.setPartitionAttributes(new PartitionAttributesFactory().setRedundantCopies(1).create());
                factory.setDiskSynchronous(true);
                factory.setCustomEvictionAttributes(criteria, start, 5000L);
                PartitionedRegion pr = (PartitionedRegion)PartitionedRegionCustomEvictionDUnitTest.this.getCache().createRegionFactory(factory.create()).create(name);
                TestCase.assertNotNull((Object)pr);
            }
        };
        vm2.invoke(create);
        vm3.invoke(create);
        CacheSerializableRunnable doPuts = new CacheSerializableRunnable("Partitioned Region put operation"){

            @Override
            public void run2() {
                int i;
                PartitionedRegion pr = (PartitionedRegion)PartitionedRegionCustomEvictionDUnitTest.this.getRootRegion(name);
                for (i = 0; i < 100; ++i) {
                    pr.put((Object)i, (Object)i);
                }
                for (i = 100; i < 200; ++i) {
                    pr.put((Object)i, (Object)i);
                }
            }
        };
        vm2.invoke(doPuts);
        CacheSerializableRunnable verify = new CacheSerializableRunnable("Partitioned Region put operation"){

            @Override
            public void run2() {
                PartitionedRegion pr = (PartitionedRegion)PartitionedRegionCustomEvictionDUnitTest.this.getRootRegion(name);
                for (int i = 0; i < 200; ++i) {
                    if (i % 2 == 0) {
                        TestCase.assertNull((Object)pr.get((Object)i));
                        continue;
                    }
                    TestCase.assertNotNull((Object)pr.get((Object)i));
                }
            }
        };
        PartitionedRegionCustomEvictionDUnitTest.pause(40000);
        vm2.invoke(verify);
    }

    class MyItr
    implements Iterator {
        final PartitionedRegion region;
        Iterator itr;

        public MyItr(Region r) {
            this.region = (PartitionedRegion)r;
            this.itr = PartitionRegionHelper.getLocalData((Region)this.region).keySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.itr.hasNext();
        }

        public Object next() {
            int key;
            int routingObject = key = ((Integer)this.itr.next()).intValue();
            return new AbstractMap.SimpleEntry<Integer, Integer>(key, routingObject);
        }

        @Override
        public void remove() {
        }
    }

    class MyEvictionCriteria
    implements EvictionCriteria,
    Serializable {
        MyEvictionCriteria() {
        }

        public Iterator getKeysToBeEvicted(long currentMillis, Region region) {
            return new MyItr(region);
        }

        public boolean doEvict(EntryEvent event) {
            System.out.println("Being called for " + event.getKey() + " returning " + ((Integer)event.getKey() % 2 == 0));
            return (Integer)event.getKey() % 2 == 0;
        }

        public boolean isEquivalent(EvictionCriteria other) {
            return true;
        }
    }
}

