/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionDUnitTestCase;
import dunit.Host;
import dunit.VM;
import junit.framework.TestCase;

public class PartitionedRegionAsSubRegionDUnitTest
extends PartitionedRegionDUnitTestCase {
    public static final String PR_PREFIX = "PR";
    final String parentRegionName = "PARENT_REGION";
    final String childRegionName = "CHILD_REGION";
    private CacheSerializableRunnable createPR = new CacheSerializableRunnable("createPR"){

        @Override
        public void run2() throws CacheException {
            Cache cache = PartitionedRegionAsSubRegionDUnitTest.this.getCache();
            Region parentRegion = cache.getRegion("/PARENT_REGION/CHILD_REGION");
            parentRegion.createSubregion(PartitionedRegionAsSubRegionDUnitTest.PR_PREFIX, PartitionedRegionAsSubRegionDUnitTest.this.createRegionAttributesForPR(1, 200));
        }
    };
    private CacheSerializableRunnable doRegionOps = new CacheSerializableRunnable("doRegionOps"){

        @Override
        public void run2() throws CacheException {
            Cache cache = PartitionedRegionAsSubRegionDUnitTest.this.getCache();
            PartitionedRegion pr = (PartitionedRegion)cache.getRegion("/PARENT_REGION/CHILD_REGION/PR");
            for (int i = 0; i < pr.getTotalNumberOfBuckets(); ++i) {
                pr.put((Object)new Integer(i), (Object)(i + ""));
            }
        }
    };
    private CacheSerializableRunnable recreatePRAfterDestroy = new CacheSerializableRunnable("recreatePRAfterDestroy"){

        @Override
        public void run2() throws CacheException {
            Cache cache = PartitionedRegionAsSubRegionDUnitTest.this.getCache();
            Region parentRegion = cache.getRegion("/PARENT_REGION");
            Region childRegion = null;
            childRegion = parentRegion.createSubregion("CHILD_REGION", parentRegion.getAttributes());
            PartitionedRegion pr = null;
            pr = (PartitionedRegion)cache.getRegion("/PARENT_REGION/CHILD_REGION/PR");
            if (pr != null) {
                TestCase.fail((String)"PR strill exists");
            }
            pr = (PartitionedRegion)childRegion.createSubregion(PartitionedRegionAsSubRegionDUnitTest.PR_PREFIX, PartitionedRegionAsSubRegionDUnitTest.this.createRegionAttributesForPR(1, 200));
            TestCase.assertEquals((int)0, (int)pr.getRegionAdvisor().getCreatedBucketsCount());
        }
    };
    private CacheSerializableRunnable recreatePRAfterLocalDestroy = new CacheSerializableRunnable("recreatePRAfterLocalDestroy"){

        @Override
        public void run2() throws CacheException {
            Cache cache = PartitionedRegionAsSubRegionDUnitTest.this.getCache();
            Region parentRegion = cache.getRegion("/PARENT_REGION");
            Region childRegion = null;
            childRegion = parentRegion.createSubregion("CHILD_REGION", parentRegion.getAttributes());
            PartitionedRegion pr = null;
            pr = (PartitionedRegion)cache.getRegion("/PARENT_REGION/CHILD_REGION/PR");
            if (pr != null) {
                TestCase.fail((String)"PR strill exists");
            }
            pr = (PartitionedRegion)childRegion.createSubregion(PartitionedRegionAsSubRegionDUnitTest.PR_PREFIX, PartitionedRegionAsSubRegionDUnitTest.this.createRegionAttributesForPR(1, 200));
            TestCase.assertEquals((int)pr.getRegionAdvisor().getBucketSet().size(), (int)113);
        }
    };
    private CacheSerializableRunnable destroyChildRegion = new CacheSerializableRunnable("destroyChildRegion"){

        @Override
        public void run2() throws CacheException {
            Cache cache = PartitionedRegionAsSubRegionDUnitTest.this.getCache();
            Region parentRegion = cache.getRegion("/PARENT_REGION/CHILD_REGION");
            parentRegion.destroyRegion();
        }
    };
    private CacheSerializableRunnable destroyPR = new CacheSerializableRunnable("destroyPR"){

        @Override
        public void run2() throws CacheException {
            Cache cache = PartitionedRegionAsSubRegionDUnitTest.this.getCache();
            Region pr = cache.getRegion("/PR");
            pr.destroyRegion();
        }
    };
    private CacheSerializableRunnable localDestroyChildRegion = new CacheSerializableRunnable("localDestroyChildRegion"){

        @Override
        public void run2() throws CacheException {
            Cache cache = PartitionedRegionAsSubRegionDUnitTest.this.getCache();
            Region parentRegion = cache.getRegion("/PARENT_REGION/CHILD_REGION");
            parentRegion.localDestroyRegion();
        }
    };
    private CacheSerializableRunnable closeChildRegion = new CacheSerializableRunnable("closeChildRegion"){

        @Override
        public void run2() throws CacheException {
            Cache cache = PartitionedRegionAsSubRegionDUnitTest.this.getCache();
            Region parentRegion = cache.getRegion("/PARENT_REGION/CHILD_REGION");
            parentRegion.close();
        }
    };
    private CacheSerializableRunnable createDACKRegions = new CacheSerializableRunnable("createDACKRegions"){

        @Override
        public void run2() throws CacheException {
            Cache cache = PartitionedRegionAsSubRegionDUnitTest.this.getCache();
            RegionAttributes ra = PartitionedRegionAsSubRegionDUnitTest.this.createRegionAttributesForDACKRegions();
            Region parentRegion = cache.createRegion("PARENT_REGION", ra);
            parentRegion.createSubregion("CHILD_REGION", ra);
        }
    };

    public PartitionedRegionAsSubRegionDUnitTest(String name) {
        super(name);
    }

    public void testSubRegionDestroyRegion() throws Exception {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        vm0.invoke(this.createDACKRegions);
        vm1.invoke(this.createDACKRegions);
        vm0.invoke(this.createPR);
        vm1.invoke(this.createPR);
        vm0.invoke(this.doRegionOps);
        vm0.invoke(this.destroyChildRegion);
        vm0.invoke(this.recreatePRAfterDestroy);
        vm0.invoke(this.destroyChildRegion);
        vm0.invoke(this.recreatePRAfterDestroy);
    }

    public void testSubRegionLocalDestroyRegion() throws Exception {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        vm0.invoke(this.createDACKRegions);
        vm1.invoke(this.createDACKRegions);
        vm0.invoke(this.createPR);
        vm1.invoke(this.createPR);
        vm0.invoke(this.doRegionOps);
        vm0.invoke(this.localDestroyChildRegion);
        vm0.invoke(this.recreatePRAfterLocalDestroy);
        vm0.invoke(this.localDestroyChildRegion);
    }

    public void testSubRegionClose() throws Exception {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        vm0.invoke(this.createDACKRegions);
        vm1.invoke(this.createDACKRegions);
        vm0.invoke(this.createPR);
        vm1.invoke(this.createPR);
        vm0.invoke(this.doRegionOps);
        vm0.invoke(this.closeChildRegion);
        vm0.invoke(this.recreatePRAfterLocalDestroy);
        vm0.invoke(this.closeChildRegion);
    }

    protected RegionAttributes createRegionAttributesForPR(int redundancy, int localMaxMem) {
        AttributesFactory attr = new AttributesFactory();
        PartitionAttributesFactory paf = new PartitionAttributesFactory();
        PartitionAttributes prAttr = paf.setRedundantCopies(redundancy).setLocalMaxMemory(localMaxMem).create();
        attr.setPartitionAttributes(prAttr);
        return attr.create();
    }

    protected RegionAttributes createRegionAttributesForDACKRegions() {
        AttributesFactory attr = new AttributesFactory();
        return attr.create();
    }
}

