/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.Delta;
import com.gemstone.gemfire.DeltaTestImpl;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.AttributesMutator;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.ExpirationAction;
import com.gemstone.gemfire.cache.ExpirationAttributes;
import com.gemstone.gemfire.cache.InterestPolicy;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.SubscriptionAttributes;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.query.CqAttributes;
import com.gemstone.gemfire.cache.query.CqAttributesFactory;
import com.gemstone.gemfire.cache.query.CqEvent;
import com.gemstone.gemfire.cache.query.CqListener;
import com.gemstone.gemfire.cache.query.CqQuery;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.cache.util.BridgeServer;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.cache.util.CqListenerAdapter;
import com.gemstone.gemfire.compression.Compressor;
import com.gemstone.gemfire.compression.SnappyCompressor;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.BridgeServerImpl;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientNotifier;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientProxy;
import com.gemstone.gemfire.internal.cache.tier.sockets.ConflationDUnitTest;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Properties;
import junit.framework.TestCase;

public class PRDeltaPropagationDUnitTest
extends DistributedTestCase {
    private static final Compressor compressor = SnappyCompressor.getDefaultInstance();
    private static final long serialVersionUID = 1L;
    protected static Cache cache = null;
    protected static VM dataStore1 = null;
    protected static VM dataStore2 = null;
    protected static VM dataStore3 = null;
    protected static VM client1 = null;
    protected static Region deltaPR = null;
    private static final int NO_PUTS = 10;
    private static PRDeltaTestImpl prDelta = null;
    static PoolImpl pool = null;
    public static String DELTA_KEY = "DELTA_KEY";
    public static String LAST_KEY = "LAST_KEY";
    static boolean isFailed = false;
    private static boolean procced = false;
    private static boolean forOldNewCQVarification = false;
    private static final String REGION_NAME = "PRDeltaPropagationDUnitTest_Region";
    private static final String CQ = "SELECT * FROM /PRDeltaPropagationDUnitTest_Region p where p.intVar < 9";
    private static int numValidCqEvents = 0;
    static boolean lastKeyReceived = false;
    private static boolean queryUpdateExecuted = false;
    private static boolean queryDestroyExecuted = false;
    private static boolean notADeltaInstanceObj = false;

    public PRDeltaPropagationDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Host host = Host.getHost(0);
        dataStore1 = host.getVM(0);
        dataStore2 = host.getVM(1);
        client1 = host.getVM(2);
        dataStore3 = host.getVM(3);
        DeltaTestImpl.resetDeltaInvokationCounters();
        dataStore1.invoke(PRDeltaPropagationDUnitTest.class, "resetAll");
        dataStore2.invoke(PRDeltaPropagationDUnitTest.class, "resetAll");
        dataStore3.invoke(PRDeltaPropagationDUnitTest.class, "resetAll");
    }

    public void testDeltaPropagationForPR() throws Throwable {
        PRDeltaPropagationDUnitTest.createCacheInAllPRVms();
        PRDeltaPropagationDUnitTest.createDeltaPR(Boolean.FALSE);
        PRDeltaPropagationDUnitTest.put();
        Boolean deltaUsed1 = (Boolean)dataStore1.invoke(PRDeltaPropagationDUnitTest.class, "checkForDelta");
        Boolean deltaUsed2 = (Boolean)dataStore2.invoke(PRDeltaPropagationDUnitTest.class, "checkForDelta");
        PRDeltaPropagationDUnitTest.assertTrue((String)"Delta Propagation Not Used in PR", (deltaUsed1 != false && deltaUsed2 != false ? 1 : 0) != 0);
    }

    public void testDeltaPropagationForPRFailover() throws Throwable {
        Object[] args = new Object[]{REGION_NAME, new Integer(1), new Integer(50), new Integer(8), Boolean.FALSE, null};
        Integer port1 = (Integer)dataStore1.invoke(PRDeltaPropagationDUnitTest.class, "createCacheServerWithPR", args);
        Integer port2 = (Integer)dataStore2.invoke(PRDeltaPropagationDUnitTest.class, "createCacheServerWithPR", args);
        dataStore1.invoke(ConflationDUnitTest.class, "setIsSlowStart", new Object[]{"60000"});
        dataStore2.invoke(ConflationDUnitTest.class, "setIsSlowStart", new Object[]{"60000"});
        PRDeltaPropagationDUnitTest.createClientCache(port1, port2);
        client1.invoke(PRDeltaPropagationDUnitTest.class, "createClientCache", new Object[]{port1, port2});
        int deltaSent = PRDeltaPropagationDUnitTest.putsWhichReturnsDeltaSent();
        VM primary = null;
        VM secondary = null;
        if (pool.getPrimaryPort() == port1.intValue()) {
            primary = dataStore1;
            secondary = dataStore2;
        } else {
            primary = dataStore2;
            secondary = dataStore1;
        }
        primary.invoke(PRDeltaPropagationDUnitTest.class, "closeCache");
        Thread.sleep(5000L);
        secondary.invoke(ConflationDUnitTest.class, "unsetIsSlowStart");
        client1.invoke(PRDeltaPropagationDUnitTest.class, "waitForLastKey");
        client1.invoke(PRDeltaPropagationDUnitTest.class, "checkDeltaInvoked", new Object[]{new Integer(deltaSent)});
    }

    public void testDeltaPropagationForPRFailoverWithCompression() throws Throwable {
        Object[] args = new Object[]{REGION_NAME, new Integer(1), new Integer(50), new Integer(8), Boolean.FALSE, compressor};
        Integer port1 = (Integer)dataStore1.invoke(PRDeltaPropagationDUnitTest.class, "createCacheServerWithPR", args);
        Integer port2 = (Integer)dataStore2.invoke(PRDeltaPropagationDUnitTest.class, "createCacheServerWithPR", args);
        dataStore1.invoke(new SerializableRunnable(){

            @Override
            public void run() {
                TestCase.assertTrue((cache.getRegion(PRDeltaPropagationDUnitTest.REGION_NAME).getAttributes().getCompressor() != null ? 1 : 0) != 0);
            }
        });
        dataStore1.invoke(ConflationDUnitTest.class, "setIsSlowStart", new Object[]{"60000"});
        dataStore2.invoke(ConflationDUnitTest.class, "setIsSlowStart", new Object[]{"60000"});
        PRDeltaPropagationDUnitTest.createClientCache(port1, port2);
        client1.invoke(PRDeltaPropagationDUnitTest.class, "createClientCache", new Object[]{port1, port2});
        int deltaSent = PRDeltaPropagationDUnitTest.putsWhichReturnsDeltaSent();
        VM primary = null;
        VM secondary = null;
        if (pool.getPrimaryPort() == port1.intValue()) {
            primary = dataStore1;
            secondary = dataStore2;
        } else {
            primary = dataStore2;
            secondary = dataStore1;
        }
        primary.invoke(PRDeltaPropagationDUnitTest.class, "closeCache");
        Thread.sleep(5000L);
        secondary.invoke(ConflationDUnitTest.class, "unsetIsSlowStart");
        client1.invoke(PRDeltaPropagationDUnitTest.class, "waitForLastKey");
        client1.invoke(PRDeltaPropagationDUnitTest.class, "checkDeltaInvoked", new Object[]{new Integer(deltaSent)});
    }

    public void testDeltaPropagationForPRWithExpiry() throws Throwable {
        PRDeltaPropagationDUnitTest.createCacheInAllPRVms();
        PRDeltaPropagationDUnitTest.createDeltaPR(Boolean.TRUE);
        PRDeltaPropagationDUnitTest.putWithExpiry();
        dataStore1.invoke(PRDeltaPropagationDUnitTest.class, "checkForFullObject");
        dataStore2.invoke(PRDeltaPropagationDUnitTest.class, "checkForFullObject");
    }

    public void testDeltaPropagationPRAccessorAsBridgeServer() throws Throwable {
        Object[] args1 = new Object[]{REGION_NAME, new Integer(0), new Integer(0), new Integer(8), Boolean.FALSE, null};
        Object[] args2 = new Object[]{REGION_NAME, new Integer(0), new Integer(50), new Integer(8), Boolean.FALSE, null};
        Integer port2 = (Integer)dataStore2.invoke(PRDeltaPropagationDUnitTest.class, "createCacheServerWithPR", args2);
        Integer port1 = (Integer)dataStore1.invoke(PRDeltaPropagationDUnitTest.class, "createCacheServerWithPR", args1);
        PRDeltaPropagationDUnitTest.createClientCache(port1, new Boolean(true), new Boolean(false), new Boolean(false));
        client1.invoke(PRDeltaPropagationDUnitTest.class, "createClientCache", new Object[]{port2, new Boolean(true), new Boolean(false), new Boolean(false)});
        int deltaSent = PRDeltaPropagationDUnitTest.putsWhichReturnsDeltaSent();
        client1.invoke(PRDeltaPropagationDUnitTest.class, "waitForLastKey");
        client1.invoke(PRDeltaPropagationDUnitTest.class, "checkDeltaInvoked", new Object[]{new Integer(deltaSent)});
    }

    public void testDeltaPropagationPRAccessorAsBridgeServerWithDeltaException() throws Throwable {
        Object[] args1 = new Object[]{REGION_NAME, new Integer(0), new Integer(0), new Integer(8), Boolean.FALSE, null};
        Object[] args2 = new Object[]{REGION_NAME, new Integer(0), new Integer(50), new Integer(8), Boolean.FALSE, null};
        Integer port2 = (Integer)dataStore2.invoke(PRDeltaPropagationDUnitTest.class, "createCacheServerWithPR", args2);
        Integer port1 = (Integer)dataStore1.invoke(PRDeltaPropagationDUnitTest.class, "createCacheServerWithPR", args1);
        PRDeltaPropagationDUnitTest.createClientCache(port1, new Boolean(false), new Boolean(false), new Boolean(false));
        client1.invoke(PRDeltaPropagationDUnitTest.class, "createClientCache", new Object[]{port2, new Boolean(true), new Boolean(false), new Boolean(false)});
        DeltaTestImpl test = new DeltaTestImpl();
        deltaPR.put((Object)DELTA_KEY, (Object)test);
        test.setIntVar(10);
        deltaPR.put((Object)DELTA_KEY, (Object)test);
        dataStore2.invoke(PRDeltaPropagationDUnitTest.class, "invalidateDeltaKey");
        test = new DeltaTestImpl();
        test.setStr("DELTA");
        deltaPR.put((Object)DELTA_KEY, (Object)test);
        deltaPR.put((Object)LAST_KEY, (Object)"");
        client1.invoke(PRDeltaPropagationDUnitTest.class, "waitForLastKey");
        client1.invoke(PRDeltaPropagationDUnitTest.class, "checkForFullObject");
    }

    public void testDeltaPropagationClientEmptyPRAccessorAsBridgeServerWithDeltaException() throws Throwable {
        Object[] args1 = new Object[]{REGION_NAME, new Integer(0), new Integer(0), new Integer(8), Boolean.FALSE, null};
        Object[] args2 = new Object[]{REGION_NAME, new Integer(0), new Integer(50), new Integer(8), Boolean.FALSE, null};
        Integer port2 = (Integer)dataStore2.invoke(PRDeltaPropagationDUnitTest.class, "createCacheServerWithPR", args2);
        Integer port1 = (Integer)dataStore1.invoke(PRDeltaPropagationDUnitTest.class, "createCacheServerWithPR", args1);
        PRDeltaPropagationDUnitTest.createClientCache(port1, new Boolean(false), new Boolean(true), new Boolean(false));
        client1.invoke(PRDeltaPropagationDUnitTest.class, "createClientCache", new Object[]{port2, new Boolean(true), new Boolean(false), new Boolean(false)});
        DeltaTestImpl test = new DeltaTestImpl();
        deltaPR.put((Object)DELTA_KEY, (Object)test);
        test.setIntVar(10);
        deltaPR.put((Object)DELTA_KEY, (Object)test);
        dataStore2.invoke(PRDeltaPropagationDUnitTest.class, "invalidateDeltaKey");
        test = new DeltaTestImpl();
        test.setStr("DELTA");
        deltaPR.put((Object)DELTA_KEY, (Object)test);
        deltaPR.put((Object)LAST_KEY, (Object)"");
        PRDeltaPropagationDUnitTest.checkToDeltaCounter(new Integer(2));
        client1.invoke(PRDeltaPropagationDUnitTest.class, "waitForLastKey");
        client1.invoke(PRDeltaPropagationDUnitTest.class, "checkForFullObject");
    }

    public void testDeltaPropagationReplicatedRegionPeerWithDeltaException() throws Throwable {
        Object[] args1 = new Object[]{Boolean.FALSE, Boolean.TRUE};
        Object[] args2 = new Object[]{Boolean.TRUE, Boolean.FALSE};
        Integer port1 = (Integer)dataStore1.invoke(PRDeltaPropagationDUnitTest.class, "createServerCache", args1);
        dataStore2.invoke(PRDeltaPropagationDUnitTest.class, "createServerCache", args2);
        PRDeltaPropagationDUnitTest.createClientCache(port1, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE);
        DeltaTestImpl test = new DeltaTestImpl();
        deltaPR.put((Object)DELTA_KEY, (Object)test);
        test.setIntVar(10);
        deltaPR.put((Object)DELTA_KEY, (Object)test);
        dataStore2.invoke(PRDeltaPropagationDUnitTest.class, "invalidateDeltaKey");
        test = new DeltaTestImpl();
        test.setStr("DELTA");
        deltaPR.put((Object)DELTA_KEY, (Object)test);
        deltaPR.put((Object)LAST_KEY, (Object)"");
        dataStore2.invoke(PRDeltaPropagationDUnitTest.class, "waitForLastKey");
        dataStore2.invoke(PRDeltaPropagationDUnitTest.class, "checkIsFailed");
        dataStore2.invoke(PRDeltaPropagationDUnitTest.class, "fromDeltaCounter", new Object[]{new Integer(1)});
    }

    public void testCqClientConnectAccessorAndDataStore() throws Throwable {
        Object[] args1 = new Object[]{REGION_NAME, new Integer(1), new Integer(0), new Integer(8), Boolean.FALSE, null};
        Object[] args2 = new Object[]{REGION_NAME, new Integer(1), new Integer(50), new Integer(8), Boolean.FALSE, null};
        Integer port2 = (Integer)dataStore2.invoke(PRDeltaPropagationDUnitTest.class, "createCacheServerWithPR", args2);
        Integer port1 = (Integer)dataStore1.invoke(PRDeltaPropagationDUnitTest.class, "createCacheServerWithPR", args1);
        PRDeltaPropagationDUnitTest.createClientCache(port1, new Boolean(false), new Boolean(true), new Boolean(false));
        client1.invoke(PRDeltaPropagationDUnitTest.class, "setForOldNewCQVarification", new Object[]{new Boolean(true)});
        client1.invoke(PRDeltaPropagationDUnitTest.class, "createClientCache", new Object[]{port2, new Boolean(false), new Boolean(false), new Boolean(true)});
        dataStore1.invoke(PRDeltaPropagationDUnitTest.class, "checkCloning");
        dataStore2.invoke(PRDeltaPropagationDUnitTest.class, "checkCloning");
        client1.invoke(PRDeltaPropagationDUnitTest.class, "checkCloning");
        PRDeltaPropagationDUnitTest.checkCloning();
        DeltaTestImpl test = new DeltaTestImpl(8, "");
        deltaPR.put((Object)DELTA_KEY, (Object)test);
        test.setIntVar(10);
        deltaPR.put((Object)DELTA_KEY, (Object)test);
        deltaPR.put((Object)LAST_KEY, (Object)new DeltaTestImpl(5, ""));
        client1.invoke(PRDeltaPropagationDUnitTest.class, "waitForLastKey");
        client1.invoke(PRDeltaPropagationDUnitTest.class, "fromDeltaCounter", new Object[]{new Integer(0)});
        boolean failed = (Boolean)client1.invoke(PRDeltaPropagationDUnitTest.class, "isFailed");
        PRDeltaPropagationDUnitTest.assertTrue((String)"EVENT Missed", (failed ? 1 : 0) != 0);
        client1.invoke(PRDeltaPropagationDUnitTest.class, "checkRegionSize", new Object[]{new Integer(0)});
    }

    public void testClientOnAccessorReceivesCqEvents() throws Throwable {
        Object[] args1 = new Object[]{REGION_NAME, new Integer(1), new Integer(0), new Integer(8), Boolean.FALSE, null};
        Object[] args2 = new Object[]{REGION_NAME, new Integer(1), new Integer(50), new Integer(8), Boolean.FALSE, null};
        dataStore2.invoke(PRDeltaPropagationDUnitTest.class, "createCacheServerWithPR", args2);
        Integer port1 = (Integer)dataStore1.invoke(PRDeltaPropagationDUnitTest.class, "createCacheServerWithPR", args1);
        PRDeltaPropagationDUnitTest.createClientCache(port1, new Boolean(false), new Boolean(true), new Boolean(false));
        client1.invoke(PRDeltaPropagationDUnitTest.class, "createClientCache", new Object[]{port1, new Boolean(false), new Boolean(false), new Boolean(true)});
        DeltaTestImpl test = new DeltaTestImpl(8, "");
        deltaPR.put((Object)DELTA_KEY, (Object)test);
        test.setIntVar(10);
        deltaPR.put((Object)DELTA_KEY, (Object)test);
        deltaPR.put((Object)LAST_KEY, (Object)new DeltaTestImpl(8, ""));
        client1.invoke(PRDeltaPropagationDUnitTest.class, "waitForLastKey");
        boolean flag = (Boolean)client1.invoke(PRDeltaPropagationDUnitTest.class, "verifyQueryUpdateExecuted");
        PRDeltaPropagationDUnitTest.assertTrue((String)"client update cq not executed properly", (boolean)flag);
        flag = (Boolean)client1.invoke(PRDeltaPropagationDUnitTest.class, "verifyQueryDestroyExecuted");
        PRDeltaPropagationDUnitTest.assertTrue((String)"client destroy cq not executed properly", (boolean)flag);
    }

    public void testCQClientOnRedundantBucketReceivesCQEvents() throws Throwable {
        Object[] args1 = new Object[]{REGION_NAME, new Integer(1), new Integer(0), new Integer(2), Boolean.FALSE, null};
        Object[] args2 = new Object[]{REGION_NAME, new Integer(1), new Integer(50), new Integer(2), Boolean.FALSE, null};
        dataStore2.invoke(PRDeltaPropagationDUnitTest.class, "createCacheServerWithPR", args2);
        Integer port3 = (Integer)dataStore3.invoke(PRDeltaPropagationDUnitTest.class, "createCacheServerWithPR", args2);
        Integer port1 = (Integer)dataStore1.invoke(PRDeltaPropagationDUnitTest.class, "createCacheServerWithPR", args1);
        PRDeltaPropagationDUnitTest.createClientCache(port1, new Boolean(false), new Boolean(true), new Boolean(false));
        client1.invoke(PRDeltaPropagationDUnitTest.class, "createClientCache", new Object[]{port3, new Boolean(false), new Boolean(false), new Boolean(true)});
        DeltaTestImpl test = new DeltaTestImpl(8, "");
        deltaPR.put((Object)DELTA_KEY, (Object)test);
        test.setIntVar(10);
        deltaPR.put((Object)DELTA_KEY, (Object)test);
        deltaPR.put((Object)LAST_KEY, (Object)new DeltaTestImpl(8, ""));
        client1.invoke(PRDeltaPropagationDUnitTest.class, "waitForLastKey");
        dataStore3.invoke(PRDeltaPropagationDUnitTest.class, "verifyDeltaSent", new Object[]{1});
        boolean flag = (Boolean)client1.invoke(PRDeltaPropagationDUnitTest.class, "verifyQueryUpdateExecuted");
        PRDeltaPropagationDUnitTest.assertTrue((String)"client update cq not executed properly", (boolean)flag);
        flag = (Boolean)client1.invoke(PRDeltaPropagationDUnitTest.class, "verifyQueryDestroyExecuted");
        PRDeltaPropagationDUnitTest.assertTrue((String)"client destroy cq not executed properly", (boolean)flag);
    }

    public void testCQRIClientOnRedundantBucketReceivesDeltaAndCQEvents() throws Throwable {
        Object[] args1 = new Object[]{REGION_NAME, new Integer(1), new Integer(0), new Integer(2), Boolean.FALSE, null};
        Object[] args2 = new Object[]{REGION_NAME, new Integer(1), new Integer(50), new Integer(2), Boolean.FALSE, null};
        dataStore2.invoke(PRDeltaPropagationDUnitTest.class, "createCacheServerWithPR", args2);
        Integer port3 = (Integer)dataStore3.invoke(PRDeltaPropagationDUnitTest.class, "createCacheServerWithPR", args2);
        Integer port1 = (Integer)dataStore1.invoke(PRDeltaPropagationDUnitTest.class, "createCacheServerWithPR", args1);
        PRDeltaPropagationDUnitTest.createClientCache(port1, new Boolean(false), new Boolean(true), new Boolean(false));
        client1.invoke(PRDeltaPropagationDUnitTest.class, "createClientCache", new Object[]{port3, new Boolean(true), new Boolean(false), new Boolean(true)});
        DeltaTestImpl test = new DeltaTestImpl(8, "");
        deltaPR.put((Object)DELTA_KEY, (Object)test);
        test.setIntVar(10);
        deltaPR.put((Object)DELTA_KEY, (Object)test);
        deltaPR.put((Object)LAST_KEY, (Object)new DeltaTestImpl(8, ""));
        client1.invoke(PRDeltaPropagationDUnitTest.class, "waitForLastKey");
        client1.invoke(PRDeltaPropagationDUnitTest.class, "fromDeltaCounter", new Object[]{new Integer(1)});
        boolean flag = (Boolean)client1.invoke(PRDeltaPropagationDUnitTest.class, "verifyQueryUpdateExecuted");
        PRDeltaPropagationDUnitTest.assertTrue((String)"client update cq not executed properly", (boolean)flag);
        flag = (Boolean)client1.invoke(PRDeltaPropagationDUnitTest.class, "verifyQueryDestroyExecuted");
        PRDeltaPropagationDUnitTest.assertTrue((String)"client destroy cq not executed properly", (boolean)flag);
    }

    public void testDeltaPropagationWithAdjunctMessaging() throws Throwable {
        Object[] args1 = new Object[]{REGION_NAME, new Integer(0), new Integer(0), new Integer(8), Boolean.FALSE, null};
        Object[] args2 = new Object[]{REGION_NAME, new Integer(0), new Integer(50), new Integer(8), Boolean.FALSE, null};
        dataStore2.invoke(PRDeltaPropagationDUnitTest.class, "createCacheServerWithPR", args2);
        Integer port1 = (Integer)dataStore1.invoke(PRDeltaPropagationDUnitTest.class, "createCacheServerWithPR", args1);
        PRDeltaPropagationDUnitTest.createClientCache(port1, new Boolean(true), new Boolean(false), new Boolean(false));
        client1.invoke(PRDeltaPropagationDUnitTest.class, "createClientCache", new Object[]{port1, new Boolean(true), new Boolean(false), new Boolean(false)});
        int deltaSent = PRDeltaPropagationDUnitTest.putsWhichReturnsDeltaSent();
        client1.invoke(PRDeltaPropagationDUnitTest.class, "waitForLastKey");
        client1.invoke(PRDeltaPropagationDUnitTest.class, "checkDeltaInvoked", new Object[]{new Integer(deltaSent)});
    }

    public void testDeltaPropagationWithAdjunctMessagingForEmptyClient() throws Throwable {
        Object[] args1 = new Object[]{REGION_NAME, new Integer(0), new Integer(0), new Integer(8), Boolean.FALSE, null};
        Object[] args2 = new Object[]{REGION_NAME, new Integer(0), new Integer(50), new Integer(8), Boolean.FALSE, null};
        dataStore2.invoke(PRDeltaPropagationDUnitTest.class, "createCacheServerWithPR", args2);
        Integer port1 = (Integer)dataStore1.invoke(PRDeltaPropagationDUnitTest.class, "createCacheServerWithPR", args1);
        PRDeltaPropagationDUnitTest.createClientCache(port1, new Boolean(true), new Boolean(true), new Boolean(false));
        client1.invoke(PRDeltaPropagationDUnitTest.class, "createClientCache", new Object[]{port1, new Boolean(true), new Boolean(false), new Boolean(false)});
        int deltaSent = (Integer)dataStore1.invoke(PRDeltaPropagationDUnitTest.class, "putsWhichReturnsDeltaSent");
        PRDeltaPropagationDUnitTest.waitForLastKey();
        PRDeltaPropagationDUnitTest.checkDeltaInvoked(new Integer(0));
        client1.invoke(PRDeltaPropagationDUnitTest.class, "waitForLastKey");
        client1.invoke(PRDeltaPropagationDUnitTest.class, "checkDeltaInvoked", new Object[]{new Integer(deltaSent)});
    }

    public static void checkToDeltaCounter(Integer count) {
        PRDeltaPropagationDUnitTest.assertTrue((String)("ToDelta counters do not match, expected: " + count + ", actual: " + DeltaTestImpl.getToDeltaInvokations()), (DeltaTestImpl.getToDeltaInvokations() == (long)count.intValue() ? 1 : 0) != 0);
        DeltaTestImpl.resetDeltaInvokationCounters();
    }

    public static void fromDeltaCounter(Integer count) {
        PRDeltaPropagationDUnitTest.assertTrue((String)("FromDelta counters do not match, expected: " + count + ", but actual: " + DeltaTestImpl.getFromDeltaInvokations()), (DeltaTestImpl.getFromDeltaInvokations() == (long)count.intValue() ? 1 : 0) != 0);
        DeltaTestImpl.resetDeltaInvokationCounters();
    }

    public static void checkIsFailed() {
        PRDeltaPropagationDUnitTest.assertFalse((String)"Full value is not recieved by server", (boolean)isFailed);
    }

    public static Boolean isFailed() {
        return isFailed;
    }

    public static void checkRegionSize(Integer i) {
        PRDeltaPropagationDUnitTest.assertTrue((String)"Region size is not zero ", (cache.getRegion(REGION_NAME).size() == i.intValue() ? 1 : 0) != 0);
    }

    public static void checkCloning() {
        PRDeltaPropagationDUnitTest.assertFalse((String)"Cloning is enabled ", (boolean)cache.getRegion(REGION_NAME).getAttributes().getCloningEnabled());
    }

    public static void invalidateDeltaKey() {
        deltaPR.invalidate((Object)DELTA_KEY);
    }

    public static void createCacheInVm() {
        new PRDeltaPropagationDUnitTest("temp").createCache(new Properties());
    }

    public void createCache(Properties props) {
        try {
            InternalDistributedSystem ds = this.getSystem(props);
            PRDeltaPropagationDUnitTest.assertNotNull((Object)ds);
            ds.disconnect();
            ds = this.getSystem(props);
            cache = CacheFactory.create((DistributedSystem)ds);
            PRDeltaPropagationDUnitTest.assertNotNull((Object)cache);
        }
        catch (Exception e) {
            PRDeltaPropagationDUnitTest.fail("Failed while creating the cache", e);
        }
    }

    private static void createDeltaPR(Boolean flag) {
        Object[] args = new Object[]{"DeltaPR", new Integer(1), new Integer(50), new Integer(8), flag, null};
        PRDeltaPropagationDUnitTest.createPR("DeltaPR", new Integer(1), new Integer(0), new Integer(8), flag, null);
        dataStore1.invoke(PRDeltaPropagationDUnitTest.class, "createPR", args);
        dataStore2.invoke(PRDeltaPropagationDUnitTest.class, "createPR", args);
    }

    public static void createPR(String partitionedRegionName, Integer redundancy, Integer localMaxMemory, Integer totalNumBuckets, Boolean setExpiry, Compressor compressor) {
        PartitionAttributesFactory paf = new PartitionAttributesFactory();
        PartitionAttributes prAttr = paf.setRedundantCopies(redundancy.intValue()).setLocalMaxMemory(localMaxMemory.intValue()).setTotalNumBuckets(totalNumBuckets.intValue()).create();
        AttributesFactory attr = new AttributesFactory();
        attr.setPartitionAttributes(prAttr);
        attr.setDataPolicy(DataPolicy.PARTITION);
        attr.setConcurrencyChecksEnabled(true);
        if (setExpiry.booleanValue()) {
            attr.setStatisticsEnabled(true);
            attr.setEntryIdleTimeout(new ExpirationAttributes(1, ExpirationAction.INVALIDATE));
        }
        if (compressor != null) {
            attr.setCompressor(compressor);
        }
        PRDeltaPropagationDUnitTest.assertNotNull((Object)cache);
        deltaPR = cache.createRegion(partitionedRegionName, attr.create());
        PRDeltaPropagationDUnitTest.assertNotNull((Object)deltaPR);
        PRDeltaPropagationDUnitTest.getLogWriter().info("Partitioned Region " + partitionedRegionName + " created Successfully :" + deltaPR);
    }

    public static Integer createCacheServerWithPR(String partitionedRegionName, Integer redundancy, Integer localMaxMemory, Integer totalNumBuckets, Boolean setExpiry, Compressor compressor) {
        new PRDeltaPropagationDUnitTest("temp").createCache(new Properties());
        PRDeltaPropagationDUnitTest.createPR(partitionedRegionName, redundancy, localMaxMemory, totalNumBuckets, setExpiry, compressor);
        PRDeltaPropagationDUnitTest.assertNotNull((Object)deltaPR);
        deltaPR.put((Object)DELTA_KEY, (Object)new PRDeltaTestImpl());
        BridgeServer server1 = cache.addBridgeServer();
        PRDeltaPropagationDUnitTest.assertNotNull((Object)server1);
        int port = AvailablePort.getRandomAvailablePort((int)0);
        server1.setPort(port);
        try {
            server1.start();
        }
        catch (IOException e) {
            PRDeltaPropagationDUnitTest.fail("Failed to start the Server", e);
        }
        PRDeltaPropagationDUnitTest.assertTrue((boolean)server1.isRunning());
        return new Integer(server1.getPort());
    }

    public static Integer createServerCache(Boolean isListAttach, Boolean isEmpty) throws Exception {
        Properties props = new Properties();
        new PRDeltaPropagationDUnitTest("temp").createCache(props);
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setConcurrencyChecksEnabled(true);
        if (isEmpty.booleanValue()) {
            factory.setDataPolicy(DataPolicy.EMPTY);
        } else {
            factory.setDataPolicy(DataPolicy.REPLICATE);
        }
        lastKeyReceived = false;
        RegionAttributes attrs = factory.create();
        deltaPR = cache.createRegion(REGION_NAME, attrs);
        AttributesMutator am = deltaPR.getAttributesMutator();
        if (isListAttach.booleanValue()) {
            am.addCacheListener((CacheListener)new CacheListenerAdapter(){

                public void afterCreate(EntryEvent event) {
                    if (event.getNewValue() == null) {
                        isFailed = true;
                    }
                    if (event.getKey().equals(LAST_KEY)) {
                        lastKeyReceived = true;
                    }
                }

                public void afterUpdate(EntryEvent event) {
                    if (event.getNewValue() == null) {
                        isFailed = true;
                    }
                }
            });
        }
        CacheServer server = cache.addCacheServer();
        int port = AvailablePort.getRandomAvailablePort((int)0);
        server.setPort(port);
        server.setNotifyBySubscription(true);
        server.start();
        return new Integer(server.getPort());
    }

    public static void createClientCache(Integer port1, Boolean subscriptionEnable, Boolean isEmpty, Boolean isCq) throws Exception {
        PRDeltaPropagationDUnitTest test = new PRDeltaPropagationDUnitTest("temp");
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        test.createCache(props);
        lastKeyReceived = false;
        queryUpdateExecuted = false;
        queryDestroyExecuted = false;
        notADeltaInstanceObj = false;
        isFailed = false;
        procced = false;
        numValidCqEvents = 0;
        PoolImpl p = (PoolImpl)PoolManager.createFactory().addServer("localhost", port1.intValue()).setSubscriptionEnabled(true).setSubscriptionRedundancy(0).setThreadLocalConnections(true).setMinConnections(6).setReadTimeout(20000).setPingInterval(10000L).setRetryAttempts(5).create("PRDeltaPropagationDUnitTestPool");
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        factory.setConcurrencyChecksEnabled(true);
        if (isEmpty.booleanValue()) {
            factory.setSubscriptionAttributes(new SubscriptionAttributes(InterestPolicy.ALL));
            factory.setDataPolicy(DataPolicy.EMPTY);
        }
        factory.setPoolName(p.getName());
        factory.setCloningEnabled(false);
        factory.addCacheListener((CacheListener)new CacheListenerAdapter(){

            public void afterCreate(EntryEvent event) {
                if (LAST_KEY.equals(event.getKey())) {
                    lastKeyReceived = true;
                }
            }
        });
        RegionAttributes attrs = factory.create();
        deltaPR = cache.createRegion(REGION_NAME, attrs);
        if (subscriptionEnable.booleanValue()) {
            deltaPR.registerInterest((Object)"ALL_KEYS");
        }
        pool = p;
        if (isCq.booleanValue()) {
            CqAttributesFactory cqf = new CqAttributesFactory();
            CqListenerAdapter cqlist = new CqListenerAdapter(){

                public void onEvent(CqEvent cqEvent) {
                    if (LAST_KEY.equals(cqEvent.getKey().toString())) {
                        lastKeyReceived = true;
                    } else if (!(cqEvent.getNewValue() instanceof Delta)) {
                        notADeltaInstanceObj = true;
                    } else if (cqEvent.getQueryOperation().isUpdate() && cqEvent.getBaseOperation().isUpdate() && DELTA_KEY.equals(cqEvent.getKey().toString())) {
                        queryUpdateExecuted = true;
                    } else if (cqEvent.getQueryOperation().isDestroy() && cqEvent.getBaseOperation().isUpdate() && DELTA_KEY.equals(cqEvent.getKey().toString())) {
                        queryDestroyExecuted = true;
                    }
                    if (forOldNewCQVarification && DELTA_KEY.equals(cqEvent.getKey().toString())) {
                        if (numValidCqEvents == 0 && ((DeltaTestImpl)cqEvent.getNewValue()).getIntVar() == 8) {
                            procced = true;
                        } else if (procced && numValidCqEvents == 1 && ((DeltaTestImpl)cqEvent.getNewValue()).getIntVar() == 10) {
                            isFailed = true;
                        }
                    }
                    numValidCqEvents++;
                }
            };
            cqf.addCqListener((CqListener)cqlist);
            CqAttributes cqa = cqf.create();
            CqQuery cq = cache.getQueryService().newCq("CQ_Delta", CQ, cqa);
            cq.execute();
        }
    }

    public static void createClientCache(Integer port1, Integer port2) throws Exception {
        PRDeltaPropagationDUnitTest test = new PRDeltaPropagationDUnitTest("temp");
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        test.createCache(props);
        lastKeyReceived = false;
        PoolImpl p = (PoolImpl)PoolManager.createFactory().addServer("localhost", port1.intValue()).addServer("localhost", port2.intValue()).setSubscriptionEnabled(true).setSubscriptionRedundancy(1).setThreadLocalConnections(true).setMinConnections(6).setReadTimeout(20000).setPingInterval(10000L).setRetryAttempts(5).create("PRDeltaPropagationDUnitTestPool");
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.LOCAL);
        factory.setPoolName(p.getName());
        factory.setCloningEnabled(false);
        factory.setConcurrencyChecksEnabled(true);
        factory.addCacheListener((CacheListener)new CacheListenerAdapter(){

            public void afterCreate(EntryEvent event) {
                if (LAST_KEY.equals(event.getKey())) {
                    lastKeyReceived = true;
                }
            }
        });
        RegionAttributes attrs = factory.create();
        deltaPR = cache.createRegion(REGION_NAME, attrs);
        deltaPR.registerInterest((Object)"ALL_KEYS");
        pool = p;
    }

    public static void createCacheInAllPRVms() {
        PRDeltaPropagationDUnitTest.createCacheInVm();
        dataStore1.invoke(PRDeltaPropagationDUnitTest.class, "createCacheInVm");
        dataStore2.invoke(PRDeltaPropagationDUnitTest.class, "createCacheInVm");
    }

    public static void put() throws Exception {
        DeltaTestImpl test = new DeltaTestImpl();
        deltaPR.put((Object)DELTA_KEY, (Object)test);
        test.setIntVar(10);
        deltaPR.put((Object)DELTA_KEY, (Object)test);
        test = new DeltaTestImpl();
        test.setStr("DELTA");
        deltaPR.put((Object)DELTA_KEY, (Object)test);
    }

    public static void putWithExpiry() throws Exception {
        DeltaTestImpl test = new DeltaTestImpl();
        deltaPR.put((Object)DELTA_KEY, (Object)test);
        test.setIntVar(10);
        deltaPR.put((Object)DELTA_KEY, (Object)test);
        Thread.sleep(2000L);
        test = new DeltaTestImpl();
        test.setStr("DELTA");
        deltaPR.put((Object)DELTA_KEY, (Object)test);
    }

    public static int putsWhichReturnsDeltaSent() throws Exception {
        prDelta = new PRDeltaTestImpl();
        for (int i = 0; i < 10; ++i) {
            prDelta.setIntVar(i);
            deltaPR.put((Object)DELTA_KEY, (Object)prDelta);
        }
        deltaPR.put((Object)LAST_KEY, (Object)"");
        return PRDeltaPropagationDUnitTest.prDelta.deltaSent;
    }

    public static Boolean checkForDelta() {
        if (DeltaTestImpl.fromDeltaFeatureUsed().booleanValue()) {
            PRDeltaPropagationDUnitTest.assertTrue((((DeltaTestImpl)deltaPR.getEntry((Object)"DELTA_KEY").getValue()).getIntVar() == 10 ? 1 : 0) != 0);
            PRDeltaPropagationDUnitTest.assertTrue((boolean)((DeltaTestImpl)deltaPR.getEntry((Object)"DELTA_KEY").getValue()).getStr().equals("DELTA"));
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static void checkForFullObject() {
        PRDeltaPropagationDUnitTest.assertFalse((((DeltaTestImpl)deltaPR.getEntry((Object)"DELTA_KEY").getValue()).getIntVar() == 10 ? 1 : 0) != 0);
        PRDeltaPropagationDUnitTest.assertTrue((boolean)((DeltaTestImpl)deltaPR.getEntry((Object)"DELTA_KEY").getValue()).getStr().equals("DELTA"));
    }

    public static void checkDeltaInvoked(Integer deltaSent) {
        PRDeltaPropagationDUnitTest.assertTrue((String)("Delta applied :" + ((PRDeltaTestImpl)((Object)deltaPR.get((Object)"DELTA_KEY"))).getDeltaApplied() + "\n Delta sent :" + deltaSent), (((PRDeltaTestImpl)((Object)deltaPR.get((Object)"DELTA_KEY"))).getDeltaApplied() == deltaSent.intValue() ? 1 : 0) != 0);
    }

    public static void waitForLastKey() {
        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return PRDeltaPropagationDUnitTest.isLastKeyReceived();
            }

            @Override
            public String description() {
                return "Last key NOT received.";
            }
        };
        DistributedTestCase.waitForCriterion(wc, 10000L, 100L, true);
    }

    public static Boolean verifyQueryUpdateExecuted() {
        return queryUpdateExecuted;
    }

    public static Boolean verifyQueryDestroyExecuted() {
        return queryDestroyExecuted;
    }

    public static Boolean checkVMRecievesDeltaObjectThrCQListner() {
        return notADeltaInstanceObj;
    }

    public static boolean isLastKeyReceived() {
        return lastKeyReceived;
    }

    public static void verifyDeltaSent(Integer deltas) {
        CacheClientNotifier ccn = ((BridgeServerImpl)cache.getCacheServers().toArray()[0]).getAcceptor().getCacheClientNotifier();
        int numOfDeltasSent = ((CacheClientProxy)ccn.getClientProxies().toArray()[0]).getStatistics().getDeltaMessagesSent();
        PRDeltaPropagationDUnitTest.assertTrue((String)("Expected " + deltas + " deltas to be sent but " + numOfDeltasSent + " were sent."), (numOfDeltasSent == deltas ? 1 : 0) != 0);
    }

    public static void resetAll() {
        DeltaTestImpl.resetDeltaInvokationCounters();
        ConflationDUnitTest.unsetIsSlowStart();
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        PRDeltaPropagationDUnitTest.closeCache();
        client1.invoke(PRDeltaPropagationDUnitTest.class, "closeCache");
        dataStore1.invoke(PRDeltaPropagationDUnitTest.class, "closeCache");
        dataStore2.invoke(PRDeltaPropagationDUnitTest.class, "closeCache");
        dataStore3.invoke(PRDeltaPropagationDUnitTest.class, "closeCache");
    }

    public static void closeCache() {
        if (cache != null && !cache.isClosed()) {
            cache.close();
            cache.getDistributedSystem().disconnect();
            DeltaTestImpl.resetDeltaInvokationCounters();
            isFailed = false;
        }
    }

    public static void setForOldNewCQVarification(Boolean forOldNewCQVarification) {
        PRDeltaPropagationDUnitTest.forOldNewCQVarification = forOldNewCQVarification;
    }

    static class PRDeltaTestImpl
    extends DeltaTestImpl {
        int deltaSent = 0;
        int deltaApplied = 0;

        public void toDelta(DataOutput out) throws IOException {
            super.toDelta(out);
            ++this.deltaSent;
        }

        public void fromDelta(DataInput in) throws IOException {
            super.fromDelta(in);
            ++this.deltaApplied;
        }

        public int getDeltaSent() {
            return this.deltaSent;
        }

        public int getDeltaApplied() {
            return this.deltaApplied;
        }

        public String toString() {
            return "PRDeltaTestImpl[deltaApplied=" + this.deltaApplied + "]" + super.toString();
        }
    }
}

