/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.EvictionAction;
import com.gemstone.gemfire.cache.EvictionAlgorithm;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.util.ObjectSizer;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.OSProcess;
import com.gemstone.gemfire.internal.SharedLibrary;
import com.gemstone.gemfire.internal.cache.AbstractLRURegionEntry;
import com.gemstone.gemfire.internal.cache.AbstractLRURegionMap;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.CachedDeserializableFactory;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.TestNonSizerObject;
import com.gemstone.gemfire.internal.cache.TestObjectSizerImpl;
import com.gemstone.gemfire.internal.cache.lru.HeapLRUCapacityController;
import com.gemstone.gemfire.internal.cache.lru.Sizeable;
import com.gemstone.gemfire.internal.size.ReflectionSingleObjectSizer;
import java.io.File;
import java.util.Map;
import java.util.Properties;

public class EvictionObjectSizerDUnitTest
extends CacheTestCase {
    protected static Cache cache = null;
    static int maxEnteries = 20;
    static int maxSizeInMb = 20;
    protected static Region region = null;
    private static final long serialVersionUID = 1L;

    public EvictionObjectSizerDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
    }

    public void testWithoutObjectSizerForHeapLRU() {
        this.prepareScenario(EvictionAlgorithm.LRU_HEAP, null);
        EvictionObjectSizerDUnitTest.putData("PR1", 2, 1);
        int keySize = SharedLibrary.getObjectHeaderSize() + 4;
        keySize = (int)ReflectionSingleObjectSizer.roundUpSize((long)keySize);
        int valueSize = SharedLibrary.getObjectHeaderSize() + 4 + 0x100000;
        valueSize = (int)ReflectionSingleObjectSizer.roundUpSize((long)valueSize);
        int entrySize = keySize + valueSize + ((HeapLRUCapacityController)((PartitionedRegion)region).getEvictionController()).getPerEntryOverhead();
        EvictionObjectSizerDUnitTest.verifySize("PR1", 2, entrySize);
        EvictionObjectSizerDUnitTest.assertEquals((long)(2 * entrySize), (long)((PartitionedRegion)region).getEvictionController().getLRUHelper().getStats().getCounter());
    }

    public void testObjectSizerForHeapLRU_StandardObjects() {
        this.prepareScenario(EvictionAlgorithm.LRU_HEAP, new TestObjectSizerImpl());
        EvictionObjectSizerDUnitTest.putData("PR1", 2, 1);
        int keySize = 5;
        int valueSize = SharedLibrary.getObjectHeaderSize() + 4 + 0x100000;
        valueSize = (int)ReflectionSingleObjectSizer.roundUpSize((long)valueSize);
        int entrySize = keySize + valueSize + ((HeapLRUCapacityController)((PartitionedRegion)region).getEvictionController()).getPerEntryOverhead();
        EvictionObjectSizerDUnitTest.verifySize("PR1", 2, entrySize);
        EvictionObjectSizerDUnitTest.putData("PR1", 2, 2);
        keySize = 5;
        valueSize = SharedLibrary.getObjectHeaderSize() + 4 + 0x200000;
        valueSize = (int)ReflectionSingleObjectSizer.roundUpSize((long)valueSize);
        entrySize = keySize + valueSize + ((HeapLRUCapacityController)((PartitionedRegion)region).getEvictionController()).getPerEntryOverhead();
        EvictionObjectSizerDUnitTest.verifySize("PR1", 2, entrySize);
    }

    public void testObjectSizerForHeapLRU_CustomizedNonSizerObject() {
        this.prepareScenario(EvictionAlgorithm.LRU_HEAP, new TestObjectSizerImpl());
        this.putCustomizedData(1, new byte[0]);
        int keySize = 5;
        int valueSize = SharedLibrary.getObjectHeaderSize() + 4 + 0;
        valueSize = (int)ReflectionSingleObjectSizer.roundUpSize((long)valueSize);
        int entrySize = keySize + valueSize + ((HeapLRUCapacityController)((PartitionedRegion)region).getEvictionController()).getPerEntryOverhead();
        EvictionObjectSizerDUnitTest.getLogWriter().info("testObjectSizerForHeapLRU_CustomizedNonSizerObject expected= " + entrySize);
        EvictionObjectSizerDUnitTest.assertEquals((int)entrySize, (int)this.getSizeOfCustomizedData(1));
        this.putCustomizedData(2, new byte[4]);
        keySize = 5;
        valueSize = SharedLibrary.getObjectHeaderSize() + 4 + 4;
        valueSize = (int)ReflectionSingleObjectSizer.roundUpSize((long)valueSize);
        entrySize = keySize + valueSize + ((HeapLRUCapacityController)((PartitionedRegion)region).getEvictionController()).getPerEntryOverhead();
        EvictionObjectSizerDUnitTest.getLogWriter().info("testObjectSizerForHeapLRU_CustomizedNonSizerObject expected= " + entrySize);
        EvictionObjectSizerDUnitTest.assertEquals((int)entrySize, (int)this.getSizeOfCustomizedData(2));
    }

    public void testObjectSizerForHeapLRU_CustomizedSizerObject() {
        this.prepareScenario(EvictionAlgorithm.LRU_HEAP, new TestObjectSizerImpl());
        this.putCustomizedData(1, new TestObjectSizerImpl());
        int expected = 165 + Sizeable.PER_OBJECT_OVERHEAD * 2 + ((HeapLRUCapacityController)((PartitionedRegion)region).getEvictionController()).getPerEntryOverhead();
        if (CachedDeserializableFactory.preferObject()) {
            expected -= 200;
        }
        EvictionObjectSizerDUnitTest.getLogWriter().info("testObjectSizerForHeapLRU_CustomizedSizerObject expected= " + expected);
        EvictionObjectSizerDUnitTest.assertEquals((int)expected, (int)this.getSizeOfCustomizedData(1));
        EvictionObjectSizerDUnitTest.assertEquals((long)expected, (long)((PartitionedRegion)region).getEvictionController().getLRUHelper().getStats().getCounter());
    }

    public void testObjectSizerForHeapLRU_CustomizedSizerObjects() {
        this.prepareScenario(EvictionAlgorithm.LRU_HEAP, new TestObjectSizerImpl());
        this.putCustomizedObjects(new TestNonSizerObject("1"), new TestObjectSizerImpl());
        int expected = 161 + Sizeable.PER_OBJECT_OVERHEAD * 2 + ((HeapLRUCapacityController)((PartitionedRegion)region).getEvictionController()).getPerEntryOverhead();
        if (CachedDeserializableFactory.preferObject()) {
            expected -= 200;
        }
        EvictionObjectSizerDUnitTest.getLogWriter().info("testObjectSizerForHeapLRU_CustomizedSizerObjects expected= " + expected);
        EvictionObjectSizerDUnitTest.assertEquals((int)expected, (int)this.getSizeOfCustomizedObject(new TestNonSizerObject("1")));
        EvictionObjectSizerDUnitTest.assertEquals((long)expected, (long)((PartitionedRegion)region).getEvictionController().getLRUHelper().getStats().getCounter());
    }

    public void prepareScenario(EvictionAlgorithm evictionAlgorithm, ObjectSizer sizer) {
        this.createCache();
        EvictionObjectSizerDUnitTest.createPartitionedRegion(true, evictionAlgorithm, "PR1", 1, 1, 10000, sizer);
    }

    public void createCache() {
        try {
            Properties props = new Properties();
            InternalDistributedSystem ds = this.getSystem(props);
            EvictionObjectSizerDUnitTest.assertNotNull((Object)ds);
            ds.disconnect();
            ds = this.getSystem(props);
            cache = CacheFactory.create((DistributedSystem)ds);
            EvictionObjectSizerDUnitTest.assertNotNull((Object)cache);
            EvictionObjectSizerDUnitTest.getLogWriter().info("cache= " + cache);
            EvictionObjectSizerDUnitTest.getLogWriter().info("cache closed= " + cache.isClosed());
            cache.getResourceManager().setEvictionHeapPercentage(50.0f);
        }
        catch (Exception e) {
            EvictionObjectSizerDUnitTest.fail("Failed while creating the cache", e);
        }
    }

    public static void createPartitionedRegion(boolean setEvictionOn, EvictionAlgorithm evictionAlgorithm, String regionName, int totalNoOfBuckets, int evictionAction, int evictorInterval, ObjectSizer sizer) {
        AttributesFactory factory = new AttributesFactory();
        PartitionAttributesFactory partitionAttributesFactory = new PartitionAttributesFactory().setRedundantCopies(totalNoOfBuckets == 4 ? 0 : 1).setTotalNumBuckets(totalNoOfBuckets);
        factory.setConcurrencyChecksEnabled(false);
        factory.setPartitionAttributes(partitionAttributesFactory.create());
        if (setEvictionOn) {
            if (evictionAlgorithm.isLRUHeap()) {
                factory.setEvictionAttributes(EvictionAttributes.createLRUHeapAttributes((ObjectSizer)sizer, (EvictionAction)(evictionAction == 1 ? EvictionAction.LOCAL_DESTROY : EvictionAction.OVERFLOW_TO_DISK)));
            } else if (evictionAlgorithm.isLRUMemory()) {
                factory.setEvictionAttributes(EvictionAttributes.createLRUMemoryAttributes((int)maxSizeInMb, (ObjectSizer)sizer, (EvictionAction)(evictionAction == 1 ? EvictionAction.LOCAL_DESTROY : EvictionAction.OVERFLOW_TO_DISK)));
            } else {
                factory.setEvictionAttributes(EvictionAttributes.createLRUEntryAttributes((int)maxEnteries, (EvictionAction)(evictionAction == 1 ? EvictionAction.LOCAL_DESTROY : EvictionAction.OVERFLOW_TO_DISK)));
            }
            if (evictionAction == 2) {
                factory.setDiskSynchronous(true);
                File[] diskDirs = new File[]{new File("Partitioned_Region_Eviction/LogFile_" + OSProcess.getId())};
                diskDirs[0].mkdirs();
                factory.setDiskStoreName(cache.createDiskStoreFactory().setDiskDirs(diskDirs).create("EvictionObjectSizerDUnitTest").getName());
            }
        }
        region = cache.createRegion(regionName, factory.create());
        EvictionObjectSizerDUnitTest.assertNotNull((Object)region);
        EvictionObjectSizerDUnitTest.getLogWriter().info("Partitioned Region created Successfully :" + region);
    }

    public static int putData(String regionName, int noOfElememts, int sizeOfElement) {
        int result = 0;
        Region pr = cache.getRegion(regionName);
        for (int counter = 1; counter <= noOfElememts; ++counter) {
            byte[] baValue = new byte[sizeOfElement * 1024 * 1024];
            int baSize = CachedDeserializableFactory.getByteSize((byte[])baValue);
            result += baSize;
            pr.put((Object)new Integer(counter), (Object)baValue);
        }
        return result;
    }

    public static void verifySize(String regionName, int noOfElememts, int entrySize) {
        Region pr = cache.getRegion(regionName);
        for (Map.Entry entry : ((PartitionedRegion)pr).getDataStore().getAllLocalBuckets()) {
            AbstractLRURegionMap map;
            BucketRegion bucketRegion = (BucketRegion)entry.getValue();
            if (bucketRegion == null || (map = (AbstractLRURegionMap)bucketRegion.entries) == null || map.size() == 0) continue;
            EvictionObjectSizerDUnitTest.getLogWriter().info("Checking for entry in bucket region: " + bucketRegion);
            for (int counter = 1; counter <= noOfElememts; ++counter) {
                EvictionObjectSizerDUnitTest.assertEquals((int)entrySize, (int)((AbstractLRURegionEntry)map.getEntry((Object)new Integer(counter))).getEntrySize());
            }
        }
    }

    private void putCustomizedData(int counter, Object object) {
        Region pr = cache.getRegion("PR1");
        pr.put((Object)new Integer(counter), object);
    }

    private void putCustomizedObjects(Object key, Object value) {
        Region pr = cache.getRegion("PR1");
        pr.put(key, value);
    }

    private int getSizeOfCustomizedData(int counter) {
        Region pr = cache.getRegion("PR1");
        for (Map.Entry entry : ((PartitionedRegion)pr).getDataStore().getAllLocalBuckets()) {
            BucketRegion bucketRegion = (BucketRegion)entry.getValue();
            if (bucketRegion == null) continue;
            AbstractLRURegionMap map = (AbstractLRURegionMap)bucketRegion.entries;
            return ((AbstractLRURegionEntry)map.getEntry((Object)new Integer(counter))).getEntrySize();
        }
        return 0;
    }

    private int getSizeOfCustomizedObject(Object object) {
        Region pr = cache.getRegion("PR1");
        for (Map.Entry entry : ((PartitionedRegion)pr).getDataStore().getAllLocalBuckets()) {
            AbstractLRURegionMap map;
            AbstractLRURegionEntry re;
            BucketRegion bucketRegion = (BucketRegion)entry.getValue();
            if (bucketRegion == null || (re = (AbstractLRURegionEntry)(map = (AbstractLRURegionMap)bucketRegion.entries).getEntry(object)) == null) continue;
            return re.getEntrySize();
        }
        return 0;
    }
}

