/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.PoolFactory;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.TestDelta;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.SerializableRunnable;
import dunit.VM;
import java.io.Serializable;

public class DeltaSizingDUnitTest
extends CacheTestCase {
    public DeltaSizingDUnitTest(String name) {
        super(name);
    }

    public void testPeerWithoutCloning() throws Exception {
        this.doPeerTest(false, false);
    }

    public void testPeerWithCloning() throws Exception {
        this.doPeerTest(true, false);
    }

    public void testPeerWithCopyOnRead() throws Exception {
        this.doPeerTest(false, true);
    }

    public void testPeerWithCopyOnAndClone() throws Exception {
        this.doPeerTest(true, true);
    }

    public void testClientWithoutCloning() throws Exception {
        this.doClientTest(false, false);
    }

    public void testClientWithCloning() throws Exception {
        this.doClientTest(true, false);
    }

    public void testClientWithCopyOnRead() throws Exception {
        this.doClientTest(false, true);
    }

    public void testClientWithCopyOnAndClone() throws Exception {
        this.doClientTest(true, true);
    }

    private void doPeerTest(final boolean clone, boolean copyOnRead) throws Exception {
        AccessorFactory factory = new AccessorFactory(){

            @Override
            public Region<Integer, TestDelta> createRegion(Host host, Cache cache, int port1, int port2) {
                AttributesFactory attr = new AttributesFactory();
                attr.setCloningEnabled(clone);
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setRedundantCopies(1);
                paf.setLocalMaxMemory(0);
                PartitionAttributes prAttr = paf.create();
                attr.setPartitionAttributes(prAttr);
                attr.setDataPolicy(DataPolicy.PARTITION);
                Region region = cache.createRegion("region1", attr.create());
                return region;
            }
        };
        this.doTest(factory, clone, copyOnRead);
    }

    private void doClientTest(final boolean clone, boolean copyOnRead) throws Exception {
        AccessorFactory factory = new AccessorFactory(){

            @Override
            public Region<Integer, TestDelta> createRegion(Host host, Cache cache, int port1, int port2) {
                AttributesFactory attr = new AttributesFactory();
                PoolFactory pf = PoolManager.createFactory();
                pf.addServer(DistributedTestCase.getServerHostName(host), port1);
                pf.addServer(DistributedTestCase.getServerHostName(host), port2);
                pf.create("pool");
                attr.setCloningEnabled(clone);
                attr.setDataPolicy(DataPolicy.EMPTY);
                attr.setScope(Scope.LOCAL);
                attr.setPoolName("pool");
                Region region = cache.createRegion("region1", attr.create());
                return region;
            }
        };
        this.doTest(factory, clone, copyOnRead);
    }

    public void doTest(final AccessorFactory accessorFactory, final boolean clone, final boolean copyOnRead) throws InterruptedException {
        final Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        SerializableCallable createDataRegion = new SerializableCallable("createRegion"){

            public Object call() throws Exception {
                Cache cache = DeltaSizingDUnitTest.this.getCache();
                cache.setCopyOnRead(copyOnRead);
                AttributesFactory attr = new AttributesFactory();
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setRedundantCopies(1);
                PartitionAttributes prAttr = paf.create();
                attr.setPartitionAttributes(prAttr);
                attr.setCloningEnabled(clone);
                cache.createRegion("region1", attr.create());
                CacheServer server = cache.addCacheServer();
                int port = AvailablePortHelper.getRandomAvailableTCPPort();
                server.setPort(port);
                server.start();
                return port;
            }
        };
        final Integer port1 = (Integer)vm0.invoke(createDataRegion);
        final Integer port2 = (Integer)vm1.invoke(createDataRegion);
        SerializableRunnable createEmptyRegion = new SerializableRunnable("createRegion"){

            @Override
            public void run() {
                Cache cache = DeltaSizingDUnitTest.this.getCache();
                cache.setCopyOnRead(copyOnRead);
                Region<Integer, TestDelta> region = accessorFactory.createRegion(host, cache, port1, port2);
                region.put((Object)new Integer(113), (Object)new TestDelta(false, "bogus"));
                region.put((Object)new Integer(0), (Object)new TestDelta(false, "initial"));
            }
        };
        vm2.invoke(createEmptyRegion);
        int clones = 0;
        long size = this.checkObjects(vm0, 1, 1, 0, clones);
        DeltaSizingDUnitTest.assertEquals((long)size, (long)this.checkObjects(vm1, 1, 1, 0, clones));
        vm2.invoke(new SerializableRunnable("update"){

            @Override
            public void run() {
                Cache cache = DeltaSizingDUnitTest.this.getCache();
                Region region = cache.getRegion("region1");
                region.put((Object)new Integer(0), (Object)new TestDelta(true, "changedAAAAAAAA"));
            }
        });
        clones = 0;
        if (copyOnRead) {
            ++clones;
        } else if (clone) {
            ++clones;
        }
        DeltaSizingDUnitTest.assertEquals((long)size, (long)this.checkObjects(vm0, 1, 1, 1, clones));
        DeltaSizingDUnitTest.assertEquals((long)size, (long)this.checkObjects(vm1, 1, 1, 1, clones));
        vm2.invoke(new SerializableRunnable("update"){

            @Override
            public void run() {
                Cache cache = DeltaSizingDUnitTest.this.getCache();
                Region region = cache.getRegion("region1");
                region.put((Object)new Integer(0), (Object)new TestDelta(true, "changedBBBBBBB"));
            }
        });
        if (clone || copyOnRead) {
            ++clones;
        }
        if (copyOnRead) {
            ++clones;
        }
        DeltaSizingDUnitTest.assertEquals((long)size, (long)this.checkObjects(vm0, 1, 1, 2, clones));
        DeltaSizingDUnitTest.assertEquals((long)size, (long)this.checkObjects(vm1, 1, 1, 2, clones));
    }

    private long checkObjects(VM vm, final int serializations, final int deserializations, final int deltas, final int clones) {
        SerializableCallable getSize = new SerializableCallable("check objects"){

            public Object call() {
                GemFireCacheImpl cache = (GemFireCacheImpl)DeltaSizingDUnitTest.this.getCache();
                PartitionedRegion region = (PartitionedRegion)cache.getRegion("region1");
                long size = region.getDataStore().getBucketSize(0);
                TestDelta value = (TestDelta)region.get((Object)0);
                value.checkFields(serializations, deserializations, deltas, clones);
                return size;
            }
        };
        Object size = vm.invoke(getSize);
        return (Long)size;
    }

    private static interface AccessorFactory
    extends Serializable {
        public Region<Integer, TestDelta> createRegion(Host var1, Cache var2, int var3, int var4);
    }
}

