/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.CacheWriter;
import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.util.CacheWriterAdapter;
import com.gemstone.gemfire.cache.util.Gateway;
import com.gemstone.gemfire.cache.util.GatewayHub;
import com.gemstone.gemfire.cache.util.GatewayQueueAttributes;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.AvailablePort;
import delta.DeltaTestObj;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.util.Properties;
import junit.framework.TestCase;

public class DeltaPropgationWanValidationDUnitTest
extends DistributedTestCase {
    private static final String REGION_NAME = "DeltaPropgationWanValidationDUnitTest_region";
    private static Cache cache = null;
    VM wan1 = null;
    VM wan2 = null;
    private static Integer ePort1;
    private static Integer ePort2;
    private static String key1;
    private static String key2;
    private static int lastUpdatedVal;
    static DeltaPropgationWanValidationDUnitTest impl;

    public DeltaPropgationWanValidationDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        DeltaPropgationWanValidationDUnitTest.disconnectAllFromDS();
        DeltaPropgationWanValidationDUnitTest.pause(5000);
        Host host = Host.getHost(0);
        this.wan1 = host.getVM(0);
        this.wan2 = host.getVM(1);
        this.wan1.invoke(this.getClass(), "createImpl", null);
        this.wan2.invoke(this.getClass(), "createImpl", null);
    }

    public static void createImpl() {
        impl = new DeltaPropgationWanValidationDUnitTest("temp");
    }

    public void testDeltaPropgationValidationWan() {
        ePort2 = new Integer(AvailablePort.getRandomAvailablePort((int)0));
        ePort1 = new Integer(AvailablePort.getRandomAvailablePort((int)0));
        this.wan1.invoke(this.getClass(), "createServerCache", new Object[]{"EU", "1", ePort1, ePort2, DeltaPropgationWanValidationDUnitTest.getServerHostName(this.wan1.getHost())});
        this.wan2.invoke(this.getClass(), "createServerCache", new Object[]{"NY", "2", ePort2, ePort1, DeltaPropgationWanValidationDUnitTest.getServerHostName(this.wan2.getHost())});
        try {
            Thread.sleep(10000L);
            this.wan1.invoke(this.getClass(), "doPuts", new Object[]{key1});
            this.wan2.invoke(this.getClass(), "doPuts", new Object[]{key2});
            Thread.sleep(10000L);
        }
        catch (InterruptedException e) {
            DeltaPropgationWanValidationDUnitTest.fail((String)"interrupted");
        }
        this.wan2.invoke(this.getClass(), "doGet", new Object[]{new Integer(2)});
        this.wan1.invoke(this.getClass(), "doGet", new Object[]{new Integer(2)});
    }

    public static Object createServerCache(String site, String name, Integer ePort1, Integer ePort2, String host) throws Exception {
        Properties props = new Properties();
        int mcast_port = AvailablePort.getRandomAvailablePort((int)1);
        props.setProperty("mcast-port", mcast_port + "");
        props.setProperty("locators", "");
        cache = impl.createCache(props);
        AttributesFactory factory = impl.getServerCacheAttributesFactory();
        factory.setEnableGateway(true);
        factory.setCacheWriter((CacheWriter)new CacheWriterAdapter(){

            public void beforeCreate(EntryEvent event) throws CacheWriterException {
                cache.getLogger().info("event before create" + event.toString());
            }

            public void beforeUpdate(EntryEvent event) throws CacheWriterException {
                cache.getLogger().info("event before update " + (Object)((Object)((DeltaTestObj)((Object)event.getNewValue()))));
                TestCase.assertEquals((long)((DeltaTestObj)((Object)event.getNewValue())).getFromDeltaCounter(), (long)0L);
            }
        });
        factory.setCloningEnabled(false);
        factory.setConcurrencyChecksEnabled(false);
        RegionAttributes attrs = factory.create();
        cache.createRegion(REGION_NAME, attrs);
        GatewayHub hub1 = cache.addGatewayHub("GatewayHub" + name, ePort1.intValue());
        Gateway gateway1 = hub1.addGateway("Gateway" + name + ePort1);
        gateway1.addEndpoint(site, host, ePort2.intValue());
        cache.getLogger().info("site :: " + site + "endPoint port:::" + ePort2);
        GatewayQueueAttributes queueAttributes = gateway1.getQueueAttributes();
        queueAttributes.setMaximumQueueMemory(1);
        queueAttributes.setBatchSize(1);
        DeltaPropgationWanValidationDUnitTest.setDiskStoreForGateway(cache, gateway1.getId(), queueAttributes);
        hub1.start();
        gateway1.start();
        return new Integer(0);
    }

    protected AttributesFactory getServerCacheAttributesFactory() {
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setDataPolicy(DataPolicy.REPLICATE);
        return factory;
    }

    private Cache createCache(Properties props) throws Exception {
        InternalDistributedSystem ds = this.getSystem(props);
        Cache cache = null;
        cache = CacheFactory.create((DistributedSystem)ds);
        if (cache == null) {
            throw new Exception("CacheFactory.create() returned null ");
        }
        return cache;
    }

    @Override
    public void tearDown2() throws Exception {
        this.wan1.invoke(this.getClass(), "closeCache");
        this.wan2.invoke(this.getClass(), "closeCache");
        cache = null;
        DeltaPropgationWanValidationDUnitTest.invokeInEveryVM(new SerializableRunnable(){

            @Override
            public void run() {
                cache = null;
            }
        });
    }

    public static void closeCache() {
        if (cache != null && !cache.isClosed()) {
            cache.close();
            cache.getDistributedSystem().disconnect();
        }
    }

    public static void doPuts(String key) throws Exception {
        Region region1 = cache.getRegion("/DeltaPropgationWanValidationDUnitTest_region");
        DeltaTestObj obj = new DeltaTestObj();
        region1.put((Object)key, (Object)obj);
        int i = 1;
        while (i < 200) {
            obj.setIntVar(i);
            cache.getLogger().info("put happened value : " + (Object)((Object)obj));
            region1.put((Object)key, (Object)obj);
            lastUpdatedVal = i++;
        }
        cache.getLogger().info("put happened for key : " + key);
    }

    public static void doGet(final Integer n) throws Exception {
        final Region reg = cache.getRegion("/DeltaPropgationWanValidationDUnitTest_region");
        DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){
            String excuse;

            @Override
            public boolean done() {
                int curSize = reg.keySet().size();
                if (n == curSize) {
                    TestCase.assertTrue((((DeltaTestObj)((Object)reg.get((Object)key1))).getIntVar() == lastUpdatedVal ? 1 : 0) != 0);
                    TestCase.assertTrue((((DeltaTestObj)((Object)reg.get((Object)key2))).getIntVar() == lastUpdatedVal ? 1 : 0) != 0);
                    return true;
                }
                this.excuse = "Current size " + curSize + " not expected size " + n;
                return false;
            }

            @Override
            public String description() {
                return this.excuse;
            }
        };
        DistributedTestCase.waitForCriterion(wc, 120000L, 1000L, true);
    }

    static {
        key1 = "key1";
        key2 = "key2";
    }
}

