/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.InterestResultPolicy;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionFactory;
import com.gemstone.gemfire.cache.RegionShortcut;
import com.gemstone.gemfire.cache.client.ClientCache;
import com.gemstone.gemfire.cache.client.ClientCacheFactory;
import com.gemstone.gemfire.cache.client.ClientRegionShortcut;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.SerializableRunnable;
import dunit.VM;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

public class ClientServerInvalidAndDestroyedEntryDUnitTest
extends CacheTestCase {
    public ClientServerInvalidAndDestroyedEntryDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        ClientServerInvalidAndDestroyedEntryDUnitTest.disconnectAllFromDS();
    }

    public void testClientGetsInvalidEntry() throws Exception {
        String regionName = this.getUniqueName() + "Region";
        this.doTestClientGetsInvalidEntry(regionName, false, false);
    }

    public void testClientGetsInvalidEntryPR() throws Exception {
        String regionName = this.getUniqueName() + "Region";
        this.doTestClientGetsInvalidEntry(regionName, true, false);
    }

    public void testClientGetsTombstone() throws Exception {
        String regionName = this.getUniqueName() + "Region";
        this.doTestClientGetsTombstone(regionName, false, false);
    }

    public void testClientGetsTombstonePR() throws Exception {
        String regionName = this.getUniqueName() + "Region";
        this.doTestClientGetsTombstone(regionName, true, false);
    }

    public void Bug44146_testClientGetsInvalidEntryTX() throws Exception {
        String regionName = this.getUniqueName() + "Region";
        this.doTestClientGetsInvalidEntry(regionName, false, true);
    }

    public void Bug44146_testClientGetsInvalidEntryPRTX() throws Exception {
        String regionName = this.getUniqueName() + "Region";
        this.doTestClientGetsInvalidEntry(regionName, true, true);
    }

    public void Bug44146_testClientGetsTombstoneTX() throws Exception {
        String regionName = this.getUniqueName() + "Region";
        this.doTestClientGetsTombstone(regionName, false, true);
    }

    public void Bug44146_testClientGetsTombstonePRTX() throws Exception {
        String regionName = this.getUniqueName() + "Region";
        this.doTestClientGetsTombstone(regionName, true, true);
    }

    private Callable getCreateServerCallable(final String regionName, final boolean usePR) {
        return new SerializableCallable("create server and entries"){

            public Object call() {
                CacheServer server;
                Cache cache = ClientServerInvalidAndDestroyedEntryDUnitTest.this.getCache();
                List servers = cache.getCacheServers();
                if (servers.size() > 0) {
                    server = (CacheServer)servers.get(0);
                } else {
                    server = cache.addCacheServer();
                    int port = AvailablePortHelper.getRandomAvailableTCPPort();
                    server.setPort(port);
                    server.setHostnameForClients("localhost");
                    try {
                        server.start();
                    }
                    catch (IOException e) {
                        DistributedTestCase.fail("Failed to start server ", e);
                    }
                }
                if (usePR) {
                    RegionFactory factory = cache.createRegionFactory(RegionShortcut.PARTITION);
                    PartitionAttributesFactory pf = new PartitionAttributesFactory();
                    pf.setTotalNumBuckets(2);
                    factory.setPartitionAttributes(pf.create());
                    factory.create(regionName);
                } else {
                    cache.createRegionFactory(RegionShortcut.REPLICATE).create(regionName);
                }
                return server.getPort();
            }
        };
    }

    private void doTestClientGetsInvalidEntry(final String regionName, boolean usePR, boolean useTX) throws Exception {
        VM vm1 = Host.getHost(0).getVM(1);
        VM vm2 = Host.getHost(0).getVM(2);
        String notAffectedKey = "Object1";
        String nonexistantKey = usePR && useTX ? "IDoNotExist2" : "IDoNotExist1";
        String key1 = "Object10";
        final String key2 = usePR && useTX ? "Object12" : "Object11";
        Callable createServer = this.getCreateServerCallable(regionName, usePR);
        int serverPort = (Integer)vm1.invoke(createServer);
        vm2.invoke(createServer);
        vm1.invoke(new SerializableRunnable("populate server and create invalid entry"){

            @Override
            public void run() {
                Region myRegion = ClientServerInvalidAndDestroyedEntryDUnitTest.this.getCache().getRegion(regionName);
                for (int i = 1; i <= 20; ++i) {
                    myRegion.put((Object)("Object" + i), (Object)("Value" + i));
                }
                myRegion.invalidate((Object)"Object10");
                myRegion.invalidate((Object)key2);
            }
        });
        ClientServerInvalidAndDestroyedEntryDUnitTest.getLogWriter().info("creating client cache");
        ClientCache c = new ClientCacheFactory().addPoolServer("localhost", serverPort).create();
        Region myRegion = c.createClientRegionFactory(ClientRegionShortcut.CACHING_PROXY).create(regionName);
        if (useTX) {
            c.getCacheTransactionManager().begin();
        }
        ClientServerInvalidAndDestroyedEntryDUnitTest.assertNotNull((Object)myRegion.get((Object)"Object1"));
        ClientServerInvalidAndDestroyedEntryDUnitTest.getLogWriter().info("getting Object10 - should reach this cache and be INVALID");
        ClientServerInvalidAndDestroyedEntryDUnitTest.assertNull((Object)myRegion.get((Object)"Object10"));
        ClientServerInvalidAndDestroyedEntryDUnitTest.assertTrue((boolean)myRegion.containsKey((Object)"Object10"));
        ClientServerInvalidAndDestroyedEntryDUnitTest.assertNull((Object)myRegion.get((Object)key2));
        ClientServerInvalidAndDestroyedEntryDUnitTest.assertTrue((boolean)myRegion.containsKey((Object)key2));
        ClientServerInvalidAndDestroyedEntryDUnitTest.assertNull((Object)myRegion.get((Object)nonexistantKey));
        ClientServerInvalidAndDestroyedEntryDUnitTest.assertFalse((boolean)myRegion.containsKey((Object)nonexistantKey));
        if (useTX) {
            c.getCacheTransactionManager().commit();
            ClientServerInvalidAndDestroyedEntryDUnitTest.assertNotNull((Object)myRegion.get((Object)"Object1"));
            ClientServerInvalidAndDestroyedEntryDUnitTest.assertNull((Object)myRegion.get((Object)"Object10"));
            ClientServerInvalidAndDestroyedEntryDUnitTest.assertTrue((boolean)myRegion.containsKey((Object)"Object10"));
            ClientServerInvalidAndDestroyedEntryDUnitTest.assertNull((Object)myRegion.get((Object)key2));
            ClientServerInvalidAndDestroyedEntryDUnitTest.assertTrue((boolean)myRegion.containsKey((Object)key2));
        }
        myRegion.localDestroy((Object)"Object1");
        myRegion.localDestroy((Object)"Object10");
        myRegion.localDestroy((Object)key2);
        if (useTX) {
            c.getCacheTransactionManager().begin();
        }
        LinkedList<String> keys = new LinkedList<String>();
        keys.add("Object1");
        keys.add("Object10");
        keys.add(key2);
        Map result = myRegion.getAll(keys);
        ClientServerInvalidAndDestroyedEntryDUnitTest.assertNotNull(result.get("Object1"));
        ClientServerInvalidAndDestroyedEntryDUnitTest.assertNull(result.get("Object10"));
        ClientServerInvalidAndDestroyedEntryDUnitTest.assertNull(result.get(key2));
        ClientServerInvalidAndDestroyedEntryDUnitTest.assertTrue((boolean)result.containsKey("Object10"));
        ClientServerInvalidAndDestroyedEntryDUnitTest.assertTrue((boolean)result.containsKey(key2));
        ClientServerInvalidAndDestroyedEntryDUnitTest.assertTrue((boolean)myRegion.containsKey((Object)"Object10"));
        ClientServerInvalidAndDestroyedEntryDUnitTest.assertTrue((boolean)myRegion.containsKey((Object)key2));
        if (useTX) {
            c.getCacheTransactionManager().commit();
            ClientServerInvalidAndDestroyedEntryDUnitTest.assertNotNull((Object)myRegion.get((Object)"Object1"));
            ClientServerInvalidAndDestroyedEntryDUnitTest.assertNull((Object)myRegion.get((Object)"Object10"));
            ClientServerInvalidAndDestroyedEntryDUnitTest.assertTrue((boolean)myRegion.containsKey((Object)"Object10"));
            ClientServerInvalidAndDestroyedEntryDUnitTest.assertNull((Object)myRegion.get((Object)key2));
            ClientServerInvalidAndDestroyedEntryDUnitTest.assertTrue((boolean)myRegion.containsKey((Object)key2));
        }
        UpdateListener listener = new UpdateListener();
        listener.log = ClientServerInvalidAndDestroyedEntryDUnitTest.getLogWriter();
        myRegion.getAttributesMutator().addCacheListener((CacheListener)listener);
        myRegion.get((Object)"Object10");
        ClientServerInvalidAndDestroyedEntryDUnitTest.assertEquals((String)"expected no cache listener invocations", (float)0.0f, (float)listener.updateCount, (float)listener.updateCount);
        myRegion.localDestroy((Object)"Object1");
        myRegion.getAll(keys);
        ClientServerInvalidAndDestroyedEntryDUnitTest.assertTrue((String)"expected to find Object1", (boolean)myRegion.containsKey((Object)"Object1"));
        ClientServerInvalidAndDestroyedEntryDUnitTest.assertEquals((String)"expected only one listener invocation for Object1", (int)1, (int)listener.updateCount);
    }

    private void doTestClientGetsTombstone(final String regionName, boolean usePR, boolean useTX) throws Exception {
        RegionEntry entry;
        VM vm1 = Host.getHost(0).getVM(1);
        VM vm2 = Host.getHost(0).getVM(2);
        String notAffectedKey = "Object1";
        String nonexistantKey = usePR && useTX ? "IDoNotExist2" : "IDoNotExist1";
        String key1 = "Object10";
        final String key2 = usePR && useTX ? "Object12" : "Object11";
        Callable createServer = this.getCreateServerCallable(regionName, usePR);
        int serverPort = (Integer)vm1.invoke(createServer);
        vm2.invoke(createServer);
        vm1.invoke(new SerializableRunnable("populate server and create invalid entry"){

            @Override
            public void run() {
                Region myRegion = ClientServerInvalidAndDestroyedEntryDUnitTest.this.getCache().getRegion(regionName);
                for (int i = 1; i <= 20; ++i) {
                    myRegion.put((Object)("Object" + i), (Object)("Value" + i));
                }
                myRegion.destroy((Object)"Object10");
                myRegion.destroy((Object)key2);
            }
        });
        ClientServerInvalidAndDestroyedEntryDUnitTest.getLogWriter().info("creating client cache");
        ClientCache c = new ClientCacheFactory().addPoolServer("localhost", serverPort).create();
        Region myRegion = c.createClientRegionFactory(ClientRegionShortcut.CACHING_PROXY).create(regionName);
        if (useTX) {
            c.getCacheTransactionManager().begin();
        }
        ClientServerInvalidAndDestroyedEntryDUnitTest.assertNotNull((Object)myRegion.get((Object)"Object1"));
        ClientServerInvalidAndDestroyedEntryDUnitTest.getLogWriter().info("getting Object10 - should reach this cache and be a TOMBSTONE");
        ClientServerInvalidAndDestroyedEntryDUnitTest.assertNull((Object)myRegion.get((Object)"Object10"));
        ClientServerInvalidAndDestroyedEntryDUnitTest.assertFalse((boolean)myRegion.containsKey((Object)"Object10"));
        if (!useTX) {
            entry = ((LocalRegion)myRegion).getRegionEntry((Object)"Object10");
            ClientServerInvalidAndDestroyedEntryDUnitTest.assertNotNull((Object)entry);
            ClientServerInvalidAndDestroyedEntryDUnitTest.assertTrue((boolean)entry.isTombstone());
        }
        ClientServerInvalidAndDestroyedEntryDUnitTest.assertNull((Object)myRegion.get((Object)key2));
        ClientServerInvalidAndDestroyedEntryDUnitTest.assertFalse((boolean)myRegion.containsKey((Object)key2));
        if (!useTX) {
            entry = ((LocalRegion)myRegion).getRegionEntry((Object)key2);
            ClientServerInvalidAndDestroyedEntryDUnitTest.assertNotNull((Object)entry);
            ClientServerInvalidAndDestroyedEntryDUnitTest.assertTrue((boolean)entry.isTombstone());
        }
        ClientServerInvalidAndDestroyedEntryDUnitTest.assertNull((Object)myRegion.get((Object)nonexistantKey));
        ClientServerInvalidAndDestroyedEntryDUnitTest.assertFalse((boolean)myRegion.containsKey((Object)nonexistantKey));
        if (useTX) {
            c.getCacheTransactionManager().commit();
            ClientServerInvalidAndDestroyedEntryDUnitTest.assertNotNull((Object)myRegion.get((Object)"Object1"));
            ClientServerInvalidAndDestroyedEntryDUnitTest.assertNull((Object)myRegion.get((Object)"Object10"));
            ClientServerInvalidAndDestroyedEntryDUnitTest.assertFalse((boolean)myRegion.containsKey((Object)"Object10"));
            entry = ((LocalRegion)myRegion).getRegionEntry((Object)"Object10");
            ClientServerInvalidAndDestroyedEntryDUnitTest.assertNotNull((Object)entry);
            ClientServerInvalidAndDestroyedEntryDUnitTest.assertTrue((boolean)entry.isTombstone());
            ClientServerInvalidAndDestroyedEntryDUnitTest.assertNull((Object)myRegion.get((Object)key2));
            ClientServerInvalidAndDestroyedEntryDUnitTest.assertFalse((boolean)myRegion.containsKey((Object)key2));
            entry = ((LocalRegion)myRegion).getRegionEntry((Object)key2);
            ClientServerInvalidAndDestroyedEntryDUnitTest.assertNotNull((Object)entry);
            ClientServerInvalidAndDestroyedEntryDUnitTest.assertTrue((boolean)entry.isTombstone());
        }
        myRegion.localDestroy((Object)"Object1");
        if (useTX) {
            c.getCacheTransactionManager().begin();
        }
        LinkedList<String> keys = new LinkedList<String>();
        keys.add("Object1");
        keys.add("Object10");
        keys.add(key2);
        Map result = myRegion.getAll(keys);
        ClientServerInvalidAndDestroyedEntryDUnitTest.getLogWriter().info("result of getAll = " + result);
        ClientServerInvalidAndDestroyedEntryDUnitTest.assertNotNull(result.get("Object1"));
        ClientServerInvalidAndDestroyedEntryDUnitTest.assertNull(result.get("Object10"));
        ClientServerInvalidAndDestroyedEntryDUnitTest.assertNull(result.get(key2));
        ClientServerInvalidAndDestroyedEntryDUnitTest.assertFalse((boolean)myRegion.containsKey((Object)"Object10"));
        ClientServerInvalidAndDestroyedEntryDUnitTest.assertFalse((boolean)myRegion.containsKey((Object)key2));
        if (!useTX) {
            entry = ((LocalRegion)myRegion).getRegionEntry((Object)"Object10");
            ClientServerInvalidAndDestroyedEntryDUnitTest.assertNotNull((Object)entry);
            ClientServerInvalidAndDestroyedEntryDUnitTest.assertTrue((boolean)entry.isTombstone());
            entry = ((LocalRegion)myRegion).getRegionEntry((Object)key2);
            ClientServerInvalidAndDestroyedEntryDUnitTest.assertNotNull((Object)entry);
            ClientServerInvalidAndDestroyedEntryDUnitTest.assertTrue((boolean)entry.isTombstone());
        } else {
            c.getCacheTransactionManager().commit();
            ClientServerInvalidAndDestroyedEntryDUnitTest.assertNotNull((Object)myRegion.get((Object)"Object1"));
            ClientServerInvalidAndDestroyedEntryDUnitTest.assertNull((Object)myRegion.get((Object)"Object10"));
            ClientServerInvalidAndDestroyedEntryDUnitTest.assertFalse((boolean)myRegion.containsKey((Object)"Object10"));
            entry = ((LocalRegion)myRegion).getRegionEntry((Object)"Object10");
            ClientServerInvalidAndDestroyedEntryDUnitTest.assertNotNull((Object)entry);
            ClientServerInvalidAndDestroyedEntryDUnitTest.assertTrue((boolean)entry.isTombstone());
            ClientServerInvalidAndDestroyedEntryDUnitTest.assertNull((Object)myRegion.get((Object)key2));
            ClientServerInvalidAndDestroyedEntryDUnitTest.assertFalse((boolean)myRegion.containsKey((Object)key2));
            entry = ((LocalRegion)myRegion).getRegionEntry((Object)key2);
            ClientServerInvalidAndDestroyedEntryDUnitTest.assertNotNull((Object)entry);
            ClientServerInvalidAndDestroyedEntryDUnitTest.assertTrue((boolean)entry.isTombstone());
        }
    }

    private void doTestRegisterInterestRemovesOldEntry(final String regionName, final boolean usePR) throws Exception {
        VM vm1 = Host.getHost(0).getVM(1);
        VM vm2 = Host.getHost(0).getVM(2);
        String key10 = "Object10";
        String interestPattern = "Object.*";
        Callable createServer = this.getCreateServerCallable(regionName, usePR);
        int serverPort = (Integer)vm1.invoke(createServer);
        vm2.invoke(createServer);
        vm1.invoke(new SerializableRunnable("populate server"){

            @Override
            public void run() {
                Region myRegion = ClientServerInvalidAndDestroyedEntryDUnitTest.this.getCache().getRegion(regionName);
                for (int i = 1; i <= 20; ++i) {
                    myRegion.put((Object)("Object" + i), (Object)("Value" + i));
                }
            }
        });
        ClientServerInvalidAndDestroyedEntryDUnitTest.getLogWriter().info("creating client cache");
        ClientCache c = new ClientCacheFactory().addPoolServer("localhost", serverPort).set("log-level", ClientServerInvalidAndDestroyedEntryDUnitTest.getDUnitLogLevel()).setPoolSubscriptionEnabled(true).create();
        Region myRegion = c.createClientRegionFactory(ClientRegionShortcut.CACHING_PROXY).create(regionName);
        myRegion.registerInterestRegex("Object.*");
        ClientServerInvalidAndDestroyedEntryDUnitTest.assertNotNull((Object)myRegion.get((Object)"Object10"));
        SerializableRunnable destroyKey10 = new SerializableRunnable("locally destroy Object10 in the servers"){

            @Override
            public void run() {
                Region myRegion = ClientServerInvalidAndDestroyedEntryDUnitTest.this.getCache().getRegion(regionName);
                EntryEventImpl event = ((LocalRegion)myRegion).generateEvictDestroyEvent((Object)"Object10");
                event.setOperation(Operation.LOCAL_DESTROY);
                if (usePR) {
                    BucketRegion bucket = ((PartitionedRegion)myRegion).getBucketRegion((Object)"Object10");
                    if (bucket != null) {
                        event.setRegion((LocalRegion)bucket);
                        DistributedTestCase.getLogWriter().info("performing local destroy in " + bucket + " ccEnabled=" + bucket.concurrencyChecksEnabled + " rvv=" + bucket.getVersionVector());
                        bucket.concurrencyChecksEnabled = false;
                        bucket.mapDestroy(event, false, false, null);
                        bucket.concurrencyChecksEnabled = true;
                    }
                } else {
                    ((LocalRegion)myRegion).concurrencyChecksEnabled = false;
                    ((LocalRegion)myRegion).mapDestroy(event, false, false, null);
                    ((LocalRegion)myRegion).concurrencyChecksEnabled = true;
                }
            }
        };
        vm1.invoke(destroyKey10);
        vm2.invoke(destroyKey10);
        myRegion.getCache().getLogger().info("clearing keys of interest");
        ((LocalRegion)myRegion).clearKeysOfInterest((Object)"Object.*", 1, InterestResultPolicy.KEYS_VALUES);
        myRegion.getCache().getLogger().info("done clearing keys of interest");
        ClientServerInvalidAndDestroyedEntryDUnitTest.assertTrue((String)("expected region to be empty but it has " + myRegion.size() + " entries"), (myRegion.size() == 0 ? 1 : 0) != 0);
        RegionEntry entry = ((LocalRegion)myRegion).getRegionEntry((Object)"Object10");
        ClientServerInvalidAndDestroyedEntryDUnitTest.assertNull((Object)entry);
        myRegion.registerInterestRegex("Object.*");
        entry = ((LocalRegion)myRegion).getRegionEntry((Object)"Object10");
        ClientServerInvalidAndDestroyedEntryDUnitTest.assertNull((Object)entry);
    }

    static class UpdateListener
    extends CacheListenerAdapter {
        int updateCount;
        LogWriter log;

        UpdateListener() {
        }

        public void afterUpdate(EntryEvent event) {
            ++this.updateCount;
        }

        public void afterCreate(EntryEvent event) {
            ++this.updateCount;
        }
    }
}

