/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionEvent;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.internal.cache.CacheObserver;
import com.gemstone.gemfire.internal.cache.CacheObserverAdapter;
import com.gemstone.gemfire.internal.cache.CacheObserverHolder;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import hydra.Log;
import java.util.Properties;

public class ClearGlobalDUnitTest
extends DistributedTestCase {
    static VM server1 = null;
    static Cache cache;
    static Properties props;
    static DistributedSystem ds;
    static Region region;
    static boolean testFailed;
    static StringBuffer exceptionMsg;
    static boolean testComplete;
    static Object lock;
    private static CacheObserver origObserver;
    private static final String REGION_NAME = "ClearGlobalDUnitTest_Region";

    public ClearGlobalDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        Host host = Host.getHost(0);
        server1 = host.getVM(0);
        server1.invoke(ClearGlobalDUnitTest.class, "createCacheServer1");
        ClearGlobalDUnitTest.createCacheServer2();
        ClearGlobalDUnitTest.getLogWriter().fine("Cache created in successfully");
    }

    @Override
    public void tearDown2() {
        server1.invoke(ClearGlobalDUnitTest.class, "closeCache");
        ClearGlobalDUnitTest.resetClearCallBack();
        ClearGlobalDUnitTest.closeCache();
    }

    public static void resetClearCallBack() {
        LocalRegion.ISSUE_CALLBACKS_TO_CACHE_OBSERVER = false;
        CacheObserverHolder.setInstance((CacheObserver)origObserver);
    }

    public static void closeCache() {
        if (cache != null && !cache.isClosed()) {
            cache.close();
            cache.getDistributedSystem().disconnect();
        }
    }

    public void testClearGlobalMultiVM() throws Exception {
        Object[] objArr = new Object[1];
        for (int i = 1; i < 4; ++i) {
            objArr[0] = "" + i;
            server1.invoke(ClearGlobalDUnitTest.class, "putMethod", objArr);
        }
        server1.invoke(ClearGlobalDUnitTest.class, "clearMethod");
        ClearGlobalDUnitTest.checkTestResults();
    }

    public static void createCacheServer1() throws Exception {
        ds = new ClearGlobalDUnitTest("temp").getSystem(props);
        cache = CacheFactory.create((DistributedSystem)ds);
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.GLOBAL);
        RegionAttributes attr = factory.create();
        region = cache.createRegion(REGION_NAME, attr);
    }

    public static void createCacheServer2() throws Exception {
        ds = new ClearGlobalDUnitTest("temp").getSystem(props);
        CacheObserverImpl observer = new CacheObserverImpl();
        origObserver = CacheObserverHolder.setInstance((CacheObserver)observer);
        LocalRegion.ISSUE_CALLBACKS_TO_CACHE_OBSERVER = true;
        cache = CacheFactory.create((DistributedSystem)ds);
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.GLOBAL);
        RegionAttributes attr = factory.create();
        region = cache.createRegion(REGION_NAME, attr);
        cache.setLockTimeout(3);
    }

    public static void putMethod(Object ob) throws Exception {
        if (ob != null) {
            String str = "first";
            region.put(ob, (Object)str);
        }
    }

    public static void clearMethod() throws Exception {
        region.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkTestResults() throws Exception {
        Object object = lock;
        synchronized (object) {
            while (!testComplete) {
                try {
                    lock.wait(5000L);
                }
                catch (InterruptedException ex) {
                    ClearGlobalDUnitTest.fail((String)"interrupted");
                }
            }
        }
        if (testFailed) {
            throw new Exception("Test Failed: " + exceptionMsg);
        }
        Log.getLogWriter().info("Test Passed Successfully ");
    }

    static {
        props = new Properties();
        ds = null;
        testFailed = true;
        exceptionMsg = new StringBuffer();
        testComplete = false;
        lock = new Object();
    }

    static class PutThread
    extends Thread {
        PutThread() {
        }

        @Override
        public void run() {
            try {
                region.put((Object)"ClearGlobal", (Object)"PutThread");
                exceptionMsg.append(" Put operation should wait for clear operation to complete ");
            }
            catch (TimeoutException ex) {
                testFailed = false;
                Log.getLogWriter().info("Expected TimeoutException in thread ");
            }
            catch (Exception ex) {
                exceptionMsg.append(" Exception occurred while region.put(key,value)");
            }
        }
    }

    public static class CacheObserverImpl
    extends CacheObserverAdapter {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterRegionClear(RegionEvent event) {
            PutThread th = new PutThread();
            th.start();
            DistributedTestCase.join(th, 300000L, DistributedTestCase.getLogWriter());
            Object object = lock;
            synchronized (object) {
                testComplete = true;
                lock.notify();
            }
        }
    }
}

