/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionFactory;
import com.gemstone.gemfire.cache.RegionShortcut;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.internal.cache.AbstractUpdateOperation;
import com.gemstone.gemfire.internal.util.DelayedAction;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.VM;
import java.util.HashMap;
import junit.framework.TestCase;

public class Bug45934DUnitTest
extends CacheTestCase {
    public Bug45934DUnitTest(String name) {
        super(name);
    }

    public void testNormal() throws Exception {
        int count = 1000;
        Host host = Host.getHost(0);
        final VM remote = host.getVM(1);
        String name = this.getName();
        this.createRemoteRegion(remote, name);
        CacheFactory cf = new CacheFactory();
        cf.set("mcast-port", "45934");
        cf.set("conserve-sockets", "false");
        Cache cache = this.getCache(cf);
        RegionFactory rf = cache.createRegionFactory();
        rf.setDataPolicy(DataPolicy.NORMAL);
        rf.setScope(Scope.DISTRIBUTED_ACK);
        Region region = rf.create(name);
        AbstractUpdateOperation.test_InvalidVersionAction = new DelayedAction(new Runnable(){

            @Override
            public void run() {
                Bug45934DUnitTest.this.unsetRemoteFlag(remote);
            }
        });
        AbstractUpdateOperation.test_InvalidVersionAction.allowToProceed();
        HashMap<Integer, Integer> values = new HashMap<Integer, Integer>();
        for (int i = 0; i < count; ++i) {
            values.put(i, i);
        }
        region.putAll(values);
        this.verifyLocal((Region<Integer, Integer>)region, count);
        this.verify(remote, name, count);
        cache.close();
    }

    private void createRemoteRegion(VM remote, final String name) {
        SerializableCallable create = new SerializableCallable(){

            public Object call() throws Exception {
                CacheFactory cf = new CacheFactory();
                cf.set("mcast-port", "45934");
                cf.set("conserve-sockets", "false");
                Bug45934DUnitTest.this.getCache(cf).createRegionFactory(RegionShortcut.REPLICATE_PERSISTENT).create(name);
                AbstractUpdateOperation.test_InvalidVersion = true;
                return null;
            }
        };
        remote.invoke(create);
    }

    private void unsetRemoteFlag(VM remote) {
        SerializableCallable create = new SerializableCallable(){

            public Object call() throws Exception {
                AbstractUpdateOperation.test_InvalidVersion = false;
                return null;
            }
        };
        remote.invoke(create);
    }

    private void verifyLocal(Region<Integer, Integer> r, int count) {
        Bug45934DUnitTest.assertEquals((int)count, (int)r.size());
        for (int i = 0; i < count; ++i) {
            Bug45934DUnitTest.assertEquals((int)i, (int)((Integer)r.get((Object)i)));
        }
    }

    private void verify(VM vm, final String name, final int count) {
        SerializableCallable verify = new SerializableCallable(){

            public Object call() throws Exception {
                Region r = Bug45934DUnitTest.this.getCache().getRegion(name);
                TestCase.assertEquals((int)count, (int)r.size());
                for (int i = 0; i < count; ++i) {
                    TestCase.assertEquals((int)i, (int)((Integer)r.get((Object)i)));
                }
                return null;
            }
        };
        vm.invoke(verify);
    }
}

