/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionShortcut;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.Locator;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.AvailablePort;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.VM;
import hydra.FileUtil;
import hydra.GemFireDescription;
import hydra.HostDescription;
import hydra.HydraConfigException;
import hydra.HydraRuntimeException;
import hydra.ProcessMgr;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Map;
import java.util.Properties;
import junit.framework.TestCase;
import util.TestException;

public class BackwardCompatibilityDUnitTest
extends DistributedTestCase {
    private final String rollingUpgradeBaseVersion = "7.0.99";
    private final String rollingUpgradeBaseVersionDir = "/export/gcm/where/gemfire/releases/GemFire7.0.99-all";
    static final String GCM_WHERE;
    private String vm1WorkingDir;
    private String vm2WorkingDir;
    private String vm3WorkingDir;
    private String vm4WorkingDir;
    SerializableCallable getVMWorkingDir = new SerializableCallable("get working directory of this JVM"){

        public Object call() {
            return BackwardCompatibilityDUnitTest.this.getSysDir();
        }
    };

    public BackwardCompatibilityDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.vm1WorkingDir = (String)Host.getHost(0).getVM(0).invoke(this.getVMWorkingDir);
        this.vm2WorkingDir = (String)Host.getHost(0).getVM(1).invoke(this.getVMWorkingDir);
        this.vm3WorkingDir = (String)Host.getHost(0).getVM(2).invoke(this.getVMWorkingDir);
        this.vm4WorkingDir = (String)Host.getHost(0).getVM(3).invoke(this.getVMWorkingDir);
        BackwardCompatibilityDUnitTest.getLogWriter().info("VMDIR:" + this.vm1WorkingDir);
        BackwardCompatibilityDUnitTest.getLogWriter().info("VMDIR:" + this.vm2WorkingDir);
        BackwardCompatibilityDUnitTest.getLogWriter().info("VMDIR:" + this.vm3WorkingDir);
        BackwardCompatibilityDUnitTest.getLogWriter().info("VMDIR:" + this.vm4WorkingDir);
        this.cleanUp(new String[]{this.vm1WorkingDir, this.vm2WorkingDir, this.vm3WorkingDir, this.vm4WorkingDir});
    }

    public String getSysDir() {
        String sysDirName = null;
        String gemfireName = System.getProperty("gemfireName");
        if (gemfireName == null) {
            String s = "No gemfire name has been specified";
            throw new HydraConfigException(s);
        }
        GemFireDescription gfd = TestConfig.getInstance().getGemFireDescription(gemfireName);
        sysDirName = gfd.getSystemDirectory() + "_" + ProcessMgr.getProcessId();
        if (!FileUtil.exists(sysDirName)) {
            FileUtil.mkdir(new File(sysDirName));
            HostDescription hd = gfd.getHostDescription();
            try {
                RemoteTestModule.Master.recordDir(hd, gfd.getName(), sysDirName);
            }
            catch (RemoteException e) {
                String s = "Unable to access master to record directory: " + sysDirName;
                throw new HydraRuntimeException(s, e);
            }
        }
        return sysDirName;
    }

    private void cleanUp(String[] dirs) {
        for (String dirName : dirs) {
            File dir = new File(dirName + "/datadictionary");
            BackwardCompatibilityDUnitTest.deleteDir(dir);
        }
    }

    public static boolean deleteDir(File dir) {
        if (!dir.exists()) {
            return false;
        }
        BackwardCompatibilityDUnitTest.deleteDirContents(dir);
        return BackwardCompatibilityDUnitTest.deleteDirOnly(dir);
    }

    protected static void deleteDirContents(File dir) {
        if (!dir.exists()) {
            return;
        }
        File[] files = dir.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    BackwardCompatibilityDUnitTest.deleteDirContents(f);
                }
                BackwardCompatibilityDUnitTest.deleteDirOnly(f);
            }
        }
    }

    protected static boolean deleteDirOnly(File dir) {
        int numTries = 10;
        while (numTries-- > 0 && dir.exists()) {
            if (!dir.delete()) continue;
            return true;
        }
        return numTries > 0;
    }

    public void testMixedVersion() throws Exception {
    }

    private void createCacheAndRegion(VM vm, Properties props) {
        final Properties p = props;
        vm.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                DistributedSystem ds = DistributedSystem.connect((Properties)p);
                Cache cache = null;
                try {
                    cache = CacheFactory.getAnyInstance();
                }
                catch (CacheClosedException e) {
                    cache = CacheFactory.create((DistributedSystem)ds);
                }
                Region r = cache.createRegionFactory(RegionShortcut.REPLICATE).create("REG1");
                return null;
            }
        });
    }

    private void addData(VM vm) {
        vm.invoke(new SerializableCallable("Adding data"){

            public Object call() throws Exception {
                Cache cache = CacheFactory.getAnyInstance();
                Region r = cache.getRegion("/REG1");
                for (int i = 0; i < 10; ++i) {
                    r.put((Object)("name" + i), (Object)("value" + i));
                }
                Region reg1 = cache.getRegion("/REG1");
                TestCase.assertEquals((int)10, (int)r.size());
                return null;
            }
        });
    }

    private void verifyData(VM vm) {
        BackwardCompatibilityDUnitTest.getLogWriter().info("Verifying data for" + vm);
        vm.invoke(new SerializableCallable("Verifying data"){

            public Object call() throws Exception {
                Cache cache = CacheFactory.getAnyInstance();
                Region r = cache.getRegion("/REG1");
                TestCase.assertEquals((int)10, (int)r.size());
                for (int i = 0; i < 10; ++i) {
                    TestCase.assertTrue((boolean)r.containsKey((Object)("name" + i)));
                    TestCase.assertEquals((Object)("value" + i), (Object)r.get((Object)("name" + i)));
                }
                return null;
            }
        });
    }

    public String getTestLogNamePrefix() {
        return this.getTestClass().getName() + "-" + BackwardCompatibilityDUnitTest.getTestName();
    }

    private int startVersionedLocator(String version, String versionDir, String workingDir, boolean withAuth) throws Exception {
        String gfeDir = versionDir.charAt(0) != '/' ? GCM_WHERE + '/' + versionDir : versionDir;
        String utilLauncher = this.getGemfireLauncher(gfeDir);
        int peerDiscoveryPort = AvailablePort.getRandomAvailablePort((int)0);
        BackwardCompatibilityDUnitTest.getLogWriter().info("Starting locator version " + version + " from " + gfeDir + " on port " + peerDiscoveryPort);
        String logFile = this.getTestLogNamePrefix() + "-locator" + version + ".log";
        String[] startOps = null;
        startOps = withAuth ? new String[]{utilLauncher, "start-locator", "-dir=" + workingDir, "-port=" + peerDiscoveryPort} : new String[]{utilLauncher, "start-locator", "dir=" + workingDir, "port=" + peerDiscoveryPort};
        Process serverProc = new ProcessBuilder(startOps).start();
        int exitValue = serverProc.waitFor();
        if (exitValue != 0) {
            throw new TestException("Unexpected exit value " + exitValue + " while starting locator version " + version + ". See logs in " + logFile + " and start file output.");
        }
        return peerDiscoveryPort;
    }

    public void stopVersionedLocator(String version, String versionDir, String workingDir) throws Exception {
        String gfxdDir = versionDir.charAt(0) != '/' ? GCM_WHERE + '/' + versionDir : versionDir;
        String utilLauncher = this.getGemfireLauncher(gfxdDir);
        BackwardCompatibilityDUnitTest.getLogWriter().info("Stopping locator version " + version + " from " + gfxdDir);
        String[] startOps = new String[]{utilLauncher, "stop-locator", "-dir=" + workingDir};
        Process serverProc = new ProcessBuilder(startOps).start();
        int exitValue = serverProc.waitFor();
        if (exitValue != 0) {
            throw new TestException("Unexpected exit value " + exitValue + " while stopping locator version " + version + '.');
        }
    }

    public int startVersionedServer(String version, String versionDir, String workingDir, int mcastPort, int locatorPort, boolean withAuth) throws Exception {
        String gfxdDir = versionDir.charAt(0) != '/' ? GCM_WHERE + '/' + versionDir : versionDir;
        String utilLauncher = this.getCacheServerLauncher(gfxdDir);
        int clientPort = AvailablePort.getRandomAvailablePort((int)0);
        String logFile = this.getTestLogNamePrefix() + "-server" + version + ".log";
        String[] startOps = locatorPort > 0 ? (withAuth ? new String[]{utilLauncher, "start", "-dir=" + workingDir, "-server-port=" + clientPort, "locators=localhost[" + locatorPort + "]"} : new String[]{utilLauncher, "start", "-dir=" + workingDir, "-server-port=" + clientPort, "locators=localhost[" + locatorPort + "]"}) : new String[]{utilLauncher, "start", "-dir=" + workingDir, "-server-port=" + clientPort, "-mcast-port" + mcastPort};
        BackwardCompatibilityDUnitTest.getLogWriter().info("Starting cache server version " + version + " from " + gfxdDir + " on port " + clientPort);
        Process serverProc = new ProcessBuilder(startOps).start();
        int exitValue = serverProc.waitFor();
        if (exitValue != 0) {
            throw new TestException("Unexpected exit value " + exitValue + " while starting cache server version " + version + ". See logs in " + logFile);
        }
        return clientPort;
    }

    public void stopVersionedServer(String version, String versionDir, String workingDir) throws Exception {
        String gfeDir = versionDir.charAt(0) != '/' ? GCM_WHERE + '/' + versionDir : versionDir;
        String utilLauncher = this.getCacheServerLauncher(gfeDir);
        BackwardCompatibilityDUnitTest.getLogWriter().info("Stopping cache server version " + version + " from " + gfeDir);
        String[] startOps = new String[]{utilLauncher, "stop", "-dir=" + workingDir};
        Process serverProc = new ProcessBuilder(startOps).start();
        int exitValue = serverProc.waitFor();
        if (exitValue != 0) {
            throw new TestException("Unexpected exit value " + exitValue + " while stopping cache server version " + version + '.');
        }
    }

    private int startLocator(VM locatorVM, Properties props) throws IOException {
        final int locatorPort = AvailablePort.getRandomAvailablePort((int)0);
        final Properties pr = props;
        final File locatorLogFile = new File("locator-" + locatorPort + ".log");
        locatorVM.invoke(new SerializableCallable(){

            public Object call() throws IOException {
                try {
                    Properties p = BackwardCompatibilityDUnitTest.this.getDistributedSystemProperties();
                    p.putAll((Map<?, ?>)pr);
                    Locator.startLocatorAndDS((int)locatorPort, (File)locatorLogFile, (Properties)p);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return null;
            }
        });
        return locatorPort;
    }

    private void stopLocator(VM locatorVM, Properties props) throws Exception {
        Properties p = props;
        locatorVM.invoke(new SerializableCallable(){

            public Object call() throws IOException {
                try {
                    Locator locator = Locator.getLocator();
                    if (locator == null) {
                        throw new Exception("No locator found");
                    }
                    locator.stop();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return null;
            }
        });
    }

    private void startCacheServer(VM serverVM, Properties props) {
        final Properties p = props;
        serverVM.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                try {
                    InternalDistributedSystem ds = (InternalDistributedSystem)DistributedSystem.connect((Properties)p);
                    Cache cache = CacheFactory.create((DistributedSystem)ds);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return null;
            }
        });
    }

    private void stopCacheServer(VM serverVM, Properties props) {
        Properties p = props;
        serverVM.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                try {
                    Cache cache = CacheFactory.getAnyInstance();
                    if (cache != null) {
                        cache.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return null;
            }
        });
    }

    private String getGemfireLauncher(String gfeDir) {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.indexOf("win") >= 0) {
            return gfeDir + "/product/bin/gemfire.bat";
        }
        return gfeDir + "/product/bin/gemfire";
    }

    private String getCacheServerLauncher(String gfeDir) {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.indexOf("win") >= 0) {
            return gfeDir + "/product/bin/cacheserver.bat";
        }
        return gfeDir + "/product/bin/cacheserver";
    }

    static {
        String gcmdir = System.getenv("GCMDIR");
        if (gcmdir == null || gcmdir.length() == 0) {
            gcmdir = "/gcm";
        }
        GCM_WHERE = gcmdir + "/where";
    }
}

