/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.admin.BackupStatus;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.DiskStore;
import com.gemstone.gemfire.cache.DiskStoreFactory;
import com.gemstone.gemfire.cache.EvictionAction;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionFactory;
import com.gemstone.gemfire.cache.control.RebalanceOperation;
import com.gemstone.gemfire.cache.control.RebalanceResults;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.DistributionMessage;
import com.gemstone.gemfire.distributed.internal.DistributionMessageObserver;
import com.gemstone.gemfire.distributed.internal.ReplyMessage;
import com.gemstone.gemfire.internal.FileUtil;
import com.gemstone.gemfire.internal.cache.DestroyRegionOperation;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.partitioned.PersistentPartitionedRegionTestBase;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.SerializableRunnable;
import dunit.VM;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import junit.framework.TestCase;

public class BackupDUnitTest
extends PersistentPartitionedRegionTestBase {
    private static final long MAX_WAIT = 30000L;

    public BackupDUnitTest(String name) {
        super(name);
    }

    @Override
    public void tearDown2() throws Exception {
        StringBuilder failures = new StringBuilder();
        FileUtil.delete((File)BackupDUnitTest.getBackupDir(), (StringBuilder)failures);
        if (failures.length() > 0) {
            BackupDUnitTest.getLogWriter().error(failures.toString());
        }
        super.tearDown2();
    }

    public void testBackupPR() throws Throwable {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        BackupDUnitTest.getLogWriter().info("Creating region in VM0");
        this.createPersistentRegion(vm0);
        BackupDUnitTest.getLogWriter().info("Creating region in VM1");
        this.createPersistentRegion(vm1);
        long lm0 = this.setBackupFiles(vm0);
        long lm1 = this.setBackupFiles(vm1);
        this.createData(vm0, 0, 5, "A", "region1");
        this.createData(vm0, 0, 5, "B", "region2");
        BackupStatus status = this.backup(vm2);
        BackupDUnitTest.assertEquals((int)2, (int)status.getBackedUpDiskStores().size());
        BackupDUnitTest.assertEquals(Collections.emptySet(), (Object)status.getOfflineDiskStores());
        List mytexts = FileUtil.findAll((File)BackupDUnitTest.getBackupDir(), (String)".*my.txt.*");
        BackupDUnitTest.assertEquals((int)2, (int)mytexts.size());
        this.deleteOldUserUserFile(vm0);
        this.deleteOldUserUserFile(vm1);
        this.validateBackupComplete();
        this.createData(vm0, 0, 5, "C", "region1");
        this.createData(vm0, 0, 5, "C", "region2");
        BackupDUnitTest.assertEquals((int)2, (int)status.getBackedUpDiskStores().size());
        BackupDUnitTest.assertEquals(Collections.emptySet(), (Object)status.getOfflineDiskStores());
        this.closeCache(vm0);
        this.closeCache(vm1);
        BackupDUnitTest.invokeInEveryVM(new SerializableRunnable("Clean disk dirs"){

            @Override
            public void run() {
                try {
                    CacheTestCase.cleanDiskDirs();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        this.restoreBackup(2);
        BackupDUnitTest.getLogWriter().info("Creating region in VM0");
        AsyncInvocation async0 = this.createPersistentRegionAsync(vm0);
        BackupDUnitTest.getLogWriter().info("Creating region in VM1");
        AsyncInvocation async1 = this.createPersistentRegionAsync(vm1);
        async0.getResult(30000L);
        async1.getResult(30000L);
        this.checkData(vm0, 0, 5, "A", "region1");
        this.checkData(vm0, 0, 5, "B", "region2");
        this.verifyUserFileRestored(vm0.getPid(), lm0);
        this.verifyUserFileRestored(vm1.getPid(), lm1);
    }

    public void testBackupFromMemberWithDiskStore() throws Throwable {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        BackupDUnitTest.getLogWriter().info("Creating region in VM0");
        this.createPersistentRegion(vm0);
        BackupDUnitTest.getLogWriter().info("Creating region in VM1");
        this.createPersistentRegion(vm1);
        this.createData(vm0, 0, 5, "A", "region1");
        this.createData(vm0, 0, 5, "B", "region2");
        BackupStatus status = this.backup(vm1);
        BackupDUnitTest.assertEquals((int)2, (int)status.getBackedUpDiskStores().size());
        for (DistributedMember key : status.getBackedUpDiskStores().keySet()) {
            BackupDUnitTest.assertNotNull((Object)key);
        }
        BackupDUnitTest.assertEquals(Collections.emptySet(), (Object)status.getOfflineDiskStores());
        this.validateBackupComplete();
        this.closeCache(vm0);
        this.closeCache(vm1);
        BackupDUnitTest.invokeInEveryVM(new SerializableRunnable("Clean disk dirs"){

            @Override
            public void run() {
                try {
                    CacheTestCase.cleanDiskDirs();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        this.restoreBackup(2);
        BackupDUnitTest.getLogWriter().info("Creating region in VM0");
        AsyncInvocation async0 = this.createPersistentRegionAsync(vm0);
        BackupDUnitTest.getLogWriter().info("Creating region in VM1");
        AsyncInvocation async1 = this.createPersistentRegionAsync(vm1);
        async0.getResult(30000L);
        async1.getResult(30000L);
        this.checkData(vm0, 0, 5, "A", "region1");
        this.checkData(vm0, 0, 5, "B", "region2");
    }

    public void testBackupWhileBucketIsCreated() throws Throwable {
        Host host = Host.getHost(0);
        final VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        final VM vm2 = host.getVM(2);
        BackupDUnitTest.getLogWriter().info("Creating region in VM0");
        this.createPersistentRegion(vm0);
        this.createData(vm0, 0, 1, "A", "region1");
        BackupDUnitTest.getLogWriter().info("Creating region in VM1");
        this.createPersistentRegion(vm1);
        final AtomicReference statusRef = new AtomicReference();
        Thread thread1 = new Thread(){

            @Override
            public void run() {
                BackupStatus status = BackupDUnitTest.this.backup(vm2);
                statusRef.set(status);
            }
        };
        thread1.start();
        Thread thread2 = new Thread(){

            @Override
            public void run() {
                BackupDUnitTest.this.createData(vm0, 1, 5, "A", "region1");
            }
        };
        thread2.start();
        thread1.join();
        thread2.join();
        BackupStatus status = (BackupStatus)statusRef.get();
        BackupDUnitTest.assertEquals((int)2, (int)status.getBackedUpDiskStores().size());
        BackupDUnitTest.assertEquals(Collections.emptySet(), (Object)status.getOfflineDiskStores());
        this.validateBackupComplete();
        this.createData(vm0, 0, 5, "C", "region1");
        BackupDUnitTest.assertEquals((int)2, (int)status.getBackedUpDiskStores().size());
        BackupDUnitTest.assertEquals(Collections.emptySet(), (Object)status.getOfflineDiskStores());
        this.closeCache(vm0);
        this.closeCache(vm1);
        BackupDUnitTest.invokeInEveryVM(new SerializableRunnable("Clean disk dirs"){

            @Override
            public void run() {
                try {
                    CacheTestCase.cleanDiskDirs();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        this.restoreBackup(2);
        BackupDUnitTest.getLogWriter().info("Creating region in VM0");
        AsyncInvocation async0 = this.createPersistentRegionAsync(vm0);
        BackupDUnitTest.getLogWriter().info("Creating region in VM1");
        AsyncInvocation async1 = this.createPersistentRegionAsync(vm1);
        async0.getResult(30000L);
        async1.getResult(30000L);
        this.checkData(vm0, 0, 1, "A", "region1");
    }

    public void testBackupWhileBucketIsMovedBackupBeforeSendDestroy() throws Throwable {
        Host host = Host.getHost(0);
        final VM vm2 = host.getVM(2);
        SerializableDistributionMessageObserver observer = new SerializableDistributionMessageObserver(){
            private volatile boolean done;
            private AtomicInteger count = new AtomicInteger();
            private volatile int replyId = -2989;

            public void beforeSendMessage(DistributionManager dm, DistributionMessage msg) {
                if (msg instanceof DestroyRegionOperation.DestroyRegionMessage && !this.done) {
                    BackupDUnitTest.this.backup(vm2);
                    this.done = true;
                }
            }
        };
        this.backupWhileBucketIsMoved(observer);
    }

    public void testBackupWhileBucketIsMovedBackupAfterSendDestroy() throws Throwable {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        final VM vm2 = host.getVM(2);
        SerializableDistributionMessageObserver observer = new SerializableDistributionMessageObserver(){
            private volatile boolean done;
            private AtomicInteger count = new AtomicInteger();
            private volatile int replyId = -2989;

            public void beforeSendMessage(DistributionManager dm, DistributionMessage msg) {
                if (msg instanceof DestroyRegionOperation.DestroyRegionMessage && !this.done) {
                    this.replyId = msg.getProcessorId();
                }
            }

            public void beforeProcessMessage(DistributionManager dm, DistributionMessage message) {
                if (message instanceof ReplyMessage && this.replyId != -2989 && this.replyId == message.getProcessorId() && !this.done && this.count.incrementAndGet() == 2) {
                    BackupDUnitTest.this.backup(vm2);
                    this.done = true;
                }
            }
        };
        this.backupWhileBucketIsMoved(observer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void backupWhileBucketIsMoved(final DistributionMessageObserver observer) throws Throwable {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        vm0.invoke(new SerializableRunnable("Add listener to invoke backup"){

            @Override
            public void run() {
                CacheTestCase.disconnectFromDS();
                DistributionMessageObserver.setInstance((DistributionMessageObserver)observer);
            }
        });
        try {
            BackupDUnitTest.getLogWriter().info("Creating region in VM0");
            this.createPersistentRegion(vm0);
            this.createData(vm0, 0, 2, "A", "region1");
            BackupDUnitTest.getLogWriter().info("Creating region in VM1");
            this.createPersistentRegion(vm1);
            vm0.invoke(new SerializableRunnable("Do rebalance"){

                @Override
                public void run() {
                    Cache cache = BackupDUnitTest.this.getCache();
                    RebalanceOperation op = cache.getResourceManager().createRebalanceFactory().start();
                    try {
                        RebalanceResults results = op.getResults();
                        TestCase.assertEquals((int)1, (int)results.getTotalBucketTransfersCompleted());
                    }
                    catch (Exception e) {
                        DistributedTestCase.fail("interupted", e);
                    }
                }
            });
            this.validateBackupComplete();
            this.createData(vm0, 0, 5, "C", "region1");
            this.closeCache(vm0);
            this.closeCache(vm1);
            BackupDUnitTest.invokeInEveryVM(new SerializableRunnable("Clean disk dirs"){

                @Override
                public void run() {
                    try {
                        CacheTestCase.cleanDiskDirs();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            this.restoreBackup(2);
            BackupDUnitTest.getLogWriter().info("Creating region in VM0");
            AsyncInvocation async0 = this.createPersistentRegionAsync(vm0);
            BackupDUnitTest.getLogWriter().info("Creating region in VM1");
            AsyncInvocation async1 = this.createPersistentRegionAsync(vm1);
            async0.getResult(30000L);
            async1.getResult(30000L);
            this.checkData(vm0, 0, 2, "A", "region1");
            vm0.invoke(new SerializableRunnable(){

                @Override
                public void run() {
                    DistributionMessageObserver.setInstance(null);
                    CacheTestCase.disconnectFromDS();
                }
            });
        }
        catch (Throwable throwable) {
            vm0.invoke(new /* invalid duplicate definition of identical inner class */);
            throw throwable;
        }
    }

    public void testBackupOverflow() throws Throwable {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        BackupDUnitTest.getLogWriter().info("Creating region in VM0");
        this.createPersistentRegion(vm0);
        BackupDUnitTest.getLogWriter().info("Creating region in VM1");
        this.createOverflowRegion(vm1);
        this.createData(vm0, 0, 5, "A", "region1");
        this.createData(vm0, 0, 5, "B", "region2");
        BackupStatus status = this.backup(vm2);
        BackupDUnitTest.assertEquals((String)("Backed up disk stores  " + status), (int)1, (int)status.getBackedUpDiskStores().size());
        BackupDUnitTest.assertEquals((int)2, (int)((Set)status.getBackedUpDiskStores().values().iterator().next()).size());
        BackupDUnitTest.assertEquals(Collections.emptySet(), (Object)status.getOfflineDiskStores());
        this.validateBackupComplete();
    }

    public void testBackupPRWithOfflineMembers() throws Throwable {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        BackupDUnitTest.getLogWriter().info("Creating region in VM0");
        this.createPersistentRegion(vm0);
        BackupDUnitTest.getLogWriter().info("Creating region in VM1");
        this.createPersistentRegion(vm1);
        BackupDUnitTest.getLogWriter().info("Creating region in VM2");
        this.createPersistentRegion(vm2);
        this.createData(vm0, 0, 5, "A", "region1");
        this.createData(vm0, 0, 5, "B", "region2");
        this.closeCache(vm2);
        BackupStatus status = this.backup(vm3);
        BackupDUnitTest.assertEquals((int)2, (int)status.getBackedUpDiskStores().size());
        BackupDUnitTest.assertEquals((int)2, (int)status.getOfflineDiskStores().size());
    }

    private void validateBackupComplete() {
        File backupDir = BackupDUnitTest.getBackupDir();
        File incompleteBackup = FileUtil.find((File)backupDir, (String)".*INCOMPLETE.*");
        BackupDUnitTest.assertNull((Object)incompleteBackup);
    }

    protected void createPersistentRegion(VM vm) throws Throwable {
        AsyncInvocation future = this.createPersistentRegionAsync(vm);
        future.join(30000L);
        if (future.isAlive()) {
            BackupDUnitTest.fail((String)"Region not created within30000");
        }
        if (future.exceptionOccurred()) {
            throw new RuntimeException(future.getException());
        }
    }

    private void deleteOldUserUserFile(final VM vm) {
        SerializableRunnable validateUserFileBackup = new SerializableRunnable("set user backups"){

            @Override
            public void run() {
                int pid = vm.getPid();
                try {
                    FileUtil.delete((File)new File("userbackup_" + pid));
                }
                catch (IOException e) {
                    TestCase.fail((String)e.getMessage());
                }
            }
        };
        vm.invoke(validateUserFileBackup);
    }

    protected long setBackupFiles(VM vm) {
        int pid = vm.getPid();
        File vmdir = new File("userbackup_" + pid);
        File test1 = new File(vmdir, "test1");
        File test2 = new File(test1, "test2");
        File mytext = new File(test2, "my.txt");
        final ArrayList<File> backuplist = new ArrayList<File>();
        test2.mkdirs();
        PrintStream ps = null;
        try {
            ps = new PrintStream(mytext);
        }
        catch (FileNotFoundException e) {
            BackupDUnitTest.fail((String)e.getMessage());
        }
        ps.println(pid);
        ps.close();
        mytext.setExecutable(true, true);
        long lastModified = mytext.lastModified();
        backuplist.add(test2);
        SerializableRunnable setUserBackups = new SerializableRunnable("set user backups"){

            @Override
            public void run() {
                Cache cache = BackupDUnitTest.this.getCache();
                GemFireCacheImpl gfci = (GemFireCacheImpl)cache;
                gfci.setBackupFiles((List)backuplist);
            }
        };
        vm.invoke(setUserBackups);
        return lastModified;
    }

    protected void verifyUserFileRestored(int pid, long lm) {
        File vmdir = new File("userbackup_" + pid);
        File mytext = new File(vmdir, "test1/test2/my.txt");
        BackupDUnitTest.assertTrue((boolean)mytext.exists());
        if (System.getProperty("java.specification.version").equals("1.6")) {
            BackupDUnitTest.assertTrue((boolean)mytext.canExecute());
        } else {
            System.out.println("java.specification.version is " + System.getProperty("java.specification.version") + ", canExecute is " + mytext.canExecute());
        }
        BackupDUnitTest.assertEquals((long)lm, (long)mytext.lastModified());
        try {
            FileReader fr = new FileReader(mytext);
            BufferedReader bin = new BufferedReader(fr);
            String content = bin.readLine();
            BackupDUnitTest.assertTrue((boolean)content.equals("" + pid));
        }
        catch (FileNotFoundException e) {
            BackupDUnitTest.fail((String)e.getMessage());
        }
        catch (IOException e) {
            BackupDUnitTest.fail((String)e.getMessage());
        }
    }

    protected AsyncInvocation createPersistentRegionAsync(VM vm) {
        SerializableRunnable createRegion = new SerializableRunnable("Create persistent region"){

            @Override
            public void run() {
                Cache cache = BackupDUnitTest.this.getCache();
                DiskStoreFactory dsf = cache.createDiskStoreFactory();
                dsf.setDiskDirs(BackupDUnitTest.this.getDiskDirs(BackupDUnitTest.this.getUniqueName()));
                dsf.setMaxOplogSize(1L);
                DiskStore ds = dsf.create(BackupDUnitTest.this.getUniqueName());
                RegionFactory rf = new RegionFactory();
                rf.setDiskStoreName(ds.getName());
                rf.setDiskSynchronous(true);
                rf.setDataPolicy(BackupDUnitTest.this.getDataPolicy());
                PartitionAttributesFactory paf = new PartitionAttributesFactory();
                paf.setRedundantCopies(0);
                rf.setPartitionAttributes(paf.create());
                rf.create("region1");
                dsf = cache.createDiskStoreFactory();
                dsf.setDiskDirs(BackupDUnitTest.this.getDiskDirs(BackupDUnitTest.this.getUniqueName() + 2));
                dsf.setMaxOplogSize(1L);
                ds = dsf.create(BackupDUnitTest.this.getUniqueName() + 2);
                rf.setDiskStoreName(BackupDUnitTest.this.getUniqueName() + 2);
                rf.create("region2");
            }
        };
        return vm.invokeAsync(createRegion);
    }

    protected void createOverflowRegion(VM vm) {
        SerializableRunnable createRegion = new SerializableRunnable("Create persistent region"){

            @Override
            public void run() {
                Cache cache = BackupDUnitTest.this.getCache();
                DiskStoreFactory dsf = cache.createDiskStoreFactory();
                dsf.setDiskDirs(BackupDUnitTest.this.getDiskDirs(BackupDUnitTest.this.getUniqueName()));
                dsf.setMaxOplogSize(1L);
                DiskStore ds = dsf.create(BackupDUnitTest.this.getUniqueName());
                RegionFactory rf = new RegionFactory();
                rf.setDiskStoreName(ds.getName());
                rf.setDiskSynchronous(true);
                rf.setDataPolicy(DataPolicy.REPLICATE);
                rf.setEvictionAttributes(EvictionAttributes.createLIFOEntryAttributes((int)1, (EvictionAction)EvictionAction.OVERFLOW_TO_DISK));
                rf.create("region3");
            }
        };
        vm.invoke(createRegion);
    }

    @Override
    protected void createData(VM vm, int startKey, int endKey, String value) {
        this.createData(vm, startKey, endKey, value, PR_REGION_NAME);
    }

    @Override
    protected void createData(VM vm, final int startKey, final int endKey, final String value, final String regionName) {
        SerializableRunnable createData = new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = BackupDUnitTest.this.getCache();
                Region region = cache.getRegion(regionName);
                for (int i = startKey; i < endKey; ++i) {
                    region.put((Object)i, (Object)value);
                }
            }
        };
        vm.invoke(createData);
    }

    @Override
    protected void checkData(VM vm0, int startKey, int endKey, String value) {
        this.checkData(vm0, startKey, endKey, value, PR_REGION_NAME);
    }

    @Override
    protected void checkData(VM vm0, final int startKey, final int endKey, final String value, final String regionName) {
        SerializableRunnable checkData = new SerializableRunnable(){

            @Override
            public void run() {
                Cache cache = BackupDUnitTest.this.getCache();
                Region region = cache.getRegion(regionName);
                for (int i = startKey; i < endKey; ++i) {
                    TestCase.assertEquals((Object)value, (Object)region.get((Object)i));
                }
            }
        };
        vm0.invoke(checkData);
    }

    @Override
    protected void closeCache(VM vm) {
        SerializableRunnable closeCache = new SerializableRunnable("close cache"){

            @Override
            public void run() {
                Cache cache = BackupDUnitTest.this.getCache();
                cache.close();
            }
        };
        vm.invoke(closeCache);
    }

    @Override
    protected Set<Integer> getBucketList(VM vm0) {
        return this.getBucketList(vm0, PR_REGION_NAME);
    }

    @Override
    protected Set<Integer> getBucketList(VM vm0, final String regionName) {
        SerializableCallable getBuckets = new SerializableCallable("get buckets"){

            public Object call() throws Exception {
                Cache cache = BackupDUnitTest.this.getCache();
                PartitionedRegion region = (PartitionedRegion)cache.getRegion(regionName);
                return new TreeSet(region.getDataStore().getAllLocalBucketIds());
            }
        };
        return (Set)vm0.invoke(getBuckets);
    }

    public File[] getDiskDirs(String dsName) {
        File[] dirs = BackupDUnitTest.getDiskDirs();
        File[] diskStoreDirs = new File[]{new File(dirs[0], dsName)};
        diskStoreDirs[0].mkdirs();
        return diskStoreDirs;
    }

    protected DataPolicy getDataPolicy() {
        return DataPolicy.PERSISTENT_PARTITION;
    }

    private static class SerializableDistributionMessageObserver
    extends DistributionMessageObserver
    implements Serializable {
        private SerializableDistributionMessageObserver() {
        }
    }
}

