/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed.internal;

import com.gemstone.gemfire.distributed.internal.MessagingPerf;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import hydra.BasePrms;
import hydra.TestConfig;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.ServerSocket;
import java.net.Socket;

public class TCPPerf
extends MessagingPerf {
    public TCPPerf(String name) {
        super(name, false);
    }

    private static Socket waitForConnection(int port) throws IOException {
        Socket socket = new ServerSocket(port).accept();
        if (!Prms.useDefaultSocketBufferSize()) {
            int size = Prms.getSocketBufferSize();
            TCPPerf.getLogWriter().info("Setting socket buffer size to " + size);
            socket.setReceiveBufferSize(size);
            socket.setSendBufferSize(size);
        }
        TCPPerf.getLogWriter().info("Setting tcpNoDelay to " + Prms.getTcpNoDelay());
        socket.setTcpNoDelay(Prms.getTcpNoDelay());
        return socket;
    }

    private static Socket attemptConnection(String host, int port) throws IOException {
        for (int i = 0; i < 100; ++i) {
            try {
                Socket socket = new Socket(host, port);
                if (!Prms.useDefaultSocketBufferSize()) {
                    int size = Prms.getSocketBufferSize();
                    TCPPerf.getLogWriter().info("Setting socket buffer size to " + size);
                    socket.setReceiveBufferSize(size);
                    socket.setSendBufferSize(size);
                }
                TCPPerf.getLogWriter().info("Setting tcpNoDelay to " + Prms.getTcpNoDelay());
                socket.setTcpNoDelay(Prms.getTcpNoDelay());
                return socket;
            }
            catch (ConnectException ex) {
                try {
                    Thread.sleep(500L);
                    TCPPerf.getLogWriter().info("Retrying " + host + ":" + port);
                    continue;
                }
                catch (InterruptedException ex2) {
                    String s = "Interrupted while sleeping";
                    throw new InterruptedIOException(s);
                }
            }
        }
        String s = "Timed out!!";
        throw new IllegalStateException(s);
    }

    protected static void work(int sendingPort, int receivingPort, String otherHost, boolean sendFirstMessage) throws IOException, ClassNotFoundException {
        boolean startTimeSet;
        OutputStream out = null;
        InputStream in = null;
        MessagingPerf.Message m = null;
        boolean bl = startTimeSet = !sendFirstMessage;
        if (sendFirstMessage) {
            TCPPerf.getLogWriter().info("Starting server on port " + sendingPort);
            out = TCPPerf.waitForConnection(sendingPort).getOutputStream();
            in = TCPPerf.attemptConnection(otherHost, receivingPort).getInputStream();
            m = new MessagingPerf.Message();
            m.number = 0L;
        } else {
            TCPPerf.getLogWriter().info("Starting client on " + receivingPort);
            in = TCPPerf.attemptConnection(otherHost, receivingPort).getInputStream();
            out = TCPPerf.waitForConnection(sendingPort).getOutputStream();
        }
        long WARMUP_COUNT = MessagingPerf.Prms.getWarmupCount();
        long messageCount = MessagingPerf.Prms.getMessageCount() + WARMUP_COUNT;
        while (true) {
            if (m != null) {
                long nextNumber;
                if (m.number >= messageCount) {
                    TCPPerf.getLogWriter().info("Received last message");
                    long end = System.currentTimeMillis();
                    TCPPerf.getLogWriter().info(TCPPerf.noteTiming(messageCount - WARMUP_COUNT, "messages", m.begin, end, "milliseconds"));
                    break;
                }
                if (!startTimeSet && m.number >= WARMUP_COUNT) {
                    m.begin = System.currentTimeMillis();
                    startTimeSet = true;
                }
                MessagingPerf.Message m2 = new MessagingPerf.Message();
                m2.begin = m.begin;
                m2.number = nextNumber = m.number + 1L;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject((Object)m2);
                oos.flush();
                byte[] m2bytes = baos.toByteArray();
                byte[] m2len = new byte[]{(byte)(m2bytes.length / 0x1000000 & 0xFF), (byte)(m2bytes.length / 65536 & 0xFF), (byte)(m2bytes.length / 256 & 0xFF), (byte)(m2bytes.length & 0xFF)};
                out.write(m2len, 0, 4);
                out.write(m2bytes, 0, m2bytes.length);
                out.flush();
                if (nextNumber >= messageCount) {
                    String s = "Sent last message (" + messageCount + ")";
                    TCPPerf.getLogWriter().info(s);
                    break;
                }
            }
            byte[] mlen = new byte[4];
            in.read(mlen, 0, 4);
            int mleni = (mlen[0] & 0xFF) * 0x1000000 + (mlen[1] & 0xFF) * 65536 + (mlen[2] & 0xFF) * 256 + (mlen[3] & 0xFF);
            byte[] mbytes = new byte[mleni];
            in.read(mbytes, 0, mleni);
            ByteArrayInputStream bais = new ByteArrayInputStream(mbytes);
            ObjectInputStream ois = new ObjectInputStream(bais);
            m = (MessagingPerf.Message)((Object)ois.readObject());
        }
    }

    @Override
    public void testSendingMessages() throws InterruptedException {
        Host host0 = Host.getHost(0);
        Host host1 = Host.getHost(1);
        VM vm0 = host0.getVM(0);
        VM vm1 = host1.getVM(0);
        int[] freeTCPPorts = AvailablePortHelper.getRandomAvailableTCPPorts(2);
        int port1 = freeTCPPorts[0];
        int port2 = freeTCPPorts[0];
        AsyncInvocation ai0 = vm0.invokeAsync(this.getClass(), "work", new Object[]{new Integer(port1), new Integer(port2), TCPPerf.getServerHostName(host1), Boolean.TRUE});
        AsyncInvocation ai1 = vm1.invokeAsync(this.getClass(), "work", new Object[]{new Integer(port2), new Integer(port1), TCPPerf.getServerHostName(host0), Boolean.FALSE});
        DistributedTestCase.join(ai0, 30000L, TCPPerf.getLogWriter());
        if (ai0.exceptionOccurred()) {
            TCPPerf.fail("Exception during " + ai0, ai0.getException());
        }
        DistributedTestCase.join(ai1, 30000L, TCPPerf.getLogWriter());
        if (ai1.exceptionOccurred()) {
            TCPPerf.fail("Exception during " + ai1, ai1.getException());
        }
    }

    public static class Prms
    extends MessagingPerf.Prms {
        public static Long socketBufferSize;
        public static Long tcpNoDelay;

        protected static boolean getTcpNoDelay() {
            return TestConfig.tab().booleanAt(tcpNoDelay);
        }

        protected static int getSocketBufferSize() {
            return TestConfig.tab().intAt(socketBufferSize);
        }

        protected static boolean useDefaultSocketBufferSize() {
            return TestConfig.tab().get(socketBufferSize) != null;
        }

        static {
            BasePrms.setValues(Prms.class);
        }
    }
}

