/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed.internal;

import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.DistributionMessage;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.SerialDistributionMessage;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import dunit.DistributedTestCase;
import dunit.GemFireSystem;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Properties;
import junit.framework.TestCase;

public class JavaGroupsTest
extends DistributedTestCase {
    protected static InternalDistributedSystem system;

    public JavaGroupsTest(String name) {
        super(name);
    }

    protected static InternalDistributedMember remoteGetDistributionManagerId() {
        if (system == null) {
            system = (InternalDistributedSystem)DistributedSystem.connect((Properties)new Properties());
        }
        DM dm = system.getDistributionManager();
        return dm.getDistributionManagerId();
    }

    @Override
    public void tearDown2() {
        if (system != null) {
            system.disconnect();
        }
        for (int h = 0; h < Host.getHostCount(); ++h) {
            Host host = Host.getHost(h);
            for (int v = 0; v < host.getVMCount(); ++v) {
                VM vm = host.getVM(v);
                vm.invoke(new SerializableRunnable("Disconnect from DS"){

                    @Override
                    public void run() {
                        if (system != null) {
                            system.disconnect();
                        }
                    }
                });
            }
        }
    }

    public void testMessagesArriveInOrder() throws InterruptedException {
        Host host = Host.getHost(0);
        GemFireSystem sys0 = host.getSystem(0);
        GemFireSystem sys1 = host.getSystem(1);
        VM vm0 = (VM)sys0.getVMs().get(0);
        VM vm1 = (VM)sys1.getVMs().get(0);
        int max = 20;
        final InternalDistributedMember dmId1 = (InternalDistributedMember)vm1.invoke(this.getClass(), "remoteGetDistributionManagerId");
        vm0.invoke(new SerializableRunnable("Send 20messages"){

            @Override
            public void run() {
                for (int curr = 1; curr <= 20; ++curr) {
                    JavaGroupsTest.remoteGetDistributionManagerId();
                    DM dm = system.getDistributionManager();
                    IntegerMessage m = new IntegerMessage();
                    m.curr = curr;
                    if (curr % 2 == 0) {
                        m.setMulticast(true);
                    } else {
                        m.setRecipient(dmId1);
                    }
                    dm.putOutgoing((DistributionMessage)m);
                }
            }
        });
        vm1.invoke(new SerializableRunnable("Verify no exceptions"){

            @Override
            public void run() {
                DistributionManager dm = (DistributionManager)JavaGroupsTest.this.getSystem().getDistributionManager();
                TestCase.assertTrue((String)"Exceptions occurred", (!dm.exceptionInThreads() ? 1 : 0) != 0);
            }
        });
    }

    public static class IntegerMessage
    extends SerialDistributionMessage {
        private static int prev = 0;
        protected int curr;

        public void process(DistributionManager dm) {
            TestCase.assertTrue((String)("Prev: " + prev + ", curr: " + this.curr), (this.curr > prev ? 1 : 0) != 0);
            dm.getLoggerI18n().convertToLogWriter().info(this.curr + " > " + prev);
            prev = this.curr;
        }

        public int getDSFID() {
            return Integer.MAX_VALUE;
        }

        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            out.writeInt(this.curr);
        }

        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.curr = in.readInt();
        }

        public String toString() {
            return "Integer with value " + this.curr + " send to " + this.getRecipientsDescription();
        }
    }
}

