/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed.internal;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.admin.AdminDistributedSystem;
import com.gemstone.gemfire.admin.AdminDistributedSystemFactory;
import com.gemstone.gemfire.admin.Alert;
import com.gemstone.gemfire.admin.AlertLevel;
import com.gemstone.gemfire.admin.AlertListener;
import com.gemstone.gemfire.admin.DistributedSystemConfig;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionEvent;
import com.gemstone.gemfire.cache.RegionFactory;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.DistributionMessage;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.SerialDistributionMessage;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.distributed.internal.membership.jgroup.JGroupMembershipManager;
import com.gemstone.gemfire.distributed.internal.membership.jgroup.MembershipManagerHelper;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.tcp.Stub;
import com.gemstone.org.jgroups.protocols.pbcast.GMS;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.SerializableRunnable;
import dunit.VM;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import junit.framework.Assert;
import junit.framework.TestCase;

public class DistributionManagerTest
extends DistributedTestCase {
    public static DistributedSystem ds;
    static Cache myCache;
    static volatile boolean regionDestroyedInvoked;
    static AdminDistributedSystem adminSystem;
    static Object alertGuard;
    static boolean alertReceived;

    public static void clearExceptionInThreads(DistributionManager dm) {
        dm.clearExceptionInThreads();
    }

    public DistributionManagerTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        DistributionManagerTest.disconnectAllFromDS();
        super.setUp();
    }

    public void testGetDistributionVMType() {
        DM dm = this.getSystem().getDistributionManager();
        InternalDistributedMember ipaddr = dm.getId();
        DistributionManagerTest.assertEquals((int)10, (int)ipaddr.getVmKind());
    }

    public void testExceptionInThreads() throws InterruptedException {
        DM dm = this.getSystem().getDistributionManager();
        String p1 = "ItsOkayForMyClassNotToBeFound";
        dm.getLoggerI18n().convertToLogWriter().info("<ExpectedException action=add>" + p1 + "</ExpectedException>");
        ItsOkayForMyClassNotToBeFound m = new ItsOkayForMyClassNotToBeFound();
        dm.putOutgoing((DistributionMessage)m);
        Thread.sleep(1000L);
        dm.getLoggerI18n().convertToLogWriter().info("<ExpectedException action=remove>" + p1 + "</ExpectedException>");
    }

    public void _testGetDistributionManagerIds() {
        int systemCount = 0;
        for (int h = 0; h < Host.getHostCount(); ++h) {
            Host host = Host.getHost(h);
            systemCount += host.getSystemCount();
        }
        DM dm = this.getSystem().getDistributionManager();
        DistributionManagerTest.assertEquals((int)(++systemCount), (int)dm.getNormalDistributionManagerIds().size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConnectAfterBeingShunned() {
        InternalDistributedSystem sys = this.getSystem();
        JGroupMembershipManager mgr = MembershipManagerHelper.getMembershipManager((DistributedSystem)sys);
        InternalDistributedMember idm = mgr.getLocalMember();
        System.setProperty("gemfire.jg-bind-port", "" + idm.getPort());
        try {
            sys.disconnect();
            sys = this.getSystem();
            mgr = MembershipManagerHelper.getMembershipManager((DistributedSystem)sys);
            sys.disconnect();
            InternalDistributedMember idm2 = mgr.getLocalMember();
            DistributionManagerTest.getLogWriter().info("original ID=" + idm + " and after connecting=" + idm2);
            DistributionManagerTest.assertTrue((String)"should not have used a different udp port", (idm.getPort() == idm2.getPort() ? 1 : 0) != 0);
        }
        finally {
            System.getProperties().remove("gemfire.jg-bind-port");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSurpriseMemberHandling() {
        VM vm0 = Host.getHost(0).getVM(0);
        InternalDistributedSystem sys = this.getSystem();
        JGroupMembershipManager mgr = MembershipManagerHelper.getMembershipManager((DistributedSystem)sys);
        try {
            InternalDistributedMember mbr = new InternalDistributedMember(DistributedTestCase.getIPLiteral(), 12345);
            Assert.assertTrue((String)"expected view ID to be greater than zero", (mgr.getView().getViewNumber() > 0L ? 1 : 0) != 0);
            int oldViewId = mbr.getVmViewId();
            mbr.setVmViewId((int)mgr.getView().getViewNumber() - 1);
            DistributionManagerTest.getLogWriter().info("current membership view is " + mgr.getView());
            DistributionManagerTest.getLogWriter().info("created ID " + mbr + " with view ID " + mbr.getVmViewId());
            sys.getLogWriter().info("<ExpectedException action=add>attempt to add old member</ExpectedException>");
            sys.getLogWriter().info("<ExpectedException action=add>Removing shunned GemFire node</ExpectedException>");
            try {
                boolean accepted = mgr.addSurpriseMember((DistributedMember)mbr, new Stub());
                Assert.assertTrue((String)"member with old ID was not rejected (bug #44566)", (!accepted ? 1 : 0) != 0);
            }
            finally {
                sys.getLogWriter().info("<ExpectedException action=remove>attempt to add old member</ExpectedException>");
                sys.getLogWriter().info("<ExpectedException action=remove>Removing shunned GemFire node</ExpectedException>");
            }
            mbr.setVmViewId(oldViewId);
            long gracePeriod = 5000L;
            long startTime = System.currentTimeMillis();
            long birthTime = startTime - (long)mgr.getSurpriseMemberTimeout() + gracePeriod;
            MembershipManagerHelper.addSurpriseMember((DistributedSystem)sys, (DistributedMember)mbr, (long)birthTime);
            DistributionManagerTest.assertTrue((String)"Member was not a surprise member", (boolean)mgr.isSurpriseMember((DistributedMember)mbr));
            SerializableRunnable connectDisconnect = new SerializableRunnable(){

                @Override
                public void run() {
                    DistributionManagerTest.this.getSystem().disconnect();
                }
            };
            vm0.invoke(connectDisconnect);
            if (birthTime < System.currentTimeMillis() - (long)mgr.getSurpriseMemberTimeout()) {
                return;
            }
            DistributionManagerTest.assertTrue((String)"Member was incorrectly removed from surprise member set", (boolean)mgr.isSurpriseMember((DistributedMember)mbr));
            try {
                Thread.sleep(gracePeriod);
            }
            catch (InterruptedException e) {
                DistributionManagerTest.fail((String)"test was interrupted");
            }
            vm0.invoke(connectDisconnect);
            DistributionManagerTest.assertTrue((String)"Member was not removed from surprise member set", (!mgr.isSurpriseMember((DistributedMember)mbr) ? 1 : 0) != 0);
        }
        catch (UnknownHostException e) {
            DistributionManagerTest.fail((String)"unable to resolve localhost - test needs some attention");
        }
        finally {
            if (sys != null && sys.isConnected()) {
                sys.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testVerifyMember() {
        VM memberVM = Host.getHost(0).getVM(1);
        int port1 = AvailablePort.getRandomAvailablePort((int)0);
        String locators = DistributionManagerTest.getIPLiteral() + "[" + port1 + "]";
        final Properties properties = new Properties();
        properties.put("mcast-port", "0");
        properties.put("start-locator", locators);
        properties.put("disable-auto-reconnect", "true");
        properties.put("log-level", DistributionManagerTest.getDUnitLogLevel());
        system = (InternalDistributedSystem)DistributedSystem.connect((Properties)properties);
        JGroupMembershipManager mgr = MembershipManagerHelper.getMembershipManager((DistributedSystem)system);
        try {
            properties.remove("start-locator");
            properties.put("locators", locators);
            properties.put("name", "John Doe");
            DistributedMember id = (DistributedMember)memberVM.invoke(new SerializableCallable(){

                public Object call() {
                    DistributedSystem system = DistributedSystem.connect((Properties)properties);
                    return system.getDistributedMember();
                }
            });
            DistributionManagerTest.assertTrue((boolean)id.getName().equals("John Doe"));
            GMS.TEST_HOOK_SLOW_VIEW_CASTING = 20;
            memberVM.invoke(new SerializableRunnable("disconnect and reconnect"){

                @Override
                public void run() {
                    InternalDistributedSystem sys = InternalDistributedSystem.getAnyInstance();
                    DistributedMember oldID = sys.getDistributedMember();
                    DistributionManagerTest.this.crashDistributedSystem((DistributedSystem)sys);
                    sys = DistributedSystem.connect((Properties)properties);
                    DistributedTestCase.getLogWriter().info("initial view in new system is " + MembershipManagerHelper.getMembershipManager((DistributedSystem)sys).getView());
                    if (MembershipManagerHelper.getMembershipManager((DistributedSystem)sys).memberExists((InternalDistributedMember)oldID)) {
                        TestCase.assertFalse((boolean)MembershipManagerHelper.getMembershipManager((DistributedSystem)sys).verifyMember(oldID, "old member has disconnected for this test"));
                    }
                }
            });
            memberVM.invoke(new SerializableRunnable("disconnect"){

                @Override
                public void run() {
                    InternalDistributedSystem sys = InternalDistributedSystem.getAnyInstance();
                    if (sys != null) {
                        sys.disconnect();
                    }
                }
            });
        }
        catch (Throwable throwable) {
            memberVM.invoke(new /* invalid duplicate definition of identical inner class */);
            if (system != null && system.isConnected()) {
                system.disconnect();
            }
            throw throwable;
        }
        if (system != null && system.isConnected()) {
            system.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAckSevereAlertThreshold() throws Exception {
        DistributionManagerTest.disconnectAllFromDS();
        Host host = Host.getHost(0);
        VM vm1 = host.getVM(1);
        String oldAckWait = (String)System.getProperties().remove("gemfire.ack-wait-threshold");
        try {
            final Properties props = this.getDistributedSystemProperties();
            props.setProperty("mcast-port", "0");
            props.setProperty("ack-wait-threshold", "5");
            props.setProperty("ack-severe-alert-threshold", "5");
            props.setProperty("name", "putter");
            this.getSystem(props);
            Region rgn = new RegionFactory().setScope(Scope.DISTRIBUTED_ACK).setEarlyAck(false).setDataPolicy(DataPolicy.REPLICATE).create("testRegion");
            system.getLogWriter().info("<ExpectedException action=add>elapsed while waiting for replies</ExpectedException>");
            vm1.invoke(new SerializableRunnable("Connect to distributed system"){

                @Override
                public void run() {
                    props.setProperty("name", "sleeper");
                    DistributionManagerTest.this.getSystem(props);
                    RegionFactory rf = new RegionFactory();
                    Region r = rf.setScope(Scope.DISTRIBUTED_ACK).setDataPolicy(DataPolicy.REPLICATE).setEarlyAck(false).addCacheListener(DistributionManagerTest.getSleepingListener(false)).create("testRegion");
                    myCache = r.getCache();
                    try {
                        DistributionManagerTest.createAlertListener();
                    }
                    catch (Exception e) {
                        throw new RuntimeException("failed to create alert listener", e);
                    }
                }
            });
            rgn.put((Object)"bomb", (Object)"pow!");
            system.getLogWriter().info("<ExpectedException action=remove>elapsed while waiting for replies</ExpectedException>");
            rgn.getCache().close();
            system.disconnect();
            vm1.invoke(new SerializableRunnable("disconnect from ds"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (!myCache.isClosed()) {
                        if (DistributedTestCase.system.isConnected()) {
                            DistributedTestCase.system.disconnect();
                        }
                        myCache = null;
                    }
                    if (DistributedTestCase.system.isConnected()) {
                        DistributedTestCase.system.disconnect();
                    }
                    Object object = alertGuard;
                    synchronized (object) {
                        TestCase.assertTrue((String)"alert listener was not invoked for event in remote VM", (boolean)alertReceived);
                    }
                }
            });
        }
        finally {
            if (oldAckWait != null) {
                System.setProperty("gemfire.ack-wait-threshold", oldAckWait);
            }
        }
    }

    static CacheListener getSleepingListener(final boolean playDead) {
        regionDestroyedInvoked = false;
        return new CacheListenerAdapter(){

            public void afterCreate(EntryEvent event) {
                try {
                    if (playDead) {
                        MembershipManagerHelper.playDead((DistributedSystem)DistributedTestCase.system);
                    }
                    Thread.sleep(15000L);
                }
                catch (InterruptedException ie) {
                    TestCase.fail((String)"interrupted");
                }
            }

            public void afterRegionDestroy(RegionEvent event) {
                LogWriter logger = myCache.getLogger();
                logger.info("afterRegionDestroyed invoked in sleeping listener");
                logger.info("<ExpectedException action=remove>service failure</ExpectedException>");
                logger.info("<ExpectedException action=remove>com.gemstone.gemfire.ForcedDisconnectException</ExpectedException>");
                regionDestroyedInvoked = true;
            }
        };
    }

    static void createAlertListener() throws Exception {
        DistributedSystemConfig config = AdminDistributedSystemFactory.defineDistributedSystem((DistributedSystem)system, null);
        adminSystem = AdminDistributedSystemFactory.getDistributedSystem((DistributedSystemConfig)config);
        adminSystem.setAlertLevel(AlertLevel.SEVERE);
        adminSystem.addAlertListener(new AlertListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void alert(Alert alert) {
                LogWriter lw = adminSystem.getLogWriter();
                try {
                    lw.info("alert listener invoked for alert originating in " + alert.getConnectionName());
                    lw.info("  alert text = " + alert.getMessage());
                    lw.info("  systemMember = " + alert.getSystemMember());
                }
                catch (Exception e) {
                    lw.severe("exception trying to use alert object", (Throwable)e);
                }
                Object object = alertGuard;
                synchronized (object) {
                    alertReceived = true;
                }
            }
        });
        adminSystem.connect();
        DistributionManagerTest.assertTrue((boolean)adminSystem.waitToBeConnected(5000L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testKickOutSickMember() throws Exception {
        DistributionManagerTest.disconnectAllFromDS();
        Host host = Host.getHost(0);
        VM vm1 = host.getVM(1);
        String oldAckWait = (String)System.getProperties().remove("gemfire.ack-wait-threshold");
        try {
            final Properties props = this.getDistributedSystemProperties();
            props.setProperty("mcast-port", "0");
            props.setProperty("ack-wait-threshold", "5");
            props.setProperty("ack-severe-alert-threshold", "5");
            props.setProperty("name", "putter");
            this.getSystem(props);
            Region rgn = new RegionFactory().setScope(Scope.DISTRIBUTED_ACK).setDataPolicy(DataPolicy.REPLICATE).create("testRegion");
            system.getLogWriter().info("<ExpectedException action=add>sec have elapsed while waiting for replies</ExpectedException>");
            vm1.invoke(new SerializableRunnable("Connect to distributed system"){

                @Override
                public void run() {
                    props.setProperty("name", "sleeper");
                    DistributionManagerTest.this.getSystem(props);
                    LogWriter log = DistributedTestCase.system.getLogWriter();
                    log.info("<ExpectedException action=add>service failure</ExpectedException>");
                    log.info("<ExpectedException action=add>com.gemstone.gemfire.ForcedDisconnectException</ExpectedException>");
                    RegionFactory rf = new RegionFactory();
                    Region r = rf.setScope(Scope.DISTRIBUTED_ACK).setDataPolicy(DataPolicy.REPLICATE).addCacheListener(DistributionManagerTest.getSleepingListener(true)).create("testRegion");
                    myCache = r.getCache();
                }
            });
            rgn.put((Object)"bomb", (Object)"pow!");
            rgn.getCache().close();
            system.getLogWriter().info("<ExpectedException action=remove>sec have elapsed while waiting for replies</ExpectedException>");
            system.disconnect();
            vm1.invoke(new SerializableRunnable("wait for forced disconnect"){

                @Override
                public void run() {
                    DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

                        @Override
                        public boolean done() {
                            return !DistributedTestCase.system.isConnected();
                        }

                        @Override
                        public String description() {
                            return null;
                        }
                    };
                    DistributedTestCase.waitForCriterion(ev, 60000L, 200L, true);
                    ev = new DistributedTestCase.WaitCriterion(){

                        @Override
                        public boolean done() {
                            return myCache.isClosed();
                        }

                        @Override
                        public String description() {
                            return null;
                        }
                    };
                    DistributedTestCase.waitForCriterion(ev, 20000L, 200L, false);
                    if (!myCache.isClosed()) {
                        if (DistributedTestCase.system.isConnected()) {
                            DistributedTestCase.system.disconnect();
                        }
                        myCache = null;
                        throw new RuntimeException("Test Failed - vm1's cache is not closed");
                    }
                    if (DistributedTestCase.system.isConnected()) {
                        DistributedTestCase.system.disconnect();
                        throw new RuntimeException("Test Failed - vm1's system should have been disconnected");
                    }
                    DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

                        @Override
                        public boolean done() {
                            return regionDestroyedInvoked;
                        }

                        @Override
                        public String description() {
                            return "vm1's listener should have received afterRegionDestroyed notification";
                        }
                    };
                    DistributedTestCase.waitForCriterion(wc, 30000L, 1000L, true);
                }
            });
        }
        finally {
            if (oldAckWait != null) {
                System.setProperty("gemfire.ack-wait-threshold", oldAckWait);
            }
        }
    }

    public void testBadBindAddress() throws Exception {
        DistributionManagerTest.disconnectAllFromDS();
        Properties props = this.getDistributedSystemProperties();
        props.setProperty("mcast-port", "0");
        props.setProperty("bind-address", "www.yahoo.com");
        props.setProperty("ack-wait-threshold", "5");
        props.setProperty("ack-severe-alert-threshold", "5");
        try {
            this.getSystem(props);
        }
        catch (IllegalArgumentException e) {
            DistributionManagerTest.getLogWriter().info("caught expected exception (1)", (Throwable)e);
        }
        props.setProperty("bind-address", "bruce.schuchardt");
        try {
            this.getSystem(props);
        }
        catch (IllegalArgumentException e) {
            DistributionManagerTest.getLogWriter().info("caught expected exception (2_", (Throwable)e);
        }
        props.setProperty("bind-address", InetAddress.getLocalHost().getCanonicalHostName());
        this.getSystem().disconnect();
    }

    static {
        alertGuard = new Object();
    }

    protected static class ItsOkayForMyClassNotToBeFound
    extends SerialDistributionMessage {
        protected ItsOkayForMyClassNotToBeFound() {
        }

        public int getDSFID() {
            return Integer.MAX_VALUE;
        }

        protected void process(DistributionManager dm) {
        }
    }
}

