/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.distributed.AbstractLauncher;
import com.gemstone.gemfire.distributed.AbstractServerLauncherDUnitTestCase;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.ServerLauncher;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import com.gemstone.gemfire.internal.GemFireVersion;
import com.gemstone.gemfire.internal.SocketCreator;
import com.gemstone.gemfire.internal.cache.xmlcache.CacheCreation;
import com.gemstone.gemfire.internal.cache.xmlcache.CacheXmlGenerator;
import com.gemstone.gemfire.internal.cache.xmlcache.RegionAttributesCreation;
import com.gemstone.gemfire.internal.process.FileAlreadyExistsException;
import com.gemstone.gemfire.internal.process.ProcessControllerFactory;
import com.gemstone.gemfire.internal.process.ProcessType;
import com.gemstone.gemfire.internal.process.ProcessUtils;
import com.gemstone.org.jgroups.util.GFLogWriter;
import dunit.Host;
import dunit.SerializableRunnable;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.net.BindException;
import junit.framework.TestCase;

public class ServerLauncherLocalDUnitTest
extends AbstractServerLauncherDUnitTestCase {
    public ServerLauncherLocalDUnitTest(String name) {
        super(name);
    }

    @Override
    protected final void subSetUp1() throws Exception {
        ServerLauncherLocalDUnitTest.disconnectAllFromDS();
        System.setProperty("gemfire.test.ProcessType.TEST_PREFIX", this.getUniqueName() + "-");
        this.subSetUp2();
    }

    @Override
    protected final void subTearDown1() throws Exception {
        ServerLauncherLocalDUnitTest.disconnectAllFromDS();
        System.clearProperty("gemfire.test.ProcessType.TEST_PREFIX");
        this.subTearDown2();
    }

    protected void subSetUp2() throws Exception {
    }

    protected void subTearDown2() throws Exception {
    }

    protected AbstractLauncher.Status getExpectedStopStatusForNotRunning() {
        return AbstractLauncher.Status.NOT_RESPONDING;
    }

    public void testBuilderSetProperties() throws Throwable {
        Throwable failure;
        block6: {
            block5: {
                failure = null;
                this.launcher = new ServerLauncher.Builder().setDisableDefaultServer(Boolean.valueOf(true)).setForce(Boolean.valueOf(true)).setMemberName(this.getUniqueName()).set("disable-auto-reconnect", "true").set("log-level", "config").set("mcast-port", "0").build();
                ServerLauncherLocalDUnitTest.assertNotNull((Object)this.launcher);
                try {
                    ServerLauncherLocalDUnitTest.assertEquals((Object)AbstractLauncher.Status.ONLINE, (Object)this.launcher.start().getStatus());
                    this.waitForServerToStart(this.launcher);
                    Cache cache = this.launcher.getCache();
                    ServerLauncherLocalDUnitTest.assertNotNull((Object)cache);
                    DistributedSystem distributedSystem = cache.getDistributedSystem();
                    ServerLauncherLocalDUnitTest.assertNotNull((Object)distributedSystem);
                    ServerLauncherLocalDUnitTest.assertEquals((String)"true", (String)distributedSystem.getProperties().getProperty("disable-auto-reconnect"));
                    ServerLauncherLocalDUnitTest.assertEquals((String)"config", (String)distributedSystem.getProperties().getProperty("log-level"));
                    ServerLauncherLocalDUnitTest.assertEquals((String)"0", (String)distributedSystem.getProperties().getProperty("mcast-port"));
                    ServerLauncherLocalDUnitTest.assertEquals((String)this.getUniqueName(), (String)distributedSystem.getProperties().getProperty("name"));
                }
                catch (Throwable e) {
                    ServerLauncherLocalDUnitTest.getLogWriter().error(e);
                    if (failure != null) break block5;
                    failure = e;
                }
            }
            try {
                ServerLauncherLocalDUnitTest.assertEquals((Object)AbstractLauncher.Status.STOPPED, (Object)this.launcher.stop().getStatus());
                ServerLauncherLocalDUnitTest.assertNull((Object)this.launcher.getCache());
            }
            catch (Throwable e) {
                ServerLauncherLocalDUnitTest.getLogWriter().error(e);
                if (failure != null) break block6;
                failure = e;
            }
        }
        if (failure != null) {
            throw failure;
        }
    }

    public void testIsAttachAPIFound() throws Exception {
        ProcessControllerFactory factory = new ProcessControllerFactory();
        ServerLauncherLocalDUnitTest.assertTrue((boolean)factory.isAttachAPIFound());
        ServerLauncherLocalDUnitTest.invokeInEveryVM(new SerializableRunnable("isAttachAPIFound"){

            @Override
            public void run() {
                ProcessControllerFactory factory = new ProcessControllerFactory();
                TestCase.assertTrue((boolean)factory.isAttachAPIFound());
            }
        });
    }

    public void testStartCreatesPidFile() throws Throwable {
        Throwable failure;
        block6: {
            block5: {
                ServerLauncher.Builder builder = new ServerLauncher.Builder().setDisableDefaultServer(Boolean.valueOf(true)).setMemberName(this.getUniqueName()).setRedirectOutput(Boolean.valueOf(true)).set("log-level", "config");
                this.launcher = builder.build();
                ServerLauncherLocalDUnitTest.assertNotNull((Object)this.launcher);
                failure = null;
                try {
                    this.launcher.start();
                    this.waitForServerToStart(this.launcher);
                    ServerLauncherLocalDUnitTest.assertEquals((Object)AbstractLauncher.Status.ONLINE, (Object)this.launcher.status().getStatus());
                    this.pidFile = new File(builder.getWorkingDirectory(), ProcessType.SERVER.getPidFileName());
                    ServerLauncherLocalDUnitTest.assertTrue((boolean)this.pidFile.exists());
                    int pid = this.readPid(this.pidFile);
                    ServerLauncherLocalDUnitTest.assertTrue((pid > 0 ? 1 : 0) != 0);
                    ServerLauncherLocalDUnitTest.assertTrue((boolean)this.isPidAlive(pid));
                    ServerLauncherLocalDUnitTest.assertEquals((int)ServerLauncherLocalDUnitTest.getPid(), (int)pid);
                    ServerLauncherLocalDUnitTest.assertEquals((Object)AbstractLauncher.Status.ONLINE, (Object)this.launcher.status().getStatus());
                }
                catch (Throwable e) {
                    ServerLauncherLocalDUnitTest.getLogWriter().error(e);
                    if (failure != null) break block5;
                    failure = e;
                }
            }
            try {
                ServerLauncherLocalDUnitTest.assertEquals((Object)AbstractLauncher.Status.STOPPED, (Object)this.launcher.stop().getStatus());
                this.waitForFileToDelete(this.pidFile);
            }
            catch (Throwable e) {
                ServerLauncherLocalDUnitTest.getLogWriter().error(e);
                if (failure != null) break block6;
                failure = e;
            }
        }
        if (failure != null) {
            throw failure;
        }
    }

    public void testStartDeletesStaleControlFiles() throws Throwable {
        Throwable failure;
        block9: {
            block8: {
                block7: {
                    this.stopRequestFile = new File(ProcessType.SERVER.getStopRequestFileName());
                    this.stopRequestFile.createNewFile();
                    ServerLauncherLocalDUnitTest.assertTrue((boolean)this.stopRequestFile.exists());
                    this.statusRequestFile = new File(ProcessType.SERVER.getStatusRequestFileName());
                    this.statusRequestFile.createNewFile();
                    ServerLauncherLocalDUnitTest.assertTrue((boolean)this.statusRequestFile.exists());
                    this.statusFile = new File(ProcessType.SERVER.getStatusFileName());
                    this.statusFile.createNewFile();
                    ServerLauncherLocalDUnitTest.assertTrue((boolean)this.statusFile.exists());
                    ServerLauncher.Builder builder = new ServerLauncher.Builder().setDisableDefaultServer(Boolean.valueOf(true)).setMemberName(this.getUniqueName()).setRedirectOutput(Boolean.valueOf(true)).set("log-level", "config");
                    ServerLauncherLocalDUnitTest.assertFalse((boolean)builder.getForce());
                    this.launcher = builder.build();
                    ServerLauncherLocalDUnitTest.assertFalse((boolean)this.launcher.isForcing());
                    this.launcher.start();
                    failure = null;
                    try {
                        this.waitForServerToStart(this.launcher);
                    }
                    catch (Throwable e) {
                        ServerLauncherLocalDUnitTest.getLogWriter().error(e);
                        if (failure != null) break block7;
                        failure = e;
                    }
                }
                try {
                    this.pidFile = new File(ProcessType.SERVER.getPidFileName());
                    ServerLauncherLocalDUnitTest.assertTrue((boolean)this.pidFile.exists());
                    int pid = this.readPid(this.pidFile);
                    ServerLauncherLocalDUnitTest.assertTrue((pid > 0 ? 1 : 0) != 0);
                    ServerLauncherLocalDUnitTest.assertTrue((boolean)this.isPidAlive(pid));
                    ServerLauncherLocalDUnitTest.assertEquals((int)ServerLauncherLocalDUnitTest.getPid(), (int)pid);
                    ServerLauncherLocalDUnitTest.assertFalse((boolean)this.stopRequestFile.exists());
                    ServerLauncherLocalDUnitTest.assertFalse((boolean)this.statusRequestFile.exists());
                    ServerLauncherLocalDUnitTest.assertFalse((boolean)this.statusFile.exists());
                    String logFileName = this.getUniqueName() + ".log";
                    ServerLauncherLocalDUnitTest.assertTrue((String)("Log file should exist: " + logFileName), (boolean)new File(logFileName).exists());
                }
                catch (Throwable e) {
                    ServerLauncherLocalDUnitTest.getLogWriter().error(e);
                    if (failure != null) break block8;
                    failure = e;
                }
            }
            try {
                ServerLauncherLocalDUnitTest.assertEquals((Object)AbstractLauncher.Status.STOPPED, (Object)this.launcher.stop().getStatus());
                this.waitForFileToDelete(this.pidFile);
            }
            catch (Throwable e) {
                ServerLauncherLocalDUnitTest.getLogWriter().error(e);
                if (failure != null) break block9;
                failure = e;
            }
        }
        if (failure != null) {
            throw failure;
        }
    }

    public void testStartOverwritesStalePidFile() throws Throwable {
        Throwable failure;
        block9: {
            block8: {
                block7: {
                    this.pidFile = new File(ProcessType.SERVER.getPidFileName());
                    ServerLauncherLocalDUnitTest.assertFalse((String)"Integer.MAX_VALUE shouldn't be the same as local pid 2147483647", (Integer.MAX_VALUE == ProcessUtils.identifyPid() ? 1 : 0) != 0);
                    this.writePid(this.pidFile, Integer.MAX_VALUE);
                    ServerLauncher.Builder builder = new ServerLauncher.Builder().setDisableDefaultServer(Boolean.valueOf(true)).setMemberName(this.getUniqueName()).setRedirectOutput(Boolean.valueOf(true)).set("log-level", "config");
                    ServerLauncherLocalDUnitTest.assertFalse((boolean)builder.getForce());
                    this.launcher = builder.build();
                    ServerLauncherLocalDUnitTest.assertFalse((boolean)this.launcher.isForcing());
                    this.launcher.start();
                    failure = null;
                    try {
                        this.waitForServerToStart(this.launcher);
                    }
                    catch (Throwable e) {
                        ServerLauncherLocalDUnitTest.getLogWriter().error(e);
                        if (failure != null) break block7;
                        failure = e;
                    }
                }
                try {
                    ServerLauncherLocalDUnitTest.assertTrue((boolean)this.pidFile.exists());
                    int pid = this.readPid(this.pidFile);
                    ServerLauncherLocalDUnitTest.assertTrue((pid > 0 ? 1 : 0) != 0);
                    ServerLauncherLocalDUnitTest.assertTrue((boolean)this.isPidAlive(pid));
                    ServerLauncherLocalDUnitTest.assertEquals((int)ServerLauncherLocalDUnitTest.getPid(), (int)pid);
                }
                catch (Throwable e) {
                    ServerLauncherLocalDUnitTest.getLogWriter().error(e);
                    if (failure != null) break block8;
                    failure = e;
                }
            }
            try {
                ServerLauncherLocalDUnitTest.assertEquals((Object)AbstractLauncher.Status.STOPPED, (Object)this.launcher.stop().getStatus());
                this.waitForFileToDelete(this.pidFile);
            }
            catch (Throwable e) {
                ServerLauncherLocalDUnitTest.getLogWriter().error(e);
                if (failure != null) break block9;
                failure = e;
            }
        }
        if (failure != null) {
            throw failure;
        }
    }

    public void testStartUsingDisableDefaultServerLeavesPortFree() throws Throwable {
        Throwable failure;
        block6: {
            block5: {
                failure = null;
                ServerLauncherLocalDUnitTest.assertTrue((boolean)AvailablePort.isPortAvailable((int)this.serverPort, (int)0));
                ServerLauncher.Builder builder = new ServerLauncher.Builder().setDisableDefaultServer(Boolean.valueOf(true)).setMemberName(this.getUniqueName()).setRedirectOutput(Boolean.valueOf(true)).set("log-level", "config");
                this.launcher = builder.build();
                int pid = 0;
                try {
                    this.launcher.start();
                    this.waitForServerToStart(this.launcher);
                    this.pidFile = new File(ProcessType.SERVER.getPidFileName());
                    ServerLauncherLocalDUnitTest.assertTrue((boolean)this.pidFile.exists());
                    pid = this.readPid(this.pidFile);
                    ServerLauncherLocalDUnitTest.assertTrue((pid > 0 ? 1 : 0) != 0);
                    ServerLauncherLocalDUnitTest.assertTrue((boolean)this.isPidAlive(pid));
                    ServerLauncherLocalDUnitTest.assertEquals((int)ServerLauncherLocalDUnitTest.getPid(), (int)pid);
                    String logFileName = this.getUniqueName() + ".log";
                    ServerLauncherLocalDUnitTest.assertTrue((String)("Log file should exist: " + logFileName), (boolean)new File(logFileName).exists());
                    ServerLauncherLocalDUnitTest.assertTrue((boolean)AvailablePort.isPortAvailable((int)this.serverPort, (int)0));
                    ServerLauncher.ServerState status = this.launcher.status();
                    String portString = status.getPort();
                    ServerLauncherLocalDUnitTest.assertEquals((String)("Port should be \"\" instead of " + portString), (String)"", (String)portString);
                }
                catch (Throwable e) {
                    ServerLauncherLocalDUnitTest.getLogWriter().error(e);
                    if (failure != null) break block5;
                    failure = e;
                }
            }
            try {
                ServerLauncherLocalDUnitTest.assertEquals((Object)AbstractLauncher.Status.STOPPED, (Object)this.launcher.stop().getStatus());
                this.waitForFileToDelete(this.pidFile);
            }
            catch (Throwable e) {
                ServerLauncherLocalDUnitTest.getLogWriter().error(e);
                if (failure != null) break block6;
                failure = e;
            }
        }
        if (failure != null) {
            throw failure;
        }
    }

    public void testStartUsingDisableDefaultServerSkipsPortCheck() throws Throwable {
        Throwable failure;
        block6: {
            block5: {
                failure = null;
                this.socket = SocketCreator.getDefaultInstance().createServerSocket(this.serverPort, 50, null, (GFLogWriter)ServerLauncherLocalDUnitTest.getLogWriter().convertToLogWriterI18n(), -1);
                ServerLauncherLocalDUnitTest.assertFalse((boolean)AvailablePort.isPortAvailable((int)this.serverPort, (int)0));
                ServerLauncher.Builder builder = new ServerLauncher.Builder().setDisableDefaultServer(Boolean.valueOf(true)).setMemberName(this.getUniqueName()).setRedirectOutput(Boolean.valueOf(true)).set("log-level", "config");
                this.launcher = builder.build();
                int pid = 0;
                try {
                    this.launcher.start();
                    this.waitForServerToStart(this.launcher);
                    this.pidFile = new File(ProcessType.SERVER.getPidFileName());
                    ServerLauncherLocalDUnitTest.assertTrue((boolean)this.pidFile.exists());
                    pid = this.readPid(this.pidFile);
                    ServerLauncherLocalDUnitTest.assertTrue((pid > 0 ? 1 : 0) != 0);
                    ServerLauncherLocalDUnitTest.assertTrue((boolean)this.isPidAlive(pid));
                    ServerLauncherLocalDUnitTest.assertEquals((int)ServerLauncherLocalDUnitTest.getPid(), (int)pid);
                    String logFileName = this.getUniqueName() + ".log";
                    ServerLauncherLocalDUnitTest.assertTrue((String)("Log file should exist: " + logFileName), (boolean)new File(logFileName).exists());
                    ServerLauncher.ServerState status = this.launcher.status();
                    String portString = status.getPort();
                    ServerLauncherLocalDUnitTest.assertEquals((String)("Port should be \"\" instead of " + portString), (String)"", (String)portString);
                }
                catch (Throwable e) {
                    ServerLauncherLocalDUnitTest.getLogWriter().error(e);
                    if (failure != null) break block5;
                    failure = e;
                }
            }
            try {
                ServerLauncherLocalDUnitTest.assertEquals((Object)AbstractLauncher.Status.STOPPED, (Object)this.launcher.stop().getStatus());
                this.waitForFileToDelete(this.pidFile);
            }
            catch (Throwable e) {
                ServerLauncherLocalDUnitTest.getLogWriter().error(e);
                if (failure != null) break block6;
                failure = e;
            }
        }
        ServerLauncherLocalDUnitTest.assertFalse((boolean)AvailablePort.isPortAvailable((int)this.serverPort, (int)0));
        if (failure != null) {
            throw failure;
        }
    }

    public void testStartUsingForceOverwritesExistingPidFile() throws Throwable {
        Throwable failure;
        block6: {
            block5: {
                ServerLauncherLocalDUnitTest.assertTrue((String)(this.getUniqueName() + " is broken if PID == Integer.MAX_VALUE"), (ProcessUtils.identifyPid() != Integer.MAX_VALUE ? 1 : 0) != 0);
                this.pidFile = new File(ProcessType.SERVER.getPidFileName());
                int realPid = Host.getHost(0).getVM(3).invokeInt(ProcessUtils.class, "identifyPid");
                ServerLauncherLocalDUnitTest.assertFalse((realPid == ProcessUtils.identifyPid() ? 1 : 0) != 0);
                this.writePid(this.pidFile, realPid);
                ServerLauncher.Builder builder = new ServerLauncher.Builder().setDisableDefaultServer(Boolean.valueOf(true)).setForce(Boolean.valueOf(true)).setMemberName(this.getUniqueName()).setRedirectOutput(Boolean.valueOf(true)).set("log-level", "config");
                ServerLauncherLocalDUnitTest.assertTrue((boolean)builder.getForce());
                this.launcher = builder.build();
                ServerLauncherLocalDUnitTest.assertTrue((boolean)this.launcher.isForcing());
                this.launcher.start();
                failure = null;
                try {
                    this.waitForServerToStart(this.launcher);
                    ServerLauncherLocalDUnitTest.assertTrue((boolean)this.pidFile.exists());
                    int pid = this.readPid(this.pidFile);
                    ServerLauncherLocalDUnitTest.assertTrue((pid > 0 ? 1 : 0) != 0);
                    ServerLauncherLocalDUnitTest.assertTrue((boolean)this.isPidAlive(pid));
                    ServerLauncherLocalDUnitTest.assertEquals((int)ServerLauncherLocalDUnitTest.getPid(), (int)pid);
                    String logFileName = this.getUniqueName() + ".log";
                    ServerLauncherLocalDUnitTest.assertTrue((String)("Log file should exist: " + logFileName), (boolean)new File(logFileName).exists());
                }
                catch (Throwable e) {
                    ServerLauncherLocalDUnitTest.getLogWriter().error(e);
                    if (failure != null) break block5;
                    failure = e;
                }
            }
            try {
                ServerLauncherLocalDUnitTest.assertEquals((Object)AbstractLauncher.Status.STOPPED, (Object)this.launcher.stop().getStatus());
                this.waitForFileToDelete(this.pidFile);
            }
            catch (Throwable e) {
                ServerLauncherLocalDUnitTest.getLogWriter().error(e);
                if (failure != null) break block6;
                failure = e;
            }
        }
        if (failure != null) {
            throw failure;
        }
    }

    public void testStartUsingServerPortOverridesCacheXml() throws Throwable {
        Throwable failure;
        block6: {
            block5: {
                int[] freeTCPPorts = AvailablePortHelper.getRandomAvailableTCPPorts(2);
                ServerLauncherLocalDUnitTest.assertTrue((boolean)AvailablePort.isPortAvailable((int)freeTCPPorts[0], (int)0));
                ServerLauncherLocalDUnitTest.assertTrue((boolean)AvailablePort.isPortAvailable((int)freeTCPPorts[1], (int)0));
                CacheCreation creation = new CacheCreation();
                RegionAttributesCreation attrs = new RegionAttributesCreation(creation);
                attrs.setScope(Scope.DISTRIBUTED_ACK);
                attrs.setDataPolicy(DataPolicy.REPLICATE);
                creation.createRegion(this.getUniqueName(), (RegionAttributes)attrs);
                creation.addCacheServer().setPort(freeTCPPorts[0]);
                this.cacheXmlFile = new File(this.getUniqueName() + ".xml");
                boolean useSchema = false;
                PrintWriter pw = new PrintWriter((Writer)new FileWriter(this.cacheXmlFile), true);
                CacheXmlGenerator.generate((Cache)creation, (PrintWriter)pw, (boolean)false, (String)"7_5");
                pw.close();
                System.setProperty("cache-xml-file", this.cacheXmlFile.getCanonicalPath());
                ServerLauncher.Builder builder = new ServerLauncher.Builder().setMemberName(this.getUniqueName()).setRedirectOutput(Boolean.valueOf(true)).setServerPort(Integer.valueOf(freeTCPPorts[1])).set("log-level", "config");
                this.launcher = builder.build();
                this.launcher.start();
                failure = null;
                int pid = 0;
                try {
                    this.waitForServerToStart(this.launcher);
                    this.pidFile = new File(ProcessType.SERVER.getPidFileName());
                    ServerLauncherLocalDUnitTest.assertTrue((boolean)this.pidFile.exists());
                    pid = this.readPid(this.pidFile);
                    ServerLauncherLocalDUnitTest.assertTrue((pid > 0 ? 1 : 0) != 0);
                    ServerLauncherLocalDUnitTest.assertTrue((boolean)this.isPidAlive(pid));
                    ServerLauncherLocalDUnitTest.assertEquals((int)ServerLauncherLocalDUnitTest.getPid(), (int)pid);
                    String logFileName = this.getUniqueName() + ".log";
                    ServerLauncherLocalDUnitTest.assertTrue((String)("Log file should exist: " + logFileName), (boolean)new File(logFileName).exists());
                    ServerLauncherLocalDUnitTest.assertTrue((boolean)AvailablePort.isPortAvailable((int)freeTCPPorts[0], (int)0));
                    ServerLauncherLocalDUnitTest.assertFalse((boolean)AvailablePort.isPortAvailable((int)freeTCPPorts[1], (int)0));
                    ServerLauncher.ServerState status = this.launcher.status();
                    String portString = status.getPort();
                    int port = Integer.valueOf(portString);
                    ServerLauncherLocalDUnitTest.assertEquals((String)("Port should be " + freeTCPPorts[1] + " instead of " + port), (int)freeTCPPorts[1], (int)port);
                }
                catch (Throwable e) {
                    ServerLauncherLocalDUnitTest.getLogWriter().error(e);
                    if (failure != null) break block5;
                    failure = e;
                }
            }
            try {
                ServerLauncherLocalDUnitTest.assertEquals((Object)AbstractLauncher.Status.STOPPED, (Object)this.launcher.stop().getStatus());
                this.waitForFileToDelete(this.pidFile);
                ServerLauncherLocalDUnitTest.assertFalse((String)"PID file still exists!", (boolean)this.pidFile.exists());
            }
            catch (Throwable e) {
                ServerLauncherLocalDUnitTest.getLogWriter().error(e);
                if (failure != null) break block6;
                failure = e;
            }
        }
        if (failure != null) {
            throw failure;
        }
    }

    public void testStartUsingServerPortUsedInsteadOfDefaultCacheXml() throws Throwable {
        Throwable failure;
        block6: {
            block5: {
                CacheCreation creation = new CacheCreation();
                RegionAttributesCreation attrs = new RegionAttributesCreation(creation);
                attrs.setScope(Scope.DISTRIBUTED_ACK);
                attrs.setDataPolicy(DataPolicy.REPLICATE);
                creation.createRegion(this.getUniqueName(), (RegionAttributes)attrs);
                creation.addCacheServer();
                this.cacheXmlFile = new File(this.getUniqueName() + ".xml");
                boolean useSchema = false;
                PrintWriter pw = new PrintWriter((Writer)new FileWriter(this.cacheXmlFile), true);
                CacheXmlGenerator.generate((Cache)creation, (PrintWriter)pw, (boolean)false, (String)"7_5");
                pw.close();
                System.setProperty("cache-xml-file", this.cacheXmlFile.getCanonicalPath());
                ServerLauncher.Builder builder = new ServerLauncher.Builder().setMemberName(this.getUniqueName()).setRedirectOutput(Boolean.valueOf(true)).setServerPort(Integer.valueOf(this.serverPort)).set("log-level", "config");
                this.launcher = builder.build();
                this.launcher.start();
                failure = null;
                int pid = 0;
                try {
                    this.waitForServerToStart(this.launcher);
                    this.pidFile = new File(ProcessType.SERVER.getPidFileName());
                    ServerLauncherLocalDUnitTest.assertTrue((boolean)this.pidFile.exists());
                    pid = this.readPid(this.pidFile);
                    ServerLauncherLocalDUnitTest.assertTrue((pid > 0 ? 1 : 0) != 0);
                    ServerLauncherLocalDUnitTest.assertTrue((boolean)this.isPidAlive(pid));
                    ServerLauncherLocalDUnitTest.assertEquals((int)ServerLauncherLocalDUnitTest.getPid(), (int)pid);
                    String logFileName = this.getUniqueName() + ".log";
                    ServerLauncherLocalDUnitTest.assertTrue((String)("Log file should exist: " + logFileName), (boolean)new File(logFileName).exists());
                    ServerLauncherLocalDUnitTest.assertFalse((boolean)AvailablePort.isPortAvailable((int)this.serverPort, (int)0));
                    int port = Integer.valueOf(this.launcher.status().getPort());
                    ServerLauncherLocalDUnitTest.assertEquals((String)("Port should be " + this.serverPort + " instead of " + port), (int)this.serverPort, (int)port);
                }
                catch (Throwable e) {
                    ServerLauncherLocalDUnitTest.getLogWriter().error(e);
                    if (failure != null) break block5;
                    failure = e;
                }
            }
            try {
                ServerLauncherLocalDUnitTest.assertEquals((Object)AbstractLauncher.Status.STOPPED, (Object)this.launcher.stop().getStatus());
                this.waitForFileToDelete(this.pidFile);
            }
            catch (Throwable e) {
                ServerLauncherLocalDUnitTest.getLogWriter().error(e);
                if (failure != null) break block6;
                failure = e;
            }
        }
        if (failure != null) {
            throw failure;
        }
    }

    public void testStartWithDefaultPortInUseFails() throws Throwable {
        Throwable failure;
        block15: {
            block14: {
                block13: {
                    RuntimeException expected;
                    block12: {
                        this.socket = SocketCreator.getDefaultInstance().createServerSocket(this.serverPort, 50, null, (GFLogWriter)ServerLauncherLocalDUnitTest.getLogWriter().convertToLogWriterI18n(), -1);
                        ServerLauncherLocalDUnitTest.assertFalse((boolean)AvailablePort.isPortAvailable((int)this.serverPort, (int)0));
                        ServerLauncher.Builder builder = new ServerLauncher.Builder().setMemberName(this.getUniqueName()).setRedirectOutput(Boolean.valueOf(true)).set("log-level", "config");
                        this.launcher = builder.build();
                        failure = null;
                        expected = null;
                        try {
                            this.launcher.start();
                            String property = System.getProperty("gemfire.test.CacheServer.OVERRIDE_DEFAULT_PORT");
                            ServerLauncherLocalDUnitTest.assertNotNull((Object)property);
                            ServerLauncherLocalDUnitTest.assertEquals((int)this.serverPort, (int)Integer.valueOf(property));
                            ServerLauncherLocalDUnitTest.assertFalse((boolean)AvailablePort.isPortAvailable((int)this.serverPort, (int)0));
                            ServerLauncherLocalDUnitTest.fail((String)("Server port is " + ((CacheServer)this.launcher.getCache().getCacheServers().get(0)).getPort()));
                            ServerLauncherLocalDUnitTest.fail((String)"ServerLauncher start should have thrown RuntimeException caused by BindException");
                        }
                        catch (RuntimeException e) {
                            expected = e;
                            ServerLauncherLocalDUnitTest.assertNotNull((Object)expected.getMessage());
                        }
                        catch (Throwable e) {
                            ServerLauncherLocalDUnitTest.getLogWriter().error(e);
                            if (failure != null) break block12;
                            failure = e;
                        }
                    }
                    try {
                        ServerLauncherLocalDUnitTest.assertNotNull((Object)expected);
                        Throwable cause = expected.getCause();
                        ServerLauncherLocalDUnitTest.assertNotNull((Object)cause);
                        ServerLauncherLocalDUnitTest.assertTrue((boolean)(cause instanceof BindException));
                    }
                    catch (Throwable e) {
                        ServerLauncherLocalDUnitTest.getLogWriter().error(e);
                        if (failure != null) break block13;
                        failure = e;
                    }
                }
                try {
                    this.pidFile = new File(ProcessType.SERVER.getPidFileName());
                    ServerLauncherLocalDUnitTest.assertFalse((String)("Pid file should not exist: " + this.pidFile), (boolean)this.pidFile.exists());
                    String logFileName = this.getUniqueName() + ".log";
                    ServerLauncherLocalDUnitTest.assertFalse((String)("Log file should not exist: " + logFileName), (boolean)new File(logFileName).exists());
                }
                catch (Throwable e) {
                    ServerLauncherLocalDUnitTest.getLogWriter().error(e);
                    if (failure != null) break block14;
                    failure = e;
                }
            }
            ServerLauncher.ServerState status = null;
            try {
                status = this.launcher.stop();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.waitForFileToDelete(this.pidFile);
                ServerLauncherLocalDUnitTest.assertEquals((Object)this.getExpectedStopStatusForNotRunning(), (Object)status.getStatus());
            }
            catch (Throwable e) {
                ServerLauncherLocalDUnitTest.getLogWriter().error(e);
                if (failure != null) break block15;
                failure = e;
            }
        }
        if (failure != null) {
            throw failure;
        }
    }

    public void testStartWithExistingPidFileFails() throws Throwable {
        Throwable failure;
        block12: {
            ServerLauncher.ServerState status;
            block11: {
                RuntimeException expected;
                int realPid;
                block10: {
                    realPid = Host.getHost(0).getVM(3).invokeInt(ProcessUtils.class, "identifyPid");
                    ServerLauncherLocalDUnitTest.assertFalse((String)("Remote pid shouldn't be the same as local pid " + realPid), (realPid == ProcessUtils.identifyPid() ? 1 : 0) != 0);
                    this.pidFile = new File(ProcessType.SERVER.getPidFileName());
                    this.writePid(this.pidFile, realPid);
                    ServerLauncher.Builder builder = new ServerLauncher.Builder().setDisableDefaultServer(Boolean.valueOf(true)).setMemberName(this.getUniqueName()).setRedirectOutput(Boolean.valueOf(true)).set("log-level", "config");
                    ServerLauncherLocalDUnitTest.assertFalse((boolean)builder.getForce());
                    this.launcher = builder.build();
                    ServerLauncherLocalDUnitTest.assertFalse((boolean)this.launcher.isForcing());
                    failure = null;
                    expected = null;
                    try {
                        this.launcher.start();
                        ServerLauncherLocalDUnitTest.fail((String)"ServerLauncher start should have thrown RuntimeException caused by FileAlreadyExistsException");
                    }
                    catch (RuntimeException e) {
                        expected = e;
                        ServerLauncherLocalDUnitTest.assertNotNull((Object)expected.getMessage());
                        ServerLauncherLocalDUnitTest.assertTrue((boolean)expected.getMessage().contains("A PID file already exists and a Server may be running in"));
                    }
                    catch (Throwable e) {
                        ServerLauncherLocalDUnitTest.getLogWriter().error(e);
                        if (failure != null) break block10;
                        failure = e;
                    }
                }
                status = null;
                try {
                    status = this.launcher.stop();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    ServerLauncherLocalDUnitTest.assertNotNull((Object)expected);
                    Throwable cause = expected.getCause();
                    ServerLauncherLocalDUnitTest.assertNotNull((Object)cause);
                    ServerLauncherLocalDUnitTest.assertTrue((boolean)(cause instanceof FileAlreadyExistsException));
                    ServerLauncherLocalDUnitTest.assertTrue((boolean)cause.getMessage().contains("Pid file already exists: "));
                    ServerLauncherLocalDUnitTest.assertTrue((boolean)cause.getMessage().contains("vf.gf.server.pid for process " + realPid));
                }
                catch (Throwable e) {
                    ServerLauncherLocalDUnitTest.getLogWriter().error(e);
                    if (failure != null) break block11;
                    failure = e;
                }
            }
            try {
                this.delete(this.pidFile);
                AbstractLauncher.Status theStatus = status.getStatus();
                ServerLauncherLocalDUnitTest.assertFalse((theStatus == AbstractLauncher.Status.STARTING ? 1 : 0) != 0);
                ServerLauncherLocalDUnitTest.assertFalse((theStatus == AbstractLauncher.Status.ONLINE ? 1 : 0) != 0);
            }
            catch (Throwable e) {
                ServerLauncherLocalDUnitTest.getLogWriter().error(e);
                if (failure != null) break block12;
                failure = e;
            }
        }
        if (failure != null) {
            throw failure;
        }
    }

    public void testStartUsingServerPortInUseFails() throws Throwable {
        Throwable failure;
        block15: {
            block14: {
                block13: {
                    RuntimeException expected;
                    block12: {
                        int freeTCPPort = AvailablePort.getRandomAvailablePort((int)0);
                        this.socket = SocketCreator.getDefaultInstance().createServerSocket(freeTCPPort, 50, null, (GFLogWriter)ServerLauncherLocalDUnitTest.getLogWriter().convertToLogWriterI18n(), -1);
                        ServerLauncher.Builder builder = new ServerLauncher.Builder().setMemberName(this.getUniqueName()).setRedirectOutput(Boolean.valueOf(true)).setServerPort(Integer.valueOf(freeTCPPort)).set("log-level", "config");
                        this.launcher = builder.build();
                        failure = null;
                        expected = null;
                        try {
                            this.launcher.start();
                            ServerLauncherLocalDUnitTest.fail((String)"ServerLauncher start should have thrown RuntimeException caused by BindException");
                        }
                        catch (RuntimeException e) {
                            expected = e;
                            ServerLauncherLocalDUnitTest.assertNotNull((Object)expected.getMessage());
                        }
                        catch (Throwable e) {
                            ServerLauncherLocalDUnitTest.getLogWriter().error(e);
                            if (failure != null) break block12;
                            failure = e;
                        }
                    }
                    try {
                        ServerLauncherLocalDUnitTest.assertNotNull((Object)expected);
                        Throwable cause = expected.getCause();
                        ServerLauncherLocalDUnitTest.assertNotNull((Object)cause);
                        ServerLauncherLocalDUnitTest.assertTrue((boolean)(cause instanceof BindException));
                    }
                    catch (Throwable e) {
                        ServerLauncherLocalDUnitTest.getLogWriter().error(e);
                        if (failure != null) break block13;
                        failure = e;
                    }
                }
                try {
                    this.pidFile = new File(ProcessType.SERVER.getPidFileName());
                    ServerLauncherLocalDUnitTest.assertFalse((String)("Pid file should not exist: " + this.pidFile), (boolean)this.pidFile.exists());
                    String logFileName = this.getUniqueName() + ".log";
                    ServerLauncherLocalDUnitTest.assertFalse((String)("Log file should not exist: " + logFileName), (boolean)new File(logFileName).exists());
                }
                catch (Throwable e) {
                    ServerLauncherLocalDUnitTest.getLogWriter().error(e);
                    if (failure != null) break block14;
                    failure = e;
                }
            }
            ServerLauncher.ServerState status = null;
            try {
                status = this.launcher.stop();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.waitForFileToDelete(this.pidFile);
                ServerLauncherLocalDUnitTest.assertEquals((Object)this.getExpectedStopStatusForNotRunning(), (Object)status.getStatus());
            }
            catch (Throwable e) {
                ServerLauncherLocalDUnitTest.getLogWriter().error(e);
                if (failure != null) break block15;
                failure = e;
            }
        }
        if (failure != null) {
            throw failure;
        }
    }

    public void testStatusUsingPid() throws Throwable {
        Throwable failure;
        block10: {
            ServerLauncher pidLauncher;
            block9: {
                ServerLauncher.Builder builder = new ServerLauncher.Builder().setDisableDefaultServer(Boolean.valueOf(true)).setMemberName(this.getUniqueName()).setRedirectOutput(Boolean.valueOf(true)).set("log-level", "config");
                ServerLauncherLocalDUnitTest.assertFalse((boolean)builder.getForce());
                this.launcher = builder.build();
                ServerLauncherLocalDUnitTest.assertFalse((boolean)this.launcher.isForcing());
                failure = null;
                pidLauncher = null;
                try {
                    this.launcher.start();
                    this.waitForServerToStart(this.launcher);
                    this.pidFile = new File(ProcessType.SERVER.getPidFileName());
                    ServerLauncherLocalDUnitTest.assertTrue((boolean)this.pidFile.exists());
                    int pid = this.readPid(this.pidFile);
                    ServerLauncherLocalDUnitTest.assertTrue((pid > 0 ? 1 : 0) != 0);
                    ServerLauncherLocalDUnitTest.assertEquals((int)ProcessUtils.identifyPid(), (int)pid);
                    pidLauncher = new ServerLauncher.Builder().setPid(Integer.valueOf(pid)).build();
                    ServerLauncherLocalDUnitTest.assertNotNull((Object)pidLauncher);
                    ServerLauncherLocalDUnitTest.assertFalse((boolean)pidLauncher.isRunning());
                    ServerLauncher.ServerState actualStatus = pidLauncher.status();
                    ServerLauncherLocalDUnitTest.assertNotNull((Object)actualStatus);
                    ServerLauncherLocalDUnitTest.assertEquals((Object)AbstractLauncher.Status.ONLINE, (Object)actualStatus.getStatus());
                    ServerLauncherLocalDUnitTest.assertEquals((int)pid, (int)actualStatus.getPid());
                    ServerLauncherLocalDUnitTest.assertTrue((actualStatus.getUptime() > 0L ? 1 : 0) != 0);
                    ServerLauncherLocalDUnitTest.assertEquals((String)new File(System.getProperty("user.dir")).getCanonicalPath(), (String)actualStatus.getWorkingDirectory());
                    ServerLauncherLocalDUnitTest.assertEquals((String)ManagementFactory.getRuntimeMXBean().getClassPath(), (String)actualStatus.getClasspath());
                    ServerLauncherLocalDUnitTest.assertEquals((String)GemFireVersion.getGemFireVersion(), (String)actualStatus.getGemFireVersion());
                    ServerLauncherLocalDUnitTest.assertEquals((String)System.getProperty("java.version"), (String)actualStatus.getJavaVersion());
                    ServerLauncherLocalDUnitTest.assertEquals((String)(new File(System.getProperty("user.dir")).getCanonicalPath() + File.separator + this.getUniqueName() + ".log"), (String)actualStatus.getLogFile());
                    ServerLauncherLocalDUnitTest.assertEquals((String)SocketCreator.getLocalHost().getCanonicalHostName(), (String)actualStatus.getHost());
                    ServerLauncherLocalDUnitTest.assertEquals((String)this.getUniqueName(), (String)actualStatus.getMemberName());
                }
                catch (Throwable e) {
                    ServerLauncherLocalDUnitTest.getLogWriter().error(e);
                    if (failure != null) break block9;
                    failure = e;
                }
            }
            if (pidLauncher == null) {
                try {
                    ServerLauncherLocalDUnitTest.assertEquals((Object)AbstractLauncher.Status.STOPPED, (Object)this.launcher.stop().getStatus());
                    this.waitForFileToDelete(this.pidFile);
                }
                catch (Throwable e) {
                    ServerLauncherLocalDUnitTest.getLogWriter().error(e);
                    if (failure == null) {
                        failure = e;
                    }
                    break block10;
                }
            }
            try {
                ServerLauncherLocalDUnitTest.assertEquals((Object)AbstractLauncher.Status.STOPPED, (Object)pidLauncher.stop().getStatus());
                this.waitForFileToDelete(this.pidFile);
            }
            catch (Throwable e) {
                ServerLauncherLocalDUnitTest.getLogWriter().error(e);
                if (failure != null) break block10;
                failure = e;
            }
        }
        if (failure != null) {
            throw failure;
        }
    }

    public void testStatusUsingWorkingDirectory() throws Throwable {
        Throwable failure;
        block10: {
            ServerLauncher dirLauncher;
            block9: {
                ServerLauncher.Builder builder = new ServerLauncher.Builder().setDisableDefaultServer(Boolean.valueOf(true)).setMemberName(this.getUniqueName()).setRedirectOutput(Boolean.valueOf(true)).set("log-level", "config");
                ServerLauncherLocalDUnitTest.assertFalse((boolean)builder.getForce());
                this.launcher = builder.build();
                ServerLauncherLocalDUnitTest.assertFalse((boolean)this.launcher.isForcing());
                failure = null;
                dirLauncher = null;
                try {
                    this.launcher.start();
                    this.waitForServerToStart(this.launcher);
                    this.pidFile = new File(ProcessType.SERVER.getPidFileName());
                    ServerLauncherLocalDUnitTest.assertTrue((boolean)this.pidFile.exists());
                    int pid = this.readPid(this.pidFile);
                    ServerLauncherLocalDUnitTest.assertTrue((pid > 0 ? 1 : 0) != 0);
                    ServerLauncherLocalDUnitTest.assertEquals((int)ProcessUtils.identifyPid(), (int)pid);
                    String workingDir = new File(System.getProperty("user.dir")).getCanonicalPath();
                    dirLauncher = new ServerLauncher.Builder().setWorkingDirectory(workingDir).build();
                    ServerLauncherLocalDUnitTest.assertNotNull((Object)dirLauncher);
                    ServerLauncherLocalDUnitTest.assertFalse((boolean)dirLauncher.isRunning());
                    ServerLauncher.ServerState actualStatus = dirLauncher.status();
                    ServerLauncherLocalDUnitTest.assertNotNull((Object)actualStatus);
                    ServerLauncherLocalDUnitTest.assertEquals((Object)AbstractLauncher.Status.ONLINE, (Object)actualStatus.getStatus());
                    ServerLauncherLocalDUnitTest.assertEquals((int)pid, (int)actualStatus.getPid());
                    ServerLauncherLocalDUnitTest.assertTrue((actualStatus.getUptime() > 0L ? 1 : 0) != 0);
                    ServerLauncherLocalDUnitTest.assertEquals((String)new File(System.getProperty("user.dir")).getCanonicalPath(), (String)actualStatus.getWorkingDirectory());
                    ServerLauncherLocalDUnitTest.assertEquals((String)ManagementFactory.getRuntimeMXBean().getClassPath(), (String)actualStatus.getClasspath());
                    ServerLauncherLocalDUnitTest.assertEquals((String)GemFireVersion.getGemFireVersion(), (String)actualStatus.getGemFireVersion());
                    ServerLauncherLocalDUnitTest.assertEquals((String)System.getProperty("java.version"), (String)actualStatus.getJavaVersion());
                    ServerLauncherLocalDUnitTest.assertEquals((String)(new File(System.getProperty("user.dir")).getCanonicalPath() + File.separator + this.getUniqueName() + ".log"), (String)actualStatus.getLogFile());
                    ServerLauncherLocalDUnitTest.assertEquals((String)SocketCreator.getLocalHost().getCanonicalHostName(), (String)actualStatus.getHost());
                    ServerLauncherLocalDUnitTest.assertEquals((String)this.getUniqueName(), (String)actualStatus.getMemberName());
                }
                catch (Throwable e) {
                    ServerLauncherLocalDUnitTest.getLogWriter().error(e);
                    if (failure != null) break block9;
                    failure = e;
                }
            }
            if (dirLauncher == null) {
                try {
                    ServerLauncherLocalDUnitTest.assertEquals((Object)AbstractLauncher.Status.STOPPED, (Object)this.launcher.stop().getStatus());
                    this.waitForFileToDelete(this.pidFile);
                }
                catch (Throwable e) {
                    ServerLauncherLocalDUnitTest.getLogWriter().error(e);
                    if (failure == null) {
                        failure = e;
                    }
                    break block10;
                }
            }
            try {
                ServerLauncherLocalDUnitTest.assertEquals((Object)AbstractLauncher.Status.STOPPED, (Object)dirLauncher.stop().getStatus());
                this.waitForFileToDelete(this.pidFile);
            }
            catch (Throwable e) {
                ServerLauncherLocalDUnitTest.getLogWriter().error(e);
                if (failure != null) break block10;
                failure = e;
            }
        }
        if (failure != null) {
            throw failure;
        }
    }

    public void testStopUsingPid() throws Throwable {
        Throwable failure;
        block8: {
            block7: {
                ServerLauncher.Builder builder = new ServerLauncher.Builder().setDisableDefaultServer(Boolean.valueOf(true)).setMemberName(this.getUniqueName()).setRedirectOutput(Boolean.valueOf(true)).set("log-level", "config");
                ServerLauncherLocalDUnitTest.assertFalse((boolean)builder.getForce());
                this.launcher = builder.build();
                ServerLauncherLocalDUnitTest.assertFalse((boolean)this.launcher.isForcing());
                failure = null;
                ServerLauncher pidLauncher = null;
                try {
                    this.launcher.start();
                    this.waitForServerToStart(this.launcher);
                    this.pidFile = new File(ProcessType.SERVER.getPidFileName());
                    ServerLauncherLocalDUnitTest.assertTrue((boolean)this.pidFile.exists());
                    int pid = this.readPid(this.pidFile);
                    ServerLauncherLocalDUnitTest.assertTrue((pid > 0 ? 1 : 0) != 0);
                    ServerLauncherLocalDUnitTest.assertEquals((int)ProcessUtils.identifyPid(), (int)pid);
                    pidLauncher = new ServerLauncher.Builder().setPid(Integer.valueOf(pid)).build();
                    ServerLauncherLocalDUnitTest.assertNotNull((Object)pidLauncher);
                    ServerLauncherLocalDUnitTest.assertFalse((boolean)pidLauncher.isRunning());
                    ServerLauncher.ServerState serverState = pidLauncher.stop();
                    ServerLauncherLocalDUnitTest.assertNotNull((Object)serverState);
                    ServerLauncherLocalDUnitTest.assertEquals((Object)AbstractLauncher.Status.STOPPED, (Object)serverState.getStatus());
                }
                catch (Throwable e) {
                    ServerLauncherLocalDUnitTest.getLogWriter().error(e);
                    if (failure != null) break block7;
                    failure = e;
                }
            }
            try {
                this.launcher.stop();
            }
            catch (Throwable e) {
                // empty catch block
            }
            try {
                this.waitForFileToDelete(this.pidFile);
            }
            catch (Throwable e) {
                ServerLauncherLocalDUnitTest.getLogWriter().error(e);
                if (failure != null) break block8;
                failure = e;
            }
        }
        if (failure != null) {
            throw failure;
        }
    }

    public void testStopUsingWorkingDirectory() throws Throwable {
        Throwable failure;
        block8: {
            block7: {
                ServerLauncher.Builder builder = new ServerLauncher.Builder().setDisableDefaultServer(Boolean.valueOf(true)).setMemberName(this.getUniqueName()).setRedirectOutput(Boolean.valueOf(true)).set("log-level", "config");
                ServerLauncherLocalDUnitTest.assertFalse((boolean)builder.getForce());
                this.launcher = builder.build();
                ServerLauncherLocalDUnitTest.assertFalse((boolean)this.launcher.isForcing());
                failure = null;
                ServerLauncher dirLauncher = null;
                try {
                    this.launcher.start();
                    this.waitForServerToStart(this.launcher);
                    this.pidFile = new File(ProcessType.SERVER.getPidFileName());
                    ServerLauncherLocalDUnitTest.assertTrue((boolean)this.pidFile.exists());
                    int pid = this.readPid(this.pidFile);
                    ServerLauncherLocalDUnitTest.assertTrue((pid > 0 ? 1 : 0) != 0);
                    ServerLauncherLocalDUnitTest.assertEquals((int)ProcessUtils.identifyPid(), (int)pid);
                    String workingDir = new File(System.getProperty("user.dir")).getCanonicalPath();
                    dirLauncher = new ServerLauncher.Builder().setWorkingDirectory(workingDir).build();
                    ServerLauncherLocalDUnitTest.assertNotNull((Object)dirLauncher);
                    ServerLauncherLocalDUnitTest.assertFalse((boolean)dirLauncher.isRunning());
                    ServerLauncher.ServerState serverState = dirLauncher.stop();
                    ServerLauncherLocalDUnitTest.assertNotNull((Object)serverState);
                    ServerLauncherLocalDUnitTest.assertEquals((Object)AbstractLauncher.Status.STOPPED, (Object)serverState.getStatus());
                }
                catch (Throwable e) {
                    ServerLauncherLocalDUnitTest.getLogWriter().error(e);
                    if (failure != null) break block7;
                    failure = e;
                }
            }
            try {
                this.launcher.stop();
            }
            catch (Throwable e) {
                // empty catch block
            }
            try {
                this.waitForFileToDelete(this.pidFile);
            }
            catch (Throwable e) {
                ServerLauncherLocalDUnitTest.getLogWriter().error(e);
                if (failure != null) break block8;
                failure = e;
            }
        }
        if (failure != null) {
            throw failure;
        }
    }
}

