/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed;

import com.gemstone.gemfire.IncompatibleSystemException;
import com.gemstone.gemfire.distributed.Role;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;

public class DistributedMemberTest
extends DistributedTestCase {
    public DistributedMemberTest(String name) {
        super(name);
    }

    protected void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            DistributedMemberTest.fail((String)"interrupted");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDefaults() {
        Properties config = new Properties();
        config.setProperty("mcast-port", "0");
        config.setProperty("locators", "");
        config.setProperty("roles", "");
        config.setProperty("groups", "");
        config.setProperty("name", "");
        InternalDistributedSystem system = this.getSystem(config);
        try {
            DistributedMemberTest.assertTrue((boolean)system.getConfig().getRoles().equals(""));
            DistributedMemberTest.assertTrue((boolean)system.getConfig().getGroups().equals(""));
            DistributedMemberTest.assertTrue((boolean)system.getConfig().getName().equals(""));
            DM dm = system.getDistributionManager();
            InternalDistributedMember member = dm.getDistributionManagerId();
            Set roles = member.getRoles();
            DistributedMemberTest.assertEquals((int)0, (int)roles.size());
            DistributedMemberTest.assertEquals((String)"", (String)member.getName());
            DistributedMemberTest.assertEquals(Collections.emptyList(), (Object)member.getGroups());
        }
        finally {
            system.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNonDefaultName() {
        Properties config = new Properties();
        config.setProperty("mcast-port", "0");
        config.setProperty("locators", "");
        config.setProperty("name", "nondefault");
        InternalDistributedSystem system = this.getSystem(config);
        try {
            DistributedMemberTest.assertEquals((String)"nondefault", (String)system.getConfig().getName());
            DM dm = system.getDistributionManager();
            InternalDistributedMember member = dm.getDistributionManagerId();
            DistributedMemberTest.assertEquals((String)"nondefault", (String)member.getName());
        }
        finally {
            system.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRolesInOneVM() {
        String rolesProp = "A,B,C";
        String groupsProp = "D,E,F,G";
        List<String> bothList = Arrays.asList("A", "B", "C", "D", "E", "F", "G");
        Properties config = new Properties();
        config.setProperty("mcast-port", "0");
        config.setProperty("locators", "");
        config.setProperty("roles", "A,B,C");
        config.setProperty("groups", "D,E,F,G");
        InternalDistributedSystem system = this.getSystem(config);
        try {
            DistributedMemberTest.assertEquals((String)"A,B,C", (String)system.getConfig().getRoles());
            DistributedMemberTest.assertEquals((String)"D,E,F,G", (String)system.getConfig().getGroups());
            DM dm = system.getDistributionManager();
            InternalDistributedMember member = dm.getDistributionManagerId();
            Set roles = member.getRoles();
            DistributedMemberTest.assertEquals((int)bothList.size(), (int)roles.size());
            for (Role role : roles) {
                DistributedMemberTest.assertTrue((boolean)bothList.contains(role.getName()));
            }
            DistributedMemberTest.assertEquals(bothList, (Object)member.getGroups());
        }
        finally {
            system.disconnect();
        }
    }

    public void testTwoMembersSameName() {
        DistributedMemberTest.disconnectFromDS();
        Host.getHost(0).getVM(0).invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Properties config = new Properties();
                config.setProperty("name", "name0");
                DistributedMemberTest.this.getSystem(config);
            }
        });
        Host.getHost(0).getVM(1).invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Properties config = new Properties();
                config.setProperty("name", "name1");
                DistributedMemberTest.this.getSystem(config);
            }
        });
        Host.getHost(0).getVM(2).invoke(new SerializableRunnable(){

            @Override
            public void run() {
                Properties config = new Properties();
                config.setProperty("name", "name0");
                try {
                    DistributedMemberTest.this.getSystem(config);
                    TestCase.fail((String)"expected IncompatibleSystemException");
                }
                catch (IncompatibleSystemException incompatibleSystemException) {
                    // empty catch block
                }
            }
        });
    }

    public void testRolesInAllVMs() {
        int vm;
        DistributedMemberTest.disconnectAllFromDS();
        final String[] vmRoles = new String[]{"VM_A", "VM_B", "VM_C", "VM_D"};
        int i = 0;
        while (i < vmRoles.length) {
            vm = i++;
            Host.getHost(0).getVM(vm).invoke(new SerializableRunnable(){

                @Override
                public void run() {
                    Properties config = new Properties();
                    config.setProperty("roles", vmRoles[vm]);
                    DistributedMemberTest.this.getSystem(config);
                }
            });
        }
        i = 0;
        while (i < vmRoles.length) {
            vm = i++;
            Host.getHost(0).getVM(vm).invoke(new SerializableRunnable(){

                @Override
                public void run() {
                    InternalDistributedSystem sys = DistributedMemberTest.this.getSystem();
                    TestCase.assertNotNull((Object)sys.getConfig().getRoles());
                    TestCase.assertTrue((boolean)sys.getConfig().getRoles().equals(vmRoles[vm]));
                    DM dm = sys.getDistributionManager();
                    InternalDistributedMember self = dm.getDistributionManagerId();
                    Set myRoles = self.getRoles();
                    TestCase.assertEquals((int)1, (int)myRoles.size());
                    Role myRole = (Role)myRoles.iterator().next();
                    TestCase.assertTrue((boolean)vmRoles[vm].equals(myRole.getName()));
                    Set members = null;
                    for (int i = 1; i <= 3; ++i) {
                        try {
                            members = dm.getOtherNormalDistributionManagerIds();
                            TestCase.assertEquals((int)3, (int)members.size());
                            break;
                        }
                        catch (AssertionFailedError e) {
                            if (i >= 3) {
                                throw e;
                            }
                            DistributedMemberTest.this.sleep(200L);
                            continue;
                        }
                    }
                    for (InternalDistributedMember member : members) {
                        Set roles = member.getRoles();
                        TestCase.assertEquals((int)1, (int)roles.size());
                        for (Role role : roles) {
                            TestCase.assertTrue((!role.getName().equals(myRole.getName()) ? 1 : 0) != 0);
                            boolean foundRole = false;
                            for (int j = 0; j < vmRoles.length; ++j) {
                                if (!vmRoles[j].equals(role.getName())) continue;
                                foundRole = true;
                                break;
                            }
                            TestCase.assertTrue((boolean)foundRole);
                        }
                    }
                }
            });
        }
    }

    private static String makeOddEvenString(int vm) {
        return vm % 2 == 0 ? "EVENS" : "ODDS";
    }

    private static String makeGroupsString(int vm) {
        return "" + vm + ", " + DistributedMemberTest.makeOddEvenString(vm);
    }

    public void testGroupsInAllVMs() {
        int vm;
        DistributedMemberTest.disconnectFromDS();
        int i = 0;
        while (i < 4) {
            vm = i++;
            Host.getHost(0).getVM(vm).invoke(new SerializableRunnable(){

                @Override
                public void run() {
                    Properties config = new Properties();
                    config.setProperty("groups", DistributedMemberTest.makeGroupsString(vm));
                    DistributedMemberTest.this.getSystem(config);
                }
            });
        }
        i = 0;
        while (i < 4) {
            vm = i++;
            Host.getHost(0).getVM(vm).invoke(new SerializableRunnable(){

                @Override
                public void run() {
                    InternalDistributedSystem sys = DistributedMemberTest.this.getSystem();
                    String expectedMyGroup = DistributedMemberTest.makeGroupsString(vm);
                    TestCase.assertEquals((String)expectedMyGroup, (String)sys.getConfig().getGroups());
                    DM dm = sys.getDistributionManager();
                    InternalDistributedMember self = sys.getDistributedMember();
                    List myGroups = self.getGroups();
                    TestCase.assertEquals(Arrays.asList("" + vm, DistributedMemberTest.makeOddEvenString(vm)), (Object)myGroups);
                    Set members = null;
                    for (int i = 1; i <= 3; ++i) {
                        try {
                            members = dm.getOtherNormalDistributionManagerIds();
                            TestCase.assertEquals((int)3, (int)members.size());
                            break;
                        }
                        catch (AssertionFailedError e) {
                            if (i >= 3) {
                                throw e;
                            }
                            DistributedMemberTest.this.sleep(200L);
                            continue;
                        }
                    }
                    Set others = sys.getAllOtherMembers();
                    TestCase.assertEquals((int)4, (int)others.size());
                    others.removeAll(dm.getOtherNormalDistributionManagerIds());
                    TestCase.assertEquals((int)1, (int)others.size());
                    HashSet evens = new HashSet();
                    HashSet odds = new HashSet();
                    boolean isEvens = true;
                    for (String groupName : Arrays.asList("0", "1", "2", "3")) {
                        Set gm = sys.getGroupMembers(groupName);
                        if (isEvens) {
                            evens.addAll(gm);
                        } else {
                            odds.addAll(gm);
                        }
                        boolean bl = isEvens = !isEvens;
                        if (groupName.equals("" + vm)) {
                            TestCase.assertEquals(Collections.singleton(self), (Object)gm);
                            continue;
                        }
                        TestCase.assertEquals((int)1, (int)gm.size());
                        TestCase.assertEquals((String)("members=" + members + " gm=" + gm), (boolean)true, (boolean)members.removeAll(gm));
                    }
                    TestCase.assertEquals(Collections.emptySet(), (Object)members);
                    TestCase.assertEquals(evens, (Object)sys.getGroupMembers("EVENS"));
                    TestCase.assertEquals(odds, (Object)sys.getGroupMembers("ODDS"));
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetId() {
        Properties config = new Properties();
        config.setProperty("mcast-port", "0");
        config.setProperty("locators", "");
        config.setProperty("name", "foobar");
        InternalDistributedSystem system = this.getSystem(config);
        try {
            DM dm = system.getDistributionManager();
            InternalDistributedMember member = dm.getDistributionManagerId();
            DistributedMemberTest.assertEquals((String)member.getId(), (String)system.getMemberId());
            DistributedMemberTest.assertTrue((boolean)member.getId().contains("foobar"));
        }
        finally {
            system.disconnect();
        }
    }
}

