/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache30;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheTransactionManager;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.IllegalTransactionStateException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache30.CacheTestCase;
import dunit.DistributedTestCase;
import dunit.SerializableRunnable;
import hydra.ProcessMgr;
import java.io.File;

public class TXRestrictionsTest
extends CacheTestCase {
    public TXRestrictionsTest(String name) {
        super(name);
    }

    protected RegionAttributes getRegionAttributes() {
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_NO_ACK);
        return factory.create();
    }

    protected RegionAttributes getDiskRegionAttributes() {
        AttributesFactory factory = new AttributesFactory(this.getRegionAttributes());
        File[] diskDirs = new File[]{new File("diskRegionDirs/" + ProcessMgr.getProcessId())};
        diskDirs[0].mkdirs();
        factory.setDiskStoreName(this.getCache().createDiskStoreFactory().setDiskDirs(diskDirs).setTimeInterval(1000L).setQueueSize(0).create("TXRestrictionsTest").getName());
        factory.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
        return factory.create();
    }

    public void testPersistentRestriction() throws Exception {
        CacheTransactionManager txMgr = this.getCache().getCacheTransactionManager();
        final String misConfigRegionName = this.getUniqueName();
        Region misConfigRgn = this.getCache().createRegion(misConfigRegionName, this.getDiskRegionAttributes());
        TXRestrictionsTest.invokeInEveryVM(new SerializableRunnable("testPersistentRestriction: Illegal Region Configuration"){

            @Override
            public void run() {
                try {
                    TXRestrictionsTest.this.getCache().createRegion(misConfigRegionName, TXRestrictionsTest.this.getDiskRegionAttributes());
                }
                catch (CacheException e) {
                    DistributedTestCase.fail("While creating region", e);
                }
            }
        });
        misConfigRgn.put((Object)"misConfigKey", (Object)"oldmisConfigVal");
        txMgr.begin();
        try {
            misConfigRgn.put((Object)"misConfigKey", (Object)"newmisConfigVal");
            TXRestrictionsTest.fail((String)"Expected an UnsupportedOperationException with information about misconfigured regions");
        }
        catch (UnsupportedOperationException expected) {
            this.getSystem().getLogWriter().info("Expected exception: " + expected);
            txMgr.rollback();
        }
        try {
            txMgr.commit();
            TXRestrictionsTest.fail((String)"Expected illegal state exception for transaction after rollback");
        }
        catch (IllegalTransactionStateException expected) {
            this.getSystem().getLogWriter().info("Expected exception: " + (Object)((Object)expected));
        }
        misConfigRgn.destroyRegion();
    }
}

