/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache30;

import com.gemstone.gemfire.CopyHelper;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.CacheEvent;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.CacheLoader;
import com.gemstone.gemfire.cache.CacheLoaderException;
import com.gemstone.gemfire.cache.CacheTransactionManager;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.LoaderHelper;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionShortcut;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.TransactionEvent;
import com.gemstone.gemfire.cache.TransactionListener;
import com.gemstone.gemfire.cache.query.IndexType;
import com.gemstone.gemfire.cache.query.Query;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.query.transaction.Person;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.cache.util.TransactionListenerAdapter;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.cache.TXManagerImpl;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableCallable;
import dunit.VM;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.naming.Context;
import javax.transaction.UserTransaction;
import junit.framework.TestCase;

public class TXOrderDUnitTest
extends CacheTestCase {
    private transient Region r;
    private transient DistributedMember otherId;
    protected transient int invokeCount;
    List expectedKeys;
    int clCount = 0;
    private final int TEST_PUT = 0;
    private final int TEST_INVALIDATE = 1;
    private final int TEST_DESTROY = 2;

    public TXOrderDUnitTest(String name) {
        super(name);
    }

    private VM getOtherVm() {
        Host host = Host.getHost(0);
        return host.getVM(0);
    }

    private void initOtherId() {
        VM vm = this.getOtherVm();
        vm.invoke(new CacheSerializableRunnable("Connect"){

            @Override
            public void run2() throws CacheException {
                TXOrderDUnitTest.this.getCache();
            }
        });
        this.otherId = (DistributedMember)vm.invoke(TXOrderDUnitTest.class, "getVMDistributedMember");
    }

    private void doCommitOtherVm() {
        VM vm = this.getOtherVm();
        vm.invoke(new CacheSerializableRunnable("create root"){

            @Override
            public void run2() throws CacheException {
                AttributesFactory af = new AttributesFactory();
                af.setScope(Scope.DISTRIBUTED_ACK);
                Region r1 = TXOrderDUnitTest.this.createRootRegion("r1", af.create());
                Region r2 = r1.createSubregion("r2", af.create());
                Region r3 = r2.createSubregion("r3", af.create());
                TXManagerImpl ctm = (TXManagerImpl)TXOrderDUnitTest.this.getCache().getCacheTransactionManager();
                ctm.begin();
                r2.put((Object)"b", (Object)"value1");
                r3.put((Object)"c", (Object)"value2");
                r1.put((Object)"a", (Object)"value3");
                r1.put((Object)"a2", (Object)"value4");
                r3.put((Object)"c2", (Object)"value5");
                r2.put((Object)"b2", (Object)"value6");
                ctm.commit();
                TXManagerImpl.waitForPendingCommitForTest();
            }
        });
    }

    public static DistributedMember getVMDistributedMember() {
        return InternalDistributedSystem.getAnyInstance().getDistributedMember();
    }

    Object getCurrentExpectedKey() {
        Object result = this.expectedKeys.get(this.clCount);
        ++this.clCount;
        return result;
    }

    public void testFarSideOrder() throws CacheException {
        this.initOtherId();
        AttributesFactory af = new AttributesFactory();
        af.setDataPolicy(DataPolicy.REPLICATE);
        af.setScope(Scope.DISTRIBUTED_ACK);
        CacheListenerAdapter cl1 = new CacheListenerAdapter(){

            public void afterCreate(EntryEvent e) {
                TestCase.assertEquals((Object)TXOrderDUnitTest.this.getCurrentExpectedKey(), (Object)e.getKey());
            }
        };
        af.addCacheListener((CacheListener)cl1);
        Region r1 = this.createRootRegion("r1", af.create());
        Region r2 = r1.createSubregion("r2", af.create());
        r2.createSubregion("r3", af.create());
        TransactionListenerAdapter tl1 = new TransactionListenerAdapter(){

            public void afterCommit(TransactionEvent e) {
                TestCase.assertEquals((int)6, (int)e.getEvents().size());
                ArrayList<Object> keys = new ArrayList<Object>();
                for (EntryEvent ee : e.getEvents()) {
                    keys.add(ee.getKey());
                    TestCase.assertEquals(null, (Object)ee.getCallbackArgument());
                    TestCase.assertEquals((boolean)true, (boolean)ee.isCallbackArgumentAvailable());
                }
                TestCase.assertEquals((Object)TXOrderDUnitTest.this.expectedKeys, keys);
                TXOrderDUnitTest.this.invokeCount = 1;
            }
        };
        CacheTransactionManager ctm = this.getCache().getCacheTransactionManager();
        ctm.addListener((TransactionListener)tl1);
        this.invokeCount = 0;
        this.clCount = 0;
        this.expectedKeys = Arrays.asList("b", "c", "a", "a2", "c2", "b2");
        this.doCommitOtherVm();
        TXOrderDUnitTest.assertEquals((int)1, (int)this.invokeCount);
        TXOrderDUnitTest.assertEquals((int)6, (int)this.clCount);
    }

    public void _testFarSideOpForLoad() throws Exception {
        Host host = Host.getHost(0);
        VM vm1 = host.getVM(0);
        VM vm2 = host.getVM(1);
        vm1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                AttributesFactory af = new AttributesFactory();
                af.setDataPolicy(DataPolicy.REPLICATE);
                af.setScope(Scope.DISTRIBUTED_ACK);
                CacheListenerAdapter cl1 = new CacheListenerAdapter(){

                    public void afterCreate(EntryEvent e) {
                        TestCase.assertTrue((boolean)e.getOperation().isLocalLoad());
                    }
                };
                af.addCacheListener((CacheListener)cl1);
                CacheLoader cl = new CacheLoader(){

                    public Object load(LoaderHelper helper) throws CacheLoaderException {
                        DistributedTestCase.getLogWriter().info("Loading value:" + helper.getKey() + "_value");
                        return helper.getKey() + "_value";
                    }

                    public void close() {
                    }
                };
                af.setCacheLoader(cl);
                TXOrderDUnitTest.this.createRootRegion("r1", af.create());
                return null;
            }
        });
        vm2.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                AttributesFactory af = new AttributesFactory();
                af.setDataPolicy(DataPolicy.REPLICATE);
                af.setScope(Scope.DISTRIBUTED_ACK);
                CacheListenerAdapter cl1 = new CacheListenerAdapter(){

                    public void afterCreate(EntryEvent e) {
                        DistributedTestCase.getLogWriter().info("op:" + e.getOperation().toString());
                        TestCase.assertTrue((!e.getOperation().isLocalLoad() ? 1 : 0) != 0);
                    }
                };
                af.addCacheListener((CacheListener)cl1);
                TXOrderDUnitTest.this.createRootRegion("r1", af.create());
                return null;
            }
        });
        vm1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region r = TXOrderDUnitTest.this.getRootRegion("r1");
                TXOrderDUnitTest.this.getCache().getCacheTransactionManager().begin();
                r.get((Object)"obj_2");
                TXOrderDUnitTest.this.getCache().getCacheTransactionManager().commit();
                return null;
            }
        });
    }

    public void testInternalRegionNotExposed() {
        Host host = Host.getHost(0);
        VM vm1 = host.getVM(0);
        VM vm2 = host.getVM(1);
        SerializableCallable createRegion = new SerializableCallable(){

            public Object call() throws Exception {
                ExposedRegionTransactionListener tl = new ExposedRegionTransactionListener();
                CacheTransactionManager ctm = TXOrderDUnitTest.this.getCache().getCacheTransactionManager();
                ctm.addListener((TransactionListener)tl);
                ExposedRegionCacheListener cl = new ExposedRegionCacheListener();
                AttributesFactory af = new AttributesFactory();
                PartitionAttributes pa = new PartitionAttributesFactory().setRedundantCopies(1).setTotalNumBuckets(1).create();
                af.setPartitionAttributes(pa);
                af.addCacheListener((CacheListener)cl);
                Region pr = TXOrderDUnitTest.this.createRootRegion("testTxEventForRegion", af.create());
                return null;
            }
        };
        vm1.invoke(createRegion);
        vm2.invoke(createRegion);
        vm1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region pr = TXOrderDUnitTest.this.getRootRegion("testTxEventForRegion");
                CacheTransactionManager ctm = TXOrderDUnitTest.this.getCache().getCacheTransactionManager();
                pr.put((Object)2, (Object)"tw");
                pr.put((Object)3, (Object)"three");
                pr.put((Object)4, (Object)"four");
                ctm.begin();
                pr.put((Object)1, (Object)"one");
                pr.put((Object)2, (Object)"two");
                pr.invalidate((Object)3);
                pr.destroy((Object)4);
                ctm.commit();
                return null;
            }
        });
        SerializableCallable verifyListener = new SerializableCallable(){

            public Object call() throws Exception {
                Region pr = TXOrderDUnitTest.this.getRootRegion("testTxEventForRegion");
                CacheTransactionManager ctm = TXOrderDUnitTest.this.getCache().getCacheTransactionManager();
                ExposedRegionTransactionListener tl = (ExposedRegionTransactionListener)ctm.getListeners()[0];
                ExposedRegionCacheListener cl = (ExposedRegionCacheListener)pr.getAttributes().getCacheListeners()[0];
                TestCase.assertFalse((boolean)tl.exceptionOccurred);
                TestCase.assertFalse((boolean)cl.exceptionOccurred);
                return null;
            }
        };
        vm1.invoke(verifyListener);
        vm2.invoke(verifyListener);
    }

    public void testFarSideIndexOnPut() throws Exception {
        this.doTest(0);
    }

    public void testFarSideIndexOnInvalidate() throws Exception {
        this.doTest(1);
    }

    public void testFarSideIndexOnDestroy() throws Exception {
        this.doTest(2);
    }

    private void doTest(final int op) throws Exception {
        Host host = Host.getHost(0);
        VM vm1 = host.getVM(0);
        VM vm2 = host.getVM(1);
        SerializableCallable createRegionAndIndex = new SerializableCallable(){

            public Object call() throws Exception {
                AttributesFactory af = new AttributesFactory();
                af.setDataPolicy(DataPolicy.REPLICATE);
                af.setScope(Scope.DISTRIBUTED_ACK);
                Region region = TXOrderDUnitTest.this.createRootRegion("sample", af.create());
                QueryService qs = TXOrderDUnitTest.this.getCache().getQueryService();
                qs.createIndex("foo", IndexType.FUNCTIONAL, "age", "/sample");
                return null;
            }
        };
        vm1.invoke(createRegionAndIndex);
        vm2.invoke(createRegionAndIndex);
        vm1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Context ctx = TXOrderDUnitTest.this.getCache().getJNDIContext();
                UserTransaction utx = (UserTransaction)ctx.lookup("java:/UserTransaction");
                Region region = TXOrderDUnitTest.this.getRootRegion("sample");
                Integer x = new Integer(0);
                utx.begin();
                region.create((Object)x, (Object)new Person("xyz", 45));
                utx.commit();
                QueryService qs = TXOrderDUnitTest.this.getCache().getQueryService();
                Query q = qs.newQuery("select * from /sample where age < 50");
                TestCase.assertEquals((int)1, (int)((SelectResults)q.execute()).size());
                Person dsample = (Person)CopyHelper.copy((Object)region.get((Object)x));
                dsample.setAge(55);
                utx.begin();
                switch (op) {
                    case 0: {
                        region.put((Object)x, (Object)dsample);
                        break;
                    }
                    case 1: {
                        region.invalidate((Object)x);
                        break;
                    }
                    case 2: {
                        region.destroy((Object)x);
                        break;
                    }
                    default: {
                        TestCase.fail((String)"unknown op");
                    }
                }
                utx.commit();
                TestCase.assertEquals((int)0, (int)((SelectResults)q.execute()).size());
                TXManagerImpl.waitForPendingCommitForTest();
                return null;
            }
        });
        vm2.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                QueryService qs = TXOrderDUnitTest.this.getCache().getQueryService();
                Query q = qs.newQuery("select * from /sample where age < 50");
                TestCase.assertEquals((int)0, (int)((SelectResults)q.execute()).size());
                return null;
            }
        });
    }

    public void testBug43353() {
        Host host = Host.getHost(0);
        VM vm1 = host.getVM(0);
        VM vm2 = host.getVM(1);
        SerializableCallable createRegion = new SerializableCallable(){

            public Object call() throws Exception {
                TXOrderDUnitTest.this.getCache().createRegionFactory(RegionShortcut.REPLICATE).create(DistributedTestCase.testName);
                return null;
            }
        };
        vm1.invoke(createRegion);
        vm2.invoke(createRegion);
        vm1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region r = TXOrderDUnitTest.this.getCache().getRegion(DistributedTestCase.testName);
                r.put((Object)"ikey", (Object)"value");
                TXOrderDUnitTest.this.getCache().getCacheTransactionManager().begin();
                r.put((Object)"key1", (Object)new byte[20]);
                r.invalidate((Object)"ikey");
                TXOrderDUnitTest.this.getCache().getCacheTransactionManager().commit();
                return null;
            }
        });
        vm2.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region r = TXOrderDUnitTest.this.getCache().getRegion(DistributedTestCase.testName);
                Object v = r.get((Object)"key1");
                TestCase.assertNotNull((Object)v);
                TestCase.assertTrue((boolean)(v instanceof byte[]));
                TestCase.assertNull((Object)r.get((Object)"ikey"));
                return null;
            }
        });
    }

    class ExposedRegionCacheListener
    extends CacheListenerAdapter {
        private boolean exceptionOccurred = false;

        ExposedRegionCacheListener() {
        }

        public void afterCreate(EntryEvent event) {
            this.verifyRegion(event);
        }

        public void afterUpdate(EntryEvent event) {
            this.verifyRegion(event);
        }

        private void verifyRegion(EntryEvent event) {
            if (!"/testTxEventForRegion".equals(event.getRegion().getFullPath())) {
                this.exceptionOccurred = true;
            }
        }
    }

    class ExposedRegionTransactionListener
    extends TransactionListenerAdapter {
        private boolean exceptionOccurred = false;

        ExposedRegionTransactionListener() {
        }

        public void afterCommit(TransactionEvent event) {
            List events = event.getEvents();
            for (CacheEvent e : events) {
                if ("/testTxEventForRegion".equals(e.getRegion().getFullPath())) continue;
                this.exceptionOccurred = true;
            }
        }
    }
}

