/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache30;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheLoader;
import com.gemstone.gemfire.cache.CacheTransactionManager;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.DiskAccessException;
import com.gemstone.gemfire.cache.LoaderHelper;
import com.gemstone.gemfire.cache.MirrorType;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.cache.TransactionInDoubtException;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.distributed.internal.membership.jgroup.MembershipManagerHelper;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.InternalRegionArguments;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.TXManagerImpl;
import com.gemstone.gemfire.internal.cache.TXState;
import com.gemstone.gemfire.internal.cache.TXStateInterface;
import com.gemstone.gemfire.internal.cache.TXStateProxy;
import com.gemstone.gemfire.internal.cache.TransactionObserver;
import com.gemstone.gemfire.internal.cache.TransactionObserverAdapter;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import junit.framework.TestCase;

public class TXDistributedTest
extends CacheTestCase {
    static HashSet preTXSystemIds;
    static HashSet postTXSystemIds;
    static Serializable txHostId;
    public static final String TROUBLE_KEY = "GoBoom";

    public TXDistributedTest(String name) {
        super(name);
    }

    protected RegionAttributes getRegionAttributes() {
        return this.getRegionAttributes(Scope.DISTRIBUTED_ACK);
    }

    protected RegionAttributes getRegionAttributes(Scope scope) {
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(scope);
        if (scope.isDistributedAck()) {
            factory.setEarlyAck(false);
        }
        return factory.create();
    }

    public void testInternalCallbacks() throws Exception {
        int i;
        int i2;
        int i3;
        CacheTransactionManager txMgr = this.getCache().getCacheTransactionManager();
        final String rgnName1 = this.getUniqueName() + "_1";
        final String rgnName2 = this.getUniqueName() + "_2";
        final String rgnName3 = this.getUniqueName() + "_3";
        Region rgn1 = this.getCache().createRegionFactory(this.getRegionAttributes()).create(rgnName1);
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        SerializableRunnable createRgn = new SerializableRunnable("testInternalCallbacks: initial configuration"){

            @Override
            public void run() {
                try {
                    Region rgn1a = TXDistributedTest.this.getCache().createRegionFactory(TXDistributedTest.this.getRegionAttributes()).create(rgnName1);
                    Region rgn2 = TXDistributedTest.this.getCache().createRegionFactory(TXDistributedTest.this.getRegionAttributes()).create(rgnName2);
                    Region rgn3 = TXDistributedTest.this.getCache().createRegionFactory(TXDistributedTest.this.getRegionAttributes(Scope.DISTRIBUTED_NO_ACK)).create(rgnName3);
                    rgn1a.create((Object)"key", null);
                    rgn2.create((Object)"key", null);
                    rgn3.create((Object)"key", null);
                }
                catch (CacheException e) {
                    DistributedTestCase.fail("While creating region", e);
                }
            }
        };
        vm0.invoke(createRgn);
        vm1.invoke(createRgn);
        txMgr.begin();
        rgn1.put((Object)"key", (Object)"value0");
        txMgr.commit();
        SerializableRunnable checkRgn1 = new SerializableRunnable("testInternalCallbacks: check rgn1 valus"){

            @Override
            public void run() {
                Region rgn1a = TXDistributedTest.this.getCache().getRegion(rgnName1);
                TestCase.assertNotNull((Object)rgn1a);
                TestCase.assertEquals((Object)"value0", (Object)rgn1a.getEntry((Object)"key").getValue());
            }
        };
        TXManagerImpl.waitForPendingCommitForTest();
        vm0.invoke(checkRgn1);
        vm1.invoke(checkRgn1);
        byte[] cbSensors = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0};
        txMgr.begin();
        TXDistributedTest.setInternalCallbacks(((TXManagerImpl)txMgr).getTXState(), cbSensors);
        rgn1.put((Object)"key", (Object)"value1");
        txMgr.commit();
        for (i3 = 5; i3 >= 0; --i3) {
            TXDistributedTest.assertEquals((String)("Internal callback " + i3 + " was not called the expected number of times!"), (byte)1, (byte)cbSensors[i3]);
        }
        for (i3 = 7; i3 > 5; --i3) {
            TXDistributedTest.assertEquals((String)("Internal \"during\" callback " + i3 + " invoked an unexpected number of times!"), (byte)0, (byte)cbSensors[i3]);
        }
        SerializableRunnable checkRgn1Again = new SerializableRunnable("testInternalCallbacks: validate remote values"){

            @Override
            public void run() {
                Region rgn1a = TXDistributedTest.this.getCache().getRegion(rgnName1);
                TestCase.assertNotNull((Object)rgn1a);
                TestCase.assertEquals((Object)"value1", (Object)rgn1a.getEntry((Object)"key").getValue());
            }
        };
        TXManagerImpl.waitForPendingCommitForTest();
        vm0.invoke(checkRgn1Again);
        vm1.invoke(checkRgn1Again);
        Region rgn2 = this.getCache().createRegion(rgnName2, this.getRegionAttributes());
        txMgr.begin();
        rgn1.put((Object)"key", (Object)"value2");
        rgn2.put((Object)"key", (Object)"value2");
        txMgr.commit();
        TXManagerImpl.waitForPendingCommitForTest();
        SerializableRunnable checkRgn12 = new SerializableRunnable("testInternalCallbacks: check rgn1 valus"){

            @Override
            public void run() {
                Region rgn1a = TXDistributedTest.this.getCache().getRegion(rgnName1);
                TestCase.assertNotNull((Object)rgn1a);
                TestCase.assertEquals((Object)"value2", (Object)rgn1a.getEntry((Object)"key").getValue());
                Region rgn2a = TXDistributedTest.this.getCache().getRegion(rgnName2);
                TestCase.assertNotNull((Object)rgn2a);
                TestCase.assertEquals((Object)"value2", (Object)rgn2a.getEntry((Object)"key").getValue());
            }
        };
        TXManagerImpl.waitForPendingCommitForTest();
        vm0.invoke(checkRgn12);
        vm1.invoke(checkRgn12);
        byte[] cbSensors2 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0};
        txMgr.begin();
        TXDistributedTest.setInternalCallbacks(((TXManagerImpl)txMgr).getTXState(), cbSensors2);
        rgn1.put((Object)"key", (Object)"value3");
        rgn2.put((Object)"key", (Object)"value3");
        txMgr.commit();
        for (i2 = 5; i2 >= 0; --i2) {
            TXDistributedTest.assertEquals((String)("Internal callback " + i2 + " was not called the expected number of times!"), (byte)1, (byte)cbSensors2[i2]);
        }
        for (i2 = 7; i2 > 5; --i2) {
            TXDistributedTest.assertEquals((String)("Internal \"during\" callback " + i2 + " invoked an unexpected number of times!"), (byte)0, (byte)cbSensors2[i2]);
        }
        SerializableRunnable checkRgn12Again = new SerializableRunnable("testInternalCallbacks: validate both regions remote values"){

            @Override
            public void run() {
                Region rgn1a = TXDistributedTest.this.getCache().getRegion(rgnName1);
                TestCase.assertNotNull((Object)rgn1a);
                TestCase.assertEquals((Object)"value3", (Object)rgn1a.getEntry((Object)"key").getValue());
                Region rgn2a = TXDistributedTest.this.getCache().getRegion(rgnName2);
                TestCase.assertNotNull((Object)rgn2a);
                TestCase.assertEquals((Object)"value3", (Object)rgn2a.getEntry((Object)"key").getValue());
            }
        };
        TXManagerImpl.waitForPendingCommitForTest();
        vm0.invoke(checkRgn12Again);
        vm1.invoke(checkRgn12Again);
        Region rgn3 = this.getCache().createRegion(rgnName3, this.getRegionAttributes(Scope.DISTRIBUTED_NO_ACK));
        txMgr.begin();
        rgn1.put((Object)"key", (Object)"value4");
        rgn2.put((Object)"key", (Object)"value4");
        rgn3.put((Object)"key", (Object)"value4");
        txMgr.commit();
        SerializableRunnable checkRgn123 = new SerializableRunnable("testInternalCallbacks: check rgn1 valus"){

            @Override
            public void run() {
                Region rgn1a = TXDistributedTest.this.getCache().getRegion(rgnName1);
                TestCase.assertNotNull((Object)rgn1a);
                TestCase.assertEquals((Object)"value4", (Object)rgn1a.getEntry((Object)"key").getValue());
                Region rgn2a = TXDistributedTest.this.getCache().getRegion(rgnName2);
                TestCase.assertNotNull((Object)rgn2a);
                TestCase.assertEquals((Object)"value4", (Object)rgn2a.getEntry((Object)"key").getValue());
                Region rgn3a = TXDistributedTest.this.getCache().getRegion(rgnName3);
                TestCase.assertNotNull((Object)rgn3a);
                TestCase.assertEquals((Object)"value4", (Object)rgn3a.getEntry((Object)"key").getValue());
            }
        };
        TXManagerImpl.waitForPendingCommitForTest();
        vm0.invoke(checkRgn123);
        vm1.invoke(checkRgn123);
        byte[] cbSensors3 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0};
        txMgr.begin();
        TXDistributedTest.setInternalCallbacks(((TXManagerImpl)txMgr).getTXState(), cbSensors3);
        rgn1.put((Object)"key", (Object)"value5");
        rgn2.put((Object)"key", (Object)"value5");
        rgn3.put((Object)"key", (Object)"value5");
        txMgr.commit();
        for (i = 5; i >= 0; --i) {
            TXDistributedTest.assertEquals((String)("Internal callback " + i + " was not called the expected number of times!"), (byte)1, (byte)cbSensors3[i]);
        }
        for (i = 7; i > 5; --i) {
            TXDistributedTest.assertEquals((String)("Internal \"during\" callback " + i + " invoked an unexpected number of times!"), (byte)0, (byte)cbSensors3[i]);
        }
        SerializableRunnable checkRgn123Again = new SerializableRunnable("testInternalCallbacks: validate both regions remote values"){

            @Override
            public void run() {
                Region rgn1a = TXDistributedTest.this.getCache().getRegion(rgnName1);
                TestCase.assertNotNull((Object)rgn1a);
                TestCase.assertEquals((Object)"value5", (Object)rgn1a.getEntry((Object)"key").getValue());
                Region rgn2a = TXDistributedTest.this.getCache().getRegion(rgnName2);
                TestCase.assertNotNull((Object)rgn2a);
                TestCase.assertEquals((Object)"value5", (Object)rgn2a.getEntry((Object)"key").getValue());
                Region rgn3a = TXDistributedTest.this.getCache().getRegion(rgnName3);
                TestCase.assertNotNull((Object)rgn3a);
                TestCase.assertEquals((Object)"value5", (Object)rgn3a.getEntry((Object)"key").getValue());
            }
        };
        TXManagerImpl.waitForPendingCommitForTest();
        vm0.invoke(checkRgn123Again);
        vm1.invoke(checkRgn123Again);
        rgn1.destroyRegion();
        rgn2.destroyRegion();
    }

    static final void setInternalCallbacks(TXStateInterface txp, final byte[] cbSensors) {
        TXDistributedTest.assertEquals((int)9, (int)cbSensors.length);
        txp.setObserver((TransactionObserver)new TransactionObserverAdapter(){

            public void afterApplyChanges(TXStateProxy tx) {
                cbSensors[0] = (byte)(cbSensors[0] + 1);
            }

            public void afterReleaseLocalLocks(TXStateProxy tx) {
                cbSensors[1] = (byte)(cbSensors[1] + 1);
            }

            public void beforeSend(TXStateProxy tx, boolean rollback) {
                if (rollback) {
                    cbSensors[6] = (byte)(cbSensors[6] + 1);
                } else {
                    cbSensors[2] = (byte)(cbSensors[2] + 1);
                }
            }

            public void afterSend(TXStateProxy tx, boolean rollback) {
                if (rollback) {
                    cbSensors[7] = (byte)(cbSensors[7] + 1);
                } else {
                    cbSensors[3] = (byte)(cbSensors[3] + 1);
                }
            }

            public void duringIndividualCommit(TXStateProxy tx, Object callbackArg) {
                cbSensors[4] = (byte)(cbSensors[4] + 1);
            }

            public void afterIndividualCommit(TXStateProxy tx, Object callbackArg) {
                cbSensors[5] = (byte)(cbSensors[5] + 1);
            }
        });
    }

    public void testDACKLoadedMessage() throws Exception {
        TXManagerImpl txMgr = (TXManagerImpl)this.getCache().getCacheTransactionManager();
        final String rgnName = this.getUniqueName();
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setEarlyAck(false);
        factory.setCacheLoader(new CacheLoader(){

            public Object load(LoaderHelper helper) {
                return "val" + helper.getArgument();
            }

            public void close() {
            }
        });
        Region rgn = this.getCache().createRegion(rgnName, factory.create());
        TXDistributedTest.invokeInEveryVM(new SerializableRunnable("testDACKLoadedMessage: intial configuration"){

            @Override
            public void run() {
                try {
                    AttributesFactory factory2 = new AttributesFactory();
                    factory2.setScope(Scope.DISTRIBUTED_ACK);
                    factory2.setEarlyAck(false);
                    factory2.setMirrorType(MirrorType.KEYS);
                    TXDistributedTest.this.getCache().createRegion(rgnName, factory2.create());
                }
                catch (CacheException e) {
                    DistributedTestCase.fail("While creating region", e);
                }
            }
        });
        txMgr.begin();
        rgn.put((Object)"key1", (Object)"val1");
        txMgr.commit();
        TXDistributedTest.assertEquals((Object)"val1", (Object)rgn.getEntry((Object)"key1").getValue());
        TXManagerImpl.waitForPendingCommitForTest();
        TXDistributedTest.invokeInEveryVM(new SerializableRunnable("testDACKLoadedMessage: confirm standard case"){

            @Override
            public void run() {
                Region rgn1 = TXDistributedTest.this.getCache().getRegion(rgnName);
                TestCase.assertEquals((Object)"val1", (Object)rgn1.getEntry((Object)"key1").getValue());
            }
        });
        txMgr.begin();
        rgn.get((Object)"key2", (Object)new Integer(2));
        txMgr.commit();
        TXDistributedTest.assertEquals((Object)"val2", (Object)rgn.getEntry((Object)"key2").getValue());
        TXManagerImpl.waitForPendingCommitForTest();
        TXDistributedTest.invokeInEveryVM(new SerializableRunnable("testDACKLoadedMessage: confirm standard case"){

            @Override
            public void run() {
                Region rgn1 = TXDistributedTest.this.getCache().getRegion(rgnName);
                TestCase.assertEquals((Object)"val2", (Object)rgn1.getEntry((Object)"key2").getValue());
            }
        });
        txMgr.begin();
        rgn.put((Object)"key3", (Object)"val3");
        rgn.get((Object)"key4", (Object)new Integer(4));
        txMgr.commit();
        TXManagerImpl.waitForPendingCommitForTest();
        TXDistributedTest.invokeInEveryVM(new SerializableRunnable("testDACKLoadedMessage: confirm standard case"){

            @Override
            public void run() {
                Region rgn1 = TXDistributedTest.this.getCache().getRegion(rgnName);
                TestCase.assertEquals((Object)"val3", (Object)rgn1.getEntry((Object)"key3").getValue());
                TestCase.assertEquals((Object)"val4", (Object)rgn1.getEntry((Object)"key4").getValue());
            }
        });
    }

    public void DISABLED_TILL_NEW_TX_IMPL_COMPLETE_testHighAvailabilityFeatures() throws Exception {
        final String rgnName = this.getUniqueName();
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setEarlyAck(false);
        Region rgn = this.getCache().createRegion(rgnName, factory.create());
        TXDistributedTest.invokeInEveryVM(new SerializableRunnable("testHighAvailabilityFeatures: intial region configuration"){

            @Override
            public void run() {
                try {
                    AttributesFactory factory2 = new AttributesFactory();
                    factory2.setScope(Scope.DISTRIBUTED_ACK);
                    factory2.setEarlyAck(false);
                    factory2.setDataPolicy(DataPolicy.REPLICATE);
                    TXDistributedTest.this.getCache().createRegion(rgnName, factory2.create());
                }
                catch (CacheException e) {
                    DistributedTestCase.fail("While creating region", e);
                }
            }
        });
        rgn.put((Object)"key0", (Object)"val0_0");
        rgn.put((Object)"key1", (Object)"val1_0");
        Host host = Host.getHost(0);
        TXDistributedTest.assertTrue((host.getVMCount() >= 3 ? 1 : 0) != 0);
        VM originVM = host.getVM(0);
        originVM.invoke(new SerializableRunnable("Flakey DuringIndividualSend Transaction"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                final Region rgn1 = TXDistributedTest.this.getCache().getRegion(rgnName);
                TestCase.assertNotNull((Object)rgn1);
                try {
                    CacheTransactionManager txMgr2;
                    CacheTransactionManager txMgrImpl = txMgr2 = TXDistributedTest.this.getCache().getCacheTransactionManager();
                    txMgr2.begin();
                    TXStateInterface txState = ((TXManagerImpl)txMgrImpl).getTXState();
                    txState.setObserver((TransactionObserver)new TransactionObserverAdapter(){
                        private int numCalled = 0;

                        public synchronized void beforeSend(TXStateProxy tx, boolean rollback) {
                            ++this.numCalled;
                            rgn1.getCache().getLogger().info("beforeSend called " + this.numCalled + " times");
                            if (this.numCalled > 1) {
                                CacheTestCase.disconnectFromDS();
                            }
                        }
                    });
                    rgn1.put((Object)"key0", (Object)"val0_1");
                    rgn1.put((Object)"key1", (Object)"val1_1");
                    txMgr2.commit();
                }
                catch (VirtualMachineError e) {
                    SystemFailure.initiateFailure((Error)e);
                    throw e;
                }
                catch (Throwable e) {
                    rgn1.getCache().getLogger().warning("Ignoring Exception", e);
                }
                finally {
                    CacheTestCase.closeCache();
                }
            }
        });
        SerializableRunnable noChangeValidator = new SerializableRunnable("testHighAvailabilityFeatures: validate no change in Region"){

            @Override
            public void run() {
                Region rgn1 = TXDistributedTest.this.getCache().getRegion(rgnName);
                if (rgn1 == null) {
                    try {
                        AttributesFactory factory2 = new AttributesFactory();
                        factory2.setScope(Scope.DISTRIBUTED_ACK);
                        factory2.setDataPolicy(DataPolicy.REPLICATE);
                        rgn1 = TXDistributedTest.this.getCache().createRegion(rgnName, factory2.create());
                    }
                    catch (CacheException e) {
                        DistributedTestCase.fail("While creating region", e);
                    }
                }
                Region.Entry re = rgn1.getEntry((Object)"key0");
                TestCase.assertNotNull((Object)re);
                TestCase.assertEquals((Object)"val0_0", (Object)re.getValue());
                re = rgn1.getEntry((Object)"key1");
                TestCase.assertNotNull((Object)re);
                TestCase.assertEquals((Object)"val1_0", (Object)re.getValue());
            }
        };
        TXDistributedTest.invokeInEveryVM(noChangeValidator);
        originVM.invoke(new SerializableRunnable("Flakey AfterIndividualSend Transaction"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Region rgn1 = TXDistributedTest.this.getCache().getRegion(rgnName);
                TestCase.assertNotNull((Object)rgn1);
                try {
                    CacheTransactionManager txMgr2;
                    CacheTransactionManager txMgrImpl = txMgr2 = TXDistributedTest.this.getCache().getCacheTransactionManager();
                    txMgr2.begin();
                    TXStateInterface txState = ((TXManagerImpl)txMgrImpl).getTXState();
                    txState.setObserver((TransactionObserver)new TransactionObserverAdapter(){

                        public synchronized void afterSend(TXStateProxy tx, boolean rollback) {
                            MembershipManagerHelper.crashDistributedSystem((DistributedSystem)TXDistributedTest.this.getSystem());
                        }
                    });
                    rgn1.put((Object)"key0", (Object)"val0_2");
                    rgn1.put((Object)"key1", (Object)"val1_2");
                    txMgr2.commit();
                }
                catch (VirtualMachineError e) {
                    SystemFailure.initiateFailure((Error)e);
                    throw e;
                }
                catch (Throwable e) {
                    rgn1.getCache().getLogger().warning("Ignoring Exception", e);
                }
                finally {
                    CacheTestCase.closeCache();
                }
            }
        });
        TXDistributedTest.invokeInEveryVM(noChangeValidator);
        originVM.invoke(new SerializableRunnable("Flakey DuringIndividualCommitProcess Transaction"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                final Region rgn1 = TXDistributedTest.this.getCache().getRegion(rgnName);
                TestCase.assertNotNull((Object)rgn1);
                try {
                    CacheTransactionManager txMgr2;
                    CacheTransactionManager txMgrImpl = txMgr2 = TXDistributedTest.this.getCache().getCacheTransactionManager();
                    txMgr2.begin();
                    TXStateInterface txState = ((TXManagerImpl)txMgrImpl).getTXState();
                    txState.setObserver((TransactionObserver)new TransactionObserverAdapter(){
                        private int numCalled = 0;

                        public synchronized void duringInvidividualCommitProcess(TXStateProxy tx) {
                            ++this.numCalled;
                            rgn1.getCache().getLogger().info("duringIndividualCommitProcess called " + this.numCalled + " times");
                            if (this.numCalled > 1) {
                                MembershipManagerHelper.crashDistributedSystem((DistributedSystem)TXDistributedTest.this.getSystem());
                            }
                        }
                    });
                    rgn1.put((Object)"key0", (Object)"val0_3");
                    rgn1.put((Object)"key1", (Object)"val1_3");
                    txMgr2.commit();
                }
                catch (VirtualMachineError e) {
                    SystemFailure.initiateFailure((Error)e);
                    throw e;
                }
                catch (Throwable e) {
                    rgn1.getCache().getLogger().warning("Ignoring Exception", e);
                }
                finally {
                    CacheTestCase.closeCache();
                }
            }
        });
        SerializableRunnable nonSoloChangeValidator1 = new SerializableRunnable("testHighAvailabilityFeatures: validate v1 non-solo Region changes"){

            @Override
            public void run() {
                Region rgn1 = TXDistributedTest.this.getCache().getRegion(rgnName);
                if (rgn1 == null) {
                    try {
                        AttributesFactory factory2 = new AttributesFactory();
                        factory2.setScope(Scope.DISTRIBUTED_ACK);
                        factory2.setEarlyAck(false);
                        factory2.setDataPolicy(DataPolicy.REPLICATE);
                        rgn1 = TXDistributedTest.this.getCache().createRegion(rgnName, factory2.create());
                    }
                    catch (CacheException e) {
                        DistributedTestCase.fail("While creating region", e);
                    }
                }
                Region.Entry re = rgn1.getEntry((Object)"key0");
                TestCase.assertNotNull((Object)re);
                TestCase.assertEquals((Object)"val0_3", (Object)re.getValue());
                re = rgn1.getEntry((Object)"key1");
                TestCase.assertNotNull((Object)re);
                TestCase.assertEquals((Object)"val1_3", (Object)re.getValue());
            }
        };
        TXDistributedTest.invokeInEveryVM(nonSoloChangeValidator1);
        final String soloRegionName = this.getUniqueName() + "_solo";
        SerializableRunnable createSoloRegion = new SerializableRunnable("testHighAvailabilityFeatures: solo region configuration"){

            @Override
            public void run() {
                try {
                    AttributesFactory factory2 = new AttributesFactory();
                    factory2.setScope(Scope.DISTRIBUTED_ACK);
                    factory2.setEarlyAck(false);
                    factory2.setDataPolicy(DataPolicy.REPLICATE);
                    Region rgn1 = TXDistributedTest.this.getCache().createRegion(soloRegionName, factory2.create());
                    rgn1.put((Object)"soloKey0", (Object)"soloVal0_0");
                    rgn1.put((Object)"soloKey1", (Object)"soloVal1_0");
                }
                catch (CacheException e) {
                    DistributedTestCase.fail("While creating region", e);
                }
            }
        };
        VM soloRegionVM = host.getVM(1);
        originVM.invoke(createSoloRegion);
        soloRegionVM.invoke(createSoloRegion);
        originVM.invoke(new SerializableRunnable("Flakey solo region DuringIndividualSend Transaction"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                final Region soloRgn = TXDistributedTest.this.getCache().getRegion(soloRegionName);
                TestCase.assertNotNull((Object)soloRgn);
                try {
                    CacheTransactionManager txMgr2;
                    CacheTransactionManager txMgrImpl = txMgr2 = TXDistributedTest.this.getCache().getCacheTransactionManager();
                    txMgr2.begin();
                    TXStateInterface txState = ((TXManagerImpl)txMgrImpl).getTXState();
                    txState.setObserver((TransactionObserver)new TransactionObserverAdapter(){
                        private int numCalled = 0;

                        public synchronized void beforeSend() {
                            ++this.numCalled;
                            soloRgn.getCache().getLogger().info("beforeSend called " + this.numCalled + " times");
                            if (this.numCalled > 1) {
                                MembershipManagerHelper.crashDistributedSystem((DistributedSystem)TXDistributedTest.this.getSystem());
                            }
                        }
                    });
                    soloRgn.put((Object)"soloKey0", (Object)"soloVal0_1");
                    soloRgn.put((Object)"soloKey1", (Object)"soloVal1_1");
                    txMgr2.commit();
                }
                catch (VirtualMachineError e) {
                    SystemFailure.initiateFailure((Error)e);
                    throw e;
                }
                catch (Throwable e) {
                    soloRgn.getCache().getLogger().warning("Ignoring Exception", e);
                }
                finally {
                    CacheTestCase.closeCache();
                }
            }
        });
        SerializableRunnable soloRegionCommitValidator1 = new SerializableRunnable("testHighAvailabilityFeatures: validate successful v1 commit in solo Region"){

            @Override
            public void run() {
                Region soloRgn = TXDistributedTest.this.getCache().getRegion(soloRegionName);
                if (soloRgn == null) {
                    try {
                        AttributesFactory factory2 = new AttributesFactory();
                        factory2.setScope(Scope.DISTRIBUTED_ACK);
                        factory2.setEarlyAck(false);
                        factory2.setDataPolicy(DataPolicy.REPLICATE);
                        soloRgn = TXDistributedTest.this.getCache().createRegion(soloRegionName, factory2.create());
                    }
                    catch (CacheException e) {
                        DistributedTestCase.fail("While creating region ", e);
                    }
                }
                Region.Entry re = soloRgn.getEntry((Object)"soloKey0");
                TestCase.assertNotNull((Object)re);
                TestCase.assertEquals((Object)"soloVal0_1", (Object)re.getValue());
                re = soloRgn.getEntry((Object)"soloKey1");
                TestCase.assertNotNull((Object)re);
                TestCase.assertEquals((Object)"soloVal1_1", (Object)re.getValue());
            }
        };
        originVM.invoke(soloRegionCommitValidator1);
        soloRegionVM.invoke(soloRegionCommitValidator1);
        TXDistributedTest.invokeInEveryVM(nonSoloChangeValidator1);
        originVM.invoke(new SerializableRunnable("Flakey mixed (solo+non-solo) region DuringIndividualSend Transaction"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Region rgn1 = TXDistributedTest.this.getCache().getRegion(rgnName);
                TestCase.assertNotNull((Object)rgn1);
                Region soloRgn = TXDistributedTest.this.getCache().getRegion(soloRegionName);
                TestCase.assertNotNull((Object)soloRgn);
                try {
                    CacheTransactionManager txMgr2;
                    CacheTransactionManager txMgrImpl = txMgr2 = TXDistributedTest.this.getCache().getCacheTransactionManager();
                    txMgr2.begin();
                    TXStateInterface txState = ((TXManagerImpl)txMgrImpl).getTXState();
                    txState.setObserver((TransactionObserver)new TransactionObserverAdapter(){

                        public synchronized void afterSend(TXStateProxy tx, boolean rollback) {
                            MembershipManagerHelper.crashDistributedSystem((DistributedSystem)TXDistributedTest.this.getSystem());
                        }
                    });
                    rgn1.put((Object)"key0", (Object)"val0_4");
                    rgn1.put((Object)"key1", (Object)"val1_4");
                    soloRgn.put((Object)"soloKey0", (Object)"soloVal0_2");
                    soloRgn.put((Object)"soloKey1", (Object)"soloVal1_2");
                    txMgr2.commit();
                }
                catch (VirtualMachineError e) {
                    SystemFailure.initiateFailure((Error)e);
                    throw e;
                }
                catch (Throwable e) {
                    rgn1.getCache().getLogger().warning("Ignoring Exception", e);
                }
                finally {
                    CacheTestCase.closeCache();
                }
            }
        });
        originVM.invoke(soloRegionCommitValidator1);
        soloRegionVM.invoke(soloRegionCommitValidator1);
        TXDistributedTest.invokeInEveryVM(nonSoloChangeValidator1);
        originVM.invoke(new SerializableRunnable("Flakey mixed (solo+non-solo) region DuringIndividualCommitProcess Transaction"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                final Region rgn1 = TXDistributedTest.this.getCache().getRegion(rgnName);
                TestCase.assertNotNull((Object)rgn1);
                Region soloRgn = TXDistributedTest.this.getCache().getRegion(soloRegionName);
                TestCase.assertNotNull((Object)soloRgn);
                try {
                    CacheTransactionManager txMgr2;
                    CacheTransactionManager txMgrImpl = txMgr2 = TXDistributedTest.this.getCache().getCacheTransactionManager();
                    txMgr2.begin();
                    TXState txState = (TXState)((TXManagerImpl)txMgrImpl).getTXState();
                    txState.setObserver((TransactionObserver)new TransactionObserverAdapter(){
                        private int numCalled = 0;

                        public synchronized void afterSend(TXStateProxy tx, boolean rollback) {
                            ++this.numCalled;
                            rgn1.getCache().getLogger().info("afterSend called " + this.numCalled + " times");
                            if (this.numCalled > 1) {
                                MembershipManagerHelper.crashDistributedSystem((DistributedSystem)TXDistributedTest.this.getSystem());
                            }
                        }
                    });
                    rgn1.put((Object)"key0", (Object)"val0_5");
                    rgn1.put((Object)"key1", (Object)"val1_5");
                    soloRgn.put((Object)"soloKey0", (Object)"soloVal0_3");
                    soloRgn.put((Object)"soloKey1", (Object)"soloVal1_3");
                    txMgr2.commit();
                }
                catch (VirtualMachineError e) {
                    SystemFailure.initiateFailure((Error)e);
                    throw e;
                }
                catch (Throwable e) {
                    rgn1.getCache().getLogger().warning("Ignoring Exception", e);
                }
                finally {
                    CacheTestCase.closeCache();
                }
            }
        });
        SerializableRunnable soloRegionCommitValidator2 = new SerializableRunnable("testHighAvailabilityFeatures: validate successful v2 commit in solo Region"){

            @Override
            public void run() {
                Region soloRgn = TXDistributedTest.this.getCache().getRegion(soloRegionName);
                if (soloRgn == null) {
                    try {
                        AttributesFactory factory2 = new AttributesFactory();
                        factory2.setScope(Scope.DISTRIBUTED_ACK);
                        factory2.setEarlyAck(false);
                        factory2.setDataPolicy(DataPolicy.REPLICATE);
                        soloRgn = TXDistributedTest.this.getCache().createRegion(soloRegionName, factory2.create());
                    }
                    catch (CacheException e) {
                        DistributedTestCase.fail("While creating region ", e);
                    }
                }
                Region.Entry re = soloRgn.getEntry((Object)"soloKey0");
                TestCase.assertNotNull((Object)re);
                TestCase.assertEquals((Object)"soloVal0_3", (Object)re.getValue());
                re = soloRgn.getEntry((Object)"soloKey1");
                TestCase.assertNotNull((Object)re);
                TestCase.assertEquals((Object)"soloVal1_3", (Object)re.getValue());
            }
        };
        originVM.invoke(soloRegionCommitValidator2);
        soloRegionVM.invoke(soloRegionCommitValidator2);
        SerializableRunnable nonSoloChangeValidator2 = new SerializableRunnable("testHighAvailabilityFeatures: validate v2 non-solo Region changes"){

            @Override
            public void run() {
                Region rgn1 = TXDistributedTest.this.getCache().getRegion(rgnName);
                if (rgn1 == null) {
                    try {
                        AttributesFactory factory2 = new AttributesFactory();
                        factory2.setScope(Scope.DISTRIBUTED_ACK);
                        factory2.setEarlyAck(false);
                        factory2.setDataPolicy(DataPolicy.REPLICATE);
                        rgn1 = TXDistributedTest.this.getCache().createRegion(rgnName, factory2.create());
                    }
                    catch (CacheException e) {
                        DistributedTestCase.fail("While creating region", e);
                    }
                }
                Region.Entry re = rgn1.getEntry((Object)"key0");
                TestCase.assertNotNull((Object)re);
                TestCase.assertEquals((Object)"val0_5", (Object)re.getValue());
                re = rgn1.getEntry((Object)"key1");
                TestCase.assertNotNull((Object)re);
                TestCase.assertEquals((Object)"val1_5", (Object)re.getValue());
            }
        };
        TXDistributedTest.invokeInEveryVM(nonSoloChangeValidator2);
    }

    public static Serializable getSystemId() {
        InternalDistributedMember ret = null;
        if (DistributedTestCase.system != null) {
            ret = DistributedTestCase.system.getDistributionManager().getId();
        }
        return ret;
    }

    public static void setPreTXSystemIds(HashSet ids) {
        preTXSystemIds = ids;
    }

    public static void setPostTXSystemIds(HashSet ids) {
        postTXSystemIds = ids;
    }

    public static void setTXHostSystemId(Serializable id) {
        txHostId = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRemoteCommitFailure() {
        final String rgnName1 = this.getUniqueName() + "_1";
        final String rgnName2 = this.getUniqueName() + "_2";
        Host host = Host.getHost(0);
        VM origin = host.getVM(0);
        VM trouble1 = host.getVM(1);
        VM trouble2 = host.getVM(2);
        VM noTrouble = host.getVM(3);
        CacheSerializableRunnable initRegions = new CacheSerializableRunnable("Initialize no trouble regions"){

            @Override
            public void run2() {
                AttributesFactory af = new AttributesFactory();
                af.setDataPolicy(DataPolicy.REPLICATE);
                af.setScope(Scope.DISTRIBUTED_ACK);
                TXDistributedTest.this.getCache().createRegion(rgnName1, af.create());
                TXDistributedTest.this.getCache().createRegion(rgnName2, af.create());
            }
        };
        origin.invoke(initRegions);
        noTrouble.invoke(initRegions);
        CacheSerializableRunnable initTroulbeRegions = new CacheSerializableRunnable("Initialize regions that cause trouble"){

            @Override
            public void run2() {
                GemFireCacheImpl gfc = (GemFireCacheImpl)TXDistributedTest.this.getCache();
                InternalRegionArguments ira = new InternalRegionArguments().setTestCallable((LocalRegion.TestCallable)new TXTroubleMaker());
                try {
                    AttributesFactory af = new AttributesFactory();
                    af.setDataPolicy(DataPolicy.REPLICATE);
                    af.setScope(Scope.DISTRIBUTED_ACK);
                    gfc.createVMRegion(rgnName1, af.create(), ira);
                    gfc.createVMRegion(rgnName2, af.create(), ira);
                }
                catch (IOException ioe) {
                    TestCase.fail((String)ioe.toString());
                }
                catch (TimeoutException e) {
                    TestCase.fail((String)e.toString());
                }
                catch (ClassNotFoundException e) {
                    TestCase.fail((String)e.toString());
                }
            }
        };
        trouble1.invoke(initTroulbeRegions);
        trouble2.invoke(initTroulbeRegions);
        CacheSerializableRunnable doTransaction = new CacheSerializableRunnable("Run failing transaction"){

            @Override
            public void run2() {
                Cache c = TXDistributedTest.this.getCache();
                Region r1 = c.getRegion(rgnName1);
                TestCase.assertNotNull((Object)r1);
                Region r2 = c.getRegion(rgnName2);
                TestCase.assertNotNull((Object)r2);
                CacheTransactionManager txmgr = c.getCacheTransactionManager();
                txmgr.begin();
                r1.put((Object)"k1", (Object)"k1");
                r1.put((Object)"k2", (Object)"k2");
                r1.put((Object)TXDistributedTest.TROUBLE_KEY, (Object)TXDistributedTest.TROUBLE_KEY);
                r2.put((Object)"k1", (Object)"k1");
                r2.put((Object)"k2", (Object)"k2");
                r2.put((Object)TXDistributedTest.TROUBLE_KEY, (Object)TXDistributedTest.TROUBLE_KEY);
                try {
                    txmgr.commit();
                }
                catch (TransactionInDoubtException yay) {
                    String msg = yay.getMessage();
                    int ind = 0;
                    int match = 0;
                    while ((ind = msg.indexOf(rgnName1, ind)) >= 0) {
                        ++ind;
                        ++match;
                    }
                    TestCase.assertEquals((int)1, (int)match);
                    match = 0;
                    ind = 0;
                    while ((ind = msg.indexOf(DiskAccessException.class.getName(), ind)) >= 0) {
                        ++ind;
                        ++match;
                    }
                    TestCase.assertEquals((int)1, (int)match);
                    TestCase.fail((String)"do not expect to receive exceptions from commit phase 2");
                }
                TXManagerImpl.waitForPendingCommitForTest();
            }
        };
        DistributedTestCase.ExpectedException ee = null;
        try {
            ee = TXDistributedTest.addExpectedException(DiskAccessException.class.getName() + "|" + TransactionInDoubtException.class.getName());
            origin.invoke(doTransaction);
        }
        finally {
            if (ee != null) {
                ee.remove();
            }
        }
        CacheSerializableRunnable assertTroubledContent = new CacheSerializableRunnable("Assert partial commit data"){

            @Override
            public void run2() {
                Cache c = TXDistributedTest.this.getCache();
                Region r1 = c.getRegion(rgnName1);
                TestCase.assertNull((Object)r1);
            }
        };
        trouble1.invoke(assertTroubledContent);
        trouble2.invoke(assertTroubledContent);
        CacheSerializableRunnable assertSuccessfulContent = new CacheSerializableRunnable("Assert complete commit of data on successful VMs"){

            @Override
            public void run2() {
                Cache c = TXDistributedTest.this.getCache();
                Region r1 = c.getRegion(rgnName1);
                TestCase.assertNotNull((Object)r1);
                TestCase.assertEquals((Object)"k1", (Object)r1.getEntry((Object)"k1").getValue());
                TestCase.assertEquals((Object)"k2", (Object)r1.getEntry((Object)"k2").getValue());
                TestCase.assertEquals((Object)TXDistributedTest.TROUBLE_KEY, (Object)r1.getEntry((Object)TXDistributedTest.TROUBLE_KEY).getValue());
                Region r2 = c.getRegion(rgnName2);
                TestCase.assertNotNull((Object)r2);
                TestCase.assertEquals((Object)"k1", (Object)r2.getEntry((Object)"k1").getValue());
                TestCase.assertEquals((Object)"k2", (Object)r2.getEntry((Object)"k2").getValue());
                TestCase.assertEquals((Object)TXDistributedTest.TROUBLE_KEY, (Object)r2.getEntry((Object)TXDistributedTest.TROUBLE_KEY).getValue());
            }
        };
        noTrouble.invoke(assertSuccessfulContent);
        CacheSerializableRunnable assertNoContent = new CacheSerializableRunnable("Assert data survives on origin VM"){

            @Override
            public void run2() {
                Cache c = TXDistributedTest.this.getCache();
                Region r1 = c.getRegion(rgnName1);
                TestCase.assertNotNull((Object)r1);
                TestCase.assertNotNull((Object)r1.getEntry((Object)"k1"));
                TestCase.assertNotNull((Object)r1.getEntry((Object)"k2"));
                TestCase.assertNotNull((Object)r1.getEntry((Object)TXDistributedTest.TROUBLE_KEY));
                Region r2 = c.getRegion(rgnName2);
                TestCase.assertNotNull((Object)r2);
                TestCase.assertNotNull((Object)r2.getEntry((Object)"k1"));
                TestCase.assertNotNull((Object)r2.getEntry((Object)"k2"));
                TestCase.assertNotNull((Object)r2.getEntry((Object)TXDistributedTest.TROUBLE_KEY));
            }
        };
        origin.invoke(assertNoContent);
    }

    public static class TXTroubleMaker
    implements LocalRegion.TestCallable {
        public void call(LocalRegion r, Operation op, RegionEntry re) {
            if (TXDistributedTest.TROUBLE_KEY.equals(re.getKey())) {
                throw new DiskAccessException(TXDistributedTest.TROUBLE_KEY, (Region)r);
            }
        }
    }
}

