/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache30;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.CacheWriter;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.cache.util.CacheWriterAdapter;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.distributed.DistributedSystem;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.VM;
import java.util.HashMap;
import java.util.Properties;
import junit.framework.TestCase;

public class PutAllCallBkRemoteVMDUnitTest
extends DistributedTestCase {
    static volatile Cache cache;
    static Properties props;
    static Properties propsWork;
    static volatile DistributedSystem ds;
    static volatile Region region;
    static volatile Region paperRegion;
    static boolean afterCreate;
    static boolean afterUpdate;
    static int putAllcounter;
    static int afterUpdateputAllcounter;
    static boolean beforeCreate;
    static boolean beforeUpdate;
    static int forCreate;
    static int forUpdate;
    static int beforeCreateputAllcounter;
    static int beforeUpdateputAllcounter;
    static boolean notified;

    public PutAllCallBkRemoteVMDUnitTest(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        vm0.invoke(PutAllCallBkRemoteVMDUnitTest.class, "createCacheForVM0");
        vm1.invoke(PutAllCallBkRemoteVMDUnitTest.class, "createCacheForVM1");
        PutAllCallBkRemoteVMDUnitTest.getLogWriter().info("Cache created successfully");
    }

    @Override
    public void tearDown2() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        vm0.invoke(PutAllCallBkRemoteVMDUnitTest.class, "closeCache");
        vm1.invoke(PutAllCallBkRemoteVMDUnitTest.class, "closeCache");
    }

    public static synchronized void createCacheForVM0() {
        try {
            ds = new PutAllCallBkRemoteVMDUnitTest("temp").getSystem(props);
            cache = CacheFactory.create((DistributedSystem)ds);
            AttributesFactory factory = new AttributesFactory();
            factory.setDataPolicy(DataPolicy.REPLICATE);
            factory.setScope(Scope.DISTRIBUTED_ACK);
            RegionAttributes attr1 = factory.create();
            paperRegion = cache.createRegion("paper", attr1);
            RegionAttributes attr = factory.create();
            region = cache.createRegion("map", attr);
        }
        catch (CacheException ex) {
            throw new RuntimeException("vm0 cache creation exception", ex);
        }
    }

    public static void createCacheForVM1() {
        try {
            AfterCreateCallback aListener = new AfterCreateCallback();
            BeforeCreateCallback aWriter = new BeforeCreateCallback();
            ds = new PutAllCallBkRemoteVMDUnitTest("temp").getSystem(props);
            cache = CacheFactory.create((DistributedSystem)ds);
            AttributesFactory factory = new AttributesFactory();
            factory.setDataPolicy(DataPolicy.REPLICATE);
            factory.setScope(Scope.DISTRIBUTED_ACK);
            RegionAttributes attr1 = factory.create();
            paperRegion = cache.createRegion("paper", attr1);
            factory.setCacheWriter((CacheWriter)aWriter);
            factory.addCacheListener((CacheListener)aListener);
            RegionAttributes attr = factory.create();
            region = cache.createRegion("map", attr);
        }
        catch (CacheException ex) {
            throw new RuntimeException("vm1 cache creation exception", ex);
        }
    }

    public static synchronized void closeCache() {
        paperRegion = null;
        region = null;
        if (cache != null) {
            cache.close();
            cache = null;
        }
        if (ds != null) {
            ds.disconnect();
            ds = null;
        }
    }

    public void testputAllRemoteVM() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        vm0.invoke(new CacheSerializableRunnable("put entries"){

            @Override
            public void run2() throws CacheException {
                HashMap<Integer, String> m = new HashMap<Integer, String>();
                paperRegion.put((Object)"callbackCame", (Object)"false");
                try {
                    for (int i = 1; i < 21; ++i) {
                        m.put(new Integer(i), Integer.toString(i));
                    }
                    region.putAll(m);
                }
                catch (Exception ex) {
                    throw new RuntimeException("exception putting entries", ex);
                }
                DistributedTestCase.getLogWriter().info("****************paperRegion.get(afterCreate)***************" + paperRegion.get((Object)"afterCreate"));
                DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        int size = region.size();
                        if (size != (Integer)paperRegion.get((Object)"afterCreate") - 1) {
                            return false;
                        }
                        return size == (Integer)paperRegion.get((Object)"beforeCreate") - 1;
                    }

                    @Override
                    public String description() {
                        return "Waiting for event";
                    }
                };
                DistributedTestCase.waitForCriterion(ev, 3000L, 200L, true);
            }
        });
        vm1.invoke(new CacheSerializableRunnable("validate callbacks"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run2() throws CacheException {
                if (!notified) {
                    try {
                        Class<PutAllCallBkRemoteVMDUnitTest> clazz = PutAllCallBkRemoteVMDUnitTest.class;
                        synchronized (PutAllCallBkRemoteVMDUnitTest.class) {
                            this.wait();
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                {
                    if (!paperRegion.get((Object)"callbackCame").equals("true")) {
                        TestCase.fail((String)"Failed in aftercreate call back :: PutAllCallBkRemoteVMDUnitTest ");
                    }
                    return;
                }
            }
        });
    }

    public void testPutAllAfterUpdateCallbacks() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        vm0.invoke(new CacheSerializableRunnable("put and then update"){

            @Override
            public void run2() throws CacheException {
                paperRegion.put((Object)"callbackCame", (Object)"false");
                for (int i = 0; i < 5; ++i) {
                    region.put((Object)new Integer(i), (Object)new String("region" + i));
                }
                HashMap<Integer, String> m = new HashMap<Integer, String>();
                for (int i = 0; i < 5; ++i) {
                    m.put(new Integer(i), new String("map" + i));
                }
                region.putAll(m);
                TestCase.assertEquals((int)region.size(), (int)((Integer)paperRegion.get((Object)"beforeUpdate") - 1));
                TestCase.assertEquals((int)region.size(), (int)((Integer)paperRegion.get((Object)"afterUpdate") - 1));
            }
        });
        vm1.invoke(new CacheSerializableRunnable("validate callbacks"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run2() throws CacheException {
                if (!notified) {
                    try {
                        Class<PutAllCallBkRemoteVMDUnitTest> clazz = PutAllCallBkRemoteVMDUnitTest.class;
                        synchronized (PutAllCallBkRemoteVMDUnitTest.class) {
                            this.wait();
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                {
                    if (!paperRegion.get((Object)"callbackCame").equals("true")) {
                        TestCase.fail((String)"Failed in afterUpdate call back :: PutAllCallBkRemoteVMDUnitTest");
                    }
                    return;
                }
            }
        });
    }

    public static Object putMethod(Object ob) {
        Object obj = null;
        try {
            if (ob != null) {
                String str = "first";
                obj = region.put(ob, (Object)str);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            PutAllCallBkRemoteVMDUnitTest.fail((String)"Failed while region.put");
        }
        return obj;
    }

    public static void putAllMethod() {
        HashMap<Integer, String> m = new HashMap<Integer, String>();
        int i = 5;
        try {
            for (int cntr = 0; cntr < 20; ++cntr) {
                m.put(new Integer(i), new String("map" + i));
                ++i;
            }
            region.putAll(m);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            PutAllCallBkRemoteVMDUnitTest.fail((String)"Failed while region.putAll");
        }
    }

    public static Object getMethod(Object ob) {
        Object obj = null;
        try {
            obj = region.get(ob);
        }
        catch (Exception ex) {
            PutAllCallBkRemoteVMDUnitTest.fail((String)"Failed while region.get");
        }
        return obj;
    }

    public static int sizeMethod() {
        int i = 0;
        try {
            i = region.size();
        }
        catch (Exception ex) {
            PutAllCallBkRemoteVMDUnitTest.fail((String)"Failed while region.size");
        }
        return i;
    }

    public static void clearMethod() {
        try {
            region.clear();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static {
        props = new Properties();
        propsWork = new Properties();
        ds = null;
        afterCreate = false;
        afterUpdate = false;
        putAllcounter = 0;
        afterUpdateputAllcounter = 0;
        beforeCreate = false;
        beforeUpdate = false;
        forCreate = 0;
        forUpdate = 0;
        beforeCreateputAllcounter = 0;
        beforeUpdateputAllcounter = 0;
        notified = false;
    }

    static class BeforeCreateCallback
    extends CacheWriterAdapter {
        BeforeCreateCallback() {
        }

        public void beforeCreate(EntryEvent event) {
            Integer counter = (Integer)paperRegion.get((Object)"beforeCreate");
            if (counter == null) {
                counter = new Integer(1);
            }
            paperRegion.put((Object)"beforeCreate", (Object)new Integer(counter + 1));
            DistributedTestCase.getLogWriter().info("*******BeforeCreate***** event=" + event);
        }

        public void beforeUpdate(EntryEvent event) {
            Integer counter = (Integer)paperRegion.get((Object)"beforeUpdate");
            if (counter == null) {
                counter = new Integer(1);
            }
            paperRegion.put((Object)"beforeUpdate", (Object)new Integer(counter + 1));
            DistributedTestCase.getLogWriter().info("In beforeUpdate" + beforeUpdateputAllcounter);
            DistributedTestCase.getLogWriter().info("*******BeforeUpdate***** event=" + event);
        }
    }

    static class AfterCreateCallback
    extends CacheListenerAdapter {
        AfterCreateCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterCreate(EntryEvent event) {
            paperRegion.put((Object)"callbackCame", (Object)"true");
            Integer counter = (Integer)paperRegion.get((Object)"afterCreate");
            if (counter == null) {
                counter = new Integer(1);
            }
            paperRegion.put((Object)"afterCreate", (Object)new Integer(counter + 1));
            DistributedTestCase.getLogWriter().info("In afterCreate" + putAllcounter);
            if (putAllcounter == forCreate) {
                DistributedTestCase.getLogWriter().info("performingtrue");
                afterCreate = true;
            }
            try {
                Class<PutAllCallBkRemoteVMDUnitTest> clazz = PutAllCallBkRemoteVMDUnitTest.class;
                synchronized (PutAllCallBkRemoteVMDUnitTest.class) {
                    ((Object)((Object)this)).notify();
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            {
                notified = true;
                DistributedTestCase.getLogWriter().info("*******afterCreate***** Key :" + event.getKey() + " Value :" + event.getNewValue());
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterUpdate(EntryEvent event) {
            paperRegion.put((Object)"callbackCame", (Object)"true");
            Integer counter = (Integer)paperRegion.get((Object)"afterUpdate");
            if (counter == null) {
                counter = new Integer(1);
            }
            paperRegion.put((Object)"afterUpdate", (Object)new Integer(counter + 1));
            DistributedTestCase.getLogWriter().info("In afterUpdate" + afterUpdateputAllcounter);
            if (afterUpdateputAllcounter == forUpdate) {
                DistributedTestCase.getLogWriter().info("performingtrue afterUpdate");
                afterUpdate = true;
            }
            try {
                Class<PutAllCallBkRemoteVMDUnitTest> clazz = PutAllCallBkRemoteVMDUnitTest.class;
                synchronized (PutAllCallBkRemoteVMDUnitTest.class) {
                    ((Object)((Object)this)).notify();
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            {
                notified = true;
                DistributedTestCase.getLogWriter().info("*******afterUpdate***** Key :" + event.getKey() + " Value :" + event.getNewValue());
                return;
            }
        }
    }
}

