/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache30;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.AttributesMutator;
import com.gemstone.gemfire.cache.CacheEvent;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.CacheLoader;
import com.gemstone.gemfire.cache.CacheLoaderException;
import com.gemstone.gemfire.cache.CacheWriter;
import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.InterestPolicy;
import com.gemstone.gemfire.cache.LoaderHelper;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionEvent;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.SubscriptionAttributes;
import com.gemstone.gemfire.cache.util.CacheWriterAdapter;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.DMStats;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import dunit.Host;
import dunit.VM;
import java.util.HashMap;
import junit.framework.TestCase;

public class ProxyDUnitTest
extends CacheTestCase {
    private transient Region r;
    private transient DistributedMember otherId;
    protected transient int clInvokeCount;
    protected transient CacheEvent clLastEvent;

    public ProxyDUnitTest(String name) {
        super(name);
    }

    private VM getOtherVm() {
        Host host = Host.getHost(0);
        return host.getVM(0);
    }

    private void initOtherId() {
        VM vm = this.getOtherVm();
        vm.invoke(new CacheSerializableRunnable("Connect"){

            @Override
            public void run2() throws CacheException {
                ProxyDUnitTest.this.getCache();
            }
        });
        this.otherId = (DistributedMember)vm.invoke(ProxyDUnitTest.class, "getVMDistributedMember");
    }

    private void doCreateOtherVm() {
        VM vm = this.getOtherVm();
        vm.invoke(new CacheSerializableRunnable("create root"){

            @Override
            public void run2() throws CacheException {
                AttributesFactory af = new AttributesFactory();
                af.setDataPolicy(DataPolicy.REPLICATE);
                af.setScope(Scope.DISTRIBUTED_ACK);
                ProxyDUnitTest.this.createRootRegion("ProxyDUnitTest", af.create());
            }
        });
    }

    public static DistributedMember getVMDistributedMember() {
        return InternalDistributedSystem.getAnyInstance().getDistributedMember();
    }

    private void distributedOps(DataPolicy dp, InterestPolicy ip) throws CacheException {
        this.initOtherId();
        AttributesFactory af = new AttributesFactory();
        af.setDataPolicy(dp);
        af.setSubscriptionAttributes(new SubscriptionAttributes(ip));
        af.setScope(Scope.DISTRIBUTED_ACK);
        Region r = this.createRootRegion("ProxyDUnitTest", af.create());
        this.doCreateOtherVm();
        r.put((Object)"putkey", (Object)"putvalue1");
        this.getOtherVm().invoke(new CacheSerializableRunnable("check put"){

            @Override
            public void run2() throws CacheException {
                Region r = ProxyDUnitTest.this.getRootRegion("ProxyDUnitTest");
                TestCase.assertEquals((boolean)true, (boolean)r.containsKey((Object)"putkey"));
                TestCase.assertEquals((Object)"putvalue1", (Object)r.getEntry((Object)"putkey").getValue());
                r.put((Object)"putkey", (Object)"putvalue2");
            }
        });
        ProxyDUnitTest.assertEquals((boolean)false, (boolean)r.containsKey((Object)"putkey"));
        ProxyDUnitTest.assertEquals((Object)"putvalue2", (Object)r.get((Object)"putkey"));
        r.invalidate((Object)"putkey");
        this.getOtherVm().invoke(new CacheSerializableRunnable("check invalidate"){

            @Override
            public void run2() throws CacheException {
                Region r = ProxyDUnitTest.this.getRootRegion("ProxyDUnitTest");
                TestCase.assertEquals((boolean)true, (boolean)r.containsKey((Object)"putkey"));
                TestCase.assertEquals(null, (Object)r.getEntry((Object)"putkey").getValue());
            }
        });
        ProxyDUnitTest.assertEquals(null, (Object)r.get((Object)"putkey"));
        r.destroy((Object)"putkey");
        this.getOtherVm().invoke(new CacheSerializableRunnable("check destroy"){

            @Override
            public void run2() throws CacheException {
                Region r = ProxyDUnitTest.this.getRootRegion("ProxyDUnitTest");
                TestCase.assertEquals((boolean)false, (boolean)r.containsKey((Object)"putkey"));
            }
        });
        ProxyDUnitTest.assertEquals(null, (Object)r.get((Object)"putkey"));
        r.create((Object)"createKey", (Object)"createValue1");
        this.getOtherVm().invoke(new CacheSerializableRunnable("check create"){

            @Override
            public void run2() throws CacheException {
                Region r = ProxyDUnitTest.this.getRootRegion("ProxyDUnitTest");
                TestCase.assertEquals((boolean)true, (boolean)r.containsKey((Object)"createKey"));
                TestCase.assertEquals((Object)"createValue1", (Object)r.getEntry((Object)"createKey").getValue());
            }
        });
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("putAllKey1", "putAllValue1");
        m.put("putAllKey2", "putAllValue2");
        r.putAll(m);
        this.getOtherVm().invoke(new CacheSerializableRunnable("check putAll"){

            @Override
            public void run2() throws CacheException {
                Region r = ProxyDUnitTest.this.getRootRegion("ProxyDUnitTest");
                TestCase.assertEquals((boolean)true, (boolean)r.containsKey((Object)"putAllKey1"));
                TestCase.assertEquals((Object)"putAllValue1", (Object)r.getEntry((Object)"putAllKey1").getValue());
                TestCase.assertEquals((boolean)true, (boolean)r.containsKey((Object)"putAllKey2"));
                TestCase.assertEquals((Object)"putAllValue2", (Object)r.getEntry((Object)"putAllKey2").getValue());
            }
        });
        r.clear();
        this.getOtherVm().invoke(new CacheSerializableRunnable("check clear"){

            @Override
            public void run2() throws CacheException {
                Region r = ProxyDUnitTest.this.getRootRegion("ProxyDUnitTest");
                TestCase.assertEquals((int)0, (int)r.size());
            }
        });
        this.getOtherVm().invoke(new CacheSerializableRunnable("install CacheWriter"){

            @Override
            public void run2() throws CacheException {
                Region r = ProxyDUnitTest.this.getRootRegion("ProxyDUnitTest");
                AttributesMutator am = r.getAttributesMutator();
                CacheWriterAdapter cw = new CacheWriterAdapter(){

                    public void beforeCreate(EntryEvent event) throws CacheWriterException {
                        throw new CacheWriterException("expected");
                    }
                };
                am.setCacheWriter((CacheWriter)cw);
            }
        });
        try {
            r.put((Object)"putkey", (Object)"putvalue");
            ProxyDUnitTest.fail((String)"expected CacheWriterException");
        }
        catch (CacheWriterException cacheWriterException) {
            // empty catch block
        }
        this.getOtherVm().invoke(new CacheSerializableRunnable("check clear"){

            @Override
            public void run2() throws CacheException {
                Region r = ProxyDUnitTest.this.getRootRegion("ProxyDUnitTest");
                TestCase.assertEquals((int)0, (int)r.size());
            }
        });
        ProxyDUnitTest.assertEquals(null, (Object)r.get((Object)"loadkey"));
        this.getOtherVm().invoke(new CacheSerializableRunnable("install CacheLoader"){

            @Override
            public void run2() throws CacheException {
                Region r = ProxyDUnitTest.this.getRootRegion("ProxyDUnitTest");
                AttributesMutator am = r.getAttributesMutator();
                am.setCacheWriter(null);
                CacheLoader cl = new CacheLoader(){

                    public Object load(LoaderHelper helper) throws CacheLoaderException {
                        if (helper.getKey().equals("loadkey")) {
                            return "loadvalue";
                        }
                        if (helper.getKey().equals("loadexception")) {
                            throw new CacheLoaderException("expected");
                        }
                        return null;
                    }

                    public void close() {
                    }
                };
                am.setCacheLoader(cl);
            }
        });
        ProxyDUnitTest.assertEquals((Object)"loadvalue", (Object)r.get((Object)"loadkey"));
        ProxyDUnitTest.assertEquals(null, (Object)r.get((Object)"foobar"));
        try {
            r.get((Object)"loadexception");
            ProxyDUnitTest.fail((String)"expected CacheLoaderException");
        }
        catch (CacheLoaderException cacheLoaderException) {
            // empty catch block
        }
        r.destroyRegion();
        this.getOtherVm().invoke(new CacheSerializableRunnable("check clear"){

            @Override
            public void run2() throws CacheException {
                Region r = ProxyDUnitTest.this.getRootRegion("ProxyDUnitTest");
                TestCase.assertEquals(null, (Object)r);
            }
        });
    }

    private DMStats getDMStats() {
        return ((InternalDistributedSystem)this.getCache().getDistributedSystem()).getDistributionManager().getStats();
    }

    private void remoteOriginOps(DataPolicy dp, InterestPolicy ip) throws CacheException {
        this.initOtherId();
        AttributesFactory af = new AttributesFactory();
        af.setDataPolicy(dp);
        af.setSubscriptionAttributes(new SubscriptionAttributes(ip));
        af.setScope(Scope.DISTRIBUTED_ACK);
        CacheListener cl1 = new CacheListener(){

            public void afterUpdate(EntryEvent e) {
                ProxyDUnitTest.this.clLastEvent = e;
                ++ProxyDUnitTest.this.clInvokeCount;
            }

            public void afterCreate(EntryEvent e) {
                ProxyDUnitTest.this.clLastEvent = e;
                ++ProxyDUnitTest.this.clInvokeCount;
            }

            public void afterInvalidate(EntryEvent e) {
                ProxyDUnitTest.this.clLastEvent = e;
                ++ProxyDUnitTest.this.clInvokeCount;
            }

            public void afterDestroy(EntryEvent e) {
                ProxyDUnitTest.this.clLastEvent = e;
                ++ProxyDUnitTest.this.clInvokeCount;
            }

            public void afterRegionInvalidate(RegionEvent e) {
                ProxyDUnitTest.this.clLastEvent = e;
                ++ProxyDUnitTest.this.clInvokeCount;
            }

            public void afterRegionDestroy(RegionEvent e) {
                ProxyDUnitTest.this.clLastEvent = e;
                ++ProxyDUnitTest.this.clInvokeCount;
            }

            public void afterRegionClear(RegionEvent e) {
                ProxyDUnitTest.this.clLastEvent = e;
                ++ProxyDUnitTest.this.clInvokeCount;
            }

            public void afterRegionCreate(RegionEvent e) {
            }

            public void afterRegionLive(RegionEvent e) {
            }

            public void close() {
            }
        };
        af.addCacheListener(cl1);
        Region r = this.createRootRegion("ProxyDUnitTest", af.create());
        this.clInvokeCount = 0;
        this.doCreateOtherVm();
        DMStats stats = this.getDMStats();
        long receivedMsgs = stats.getReceivedMessages();
        if (ip.isAll()) {
            this.getOtherVm().invoke(new CacheSerializableRunnable("do put"){

                @Override
                public void run2() throws CacheException {
                    Region r = ProxyDUnitTest.this.getRootRegion("ProxyDUnitTest");
                    r.put((Object)"p", (Object)"v");
                }
            });
            ProxyDUnitTest.assertEquals((int)1, (int)this.clInvokeCount);
            ProxyDUnitTest.assertEquals((Object)Operation.CREATE, (Object)this.clLastEvent.getOperation());
            ProxyDUnitTest.assertEquals((boolean)true, (boolean)this.clLastEvent.isOriginRemote());
            ProxyDUnitTest.assertEquals((Object)this.otherId, (Object)this.clLastEvent.getDistributedMember());
            ProxyDUnitTest.assertEquals(null, (Object)((EntryEvent)this.clLastEvent).getOldValue());
            ProxyDUnitTest.assertEquals((boolean)false, (boolean)((EntryEvent)this.clLastEvent).isOldValueAvailable());
            ProxyDUnitTest.assertEquals((Object)"v", (Object)((EntryEvent)this.clLastEvent).getNewValue());
            ProxyDUnitTest.assertEquals((Object)"p", (Object)((EntryEvent)this.clLastEvent).getKey());
            this.clInvokeCount = 0;
            this.getOtherVm().invoke(new CacheSerializableRunnable("do create"){

                @Override
                public void run2() throws CacheException {
                    Region r = ProxyDUnitTest.this.getRootRegion("ProxyDUnitTest");
                    r.create((Object)"c", (Object)"v");
                }
            });
            ProxyDUnitTest.assertEquals((int)1, (int)this.clInvokeCount);
            ProxyDUnitTest.assertEquals((Object)Operation.CREATE, (Object)this.clLastEvent.getOperation());
            ProxyDUnitTest.assertEquals((boolean)true, (boolean)this.clLastEvent.isOriginRemote());
            ProxyDUnitTest.assertEquals((Object)this.otherId, (Object)this.clLastEvent.getDistributedMember());
            ProxyDUnitTest.assertEquals(null, (Object)((EntryEvent)this.clLastEvent).getOldValue());
            ProxyDUnitTest.assertEquals((boolean)false, (boolean)((EntryEvent)this.clLastEvent).isOldValueAvailable());
            ProxyDUnitTest.assertEquals((Object)"v", (Object)((EntryEvent)this.clLastEvent).getNewValue());
            ProxyDUnitTest.assertEquals((Object)"c", (Object)((EntryEvent)this.clLastEvent).getKey());
            this.clInvokeCount = 0;
            this.getOtherVm().invoke(new CacheSerializableRunnable("do update"){

                @Override
                public void run2() throws CacheException {
                    Region r = ProxyDUnitTest.this.getRootRegion("ProxyDUnitTest");
                    r.put((Object)"c", (Object)"v2");
                }
            });
            ProxyDUnitTest.assertEquals((int)1, (int)this.clInvokeCount);
            ProxyDUnitTest.assertEquals((Object)Operation.UPDATE, (Object)this.clLastEvent.getOperation());
            ProxyDUnitTest.assertEquals((boolean)true, (boolean)this.clLastEvent.isOriginRemote());
            ProxyDUnitTest.assertEquals((Object)this.otherId, (Object)this.clLastEvent.getDistributedMember());
            ProxyDUnitTest.assertEquals(null, (Object)((EntryEvent)this.clLastEvent).getOldValue());
            ProxyDUnitTest.assertEquals((boolean)false, (boolean)((EntryEvent)this.clLastEvent).isOldValueAvailable());
            ProxyDUnitTest.assertEquals((Object)"v2", (Object)((EntryEvent)this.clLastEvent).getNewValue());
            ProxyDUnitTest.assertEquals((Object)"c", (Object)((EntryEvent)this.clLastEvent).getKey());
            this.clInvokeCount = 0;
            this.getOtherVm().invoke(new CacheSerializableRunnable("do invalidate"){

                @Override
                public void run2() throws CacheException {
                    Region r = ProxyDUnitTest.this.getRootRegion("ProxyDUnitTest");
                    r.invalidate((Object)"c");
                }
            });
            ProxyDUnitTest.assertEquals((int)1, (int)this.clInvokeCount);
            ProxyDUnitTest.assertEquals((Object)Operation.INVALIDATE, (Object)this.clLastEvent.getOperation());
            ProxyDUnitTest.assertEquals((boolean)true, (boolean)this.clLastEvent.isOriginRemote());
            ProxyDUnitTest.assertEquals((Object)this.otherId, (Object)this.clLastEvent.getDistributedMember());
            ProxyDUnitTest.assertEquals(null, (Object)((EntryEvent)this.clLastEvent).getOldValue());
            ProxyDUnitTest.assertEquals((boolean)false, (boolean)((EntryEvent)this.clLastEvent).isOldValueAvailable());
            ProxyDUnitTest.assertEquals(null, (Object)((EntryEvent)this.clLastEvent).getNewValue());
            ProxyDUnitTest.assertEquals((Object)"c", (Object)((EntryEvent)this.clLastEvent).getKey());
            this.clInvokeCount = 0;
            this.getOtherVm().invoke(new CacheSerializableRunnable("do destroy"){

                @Override
                public void run2() throws CacheException {
                    Region r = ProxyDUnitTest.this.getRootRegion("ProxyDUnitTest");
                    r.destroy((Object)"c");
                }
            });
            ProxyDUnitTest.assertEquals((int)1, (int)this.clInvokeCount);
            ProxyDUnitTest.assertEquals((Object)Operation.DESTROY, (Object)this.clLastEvent.getOperation());
            ProxyDUnitTest.assertEquals((boolean)true, (boolean)this.clLastEvent.isOriginRemote());
            ProxyDUnitTest.assertEquals((Object)this.otherId, (Object)this.clLastEvent.getDistributedMember());
            ProxyDUnitTest.assertEquals(null, (Object)((EntryEvent)this.clLastEvent).getOldValue());
            ProxyDUnitTest.assertEquals((boolean)false, (boolean)((EntryEvent)this.clLastEvent).isOldValueAvailable());
            ProxyDUnitTest.assertEquals(null, (Object)((EntryEvent)this.clLastEvent).getNewValue());
            ProxyDUnitTest.assertEquals((Object)"c", (Object)((EntryEvent)this.clLastEvent).getKey());
            this.clInvokeCount = 0;
            this.getOtherVm().invoke(new CacheSerializableRunnable("do putAll"){

                @Override
                public void run2() throws CacheException {
                    Region r = ProxyDUnitTest.this.getRootRegion("ProxyDUnitTest");
                    HashMap<String, String> m = new HashMap<String, String>();
                    m.put("putAllKey1", "putAllValue1");
                    m.put("putAllKey2", "putAllValue2");
                    r.putAll(m);
                }
            });
            ProxyDUnitTest.assertEquals((int)2, (int)this.clInvokeCount);
            this.clInvokeCount = 0;
            this.getOtherVm().invoke(new CacheSerializableRunnable("do netsearch"){

                @Override
                public void run2() throws CacheException {
                    Region r = ProxyDUnitTest.this.getRootRegion("ProxyDUnitTest");
                    TestCase.assertEquals(null, (Object)r.get((Object)"loadkey"));
                }
            });
            ProxyDUnitTest.assertEquals((int)0, (int)this.clInvokeCount);
        } else {
            this.getOtherVm().invoke(new CacheSerializableRunnable("do entry ops"){

                @Override
                public void run2() throws CacheException {
                    Region r = ProxyDUnitTest.this.getRootRegion("ProxyDUnitTest");
                    r.put((Object)"p", (Object)"v");
                    r.create((Object)"c", (Object)"v");
                    r.put((Object)"c", (Object)"v");
                    r.invalidate((Object)"c");
                    r.destroy((Object)"c");
                    HashMap<String, String> m = new HashMap<String, String>();
                    m.put("putAllKey1", "putAllValue1");
                    m.put("putAllKey2", "putAllValue2");
                    r.putAll(m);
                    TestCase.assertEquals(null, (Object)r.get((Object)"loadkey"));
                }
            });
            ProxyDUnitTest.assertEquals((int)0, (int)this.clInvokeCount);
            ProxyDUnitTest.assertEquals((int)0, (int)r.size());
            ProxyDUnitTest.assertEquals((long)receivedMsgs, (long)stats.getReceivedMessages());
        }
        AttributesMutator am = r.getAttributesMutator();
        CacheLoader cl = new CacheLoader(){

            public Object load(LoaderHelper helper) throws CacheLoaderException {
                if (helper.getKey().equals("loadkey")) {
                    return "loadvalue";
                }
                if (helper.getKey().equals("loadexception")) {
                    throw new CacheLoaderException("expected");
                }
                return null;
            }

            public void close() {
            }
        };
        am.setCacheLoader(cl);
        receivedMsgs = stats.getReceivedMessages();
        this.getOtherVm().invoke(new CacheSerializableRunnable("check net loader"){

            @Override
            public void run2() throws CacheException {
                Region r = ProxyDUnitTest.this.getRootRegion("ProxyDUnitTest");
                TestCase.assertEquals((Object)"loadvalue", (Object)r.get((Object)"loadkey"));
                TestCase.assertEquals(null, (Object)r.get((Object)"foobar"));
                try {
                    r.get((Object)"loadexception");
                    TestCase.fail((String)"expected CacheLoaderException");
                }
                catch (CacheLoaderException cacheLoaderException) {
                    // empty catch block
                }
            }
        });
        ProxyDUnitTest.assertTrue((stats.getReceivedMessages() > receivedMsgs ? 1 : 0) != 0);
        if (ip.isAll()) {
            ProxyDUnitTest.assertEquals((int)1, (int)this.clInvokeCount);
            ProxyDUnitTest.assertEquals((Object)Operation.NET_LOAD_CREATE, (Object)this.clLastEvent.getOperation());
            ProxyDUnitTest.assertEquals((boolean)true, (boolean)this.clLastEvent.isOriginRemote());
            ProxyDUnitTest.assertEquals((Object)this.otherId, (Object)this.clLastEvent.getDistributedMember());
            ProxyDUnitTest.assertEquals(null, (Object)((EntryEvent)this.clLastEvent).getOldValue());
            ProxyDUnitTest.assertEquals((boolean)false, (boolean)((EntryEvent)this.clLastEvent).isOldValueAvailable());
            this.clInvokeCount = 0;
        } else {
            ProxyDUnitTest.assertEquals((int)0, (int)this.clInvokeCount);
        }
        am = r.getAttributesMutator();
        am.setCacheLoader(null);
        CacheWriterAdapter cw = new CacheWriterAdapter(){

            public void beforeCreate(EntryEvent event) throws CacheWriterException {
                throw new CacheWriterException("expected");
            }
        };
        am.setCacheWriter((CacheWriter)cw);
        receivedMsgs = stats.getReceivedMessages();
        this.getOtherVm().invoke(new CacheSerializableRunnable("check net write"){

            @Override
            public void run2() throws CacheException {
                Region r = ProxyDUnitTest.this.getRootRegion("ProxyDUnitTest");
                try {
                    r.put((Object)"putkey", (Object)"putvalue");
                    TestCase.fail((String)"expected CacheWriterException");
                }
                catch (CacheWriterException cacheWriterException) {
                    // empty catch block
                }
            }
        });
        ProxyDUnitTest.assertTrue((stats.getReceivedMessages() > receivedMsgs ? 1 : 0) != 0);
        am = r.getAttributesMutator();
        am.setCacheWriter(null);
        ProxyDUnitTest.assertEquals((int)0, (int)this.clInvokeCount);
        this.clLastEvent = null;
        this.getOtherVm().invoke(new CacheSerializableRunnable("check region invalidate"){

            @Override
            public void run2() throws CacheException {
                Region r = ProxyDUnitTest.this.getRootRegion("ProxyDUnitTest");
                r.invalidateRegion();
            }
        });
        ProxyDUnitTest.assertEquals((int)1, (int)this.clInvokeCount);
        ProxyDUnitTest.assertEquals((Object)Operation.REGION_INVALIDATE, (Object)this.clLastEvent.getOperation());
        ProxyDUnitTest.assertEquals((boolean)true, (boolean)this.clLastEvent.isOriginRemote());
        ProxyDUnitTest.assertEquals((Object)this.otherId, (Object)this.clLastEvent.getDistributedMember());
        this.clLastEvent = null;
        this.getOtherVm().invoke(new CacheSerializableRunnable("check region clear"){

            @Override
            public void run2() throws CacheException {
                Region r = ProxyDUnitTest.this.getRootRegion("ProxyDUnitTest");
                r.clear();
            }
        });
        ProxyDUnitTest.assertEquals((int)2, (int)this.clInvokeCount);
        ProxyDUnitTest.assertEquals((Object)Operation.REGION_CLEAR, (Object)this.clLastEvent.getOperation());
        ProxyDUnitTest.assertEquals((boolean)true, (boolean)this.clLastEvent.isOriginRemote());
        ProxyDUnitTest.assertEquals((Object)this.otherId, (Object)this.clLastEvent.getDistributedMember());
        this.clLastEvent = null;
        this.getOtherVm().invoke(new CacheSerializableRunnable("check region destroy"){

            @Override
            public void run2() throws CacheException {
                Region r = ProxyDUnitTest.this.getRootRegion("ProxyDUnitTest");
                r.destroyRegion();
            }
        });
        ProxyDUnitTest.assertEquals((int)3, (int)this.clInvokeCount);
        ProxyDUnitTest.assertEquals((Object)Operation.REGION_DESTROY, (Object)this.clLastEvent.getOperation());
        ProxyDUnitTest.assertEquals((boolean)true, (boolean)this.clLastEvent.isOriginRemote());
        ProxyDUnitTest.assertEquals((Object)this.otherId, (Object)this.clLastEvent.getDistributedMember());
        ProxyDUnitTest.assertTrue((boolean)r.isDestroyed());
    }

    public void testDistributedOpsPROXY() throws CacheException {
        this.distributedOps(DataPolicy.EMPTY, InterestPolicy.CACHE_CONTENT);
    }

    public void testRemoteOriginOpsPROXY() throws CacheException {
        this.remoteOriginOps(DataPolicy.EMPTY, InterestPolicy.CACHE_CONTENT);
    }

    public void testRemoteOriginOpsPROXY_ALL() throws CacheException {
        this.remoteOriginOps(DataPolicy.EMPTY, InterestPolicy.ALL);
    }
}

