/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache30;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache30.MultiVMRegionTestCase;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.SerializableRunnable;
import dunit.VM;

public class PreloadedRegionTestCase
extends MultiVMRegionTestCase {
    public PreloadedRegionTestCase(String name) {
        super(name);
    }

    @Override
    protected RegionAttributes getRegionAttributes() {
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_ACK);
        factory.setDataPolicy(DataPolicy.PRELOADED);
        return factory.create();
    }

    public void testDistributedCreate() throws Exception {
        final String rgnName = this.getUniqueName();
        SerializableRunnable create = new SerializableRunnable("testDistributedCreate: Create Region"){

            @Override
            public void run() {
                try {
                    PreloadedRegionTestCase.this.createRegion(rgnName);
                    PreloadedRegionTestCase.this.getSystem().getLogWriter().info("testDistributedCreate: Created Region");
                }
                catch (CacheException e) {
                    DistributedTestCase.fail("While creating region", e);
                }
            }
        };
        SerializableRunnable newKey = new SerializableRunnable("testDistributedCreate: Create Key"){

            @Override
            public void run() {
                try {
                    Region root = PreloadedRegionTestCase.this.getRootRegion("root");
                    Region rgn = root.getSubregion(rgnName);
                    rgn.create((Object)"key", null);
                    PreloadedRegionTestCase.this.getSystem().getLogWriter().info("testDistributedCReate: Created Key");
                }
                catch (CacheException e) {
                    DistributedTestCase.fail("While creating region", e);
                }
            }
        };
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        vm0.invoke(create);
        Region rgn = this.createRegion(rgnName);
        vm0.invoke(newKey);
        PreloadedRegionTestCase.assertTrue((rgn.getEntry((Object)"key") == null ? 1 : 0) != 0);
    }
}

