/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache30;

import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.Delta;
import com.gemstone.gemfire.Instantiator;
import com.gemstone.gemfire.InvalidDeltaException;
import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.AttributesMutator;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.CacheLoader;
import com.gemstone.gemfire.cache.CacheLoaderException;
import com.gemstone.gemfire.cache.CacheTransactionManager;
import com.gemstone.gemfire.cache.CacheWriter;
import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.EntryExistsException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.ExpirationAction;
import com.gemstone.gemfire.cache.ExpirationAttributes;
import com.gemstone.gemfire.cache.InterestPolicy;
import com.gemstone.gemfire.cache.LoaderHelper;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionEvent;
import com.gemstone.gemfire.cache.RegionFactory;
import com.gemstone.gemfire.cache.RegionShortcut;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.SubscriptionAttributes;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.cache.TransactionEvent;
import com.gemstone.gemfire.cache.TransactionId;
import com.gemstone.gemfire.cache.TransactionListener;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.cache.util.GatewayHub;
import com.gemstone.gemfire.cache30.CacheSerializableRunnable;
import com.gemstone.gemfire.cache30.CacheTestCase;
import com.gemstone.gemfire.cache30.RegionTestCase;
import com.gemstone.gemfire.cache30.TestCacheListener;
import com.gemstone.gemfire.cache30.TestCacheLoader;
import com.gemstone.gemfire.cache30.TestCacheWriter;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.DMStats;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.AvailablePortHelper;
import com.gemstone.gemfire.internal.HeapDataOutputStream;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.InternalInstantiator;
import com.gemstone.gemfire.internal.cache.CacheDistributionAdvisor;
import com.gemstone.gemfire.internal.cache.CachedDeserializableFactory;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.InitialImageOperation;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.RegionEntryContext;
import com.gemstone.gemfire.internal.cache.TXId;
import com.gemstone.gemfire.internal.cache.TXManagerImpl;
import com.gemstone.gemfire.internal.cache.Token;
import com.gemstone.gemfire.internal.cache.TombstoneService;
import com.gemstone.gemfire.internal.cache.delta.AbstractDelta;
import com.gemstone.gemfire.internal.cache.versions.RegionVersionHolder;
import com.gemstone.gemfire.internal.cache.versions.RegionVersionVector;
import com.gemstone.gemfire.internal.cache.versions.VMRegionVersionVector;
import com.gemstone.gemfire.internal.cache.versions.VersionSource;
import com.gemstone.gemfire.internal.cache.versions.VersionTag;
import com.gemstone.gemfire.internal.offheap.MemoryChunkWithRefCount;
import com.gemstone.gemfire.internal.offheap.SimpleMemoryAllocatorImpl;
import com.gemstone.gemfire.internal.shared.Version;
import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import dunit.GemFireSystem;
import dunit.Host;
import dunit.RMIException;
import dunit.SerializableCallable;
import dunit.SerializableRunnable;
import dunit.VM;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.LinkedBlockingQueue;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;

public abstract class MultiVMRegionTestCase
extends RegionTestCase {
    Properties props = new Properties();
    final int putRange_1Start = 1;
    final int putRange_1End = 5;
    final int putRange_2Start = 6;
    final int putRange_2End = 10;
    final int putRange_3Start = 11;
    final int putRange_3End = 15;
    final int putRange_4Start = 16;
    final int putRange_4End = 20;
    final int removeRange_1Start = 2;
    final int removeRange_1End = 4;
    final int removeRange_2Start = 7;
    final int removeRange_2End = 9;
    private static final int CHUNK_SIZE = 512000;
    private static final int NUM_ENTRIES = 100;
    private static final int VALUE_SIZE = 51200;
    static TestCacheListener destroyListener = null;
    private static final int NB1_CHUNK_SIZE = 512000;
    private static final int NB1_NUM_ENTRIES = 1000;
    private static final int NB1_VALUE_SIZE = 5120;
    public static LocalRegion CCRegion;
    static GatewayHub hub;
    static int distributedSystemID;
    static int afterCreates;

    public MultiVMRegionTestCase(String name) {
        super(name);
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        DistributedTestCase.cleanupAllVms();
        CCRegion = null;
        hub = null;
    }

    public void testConcurrentOperations() throws Exception {
        CacheSerializableRunnable createRegion = new CacheSerializableRunnable("createRegion"){

            @Override
            public void run2() throws CacheException {
                Cache cache = MultiVMRegionTestCase.this.getCache();
                RegionAttributes regionAttribs = MultiVMRegionTestCase.this.getRegionAttributes();
                cache.createRegion("R1", regionAttribs);
            }
        };
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        vm0.invoke(createRegion);
        vm1.invoke(createRegion);
        vm2.invoke(createRegion);
        vm3.invoke(createRegion);
        this.concurrentMapTest("/R1");
    }

    public void concurrentMapTest(final String rName) {
        VM vm0 = Host.getHost(0).getVM(0);
        vm0.invoke(new CacheSerializableRunnable("doConcurrentMapOperations"){

            @Override
            public void run2() throws CacheException {
                int i;
                Cache cache = MultiVMRegionTestCase.this.getCache();
                Region pr = cache.getRegion(rName);
                TestCase.assertNotNull((String)(rName + " not created"), (Object)pr);
                for (int i2 = 1; i2 <= 5; ++i2) {
                    Object putResult = pr.putIfAbsent((Object)Integer.toString(i2), (Object)Integer.toString(i2));
                    TestCase.assertNull((String)("Expected null, but got " + putResult + " for key " + i2), (Object)putResult);
                }
                int size = pr.size();
                TestCase.assertEquals((String)"Size doesn't return expected value", (int)5, (int)size);
                TestCase.assertFalse((String)"isEmpty doesnt return proper state of the region", (boolean)pr.isEmpty());
                for (i = 1; i <= 5; ++i) {
                    Object putResult = pr.putIfAbsent((Object)Integer.toString(i), (Object)Integer.toString(i + 1));
                    TestCase.assertEquals((String)("for i=" + i), (Object)Integer.toString(i), (Object)putResult);
                    TestCase.assertEquals((String)("for i=" + i), (Object)Integer.toString(i), (Object)pr.get((Object)Integer.toString(i)));
                }
                size = pr.size();
                TestCase.assertEquals((String)"Size doesn't return expected value", (int)5, (int)size);
                TestCase.assertFalse((String)"isEmpty doesnt return proper state of the region", (boolean)pr.isEmpty());
                for (i = 1; i <= 5; ++i) {
                    boolean replaceSucceeded = pr.replace((Object)Integer.toString(i), (Object)Integer.toString(i), (Object)("replaced" + i));
                    TestCase.assertTrue((String)("for i=" + i), (boolean)replaceSucceeded);
                    TestCase.assertEquals((String)("for i=" + i), (Object)("replaced" + i), (Object)pr.get((Object)Integer.toString(i)));
                }
                size = pr.size();
                TestCase.assertEquals((String)"Size doesn't return expected value", (int)5, (int)size);
                TestCase.assertFalse((String)"isEmpty doesnt return proper state of the region", (boolean)pr.isEmpty());
                for (i = 1; i <= 10; ++i) {
                    boolean replaceSucceeded = pr.replace((Object)Integer.toString(i), (Object)Integer.toString(i), (Object)("not" + i));
                    TestCase.assertFalse((String)("for i=" + i), (boolean)replaceSucceeded);
                    TestCase.assertEquals((String)("for i=" + i), i <= 5 ? "replaced" + i : null, (Object)pr.get((Object)Integer.toString(i)));
                }
                size = pr.size();
                TestCase.assertEquals((String)"Size doesn't return expected value", (int)5, (int)size);
                TestCase.assertFalse((String)"isEmpty doesnt return proper state of the region", (boolean)pr.isEmpty());
                for (i = 1; i <= 5; ++i) {
                    Object replaceResult = pr.replace((Object)Integer.toString(i), (Object)("twice replaced" + i));
                    TestCase.assertEquals((String)("for i=" + i), (Object)("replaced" + i), (Object)replaceResult);
                    TestCase.assertEquals((String)("for i=" + i), (Object)("twice replaced" + i), (Object)pr.get((Object)Integer.toString(i)));
                }
                size = pr.size();
                TestCase.assertEquals((String)"Size doesn't return expected value", (int)5, (int)size);
                TestCase.assertFalse((String)"isEmpty doesnt return proper state of the region", (boolean)pr.isEmpty());
                for (i = 6; i <= 10; ++i) {
                    Object replaceResult = pr.replace((Object)Integer.toString(i), (Object)("thrice replaced" + i));
                    TestCase.assertNull((String)("for i=" + i), (Object)replaceResult);
                    TestCase.assertNull((String)("for i=" + i), (Object)pr.get((Object)Integer.toString(i)));
                }
                size = pr.size();
                TestCase.assertEquals((String)"Size doesn't return expected value", (int)5, (int)size);
                TestCase.assertFalse((String)"isEmpty doesnt return proper state of the region", (boolean)pr.isEmpty());
                for (i = 1; i <= 10; ++i) {
                    boolean removeResult = pr.remove((Object)Integer.toString(i), (Object)Integer.toString(-i));
                    TestCase.assertFalse((String)("for i=" + i), (boolean)removeResult);
                    TestCase.assertEquals((String)("for i=" + i), i <= 5 ? "twice replaced" + i : null, (Object)pr.get((Object)Integer.toString(i)));
                }
                size = pr.size();
                TestCase.assertEquals((String)"Size doesn't return expected value", (int)5, (int)size);
                TestCase.assertFalse((String)"isEmpty doesnt return proper state of the region", (boolean)pr.isEmpty());
                for (i = 1; i <= 5; ++i) {
                    boolean removeResult = pr.remove((Object)Integer.toString(i), (Object)("twice replaced" + i));
                    TestCase.assertTrue((String)("for i=" + i), (boolean)removeResult);
                    TestCase.assertEquals((String)("for i=" + i), null, (Object)pr.get((Object)Integer.toString(i)));
                }
                size = pr.size();
                TestCase.assertEquals((String)"Size doesn't return expected value", (int)0, (int)size);
                TestCase.assertTrue((String)"isEmpty doesnt return proper state of the region", (boolean)pr.isEmpty());
            }
        });
        vm0.invoke(new CacheSerializableRunnable("destroyRegionOp"){

            @Override
            public void run2() {
                Cache cache = MultiVMRegionTestCase.this.getCache();
                Region pr = cache.getRegion(rName);
                TestCase.assertNotNull((String)"Region already destroyed.", (Object)pr);
                pr.destroyRegion();
                TestCase.assertTrue((String)"Region isDestroyed false", (boolean)pr.isDestroyed());
                TestCase.assertNull((String)"Region not destroyed.", (Object)cache.getRegion(rName));
            }
        });
    }

    public void testDistributedUpdate() {
        MultiVMRegionTestCase.assertTrue((boolean)this.getRegionAttributes().getScope().isDistributed());
        final String name = this.getUniqueName();
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create Region"){

            @Override
            public void run2() throws CacheException {
                MultiVMRegionTestCase.this.createRegion(name);
            }
        };
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        vm0.invoke(create);
        vm1.invoke(create);
        final String key = "KEY";
        final String oldValue = "OLD_VALUE";
        final String newValue = "NEW_VALUE";
        CacheSerializableRunnable put = new CacheSerializableRunnable("Put key/value"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                region.put(key, oldValue);
            }
        };
        vm0.invoke(put);
        vm1.invoke(put);
        this.pauseIfNecessary();
        vm0.invoke(new CacheSerializableRunnable("Update"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                region.put(key, newValue);
            }
        });
        this.pauseIfNecessary();
        vm1.invoke(new CacheSerializableRunnable("Validate update"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                Region.Entry entry = region.getEntry(key);
                TestCase.assertNotNull((Object)entry);
                TestCase.assertEquals((Object)newValue, (Object)entry.getValue());
            }
        });
    }

    public void _ttestOrderedUpdates() throws Throwable {
        if (this.getRegionAttributes().getScope() == Scope.DISTRIBUTED_NO_ACK) {
            return;
        }
        final String name = this.getUniqueName();
        final String key = "KEY";
        int lastNumber = 10;
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create region entry"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.createRegion(name);
                region.create(key, null);
            }
        };
        vm0.invoke(create);
        vm1.invoke(create);
        vm1.invoke(new CacheSerializableRunnable("Set listener"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                region.setUserAttribute(new LinkedBlockingQueue());
                region.getAttributesMutator().addCacheListener((CacheListener)new CacheListenerAdapter(){

                    public void afterUpdate(EntryEvent e) {
                        Region region2 = e.getRegion();
                        LinkedBlockingQueue queue = (LinkedBlockingQueue)region2.getUserAttribute();
                        Object value = e.getNewValue();
                        TestCase.assertNotNull((Object)value);
                        try {
                            DistributedTestCase.getLogWriter().info("++ Adding " + value);
                            queue.put(value);
                        }
                        catch (InterruptedException ex) {
                            DistributedTestCase.fail("Why was I interrupted?", ex);
                        }
                    }
                });
            }
        });
        AsyncInvocation ai1 = vm1.invokeAsync(new CacheSerializableRunnable("Verify"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                LinkedBlockingQueue queue = (LinkedBlockingQueue)region.getUserAttribute();
                for (int i = 0; i <= 10; ++i) {
                    try {
                        DistributedTestCase.getLogWriter().info("++ Waiting for " + i);
                        Integer value = (Integer)queue.take();
                        DistributedTestCase.getLogWriter().info("++ Got " + value);
                        TestCase.assertEquals((int)i, (int)value);
                        continue;
                    }
                    catch (InterruptedException ex) {
                        DistributedTestCase.fail("Why was I interrupted?", ex);
                    }
                }
            }
        });
        this.pauseIfNecessary();
        AsyncInvocation ai0 = vm0.invokeAsync(new CacheSerializableRunnable("Populate"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                for (int i = 0; i <= 10; ++i) {
                    region.put(key, (Object)new Integer(i));
                }
            }
        });
        DistributedTestCase.join(ai0, 30000L, MultiVMRegionTestCase.getLogWriter());
        DistributedTestCase.join(ai1, 30000L, MultiVMRegionTestCase.getLogWriter());
        if (ai0.exceptionOccurred()) {
            MultiVMRegionTestCase.fail("ai0 failed", ai0.getException());
        } else if (ai1.exceptionOccurred()) {
            MultiVMRegionTestCase.fail("ai1 failed", ai1.getException());
        }
    }

    public void testDistributedGet() {
        MultiVMRegionTestCase.assertTrue((boolean)this.getRegionAttributes().getScope().isDistributed());
        final String name = this.getUniqueName();
        final String key = "KEY";
        final String value = "VALUE";
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        vm0.invoke(new CacheSerializableRunnable("Populate region"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.createRegion(name);
                region.put(key, value);
            }
        });
        CacheSerializableRunnable get = new CacheSerializableRunnable("Distributed get"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.createRegion(name);
                TestCase.assertEquals((Object)value, (Object)region.get(key));
            }
        };
        vm1.invoke(get);
    }

    public void testDistributedPutNoUpdate() throws InterruptedException {
        MultiVMRegionTestCase.assertTrue((boolean)this.getRegionAttributes().getScope().isDistributed());
        final String name = this.getUniqueName();
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create Region"){

            @Override
            public void run2() throws CacheException {
                MultiVMRegionTestCase.this.createRegion(name);
            }
        };
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        vm0.invoke(create);
        vm1.invoke(create);
        Thread.sleep(250L);
        final String key = "KEY";
        final String value = "VALUE";
        vm0.invoke(new CacheSerializableRunnable("Put key/value"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                region.put(key, value);
            }
        });
        Thread.sleep(250L);
        vm1.invoke(new CacheSerializableRunnable("Verify no update"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                Region.Entry entry = region.getEntry(key);
                if (MultiVMRegionTestCase.this.getRegionAttributes().getDataPolicy().withReplication() || MultiVMRegionTestCase.this.getRegionAttributes().getPartitionAttributes() != null) {
                    TestCase.assertEquals((Object)value, (Object)region.get(key));
                } else {
                    TestCase.assertNull((Object)entry);
                }
            }
        });
    }

    public void testDefinedEntryUpdated() {
        final String name = this.getUniqueName();
        final String key = "KEY";
        final String oldValue = "OLD_VALUE";
        final String newValue = "NEW_VALUE";
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create Region"){

            @Override
            public void run2() throws CacheException {
                MultiVMRegionTestCase.this.createRegion(name);
            }
        };
        vm0.invoke(create);
        vm1.invoke(create);
        vm0.invoke(new CacheSerializableRunnable("Create and populate"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                region.put(key, oldValue);
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Define entry"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                if (!MultiVMRegionTestCase.this.getRegionAttributes().getDataPolicy().withReplication()) {
                    region.create(key, null);
                }
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Update entry"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                region.put(key, newValue);
            }
        });
        this.invokeRepeatingIfNecessary(vm1, new CacheSerializableRunnable("Get entry"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                TestCase.assertEquals((Object)newValue, (Object)region.get(key));
            }
        });
    }

    public void testDistributedDestroy() throws InterruptedException {
        MultiVMRegionTestCase.assertTrue((boolean)this.getRegionAttributes().getScope().isDistributed());
        final String name = this.getUniqueName();
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create Region"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.createRegion(name);
                TestCase.assertTrue((!region.isDestroyed() ? 1 : 0) != 0);
                Region root = region.getParentRegion();
                TestCase.assertTrue((!root.isDestroyed() ? 1 : 0) != 0);
            }
        };
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        vm0.invoke(create);
        vm1.invoke(create);
        vm2.invoke(create);
        Thread.sleep(250L);
        final String key = "KEY";
        final String value = "VALUE";
        CacheSerializableRunnable put = new CacheSerializableRunnable("Put key/value"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                region.put(key, value);
                TestCase.assertTrue((!region.isDestroyed() ? 1 : 0) != 0);
                TestCase.assertTrue((!region.getParentRegion().isDestroyed() ? 1 : 0) != 0);
            }
        };
        vm0.invoke(put);
        vm1.invoke(put);
        vm2.invoke(put);
        CacheSerializableRunnable verifyPut = new CacheSerializableRunnable("Verify Put"){

            @Override
            public void run2() throws CacheException {
                Region root = MultiVMRegionTestCase.this.getRootRegion();
                TestCase.assertTrue((!root.isDestroyed() ? 1 : 0) != 0);
                Region region = root.getSubregion(name);
                TestCase.assertTrue((!region.isDestroyed() ? 1 : 0) != 0);
                TestCase.assertEquals((Object)value, (Object)region.getEntry(key).getValue());
            }
        };
        vm0.invoke(verifyPut);
        vm1.invoke(verifyPut);
        vm2.invoke(verifyPut);
        this.pauseIfNecessary(500);
        vm0.invoke(new CacheSerializableRunnable("Destroy Entry"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                region.destroy(key);
            }
        });
        CacheSerializableRunnable verifyDestroy = new CacheSerializableRunnable("Verify entry destruction"){

            @Override
            public void run2() throws CacheException {
                Region root = MultiVMRegionTestCase.this.getRootRegion();
                TestCase.assertTrue((!root.isDestroyed() ? 1 : 0) != 0);
                Region region = root.getSubregion(name);
                TestCase.assertTrue((!region.isDestroyed() ? 1 : 0) != 0);
                TestCase.assertNull((Object)region.getEntry(key));
            }
        };
        this.invokeRepeatingIfNecessary(vm0, verifyDestroy);
        this.invokeRepeatingIfNecessary(vm1, verifyDestroy);
        this.invokeRepeatingIfNecessary(vm2, verifyDestroy);
    }

    public void testDistributedRegionDestroy() throws InterruptedException {
        MultiVMRegionTestCase.assertTrue((boolean)this.getRegionAttributes().getScope().isDistributed());
        final String name = this.getUniqueName();
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create Region"){

            @Override
            public void run2() throws CacheException {
                MultiVMRegionTestCase.this.createRegion(name);
            }
        };
        MultiVMRegionTestCase.invokeInEveryVM(create);
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        vm0.invoke(new CacheSerializableRunnable("Destroy Region"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                region.destroyRegion();
            }
        });
        this.pauseIfNecessary(400);
        MultiVMRegionTestCase.invokeInEveryVM(new CacheSerializableRunnable("Verify region destruction"){

            @Override
            public void run2() throws CacheException {
                DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        return MultiVMRegionTestCase.this.getRootRegion().getSubregion(name) == null;
                    }

                    @Override
                    public String description() {
                        return "Waiting for region " + name + " to be destroyed";
                    }
                };
                DistributedTestCase.waitForCriterion(ev, 10000L, 200L, true);
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                TestCase.assertNull((Object)region);
            }
        });
    }

    public void testLocalDestroy() throws InterruptedException {
        if (!this.supportsLocalDestroyAndLocalInvalidate()) {
            return;
        }
        if (this.getRegionAttributes().getDataPolicy().withPersistence()) {
            return;
        }
        MultiVMRegionTestCase.assertTrue((boolean)this.getRegionAttributes().getScope().isDistributed());
        final String name = this.getUniqueName();
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create Region"){

            @Override
            public void run2() throws CacheException {
                MultiVMRegionTestCase.this.createRegion(name);
            }
        };
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        vm0.invoke(create);
        vm1.invoke(create);
        Thread.sleep(250L);
        final String key = "KEY";
        final String value = "VALUE";
        CacheSerializableRunnable put = new CacheSerializableRunnable("Put key/value"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                region.put(key, value);
            }
        };
        vm0.invoke(put);
        vm1.invoke(put);
        Thread.sleep(250L);
        vm0.invoke(new CacheSerializableRunnable("Local Destroy Entry"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                region.localDestroy(key);
            }
        });
        Thread.sleep(250L);
        CacheSerializableRunnable verify = new CacheSerializableRunnable("Verify entry existence"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                TestCase.assertNotNull((Object)region.getEntry(key));
            }
        };
        vm1.invoke(verify);
    }

    public void testLocalRegionDestroy() throws InterruptedException {
        MultiVMRegionTestCase.assertTrue((boolean)this.getRegionAttributes().getScope().isDistributed());
        final String name = this.getUniqueName();
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create Region"){

            @Override
            public void run2() throws CacheException {
                MultiVMRegionTestCase.this.createRegion(name);
            }
        };
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        vm0.invoke(create);
        vm1.invoke(create);
        Thread.sleep(250L);
        vm0.invoke(new CacheSerializableRunnable("Local Destroy Region"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                region.localDestroyRegion();
            }
        });
        Thread.sleep(250L);
        CacheSerializableRunnable verify = new CacheSerializableRunnable("Verify region existence"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                TestCase.assertNotNull((Object)region);
            }
        };
        vm1.invoke(verify);
    }

    public void testDistributedInvalidate() {
        MultiVMRegionTestCase.assertTrue((boolean)this.getRegionAttributes().getScope().isDistributed());
        final String name = this.getUniqueName();
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create Region"){

            @Override
            public void run2() throws CacheException {
                MultiVMRegionTestCase.this.createRegion(name);
            }
        };
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        vm0.invoke(create);
        vm1.invoke(create);
        vm2.invoke(create);
        final String key = "KEY";
        final String value = "VALUE";
        CacheSerializableRunnable put = new CacheSerializableRunnable("Put key/value"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                region.put(key, value);
            }
        };
        vm0.invoke(put);
        vm1.invoke(put);
        vm2.invoke(put);
        this.pauseIfNecessary(500);
        vm0.invoke(new CacheSerializableRunnable("Invalidate Entry"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                region.invalidate(key);
            }
        });
        CacheSerializableRunnable verify = new CacheSerializableRunnable("Verify entry invalidation"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                Region.Entry entry = region.getEntry(key);
                TestCase.assertNotNull((Object)entry);
                if (entry.getValue() != null) {
                    DistributedTestCase.getLogWriter().fine("invalidated entry has value of " + entry.getValue());
                }
                TestCase.assertNull((Object)entry.getValue());
            }
        };
        this.invokeRepeatingIfNecessary(vm1, verify);
        this.invokeRepeatingIfNecessary(vm2, verify);
    }

    public void testDistributedInvalidate4() throws InterruptedException {
        MultiVMRegionTestCase.assertTrue((boolean)this.getRegionAttributes().getScope().isDistributed());
        final String name = this.getUniqueName();
        final String key = "KEY";
        final String value = "VALUE";
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create Region"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.createRegion(name);
                region.put(key, value);
            }
        };
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        HashSet<GemFireSystem> systems = new HashSet<GemFireSystem>();
        vm0.invoke(create);
        systems.add(vm0.getSystem());
        int vmCount = host.getVMCount();
        for (int i = 1; i < vmCount; ++i) {
            VM vm = host.getVM(i);
            vm.invoke(create);
        }
        Thread.sleep(250L);
        CacheSerializableRunnable invalidate = new CacheSerializableRunnable("Invalidate Entry"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                region.invalidate(key);
            }
        };
        for (int i = 0; i < vmCount; ++i) {
            VM vm = host.getVM(i);
            vm.invoke(invalidate);
        }
        CacheSerializableRunnable verify = new CacheSerializableRunnable("Verify entry invalidation"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                Region.Entry entry = region.getEntry(key);
                TestCase.assertNotNull((Object)entry);
                TestCase.assertNull((Object)entry.getValue());
            }
        };
        for (int i = 0; i < vmCount; ++i) {
            VM vm = host.getVM(i);
            vm.invoke(verify);
        }
        this.pauseIfNecessary(2500);
        MultiVMRegionTestCase.getLogWriter().info("Tearing down...");
    }

    public void testDistributedRegionInvalidate() throws InterruptedException {
        if (!this.supportsSubregions()) {
            return;
        }
        final String name = this.getUniqueName();
        String subname = "sub";
        final boolean useSubs = this.getRegionAttributes().getPartitionAttributes() == null;
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create Region"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.createRegion(name);
                if (useSubs) {
                    region.createSubregion("sub", region.getAttributes());
                }
            }
        };
        MultiVMRegionTestCase.invokeInEveryVM(create);
        final String key = "KEY";
        final String value = "VALUE";
        final String key2 = "KEY2";
        final String value2 = "VALUE2";
        CacheSerializableRunnable put = new CacheSerializableRunnable("Put key/value"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                region.put(key, value);
                region.put(key2, value2);
                if (useSubs) {
                    Region subregion = region.getSubregion("sub");
                    subregion.put(key, value);
                    subregion.put(key2, value2);
                }
            }
        };
        MultiVMRegionTestCase.invokeInEveryVM(put);
        this.pauseIfNecessary(1000);
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        vm0.invoke(new CacheSerializableRunnable("Invalidate Region"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                region.invalidateRegion();
            }
        });
        CacheSerializableRunnable verify = new CacheSerializableRunnable("Verify region invalidation"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                Region.Entry entry = region.getEntry(key);
                TestCase.assertNotNull((Object)entry);
                Object v = entry.getValue();
                TestCase.assertNull((String)("Expected null but was " + v), (Object)v);
                entry = region.getEntry(key2);
                TestCase.assertNotNull((Object)entry);
                TestCase.assertNull((Object)entry.getValue());
                if (useSubs) {
                    Region subregion = region.getSubregion("sub");
                    Region.Entry entry2 = subregion.getEntry(key);
                    TestCase.assertNotNull((Object)entry2);
                    TestCase.assertNull((Object)entry2.getValue());
                    entry2 = subregion.getEntry(key2);
                    TestCase.assertNotNull((Object)entry2);
                    TestCase.assertNull((Object)entry2.getValue());
                }
            }
        };
        this.invokeInEveryVMRepeatingIfNecessary(verify);
    }

    public void testRemoteCacheListener() throws InterruptedException {
        MultiVMRegionTestCase.assertTrue((boolean)this.getRegionAttributes().getScope().isDistributed());
        final String name = this.getUniqueName();
        final String key = "KEY";
        final String oldValue = "OLD_VALUE";
        final String newValue = "NEW_VALUE";
        CacheSerializableRunnable populate = new CacheSerializableRunnable("Create Region and Put"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.createRegion(name);
                region.put(key, oldValue);
            }
        };
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        vm0.invoke(populate);
        vm1.invoke(populate);
        vm1.invoke(new CacheSerializableRunnable("Set listener"){

            @Override
            public void run2() throws CacheException {
                final Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                RegionTestCase.listener = new TestCacheListener(){

                    @Override
                    public void afterUpdate2(EntryEvent event) {
                        TestCase.assertEquals((Object)Operation.UPDATE, (Object)event.getOperation());
                        TestCase.assertEquals((Object)region, (Object)event.getRegion());
                        TestCase.assertTrue((boolean)event.getOperation().isDistributed());
                        TestCase.assertFalse((boolean)event.getOperation().isExpiration());
                        TestCase.assertTrue((boolean)event.isOriginRemote());
                        TestCase.assertEquals((Object)event.getCallbackArgument(), (Object)event.getDistributedMember());
                        TestCase.assertEquals((Object)key, (Object)event.getKey());
                        TestCase.assertEquals((Object)oldValue, (Object)event.getOldValue());
                        TestCase.assertEquals((Object)newValue, (Object)event.getNewValue());
                        TestCase.assertFalse((boolean)event.getOperation().isLoad());
                        TestCase.assertFalse((boolean)event.getOperation().isLocalLoad());
                        TestCase.assertFalse((boolean)event.getOperation().isNetLoad());
                        TestCase.assertFalse((boolean)event.getOperation().isNetSearch());
                        if (event.getRegion().getAttributes().getEnableOffHeapMemory()) {
                            TestCase.assertEquals((Object)oldValue, (Object)event.getSerializedOldValue().getDeserializedValue());
                        } else {
                            TestCase.assertEquals(null, (Object)event.getSerializedOldValue());
                        }
                        if (CachedDeserializableFactory.preferObject()) {
                            TestCase.assertEquals((Object)newValue, (Object)event.getNewValue());
                        } else {
                            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(event.getSerializedNewValue().getSerializedValue()));
                            try {
                                TestCase.assertEquals((Object)newValue, (Object)DataSerializer.readObject((DataInput)dis));
                            }
                            catch (Exception e) {
                                DistributedTestCase.fail("Unexpected Exception", e);
                            }
                        }
                    }
                };
                region.getAttributesMutator().addCacheListener((CacheListener)RegionTestCase.listener);
            }
        });
        this.pauseIfNecessary();
        vm0.invoke(new CacheSerializableRunnable("Update"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                region.put(key, newValue, (Object)MultiVMRegionTestCase.this.getSystem().getDistributedMember());
            }
        });
        this.pauseIfNecessary();
        vm1.invoke(new CacheSerializableRunnable("Verify Update"){

            @Override
            public void run2() throws CacheException {
                TestCase.assertTrue((boolean)RegionTestCase.listener.wasInvoked());
                final Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                RegionTestCase.listener = new TestCacheListener(){

                    @Override
                    public void afterInvalidate2(EntryEvent event) {
                        TestCase.assertEquals((Object)Operation.INVALIDATE, (Object)event.getOperation());
                        TestCase.assertEquals((Object)region, (Object)event.getRegion());
                        TestCase.assertTrue((boolean)event.getOperation().isDistributed());
                        TestCase.assertFalse((boolean)event.getOperation().isExpiration());
                        TestCase.assertTrue((boolean)event.isOriginRemote());
                        TestCase.assertEquals((Object)event.getCallbackArgument(), (Object)event.getDistributedMember());
                        TestCase.assertEquals((Object)key, (Object)event.getKey());
                        TestCase.assertEquals((Object)newValue, (Object)event.getOldValue());
                        TestCase.assertNull((Object)event.getNewValue());
                        TestCase.assertFalse((boolean)event.getOperation().isLoad());
                        TestCase.assertFalse((boolean)event.getOperation().isLocalLoad());
                        TestCase.assertFalse((boolean)event.getOperation().isNetLoad());
                        TestCase.assertFalse((boolean)event.getOperation().isNetSearch());
                        TestCase.assertNull((Object)event.getSerializedNewValue());
                        if (CachedDeserializableFactory.preferObject()) {
                            TestCase.assertEquals((Object)newValue, (Object)event.getOldValue());
                        } else {
                            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(event.getSerializedOldValue().getSerializedValue()));
                            try {
                                TestCase.assertEquals((Object)newValue, (Object)DataSerializer.readObject((DataInput)dis));
                            }
                            catch (Exception e) {
                                DistributedTestCase.fail("Unexpected Exception", e);
                            }
                        }
                    }
                };
                region.getAttributesMutator().addCacheListener((CacheListener)RegionTestCase.listener);
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Invalidate"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                region.invalidate(key, (Object)MultiVMRegionTestCase.this.getSystem().getDistributedMember());
            }
        });
        this.pause();
        vm1.invoke(new CacheSerializableRunnable("Verify Invalidate"){

            @Override
            public void run2() throws CacheException {
                TestCase.assertTrue((boolean)RegionTestCase.listener.wasInvoked());
                final Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                RegionTestCase.listener = new TestCacheListener(){

                    @Override
                    public void afterDestroy2(EntryEvent event) {
                        TestCase.assertTrue((boolean)event.getOperation().isDestroy());
                        TestCase.assertEquals((Object)region, (Object)event.getRegion());
                        TestCase.assertTrue((boolean)event.getOperation().isDistributed());
                        TestCase.assertFalse((boolean)event.getOperation().isExpiration());
                        TestCase.assertTrue((boolean)event.isOriginRemote());
                        TestCase.assertEquals((Object)event.getCallbackArgument(), (Object)event.getDistributedMember());
                        TestCase.assertEquals((Object)key, (Object)event.getKey());
                        TestCase.assertNull((Object)event.getOldValue());
                        TestCase.assertNull((Object)event.getNewValue());
                        TestCase.assertFalse((boolean)event.getOperation().isLoad());
                        TestCase.assertFalse((boolean)event.getOperation().isLocalLoad());
                        TestCase.assertFalse((boolean)event.getOperation().isNetLoad());
                        TestCase.assertFalse((boolean)event.getOperation().isNetSearch());
                        TestCase.assertNull((Object)event.getSerializedOldValue());
                        TestCase.assertNull((Object)event.getSerializedNewValue());
                    }
                };
                region.getAttributesMutator().addCacheListener((CacheListener)RegionTestCase.listener);
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Destroy"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                region.destroy(key, (Object)MultiVMRegionTestCase.this.getSystem().getDistributedMember());
            }
        });
        this.pause();
        vm1.invoke(new CacheSerializableRunnable("Verify Destroy"){

            @Override
            public void run2() throws CacheException {
                TestCase.assertTrue((boolean)RegionTestCase.listener.wasInvoked());
                final Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                RegionTestCase.listener = new TestCacheListener(){

                    @Override
                    public void afterRegionInvalidate2(RegionEvent event) {
                        TestCase.assertEquals((Object)Operation.REGION_INVALIDATE, (Object)event.getOperation());
                        TestCase.assertEquals((Object)region, (Object)event.getRegion());
                        TestCase.assertTrue((boolean)event.getOperation().isDistributed());
                        TestCase.assertFalse((boolean)event.getOperation().isExpiration());
                        TestCase.assertTrue((boolean)event.isOriginRemote());
                        TestCase.assertEquals((Object)event.getCallbackArgument(), (Object)event.getDistributedMember());
                    }
                };
                region.getAttributesMutator().addCacheListener((CacheListener)RegionTestCase.listener);
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Invalidate Region"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                region.invalidateRegion((Object)MultiVMRegionTestCase.this.getSystem().getDistributedMember());
            }
        });
        this.pause();
        vm1.invoke(new CacheSerializableRunnable("Verify Invalidate Region"){

            @Override
            public void run2() throws CacheException {
                TestCase.assertTrue((boolean)RegionTestCase.listener.wasInvoked());
                final Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                RegionTestCase.listener = new TestCacheListener(){

                    @Override
                    public void afterRegionDestroy2(RegionEvent event) {
                        TestCase.assertEquals((Object)Operation.REGION_DESTROY, (Object)event.getOperation());
                        TestCase.assertEquals((Object)region, (Object)event.getRegion());
                        TestCase.assertTrue((boolean)event.getOperation().isDistributed());
                        TestCase.assertFalse((boolean)event.getOperation().isExpiration());
                        TestCase.assertTrue((boolean)event.isOriginRemote());
                        TestCase.assertEquals((Object)event.getCallbackArgument(), (Object)event.getDistributedMember());
                    }
                };
                region.getAttributesMutator().addCacheListener((CacheListener)RegionTestCase.listener);
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Destroy Region"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                region.destroyRegion((Object)MultiVMRegionTestCase.this.getSystem().getDistributedMember());
            }
        });
        this.pause();
        vm1.invoke(new CacheSerializableRunnable("Verify Destroy Region"){

            @Override
            public void run2() throws CacheException {
                TestCase.assertTrue((boolean)RegionTestCase.listener.wasInvoked());
            }
        });
    }

    public void testRemoteCacheListenerInSubregion() throws InterruptedException {
        if (!this.supportsSubregions()) {
            return;
        }
        MultiVMRegionTestCase.assertTrue((boolean)this.getRegionAttributes().getScope().isDistributed());
        final String name = this.getUniqueName();
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create Region"){

            @Override
            public void run2() throws CacheException {
                MultiVMRegionTestCase.this.createRegion(name);
            }
        };
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        vm0.invoke(new CacheSerializableRunnable("Create Root"){

            @Override
            public void run2() throws CacheException {
                MultiVMRegionTestCase.this.createRootRegion();
            }
        });
        vm1.invoke(create);
        vm1.invoke(new CacheSerializableRunnable("Set listener"){

            @Override
            public void run2() throws CacheException {
                final Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                RegionTestCase.listener = new TestCacheListener(){

                    @Override
                    public void afterRegionInvalidate2(RegionEvent event) {
                        TestCase.assertEquals((Object)Operation.REGION_INVALIDATE, (Object)event.getOperation());
                        TestCase.assertEquals((Object)region, (Object)event.getRegion());
                        TestCase.assertTrue((boolean)event.getOperation().isDistributed());
                        TestCase.assertFalse((boolean)event.getOperation().isExpiration());
                        TestCase.assertTrue((boolean)event.isOriginRemote());
                        TestCase.assertEquals((Object)event.getCallbackArgument(), (Object)event.getDistributedMember());
                    }
                };
                region.getAttributesMutator().addCacheListener((CacheListener)RegionTestCase.listener);
            }
        });
        this.pauseIfNecessary();
        vm0.invoke(new CacheSerializableRunnable("Invalidate Root Region"){

            @Override
            public void run2() throws CacheException {
                MultiVMRegionTestCase.this.getRootRegion().invalidateRegion((Object)MultiVMRegionTestCase.this.getSystem().getDistributedMember());
            }
        });
        this.pauseIfNecessary();
        vm1.invoke(new CacheSerializableRunnable("Verify Invalidate Region"){

            @Override
            public void run2() throws CacheException {
                TestCase.assertTrue((boolean)RegionTestCase.listener.wasInvoked());
                final Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                RegionTestCase.listener = new TestCacheListener(){

                    @Override
                    public void afterRegionDestroy2(RegionEvent event) {
                        TestCase.assertEquals((Object)Operation.REGION_DESTROY, (Object)event.getOperation());
                        TestCase.assertEquals((Object)region, (Object)event.getRegion());
                        TestCase.assertTrue((boolean)event.getOperation().isDistributed());
                        TestCase.assertFalse((boolean)event.getOperation().isExpiration());
                        TestCase.assertTrue((boolean)event.isOriginRemote());
                        TestCase.assertEquals((Object)event.getCallbackArgument(), (Object)event.getDistributedMember());
                    }
                };
                region.getAttributesMutator().addCacheListener((CacheListener)RegionTestCase.listener);
            }
        });
        this.pauseIfNecessary();
        vm0.invoke(new CacheSerializableRunnable("Destroy Root Region"){

            @Override
            public void run2() throws CacheException {
                MultiVMRegionTestCase.this.getRootRegion().destroyRegion((Object)MultiVMRegionTestCase.this.getSystem().getDistributedMember());
            }
        });
        this.pauseIfNecessary();
        vm1.invoke(new CacheSerializableRunnable("Verify Destroy Region"){

            @Override
            public void run2() throws CacheException {
                TestCase.assertTrue((boolean)RegionTestCase.listener.wasInvoked());
            }
        });
    }

    protected boolean supportsNetLoad() {
        return true;
    }

    public void testRemoteCacheLoader() throws InterruptedException {
        if (!this.supportsNetLoad()) {
            return;
        }
        MultiVMRegionTestCase.assertTrue((boolean)this.getRegionAttributes().getScope().isDistributed());
        final String name = this.getUniqueName();
        final String key = "KEY";
        final String value = "VALUE";
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create Region"){

            @Override
            public void run2() throws CacheException {
                MultiVMRegionTestCase.this.createRegion(name);
            }
        };
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        vm0.invoke(create);
        vm1.invoke(create);
        vm1.invoke(new CacheSerializableRunnable("Set CacheLoader"){

            @Override
            public void run2() throws CacheException {
                final Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                RegionTestCase.loader = new TestCacheLoader(){

                    @Override
                    public Object load2(LoaderHelper helper) throws CacheLoaderException {
                        TestCase.assertEquals((Object)region, (Object)helper.getRegion());
                        TestCase.assertEquals((Object)key, (Object)helper.getKey());
                        TestCase.assertNull((Object)helper.getArgument());
                        return value;
                    }
                };
                region.getAttributesMutator().setCacheLoader((CacheLoader)RegionTestCase.loader);
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Remote load"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                TestCase.assertEquals((Object)value, (Object)region.get(key));
            }
        });
        vm1.invoke(new SerializableRunnable("Verify loader"){

            @Override
            public void run() {
                TestCase.assertTrue((boolean)RegionTestCase.loader.wasInvoked());
            }
        });
    }

    public void testRemoteCacheLoaderArg() throws InterruptedException {
        if (!this.supportsNetLoad()) {
            return;
        }
        MultiVMRegionTestCase.assertTrue((boolean)this.getRegionAttributes().getScope().isDistributed());
        final String name = this.getUniqueName();
        final String key = "KEY";
        final String value = "VALUE";
        String arg = "ARG";
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create Region"){

            @Override
            public void run2() throws CacheException {
                MultiVMRegionTestCase.this.createRegion(name);
            }
        };
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        vm0.invoke(create);
        vm1.invoke(create);
        vm1.invoke(new CacheSerializableRunnable("Set CacheLoader"){

            @Override
            public void run2() throws CacheException {
                final Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                RegionTestCase.loader = new TestCacheLoader(){

                    @Override
                    public Object load2(LoaderHelper helper) throws CacheLoaderException {
                        TestCase.assertEquals((Object)region, (Object)helper.getRegion());
                        TestCase.assertEquals((Object)key, (Object)helper.getKey());
                        TestCase.assertEquals((Object)"ARG", (Object)helper.getArgument());
                        return value;
                    }
                };
                region.getAttributesMutator().setCacheLoader((CacheLoader)RegionTestCase.loader);
            }
        });
        this.pauseIfNecessary();
        this.pauseIfNecessary();
        vm0.invoke(new CacheSerializableRunnable("Remote load"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                try {
                    region.get(key, new Object(){});
                    TestCase.fail((String)"Should have thrown an IllegalArgumentException");
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                TestCase.assertNull((Object)region.getEntry(key));
                try {
                    TestCase.assertEquals((Object)value, (Object)region.get(key, (Object)"ARG"));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        });
        vm1.invoke(new SerializableRunnable("Verify loader"){

            @Override
            public void run() {
                TestCase.assertTrue((boolean)RegionTestCase.loader.wasInvoked());
            }
        });
    }

    public void testRemoteCacheLoaderException() throws InterruptedException {
        if (!this.supportsNetLoad()) {
            return;
        }
        MultiVMRegionTestCase.assertTrue((boolean)this.getRegionAttributes().getScope().isDistributed());
        final String name = this.getUniqueName();
        final String key = "KEY";
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create Region"){

            @Override
            public void run2() throws CacheException {
                MultiVMRegionTestCase.this.createRegion(name);
            }
        };
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        vm0.invoke(create);
        vm1.invoke(create);
        vm1.invoke(new CacheSerializableRunnable("Set CacheLoader"){

            @Override
            public void run2() throws CacheException {
                final Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                RegionTestCase.loader = new TestCacheLoader(){

                    @Override
                    public Object load2(LoaderHelper helper) throws CacheLoaderException {
                        TestCase.assertEquals((Object)region, (Object)helper.getRegion());
                        TestCase.assertEquals((Object)key, (Object)helper.getKey());
                        TestCase.assertNull((Object)helper.getArgument());
                        String s = "Test Exception";
                        throw new CacheLoaderException(s);
                    }
                };
                region.getAttributesMutator().setCacheLoader((CacheLoader)RegionTestCase.loader);
            }
        });
        this.pauseIfNecessary();
        vm0.invoke(new CacheSerializableRunnable("Remote load"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                try {
                    region.get(key);
                    TestCase.fail((String)"Should have thrown a CacheLoaderException");
                }
                catch (CacheLoaderException cacheLoaderException) {
                    // empty catch block
                }
            }
        });
        vm1.invoke(new SerializableRunnable("Verify loader"){

            @Override
            public void run() {
                TestCase.assertTrue((boolean)RegionTestCase.loader.wasInvoked());
            }
        });
    }

    public void testCacheLoaderWithNetSearch() throws CacheException {
        if (!this.supportsNetLoad()) {
            return;
        }
        if (this.getRegionAttributes().getDataPolicy().withReplication() || this.getRegionAttributes().getDataPolicy().isPreloaded()) {
            return;
        }
        final String name = this.getUniqueName();
        final String key = this.getUniqueName();
        final Integer value = new Integer(42);
        Host host = Host.getHost(0);
        VM vm1 = host.getVM(1);
        vm1.invoke(new CacheSerializableRunnable("set remote value"){

            @Override
            public void run2() throws CacheException {
                Region rgn = MultiVMRegionTestCase.this.createRegion(name);
                rgn.put(key, value);
            }
        });
        this.pauseIfNecessary();
        TestCacheLoader loader1 = new TestCacheLoader(){

            @Override
            public Object load2(LoaderHelper helper) throws CacheLoaderException {
                TestCase.assertEquals((Object)key, (Object)helper.getKey());
                TestCase.assertEquals((String)name, (String)helper.getRegion().getName());
                try {
                    helper.getRegion().getAttributes();
                    Object result = helper.netSearch(false);
                    TestCase.assertEquals((Object)value, (Object)result);
                    return result;
                }
                catch (TimeoutException ex) {
                    DistributedTestCase.fail("Why did I time out?", ex);
                    return null;
                }
            }
        };
        AttributesFactory f = new AttributesFactory(this.getRegionAttributes());
        f.setCacheLoader((CacheLoader)loader1);
        Region region = this.createRegion(name, f.create());
        loader1.wasInvoked();
        Region.Entry entry = region.getEntry((Object)key);
        MultiVMRegionTestCase.assertNull((Object)entry);
        region.create((Object)key, null);
        entry = region.getEntry((Object)key);
        MultiVMRegionTestCase.assertNotNull((Object)entry);
        MultiVMRegionTestCase.assertNull((Object)entry.getValue());
        vm1.invoke(new CacheSerializableRunnable("verify remote value"){

            @Override
            public void run2() throws CacheException {
                Region rgn = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                TestCase.assertEquals((Object)value, (Object)rgn.getEntry(key).getValue());
            }
        });
        MultiVMRegionTestCase.assertEquals((Object)value, (Object)region.get((Object)key));
        if (region.getAttributes().getScope().isGlobal()) {
            MultiVMRegionTestCase.assertTrue((!loader1.wasInvoked() ? 1 : 0) != 0);
        } else {
            MultiVMRegionTestCase.assertTrue((boolean)loader1.wasInvoked());
        }
        MultiVMRegionTestCase.assertEquals((Object)value, (Object)region.getEntry((Object)key).getValue());
    }

    public void testCacheLoaderWithNetLoad() throws CacheException {
        if (this.getRegionAttributes().getDataPolicy().withReplication() || this.getRegionAttributes().getDataPolicy().isPreloaded() || this.getRegionAttributes().getPartitionAttributes() != null) {
            return;
        }
        final String name = this.getUniqueName();
        final String key = this.getUniqueName();
        final Integer value = new Integer(42);
        Host host = Host.getHost(0);
        VM vm1 = host.getVM(1);
        vm1.invoke(new CacheSerializableRunnable("set up remote loader"){

            @Override
            public void run2() throws CacheException {
                TestCacheLoader remoteloader = new TestCacheLoader(){

                    @Override
                    public Object load2(LoaderHelper helper) throws CacheLoaderException {
                        TestCase.assertEquals((Object)key, (Object)helper.getKey());
                        TestCase.assertEquals((String)name, (String)helper.getRegion().getName());
                        return value;
                    }
                };
                AttributesFactory factory = new AttributesFactory(MultiVMRegionTestCase.this.getRegionAttributes());
                factory.setCacheLoader((CacheLoader)remoteloader);
                MultiVMRegionTestCase.this.createRegion(name, factory.create());
            }
        });
        TestCacheLoader loader1 = new TestCacheLoader(){

            @Override
            public Object load2(LoaderHelper helper) throws CacheLoaderException {
                TestCase.assertEquals((Object)key, (Object)helper.getKey());
                TestCase.assertEquals((String)name, (String)helper.getRegion().getName());
                try {
                    helper.getRegion().getAttributes();
                    Object result = helper.netSearch(true);
                    TestCase.assertEquals((Object)value, (Object)result);
                    return result;
                }
                catch (TimeoutException ex) {
                    DistributedTestCase.fail("Why did I time out?", ex);
                    return null;
                }
            }
        };
        AttributesFactory f = new AttributesFactory(this.getRegionAttributes());
        f.setCacheLoader((CacheLoader)loader1);
        Region region = this.createRegion(name, f.create());
        loader1.wasInvoked();
        Region.Entry entry = region.getEntry((Object)key);
        MultiVMRegionTestCase.assertNull((Object)entry);
        region.create((Object)key, null);
        entry = region.getEntry((Object)key);
        MultiVMRegionTestCase.assertNotNull((Object)entry);
        MultiVMRegionTestCase.assertNull((Object)entry.getValue());
        MultiVMRegionTestCase.assertEquals((Object)value, (Object)region.get((Object)key));
        MultiVMRegionTestCase.assertTrue((boolean)loader1.wasInvoked());
        MultiVMRegionTestCase.assertEquals((Object)value, (Object)region.getEntry((Object)key).getValue());
    }

    public void testNoRemoteCacheLoader() throws InterruptedException {
        MultiVMRegionTestCase.assertTrue((boolean)this.getRegionAttributes().getScope().isDistributed());
        final String name = this.getUniqueName();
        final String key = "KEY";
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create Region"){

            @Override
            public void run2() throws CacheException {
                MultiVMRegionTestCase.this.createRegion(name);
            }
        };
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        vm0.invoke(create);
        vm1.invoke(create);
        vm0.invoke(new CacheSerializableRunnable("Remote load"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                TestCase.assertNull((Object)region.get(key));
            }
        });
    }

    public void testNoLoaderWithInvalidEntry() {
        if (!this.supportsNetLoad()) {
            return;
        }
        final String name = this.getUniqueName();
        final String key = "KEY";
        final String value = "VALUE";
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create Region"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.createRegion(name);
                RegionTestCase.loader = new TestCacheLoader(){

                    @Override
                    public Object load2(LoaderHelper helper) throws CacheLoaderException {
                        return value;
                    }
                };
                region.getAttributesMutator().setCacheLoader((CacheLoader)RegionTestCase.loader);
            }
        };
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        vm0.invoke(create);
        vm1.invoke(create);
        vm1.invoke(new CacheSerializableRunnable("Create invalid entry"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                region.create(key, null);
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Remote get"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                TestCase.assertEquals((Object)value, (Object)region.get(key));
                TestCase.assertTrue((boolean)RegionTestCase.loader.wasInvoked());
            }
        });
        vm1.invoke(new SerializableRunnable("Verify loader"){

            @Override
            public void run() {
                TestCase.assertFalse((boolean)RegionTestCase.loader.wasInvoked());
            }
        });
    }

    public void testRemoteCacheWriter() throws InterruptedException {
        MultiVMRegionTestCase.assertTrue((boolean)this.getRegionAttributes().getScope().isDistributed());
        final String name = this.getUniqueName();
        final String key = "KEY";
        final String oldValue = "OLD_VALUE";
        final String newValue = "NEW_VALUE";
        final String arg = "ARG";
        final String exception = "EXCEPTION";
        final String key2 = "KEY2";
        final String value2 = "VALUE2";
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create Region"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.createRegion(name);
                region.put(key2, value2);
                TestCase.assertEquals((int)1, (int)region.size());
                if (region.getAttributes().getEnableOffHeapMemory() && !(region instanceof PartitionedRegion)) {
                    GemFireCacheImpl gfc = (GemFireCacheImpl)MultiVMRegionTestCase.this.getCache();
                    SimpleMemoryAllocatorImpl ma = (SimpleMemoryAllocatorImpl)gfc.getOffHeapStore();
                    LocalRegion reRegion = (LocalRegion)region;
                    RegionEntry re = reRegion.getRegionEntry(key2);
                    MemoryChunkWithRefCount mc = (MemoryChunkWithRefCount)re._getValue();
                    TestCase.assertEquals((int)1, (int)mc.getRefCount());
                    TestCase.assertEquals((int)1, (int)ma.getStats().getObjects());
                }
            }
        };
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        vm0.invoke(create);
        vm1.invoke(create);
        vm1.invoke(new CacheSerializableRunnable("Set Writer"){

            @Override
            public void run2() throws CacheException {
                final Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                RegionTestCase.writer = new TestCacheWriter(){

                    @Override
                    public void beforeCreate2(EntryEvent event) throws CacheWriterException {
                        if (exception.equals(event.getCallbackArgument())) {
                            String s = "Test Exception";
                            throw new CacheWriterException(s);
                        }
                        TestCase.assertEquals((Object)region, (Object)event.getRegion());
                        TestCase.assertTrue((boolean)event.getOperation().isCreate());
                        TestCase.assertTrue((boolean)event.getOperation().isDistributed());
                        TestCase.assertFalse((boolean)event.getOperation().isExpiration());
                        TestCase.assertTrue((boolean)event.isOriginRemote());
                        TestCase.assertEquals((Object)key, (Object)event.getKey());
                        TestCase.assertEquals(null, (Object)event.getOldValue());
                        TestCase.assertEquals((Object)oldValue, (Object)event.getNewValue());
                        TestCase.assertFalse((boolean)event.getOperation().isLoad());
                        TestCase.assertFalse((boolean)event.getOperation().isLocalLoad());
                        TestCase.assertFalse((boolean)event.getOperation().isNetLoad());
                        TestCase.assertFalse((boolean)event.getOperation().isNetSearch());
                    }
                };
                region.getAttributesMutator().setCacheWriter((CacheWriter)RegionTestCase.writer);
            }
        });
        this.pauseIfNecessary();
        vm0.invoke(new CacheSerializableRunnable("Create with Exception"){

            @Override
            public void run2() throws CacheException {
                block2: {
                    Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                    try {
                        region.put(key, oldValue, exception);
                        TestCase.fail((String)"Should have thrown a CacheWriterException");
                    }
                    catch (CacheWriterException ex) {
                        TestCase.assertNull((Object)region.getEntry(key));
                        TestCase.assertEquals((int)1, (int)region.size());
                        if (!region.getAttributes().getEnableOffHeapMemory() || region instanceof PartitionedRegion) break block2;
                        GemFireCacheImpl gfc = (GemFireCacheImpl)MultiVMRegionTestCase.this.getCache();
                        SimpleMemoryAllocatorImpl ma = (SimpleMemoryAllocatorImpl)gfc.getOffHeapStore();
                        TestCase.assertEquals((int)1, (int)ma.getStats().getObjects());
                    }
                }
            }
        });
        vm1.invoke(new SerializableRunnable("Verify callback"){

            @Override
            public void run() {
                TestCase.assertTrue((boolean)RegionTestCase.writer.wasInvoked());
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Create with Argument"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                region.put(key, oldValue, arg);
                TestCase.assertEquals((int)2, (int)region.size());
                if (region.getAttributes().getEnableOffHeapMemory() && !(region instanceof PartitionedRegion)) {
                    GemFireCacheImpl gfc = (GemFireCacheImpl)MultiVMRegionTestCase.this.getCache();
                    SimpleMemoryAllocatorImpl ma = (SimpleMemoryAllocatorImpl)gfc.getOffHeapStore();
                    TestCase.assertEquals((int)2, (int)ma.getStats().getObjects());
                    LocalRegion reRegion = (LocalRegion)region;
                    MemoryChunkWithRefCount mc = (MemoryChunkWithRefCount)reRegion.getRegionEntry(key)._getValue();
                    TestCase.assertEquals((int)1, (int)mc.getRefCount());
                }
            }
        });
        vm1.invoke(new SerializableRunnable("Verify callback"){

            @Override
            public void run() {
                TestCase.assertTrue((boolean)RegionTestCase.writer.wasInvoked());
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Set Writer"){

            @Override
            public void run2() throws CacheException {
                final Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                RegionTestCase.writer = new TestCacheWriter(){

                    @Override
                    public void beforeUpdate2(EntryEvent event) throws CacheWriterException {
                        Object argument = event.getCallbackArgument();
                        if (exception.equals(argument)) {
                            String s = "Test Exception";
                            throw new CacheWriterException(s);
                        }
                        TestCase.assertEquals((Object)arg, (Object)argument);
                        TestCase.assertEquals((Object)region, (Object)event.getRegion());
                        TestCase.assertTrue((boolean)event.getOperation().isUpdate());
                        TestCase.assertTrue((boolean)event.getOperation().isDistributed());
                        TestCase.assertFalse((boolean)event.getOperation().isExpiration());
                        TestCase.assertTrue((boolean)event.isOriginRemote());
                        TestCase.assertEquals((Object)key, (Object)event.getKey());
                        TestCase.assertEquals((Object)oldValue, (Object)event.getOldValue());
                        TestCase.assertEquals((Object)newValue, (Object)event.getNewValue());
                        TestCase.assertFalse((boolean)event.getOperation().isLoad());
                        TestCase.assertFalse((boolean)event.getOperation().isLocalLoad());
                        TestCase.assertFalse((boolean)event.getOperation().isNetLoad());
                        TestCase.assertFalse((boolean)event.getOperation().isNetSearch());
                    }
                };
                region.getAttributesMutator().setCacheWriter((CacheWriter)RegionTestCase.writer);
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Update with Exception"){

            @Override
            public void run2() throws CacheException {
                block2: {
                    Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                    try {
                        region.put(key, newValue, exception);
                        TestCase.fail((String)"Should have thrown a CacheWriterException");
                    }
                    catch (CacheWriterException ex) {
                        Region.Entry entry = region.getEntry(key);
                        TestCase.assertEquals((Object)oldValue, (Object)entry.getValue());
                        TestCase.assertEquals((int)2, (int)region.size());
                        if (!region.getAttributes().getEnableOffHeapMemory() || region instanceof PartitionedRegion) break block2;
                        GemFireCacheImpl gfc = (GemFireCacheImpl)MultiVMRegionTestCase.this.getCache();
                        SimpleMemoryAllocatorImpl ma = (SimpleMemoryAllocatorImpl)gfc.getOffHeapStore();
                        TestCase.assertEquals((int)2, (int)ma.getStats().getObjects());
                        LocalRegion reRegion = (LocalRegion)region;
                        MemoryChunkWithRefCount mc = (MemoryChunkWithRefCount)reRegion.getRegionEntry(key)._getValue();
                        TestCase.assertEquals((int)1, (int)mc.getRefCount());
                    }
                }
            }
        });
        vm1.invoke(new SerializableRunnable("Verify callback"){

            @Override
            public void run() {
                TestCase.assertTrue((boolean)RegionTestCase.writer.wasInvoked());
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Update with Argument"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                region.put(key, newValue, arg);
                TestCase.assertEquals((int)2, (int)region.size());
                if (region.getAttributes().getEnableOffHeapMemory() && !(region instanceof PartitionedRegion)) {
                    GemFireCacheImpl gfc = (GemFireCacheImpl)MultiVMRegionTestCase.this.getCache();
                    SimpleMemoryAllocatorImpl ma = (SimpleMemoryAllocatorImpl)gfc.getOffHeapStore();
                    TestCase.assertEquals((int)2, (int)ma.getStats().getObjects());
                }
            }
        });
        vm1.invoke(new SerializableRunnable("Verify callback"){

            @Override
            public void run() {
                TestCase.assertTrue((boolean)RegionTestCase.writer.wasInvoked());
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Set Writer"){

            @Override
            public void run2() throws CacheException {
                final Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                RegionTestCase.writer = new TestCacheWriter(){

                    @Override
                    public void beforeDestroy2(EntryEvent event) throws CacheWriterException {
                        Object argument = event.getCallbackArgument();
                        if (exception.equals(argument)) {
                            String s = "Test Exception";
                            throw new CacheWriterException(s);
                        }
                        TestCase.assertEquals((Object)arg, (Object)argument);
                        TestCase.assertEquals((Object)region, (Object)event.getRegion());
                        TestCase.assertTrue((boolean)event.getOperation().isDestroy());
                        TestCase.assertTrue((boolean)event.getOperation().isDistributed());
                        TestCase.assertFalse((boolean)event.getOperation().isExpiration());
                        TestCase.assertTrue((boolean)event.isOriginRemote());
                        TestCase.assertEquals((Object)key, (Object)event.getKey());
                        TestCase.assertEquals((Object)newValue, (Object)event.getOldValue());
                        TestCase.assertNull((Object)event.getNewValue());
                        TestCase.assertFalse((boolean)event.getOperation().isLoad());
                        TestCase.assertFalse((boolean)event.getOperation().isLocalLoad());
                        TestCase.assertFalse((boolean)event.getOperation().isNetLoad());
                        TestCase.assertFalse((boolean)event.getOperation().isNetSearch());
                    }
                };
                region.getAttributesMutator().setCacheWriter((CacheWriter)RegionTestCase.writer);
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Destroy with Exception"){

            @Override
            public void run2() throws CacheException {
                block2: {
                    Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                    try {
                        region.destroy(key, exception);
                        TestCase.fail((String)"Should have thrown a CacheWriterException");
                    }
                    catch (CacheWriterException ex) {
                        TestCase.assertNotNull((Object)region.getEntry(key));
                        TestCase.assertEquals((int)2, (int)region.size());
                        if (!region.getAttributes().getEnableOffHeapMemory() || region instanceof PartitionedRegion) break block2;
                        GemFireCacheImpl gfc = (GemFireCacheImpl)MultiVMRegionTestCase.this.getCache();
                        SimpleMemoryAllocatorImpl ma = (SimpleMemoryAllocatorImpl)gfc.getOffHeapStore();
                        TestCase.assertEquals((int)2, (int)ma.getStats().getObjects());
                    }
                }
            }
        });
        vm1.invoke(new SerializableRunnable("Verify callback"){

            @Override
            public void run() {
                TestCase.assertTrue((boolean)RegionTestCase.writer.wasInvoked());
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Destroy with Argument"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                region.destroy(key, arg);
                TestCase.assertEquals((int)1, (int)region.size());
                if (region.getAttributes().getEnableOffHeapMemory() && !(region instanceof PartitionedRegion)) {
                    GemFireCacheImpl gfc = (GemFireCacheImpl)MultiVMRegionTestCase.this.getCache();
                    SimpleMemoryAllocatorImpl ma = (SimpleMemoryAllocatorImpl)gfc.getOffHeapStore();
                    TestCase.assertEquals((int)1, (int)ma.getStats().getObjects());
                }
            }
        });
        vm1.invoke(new SerializableRunnable("Verify callback"){

            @Override
            public void run() {
                TestCase.assertTrue((boolean)RegionTestCase.writer.wasInvoked());
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Set Writer"){

            @Override
            public void run2() throws CacheException {
                final Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                RegionTestCase.writer = new TestCacheWriter(){

                    @Override
                    public void beforeRegionDestroy2(RegionEvent event) throws CacheWriterException {
                        Object argument = event.getCallbackArgument();
                        if (exception.equals(argument)) {
                            String s = "Test Exception";
                            throw new CacheWriterException(s);
                        }
                        TestCase.assertEquals((Object)arg, (Object)argument);
                        TestCase.assertEquals((Object)region, (Object)event.getRegion());
                        TestCase.assertTrue((boolean)event.getOperation().isRegionDestroy());
                        TestCase.assertTrue((boolean)event.getOperation().isDistributed());
                        TestCase.assertFalse((boolean)event.getOperation().isExpiration());
                        TestCase.assertTrue((boolean)event.isOriginRemote());
                    }
                };
                region.getAttributesMutator().setCacheWriter((CacheWriter)RegionTestCase.writer);
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Destroy with Exception"){

            @Override
            public void run2() throws CacheException {
                block3: {
                    Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                    try {
                        region.destroyRegion(exception);
                        TestCase.fail((String)"Should have thrown a CacheWriterException");
                    }
                    catch (CacheWriterException ex) {
                        if (region.isDestroyed()) {
                            DistributedTestCase.fail("should not have an exception if region is destroyed", ex);
                        }
                        TestCase.assertEquals((int)1, (int)region.size());
                        if (!region.getAttributes().getEnableOffHeapMemory() || region instanceof PartitionedRegion) break block3;
                        GemFireCacheImpl gfc = (GemFireCacheImpl)MultiVMRegionTestCase.this.getCache();
                        SimpleMemoryAllocatorImpl ma = (SimpleMemoryAllocatorImpl)gfc.getOffHeapStore();
                        TestCase.assertEquals((int)1, (int)ma.getStats().getObjects());
                    }
                }
            }
        });
        vm1.invoke(new SerializableRunnable("Verify callback"){

            @Override
            public void run() {
                TestCase.assertTrue((boolean)RegionTestCase.writer.wasInvoked());
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Destroy with Argument"){

            @Override
            public void run2() throws CacheException {
                SimpleMemoryAllocatorImpl ma;
                GemFireCacheImpl gfc;
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                TestCase.assertEquals((int)1, (int)region.size());
                if (region.getAttributes().getEnableOffHeapMemory() && !(region instanceof PartitionedRegion)) {
                    gfc = (GemFireCacheImpl)MultiVMRegionTestCase.this.getCache();
                    ma = (SimpleMemoryAllocatorImpl)gfc.getOffHeapStore();
                    TestCase.assertEquals((int)1, (int)ma.getStats().getObjects());
                }
                region.destroyRegion(arg);
                if (region.getAttributes().getEnableOffHeapMemory() && !(region instanceof PartitionedRegion)) {
                    gfc = (GemFireCacheImpl)MultiVMRegionTestCase.this.getCache();
                    ma = (SimpleMemoryAllocatorImpl)gfc.getOffHeapStore();
                    TestCase.assertEquals((int)0, (int)ma.getStats().getObjects());
                }
            }
        });
        vm1.invoke(new SerializableRunnable("Verify callback"){

            @Override
            public void run() {
                TestCase.assertTrue((boolean)RegionTestCase.writer.wasInvoked());
            }
        });
    }

    public void testLocalAndRemoteCacheWriters() throws InterruptedException {
        MultiVMRegionTestCase.assertTrue((boolean)this.getRegionAttributes().getScope().isDistributed());
        final String name = this.getUniqueName();
        final String key = "KEY";
        final String oldValue = "OLD_VALUE";
        final String newValue = "NEW_VALUE";
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        vm0.invoke(new CacheSerializableRunnable("Create \"Local\" Region"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.createRegion(name);
                RegionTestCase.writer = new TestCacheWriter(){

                    @Override
                    public void beforeUpdate2(EntryEvent event) throws CacheWriterException {
                    }

                    @Override
                    public void beforeCreate2(EntryEvent event) throws CacheWriterException {
                    }

                    @Override
                    public void beforeDestroy2(EntryEvent event) throws CacheWriterException {
                    }

                    @Override
                    public void beforeRegionDestroy2(RegionEvent event) throws CacheWriterException {
                    }
                };
                region.getAttributesMutator().setCacheWriter((CacheWriter)RegionTestCase.writer);
            }
        });
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create \"Local\" Region"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.createRegion(name);
                RegionTestCase.writer = new TestCacheWriter(){};
                region.getAttributesMutator().setCacheWriter((CacheWriter)RegionTestCase.writer);
            }
        };
        vm1.invoke(create);
        SerializableRunnable verify = new SerializableRunnable("Verify no callback"){

            @Override
            public void run() {
                TestCase.assertFalse((boolean)RegionTestCase.writer.wasInvoked());
            }
        };
        vm0.invoke(new CacheSerializableRunnable("Create entry"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                region.put(key, oldValue);
                TestCase.assertTrue((boolean)RegionTestCase.writer.wasInvoked());
            }
        });
        vm1.invoke(verify);
        vm0.invoke(new CacheSerializableRunnable("Update entry"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                region.put(key, newValue);
                TestCase.assertTrue((boolean)RegionTestCase.writer.wasInvoked());
            }
        });
        vm1.invoke(verify);
        vm0.invoke(new CacheSerializableRunnable("Destroy entry"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                region.destroy(key);
                TestCase.assertTrue((boolean)RegionTestCase.writer.wasInvoked());
            }
        });
        vm1.invoke(verify);
        vm0.invoke(new CacheSerializableRunnable("Destroy region"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                region.destroyRegion();
                TestCase.assertTrue((boolean)RegionTestCase.writer.wasInvoked());
            }
        });
        vm1.invoke(verify);
    }

    public void testCacheLoaderModifyingArgument() throws InterruptedException {
        MultiVMRegionTestCase.assertTrue((boolean)this.getRegionAttributes().getScope().isDistributed());
        final String name = this.getUniqueName();
        final String key = "KEY";
        final String value = "VALUE";
        final String one = "ONE";
        final String two = "TWO";
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create Region"){

            @Override
            public void run2() throws CacheException {
                MultiVMRegionTestCase.this.createRegion(name);
            }
        };
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        vm0.invoke(create);
        vm1.invoke(create);
        CacheSerializableRunnable setLoader = new CacheSerializableRunnable("Set CacheLoader"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                RegionTestCase.loader = new TestCacheLoader(){

                    @Override
                    public Object load2(LoaderHelper helper) throws CacheLoaderException {
                        Object[] array = (Object[])helper.getArgument();
                        TestCase.assertEquals((Object)one, (Object)array[0]);
                        array[0] = two;
                        return value;
                    }
                };
                region.getAttributesMutator().setCacheLoader((CacheLoader)RegionTestCase.loader);
            }
        };
        vm0.invoke(setLoader);
        vm1.invoke(new CacheSerializableRunnable("Conditionally create second loader"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                if (region.getAttributes().getPartitionAttributes() != null) {
                    RegionTestCase.loader = new TestCacheLoader(){

                        @Override
                        public Object load2(LoaderHelper helper) throws CacheLoaderException {
                            Object[] array = (Object[])helper.getArgument();
                            TestCase.assertEquals((Object)one, (Object)array[0]);
                            array[0] = two;
                            return value;
                        }
                    };
                    region.getAttributesMutator().setCacheLoader((CacheLoader)RegionTestCase.loader);
                }
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Set CacheWriter"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                RegionTestCase.writer = new TestCacheWriter(){

                    @Override
                    public void beforeCreate2(EntryEvent event) throws CacheWriterException {
                        Object[] array = (Object[])event.getCallbackArgument();
                        TestCase.assertEquals((Object)two, (Object)array[0]);
                    }
                };
                region.getAttributesMutator().setCacheWriter((CacheWriter)RegionTestCase.writer);
            }
        });
        this.pauseIfNecessary();
        vm0.invoke(new CacheSerializableRunnable("Create entry"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                Object[] array = new Object[]{one};
                Object result = region.get(key, (Object)array);
                TestCase.assertTrue((boolean)RegionTestCase.loader.wasInvoked());
                TestCase.assertEquals((Object)value, (Object)result);
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Validate callback"){

            @Override
            public void run2() throws CacheException {
                TestCase.assertTrue((boolean)RegionTestCase.writer.wasInvoked());
            }
        });
    }

    public void testRemoteLoaderNetSearch() throws CacheException {
        if (!this.supportsNetLoad()) {
            return;
        }
        MultiVMRegionTestCase.assertTrue((boolean)this.getRegionAttributes().getScope().isDistributed());
        final String name = this.getUniqueName();
        final String key = "KEY";
        final String value = "VALUE";
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        CacheSerializableRunnable create = new CacheSerializableRunnable("Get value"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.createRegion(name);
                TestCase.assertEquals((Object)value, (Object)region.get(key));
            }
        };
        vm0.invoke(new CacheSerializableRunnable("Create Region"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.createRegion(name);
                region.getAttributesMutator().setCacheLoader((CacheLoader)new TestCacheLoader(){

                    @Override
                    public Object load2(LoaderHelper helper) throws CacheLoaderException {
                        try {
                            TestCase.assertNull((Object)helper.netSearch(true));
                        }
                        catch (TimeoutException ex) {
                            DistributedTestCase.fail("Why did I time out?", ex);
                        }
                        return value;
                    }
                });
            }
        });
        vm1.invoke(create);
    }

    public void testLocalCacheLoader() {
        final String name = this.getUniqueName();
        final String key = "KEY";
        final String value = "VALUE";
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create \"remote\" region"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.createRegion(name);
                RegionTestCase.loader = new TestCacheLoader(){

                    @Override
                    public Object load2(LoaderHelper helper) throws CacheLoaderException {
                        if (helper.getRegion().getAttributes().getPartitionAttributes() == null) {
                            TestCase.fail((String)"Should not be invoked");
                            return null;
                        }
                        return value;
                    }
                };
                region.getAttributesMutator().setCacheLoader((CacheLoader)RegionTestCase.loader);
            }
        };
        vm0.invoke(new CacheSerializableRunnable("Create \"local\" region"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.createRegion(name);
                region.getAttributesMutator().setCacheLoader((CacheLoader)new TestCacheLoader(){

                    @Override
                    public Object load2(LoaderHelper helper) throws CacheLoaderException {
                        return value;
                    }
                });
            }
        });
        vm1.invoke(create);
        vm0.invoke(new CacheSerializableRunnable("Get"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                TestCase.assertEquals((Object)value, (Object)region.get(key));
            }
        });
        vm1.invoke(new SerializableRunnable("Verify loader not invoked"){

            @Override
            public void run() {
                TestCase.assertFalse((boolean)RegionTestCase.loader.wasInvoked());
            }
        });
    }

    public void testDistributedPut() throws Exception {
        final String rgnName = this.getUniqueName();
        SerializableRunnable create = new SerializableRunnable("testDistributedPut: Create Region"){

            @Override
            public void run() {
                try {
                    MultiVMRegionTestCase.this.createRegion(rgnName);
                    MultiVMRegionTestCase.this.getSystem().getLogWriter().info("testDistributedPut: Created Region");
                }
                catch (CacheException e) {
                    DistributedTestCase.fail("While creating region", e);
                }
            }
        };
        SerializableRunnable newKey = new SerializableRunnable("testDistributedPut: Create Key"){

            @Override
            public void run() {
                try {
                    if (!MultiVMRegionTestCase.this.getRegionAttributes().getDataPolicy().withReplication() && MultiVMRegionTestCase.this.getRegionAttributes().getPartitionAttributes() == null) {
                        Region root = MultiVMRegionTestCase.this.getRootRegion("root");
                        Region rgn = root.getSubregion(rgnName);
                        rgn.create((Object)"key", null);
                        MultiVMRegionTestCase.this.getSystem().getLogWriter().info("testDistributedPut: Created Key");
                    }
                }
                catch (CacheException e) {
                    DistributedTestCase.fail("While creating region", e);
                }
            }
        };
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        vm0.invoke(create);
        vm0.invoke(newKey);
        int vmCount = host.getVMCount();
        HashSet<GemFireSystem> systems = new HashSet<GemFireSystem>();
        systems.add(vm0.getSystem());
        for (int i = 1; i < vmCount; ++i) {
            VM vm = host.getVM(i);
            vm.invoke(create);
            if (!this.getRegionAttributes().getDataPolicy().isPreloaded()) {
                vm.invoke(newKey);
            }
            systems.add(vm.getSystem());
        }
        try {
            Region rgn = null;
            rgn = this.createRegion(rgnName);
            rgn.put((Object)"key", (Object)"value");
            this.getSystem().getLogWriter().info("testDistributedPut: Put Value");
            this.invokeInEveryVMRepeatingIfNecessary(new CacheSerializableRunnable("testDistributedPut: Verify Received Value"){

                @Override
                public void run2() {
                    Region rgn1 = MultiVMRegionTestCase.this.getRootRegion().getSubregion(rgnName);
                    TestCase.assertNotNull((String)"Could not find entry for 'key'", (Object)rgn1.getEntry((Object)"key"));
                    TestCase.assertEquals((Object)"value", (Object)rgn1.getEntry((Object)"key").getValue());
                }
            });
        }
        catch (Exception e) {
            CacheFactory.getInstance((DistributedSystem)this.getSystem()).close();
            this.getSystem().getLogWriter().fine("testDistributedPut: Caused exception in createRegion");
            throw e;
        }
    }

    protected boolean supportsReplication() {
        return true;
    }

    public void testReplicate() throws InterruptedException {
        if (!this.supportsReplication()) {
            return;
        }
        this.pauseIfNecessary(100);
        final String name = this.getUniqueName();
        final String key1 = "KEY1";
        final String value1 = "VALUE1";
        final String key2 = "KEY2";
        Object[] v = new Object[3000];
        Arrays.fill(v, new Integer(51966));
        final List<Object> value2 = Arrays.asList(v);
        final String key3 = "KEY3";
        final String value3 = "VALUE3";
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm2 = host.getVM(2);
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create Mirrored Region"){

            @Override
            public void run2() throws CacheException {
                RegionAttributes ra = MultiVMRegionTestCase.this.getRegionAttributes();
                AttributesFactory factory = new AttributesFactory(ra);
                if (ra.getEvictionAttributes() == null || !ra.getEvictionAttributes().getAction().isOverflowToDisk()) {
                    factory.setDiskStoreName(null);
                }
                factory.setDataPolicy(DataPolicy.REPLICATE);
                MultiVMRegionTestCase.this.createRegion(name, factory.create());
            }
        };
        vm0.invoke(create);
        Thread.sleep(250L);
        vm2.invoke(create);
        Thread.sleep(250L);
        vm0.invoke(new CacheSerializableRunnable("Put data"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                region.put(key1, value1);
                region.put(key2, value2);
                region.put(key3, value3);
            }
        });
        this.invokeRepeatingIfNecessary(vm2, new CacheSerializableRunnable("Wait for update"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                TestCase.assertNotNull((Object)region.getEntry(key1));
                TestCase.assertNotNull((Object)region.getEntry(key2));
                TestCase.assertNotNull((Object)region.getEntry(key3));
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Remove local entries"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                region.localDestroyRegion();
            }
        });
        this.invokeRepeatingIfNecessary(vm2, new CacheSerializableRunnable("Verify keys"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                Region.Entry entry1 = region.getEntry(key1);
                TestCase.assertNotNull((Object)entry1);
                TestCase.assertEquals((Object)value1, (Object)entry1.getValue());
                Region.Entry entry2 = region.getEntry(key2);
                TestCase.assertNotNull((Object)entry2);
                TestCase.assertEquals((Object)value2, (Object)entry2.getValue());
                Region.Entry entry3 = region.getEntry(key3);
                TestCase.assertNotNull((Object)entry3);
                TestCase.assertEquals((Object)value3, (Object)entry3.getValue());
            }
        });
    }

    public void testDeltaWithReplicate() throws InterruptedException {
        if (!this.supportsReplication()) {
            return;
        }
        this.pauseIfNecessary(100);
        final String name = this.getUniqueName();
        final String key1 = "KEY1";
        final String value1 = "VALUE1";
        final String key2 = "KEY2";
        final Integer value2 = new Integer(51966);
        final String key3 = "KEY3";
        final String value3 = "VALUE3";
        AddTen delta = new AddTen();
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm2 = host.getVM(2);
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create Replicate Region"){

            @Override
            public void run2() throws CacheException {
                RegionAttributes ra = MultiVMRegionTestCase.this.getRegionAttributes();
                AttributesFactory factory = new AttributesFactory(ra);
                if (ra.getEvictionAttributes() == null || !ra.getEvictionAttributes().getAction().isOverflowToDisk()) {
                    factory.setDiskStoreName(null);
                }
                factory.setDataPolicy(DataPolicy.REPLICATE);
                MultiVMRegionTestCase.this.createRegion(name, factory.create());
            }
        };
        vm0.invoke(create);
        Thread.sleep(250L);
        vm2.invoke(create);
        Thread.sleep(250L);
        vm0.invoke(new CacheSerializableRunnable("Put data"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                region.put(key1, value1);
                region.put(key2, value2);
                region.put(key3, value3);
            }
        });
        this.invokeRepeatingIfNecessary(vm2, new CacheSerializableRunnable("Wait for update"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                TestCase.assertNotNull((Object)region.getEntry(key1));
                TestCase.assertNotNull((Object)region.getEntry(key2));
                TestCase.assertNotNull((Object)region.getEntry(key3));
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Apply delta", (com.gemstone.gemfire.internal.cache.delta.Delta)delta, key2, key3){
            final /* synthetic */ com.gemstone.gemfire.internal.cache.delta.Delta val$delta;
            final /* synthetic */ Object val$key2;
            final /* synthetic */ Object val$key3;
            {
                this.val$delta = delta;
                this.val$key2 = object2;
                this.val$key3 = object3;
                super(name2);
            }

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                region.put(key1, (Object)this.val$delta);
                region.put(this.val$key2, (Object)this.val$delta);
                region.put(this.val$key3, (Object)this.val$delta);
            }
        });
        CacheSerializableRunnable verify = new CacheSerializableRunnable("Verify values"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                Region.Entry entry1 = region.getEntry(key1);
                TestCase.assertNotNull((Object)entry1);
                TestCase.assertEquals((Object)"VALUE1 10", (Object)entry1.getValue());
                Region.Entry entry2 = region.getEntry(key2);
                TestCase.assertNotNull((Object)entry2);
                TestCase.assertEquals((Object)new Integer(51976), (Object)entry2.getValue());
                Region.Entry entry3 = region.getEntry(key3);
                TestCase.assertNotNull((Object)entry3);
                TestCase.assertEquals((Object)"VALUE3 10", (Object)entry3.getValue());
            }
        };
        this.invokeRepeatingIfNecessary(vm0, verify);
        vm0.invoke(new CacheSerializableRunnable("Remove local entries"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                region.localDestroyRegion();
            }
        });
        this.invokeRepeatingIfNecessary(vm2, verify);
    }

    public void testGetInitialImage() {
        if (!this.supportsReplication()) {
            return;
        }
        final String name = this.getUniqueName();
        final String key1 = "KEY1";
        final String value1 = "VALUE1";
        final String key2 = "KEY2";
        final String value2 = "VALUE2";
        final String key3 = "KEY3";
        final String value3 = "VALUE3";
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm2 = host.getVM(2);
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create Mirrored Region"){

            @Override
            public void run2() throws CacheException {
                RegionAttributes ra = MultiVMRegionTestCase.this.getRegionAttributes();
                AttributesFactory factory = new AttributesFactory(ra);
                if (ra.getEvictionAttributes() == null || !ra.getEvictionAttributes().getAction().isOverflowToDisk()) {
                    factory.setDiskStoreName(null);
                }
                factory.setDataPolicy(DataPolicy.REPLICATE);
                MultiVMRegionTestCase.this.createRegion(name, factory.create());
            }
        };
        vm0.invoke(create);
        vm0.invoke(new CacheSerializableRunnable("Put data"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                region.put(key1, value1);
                region.put(key2, value2);
                region.put(key3, value3);
            }
        });
        vm2.invoke(create);
        vm0.invoke(new CacheSerializableRunnable("Remove local entries"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                region.localDestroyRegion();
            }
        });
        vm2.invoke(new CacheSerializableRunnable("Verify keys/values"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                Region.Entry entry1 = region.getEntry(key1);
                TestCase.assertNotNull((Object)entry1);
                TestCase.assertEquals((Object)value1, (Object)entry1.getValue());
                Region.Entry entry2 = region.getEntry(key2);
                TestCase.assertNotNull((Object)entry2);
                TestCase.assertEquals((Object)value2, (Object)entry2.getValue());
                Region.Entry entry3 = region.getEntry(key3);
                TestCase.assertNotNull((Object)entry3);
                TestCase.assertEquals((Object)value3, (Object)entry3.getValue());
            }
        });
    }

    public void testLargeGetInitialImage() {
        if (!this.supportsReplication()) {
            return;
        }
        final String name = this.getUniqueName();
        final Integer[] keys = new Integer[100];
        final byte[][] values = new byte[100][];
        for (int i = 0; i < 100; ++i) {
            keys[i] = new Integer(i);
            values[i] = new byte[51200];
            Arrays.fill(values[i], (byte)66);
        }
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm2 = host.getVM(2);
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create Mirrored Region"){

            @Override
            public void run2() throws CacheException {
                RegionAttributes ra = MultiVMRegionTestCase.this.getRegionAttributes();
                AttributesFactory factory = new AttributesFactory(ra);
                if (ra.getEvictionAttributes() == null || !ra.getEvictionAttributes().getAction().isOverflowToDisk()) {
                    factory.setDiskStoreName(null);
                }
                factory.setDataPolicy(DataPolicy.REPLICATE);
                MultiVMRegionTestCase.this.createRegion(name, factory.create());
            }
        };
        vm0.invoke(create);
        vm0.invoke(new CacheSerializableRunnable("Put data"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                for (int i = 0; i < 100; ++i) {
                    region.put((Object)keys[i], (Object)values[i]);
                }
            }
        });
        vm2.invoke(create);
        vm0.invoke(new CacheSerializableRunnable("Remove local entries"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                region.localDestroyRegion();
            }
        });
        vm2.invoke(new CacheSerializableRunnable("Verify keys/values"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                TestCase.assertEquals((int)100, (int)region.entrySet(false).size());
                for (int i = 0; i < 100; ++i) {
                    Region.Entry entry = region.getEntry((Object)keys[i]);
                    TestCase.assertNotNull((Object)entry);
                    if (!(entry.getValue() instanceof byte[])) {
                        TestCase.fail((String)("getValue returned a " + entry.getValue().getClass() + " instead of the expected byte[]"));
                    }
                    TestCase.assertTrue((boolean)Arrays.equals(values[i], (byte[])entry.getValue()));
                }
            }
        });
    }

    public void testMirroredDataFromNonMirrored() throws InterruptedException {
        if (!this.supportsReplication()) {
            return;
        }
        final String name = this.getUniqueName();
        final String key1 = "KEY1";
        final String value1 = "VALUE1";
        final String key2 = "KEY2";
        final String value2 = "VALUE2";
        final String key3 = "KEY3";
        final String value3 = "VALUE3";
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm2 = host.getVM(2);
        CacheSerializableRunnable create = new CacheSerializableRunnable("Populate non-mirrored region"){

            @Override
            public void run2() throws CacheException {
                RegionAttributes ra = MultiVMRegionTestCase.this.getRegionAttributes();
                AttributesFactory fac = new AttributesFactory(ra);
                if (ra.getEvictionAttributes() == null || !ra.getEvictionAttributes().getAction().isOverflowToDisk()) {
                    fac.setDiskStoreName(null);
                }
                fac.setDataPolicy(DataPolicy.NORMAL);
                Region region = MultiVMRegionTestCase.this.createRegion(name, fac.create());
                region.put(key1, value1);
                region.put(key2, value2);
                region.put(key3, value3);
            }
        };
        vm0.invoke(new CacheSerializableRunnable("Create Mirrored Region"){

            @Override
            public void run2() throws CacheException {
                RegionAttributes ra = MultiVMRegionTestCase.this.getRegionAttributes();
                AttributesFactory factory = new AttributesFactory(ra);
                if (ra.getEvictionAttributes() == null || !ra.getEvictionAttributes().getAction().isOverflowToDisk()) {
                    factory.setDiskStoreName(null);
                }
                factory.setDataPolicy(DataPolicy.REPLICATE);
                class MirroredDataFromNonMirroredListener
                extends TestCacheListener {
                    List expectedKeys;
                    List expectedValues;
                    final /* synthetic */ Object val$key1;
                    final /* synthetic */ Object val$key2;
                    final /* synthetic */ Object val$key3;
                    final /* synthetic */ Object val$value1;
                    final /* synthetic */ Object val$value2;
                    final /* synthetic */ Object val$value3;

                    MirroredDataFromNonMirroredListener() {
                        this.val$key1 = object;
                        this.val$key2 = object2;
                        this.val$key3 = object3;
                        this.val$value1 = object4;
                        this.val$value2 = object5;
                        this.val$value3 = object6;
                        this.expectedKeys = new ArrayList<Object>(Arrays.asList(this.val$key1, this.val$key2, this.val$key3));
                        this.expectedValues = new ArrayList<Object>(Arrays.asList(this.val$value1, this.val$value2, this.val$value3));
                    }

                    @Override
                    public synchronized void afterCreate2(EntryEvent event) {
                        int index = this.expectedKeys.indexOf(event.getKey());
                        TestCase.assertTrue((index >= 0 ? 1 : 0) != 0);
                        TestCase.assertEquals(this.expectedValues.remove(index), (Object)event.getNewValue());
                        this.expectedKeys.remove(index);
                        DistributedTestCase.getLogWriter().info("afterCreate called in MirroredDataFromNonMirroredListener for key:" + event.getKey());
                    }
                }
                factory.addCacheListener((CacheListener)new MirroredDataFromNonMirroredListener(MultiVMRegionTestCase.this, key1, key2, key3, value1, value2, value3));
                MultiVMRegionTestCase.this.createRegion(name, factory.create());
            }
        });
        vm2.invoke(create);
        vm2.invoke(new CacheSerializableRunnable("Remove local entries"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                region.localDestroy(key1);
                region.localDestroy(key2);
                region.localDestroy(key3);
            }
        });
        this.pauseIfNecessary(500);
        vm0.invoke(new CacheSerializableRunnable("Verify keys/values and listener"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                Region.Entry entry1 = region.getEntry(key1);
                TestCase.assertNotNull((Object)entry1);
                TestCase.assertEquals((Object)value1, (Object)entry1.getValue());
                Region.Entry entry2 = region.getEntry(key2);
                TestCase.assertNotNull((Object)entry2);
                TestCase.assertEquals((Object)value2, (Object)entry2.getValue());
                Region.Entry entry3 = region.getEntry(key3);
                TestCase.assertNotNull((Object)entry3);
                TestCase.assertEquals((Object)value3, (Object)entry3.getValue());
                MirroredDataFromNonMirroredListener lsnr = (MirroredDataFromNonMirroredListener)region.getAttributes().getCacheListeners()[0];
                TestCase.assertTrue((boolean)lsnr.wasInvoked());
                TestCase.assertTrue((String)("expectedKeys should be empty, but was: " + lsnr.expectedKeys), (boolean)lsnr.expectedKeys.isEmpty());
            }
        });
    }

    public void testNoMirroredDataToNonMirrored() throws InterruptedException {
        if (!this.supportsReplication()) {
            return;
        }
        final String name = this.getUniqueName();
        final String key1 = "KEY1";
        final String value1 = "VALUE1";
        final String key2 = "KEY2";
        final String value2 = "VALUE2";
        final String key3 = "KEY3";
        final String value3 = "VALUE3";
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm2 = host.getVM(2);
        vm0.invoke(new CacheSerializableRunnable("Create Non-mirrored Region"){

            @Override
            public void run2() throws CacheException {
                MultiVMRegionTestCase.this.createRegion(name, MultiVMRegionTestCase.this.getRegionAttributes());
            }
        });
        CacheSerializableRunnable create = new CacheSerializableRunnable("Populate mirrored region"){

            @Override
            public void run2() throws CacheException {
                RegionAttributes ra = MultiVMRegionTestCase.this.getRegionAttributes();
                AttributesFactory factory = new AttributesFactory(ra);
                if (ra.getEvictionAttributes() == null || !ra.getEvictionAttributes().getAction().isOverflowToDisk()) {
                    factory.setDiskStoreName(null);
                }
                factory.setDataPolicy(DataPolicy.REPLICATE);
                Region region = MultiVMRegionTestCase.this.createRegion(name, factory.create());
                region.put(key1, value1);
                region.put(key2, value2);
                region.put(key3, value3);
            }
        };
        this.pauseIfNecessary();
        vm2.invoke(create);
        this.pauseIfNecessary();
        vm0.invoke(new CacheSerializableRunnable("Verify keys/values"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                Region.Entry entry1 = region.getEntry(key1);
                if (!MultiVMRegionTestCase.this.getRegionAttributes().getDataPolicy().withReplication()) {
                    if (entry1 != null) {
                        DistributedTestCase.getLogWriter().info("found entry " + entry1);
                    }
                    TestCase.assertNull((Object)entry1);
                } else {
                    TestCase.assertNotNull((Object)entry1);
                }
                Region.Entry entry2 = region.getEntry(key2);
                if (!MultiVMRegionTestCase.this.getRegionAttributes().getDataPolicy().withReplication()) {
                    TestCase.assertNull((Object)entry2);
                } else {
                    TestCase.assertNotNull((Object)entry2);
                }
                Region.Entry entry3 = region.getEntry(key3);
                if (!MultiVMRegionTestCase.this.getRegionAttributes().getDataPolicy().withReplication()) {
                    TestCase.assertNull((Object)entry3);
                } else {
                    TestCase.assertNotNull((Object)entry3);
                }
            }
        });
    }

    public void testMirroredLocalLoad() {
        if (!this.supportsReplication()) {
            return;
        }
        final String name = this.getUniqueName();
        final String key = "KEY";
        final String value = "VALUE";
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm2 = host.getVM(2);
        vm0.invoke(new CacheSerializableRunnable("Create region with loader"){

            @Override
            public void run2() throws CacheException {
                RegionAttributes ra = MultiVMRegionTestCase.this.getRegionAttributes();
                AttributesFactory factory = new AttributesFactory(ra);
                if (ra.getEvictionAttributes() == null || !ra.getEvictionAttributes().getAction().isOverflowToDisk()) {
                    factory.setDiskStoreName(null);
                }
                factory.setDataPolicy(DataPolicy.REPLICATE);
                factory.setCacheLoader((CacheLoader)new TestCacheLoader(){

                    @Override
                    public Object load2(LoaderHelper helper) throws CacheLoaderException {
                        return value;
                    }
                });
                MultiVMRegionTestCase.this.createRegion(name, factory.create());
            }
        });
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create region with bad loader"){

            @Override
            public void run2() throws CacheException {
                RegionAttributes ra = MultiVMRegionTestCase.this.getRegionAttributes();
                AttributesFactory factory = new AttributesFactory(ra);
                if (ra.getEvictionAttributes() == null || !ra.getEvictionAttributes().getAction().isOverflowToDisk()) {
                    factory.setDiskStoreName(null);
                }
                factory.setDataPolicy(DataPolicy.REPLICATE);
                RegionTestCase.loader = new TestCacheLoader(){

                    @Override
                    public Object load2(LoaderHelper helper) throws CacheLoaderException {
                        TestCase.fail((String)"Should not be invoked");
                        return null;
                    }
                };
                factory.setCacheLoader((CacheLoader)RegionTestCase.loader);
                MultiVMRegionTestCase.this.createRegion(name, factory.create());
            }
        };
        vm2.invoke(create);
        vm0.invoke(new CacheSerializableRunnable("Get"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                TestCase.assertEquals((Object)value, (Object)region.get(key));
            }
        });
        vm2.invoke(new CacheSerializableRunnable("Verify no load"){

            @Override
            public void run2() throws CacheException {
                TestCase.assertFalse((boolean)RegionTestCase.loader.wasInvoked());
            }
        });
    }

    public void testMirroredNetLoad() {
        if (!this.supportsReplication()) {
            return;
        }
        final String name = this.getUniqueName();
        final String key = "KEY";
        final String value = "VALUE";
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm2 = host.getVM(2);
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create region with loader"){

            @Override
            public void run2() throws CacheException {
                RegionAttributes ra = MultiVMRegionTestCase.this.getRegionAttributes();
                AttributesFactory factory = new AttributesFactory(ra);
                if (ra.getEvictionAttributes() == null || !ra.getEvictionAttributes().getAction().isOverflowToDisk()) {
                    factory.setDiskStoreName(null);
                }
                factory.setDataPolicy(DataPolicy.REPLICATE);
                factory.setCacheLoader((CacheLoader)new TestCacheLoader(){

                    @Override
                    public Object load2(LoaderHelper helper) throws CacheLoaderException {
                        return value;
                    }
                });
                MultiVMRegionTestCase.this.createRegion(name, factory.create());
            }
        };
        vm0.invoke(new CacheSerializableRunnable("Create region with bad loader"){

            @Override
            public void run2() throws CacheException {
                RegionAttributes ra = MultiVMRegionTestCase.this.getRegionAttributes();
                AttributesFactory factory = new AttributesFactory(ra);
                if (ra.getEvictionAttributes() == null || !ra.getEvictionAttributes().getAction().isOverflowToDisk()) {
                    factory.setDiskStoreName(null);
                }
                factory.setDataPolicy(DataPolicy.REPLICATE);
                MultiVMRegionTestCase.this.createRegion(name, factory.create());
            }
        });
        vm2.invoke(create);
        vm0.invoke(new CacheSerializableRunnable("Get"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                TestCase.assertEquals((Object)value, (Object)region.get(key));
            }
        });
    }

    public void testNoRegionKeepAlive() throws InterruptedException {
        final String name = this.getUniqueName();
        final String key = "KEEP_ALIVE_KEY";
        final String value = "VALUE";
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        vm0.invoke(new CacheSerializableRunnable("Create region"){

            @Override
            public void run2() throws CacheException {
                MultiVMRegionTestCase.this.createRegion(name);
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Populate region"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                region.put(key, value);
                TestCase.assertEquals((Object)value, (Object)region.get(key));
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Close cache"){

            @Override
            public void run2() throws CacheException {
                CacheTestCase.closeCache();
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Re-create cache"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.createRegion(name);
                if (region.getAttributes().getDataPolicy().withPersistence()) {
                    TestCase.assertEquals((Object)value, (Object)region.get(key));
                } else {
                    TestCase.assertNull((Object)region.get(key));
                }
            }
        });
    }

    public void testNetSearchObservesTtl() throws InterruptedException {
        if (this.getRegionAttributes().getPartitionAttributes() != null) {
            return;
        }
        final String name = this.getUniqueName();
        int shortTimeout = 10;
        int longTimeout = 1000000;
        final String key = "KEY";
        final String value = "VALUE";
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(2);
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create with TTL"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run2() throws CacheException {
                AttributesFactory factory = new AttributesFactory(MultiVMRegionTestCase.this.getRegionAttributes());
                factory.setStatisticsEnabled(true);
                ExpirationAttributes expire = new ExpirationAttributes(1000000, ExpirationAction.DESTROY);
                factory.setEntryTimeToLive(expire);
                Region region = null;
                System.setProperty("gemfire.EXPIRY_UNITS_MS", "true");
                try {
                    region = MultiVMRegionTestCase.this.createRegion(name, factory.create());
                    region.create(key, value);
                }
                finally {
                    System.getProperties().remove("gemfire.EXPIRY_UNITS_MS");
                }
            }
        };
        vm1.invoke(create);
        vm0.invoke(new CacheSerializableRunnable("Create with TTL"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run2() throws CacheException {
                boolean partitioned;
                RegionAttributes ra = MultiVMRegionTestCase.this.getRegionAttributes();
                AttributesFactory factory = new AttributesFactory(ra);
                boolean bl = partitioned = ra.getPartitionAttributes() != null || ra.getDataPolicy().withPartitioning();
                if (!partitioned) {
                    if (ra.getEvictionAttributes() == null || !ra.getEvictionAttributes().getAction().isOverflowToDisk()) {
                        factory.setDiskStoreName(null);
                    }
                    factory.setDataPolicy(DataPolicy.NORMAL);
                }
                factory.setStatisticsEnabled(true);
                ExpirationAttributes expire = new ExpirationAttributes(10, ExpirationAction.DESTROY);
                factory.setEntryTimeToLive(expire);
                System.setProperty("gemfire.EXPIRY_UNITS_MS", "true");
                try {
                    MultiVMRegionTestCase.this.createRegion(name, factory.create());
                }
                finally {
                    System.getProperties().remove("gemfire.EXPIRY_UNITS_MS");
                }
            }
        });
        MultiVMRegionTestCase.pause(100);
        vm0.invoke(new CacheSerializableRunnable("get(key), expect null"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                Object got = region.get(key);
                TestCase.assertNull((Object)got);
            }
        });
        vm1.invoke(new CacheSerializableRunnable("get(key), expect value"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                Object got = region.get(key);
                TestCase.assertEquals((Object)value, (Object)got);
            }
        });
    }

    public void testNetSearchObservesIdleTime() throws InterruptedException {
        if (this.getRegionAttributes().getPartitionAttributes() != null) {
            return;
        }
        final String name = this.getUniqueName();
        int shortTimeout = 10;
        int longTimeout = 10000;
        final String key = "KEY";
        final String value = "VALUE";
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(2);
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create with IdleTimeout"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run2() throws CacheException {
                AttributesFactory factory = new AttributesFactory(MultiVMRegionTestCase.this.getRegionAttributes());
                factory.setStatisticsEnabled(true);
                ExpirationAttributes expire = new ExpirationAttributes(10000, ExpirationAction.DESTROY);
                factory.setEntryIdleTimeout(expire);
                Region region = null;
                System.setProperty("gemfire.EXPIRY_UNITS_MS", "true");
                try {
                    region = MultiVMRegionTestCase.this.createRegion(name, factory.create());
                    region.create(key, value);
                }
                finally {
                    System.getProperties().remove("gemfire.EXPIRY_UNITS_MS");
                }
            }
        };
        vm1.invoke(create);
        vm0.invoke(new CacheSerializableRunnable("Create with IdleTimeout"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run2() throws CacheException {
                boolean partitioned;
                RegionAttributes ra = MultiVMRegionTestCase.this.getRegionAttributes();
                AttributesFactory factory = new AttributesFactory(ra);
                boolean bl = partitioned = ra.getPartitionAttributes() != null || ra.getDataPolicy().withPartitioning();
                if (!partitioned) {
                    if (ra.getEvictionAttributes() == null || !ra.getEvictionAttributes().getAction().isOverflowToDisk()) {
                        factory.setDiskStoreName(null);
                    }
                    factory.setDataPolicy(DataPolicy.NORMAL);
                }
                factory.setStatisticsEnabled(true);
                ExpirationAttributes expire = new ExpirationAttributes(10, ExpirationAction.DESTROY);
                factory.setEntryIdleTimeout(expire);
                System.setProperty("gemfire.EXPIRY_UNITS_MS", "true");
                try {
                    MultiVMRegionTestCase.this.createRegion(name, factory.create());
                }
                finally {
                    System.getProperties().remove("gemfire.EXPIRY_UNITS_MS");
                }
            }
        });
        MultiVMRegionTestCase.pause(20);
        vm0.invoke(new CacheSerializableRunnable("get(key), expect null"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                Object got = region.get(key);
                TestCase.assertNull((Object)got);
            }
        });
        vm1.invoke(new CacheSerializableRunnable("get(key), expect value"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                Object got = region.get(key);
                TestCase.assertEquals((Object)value, (Object)got);
            }
        });
    }

    public void testEntryTtlDestroyEvent() throws InterruptedException {
        if (this.getRegionAttributes().getPartitionAttributes() != null) {
            return;
        }
        final String name = this.getUniqueName();
        int timeout = 40;
        final String key = "KEY";
        final String value = "VALUE";
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        CacheSerializableRunnable create = new CacheSerializableRunnable("Populate"){

            @Override
            public void run2() throws CacheException {
                AttributesFactory fac = new AttributesFactory(MultiVMRegionTestCase.this.getRegionAttributes());
                class DestroyListener
                extends TestCacheListener {
                    boolean eventIsExpiration = false;
                    final /* synthetic */ Object val$value;

                    DestroyListener() {
                        this.val$value = object;
                    }

                    @Override
                    public void afterDestroyBeforeAddEvent(EntryEvent event) {
                        this.eventIsExpiration = event.isExpiration();
                    }

                    @Override
                    public void afterDestroy2(EntryEvent event) {
                        if (event.isOriginRemote()) {
                            TestCase.assertTrue((!event.getDistributedMember().equals(MultiVMRegionTestCase.this.getSystem().getDistributedMember()) ? 1 : 0) != 0);
                        } else {
                            TestCase.assertEquals((Object)MultiVMRegionTestCase.this.getSystem().getDistributedMember(), (Object)event.getDistributedMember());
                        }
                        TestCase.assertEquals((Object)Operation.EXPIRE_DESTROY, (Object)event.getOperation());
                        TestCase.assertEquals((Object)this.val$value, (Object)event.getOldValue());
                        this.eventIsExpiration = event.getOperation().isExpiration();
                    }

                    @Override
                    public void afterCreate2(EntryEvent event) {
                    }

                    @Override
                    public void afterUpdate2(EntryEvent event) {
                    }
                }
                destroyListener = new DestroyListener(MultiVMRegionTestCase.this, value);
                fac.addCacheListener((CacheListener)destroyListener);
                Region region = null;
                System.setProperty("gemfire.EXPIRY_UNITS_MS", "true");
                try {
                    region = MultiVMRegionTestCase.this.createRegion(name, fac.create());
                }
                finally {
                    System.getProperties().remove("gemfire.EXPIRY_UNITS_MS");
                }
            }
        };
        vm1.invoke(create);
        vm0.invoke(new CacheSerializableRunnable("Create with TTL"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run2() throws CacheException {
                AttributesFactory factory = new AttributesFactory(MultiVMRegionTestCase.this.getRegionAttributes());
                boolean partitioned = MultiVMRegionTestCase.this.getRegionAttributes().getPartitionAttributes() != null || MultiVMRegionTestCase.this.getRegionAttributes().getDataPolicy().withPartitioning();
                factory.setStatisticsEnabled(true);
                ExpirationAttributes expire = new ExpirationAttributes(40, ExpirationAction.DESTROY);
                factory.setEntryTimeToLive(expire);
                if (!MultiVMRegionTestCase.this.getRegionAttributes().getDataPolicy().withReplication() && !partitioned) {
                    factory.setDataPolicy(DataPolicy.NORMAL);
                    factory.setSubscriptionAttributes(new SubscriptionAttributes(InterestPolicy.ALL));
                }
                System.setProperty("gemfire.EXPIRY_UNITS_MS", "true");
                try {
                    MultiVMRegionTestCase.this.createRegion(name, factory.create());
                }
                finally {
                    System.getProperties().remove("gemfire.EXPIRY_UNITS_MS");
                }
            }
        });
        vm1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                region.put(key, value);
                TestCase.assertTrue((boolean)((DestroyListener)region.getAttributes().getCacheListeners()[0]).wasInvoked());
                return null;
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Check local destroy"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                int retries = 10;
                while (region.getEntry(key) != null && retries-- > 0) {
                    DistributedTestCase.pause(40);
                }
                TestCase.assertNull((Object)region.getEntry(key));
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Verify destroyed and event"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                int retries = 10;
                while (region.getEntry(key) != null && retries-- > 0) {
                    DistributedTestCase.pause(40);
                }
                TestCase.assertNull((Object)region.getEntry(key));
                TestCase.assertTrue((boolean)destroyListener.waitForInvocation(555));
                TestCase.assertTrue((boolean)((DestroyListener)MultiVMRegionTestCase.destroyListener).eventIsExpiration);
            }
        });
    }

    public void testEntryTtlLocalDestroy() throws InterruptedException {
        if (this.getRegionAttributes().getPartitionAttributes() != null) {
            return;
        }
        final boolean mirrored = this.getRegionAttributes().getDataPolicy().withReplication();
        final boolean partitioned = this.getRegionAttributes().getPartitionAttributes() != null || this.getRegionAttributes().getDataPolicy().withPartitioning();
        final String name = this.getUniqueName();
        int timeout = 10;
        final String key = "KEY";
        final String value = "VALUE";
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        CacheSerializableRunnable create = new CacheSerializableRunnable("Populate"){

            @Override
            public void run2() throws CacheException {
                System.setProperty("gemfire.EXPIRY_UNITS_MS", "true");
                try {
                    Region region = MultiVMRegionTestCase.this.createRegion(name);
                }
                finally {
                    System.getProperties().remove("gemfire.EXPIRY_UNITS_MS");
                }
            }
        };
        vm1.invoke(create);
        vm0.invoke(new CacheSerializableRunnable("Create with TTL"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run2() throws CacheException {
                AttributesFactory factory = new AttributesFactory(MultiVMRegionTestCase.this.getRegionAttributes());
                factory.setStatisticsEnabled(true);
                ExpirationAttributes expire = new ExpirationAttributes(10, ExpirationAction.LOCAL_DESTROY);
                factory.setEntryTimeToLive(expire);
                if (!mirrored) {
                    if (!partitioned) {
                        factory.setDataPolicy(DataPolicy.NORMAL);
                    }
                    factory.setSubscriptionAttributes(new SubscriptionAttributes(InterestPolicy.ALL));
                    factory.addCacheListener((CacheListener)new CountingDistCacheListener());
                }
                System.setProperty("gemfire.EXPIRY_UNITS_MS", "true");
                try {
                    MultiVMRegionTestCase.this.createRegion(name, factory.create());
                    if (mirrored) {
                        TestCase.fail((String)"Should have thrown an IllegalStateException");
                    }
                }
                catch (IllegalStateException e) {
                    if (!mirrored) {
                        throw e;
                    }
                }
                finally {
                    System.getProperties().remove("gemfire.EXPIRY_UNITS_MS");
                }
            }
        });
        if (mirrored) {
            return;
        }
        vm1.invoke(new SerializableCallable(){

            public Object call() throws Exception {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                region.put(key, value);
                return null;
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Check local destroy"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                CountingDistCacheListener l = (CountingDistCacheListener)region.getAttributes().getCacheListeners()[0];
                int retry = 100;
                while (retry-- > 0) {
                    try {
                        l.assertCount(1, 0, 0, 0);
                        break;
                    }
                    catch (AssertionFailedError e) {
                        if (retry > 0) {
                            DistributedTestCase.pause(1);
                            continue;
                        }
                        throw e;
                    }
                }
                int retry2 = 10;
                while (retry2-- > 0 && region.getEntry(key) != null) {
                    DistributedTestCase.pause(10);
                }
                TestCase.assertNull((Object)region.getEntry(key));
            }
        });
        vm1.invoke(new CacheSerializableRunnable("Verify local"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                Region.Entry entry = region.getEntry(key);
                TestCase.assertEquals((Object)value, (Object)entry.getValue());
            }
        });
    }

    public void testUpdateResetsIdleTime() throws InterruptedException {
        final String name = this.getUniqueName();
        int timeout = 2;
        final String key = "KEY";
        final String value = "VALUE";
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        vm1.invoke(new CacheSerializableRunnable("Create Region " + name){

            @Override
            public void run2() throws CacheException {
                AttributesFactory factory = new AttributesFactory(MultiVMRegionTestCase.this.getRegionAttributes());
                factory.setStatisticsEnabled(true);
                ExpirationAttributes expire = new ExpirationAttributes(2, ExpirationAction.DESTROY);
                factory.setEntryIdleTimeout(expire);
                if (MultiVMRegionTestCase.this.getRegionAttributes().getPartitionAttributes() != null) {
                    MultiVMRegionTestCase.this.createRegion(name, factory.create());
                } else {
                    MultiVMRegionTestCase.this.createRegion(name);
                }
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Create with Idle"){

            @Override
            public void run2() throws CacheException {
                AttributesFactory factory = new AttributesFactory(MultiVMRegionTestCase.this.getRegionAttributes());
                factory.setStatisticsEnabled(true);
                ExpirationAttributes expire = new ExpirationAttributes(2, ExpirationAction.DESTROY);
                factory.setEntryIdleTimeout(expire);
                Region region = MultiVMRegionTestCase.this.createRegion(name, factory.create());
                region.create(key, null);
            }
        });
        MultiVMRegionTestCase.pause(1000);
        vm1.invoke(new CacheSerializableRunnable("Update entry"){

            @Override
            public void run2() throws CacheException {
                Region r = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                TestCase.assertNotNull((Object)r);
                r.put(key, value);
            }
        });
        final long tilt1 = System.currentTimeMillis();
        MultiVMRegionTestCase.pause(1125);
        vm0.invoke(new CacheSerializableRunnable("Verify reset"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                Region.Entry entry = region.getEntry(key);
                if (entry == null) {
                    TestCase.assertTrue((System.currentTimeMillis() >= tilt1 ? 1 : 0) != 0);
                    TestCase.fail((String)"testUpdateResetsIdleTime: machine too slow to validate");
                }
                TestCase.assertEquals((Object)value, (Object)entry.getValue());
            }
        });
        MultiVMRegionTestCase.pause(2500);
        vm0.invoke(new CacheSerializableRunnable("Verify destroy"){

            @Override
            public void run2() throws CacheException {
                DistributedTestCase.WaitCriterion wc = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                        Region.Entry entry = region.getEntry(key);
                        return entry == null;
                    }

                    @Override
                    public String description() {
                        return "Entry never destroyed";
                    }
                };
                DistributedTestCase.waitForCriterion(wc, 30000L, 1000L, true);
            }
        });
    }

    public void testNonblockingGetInitialImage() throws Throwable {
        if (!this.supportsReplication()) {
            return;
        }
        if (this.getRegionAttributes().getScope().isGlobal()) {
            return;
        }
        final String name = this.getUniqueName();
        final byte[][] values = new byte[1000][];
        for (int i = 0; i < 1000; ++i) {
            values[i] = new byte[5120];
            Arrays.fill(values[i], (byte)66);
        }
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm2 = host.getVM(2);
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create Mirrored Region"){

            @Override
            public void run2() throws CacheException {
                CacheTestCase.beginCacheXml();
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.DISTRIBUTED_ACK);
                factory.setDataPolicy(DataPolicy.NORMAL);
                factory.setSubscriptionAttributes(new SubscriptionAttributes(InterestPolicy.ALL));
                DistributedTestCase.getLogWriter().info("MJT DEBUG: attrs0 are " + factory.create());
                MultiVMRegionTestCase.this.createRootRegion(factory.create());
                factory = new AttributesFactory(MultiVMRegionTestCase.this.getRegionAttributes());
                factory.setSubscriptionAttributes(new SubscriptionAttributes(InterestPolicy.ALL));
                if (MultiVMRegionTestCase.this.getRegionAttributes().getDataPolicy() == DataPolicy.NORMAL) {
                    factory.setDataPolicy(DataPolicy.PRELOADED);
                }
                DistributedTestCase.getLogWriter().info("MJT DEBUG: attrs1 are " + factory.create());
                Region region = MultiVMRegionTestCase.this.createRegion(name, factory.create());
                MultiVMRegionTestCase.this.finishCacheXml(name);
                InitialImageOperation.slowImageProcessing = 0;
            }
        };
        vm0.invoke(new CacheSerializableRunnable("Create Nonmirrored Region"){

            @Override
            public void run2() throws CacheException {
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.DISTRIBUTED_ACK);
                factory.setDataPolicy(DataPolicy.EMPTY);
                MultiVMRegionTestCase.this.createRootRegion(factory.create());
                factory = new AttributesFactory(MultiVMRegionTestCase.this.getRegionAttributes());
                MultiVMRegionTestCase.this.createRegion(name, factory.create());
                InitialImageOperation.slowImageProcessing = 0;
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Put initial data"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                for (int i = 0; i < 1000; ++i) {
                    region.put((Object)new Integer(i), (Object)values[i]);
                }
                TestCase.assertEquals((int)1000, (int)region.keySet().size());
            }
        });
        AsyncInvocation async = vm0.invokeAsync(new CacheSerializableRunnable("Do Nonblocking Operations"){

            @Override
            public void run2() throws CacheException {
                int i;
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                final CacheDistributionAdvisor adv = ((DistributedRegion)region).getCacheDistributionAdvisor();
                boolean expectedProfiles = true;
                DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        DataPolicy currentPolicy = MultiVMRegionTestCase.this.getRegionAttributes().getDataPolicy();
                        if (currentPolicy == DataPolicy.PRELOADED) {
                            return adv.advisePreloadeds().size() + adv.adviseReplicates().size() >= 1;
                        }
                        return adv.adviseReplicates().size() >= 1;
                    }

                    @Override
                    public String description() {
                        return "replicate count never reached 1";
                    }
                };
                DistributedTestCase.waitForCriterion(ev, 20000L, 200L, true);
                DataPolicy currentPolicy = MultiVMRegionTestCase.this.getRegionAttributes().getDataPolicy();
                int numProfiles = 0;
                numProfiles = currentPolicy == DataPolicy.PRELOADED ? adv.advisePreloadeds().size() + adv.adviseReplicates().size() : adv.adviseReplicates().size();
                Assert.assertTrue((numProfiles >= 1 ? 1 : 0) != 0);
                block5: for (i = 1; i < 1000; i += 2) {
                    Integer key = new Integer(i);
                    DistributedTestCase.getLogWriter().info("Operation #" + i + " on key " + key);
                    switch (i % 6) {
                        case 1: {
                            Long value = new Long(System.currentTimeMillis());
                            region.put((Object)key, (Object)value);
                            continue block5;
                        }
                        case 3: {
                            region.invalidate((Object)key);
                            if (!MultiVMRegionTestCase.this.getRegionAttributes().getScope().isDistributedAck()) continue block5;
                            TestCase.assertNull((Object)region.get((Object)key));
                            continue block5;
                        }
                        case 5: {
                            region.destroy((Object)key);
                            if (!MultiVMRegionTestCase.this.getRegionAttributes().getScope().isDistributedAck()) continue block5;
                            TestCase.assertNull((Object)region.get((Object)key));
                            continue block5;
                        }
                        default: {
                            TestCase.fail((String)("unexpected modulus result: " + i));
                        }
                    }
                }
                for (i = 1000; i < 1200; ++i) {
                    region.create((Object)new Integer(i), (Object)new Long(System.currentTimeMillis()));
                }
                MultiVMRegionTestCase.this.getRootRegion().put((Object)"DONE", (Object)"FLUSH_OPS");
            }
        });
        if (!this.getRegionAttributes().getScope().isGlobal()) {
            vm2.invoke(new SerializableRunnable("Set slow image processing"){

                @Override
                public void run() {
                    int pause;
                    InitialImageOperation.slowImageProcessing = pause = 200;
                }
            });
        }
        MultiVMRegionTestCase.getLogWriter().info("Before GetInitialImage, data policy is " + this.getRegionAttributes().getDataPolicy() + ", scope is " + this.getRegionAttributes().getScope());
        AsyncInvocation asyncGII = vm2.invokeAsync(create);
        if (!this.getRegionAttributes().getScope().isGlobal()) {
            DistributedTestCase.join(async, 30000L, MultiVMRegionTestCase.getLogWriter());
            vm2.invoke(new SerializableRunnable("Set fast image processing"){

                @Override
                public void run() {
                    InitialImageOperation.slowImageProcessing = 0;
                }
            });
            MultiVMRegionTestCase.getLogWriter().info("after async nonblocking ops complete");
        }
        DistributedTestCase.join(asyncGII, 30000L, MultiVMRegionTestCase.getLogWriter());
        final long iiComplete = System.currentTimeMillis();
        MultiVMRegionTestCase.getLogWriter().info("Complete GetInitialImage at: " + System.currentTimeMillis());
        if (this.getRegionAttributes().getScope().isGlobal()) {
            DistributedTestCase.join(async, 30000L, MultiVMRegionTestCase.getLogWriter());
        }
        if (async.exceptionOccurred()) {
            MultiVMRegionTestCase.fail("async failed", async.getException());
        }
        if (asyncGII.exceptionOccurred()) {
            MultiVMRegionTestCase.fail("asyncGII failed", asyncGII.getException());
        }
        vm0.invoke(new CacheSerializableRunnable("Locally destroy region"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                region.localDestroyRegion();
            }
        });
        MultiVMRegionTestCase.getLogWriter().info("after localDestroyRegion");
        vm2.invokeRepeatingIfNecessary(new CacheSerializableRunnable("Verify entryCount"){
            boolean entriesDumped;
            {
                super(name2);
                this.entriesDumped = false;
            }

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                int entryCount = 1034;
                int actualCount = region.entrySet(false).size();
                if (actualCount == 1200) {
                    this.dumpDestroyedEntries(region);
                }
                TestCase.assertEquals((int)entryCount, (int)actualCount);
            }

            private void dumpDestroyedEntries(Region region) throws EntryNotFoundException {
                if (this.entriesDumped) {
                    return;
                }
                this.entriesDumped = true;
                LogWriter logger = DistributedTestCase.getLogWriter();
                logger.info("DUMPING Entries with values in VM that should have been destroyed:");
                for (int i = 5; i < 1000; i += 6) {
                    try {
                        logger.info(i + "-->" + ((LocalRegion)region).getValueInVM((Object)new Integer(i)));
                        continue;
                    }
                    catch (EntryNotFoundException expected) {
                        logger.info(i + "-->CORRECTLY DESTROYED");
                    }
                }
            }
        }, 5000L);
        MultiVMRegionTestCase.getLogWriter().info("after verify entryCount");
        vm2.invoke(new CacheSerializableRunnable("Verify keys/values & Nonblocking"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                int entryCount = 1034;
                TestCase.assertEquals((int)entryCount, (int)region.entrySet(false).size());
                int numConcurrent = 0;
                block6: for (int i = 0; i < 1200; ++i) {
                    Long timestamp;
                    Object v;
                    Region.Entry entry = region.getEntry((Object)new Integer(i));
                    Object object = v = entry == null ? null : entry.getValue();
                    if (i < 1000) {
                        switch (i % 6) {
                            case 0: 
                            case 2: 
                            case 4: {
                                TestCase.assertNotNull((Object)entry);
                                TestCase.assertTrue((boolean)Arrays.equals(values[i], (byte[])v));
                                break;
                            }
                            case 1: {
                                TestCase.assertNotNull((Object)v);
                                TestCase.assertTrue((String)("Value for key " + i + " is not a Long, is a " + v.getClass().getName()), (boolean)(v instanceof Long));
                                timestamp = (Long)entry.getValue();
                                if (timestamp >= iiComplete) continue block6;
                                ++numConcurrent;
                                break;
                            }
                            case 3: {
                                TestCase.assertNotNull((Object)entry);
                                TestCase.assertNull((String)("Expected value for " + i + " to be null, but was " + v), (Object)v);
                                break;
                            }
                            case 5: {
                                TestCase.assertNull((Object)entry);
                                break;
                            }
                            default: {
                                TestCase.fail((String)("unexpected modulus result: " + i % 6));
                                break;
                            }
                        }
                        continue;
                    }
                    TestCase.assertNotNull((Object)v);
                    TestCase.assertTrue((String)("Value for key " + i + " is not a Long, is a " + v.getClass().getName()), (boolean)(v instanceof Long));
                    timestamp = (Long)entry.getValue();
                    if (timestamp >= iiComplete) continue;
                    ++numConcurrent;
                }
                DistributedTestCase.getLogWriter().info(name + ": " + numConcurrent + " entries out of " + entryCount + " were updated concurrently with getInitialImage");
                if (region.getAttributes().getScope().isGlobal()) {
                    TestCase.assertTrue((String)("Too many concurrent updates when expected to block: " + numConcurrent), (numConcurrent < 10 ? 1 : 0) != 0);
                } else {
                    int min = 30;
                    TestCase.assertTrue((String)("Not enough updates concurrent with getInitialImage occurred to my liking. " + numConcurrent + " entries out of " + entryCount + " were updated concurrently with getInitialImage, and I'd expect at least " + min + " or so"), (numConcurrent >= min ? 1 : 0) != 0);
                }
            }
        });
        MultiVMRegionTestCase.getLogWriter().info("after verify key/values");
    }

    public void DISABLED_TILL_NEW_TX_IMPL_COMPLETE_testTXNonblockingGetInitialImage() throws Throwable {
        if (!this.supportsReplication()) {
            return;
        }
        if (!this.supportsTransactions()) {
            return;
        }
        if (this.getRegionAttributes().getScope().isGlobal() || this.getRegionAttributes().getDataPolicy().withPersistence()) {
            return;
        }
        final String name = this.getUniqueName();
        final byte[][] values = new byte[1000][];
        for (int i = 0; i < 1000; ++i) {
            values[i] = new byte[5120];
            Arrays.fill(values[i], (byte)66);
        }
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm2 = host.getVM(2);
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create Mirrored Region"){

            @Override
            public void run2() throws CacheException {
                CacheTestCase.beginCacheXml();
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.DISTRIBUTED_ACK);
                factory.setDataPolicy(DataPolicy.NORMAL);
                factory.setSubscriptionAttributes(new SubscriptionAttributes(InterestPolicy.ALL));
                MultiVMRegionTestCase.this.createRootRegion(factory.create());
                factory = new AttributesFactory(MultiVMRegionTestCase.this.getRegionAttributes());
                if (MultiVMRegionTestCase.this.getRegionAttributes().getDataPolicy() == DataPolicy.NORMAL) {
                    factory.setDataPolicy(DataPolicy.PRELOADED);
                }
                factory.setSubscriptionAttributes(new SubscriptionAttributes(InterestPolicy.ALL));
                MultiVMRegionTestCase.this.createRegion(name, factory.create());
                MultiVMRegionTestCase.this.finishCacheXml(name);
                InitialImageOperation.slowImageProcessing = 0;
            }
        };
        vm0.invoke(new CacheSerializableRunnable("Create Nonmirrored Region"){

            @Override
            public void run2() throws CacheException {
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.DISTRIBUTED_ACK);
                factory.setDataPolicy(DataPolicy.EMPTY);
                MultiVMRegionTestCase.this.createRootRegion(factory.create());
                factory = new AttributesFactory(MultiVMRegionTestCase.this.getRegionAttributes());
                MultiVMRegionTestCase.this.createRegion(name, factory.create());
                InitialImageOperation.slowImageProcessing = 0;
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Put initial data"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                for (int i = 0; i < 1000; ++i) {
                    region.put((Object)new Integer(i), (Object)values[i]);
                }
                TestCase.assertEquals((int)1000, (int)region.keySet().size());
            }
        });
        AsyncInvocation async = vm0.invokeAsync(new CacheSerializableRunnable("Do Nonblocking Operations"){

            @Override
            public void run2() throws CacheException {
                int i;
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                final CacheDistributionAdvisor adv = ((DistributedRegion)region).getCacheDistributionAdvisor();
                boolean expectedProfiles = true;
                DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        DataPolicy currentPolicy = MultiVMRegionTestCase.this.getRegionAttributes().getDataPolicy();
                        if (currentPolicy == DataPolicy.PRELOADED) {
                            return adv.advisePreloadeds().size() + adv.adviseReplicates().size() >= 1;
                        }
                        return adv.adviseReplicates().size() >= 1;
                    }

                    @Override
                    public String description() {
                        return "replicate count never reached 1";
                    }
                };
                DistributedTestCase.waitForCriterion(ev, 100000L, 200L, true);
                CacheTransactionManager txMgr = MultiVMRegionTestCase.this.getCache().getCacheTransactionManager();
                block5: for (i = 1; i < 1000; i += 2) {
                    Integer key = new Integer(i);
                    switch (i % 6) {
                        case 1: {
                            Long value = new Long(System.currentTimeMillis());
                            txMgr.begin();
                            region.put((Object)key, (Object)value);
                            txMgr.commit();
                            continue block5;
                        }
                        case 3: {
                            txMgr.begin();
                            region.invalidate((Object)key);
                            txMgr.commit();
                            if (!MultiVMRegionTestCase.this.getRegionAttributes().getScope().isDistributedAck()) continue block5;
                            TestCase.assertNull((Object)region.get((Object)key));
                            continue block5;
                        }
                        case 5: {
                            txMgr.begin();
                            region.destroy((Object)key);
                            txMgr.commit();
                            if (!MultiVMRegionTestCase.this.getRegionAttributes().getScope().isDistributedAck()) continue block5;
                            TestCase.assertNull((Object)region.get((Object)key));
                            continue block5;
                        }
                        default: {
                            TestCase.fail((String)("unexpected modulus result: " + i));
                        }
                    }
                }
                for (i = 1000; i < 1200; ++i) {
                    txMgr.begin();
                    region.create((Object)new Integer(i), (Object)new Long(System.currentTimeMillis()));
                    txMgr.commit();
                }
                MultiVMRegionTestCase.this.getRootRegion().put((Object)"DONE", (Object)"FLUSH_OPS");
            }
        });
        if (!this.getRegionAttributes().getScope().isGlobal()) {
            vm2.invoke(new SerializableRunnable("Set slow image processing"){

                @Override
                public void run() {
                    int pause;
                    InitialImageOperation.slowImageProcessing = pause = 200;
                }
            });
        }
        AsyncInvocation asyncGII = vm2.invokeAsync(create);
        if (!this.getRegionAttributes().getScope().isGlobal()) {
            DistributedTestCase.join(async, 30000L, MultiVMRegionTestCase.getLogWriter());
            vm2.invoke(new SerializableRunnable("Set fast image processing"){

                @Override
                public void run() {
                    InitialImageOperation.slowImageProcessing = 0;
                }
            });
            MultiVMRegionTestCase.getLogWriter().info("after async nonblocking ops complete");
        }
        DistributedTestCase.join(asyncGII, 30000L, MultiVMRegionTestCase.getLogWriter());
        final long iiComplete = System.currentTimeMillis();
        MultiVMRegionTestCase.getLogWriter().info("Complete GetInitialImage at: " + System.currentTimeMillis());
        if (this.getRegionAttributes().getScope().isGlobal()) {
            DistributedTestCase.join(async, 30000L, MultiVMRegionTestCase.getLogWriter());
        }
        if (async.exceptionOccurred()) {
            MultiVMRegionTestCase.fail("async failed", async.getException());
        }
        if (asyncGII.exceptionOccurred()) {
            MultiVMRegionTestCase.fail("asyncGII failed", asyncGII.getException());
        }
        vm0.invoke(new CacheSerializableRunnable("Locally destroy region"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                region.localDestroyRegion();
            }
        });
        vm2.invokeRepeatingIfNecessary(new CacheSerializableRunnable("Verify entryCount"){
            boolean entriesDumped;
            {
                super(name2);
                this.entriesDumped = false;
            }

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                int entryCount = 1034;
                int actualCount = region.entrySet(false).size();
                if (actualCount == 1200) {
                    this.dumpDestroyedEntries(region);
                }
                TestCase.assertEquals((int)entryCount, (int)actualCount);
            }

            private void dumpDestroyedEntries(Region region) throws EntryNotFoundException {
                if (this.entriesDumped) {
                    return;
                }
                this.entriesDumped = true;
                LogWriter logger = DistributedTestCase.getLogWriter();
                logger.info("DUMPING Entries with values in VM that should have been destroyed:");
                for (int i = 5; i < 1000; i += 6) {
                    logger.info(i + "-->" + ((LocalRegion)region).getValueInVM((Object)new Integer(i)));
                }
            }
        }, 5000L);
        vm2.invoke(new CacheSerializableRunnable("Verify keys/values & Nonblocking"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                int entryCount = 1034;
                TestCase.assertEquals((int)entryCount, (int)region.entrySet(false).size());
                int numConcurrent = 0;
                block6: for (int i = 0; i < 1200; ++i) {
                    Long timestamp;
                    Object v;
                    Region.Entry entry = region.getEntry((Object)new Integer(i));
                    Object object = v = entry == null ? null : entry.getValue();
                    if (i < 1000) {
                        switch (i % 6) {
                            case 0: 
                            case 2: 
                            case 4: {
                                TestCase.assertNotNull((Object)entry);
                                TestCase.assertTrue((boolean)Arrays.equals(values[i], (byte[])v));
                                break;
                            }
                            case 1: {
                                TestCase.assertNotNull((Object)v);
                                TestCase.assertTrue((String)("Value for key " + i + " is not a Long, is a " + v.getClass().getName()), (boolean)(v instanceof Long));
                                timestamp = (Long)entry.getValue();
                                if (timestamp >= iiComplete) continue block6;
                                ++numConcurrent;
                                break;
                            }
                            case 3: {
                                TestCase.assertNotNull((Object)entry);
                                TestCase.assertNull((String)("Expected value for " + i + " to be null, but was " + v), (Object)v);
                                break;
                            }
                            case 5: {
                                TestCase.assertNull((Object)entry);
                                break;
                            }
                            default: {
                                TestCase.fail((String)("unexpected modulus result: " + i % 6));
                                break;
                            }
                        }
                        continue;
                    }
                    TestCase.assertNotNull((Object)v);
                    TestCase.assertTrue((String)("Value for key " + i + " is not a Long, is a " + v.getClass().getName()), (boolean)(v instanceof Long));
                    timestamp = (Long)entry.getValue();
                    if (timestamp >= iiComplete) continue;
                    ++numConcurrent;
                }
                DistributedTestCase.getLogWriter().info(name + ": " + numConcurrent + " entries out of " + entryCount + " were updated concurrently with getInitialImage");
                int min = 30;
                TestCase.assertTrue((String)("Not enough updates concurrent with getInitialImage occurred to my liking. " + numConcurrent + " entries out of " + entryCount + " were updated concurrently with getInitialImage, and I'd expect at least " + min + " or so"), (numConcurrent >= min ? 1 : 0) != 0);
            }
        });
    }

    public void testNBRegionInvalidationDuringGetInitialImage() throws Throwable {
        if (!this.supportsReplication()) {
            return;
        }
        if (this.getRegionAttributes().getScope().isDistributedNoAck()) {
            return;
        }
        final String name = this.getUniqueName();
        final byte[][] values = new byte[1000][];
        for (int i = 0; i < 1000; ++i) {
            values[i] = new byte[5120];
            Arrays.fill(values[i], (byte)66);
        }
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm2 = host.getVM(2);
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create Mirrored Region"){

            @Override
            public void run2() throws CacheException {
                CacheTestCase.beginCacheXml();
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.DISTRIBUTED_ACK);
                factory.setDataPolicy(DataPolicy.NORMAL);
                factory.setSubscriptionAttributes(new SubscriptionAttributes(InterestPolicy.ALL));
                MultiVMRegionTestCase.this.createRootRegion(factory.create());
                factory = new AttributesFactory(MultiVMRegionTestCase.this.getRegionAttributes());
                factory.setDataPolicy(DataPolicy.REPLICATE);
                MultiVMRegionTestCase.this.createRegion(name, factory.create());
                MultiVMRegionTestCase.this.finishCacheXml(name);
                InitialImageOperation.slowImageProcessing = 0;
            }
        };
        vm0.invoke(new CacheSerializableRunnable("Create Nonmirrored Region"){

            @Override
            public void run2() throws CacheException {
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.DISTRIBUTED_ACK);
                factory.setDataPolicy(DataPolicy.EMPTY);
                MultiVMRegionTestCase.this.createRootRegion(factory.create());
                factory = new AttributesFactory(MultiVMRegionTestCase.this.getRegionAttributes());
                factory.setDataPolicy(DataPolicy.REPLICATE);
                MultiVMRegionTestCase.this.createRegion(name, factory.create());
                InitialImageOperation.slowImageProcessing = 0;
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Put initial data"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                for (int i = 0; i < 1000; ++i) {
                    region.put((Object)new Integer(i), (Object)values[i]);
                }
                TestCase.assertEquals((int)1000, (int)region.keySet().size());
            }
        });
        AsyncInvocation async = vm0.invokeAsync(new CacheSerializableRunnable("Do Nonblocking Operations"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                final CacheDistributionAdvisor adv = ((DistributedRegion)region).getCacheDistributionAdvisor();
                boolean expectedProfiles = true;
                DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        return adv.adviseReplicates().size() >= 1;
                    }

                    @Override
                    public String description() {
                        return "profile count never reached 1";
                    }
                };
                DistributedTestCase.waitForCriterion(ev, 10000L, 200L, true);
                block5: for (int i = 1; i < 1000; i += 2) {
                    if (i == 301) {
                        MultiVMRegionTestCase.this.pauseIfNecessary(300);
                        region.invalidateRegion();
                        MultiVMRegionTestCase.this.pauseIfNecessary(500);
                    }
                    Integer key = new Integer(i);
                    switch (i % 6) {
                        case 1: {
                            Object value = new Long(System.currentTimeMillis());
                            region.put((Object)key, value);
                            continue block5;
                        }
                        case 3: {
                            region.invalidate((Object)key);
                            if (!MultiVMRegionTestCase.this.getRegionAttributes().getScope().isDistributedAck()) continue block5;
                            Object value = region.get((Object)key);
                            TestCase.assertNull((String)("Expected null value for key: " + i + " but got " + value), (Object)value);
                            continue block5;
                        }
                        case 5: {
                            region.destroy((Object)key);
                            if (!MultiVMRegionTestCase.this.getRegionAttributes().getScope().isDistributedAck()) continue block5;
                            TestCase.assertNull((Object)region.get((Object)key));
                            continue block5;
                        }
                        default: {
                            TestCase.fail((String)("unexpected modulus result: " + i));
                        }
                    }
                }
                MultiVMRegionTestCase.this.getRootRegion().put((Object)"DONE", (Object)"FLUSH_OPS");
            }
        });
        if (!this.getRegionAttributes().getScope().isGlobal()) {
            vm2.invoke(new SerializableRunnable("Set slow image processing"){

                @Override
                public void run() {
                    int pause;
                    InitialImageOperation.slowImageProcessing = pause = 100;
                }
            });
        }
        AsyncInvocation asyncGII = vm2.invokeAsync(create);
        if (!this.getRegionAttributes().getScope().isGlobal()) {
            DistributedTestCase.join(async, 30000L, MultiVMRegionTestCase.getLogWriter());
            vm2.invoke(new SerializableRunnable("Set fast image processing"){

                @Override
                public void run() {
                    InitialImageOperation.slowImageProcessing = 0;
                }
            });
            MultiVMRegionTestCase.getLogWriter().info("after async nonblocking ops complete");
        }
        DistributedTestCase.join(asyncGII, 30000L, MultiVMRegionTestCase.getLogWriter());
        final long iiComplete = System.currentTimeMillis();
        MultiVMRegionTestCase.getLogWriter().info("Complete GetInitialImage at: " + System.currentTimeMillis());
        if (this.getRegionAttributes().getScope().isGlobal()) {
            DistributedTestCase.join(async, 30000L, MultiVMRegionTestCase.getLogWriter());
        }
        if (async.exceptionOccurred()) {
            MultiVMRegionTestCase.fail("async failed", async.getException());
        }
        if (asyncGII.exceptionOccurred()) {
            MultiVMRegionTestCase.fail("asyncGII failed", asyncGII.getException());
        }
        vm0.invoke(new CacheSerializableRunnable("Locally destroy region"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                region.localDestroyRegion();
            }
        });
        vm2.invokeRepeatingIfNecessary(new CacheSerializableRunnable("Verify entryCount"){
            private boolean entriesDumped;
            {
                super(name2);
                this.entriesDumped = false;
            }

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                int entryCount = 834;
                int actualCount = region.entrySet(false).size();
                if (actualCount == 1000) {
                    this.dumpDestroyedEntries(region);
                }
                TestCase.assertEquals((int)entryCount, (int)actualCount);
            }

            private void dumpDestroyedEntries(Region region) throws EntryNotFoundException {
                if (this.entriesDumped) {
                    return;
                }
                this.entriesDumped = true;
                LogWriter logger = DistributedTestCase.getLogWriter();
                logger.info("DUMPING Entries with values in VM that should have been destroyed:");
                for (int i = 5; i < 1000; i += 6) {
                    logger.info(i + "-->" + ((LocalRegion)region).getValueInVM((Object)new Integer(i)));
                }
            }
        }, 3000L);
        vm2.invoke(new CacheSerializableRunnable("Verify keys/values & Nonblocking"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                int entryCount = 834;
                TestCase.assertEquals((int)entryCount, (int)region.entrySet(false).size());
                int numConcurrent = 0;
                block6: for (int i = 0; i < 1000; ++i) {
                    Object v;
                    Region.Entry entry = region.getEntry((Object)new Integer(i));
                    if (i < 301) {
                        if (i % 6 == 5) {
                            TestCase.assertNull((String)("Expected entry for " + i + " to be destroyed but it is " + entry), (Object)entry);
                            continue;
                        }
                        TestCase.assertNotNull((Object)entry);
                        v = entry.getValue();
                        TestCase.assertNull((String)("Expected value for " + i + " to be null, but was " + v), (Object)v);
                        continue;
                    }
                    v = entry == null ? null : entry.getValue();
                    switch (i % 6) {
                        case 0: 
                        case 2: 
                        case 4: {
                            TestCase.assertNotNull((Object)entry);
                            TestCase.assertNull((String)("Expected value for " + i + " to be null, but was " + v), (Object)v);
                            continue block6;
                        }
                        case 1: {
                            TestCase.assertNotNull((Object)v);
                            TestCase.assertTrue((String)("Value for key " + i + " is not a Long, is a " + v.getClass().getName()), (boolean)(v instanceof Long));
                            Long timestamp = (Long)entry.getValue();
                            if (timestamp >= iiComplete) continue block6;
                            ++numConcurrent;
                            continue block6;
                        }
                        case 3: {
                            TestCase.assertNotNull((Object)entry);
                            TestCase.assertNull((String)("Expected value for " + i + " to be null, but was " + v), (Object)v);
                            continue block6;
                        }
                        case 5: {
                            TestCase.assertNull((Object)entry);
                            continue block6;
                        }
                        default: {
                            TestCase.fail((String)("unexpected modulus result: " + i % 6));
                        }
                    }
                }
                DistributedTestCase.getLogWriter().info(name + ": " + numConcurrent + " entries out of " + entryCount + " were updated concurrently with getInitialImage");
                if (MultiVMRegionTestCase.this.getRegionAttributes().getScope().isGlobal()) {
                    TestCase.assertTrue((String)("Too many concurrent updates when expected to block: " + numConcurrent), (numConcurrent < 300 ? 1 : 0) != 0);
                } else {
                    TestCase.assertTrue((String)("Not enough updates concurrent with getInitialImage occurred to my liking. " + numConcurrent + " entries out of " + entryCount + " were updated concurrently with getInitialImage, and I'd expect at least 50 or so"), (numConcurrent >= 30 ? 1 : 0) != 0);
                }
            }
        });
    }

    public void testNBRegionDestructionDuringGetInitialImage() throws Throwable {
        if (!this.supportsReplication()) {
            return;
        }
        final String name = this.getUniqueName();
        final byte[][] values = new byte[1000][];
        for (int i = 0; i < 1000; ++i) {
            values[i] = new byte[5120];
            Arrays.fill(values[i], (byte)66);
        }
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm2 = host.getVM(2);
        vm0.invoke(new CacheSerializableRunnable("Create Nonmirrored Region"){

            @Override
            public void run2() throws CacheException {
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.DISTRIBUTED_ACK);
                factory.setDataPolicy(DataPolicy.EMPTY);
                MultiVMRegionTestCase.this.createRootRegion(factory.create());
                factory = new AttributesFactory(MultiVMRegionTestCase.this.getRegionAttributes());
                MultiVMRegionTestCase.this.createRegion(name, factory.create());
                InitialImageOperation.slowImageProcessing = 0;
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Put initial data"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                for (int i = 0; i < 1000; ++i) {
                    region.put((Object)new Integer(i), (Object)values[i]);
                }
                TestCase.assertEquals((int)1000, (int)region.keySet().size());
            }
        });
        AsyncInvocation async = vm0.invokeAsync(new CacheSerializableRunnable("Do Nonblocking Operations"){

            @Override
            public void run2() throws CacheException {
                DistributedTestCase.pause(200);
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                final CacheDistributionAdvisor adv = ((DistributedRegion)region).getCacheDistributionAdvisor();
                boolean expectedProfiles = true;
                DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

                    @Override
                    public boolean done() {
                        return 1 == adv.adviseReplicates().size();
                    }

                    @Override
                    public String description() {
                        return "profile count never became exactly 1";
                    }
                };
                DistributedTestCase.waitForCriterion(ev, 10000L, 200L, true);
                block5: for (int i = 1; i < 301; i += 2) {
                    Integer key = new Integer(i);
                    switch (i % 6) {
                        case 1: {
                            Object value = new Long(System.currentTimeMillis());
                            region.put((Object)key, value);
                            continue block5;
                        }
                        case 3: {
                            region.invalidate((Object)key);
                            if (!region.getAttributes().getScope().isDistributedAck()) continue block5;
                            Object value = region.get((Object)key);
                            TestCase.assertNull((String)("Expected null value for key: " + i + " but got " + value), (Object)value);
                            continue block5;
                        }
                        case 5: {
                            region.destroy((Object)key);
                            if (!region.getAttributes().getScope().isDistributedAck()) continue block5;
                            TestCase.assertNull((Object)region.get((Object)key));
                            continue block5;
                        }
                        default: {
                            TestCase.fail((String)("unexpected modulus result: " + i));
                        }
                    }
                }
                region.destroyRegion();
                Region rr = MultiVMRegionTestCase.this.getRootRegion();
                if (rr != null) {
                    rr.put((Object)"DONE", (Object)"FLUSH_OPS");
                }
            }
        });
        AsyncInvocation asyncGII = vm2.invokeAsync(new CacheSerializableRunnable("Create Mirrored Region"){

            @Override
            public void run2() throws CacheException {
                if (!MultiVMRegionTestCase.this.getRegionAttributes().getScope().isGlobal()) {
                    int pause;
                    InitialImageOperation.slowImageProcessing = pause = 200;
                }
                CacheTestCase.beginCacheXml();
                AttributesFactory factory = new AttributesFactory();
                factory.setScope(Scope.DISTRIBUTED_ACK);
                factory.setDataPolicy(DataPolicy.NORMAL);
                factory.setSubscriptionAttributes(new SubscriptionAttributes(InterestPolicy.ALL));
                MultiVMRegionTestCase.this.createRootRegion(factory.create());
                RegionAttributes ra = MultiVMRegionTestCase.this.getRegionAttributes();
                AttributesFactory factory2 = new AttributesFactory(ra);
                if (ra.getDataPolicy().withPersistence()) {
                    factory2.setDataPolicy(DataPolicy.PERSISTENT_REPLICATE);
                } else {
                    factory2.setDataPolicy(DataPolicy.REPLICATE);
                }
                MultiVMRegionTestCase.this.createRegion(name, factory2.create());
                MultiVMRegionTestCase.this.finishCacheXml(name);
                InitialImageOperation.slowImageProcessing = 0;
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException ie) {
                    TestCase.fail((String)"interrupted");
                }
                TestCase.assertTrue((MultiVMRegionTestCase.this.getRootRegion().getSubregion(name) == null || MultiVMRegionTestCase.this.getRegionAttributes().getScope().isGlobal() ? 1 : 0) != 0);
            }
        });
        if (this.getRegionAttributes().getScope().isGlobal()) {
            DistributedTestCase.join(async, 30000L, MultiVMRegionTestCase.getLogWriter());
            if (async.exceptionOccurred()) {
                MultiVMRegionTestCase.fail("async invocation failed", async.getException());
            }
            vm2.invoke(new SerializableRunnable("Set fast image processing"){

                @Override
                public void run() {
                    InitialImageOperation.slowImageProcessing = 0;
                }
            });
            MultiVMRegionTestCase.getLogWriter().info("after async nonblocking ops complete");
        }
        DistributedTestCase.join(asyncGII, 30000L, MultiVMRegionTestCase.getLogWriter());
        MultiVMRegionTestCase.getLogWriter().info("Complete GetInitialImage at: " + System.currentTimeMillis());
        if (this.getRegionAttributes().getScope().isGlobal()) {
            DistributedTestCase.join(async, 30000L, MultiVMRegionTestCase.getLogWriter());
        }
        if (async.exceptionOccurred()) {
            MultiVMRegionTestCase.fail("async failed", async.getException());
        }
        if (asyncGII.exceptionOccurred()) {
            MultiVMRegionTestCase.fail("asyncGII failed", asyncGII.getException());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNoDataSerializer() {
        MultiVMRegionTestCase.assertTrue((boolean)this.getRegionAttributes().getScope().isDistributed());
        final String name = this.getUniqueName();
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create Region"){

            @Override
            public void run2() throws CacheException {
                MultiVMRegionTestCase.this.createRegion(name);
            }
        };
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        MultiVMRegionTestCase.getLogWriter().info(name + ": before creates");
        vm0.invoke(create);
        vm1.invoke(create);
        MultiVMRegionTestCase.getLogWriter().info(name + ": after creates");
        final String key = "KEY";
        final String key2 = "KEY2";
        int intValue = 3452;
        long longValue = 213421L;
        vm2.invoke(new SerializableRunnable("Disconnect from DS"){

            @Override
            public void run() {
                CacheTestCase.disconnectFromDS();
            }
        });
        MultiVMRegionTestCase.getLogWriter().info(name + ": after vm2 disconnect");
        try {
            vm0.invoke(new CacheSerializableRunnable("Put int"){

                @Override
                public void run2() throws CacheException {
                    Class<IntWrapper.IntWrapperSerializer> c = IntWrapper.IntWrapperSerializer.class;
                    IntWrapper.IntWrapperSerializer serializer = (IntWrapper.IntWrapperSerializer)DataSerializer.register(c);
                    Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                    region.put(key, (Object)new IntWrapper(3452));
                    MultiVMRegionTestCase.this.pauseIfNecessary();
                    TestCase.assertTrue((boolean)serializer.wasInvoked);
                }
            });
            MultiVMRegionTestCase.getLogWriter().info(name + ": after vm0 put");
            CacheSerializableRunnable get = new CacheSerializableRunnable("Get int"){

                @Override
                public void run2() throws CacheException {
                    Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                    if (region.getAttributes().getScope().isDistributedNoAck()) {
                        long end = System.currentTimeMillis() + 30000L;
                        while (InternalDataSerializer.getSerializer((int)120) == null) {
                            TestCase.assertTrue((String)"This test sometimes fails due to timing issues", (System.currentTimeMillis() <= end ? 1 : 0) != 0);
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException e) {
                                throw new CacheException("Test interrupted"){};
                            }
                        }
                    }
                    IntWrapper value = (IntWrapper)region.get(key);
                    TestCase.assertNotNull((Object)InternalDataSerializer.getSerializer((int)120));
                    TestCase.assertNotNull((Object)value);
                    TestCase.assertEquals((int)3452, (int)value.intValue);
                }
            };
            vm1.invoke(get);
            MultiVMRegionTestCase.getLogWriter().info(name + ": after vm1 get");
            vm2.invoke(new SerializableRunnable("Connect to DS"){

                @Override
                public void run() {
                    Class<LongWrapper.LongWrapperSerializer> c = LongWrapper.LongWrapperSerializer.class;
                    DataSerializer.register(c);
                    MultiVMRegionTestCase.this.getSystem();
                }
            });
            vm2.invoke(create);
            MultiVMRegionTestCase.getLogWriter().info(name + ": after vm2 create");
            vm2.invoke(new CacheSerializableRunnable("Put long"){

                @Override
                public void run2() throws CacheException {
                    Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                    region.put(key2, (Object)new LongWrapper(213421L));
                    MultiVMRegionTestCase.this.pauseIfNecessary();
                    LongWrapper.LongWrapperSerializer serializer = (LongWrapper.LongWrapperSerializer)InternalDataSerializer.getSerializer((int)121);
                    TestCase.assertTrue((boolean)serializer.wasInvoked);
                }
            });
            MultiVMRegionTestCase.getLogWriter().info(name + ": after vm2 put");
            vm2.invoke(get);
            MultiVMRegionTestCase.getLogWriter().info(name + ": after vm2 get");
            CacheSerializableRunnable get2 = new CacheSerializableRunnable("Get long"){

                @Override
                public void run2() throws CacheException {
                    Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                    LongWrapper value = (LongWrapper)region.get(key2);
                    TestCase.assertNotNull((Object)InternalDataSerializer.getSerializer((int)121));
                    TestCase.assertNotNull((Object)value);
                    TestCase.assertEquals((long)213421L, (long)value.longValue);
                }
            };
            vm0.invoke(get2);
            MultiVMRegionTestCase.getLogWriter().info(name + ": after vm0 get2");
            vm1.invoke(get2);
            MultiVMRegionTestCase.getLogWriter().info(name + ": after vm1 get2");
        }
        finally {
            MultiVMRegionTestCase.pause(1500);
            MultiVMRegionTestCase.unregisterAllSerializers();
            MultiVMRegionTestCase.getLogWriter().info(name + ": after unregister");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNoInstantiator() {
        MultiVMRegionTestCase.assertTrue((boolean)this.getRegionAttributes().getScope().isDistributed());
        final String name = this.getUniqueName();
        CacheSerializableRunnable create = new CacheSerializableRunnable("Create Region"){

            @Override
            public void run2() throws CacheException {
                MultiVMRegionTestCase.this.createRegion(name);
            }
        };
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        vm0.invoke(create);
        vm1.invoke(create);
        final String key = "KEY";
        final String key2 = "KEY2";
        int intValue = 7201;
        long longValue = 123612L;
        vm2.invoke(new SerializableRunnable("Disconnect from DS"){

            @Override
            public void run() {
                CacheTestCase.disconnectFromDS();
            }
        });
        vm0.invoke(new CacheSerializableRunnable("Put int"){

            @Override
            public void run2() throws CacheException {
                Instantiator.register((Instantiator)new DSIntWrapper.DSIntWrapperInstantiator());
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                region.put(key, (Object)new DSIntWrapper(7201));
                MultiVMRegionTestCase.this.pauseIfNecessary();
            }
        });
        CacheSerializableRunnable get = new CacheSerializableRunnable("Get int"){

            @Override
            public void run2() throws CacheException {
                Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                DSIntWrapper.DSIntWrapperInstantiator inst = new DSIntWrapper.DSIntWrapperInstantiator();
                TestCase.assertNotNull((Object)InternalInstantiator.getInstantiator((int)inst.getId()));
                DSIntWrapper value = (DSIntWrapper)region.get(key);
                TestCase.assertNotNull((Object)value);
                TestCase.assertEquals((int)7201, (int)value.intValue);
            }
        };
        try {
            vm1.invoke(get);
            vm2.invoke(new SerializableRunnable("Connect to DS"){

                @Override
                public void run() {
                    Instantiator.register((Instantiator)new DSLongWrapper.DSLongWrapperInstantiator());
                    MultiVMRegionTestCase.this.getSystem();
                }
            });
            vm2.invoke(create);
            vm2.invoke(new CacheSerializableRunnable("Put long"){

                @Override
                public void run2() throws CacheException {
                    Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                    region.put(key2, (Object)new DSLongWrapper(123612L));
                    MultiVMRegionTestCase.this.pauseIfNecessary();
                }
            });
            vm2.invoke(get);
            CacheSerializableRunnable get2 = new CacheSerializableRunnable("Get long"){

                @Override
                public void run2() throws CacheException {
                    Region region = MultiVMRegionTestCase.this.getRootRegion().getSubregion(name);
                    DSLongWrapper.DSLongWrapperInstantiator inst = new DSLongWrapper.DSLongWrapperInstantiator();
                    TestCase.assertNotNull((Object)InternalInstantiator.getInstantiator((int)inst.getId()));
                    LongWrapper value = (LongWrapper)region.get(key2);
                    TestCase.assertNotNull((Object)value);
                    TestCase.assertEquals((long)123612L, (long)value.longValue);
                    inst = (DSLongWrapper.DSLongWrapperInstantiator)InternalInstantiator.getInstantiator((int)inst.getId());
                    TestCase.assertNotNull((Object)((Object)inst));
                    TestCase.assertTrue((boolean)inst.wasInvoked);
                }
            };
            vm0.invoke(get2);
            vm1.invoke(get2);
        }
        finally {
            MultiVMRegionTestCase.pause(1500);
            MultiVMRegionTestCase.unregisterAllSerializers();
        }
    }

    private static void unregisterAllSerializers() {
        MultiVMRegionTestCase.unregisterAllDataSerializersFromAllVms();
        MultiVMRegionTestCase.cleanupAllVms();
    }

    public static void assertCacheCallbackEvents(String regionName, TransactionId txId, Object key, Object oldValue, Object newValue) {
        Cache johnnyCash = CacheFactory.getAnyInstance();
        Region re = johnnyCash.getRegion("root").getSubregion(regionName);
        MyTransactionListener tl = (MyTransactionListener)johnnyCash.getCacheTransactionManager().getListeners()[0];
        tl.expectedTxId = txId;
        MultiVMRegionTestCase.assertNotNull((String)("Cannot assert TX Callout Events with a null Region: " + regionName), (Object)re);
        final CountingDistCacheListener cdcl = (CountingDistCacheListener)re.getAttributes().getCacheListeners()[0];
        if (re.getAttributes().getDataPolicy().withPartitioning()) {
            return;
        }
        DistributedTestCase.WaitCriterion ev = new DistributedTestCase.WaitCriterion(){

            @Override
            public boolean done() {
                return cdcl.getEntryEvent() != null;
            }

            @Override
            public String description() {
                return "waiting for entry event";
            }
        };
        DistributedTestCase.waitForCriterion(ev, 2000L, 200L, true);
        EntryEvent listenEvent = cdcl.getEntryEvent();
        MultiVMRegionTestCase.assertNotNull((String)"Cannot assert TX CacheListener Events with a null Entry Event", (Object)listenEvent);
        MultiVMRegionTestCase.assertEquals((Object)re, (Object)listenEvent.getRegion());
        MultiVMRegionTestCase.assertEquals((Object)txId, (Object)listenEvent.getTransactionId());
        MultiVMRegionTestCase.assertEquals((Object)key, (Object)listenEvent.getKey());
        MultiVMRegionTestCase.assertEquals((Object)oldValue, (Object)listenEvent.getOldValue());
        MultiVMRegionTestCase.assertEquals((Object)newValue, (Object)listenEvent.getNewValue());
        MultiVMRegionTestCase.assertEquals(null, (Object)listenEvent.getCallbackArgument());
        MultiVMRegionTestCase.assertEquals((boolean)true, (boolean)listenEvent.isCallbackArgumentAvailable());
        MultiVMRegionTestCase.assertTrue((!listenEvent.getOperation().isLoad() ? 1 : 0) != 0);
        MultiVMRegionTestCase.assertTrue((!listenEvent.getOperation().isNetLoad() ? 1 : 0) != 0);
        MultiVMRegionTestCase.assertTrue((!listenEvent.getOperation().isNetSearch() ? 1 : 0) != 0);
        MultiVMRegionTestCase.assertTrue((!listenEvent.getOperation().isLocalLoad() ? 1 : 0) != 0);
        MultiVMRegionTestCase.assertTrue((boolean)listenEvent.getOperation().isDistributed());
        MultiVMRegionTestCase.assertTrue((!listenEvent.getOperation().isExpiration() ? 1 : 0) != 0);
        MultiVMRegionTestCase.assertTrue((boolean)listenEvent.isOriginRemote());
        cdcl.setEntryEvent(null);
    }

    public void testTXSimpleOps() throws Exception {
        if (!this.supportsTransactions()) {
            return;
        }
        TXManagerImpl txMgr = (TXManagerImpl)this.getCache().getCacheTransactionManager();
        RegionAttributes rattrs = this.getRegionAttributes();
        final DataPolicy dp = rattrs.getDataPolicy();
        if (rattrs.getScope().isGlobal() || dp.withPersistence()) {
            Region rgn = this.createRegion(this.getUniqueName());
            txMgr.begin();
            try {
                rgn.put((Object)"testTXSimpleOpsKey1", (Object)"val");
                MultiVMRegionTestCase.fail((String)"expected UnsupportedOperationException");
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            txMgr.rollback();
            rgn.localDestroyRegion();
            return;
        }
        final String rgnName = this.getUniqueName();
        SerializableRunnable create = new SerializableRunnable("testTXSimpleOps: Create Region"){

            @Override
            public void run() {
                CacheTransactionManager txMgr2 = MultiVMRegionTestCase.this.getCache().getCacheTransactionManager();
                MyTransactionListener tl = new MyTransactionListener();
                txMgr2.addListener((TransactionListener)tl);
                TestCase.assertEquals(null, (Object)tl.lastEvent);
                TestCase.assertEquals((int)0, (int)tl.afterCommitCount);
                TestCase.assertEquals((int)0, (int)tl.afterFailedCommitCount);
                TestCase.assertEquals((int)0, (int)tl.afterRollbackCount);
                TestCase.assertEquals((int)0, (int)tl.closeCount);
                try {
                    Region rgn = MultiVMRegionTestCase.this.createRegion(rgnName);
                    CountingDistCacheListener cacheListener = new CountingDistCacheListener();
                    rgn.getAttributesMutator().addCacheListener((CacheListener)cacheListener);
                    cacheListener.assertCount(0, 0, 0, 0);
                    MultiVMRegionTestCase.this.getSystem().getLogWriter().info("testTXSimpleOps: Created region");
                }
                catch (CacheException e) {
                    DistributedTestCase.fail("While creating region", e);
                }
            }
        };
        SerializableRunnable newKey = new SerializableRunnable("testTXSimpleOps: Create Region & Create Key"){

            @Override
            public void run() {
                try {
                    Region root = MultiVMRegionTestCase.this.getRootRegion();
                    Region rgn = root.getSubregion(rgnName);
                    rgn.create((Object)"key", null);
                    CountingDistCacheListener cacheListener = (CountingDistCacheListener)rgn.getAttributes().getCacheListener();
                    cacheListener.assertCount(0, 0, 0, 0);
                    MultiVMRegionTestCase.this.getSystem().getLogWriter().info("testTXSimpleOps: Created Key");
                }
                catch (CacheException e) {
                    DistributedTestCase.fail("While creating region", e);
                }
            }
        };
        Host host = Host.getHost(0);
        VM vm = host.getVM(0);
        vm.invoke(create);
        vm.invoke(newKey);
        int vmCount = host.getVMCount();
        for (int i = 1; i < vmCount; ++i) {
            vm = host.getVM(i);
            vm.invoke(create);
            if (this.getRegionAttributes().getDataPolicy().withReplication() || this.getRegionAttributes().getDataPolicy() == DataPolicy.PRELOADED || this.getRegionAttributes().getDataPolicy().withPartitioning()) continue;
            vm.invoke(newKey);
        }
        try {
            Region rgn = this.createRegion(rgnName);
            DMStats dmStats = this.getSystem().getDistributionManager().getStats();
            long cmtMsgs = dmStats.getSentCommitMessages();
            long commitWaits = dmStats.getCommitWaits();
            txMgr.begin();
            rgn.put((Object)"key", (Object)"value");
            TXId txId = txMgr.getTransactionId();
            txMgr.commit();
            MultiVMRegionTestCase.assertEquals((long)(cmtMsgs + 1L), (long)dmStats.getSentCommitMessages());
            TXManagerImpl.waitForPendingCommitForTest();
            MultiVMRegionTestCase.assertEquals((long)(commitWaits + 1L), (long)dmStats.getCommitWaits());
            this.getSystem().getLogWriter().info("testTXSimpleOps: Create/Put Value");
            MultiVMRegionTestCase.invokeInEveryVM(MultiVMRegionTestCase.class, "assertCacheCallbackEvents", new Object[]{rgnName, txId, "key", null, "value"});
            this.invokeInEveryVMRepeatingIfNecessary(new CacheSerializableRunnable("testTXSimpleOps: Verify Received Value"){

                @Override
                public void run2() {
                    Region rgn1 = MultiVMRegionTestCase.this.getRootRegion().getSubregion(rgnName);
                    TestCase.assertNotNull((String)"Could not find entry for 'key'", (Object)rgn1.getEntry((Object)"key"));
                    TestCase.assertEquals((Object)"value", (Object)rgn1.getEntry((Object)"key").getValue());
                    CacheTransactionManager txMgr2 = MultiVMRegionTestCase.this.getCache().getCacheTransactionManager();
                    MyTransactionListener tl = (MyTransactionListener)txMgr2.getListeners()[0];
                    if (dp.withPartitioning()) {
                        return;
                    }
                    tl.checkAfterCommitCount(1);
                    TestCase.assertEquals((int)0, (int)tl.afterFailedCommitCount);
                    TestCase.assertEquals((int)0, (int)tl.afterRollbackCount);
                    TestCase.assertEquals((int)0, (int)tl.closeCount);
                    TestCase.assertEquals((Object)rgn1.getCache(), (Object)tl.lastEvent.getCache());
                    RegionAttributes attr = MultiVMRegionTestCase.this.getRegionAttributes();
                    List events = !attr.getDataPolicy().withReplication() || attr.getConcurrencyChecksEnabled() ? tl.lastEvent.getPutEvents() : tl.lastEvent.getCreateEvents();
                    TestCase.assertEquals((int)1, (int)events.size());
                    EntryEvent ev = (EntryEvent)events.iterator().next();
                    TestCase.assertEquals((Object)tl.expectedTxId, (Object)ev.getTransactionId());
                    TestCase.assertTrue((ev.getRegion() == rgn1 ? 1 : 0) != 0);
                    TestCase.assertEquals((Object)"key", (Object)ev.getKey());
                    TestCase.assertEquals((Object)"value", (Object)ev.getNewValue());
                    TestCase.assertEquals(null, (Object)ev.getOldValue());
                    TestCase.assertTrue((!ev.getOperation().isLocalLoad() ? 1 : 0) != 0);
                    TestCase.assertTrue((!ev.getOperation().isNetLoad() ? 1 : 0) != 0);
                    TestCase.assertTrue((!ev.getOperation().isLoad() ? 1 : 0) != 0);
                    TestCase.assertTrue((!ev.getOperation().isNetSearch() ? 1 : 0) != 0);
                    TestCase.assertTrue((!ev.getOperation().isExpiration() ? 1 : 0) != 0);
                    TestCase.assertEquals(null, (Object)ev.getCallbackArgument());
                    TestCase.assertEquals((boolean)true, (boolean)ev.isCallbackArgumentAvailable());
                    TestCase.assertTrue((boolean)ev.isOriginRemote());
                    TestCase.assertTrue((boolean)ev.getOperation().isDistributed());
                    CountingDistCacheListener cdcL = (CountingDistCacheListener)rgn1.getAttributes().getCacheListeners()[0];
                    cdcL.assertCount(0, 1, 0, 0);
                }
            });
            txMgr.begin();
            rgn.put((Object)"key", (Object)"value2");
            txId = txMgr.getTransactionId();
            txMgr.commit();
            TXManagerImpl.waitForPendingCommitForTest();
            this.getSystem().getLogWriter().info("testTXSimpleOps: Put(update) Value2");
            MultiVMRegionTestCase.invokeInEveryVM(MultiVMRegionTestCase.class, "assertCacheCallbackEvents", new Object[]{rgnName, txId, "key", "value", "value2"});
            this.invokeInEveryVMRepeatingIfNecessary(new CacheSerializableRunnable("testTXSimpleOps: Verify Received Value"){

                @Override
                public void run2() {
                    Region rgn1 = MultiVMRegionTestCase.this.getRootRegion().getSubregion(rgnName);
                    TestCase.assertNotNull((String)"Could not find entry for 'key'", (Object)rgn1.getEntry((Object)"key"));
                    TestCase.assertEquals((Object)"value2", (Object)rgn1.getEntry((Object)"key").getValue());
                    CacheTransactionManager txMgr2 = MultiVMRegionTestCase.this.getCache().getCacheTransactionManager();
                    MyTransactionListener tl = (MyTransactionListener)txMgr2.getListeners()[0];
                    if (dp.withPartitioning()) {
                        return;
                    }
                    tl.checkAfterCommitCount(2);
                    TestCase.assertEquals((Object)rgn1.getCache(), (Object)tl.lastEvent.getCache());
                    List events = tl.lastEvent.getEvents();
                    TestCase.assertEquals((int)1, (int)events.size());
                    EntryEvent ev = (EntryEvent)events.iterator().next();
                    TestCase.assertEquals((Object)tl.expectedTxId, (Object)ev.getTransactionId());
                    TestCase.assertTrue((ev.getRegion() == rgn1 ? 1 : 0) != 0);
                    TestCase.assertEquals((Object)"key", (Object)ev.getKey());
                    TestCase.assertEquals((Object)"value2", (Object)ev.getNewValue());
                    TestCase.assertEquals((Object)"value", (Object)ev.getOldValue());
                    TestCase.assertTrue((!ev.getOperation().isLocalLoad() ? 1 : 0) != 0);
                    TestCase.assertTrue((!ev.getOperation().isNetLoad() ? 1 : 0) != 0);
                    TestCase.assertTrue((!ev.getOperation().isLoad() ? 1 : 0) != 0);
                    TestCase.assertTrue((!ev.getOperation().isNetSearch() ? 1 : 0) != 0);
                    TestCase.assertTrue((!ev.getOperation().isExpiration() ? 1 : 0) != 0);
                    TestCase.assertEquals(null, (Object)ev.getCallbackArgument());
                    TestCase.assertEquals((boolean)true, (boolean)ev.isCallbackArgumentAvailable());
                    TestCase.assertTrue((boolean)ev.isOriginRemote());
                    TestCase.assertTrue((boolean)ev.getOperation().isDistributed());
                    CountingDistCacheListener cdcL = (CountingDistCacheListener)rgn1.getAttributes().getCacheListeners()[0];
                    cdcL.assertCount(0, 2, 0, 0);
                }
            });
            txMgr.begin();
            rgn.invalidate((Object)"key");
            txId = txMgr.getTransactionId();
            txMgr.commit();
            TXManagerImpl.waitForPendingCommitForTest();
            this.getSystem().getLogWriter().info("testTXSimpleOps: invalidate key");
            MultiVMRegionTestCase.invokeInEveryVM(MultiVMRegionTestCase.class, "assertCacheCallbackEvents", new Object[]{rgnName, txId, "key", "value2", null});
            this.invokeInEveryVMRepeatingIfNecessary(new CacheSerializableRunnable("testTXSimpleOps: Verify Received Value"){

                @Override
                public void run2() {
                    Region rgn1 = MultiVMRegionTestCase.this.getRootRegion().getSubregion(rgnName);
                    TestCase.assertNotNull((String)"Could not find entry for 'key'", (Object)rgn1.getEntry((Object)"key"));
                    TestCase.assertTrue((boolean)rgn1.containsKey((Object)"key"));
                    TestCase.assertTrue((!rgn1.containsValueForKey((Object)"key") ? 1 : 0) != 0);
                    CacheTransactionManager txMgr2 = MultiVMRegionTestCase.this.getCache().getCacheTransactionManager();
                    MyTransactionListener tl = (MyTransactionListener)txMgr2.getListeners()[0];
                    if (dp.withPartitioning()) {
                        return;
                    }
                    tl.checkAfterCommitCount(3);
                    TestCase.assertEquals((Object)rgn1.getCache(), (Object)tl.lastEvent.getCache());
                    List events = tl.lastEvent.getInvalidateEvents();
                    TestCase.assertEquals((int)1, (int)events.size());
                    EntryEvent ev = (EntryEvent)events.iterator().next();
                    TestCase.assertEquals((Object)tl.expectedTxId, (Object)ev.getTransactionId());
                    TestCase.assertTrue((ev.getRegion() == rgn1 ? 1 : 0) != 0);
                    TestCase.assertEquals((Object)"key", (Object)ev.getKey());
                    TestCase.assertEquals(null, (Object)ev.getNewValue());
                    TestCase.assertEquals((Object)"value2", (Object)ev.getOldValue());
                    TestCase.assertTrue((!ev.getOperation().isLocalLoad() ? 1 : 0) != 0);
                    TestCase.assertTrue((!ev.getOperation().isNetLoad() ? 1 : 0) != 0);
                    TestCase.assertTrue((!ev.getOperation().isLoad() ? 1 : 0) != 0);
                    TestCase.assertTrue((!ev.getOperation().isNetSearch() ? 1 : 0) != 0);
                    TestCase.assertTrue((!ev.getOperation().isExpiration() ? 1 : 0) != 0);
                    TestCase.assertEquals(null, (Object)ev.getCallbackArgument());
                    TestCase.assertEquals((boolean)true, (boolean)ev.isCallbackArgumentAvailable());
                    TestCase.assertTrue((boolean)ev.isOriginRemote());
                    TestCase.assertTrue((boolean)ev.getOperation().isDistributed());
                    CountingDistCacheListener cdcL = (CountingDistCacheListener)rgn1.getAttributes().getCacheListeners()[0];
                    cdcL.assertCount(0, 2, 1, 0);
                }
            });
            txMgr.begin();
            rgn.destroy((Object)"key");
            txId = txMgr.getTransactionId();
            txMgr.commit();
            TXManagerImpl.waitForPendingCommitForTest();
            this.getSystem().getLogWriter().info("testTXSimpleOps: destroy key");
            MultiVMRegionTestCase.invokeInEveryVM(MultiVMRegionTestCase.class, "assertCacheCallbackEvents", new Object[]{rgnName, txId, "key", null, null});
            this.invokeInEveryVMRepeatingIfNecessary(new CacheSerializableRunnable("testTXSimpleOps: Verify Received Value"){

                @Override
                public void run2() {
                    Region rgn1 = MultiVMRegionTestCase.this.getRootRegion().getSubregion(rgnName);
                    TestCase.assertTrue((!rgn1.containsKey((Object)"key") ? 1 : 0) != 0);
                    CacheTransactionManager txMgr2 = MultiVMRegionTestCase.this.getCache().getCacheTransactionManager();
                    MyTransactionListener tl = (MyTransactionListener)txMgr2.getListeners()[0];
                    if (dp.withPartitioning()) {
                        return;
                    }
                    tl.checkAfterCommitCount(4);
                    TestCase.assertEquals((Object)rgn1.getCache(), (Object)tl.lastEvent.getCache());
                    List events = tl.lastEvent.getDestroyEvents();
                    TestCase.assertEquals((int)1, (int)events.size());
                    EntryEvent ev = (EntryEvent)events.iterator().next();
                    TestCase.assertEquals((Object)tl.expectedTxId, (Object)ev.getTransactionId());
                    TestCase.assertTrue((ev.getRegion() == rgn1 ? 1 : 0) != 0);
                    TestCase.assertEquals((Object)"key", (Object)ev.getKey());
                    TestCase.assertEquals(null, (Object)ev.getNewValue());
                    TestCase.assertEquals(null, (Object)ev.getOldValue());
                    TestCase.assertTrue((!ev.getOperation().isLocalLoad() ? 1 : 0) != 0);
                    TestCase.assertTrue((!ev.getOperation().isNetLoad() ? 1 : 0) != 0);
                    TestCase.assertTrue((!ev.getOperation().isLoad() ? 1 : 0) != 0);
                    TestCase.assertTrue((!ev.getOperation().isNetSearch() ? 1 : 0) != 0);
                    TestCase.assertTrue((!ev.getOperation().isExpiration() ? 1 : 0) != 0);
                    TestCase.assertEquals(null, (Object)ev.getCallbackArgument());
                    TestCase.assertEquals((boolean)true, (boolean)ev.isCallbackArgumentAvailable());
                    TestCase.assertTrue((boolean)ev.isOriginRemote());
                    TestCase.assertTrue((boolean)ev.getOperation().isDistributed());
                    CountingDistCacheListener cdcL = (CountingDistCacheListener)rgn1.getAttributes().getCacheListeners()[0];
                    cdcL.assertCount(0, 2, 1, 1);
                }
            });
        }
        catch (Exception e) {
            CacheFactory.getInstance((DistributedSystem)this.getSystem()).close();
            this.getSystem().getLogWriter().fine("testTXSimpleOps: Caused exception in createRegion");
            throw e;
        }
    }

    protected boolean supportsTransactions() {
        return true;
    }

    public void testTXUpdateLoadNoConflict() throws Exception {
    }

    public void testTXMultiRegion() throws Exception {
        if (!this.supportsTransactions()) {
            return;
        }
        TXManagerImpl txMgr = (TXManagerImpl)this.getCache().getCacheTransactionManager();
        RegionAttributes rattrs = this.getRegionAttributes();
        final DataPolicy dp = rattrs.getDataPolicy();
        if (rattrs.getScope().isGlobal() || dp.withPersistence()) {
            return;
        }
        final String rgnName1 = this.getUniqueName() + "MR1";
        final String rgnName2 = this.getUniqueName() + "MR2";
        final String rgnName3 = this.getUniqueName() + "MR3";
        SerializableRunnable create1 = new SerializableRunnable("testTXMultiRegion: Create Region"){

            @Override
            public void run() {
                CacheTransactionManager txMgr2 = MultiVMRegionTestCase.this.getCache().getCacheTransactionManager();
                MyTransactionListener tl = new MyTransactionListener();
                txMgr2.setListener((TransactionListener)tl);
                try {
                    MultiVMRegionTestCase.this.createRegion(rgnName1);
                    MultiVMRegionTestCase.this.getSystem().getLogWriter().info("testTXMultiRegion: Created region1");
                }
                catch (CacheException e) {
                    DistributedTestCase.fail("While creating region", e);
                }
            }
        };
        SerializableRunnable newKey1 = new SerializableRunnable("testTXMultiRegion: Create Key"){

            @Override
            public void run() {
                try {
                    Region rgn = MultiVMRegionTestCase.this.getRootRegion("root").getSubregion(rgnName1);
                    rgn.create((Object)"key", null);
                    MultiVMRegionTestCase.this.getSystem().getLogWriter().info("testTXMultiRegion: Created key");
                }
                catch (CacheException e) {
                    DistributedTestCase.fail("While creating region", e);
                }
            }
        };
        SerializableRunnable create2 = new SerializableRunnable("testTXMultiRegion: Create Region"){

            @Override
            public void run() {
                CacheTransactionManager txMgr2 = MultiVMRegionTestCase.this.getCache().getCacheTransactionManager();
                MyTransactionListener tl = new MyTransactionListener();
                txMgr2.setListener((TransactionListener)tl);
                try {
                    MultiVMRegionTestCase.this.createRegion(rgnName2);
                    MultiVMRegionTestCase.this.getSystem().getLogWriter().info("testTXMultiRegion: Created region2");
                }
                catch (CacheException e) {
                    DistributedTestCase.fail("While creating region", e);
                }
            }
        };
        SerializableRunnable newKey2 = new SerializableRunnable("testTXMultiRegion: Create Key"){

            @Override
            public void run() {
                try {
                    Region root = MultiVMRegionTestCase.this.getRootRegion("root");
                    Region rgn = root.getSubregion(rgnName2);
                    rgn.create((Object)"key", null);
                    MultiVMRegionTestCase.this.getSystem().getLogWriter().info("testTXMultiRegion: Created Key");
                }
                catch (CacheException e) {
                    DistributedTestCase.fail("While creating region", e);
                }
            }
        };
        SerializableRunnable create3 = new SerializableRunnable("testTXMultiRegion: Create Region"){

            @Override
            public void run() {
                CacheTransactionManager txMgr2 = MultiVMRegionTestCase.this.getCache().getCacheTransactionManager();
                MyTransactionListener tl = new MyTransactionListener();
                txMgr2.setListener((TransactionListener)tl);
                try {
                    MultiVMRegionTestCase.this.createRegion(rgnName3);
                    MultiVMRegionTestCase.this.getSystem().getLogWriter().info("testTXMultiRegion: Created Region");
                }
                catch (CacheException e) {
                    DistributedTestCase.fail("While creating region", e);
                }
            }
        };
        SerializableRunnable newKey3 = new SerializableRunnable("testTXMultiRegion: Create Key"){

            @Override
            public void run() {
                try {
                    Region root = MultiVMRegionTestCase.this.getRootRegion("root");
                    Region rgn = root.getSubregion(rgnName3);
                    rgn.create((Object)"key", null);
                    MultiVMRegionTestCase.this.getSystem().getLogWriter().info("testTXMultiRegion: Created Key");
                }
                catch (CacheException e) {
                    DistributedTestCase.fail("While creating region", e);
                }
            }
        };
        SerializableRunnable check1_3 = new SerializableRunnable("testTXMultiRegion: check"){

            @Override
            public void run() {
                Region rgn1 = MultiVMRegionTestCase.this.getRootRegion().getSubregion(rgnName1);
                TestCase.assertNotNull((String)"Could not find entry for 'key'", (Object)rgn1.getEntry((Object)"key"));
                TestCase.assertEquals((Object)"value1", (Object)rgn1.getEntry((Object)"key").getValue());
                Region rgn3 = MultiVMRegionTestCase.this.getRootRegion().getSubregion(rgnName3);
                TestCase.assertNotNull((String)"Could not find entry for 'key'", (Object)rgn3.getEntry((Object)"key"));
                TestCase.assertEquals((Object)"value3", (Object)rgn3.getEntry((Object)"key").getValue());
                CacheTransactionManager txMgr2 = MultiVMRegionTestCase.this.getCache().getCacheTransactionManager();
                MyTransactionListener tl = (MyTransactionListener)txMgr2.getListeners()[0];
                if (dp.withPartitioning()) {
                    return;
                }
                tl.checkAfterCommitCount(1);
                TestCase.assertEquals((int)0, (int)tl.afterFailedCommitCount);
                TestCase.assertEquals((int)0, (int)tl.afterRollbackCount);
                TestCase.assertEquals((int)0, (int)tl.closeCount);
                TestCase.assertEquals((Object)rgn1.getCache(), (Object)tl.lastEvent.getCache());
                RegionAttributes attr = MultiVMRegionTestCase.this.getRegionAttributes();
                List events = !attr.getDataPolicy().withReplication() || attr.getConcurrencyChecksEnabled() ? tl.lastEvent.getPutEvents() : tl.lastEvent.getCreateEvents();
                TestCase.assertEquals((int)2, (int)events.size());
                ArrayList eventList = new ArrayList(events);
                Collections.sort(eventList, new Comparator(){

                    public int compare(Object o1, Object o2) {
                        EntryEvent e1 = (EntryEvent)o1;
                        EntryEvent e2 = (EntryEvent)o2;
                        String s1 = e1.getRegion().getFullPath() + e1.getKey();
                        String s2 = e2.getRegion().getFullPath() + e2.getKey();
                        return s1.compareTo(s2);
                    }
                });
                Iterator it = eventList.iterator();
                EntryEvent ev = (EntryEvent)it.next();
                TestCase.assertSame((Object)rgn1, (Object)ev.getRegion());
                TestCase.assertEquals((Object)"key", (Object)ev.getKey());
                TestCase.assertEquals((Object)"value1", (Object)ev.getNewValue());
                TestCase.assertEquals(null, (Object)ev.getOldValue());
                TestCase.assertTrue((!ev.getOperation().isLocalLoad() ? 1 : 0) != 0);
                TestCase.assertTrue((!ev.getOperation().isNetLoad() ? 1 : 0) != 0);
                TestCase.assertTrue((!ev.getOperation().isLoad() ? 1 : 0) != 0);
                TestCase.assertTrue((!ev.getOperation().isNetSearch() ? 1 : 0) != 0);
                TestCase.assertTrue((!ev.getOperation().isExpiration() ? 1 : 0) != 0);
                TestCase.assertEquals(null, (Object)ev.getCallbackArgument());
                TestCase.assertEquals((boolean)true, (boolean)ev.isCallbackArgumentAvailable());
                TestCase.assertTrue((boolean)ev.isOriginRemote());
                TestCase.assertTrue((boolean)ev.getOperation().isDistributed());
                ev = (EntryEvent)it.next();
                TestCase.assertSame((Object)rgn3, (Object)ev.getRegion());
                TestCase.assertEquals((Object)"key", (Object)ev.getKey());
                TestCase.assertEquals((Object)"value3", (Object)ev.getNewValue());
                TestCase.assertEquals(null, (Object)ev.getOldValue());
                TestCase.assertTrue((!ev.getOperation().isLocalLoad() ? 1 : 0) != 0);
                TestCase.assertTrue((!ev.getOperation().isNetLoad() ? 1 : 0) != 0);
                TestCase.assertTrue((!ev.getOperation().isLoad() ? 1 : 0) != 0);
                TestCase.assertTrue((!ev.getOperation().isNetSearch() ? 1 : 0) != 0);
                TestCase.assertTrue((!ev.getOperation().isExpiration() ? 1 : 0) != 0);
                TestCase.assertEquals(null, (Object)ev.getCallbackArgument());
                TestCase.assertEquals((boolean)true, (boolean)ev.isCallbackArgumentAvailable());
                TestCase.assertTrue((boolean)ev.isOriginRemote());
                TestCase.assertTrue((boolean)ev.getOperation().isDistributed());
            }
        };
        SerializableRunnable check2_3 = new SerializableRunnable("testTXMultiRegion: check"){

            @Override
            public void run() {
                Region rgn2 = MultiVMRegionTestCase.this.getRootRegion().getSubregion(rgnName2);
                TestCase.assertNotNull((String)"Could not find entry for 'key'", (Object)rgn2.getEntry((Object)"key"));
                TestCase.assertEquals((Object)"value2", (Object)rgn2.getEntry((Object)"key").getValue());
                Region rgn3 = MultiVMRegionTestCase.this.getRootRegion().getSubregion(rgnName3);
                TestCase.assertNotNull((String)"Could not find entry for 'key'", (Object)rgn3.getEntry((Object)"key"));
                TestCase.assertEquals((Object)"value3", (Object)rgn3.getEntry((Object)"key").getValue());
                CacheTransactionManager txMgr2 = MultiVMRegionTestCase.this.getCache().getCacheTransactionManager();
                MyTransactionListener tl = (MyTransactionListener)txMgr2.getListeners()[0];
                if (dp.withPartitioning()) {
                    return;
                }
                tl.checkAfterCommitCount(1);
                TestCase.assertEquals((int)0, (int)tl.afterFailedCommitCount);
                TestCase.assertEquals((int)0, (int)tl.afterRollbackCount);
                TestCase.assertEquals((int)0, (int)tl.closeCount);
                TestCase.assertEquals((Object)rgn2.getCache(), (Object)tl.lastEvent.getCache());
                RegionAttributes attr = MultiVMRegionTestCase.this.getRegionAttributes();
                List events = !attr.getDataPolicy().withReplication() || attr.getConcurrencyChecksEnabled() ? tl.lastEvent.getPutEvents() : tl.lastEvent.getCreateEvents();
                TestCase.assertEquals((int)2, (int)events.size());
                ArrayList eventList = new ArrayList(events);
                Collections.sort(eventList, new Comparator(){

                    public int compare(Object o1, Object o2) {
                        EntryEvent e1 = (EntryEvent)o1;
                        EntryEvent e2 = (EntryEvent)o2;
                        String s1 = e1.getRegion().getFullPath() + e1.getKey();
                        String s2 = e2.getRegion().getFullPath() + e2.getKey();
                        return s1.compareTo(s2);
                    }
                });
                Iterator it = eventList.iterator();
                EntryEvent ev = (EntryEvent)it.next();
                TestCase.assertSame((Object)rgn2, (Object)ev.getRegion());
                TestCase.assertEquals((Object)"key", (Object)ev.getKey());
                TestCase.assertEquals((Object)"value2", (Object)ev.getNewValue());
                TestCase.assertEquals(null, (Object)ev.getOldValue());
                TestCase.assertTrue((!ev.getOperation().isLocalLoad() ? 1 : 0) != 0);
                TestCase.assertTrue((!ev.getOperation().isNetLoad() ? 1 : 0) != 0);
                TestCase.assertTrue((!ev.getOperation().isLoad() ? 1 : 0) != 0);
                TestCase.assertTrue((!ev.getOperation().isNetSearch() ? 1 : 0) != 0);
                TestCase.assertTrue((!ev.getOperation().isExpiration() ? 1 : 0) != 0);
                TestCase.assertEquals(null, (Object)ev.getCallbackArgument());
                TestCase.assertEquals((boolean)true, (boolean)ev.isCallbackArgumentAvailable());
                TestCase.assertTrue((boolean)ev.isOriginRemote());
                TestCase.assertTrue((boolean)ev.getOperation().isDistributed());
                ev = (EntryEvent)it.next();
                TestCase.assertSame((Object)rgn3, (Object)ev.getRegion());
                TestCase.assertEquals((Object)"key", (Object)ev.getKey());
                TestCase.assertEquals((Object)"value3", (Object)ev.getNewValue());
                TestCase.assertEquals(null, (Object)ev.getOldValue());
                TestCase.assertTrue((!ev.getOperation().isLocalLoad() ? 1 : 0) != 0);
                TestCase.assertTrue((!ev.getOperation().isNetLoad() ? 1 : 0) != 0);
                TestCase.assertTrue((!ev.getOperation().isLoad() ? 1 : 0) != 0);
                TestCase.assertTrue((!ev.getOperation().isNetSearch() ? 1 : 0) != 0);
                TestCase.assertTrue((!ev.getOperation().isExpiration() ? 1 : 0) != 0);
                TestCase.assertEquals(null, (Object)ev.getCallbackArgument());
                TestCase.assertEquals((boolean)true, (boolean)ev.isCallbackArgumentAvailable());
                TestCase.assertTrue((boolean)ev.isOriginRemote());
                TestCase.assertTrue((boolean)ev.getOperation().isDistributed());
            }
        };
        SerializableRunnable check1 = new SerializableRunnable("testTXMultiRegion: check"){

            @Override
            public void run() {
                Region rgn = MultiVMRegionTestCase.this.getRootRegion().getSubregion(rgnName1);
                TestCase.assertNotNull((String)"Could not find entry for 'key'", (Object)rgn.getEntry((Object)"key"));
                TestCase.assertEquals((Object)"value1", (Object)rgn.getEntry((Object)"key").getValue());
                CacheTransactionManager txMgr2 = MultiVMRegionTestCase.this.getCache().getCacheTransactionManager();
                MyTransactionListener tl = (MyTransactionListener)txMgr2.getListeners()[0];
                if (dp.withPartitioning()) {
                    return;
                }
                tl.checkAfterCommitCount(1);
                TestCase.assertEquals((int)0, (int)tl.afterFailedCommitCount);
                TestCase.assertEquals((int)0, (int)tl.afterRollbackCount);
                TestCase.assertEquals((int)0, (int)tl.closeCount);
                TestCase.assertEquals((Object)rgn.getCache(), (Object)tl.lastEvent.getCache());
                RegionAttributes attr = MultiVMRegionTestCase.this.getRegionAttributes();
                List events = !attr.getDataPolicy().withReplication() || attr.getConcurrencyChecksEnabled() ? tl.lastEvent.getPutEvents() : tl.lastEvent.getCreateEvents();
                TestCase.assertEquals((int)1, (int)events.size());
                EntryEvent ev = (EntryEvent)events.iterator().next();
                TestCase.assertTrue((ev.getRegion() == rgn ? 1 : 0) != 0);
                TestCase.assertEquals((Object)"key", (Object)ev.getKey());
                TestCase.assertEquals((Object)"value1", (Object)ev.getNewValue());
                TestCase.assertEquals(null, (Object)ev.getOldValue());
                TestCase.assertTrue((!ev.getOperation().isLocalLoad() ? 1 : 0) != 0);
                TestCase.assertTrue((!ev.getOperation().isNetLoad() ? 1 : 0) != 0);
                TestCase.assertTrue((!ev.getOperation().isLoad() ? 1 : 0) != 0);
                TestCase.assertTrue((!ev.getOperation().isNetSearch() ? 1 : 0) != 0);
                TestCase.assertTrue((!ev.getOperation().isExpiration() ? 1 : 0) != 0);
                TestCase.assertEquals(null, (Object)ev.getCallbackArgument());
                TestCase.assertEquals((boolean)true, (boolean)ev.isCallbackArgumentAvailable());
                TestCase.assertTrue((boolean)ev.isOriginRemote());
                TestCase.assertTrue((boolean)ev.getOperation().isDistributed());
            }
        };
        SerializableRunnable check2 = new SerializableRunnable("testTXMultiRegion: check"){

            @Override
            public void run() {
                Region rgn = MultiVMRegionTestCase.this.getRootRegion().getSubregion(rgnName2);
                TestCase.assertNotNull((String)"Could not find entry for 'key'", (Object)rgn.getEntry((Object)"key"));
                TestCase.assertEquals((Object)"value2", (Object)rgn.getEntry((Object)"key").getValue());
                CacheTransactionManager txMgr2 = MultiVMRegionTestCase.this.getCache().getCacheTransactionManager();
                MyTransactionListener tl = (MyTransactionListener)txMgr2.getListeners()[0];
                if (dp.withPartitioning()) {
                    return;
                }
                tl.checkAfterCommitCount(1);
                TestCase.assertEquals((int)0, (int)tl.afterFailedCommitCount);
                TestCase.assertEquals((int)0, (int)tl.afterRollbackCount);
                TestCase.assertEquals((int)0, (int)tl.closeCount);
                TestCase.assertEquals((Object)rgn.getCache(), (Object)tl.lastEvent.getCache());
                RegionAttributes attr = MultiVMRegionTestCase.this.getRegionAttributes();
                List events = !attr.getDataPolicy().withReplication() || attr.getConcurrencyChecksEnabled() ? tl.lastEvent.getPutEvents() : tl.lastEvent.getCreateEvents();
                TestCase.assertEquals((int)1, (int)events.size());
                EntryEvent ev = (EntryEvent)events.iterator().next();
                TestCase.assertTrue((ev.getRegion() == rgn ? 1 : 0) != 0);
                TestCase.assertEquals((Object)"key", (Object)ev.getKey());
                TestCase.assertEquals((Object)"value2", (Object)ev.getNewValue());
                TestCase.assertEquals(null, (Object)ev.getOldValue());
                TestCase.assertTrue((!ev.getOperation().isLocalLoad() ? 1 : 0) != 0);
                TestCase.assertTrue((!ev.getOperation().isNetLoad() ? 1 : 0) != 0);
                TestCase.assertTrue((!ev.getOperation().isLoad() ? 1 : 0) != 0);
                TestCase.assertTrue((!ev.getOperation().isNetSearch() ? 1 : 0) != 0);
                TestCase.assertTrue((!ev.getOperation().isExpiration() ? 1 : 0) != 0);
                TestCase.assertEquals(null, (Object)ev.getCallbackArgument());
                TestCase.assertEquals((boolean)true, (boolean)ev.isCallbackArgumentAvailable());
                TestCase.assertTrue((boolean)ev.isOriginRemote());
                TestCase.assertTrue((boolean)ev.getOperation().isDistributed());
            }
        };
        SerializableRunnable check3 = new SerializableRunnable("testTXMultiRegion: check"){

            @Override
            public void run() {
                Region rgn = MultiVMRegionTestCase.this.getRootRegion().getSubregion(rgnName3);
                TestCase.assertNotNull((String)"Could not find entry for 'key'", (Object)rgn.getEntry((Object)"key"));
                TestCase.assertEquals((Object)"value3", (Object)rgn.getEntry((Object)"key").getValue());
                CacheTransactionManager txMgr2 = MultiVMRegionTestCase.this.getCache().getCacheTransactionManager();
                MyTransactionListener tl = (MyTransactionListener)txMgr2.getListeners()[0];
                if (dp.withPartitioning()) {
                    return;
                }
                tl.checkAfterCommitCount(1);
                TestCase.assertEquals((int)0, (int)tl.afterFailedCommitCount);
                TestCase.assertEquals((int)0, (int)tl.afterRollbackCount);
                TestCase.assertEquals((int)0, (int)tl.closeCount);
                TestCase.assertEquals((Object)rgn.getCache(), (Object)tl.lastEvent.getCache());
                RegionAttributes attr = MultiVMRegionTestCase.this.getRegionAttributes();
                List events = !attr.getDataPolicy().withReplication() || attr.getConcurrencyChecksEnabled() ? tl.lastEvent.getPutEvents() : tl.lastEvent.getCreateEvents();
                TestCase.assertEquals((int)1, (int)events.size());
                EntryEvent ev = (EntryEvent)events.iterator().next();
                TestCase.assertTrue((ev.getRegion() == rgn ? 1 : 0) != 0);
                TestCase.assertEquals((Object)"key", (Object)ev.getKey());
                TestCase.assertEquals((Object)"value3", (Object)ev.getNewValue());
                TestCase.assertEquals(null, (Object)ev.getOldValue());
                TestCase.assertTrue((!ev.getOperation().isLocalLoad() ? 1 : 0) != 0);
                TestCase.assertTrue((!ev.getOperation().isNetLoad() ? 1 : 0) != 0);
                TestCase.assertTrue((!ev.getOperation().isLoad() ? 1 : 0) != 0);
                TestCase.assertTrue((!ev.getOperation().isNetSearch() ? 1 : 0) != 0);
                TestCase.assertTrue((!ev.getOperation().isExpiration() ? 1 : 0) != 0);
                TestCase.assertEquals(null, (Object)ev.getCallbackArgument());
                TestCase.assertEquals((boolean)true, (boolean)ev.isCallbackArgumentAvailable());
                TestCase.assertTrue((boolean)ev.isOriginRemote());
                TestCase.assertTrue((boolean)ev.getOperation().isDistributed());
            }
        };
        MultiVMRegionTestCase.assertEquals((int)4, (int)Host.getHost(0).getVMCount());
        VM vm0 = Host.getHost(0).getVM(0);
        VM vm1 = Host.getHost(0).getVM(1);
        VM vm2 = Host.getHost(0).getVM(2);
        VM vm3 = Host.getHost(0).getVM(3);
        try {
            DMStats dmStats = this.getSystem().getDistributionManager().getStats();
            vm0.invoke(create1);
            vm0.invoke(newKey1);
            vm0.invoke(create3);
            vm0.invoke(newKey3);
            vm1.invoke(create1);
            vm1.invoke(create3);
            if (!this.getRegionAttributes().getDataPolicy().withReplication() && this.getRegionAttributes().getDataPolicy() != DataPolicy.PRELOADED && !this.getRegionAttributes().getDataPolicy().withPartitioning()) {
                vm1.invoke(newKey1);
                vm1.invoke(newKey3);
            }
            vm2.invoke(create2);
            vm2.invoke(newKey2);
            vm3.invoke(create2);
            vm3.invoke(create3);
            if (!this.getRegionAttributes().getDataPolicy().withReplication() && this.getRegionAttributes().getDataPolicy() != DataPolicy.PRELOADED && !this.getRegionAttributes().getDataPolicy().withPartitioning()) {
                vm3.invoke(newKey2);
                vm3.invoke(newKey3);
            }
            Region rgn1 = this.createRegion(rgnName1);
            Region rgn2 = this.createRegion(rgnName2);
            Region rgn3 = this.createRegion(rgnName3);
            long cmtMsgs = dmStats.getSentCommitMessages();
            long commitWaits = dmStats.getCommitWaits();
            txMgr.begin();
            rgn1.put((Object)"key", (Object)"value1");
            rgn2.put((Object)"key", (Object)"value2");
            rgn3.put((Object)"key", (Object)"value3");
            this.getSystem().getLogWriter().info("testTXMultiRegion: vm0->R1,R3 vm1->R1,R3 vm2->R2 vm3->R2,R3");
            txMgr.commit();
            MultiVMRegionTestCase.assertEquals((long)(cmtMsgs + 1L), (long)dmStats.getSentCommitMessages());
            TXManagerImpl.waitForPendingCommitForTest();
            MultiVMRegionTestCase.assertEquals((long)(commitWaits + 1L), (long)dmStats.getCommitWaits());
            vm0.invoke(check1_3);
            vm1.invoke(check1_3);
            vm2.invoke(check2);
            vm3.invoke(check2_3);
            rgn1.destroyRegion();
            rgn2.destroyRegion();
            rgn3.destroyRegion();
            vm0.invoke(create1);
            vm0.invoke(newKey1);
            vm0.invoke(create3);
            vm0.invoke(newKey3);
            vm1.invoke(create1);
            vm1.invoke(create3);
            if (!this.getRegionAttributes().getDataPolicy().withReplication() && this.getRegionAttributes().getDataPolicy() != DataPolicy.PRELOADED && !this.getRegionAttributes().getDataPolicy().withPartitioning()) {
                vm1.invoke(newKey1);
                vm1.invoke(newKey3);
            }
            vm2.invoke(create2);
            vm2.invoke(newKey2);
            vm2.invoke(create3);
            if (!this.getRegionAttributes().getDataPolicy().withReplication() && this.getRegionAttributes().getDataPolicy() != DataPolicy.PRELOADED && !this.getRegionAttributes().getDataPolicy().withPartitioning()) {
                vm2.invoke(newKey3);
            }
            vm3.invoke(create2);
            vm3.invoke(create3);
            if (!this.getRegionAttributes().getDataPolicy().withReplication() && this.getRegionAttributes().getDataPolicy() != DataPolicy.PRELOADED && !this.getRegionAttributes().getDataPolicy().withPartitioning()) {
                vm3.invoke(newKey2);
                vm3.invoke(newKey3);
            }
            rgn1 = this.createRegion(rgnName1);
            rgn2 = this.createRegion(rgnName2);
            rgn3 = this.createRegion(rgnName3);
            cmtMsgs = dmStats.getSentCommitMessages();
            commitWaits = dmStats.getCommitWaits();
            txMgr.begin();
            rgn1.put((Object)"key", (Object)"value1");
            rgn2.put((Object)"key", (Object)"value2");
            rgn3.put((Object)"key", (Object)"value3");
            this.getSystem().getLogWriter().info("testTXMultiRegion: vm0->R1,R3 vm1->R1,R3 vm2->R2,R3 vm3->R2,R3");
            txMgr.commit();
            MultiVMRegionTestCase.assertEquals((long)(cmtMsgs + 1L), (long)dmStats.getSentCommitMessages());
            TXManagerImpl.waitForPendingCommitForTest();
            MultiVMRegionTestCase.assertEquals((long)(commitWaits + 1L), (long)dmStats.getCommitWaits());
            vm0.invoke(check1_3);
            vm1.invoke(check1_3);
            vm2.invoke(check2_3);
            vm3.invoke(check2_3);
            rgn1.destroyRegion();
            rgn2.destroyRegion();
            rgn3.destroyRegion();
            vm0.invoke(create1);
            vm0.invoke(newKey1);
            vm0.invoke(create3);
            vm0.invoke(newKey3);
            vm1.invoke(create1);
            vm1.invoke(create3);
            if (!this.getRegionAttributes().getDataPolicy().withReplication() && this.getRegionAttributes().getDataPolicy() != DataPolicy.PRELOADED && !this.getRegionAttributes().getDataPolicy().withPartitioning()) {
                vm1.invoke(newKey1);
                vm1.invoke(newKey3);
            }
            vm2.invoke(create2);
            vm2.invoke(newKey2);
            vm3.invoke(create1);
            vm3.invoke(create3);
            if (!this.getRegionAttributes().getDataPolicy().withReplication() && this.getRegionAttributes().getDataPolicy() != DataPolicy.PRELOADED && !this.getRegionAttributes().getDataPolicy().withPartitioning()) {
                vm3.invoke(newKey1);
                vm3.invoke(newKey3);
            }
            rgn1 = this.createRegion(rgnName1);
            rgn2 = this.createRegion(rgnName2);
            rgn3 = this.createRegion(rgnName3);
            cmtMsgs = dmStats.getSentCommitMessages();
            commitWaits = dmStats.getCommitWaits();
            txMgr.begin();
            rgn1.put((Object)"key", (Object)"value1");
            rgn2.put((Object)"key", (Object)"value2");
            rgn3.put((Object)"key", (Object)"value3");
            this.getSystem().getLogWriter().info("testTXMultiRegion: vm0->R1,R3 vm1->R1,R3 vm2->R2 vm3->R1,R3");
            txMgr.commit();
            MultiVMRegionTestCase.assertEquals((long)(cmtMsgs + 1L), (long)dmStats.getSentCommitMessages());
            TXManagerImpl.waitForPendingCommitForTest();
            MultiVMRegionTestCase.assertEquals((long)(commitWaits + 1L), (long)dmStats.getCommitWaits());
            vm0.invoke(check1_3);
            vm1.invoke(check1_3);
            vm2.invoke(check2);
            vm3.invoke(check1_3);
            rgn1.destroyRegion();
            rgn2.destroyRegion();
            rgn3.destroyRegion();
            vm0.invoke(create1);
            vm0.invoke(newKey1);
            vm1.invoke(create1);
            if (!this.getRegionAttributes().getDataPolicy().withReplication() && this.getRegionAttributes().getDataPolicy() != DataPolicy.PRELOADED && !this.getRegionAttributes().getDataPolicy().withPartitioning()) {
                vm1.invoke(newKey1);
            }
            vm2.invoke(create2);
            vm2.invoke(newKey2);
            vm3.invoke(create3);
            vm3.invoke(newKey3);
            rgn1 = this.createRegion(rgnName1);
            rgn2 = this.createRegion(rgnName2);
            rgn3 = this.createRegion(rgnName3);
            cmtMsgs = dmStats.getSentCommitMessages();
            commitWaits = dmStats.getCommitWaits();
            txMgr.begin();
            rgn1.put((Object)"key", (Object)"value1");
            rgn2.put((Object)"key", (Object)"value2");
            rgn3.put((Object)"key", (Object)"value3");
            this.getSystem().getLogWriter().info("testTXMultiRegion: vm0->R1 vm1->R1 vm2->R2 vm3->R3");
            txMgr.commit();
            MultiVMRegionTestCase.assertEquals((long)(cmtMsgs + 1L), (long)dmStats.getSentCommitMessages());
            TXManagerImpl.waitForPendingCommitForTest();
            MultiVMRegionTestCase.assertEquals((long)(commitWaits + 1L), (long)dmStats.getCommitWaits());
            vm0.invoke(check1);
            vm1.invoke(check1);
            vm2.invoke(check2);
            vm3.invoke(check3);
            rgn1.destroyRegion();
            rgn2.destroyRegion();
            rgn3.destroyRegion();
            vm0.invoke(create1);
            vm0.invoke(newKey1);
            vm0.invoke(create3);
            vm0.invoke(newKey3);
            vm1.invoke(create2);
            vm1.invoke(newKey2);
            vm1.invoke(create3);
            if (!this.getRegionAttributes().getDataPolicy().withReplication() && this.getRegionAttributes().getDataPolicy() != DataPolicy.PRELOADED && !this.getRegionAttributes().getDataPolicy().withPartitioning()) {
                vm1.invoke(newKey3);
            }
            vm2.invoke(create2);
            if (!this.getRegionAttributes().getDataPolicy().withReplication() && this.getRegionAttributes().getDataPolicy() != DataPolicy.PRELOADED && !this.getRegionAttributes().getDataPolicy().withPartitioning()) {
                vm2.invoke(newKey2);
            }
            vm3.invoke(create3);
            if (!this.getRegionAttributes().getDataPolicy().withReplication() && this.getRegionAttributes().getDataPolicy() != DataPolicy.PRELOADED && !this.getRegionAttributes().getDataPolicy().withPartitioning()) {
                vm3.invoke(newKey3);
            }
            rgn1 = this.createRegion(rgnName1);
            rgn2 = this.createRegion(rgnName2);
            rgn3 = this.createRegion(rgnName3);
            cmtMsgs = dmStats.getSentCommitMessages();
            commitWaits = dmStats.getCommitWaits();
            txMgr.begin();
            rgn1.put((Object)"key", (Object)"value1");
            rgn2.put((Object)"key", (Object)"value2");
            rgn3.put((Object)"key", (Object)"value3");
            this.getSystem().getLogWriter().info("testTXMultiRegion: vm0->R1,R3 vm1->R2,R3 vm2->R2 vm3->R3");
            txMgr.commit();
            MultiVMRegionTestCase.assertEquals((long)(cmtMsgs + 1L), (long)dmStats.getSentCommitMessages());
            TXManagerImpl.waitForPendingCommitForTest();
            MultiVMRegionTestCase.assertEquals((long)(commitWaits + 1L), (long)dmStats.getCommitWaits());
            vm0.invoke(check1_3);
            vm1.invoke(check2_3);
            vm2.invoke(check2);
            vm3.invoke(check3);
            rgn1.destroyRegion();
            rgn2.destroyRegion();
            rgn3.destroyRegion();
            vm0.invoke(create1);
            vm0.invoke(newKey1);
            vm0.invoke(create3);
            vm0.invoke(newKey3);
            vm1.invoke(create1);
            if (!this.getRegionAttributes().getDataPolicy().withReplication() && this.getRegionAttributes().getDataPolicy() != DataPolicy.PRELOADED && !this.getRegionAttributes().getDataPolicy().withPartitioning()) {
                vm1.invoke(newKey1);
            }
            vm1.invoke(create3);
            if (!this.getRegionAttributes().getDataPolicy().withReplication() && this.getRegionAttributes().getDataPolicy() != DataPolicy.PRELOADED && !this.getRegionAttributes().getDataPolicy().withPartitioning()) {
                vm1.invoke(newKey3);
            }
            vm2.invoke(create1);
            vm2.invoke(create3);
            if (!this.getRegionAttributes().getDataPolicy().withReplication() && this.getRegionAttributes().getDataPolicy() != DataPolicy.PRELOADED && !this.getRegionAttributes().getDataPolicy().withPartitioning()) {
                vm2.invoke(newKey1);
                vm2.invoke(newKey3);
            }
            vm3.invoke(create1);
            vm3.invoke(create3);
            if (!this.getRegionAttributes().getDataPolicy().withReplication() && this.getRegionAttributes().getDataPolicy() != DataPolicy.PRELOADED && !this.getRegionAttributes().getDataPolicy().withPartitioning()) {
                vm3.invoke(newKey1);
                vm3.invoke(newKey3);
            }
            rgn1 = this.createRegion(rgnName1);
            rgn2 = this.createRegion(rgnName2);
            rgn3 = this.createRegion(rgnName3);
            cmtMsgs = dmStats.getSentCommitMessages();
            commitWaits = dmStats.getCommitWaits();
            txMgr.begin();
            rgn1.put((Object)"key", (Object)"value1");
            rgn2.put((Object)"key", (Object)"value2");
            rgn3.put((Object)"key", (Object)"value3");
            this.getSystem().getLogWriter().info("testTXMultiRegion: vm0->R1,R3 vm1->R1,R3 vm2->R1,R3 vm3->R1,R3");
            txMgr.commit();
            MultiVMRegionTestCase.assertEquals((long)(cmtMsgs + 1L), (long)dmStats.getSentCommitMessages());
            TXManagerImpl.waitForPendingCommitForTest();
            MultiVMRegionTestCase.assertEquals((long)(commitWaits + 1L), (long)dmStats.getCommitWaits());
            vm0.invoke(check1_3);
            vm1.invoke(check1_3);
            vm2.invoke(check1_3);
            vm3.invoke(check1_3);
            rgn1.destroyRegion();
            rgn2.destroyRegion();
            rgn3.destroyRegion();
        }
        catch (Exception e) {
            CacheFactory.getInstance((DistributedSystem)this.getSystem()).close();
            this.getSystem().getLogWriter().fine("testTXMultiRegion: Caused exception in createRegion");
            throw e;
        }
    }

    public void testTXRmtMirror() throws Exception {
        if (!this.supportsTransactions()) {
            return;
        }
        RegionAttributes attrs = this.getRegionAttributes();
        MultiVMRegionTestCase.assertTrue((boolean)attrs.getScope().isDistributed());
        TXManagerImpl txMgr = (TXManagerImpl)this.getCache().getCacheTransactionManager();
        if (attrs.getScope().isGlobal() || attrs.getDataPolicy().withPersistence() || attrs.getPartitionAttributes() != null) {
            return;
        }
        final String rgnName = this.getUniqueName();
        SerializableRunnable createMirror = new SerializableRunnable("textTXRmtMirror: Create Mirrored Region"){

            @Override
            public void run() {
                CacheTransactionManager txMgr2 = MultiVMRegionTestCase.this.getCache().getCacheTransactionManager();
                MyTransactionListener tl = new MyTransactionListener();
                txMgr2.addListener((TransactionListener)tl);
                try {
                    AttributesFactory rgnAtts = new AttributesFactory(MultiVMRegionTestCase.this.getRegionAttributes());
                    rgnAtts.setDataPolicy(DataPolicy.REPLICATE);
                    MultiVMRegionTestCase.this.createRegion(rgnName, rgnAtts.create());
                }
                catch (CacheException e) {
                    DistributedTestCase.fail("While creating region", e);
                }
            }
        };
        SerializableRunnable createNonMirror = new SerializableRunnable("textTXRmtMirror: Create Mirrored Region"){

            @Override
            public void run() {
                CacheTransactionManager txMgr2 = MultiVMRegionTestCase.this.getCache().getCacheTransactionManager();
                MyTransactionListener tl = new MyTransactionListener();
                txMgr2.addListener((TransactionListener)tl);
                try {
                    AttributesFactory rgnAtts = new AttributesFactory(MultiVMRegionTestCase.this.getRegionAttributes());
                    rgnAtts.setDataPolicy(DataPolicy.NORMAL);
                    MultiVMRegionTestCase.this.createRegion(rgnName, rgnAtts.create());
                }
                catch (CacheException e) {
                    DistributedTestCase.fail("While creating region", e);
                }
            }
        };
        SerializableRunnable checkExists = new SerializableRunnable("textTXRmtMirror: checkExists"){

            @Override
            public void run() {
                Region rgn = MultiVMRegionTestCase.this.getRootRegion().getSubregion(rgnName);
                TestCase.assertNotNull((String)"Could not find entry for 'key'", (Object)rgn.getEntry((Object)"key"));
                TestCase.assertEquals((Object)"value", (Object)rgn.getEntry((Object)"key").getValue());
                CacheTransactionManager txMgr2 = MultiVMRegionTestCase.this.getCache().getCacheTransactionManager();
                MyTransactionListener tl = (MyTransactionListener)txMgr2.getListeners()[0];
                tl.checkAfterCommitCount(1);
                TestCase.assertEquals((int)0, (int)tl.afterFailedCommitCount);
                TestCase.assertEquals((int)0, (int)tl.afterRollbackCount);
                TestCase.assertEquals((int)0, (int)tl.closeCount);
                TestCase.assertEquals((Object)rgn.getCache(), (Object)tl.lastEvent.getCache());
                List events = tl.lastEvent.getCreateEvents();
                TestCase.assertEquals((int)1, (int)events.size());
                EntryEvent ev = (EntryEvent)events.iterator().next();
                TestCase.assertTrue((ev.getRegion() == rgn ? 1 : 0) != 0);
                TestCase.assertEquals((Object)"key", (Object)ev.getKey());
                TestCase.assertEquals((Object)"value", (Object)ev.getNewValue());
                TestCase.assertEquals(null, (Object)ev.getOldValue());
                TestCase.assertTrue((!ev.getOperation().isLocalLoad() ? 1 : 0) != 0);
                TestCase.assertTrue((!ev.getOperation().isNetLoad() ? 1 : 0) != 0);
                TestCase.assertTrue((!ev.getOperation().isLoad() ? 1 : 0) != 0);
                TestCase.assertTrue((!ev.getOperation().isNetSearch() ? 1 : 0) != 0);
                TestCase.assertTrue((!ev.getOperation().isExpiration() ? 1 : 0) != 0);
                TestCase.assertEquals(null, (Object)ev.getCallbackArgument());
                TestCase.assertEquals((boolean)true, (boolean)ev.isCallbackArgumentAvailable());
                TestCase.assertTrue((boolean)ev.isOriginRemote());
                TestCase.assertTrue((boolean)ev.getOperation().isDistributed());
            }
        };
        SerializableRunnable checkNoKey = new SerializableRunnable("textTXRmtMirror: checkNoKey"){

            @Override
            public void run() {
                Region rgn = MultiVMRegionTestCase.this.getRootRegion().getSubregion(rgnName);
                TestCase.assertTrue((rgn.getEntry((Object)"key") == null ? 1 : 0) != 0);
                CacheTransactionManager txMgr2 = MultiVMRegionTestCase.this.getCache().getCacheTransactionManager();
                MyTransactionListener tl = (MyTransactionListener)txMgr2.getListeners()[0];
                TestCase.assertTrue((String)("unexpected commit count " + tl.afterCommitCount), (tl.afterCommitCount == 0 || tl.afterCommitCount == 1 ? 1 : 0) != 0);
                TestCase.assertEquals((int)0, (int)tl.afterFailedCommitCount);
                TestCase.assertEquals((int)0, (int)tl.afterRollbackCount);
                TestCase.assertEquals((int)0, (int)tl.closeCount);
                if (tl.lastEvent != null) {
                    TestCase.assertEquals((int)0, (int)tl.lastEvent.getCreateEvents().size());
                    TestCase.assertEquals((int)0, (int)tl.lastEvent.getPutEvents().size());
                    TestCase.assertEquals((Object)rgn.getCache(), (Object)tl.lastEvent.getCache());
                }
            }
        };
        try {
            Host.getHost(0).getVM(0).invoke(createMirror);
            Host.getHost(0).getVM(1).invoke(createNonMirror);
            Region rgn = this.createRegion(rgnName);
            txMgr.begin();
            rgn.create((Object)"key", (Object)"value");
            this.getSystem().getLogWriter().info("textTXRmtMirror: create mirror and non-mirror");
            txMgr.commit();
            TXManagerImpl.waitForPendingCommitForTest();
            Host.getHost(0).getVM(0).invoke(checkExists);
            Host.getHost(0).getVM(1).invoke(checkNoKey);
            rgn.destroyRegion();
        }
        catch (Exception e) {
            CacheFactory.getInstance((DistributedSystem)this.getSystem()).close();
            this.getSystem().getLogWriter().fine("textTXRmtMirror: Caused exception in createRegion");
            throw e;
        }
    }

    public void todo_testTXAlgebra() throws Exception {
        MultiVMRegionTestCase.assertTrue((boolean)this.getRegionAttributes().getScope().isDistributed());
        if (this.getRegionAttributes().getScope().isGlobal() || this.getRegionAttributes().getDataPolicy().withPersistence()) {
            return;
        }
        CacheTransactionManager txMgr = this.getCache().getCacheTransactionManager();
        MyTransactionListener localTl = new MyTransactionListener();
        txMgr.addListener((TransactionListener)localTl);
        MultiVMRegionTestCase.assertEquals(null, (Object)localTl.lastEvent);
        localTl.assertCounts(0, 0, 0, 0);
        final String rgnName = this.getUniqueName();
        SerializableRunnable create = new SerializableRunnable("testTXAlgebra: Create Region"){

            @Override
            public void run() {
                CacheTransactionManager txMgr2 = MultiVMRegionTestCase.this.getCache().getCacheTransactionManager();
                MyTransactionListener tl = new MyTransactionListener();
                txMgr2.addListener((TransactionListener)tl);
                TestCase.assertEquals(null, (Object)tl.lastEvent);
                tl.assertCounts(0, 0, 0, 0);
                try {
                    Region rgn = MultiVMRegionTestCase.this.createRegion(rgnName);
                    if (!MultiVMRegionTestCase.this.getRegionAttributes().getDataPolicy().withReplication()) {
                        rgn.create((Object)"key", null);
                        MultiVMRegionTestCase.this.getSystem().getLogWriter().info("testTXAlgebra: Created Key");
                    }
                }
                catch (CacheException e) {
                    DistributedTestCase.fail("While creating region", e);
                }
            }
        };
        MultiVMRegionTestCase.invokeInEveryVM(create);
        try {
            AttributesFactory rgnAtts = new AttributesFactory(this.getRegionAttributes());
            rgnAtts.setDataPolicy(DataPolicy.NORMAL);
            Region rgn = this.createRegion(rgnName, rgnAtts.create());
            txMgr.begin();
            TransactionId myTXId = txMgr.getTransactionId();
            rgn.create((Object)"key", (Object)"value1");
            try {
                rgn.create((Object)"key", (Object)"value2");
                MultiVMRegionTestCase.fail((String)"expected EntryExistsException");
            }
            catch (EntryExistsException entryExistsException) {
                // empty catch block
            }
            rgn.put((Object)"key", (Object)"value2");
            MultiVMRegionTestCase.assertEquals((Object)"value2", (Object)rgn.getEntry((Object)"key").getValue());
            txMgr.commit();
            TXManagerImpl.waitForPendingCommitForTest();
            MultiVMRegionTestCase.invokeInEveryVM(new CacheSerializableRunnable("testTXAlgebra: check: C+P->C"){

                @Override
                public void run2() {
                    Region rgn1 = MultiVMRegionTestCase.this.getRootRegion().getSubregion(rgnName);
                    CacheTransactionManager txMgr2 = MultiVMRegionTestCase.this.getCache().getCacheTransactionManager();
                    MyTransactionListener tl = (MyTransactionListener)txMgr2.getListeners()[0];
                    TestCase.assertEquals((Object)"value2", (Object)rgn1.getEntry((Object)"key").getValue());
                    tl.assertCounts(1, 0, 0, 0);
                    RegionAttributes attr = MultiVMRegionTestCase.this.getRegionAttributes();
                    List events = !attr.getDataPolicy().withReplication() || attr.getConcurrencyChecksEnabled() ? tl.lastEvent.getPutEvents() : tl.lastEvent.getCreateEvents();
                    TestCase.assertEquals((int)1, (int)events.size());
                    EntryEvent ev = (EntryEvent)events.iterator().next();
                    TestCase.assertTrue((ev.getRegion() == rgn1 ? 1 : 0) != 0);
                    TestCase.assertEquals((Object)"key", (Object)ev.getKey());
                    TestCase.assertEquals((Object)"value2", (Object)ev.getNewValue());
                    TestCase.assertNull((Object)ev.getOldValue());
                    TestCase.assertTrue((!ev.getOperation().isLocalLoad() ? 1 : 0) != 0);
                    TestCase.assertTrue((!ev.getOperation().isNetLoad() ? 1 : 0) != 0);
                    TestCase.assertTrue((!ev.getOperation().isLoad() ? 1 : 0) != 0);
                    TestCase.assertTrue((!ev.getOperation().isNetSearch() ? 1 : 0) != 0);
                    TestCase.assertTrue((!ev.getOperation().isExpiration() ? 1 : 0) != 0);
                    TestCase.assertEquals(null, (Object)ev.getCallbackArgument());
                    TestCase.assertEquals((boolean)true, (boolean)ev.isCallbackArgumentAvailable());
                    TestCase.assertTrue((boolean)ev.isOriginRemote());
                    TestCase.assertTrue((boolean)ev.getOperation().isDistributed());
                }
            });
            MultiVMRegionTestCase.assertEquals((Object)"value2", (Object)rgn.getEntry((Object)"key").getValue());
            localTl.assertCounts(1, 0, 0, 0);
            List events = localTl.lastEvent.getCreateEvents();
            MultiVMRegionTestCase.assertEquals((Object)myTXId, (Object)localTl.lastEvent.getTransactionId());
            MultiVMRegionTestCase.assertEquals((int)1, (int)events.size());
            EntryEvent ev = (EntryEvent)events.iterator().next();
            MultiVMRegionTestCase.assertEquals((Object)myTXId, (Object)ev.getTransactionId());
            MultiVMRegionTestCase.assertTrue((ev.getRegion() == rgn ? 1 : 0) != 0);
            MultiVMRegionTestCase.assertEquals((Object)"key", (Object)ev.getKey());
            MultiVMRegionTestCase.assertEquals((Object)"value2", (Object)ev.getNewValue());
            MultiVMRegionTestCase.assertNull((Object)ev.getOldValue());
            MultiVMRegionTestCase.assertTrue((!ev.getOperation().isLocalLoad() ? 1 : 0) != 0);
            MultiVMRegionTestCase.assertTrue((!ev.getOperation().isNetLoad() ? 1 : 0) != 0);
            MultiVMRegionTestCase.assertTrue((!ev.getOperation().isLoad() ? 1 : 0) != 0);
            MultiVMRegionTestCase.assertTrue((!ev.getOperation().isNetSearch() ? 1 : 0) != 0);
            MultiVMRegionTestCase.assertEquals(null, (Object)ev.getCallbackArgument());
            MultiVMRegionTestCase.assertEquals((boolean)true, (boolean)ev.isCallbackArgumentAvailable());
            MultiVMRegionTestCase.assertTrue((!ev.isOriginRemote() ? 1 : 0) != 0);
            MultiVMRegionTestCase.assertTrue((!ev.getOperation().isExpiration() ? 1 : 0) != 0);
            MultiVMRegionTestCase.assertTrue((boolean)ev.getOperation().isDistributed());
            if (!this.getRegionAttributes().getDataPolicy().withReplication()) {
                rgn.invalidate((Object)"key");
                rgn.localDestroy((Object)"key");
            } else {
                rgn.destroy((Object)"key");
            }
            txMgr.begin();
            myTXId = txMgr.getTransactionId();
            rgn.create((Object)"key", (Object)"value1");
            rgn.invalidate((Object)"key");
            MultiVMRegionTestCase.assertTrue((boolean)rgn.containsKey((Object)"key"));
            MultiVMRegionTestCase.assertTrue((!rgn.containsValueForKey((Object)"key") ? 1 : 0) != 0);
            txMgr.commit();
            TXManagerImpl.waitForPendingCommitForTest();
            MultiVMRegionTestCase.invokeInEveryVM(new CacheSerializableRunnable("testTXAlgebra: check: C+DI->C (invalid value)"){

                @Override
                public void run2() {
                    Region rgn1 = MultiVMRegionTestCase.this.getRootRegion().getSubregion(rgnName);
                    CacheTransactionManager txMgr2 = MultiVMRegionTestCase.this.getCache().getCacheTransactionManager();
                    MyTransactionListener tl = (MyTransactionListener)txMgr2.getListeners()[0];
                    TestCase.assertTrue((boolean)rgn1.containsKey((Object)"key"));
                    TestCase.assertTrue((!rgn1.containsValueForKey((Object)"key") ? 1 : 0) != 0);
                    tl.assertCounts(2, 0, 0, 0);
                    RegionAttributes attr = MultiVMRegionTestCase.this.getRegionAttributes();
                    List events = !attr.getDataPolicy().withReplication() || attr.getConcurrencyChecksEnabled() ? tl.lastEvent.getPutEvents() : tl.lastEvent.getCreateEvents();
                    TestCase.assertEquals((int)1, (int)events.size());
                    EntryEvent ev = (EntryEvent)events.iterator().next();
                    TestCase.assertTrue((ev.getRegion() == rgn1 ? 1 : 0) != 0);
                    TestCase.assertEquals((Object)"key", (Object)ev.getKey());
                    TestCase.assertNull((Object)ev.getNewValue());
                    TestCase.assertNull((Object)ev.getOldValue());
                    TestCase.assertTrue((!ev.getOperation().isLocalLoad() ? 1 : 0) != 0);
                    TestCase.assertTrue((!ev.getOperation().isNetLoad() ? 1 : 0) != 0);
                    TestCase.assertTrue((!ev.getOperation().isLoad() ? 1 : 0) != 0);
                    TestCase.assertTrue((!ev.getOperation().isNetSearch() ? 1 : 0) != 0);
                    TestCase.assertTrue((!ev.getOperation().isExpiration() ? 1 : 0) != 0);
                    TestCase.assertEquals(null, (Object)ev.getCallbackArgument());
                    TestCase.assertEquals((boolean)true, (boolean)ev.isCallbackArgumentAvailable());
                    TestCase.assertTrue((boolean)ev.isOriginRemote());
                    TestCase.assertTrue((boolean)ev.getOperation().isDistributed());
                }
            });
            MultiVMRegionTestCase.assertTrue((boolean)rgn.containsKey((Object)"key"));
            MultiVMRegionTestCase.assertTrue((!rgn.containsValueForKey((Object)"key") ? 1 : 0) != 0);
            localTl.assertCounts(2, 0, 0, 0);
            events = localTl.lastEvent.getCreateEvents();
            MultiVMRegionTestCase.assertEquals((Object)myTXId, (Object)localTl.lastEvent.getTransactionId());
            MultiVMRegionTestCase.assertEquals((int)1, (int)events.size());
            ev = (EntryEvent)events.iterator().next();
            MultiVMRegionTestCase.assertEquals((Object)myTXId, (Object)ev.getTransactionId());
            MultiVMRegionTestCase.assertTrue((ev.getRegion() == rgn ? 1 : 0) != 0);
            MultiVMRegionTestCase.assertEquals((Object)"key", (Object)ev.getKey());
            MultiVMRegionTestCase.assertNull((Object)ev.getNewValue());
            MultiVMRegionTestCase.assertNull((Object)ev.getOldValue());
            MultiVMRegionTestCase.assertTrue((!ev.getOperation().isLocalLoad() ? 1 : 0) != 0);
            MultiVMRegionTestCase.assertTrue((!ev.getOperation().isNetLoad() ? 1 : 0) != 0);
            MultiVMRegionTestCase.assertTrue((!ev.getOperation().isLoad() ? 1 : 0) != 0);
            MultiVMRegionTestCase.assertTrue((!ev.getOperation().isNetSearch() ? 1 : 0) != 0);
            MultiVMRegionTestCase.assertEquals(null, (Object)ev.getCallbackArgument());
            MultiVMRegionTestCase.assertEquals((boolean)true, (boolean)ev.isCallbackArgumentAvailable());
            MultiVMRegionTestCase.assertTrue((!ev.isOriginRemote() ? 1 : 0) != 0);
            MultiVMRegionTestCase.assertTrue((!ev.getOperation().isExpiration() ? 1 : 0) != 0);
            MultiVMRegionTestCase.assertTrue((boolean)ev.getOperation().isDistributed());
            MultiVMRegionTestCase.assertTrue((boolean)rgn.containsKey((Object)"key"));
            MultiVMRegionTestCase.assertTrue((!rgn.containsValueForKey((Object)"key") ? 1 : 0) != 0);
            txMgr.begin();
            myTXId = txMgr.getTransactionId();
            rgn.invalidate((Object)"key");
            MultiVMRegionTestCase.assertTrue((boolean)rgn.containsKey((Object)"key"));
            MultiVMRegionTestCase.assertTrue((!rgn.containsValueForKey((Object)"key") ? 1 : 0) != 0);
            txMgr.commit();
            TXManagerImpl.waitForPendingCommitForTest();
            MultiVMRegionTestCase.invokeInEveryVM(new CacheSerializableRunnable("testTXAlgebra: check: committed LI + TX DI-> NOOP"){

                @Override
                public void run2() {
                    Region rgn1 = MultiVMRegionTestCase.this.getRootRegion().getSubregion(rgnName);
                    CacheTransactionManager txMgr2 = MultiVMRegionTestCase.this.getCache().getCacheTransactionManager();
                    MyTransactionListener tl = (MyTransactionListener)txMgr2.getListeners()[0];
                    TestCase.assertEquals((Object)"value1", (Object)rgn1.getEntry((Object)"key").getValue());
                    tl.assertCounts(2, 0, 0, 0);
                }
            });
            MultiVMRegionTestCase.assertTrue((boolean)rgn.containsKey((Object)"key"));
            MultiVMRegionTestCase.assertTrue((!rgn.containsValueForKey((Object)"key") ? 1 : 0) != 0);
            localTl.assertCounts(2, 0, 0, 0);
            if (!this.getRegionAttributes().getDataPolicy().withReplication()) {
                rgn.put((Object)"key", (Object)"value1");
                MultiVMRegionTestCase.assertTrue((boolean)rgn.containsKey((Object)"key"));
                MultiVMRegionTestCase.assertEquals((Object)"value1", (Object)rgn.getEntry((Object)"key").getValue());
                txMgr.begin();
                myTXId = txMgr.getTransactionId();
                rgn.localInvalidate((Object)"key");
                rgn.invalidate((Object)"key");
                MultiVMRegionTestCase.assertTrue((boolean)rgn.containsKey((Object)"key"));
                MultiVMRegionTestCase.assertTrue((!rgn.containsValueForKey((Object)"key") ? 1 : 0) != 0);
                txMgr.commit();
                TXManagerImpl.waitForPendingCommitForTest();
                MultiVMRegionTestCase.invokeInEveryVM(new CacheSerializableRunnable("testTXAlgebra: check: TX LI + TX DI -> LI"){

                    @Override
                    public void run2() {
                        Region rgn1 = MultiVMRegionTestCase.this.getRootRegion().getSubregion(rgnName);
                        CacheTransactionManager txMgr2 = MultiVMRegionTestCase.this.getCache().getCacheTransactionManager();
                        MyTransactionListener tl = (MyTransactionListener)txMgr2.getListeners()[0];
                        TestCase.assertTrue((boolean)rgn1.containsKey((Object)"key"));
                        TestCase.assertTrue((boolean)rgn1.containsValueForKey((Object)"key"));
                        TestCase.assertEquals((Object)"value1", (Object)rgn1.getEntry((Object)"key").getValue());
                        tl.assertCounts(2, 0, 0, 0);
                    }
                });
                MultiVMRegionTestCase.assertTrue((boolean)rgn.containsKey((Object)"key"));
                MultiVMRegionTestCase.assertTrue((!rgn.containsValueForKey((Object)"key") ? 1 : 0) != 0);
                MultiVMRegionTestCase.assertNull((Object)rgn.getEntry((Object)"key").getValue());
                localTl.assertCounts(3, 0, 0, 0);
                events = localTl.lastEvent.getInvalidateEvents();
                MultiVMRegionTestCase.assertEquals((int)1, (int)events.size());
                ev = (EntryEvent)events.iterator().next();
                MultiVMRegionTestCase.assertEquals((Object)myTXId, (Object)ev.getTransactionId());
                MultiVMRegionTestCase.assertTrue((ev.getRegion() == rgn ? 1 : 0) != 0);
                MultiVMRegionTestCase.assertEquals((Object)"key", (Object)ev.getKey());
                MultiVMRegionTestCase.assertNull((Object)ev.getNewValue());
                MultiVMRegionTestCase.assertEquals((Object)"value1", (Object)ev.getOldValue());
                MultiVMRegionTestCase.assertTrue((!ev.getOperation().isLocalLoad() ? 1 : 0) != 0);
                MultiVMRegionTestCase.assertTrue((!ev.getOperation().isNetLoad() ? 1 : 0) != 0);
                MultiVMRegionTestCase.assertTrue((!ev.getOperation().isLoad() ? 1 : 0) != 0);
                MultiVMRegionTestCase.assertTrue((!ev.getOperation().isNetSearch() ? 1 : 0) != 0);
                MultiVMRegionTestCase.assertEquals(null, (Object)ev.getCallbackArgument());
                MultiVMRegionTestCase.assertEquals((boolean)true, (boolean)ev.isCallbackArgumentAvailable());
                MultiVMRegionTestCase.assertTrue((!ev.isOriginRemote() ? 1 : 0) != 0);
                MultiVMRegionTestCase.assertTrue((!ev.getOperation().isExpiration() ? 1 : 0) != 0);
                MultiVMRegionTestCase.assertTrue((boolean)ev.getOperation().isDistributed());
                rgn.invalidate((Object)"key");
                rgn.localDestroy((Object)"key");
            } else {
                rgn.destroy((Object)"key");
            }
            txMgr.begin();
            myTXId = txMgr.getTransactionId();
            rgn.create((Object)"key", (Object)"value0");
            rgn.destroy((Object)"key");
            MultiVMRegionTestCase.assertTrue((!rgn.containsKey((Object)"key") ? 1 : 0) != 0);
            txMgr.commit();
            TXManagerImpl.waitForPendingCommitForTest();
            MultiVMRegionTestCase.invokeInEveryVM(new CacheSerializableRunnable("testTXAlgebra: check: C+DD->DD"){

                @Override
                public void run2() {
                    Region rgn1 = MultiVMRegionTestCase.this.getRootRegion().getSubregion(rgnName);
                    CacheTransactionManager txMgr2 = MultiVMRegionTestCase.this.getCache().getCacheTransactionManager();
                    MyTransactionListener tl = (MyTransactionListener)txMgr2.getListeners()[0];
                    TestCase.assertTrue((!rgn1.containsKey((Object)"key") ? 1 : 0) != 0);
                    TestCase.assertTrue((!rgn1.containsValueForKey((Object)"key") ? 1 : 0) != 0);
                    tl.assertCounts(3, 0, 0, 0);
                    List events = tl.lastEvent.getDestroyEvents();
                    TestCase.assertEquals((int)1, (int)events.size());
                    EntryEvent ev = (EntryEvent)events.iterator().next();
                    TestCase.assertTrue((ev.getRegion() == rgn1 ? 1 : 0) != 0);
                    TestCase.assertNull((Object)ev.getKey());
                    TestCase.assertNull((Object)ev.getNewValue());
                    TestCase.assertNull((Object)ev.getOldValue());
                    TestCase.assertTrue((!ev.getOperation().isLocalLoad() ? 1 : 0) != 0);
                    TestCase.assertTrue((!ev.getOperation().isNetLoad() ? 1 : 0) != 0);
                    TestCase.assertTrue((!ev.getOperation().isLoad() ? 1 : 0) != 0);
                    TestCase.assertTrue((!ev.getOperation().isNetSearch() ? 1 : 0) != 0);
                    TestCase.assertTrue((!ev.getOperation().isExpiration() ? 1 : 0) != 0);
                    TestCase.assertEquals(null, (Object)ev.getCallbackArgument());
                    TestCase.assertEquals((boolean)true, (boolean)ev.isCallbackArgumentAvailable());
                    TestCase.assertTrue((boolean)ev.isOriginRemote());
                    TestCase.assertTrue((boolean)ev.getOperation().isDistributed());
                }
            });
            MultiVMRegionTestCase.assertTrue((!rgn.containsKey((Object)"key") ? 1 : 0) != 0);
            localTl.assertCounts(3, 0, 0, 0);
            if (!this.getRegionAttributes().getDataPolicy().withReplication()) {
                MultiVMRegionTestCase.invokeInEveryVM(new CacheSerializableRunnable("testTXAlgebra: C+LI-> entry creation"){

                    @Override
                    public void run2() {
                        Region rgn1 = MultiVMRegionTestCase.this.getRootRegion().getSubregion(rgnName);
                        try {
                            rgn1.create((Object)"key", null);
                        }
                        catch (CacheException e) {
                            DistributedTestCase.fail("While creating key", e);
                        }
                    }
                });
            }
            MultiVMRegionTestCase.assertTrue((!rgn.containsKey((Object)"key") ? 1 : 0) != 0);
            txMgr.begin();
            myTXId = txMgr.getTransactionId();
            rgn.create((Object)"key", (Object)"value1");
            rgn.localInvalidate((Object)"key");
            MultiVMRegionTestCase.assertTrue((boolean)rgn.containsKey((Object)"key"));
            MultiVMRegionTestCase.assertTrue((!rgn.containsValueForKey((Object)"key") ? 1 : 0) != 0);
            txMgr.commit();
            TXManagerImpl.waitForPendingCommitForTest();
            MultiVMRegionTestCase.invokeInEveryVM(new CacheSerializableRunnable("testTXAlgebra: check: C+LI->C (with value)"){

                @Override
                public void run2() {
                    Region rgn1 = MultiVMRegionTestCase.this.getRootRegion().getSubregion(rgnName);
                    CacheTransactionManager txMgr2 = MultiVMRegionTestCase.this.getCache().getCacheTransactionManager();
                    MyTransactionListener tl = (MyTransactionListener)txMgr2.getListeners()[0];
                    tl.assertCounts(4, 0, 0, 0);
                    TestCase.assertTrue((boolean)rgn1.containsKey((Object)"key"));
                    TestCase.assertEquals((Object)"value1", (Object)rgn1.getEntry((Object)"key").getValue());
                    RegionAttributes attr = MultiVMRegionTestCase.this.getRegionAttributes();
                    List events = !attr.getDataPolicy().withReplication() || attr.getConcurrencyChecksEnabled() ? tl.lastEvent.getPutEvents() : tl.lastEvent.getCreateEvents();
                    TestCase.assertEquals((int)1, (int)events.size());
                    EntryEvent ev = (EntryEvent)events.iterator().next();
                    TestCase.assertTrue((ev.getRegion() == rgn1 ? 1 : 0) != 0);
                    TestCase.assertEquals((Object)"key", (Object)ev.getKey());
                    TestCase.assertEquals((Object)"value1", (Object)ev.getNewValue());
                    TestCase.assertNull((Object)ev.getOldValue());
                    TestCase.assertTrue((!ev.getOperation().isLocalLoad() ? 1 : 0) != 0);
                    TestCase.assertTrue((!ev.getOperation().isNetLoad() ? 1 : 0) != 0);
                    TestCase.assertTrue((!ev.getOperation().isLoad() ? 1 : 0) != 0);
                    TestCase.assertTrue((!ev.getOperation().isNetSearch() ? 1 : 0) != 0);
                    TestCase.assertTrue((!ev.getOperation().isExpiration() ? 1 : 0) != 0);
                    TestCase.assertEquals(null, (Object)ev.getCallbackArgument());
                    TestCase.assertEquals((boolean)true, (boolean)ev.isCallbackArgumentAvailable());
                    TestCase.assertTrue((boolean)ev.isOriginRemote());
                    TestCase.assertTrue((boolean)ev.getOperation().isDistributed());
                }
            });
            MultiVMRegionTestCase.assertTrue((boolean)rgn.containsKey((Object)"key"));
            MultiVMRegionTestCase.assertTrue((!rgn.containsValueForKey((Object)"key") ? 1 : 0) != 0);
            localTl.assertCounts(4, 0, 0, 0);
            events = localTl.lastEvent.getCreateEvents();
            MultiVMRegionTestCase.assertEquals((Object)myTXId, (Object)localTl.lastEvent.getTransactionId());
            MultiVMRegionTestCase.assertEquals((int)1, (int)events.size());
            ev = (EntryEvent)events.iterator().next();
            MultiVMRegionTestCase.assertEquals((Object)myTXId, (Object)ev.getTransactionId());
            MultiVMRegionTestCase.assertTrue((ev.getRegion() == rgn ? 1 : 0) != 0);
            MultiVMRegionTestCase.assertEquals((Object)"key", (Object)ev.getKey());
            MultiVMRegionTestCase.assertNull((Object)ev.getNewValue());
            MultiVMRegionTestCase.assertNull((Object)ev.getOldValue());
            MultiVMRegionTestCase.assertTrue((!ev.getOperation().isLocalLoad() ? 1 : 0) != 0);
            MultiVMRegionTestCase.assertTrue((!ev.getOperation().isNetLoad() ? 1 : 0) != 0);
            MultiVMRegionTestCase.assertTrue((!ev.getOperation().isLoad() ? 1 : 0) != 0);
            MultiVMRegionTestCase.assertTrue((!ev.getOperation().isNetSearch() ? 1 : 0) != 0);
            MultiVMRegionTestCase.assertEquals(null, (Object)ev.getCallbackArgument());
            MultiVMRegionTestCase.assertEquals((boolean)true, (boolean)ev.isCallbackArgumentAvailable());
            MultiVMRegionTestCase.assertTrue((!ev.isOriginRemote() ? 1 : 0) != 0);
            MultiVMRegionTestCase.assertTrue((!ev.getOperation().isExpiration() ? 1 : 0) != 0);
            MultiVMRegionTestCase.assertTrue((boolean)ev.getOperation().isDistributed());
            rgn.destroy((Object)"key");
            txMgr.begin();
            myTXId = txMgr.getTransactionId();
            rgn.create((Object)"key", (Object)"value1");
            rgn.localInvalidate((Object)"key");
            try {
                rgn.create((Object)"key", (Object)"ex");
                MultiVMRegionTestCase.fail((String)"expected EntryExistsException");
            }
            catch (EntryExistsException events2) {
                // empty catch block
            }
            rgn.put((Object)"key", (Object)"value2");
            MultiVMRegionTestCase.assertTrue((boolean)rgn.containsKey((Object)"key"));
            MultiVMRegionTestCase.assertEquals((Object)"value2", (Object)rgn.getEntry((Object)"key").getValue());
            txMgr.commit();
            MultiVMRegionTestCase.assertTrue((boolean)rgn.containsKey((Object)"key"));
            MultiVMRegionTestCase.assertEquals((Object)"value2", (Object)rgn.getEntry((Object)"key").getValue());
            localTl.assertCounts(5, 0, 0, 0);
            events = localTl.lastEvent.getCreateEvents();
            MultiVMRegionTestCase.assertEquals((Object)myTXId, (Object)localTl.lastEvent.getTransactionId());
            MultiVMRegionTestCase.assertEquals((int)1, (int)events.size());
            ev = (EntryEvent)events.iterator().next();
            MultiVMRegionTestCase.assertEquals((Object)myTXId, (Object)ev.getTransactionId());
            MultiVMRegionTestCase.assertTrue((ev.getRegion() == rgn ? 1 : 0) != 0);
            MultiVMRegionTestCase.assertEquals((Object)"key", (Object)ev.getKey());
            MultiVMRegionTestCase.assertEquals((Object)"value2", (Object)ev.getNewValue());
            MultiVMRegionTestCase.assertNull((Object)ev.getOldValue());
            MultiVMRegionTestCase.assertTrue((!ev.getOperation().isLocalLoad() ? 1 : 0) != 0);
            MultiVMRegionTestCase.assertTrue((!ev.getOperation().isNetLoad() ? 1 : 0) != 0);
            MultiVMRegionTestCase.assertTrue((!ev.getOperation().isLoad() ? 1 : 0) != 0);
            MultiVMRegionTestCase.assertTrue((!ev.getOperation().isNetSearch() ? 1 : 0) != 0);
            MultiVMRegionTestCase.assertEquals(null, (Object)ev.getCallbackArgument());
            MultiVMRegionTestCase.assertEquals((boolean)true, (boolean)ev.isCallbackArgumentAvailable());
            MultiVMRegionTestCase.assertTrue((!ev.isOriginRemote() ? 1 : 0) != 0);
            MultiVMRegionTestCase.assertTrue((!ev.getOperation().isExpiration() ? 1 : 0) != 0);
            MultiVMRegionTestCase.assertTrue((boolean)ev.getOperation().isDistributed());
            rgn.localDestroy((Object)"key");
        }
        catch (Exception e) {
            CacheFactory.getInstance((DistributedSystem)this.getSystem()).close();
            this.getSystem().getLogWriter().fine("testTXAlgebra: Caused exception in createRegion");
            throw e;
        }
    }

    protected RegionAttributes getRegionAttributes(String type) {
        throw new IllegalStateException("subclass must reimplement this method");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void versionTestGIISendsTombstones() throws Exception {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        final int serverPort = AvailablePortHelper.getRandomAvailableTCPPort();
        final String name = this.getUniqueName() + "-CC";
        SerializableRunnable createRegion = new SerializableRunnable("Create Region"){

            @Override
            public void run() {
                try {
                    RegionFactory f = MultiVMRegionTestCase.this.getCache().createRegionFactory(MultiVMRegionTestCase.this.getRegionAttributes());
                    CCRegion = (LocalRegion)f.create(name);
                    if (VM.getCurrentVMNum() == 0) {
                        CacheServer bridge = CCRegion.getCache().addCacheServer();
                        bridge.setPort(serverPort);
                        try {
                            bridge.start();
                        }
                        catch (IOException ex) {
                            DistributedTestCase.fail("While creating bridge", ex);
                        }
                    }
                }
                catch (CacheException ex) {
                    DistributedTestCase.fail("While creating region", ex);
                }
            }
        };
        SerializableRunnable asserter = new SerializableRunnable("ensure tombstone has been received"){

            @Override
            public void run() {
                RegionEntry entry = CCRegion.getRegionEntry((Object)"object2");
                Assert.assertTrue((entry != null ? 1 : 0) != 0);
                Assert.assertTrue((boolean)entry.isTombstone());
            }
        };
        vm0.invoke(createRegion);
        vm0.invoke(new SerializableRunnable("create some tombstones"){

            @Override
            public void run() {
                CCRegion.put((Object)"object1", (Object)"value1");
                CCRegion.put((Object)"object2", (Object)"value2");
                CCRegion.put((Object)"object3", (Object)"value3");
                CCRegion.destroy((Object)"object2");
            }
        });
        try {
            vm0.invoke(asserter);
            vm1.invoke(createRegion);
            vm1.invoke(asserter);
        }
        finally {
            MultiVMRegionTestCase.disconnectAllFromDS();
        }
    }

    protected void disconnect(VM vm) {
        SerializableRunnable disconnect = new SerializableRunnable("disconnect"){

            @Override
            public void run() {
                distributedSystemID = -1;
                CCRegion.getCache().getDistributedSystem().disconnect();
            }
        };
        vm.invoke(disconnect);
    }

    public void versionTestConcurrentEvents() throws Exception {
        String subkey;
        int subi;
        String key;
        int i;
        hub = null;
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        final String name = this.getUniqueName() + "-CC";
        SerializableRunnable createRegion = new SerializableRunnable("Create Region"){

            @Override
            public void run() {
                try {
                    RegionFactory f = MultiVMRegionTestCase.this.getCache().createRegionFactory(MultiVMRegionTestCase.this.getRegionAttributes());
                    CCRegion = (LocalRegion)f.create(name);
                }
                catch (CacheException ex) {
                    DistributedTestCase.fail("While creating region", ex);
                }
            }
        };
        vm0.invoke(createRegion);
        vm1.invoke(createRegion);
        SerializableRunnable performOps = new SerializableRunnable("perform concurrent ops"){

            @Override
            public void run() {
                try {
                    MultiVMRegionTestCase.this.doOpsLoop(5000, false);
                    long events = CCRegion.getCachePerfStats().getConflatedEventsCount();
                    if (!CCRegion.getScope().isGlobal()) {
                        TestCase.assertTrue((String)"expected some event conflation", (events > 0L ? 1 : 0) != 0);
                    }
                }
                catch (CacheException e) {
                    DistributedTestCase.fail("while performing concurrent operations", e);
                }
            }
        };
        AsyncInvocation a0 = vm0.invokeAsync(performOps);
        AsyncInvocation a1 = vm1.invokeAsync(performOps);
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            MultiVMRegionTestCase.fail((String)"sleep was interrupted");
        }
        vm2.invoke(createRegion);
        boolean a0failed = this.waitForAsyncProcessing(a0, "expected some event conflation");
        boolean a1failed = this.waitForAsyncProcessing(a1, "expected some event conflation");
        if (a0failed && a1failed) {
            MultiVMRegionTestCase.fail((String)("neither member saw event conflation - check stats for " + name));
        }
        Map r0Contents = (Map)vm0.invoke(this.getClass(), "getCCRegionContents");
        Map r1Contents = (Map)vm1.invoke(this.getClass(), "getCCRegionContents");
        Map r2Contents = (Map)vm2.invoke(this.getClass(), "getCCRegionContents");
        for (i = 0; i < 10; ++i) {
            key = "cckey" + i;
            MultiVMRegionTestCase.assertEquals((String)("region contents are not consistent for " + key), r0Contents.get(key), r1Contents.get(key));
            MultiVMRegionTestCase.assertEquals((String)("region contents are not consistent for " + key), r1Contents.get(key), r2Contents.get(key));
            for (subi = 1; subi < 3; ++subi) {
                subkey = key + "-" + subi;
                if (r0Contents.containsKey(subkey)) {
                    MultiVMRegionTestCase.assertEquals((String)("region contents are not consistent for " + subkey), r0Contents.get(subkey), r1Contents.get(subkey));
                    MultiVMRegionTestCase.assertEquals((String)("region contents are not consistent for " + subkey), r1Contents.get(subkey), r2Contents.get(subkey));
                    continue;
                }
                MultiVMRegionTestCase.assertTrue((!r1Contents.containsKey(subkey) ? 1 : 0) != 0);
            }
        }
        if (!this.getRegionAttributes().getScope().isDistributedNoAck()) {
            VersionTag tag;
            vm0.invoke(this.getClass(), "clearCCRegion");
            performOps = new SerializableRunnable("perform concurrent delta ops"){

                @Override
                public void run() {
                    try {
                        long stopTime = System.currentTimeMillis() + 5000L;
                        Random ran = new Random(System.currentTimeMillis());
                        while (System.currentTimeMillis() < stopTime) {
                            for (int i = 0; i < 10; ++i) {
                                CCRegion.put((Object)("cckey" + i), (Object)new DeltaValue("ccvalue" + ran.nextInt()));
                            }
                        }
                        long events = CCRegion.getCachePerfStats().getDeltaFailedUpdates();
                        TestCase.assertTrue((String)"expected some failed deltas", (events > 0L ? 1 : 0) != 0);
                    }
                    catch (CacheException e) {
                        DistributedTestCase.fail("while performing concurrent operations", e);
                    }
                }
            };
            a0 = vm0.invokeAsync(performOps);
            a1 = vm1.invokeAsync(performOps);
            a0failed = this.waitForAsyncProcessing(a0, "expected some failed deltas");
            a1failed = this.waitForAsyncProcessing(a1, "expected some failed deltas");
            if (a0failed && a1failed) {
                MultiVMRegionTestCase.fail((String)("neither member saw failed deltas - check stats for " + name));
            }
            r0Contents = (Map)vm0.invoke(this.getClass(), "getCCRegionContents");
            r1Contents = (Map)vm1.invoke(this.getClass(), "getCCRegionContents");
            r2Contents = (Map)vm2.invoke(this.getClass(), "getCCRegionContents");
            for (i = 0; i < 10; ++i) {
                key = "cckey" + i;
                MultiVMRegionTestCase.assertEquals((String)"region contents are not consistent", r0Contents.get(key), r1Contents.get(key));
                MultiVMRegionTestCase.assertEquals((String)"region contents are not consistent", r1Contents.get(key), r2Contents.get(key));
                for (subi = 1; subi < 3; ++subi) {
                    subkey = key + "-" + subi;
                    if (r0Contents.containsKey(subkey)) {
                        MultiVMRegionTestCase.assertEquals((String)"region contents are not consistent", r0Contents.get(subkey), r1Contents.get(subkey));
                        MultiVMRegionTestCase.assertEquals((String)"region contents are not consistent", r1Contents.get(subkey), r2Contents.get(subkey));
                        continue;
                    }
                    MultiVMRegionTestCase.assertTrue((!r1Contents.containsKey(subkey) ? 1 : 0) != 0);
                }
            }
            InternalDistributedMember vm0Id = (InternalDistributedMember)vm0.invoke(this.getClass(), "getMemberId");
            InternalDistributedMember vm1Id = (InternalDistributedMember)vm1.invoke(this.getClass(), "getMemberId");
            InternalDistributedMember vm2Id = (InternalDistributedMember)vm2.invoke(this.getClass(), "getMemberId");
            long start = System.currentTimeMillis();
            RegionVersionVector vm0vv = this.getVersionVector(vm0);
            long end = System.currentTimeMillis();
            MultiVMRegionTestCase.getLogWriter().info("version vector transmission took " + (end - start) + " ms");
            MultiVMRegionTestCase.getLogWriter().info("vm0 vector = " + vm0vv);
            RegionVersionVector vm1vv = this.getVersionVector(vm1);
            MultiVMRegionTestCase.getLogWriter().info("vm1 vector = " + vm1vv);
            RegionVersionVector vm2vv = this.getVersionVector(vm2);
            MultiVMRegionTestCase.getLogWriter().info("vm2 vector = " + vm2vv);
            Map vm0Versions = (Map)vm0.invoke(this.getClass(), "getCCRegionVersions");
            Map vm1Versions = (Map)vm1.invoke(this.getClass(), "getCCRegionVersions");
            Map vm2Versions = (Map)vm2.invoke(this.getClass(), "getCCRegionVersions");
            for (Map.Entry entry : vm0Versions.entrySet()) {
                tag = (VersionTag)entry.getValue();
                tag.replaceNullIDs((VersionSource)vm0Id);
                MultiVMRegionTestCase.assertTrue((String)(vm0Id + " should contain " + tag), (boolean)vm0vv.contains(tag.getMemberID(), tag.getRegionVersion()));
                MultiVMRegionTestCase.assertTrue((String)(vm1Id + " should contain " + tag), (boolean)vm1vv.contains(tag.getMemberID(), tag.getRegionVersion()));
                MultiVMRegionTestCase.assertTrue((String)(vm2Id + " should contain " + tag), (boolean)vm2vv.contains(tag.getMemberID(), tag.getRegionVersion()));
            }
            for (Map.Entry entry : vm1Versions.entrySet()) {
                tag = (VersionTag)entry.getValue();
                tag.replaceNullIDs((VersionSource)vm1Id);
                MultiVMRegionTestCase.assertTrue((String)(vm0Id + " should contain " + tag), (boolean)vm0vv.contains(tag.getMemberID(), tag.getRegionVersion()));
                MultiVMRegionTestCase.assertTrue((String)(vm1Id + " should contain " + tag), (boolean)vm1vv.contains(tag.getMemberID(), tag.getRegionVersion()));
                MultiVMRegionTestCase.assertTrue((String)(vm2Id + " should contain " + tag), (boolean)vm2vv.contains(tag.getMemberID(), tag.getRegionVersion()));
            }
            for (Map.Entry entry : vm2Versions.entrySet()) {
                tag = (VersionTag)entry.getValue();
                tag.replaceNullIDs((VersionSource)vm2Id);
                MultiVMRegionTestCase.assertTrue((String)(vm0Id + " should contain " + tag), (boolean)vm0vv.contains(tag.getMemberID(), tag.getRegionVersion()));
                MultiVMRegionTestCase.assertTrue((String)(vm1Id + " should contain " + tag), (boolean)vm1vv.contains(tag.getMemberID(), tag.getRegionVersion()));
                MultiVMRegionTestCase.assertTrue((String)(vm2Id + " should contain " + tag), (boolean)vm2vv.contains(tag.getMemberID(), tag.getRegionVersion()));
            }
        }
    }

    private RegionVersionVector getVersionVector(VM vm) throws Exception {
        byte[] serializedForm = (byte[])vm.invoke(this.getClass(), "getCCRegionVersionVector");
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(serializedForm));
        return (RegionVersionVector)DataSerializer.readObject((DataInput)dis);
    }

    private boolean notEqual(Object o1, Object o2) {
        if (o1 == null) {
            return o2 != null;
        }
        if (o2 == null) {
            return true;
        }
        return !o1.equals(o2);
    }

    protected AsyncInvocation performOps4ClearWithConcurrentEvents(VM vm, final int opNum) {
        SerializableRunnable performOps = new SerializableRunnable("perform concurrent ops"){

            @Override
            public void run() {
                try {
                    boolean includeClear = true;
                    MultiVMRegionTestCase.this.doOpsLoop(opNum, includeClear);
                }
                catch (CacheException e) {
                    DistributedTestCase.fail("while performing concurrent operations", e);
                }
            }
        };
        return vm.invokeAsync(performOps);
    }

    protected void createRegionWithAttribute(VM vm, final String name, final boolean syncDiskWrite) {
        SerializableRunnable createRegion = new SerializableRunnable("Create Region"){

            @Override
            public void run() {
                try {
                    RegionFactory f = MultiVMRegionTestCase.this.getCache().createRegionFactory(MultiVMRegionTestCase.this.getRegionAttributes());
                    f.setDiskSynchronous(syncDiskWrite);
                    CCRegion = (LocalRegion)f.create(name);
                }
                catch (CacheException ex) {
                    DistributedTestCase.fail("While creating region", ex);
                }
            }
        };
        vm.invoke(createRegion);
    }

    public void versionTestClearWithConcurrentEvents() throws Exception {
        this.z_versionTestClearWithConcurrentEvents(true);
    }

    public void versionTestClearWithConcurrentEventsAsync() throws Exception {
        this.z_versionTestClearWithConcurrentEvents(false);
    }

    protected void z_versionTestClearWithConcurrentEvents(boolean syncDiskWrite) throws Exception {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        String name = this.getUniqueName() + "-CC";
        this.createRegionWithAttribute(vm0, name, syncDiskWrite);
        this.createRegionWithAttribute(vm1, name, syncDiskWrite);
        AsyncInvocation a0 = this.performOps4ClearWithConcurrentEvents(vm0, 5000);
        AsyncInvocation a1 = this.performOps4ClearWithConcurrentEvents(vm1, 5000);
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            MultiVMRegionTestCase.fail((String)"sleep was interrupted");
        }
        this.createRegionWithAttribute(vm2, name, syncDiskWrite);
        this.waitForAsyncProcessing(a0, "");
        this.waitForAsyncProcessing(a1, "");
        Map r0Contents = (Map)vm0.invoke(this.getClass(), "getCCRegionContents");
        Map r1Contents = (Map)vm1.invoke(this.getClass(), "getCCRegionContents");
        Map r2Contents = (Map)vm2.invoke(this.getClass(), "getCCRegionContents");
        for (int i = 0; i < 10; ++i) {
            String key = "cckey" + i;
            MultiVMRegionTestCase.assertEquals((String)"region contents are not consistent", r0Contents.get(key), r1Contents.get(key));
            MultiVMRegionTestCase.assertEquals((String)"region contents are not consistent", r1Contents.get(key), r2Contents.get(key));
            for (int subi = 1; subi < 3; ++subi) {
                String subkey = key + "-" + subi;
                if (r0Contents.containsKey(subkey)) {
                    MultiVMRegionTestCase.assertEquals((String)"region contents are not consistent", r0Contents.get(subkey), r1Contents.get(subkey));
                    MultiVMRegionTestCase.assertEquals((String)"region contents are not consistent", r1Contents.get(subkey), r2Contents.get(subkey));
                    continue;
                }
                MultiVMRegionTestCase.assertTrue((String)("expected containsKey(" + subkey + ") to return false"), (!r1Contents.containsKey(subkey) ? 1 : 0) != 0);
            }
        }
        vm0.invoke(this.getClass(), "assertNoClearTimeouts");
        vm1.invoke(this.getClass(), "assertNoClearTimeouts");
        vm2.invoke(this.getClass(), "assertNoClearTimeouts");
    }

    public void versionTestClearOnNonReplicateWithConcurrentEvents() throws Exception {
        if (!"bruces".equals(System.getProperty("user.name"))) {
            return;
        }
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        final String name = this.getUniqueName() + "-CC";
        SerializableRunnable createRegion = new SerializableRunnable("Create Region"){

            @Override
            public void run() {
                try {
                    RegionFactory f = null;
                    if (VM.getCurrentVMNum() == 0) {
                        f = MultiVMRegionTestCase.this.getCache().createRegionFactory(MultiVMRegionTestCase.this.getRegionAttributes(RegionShortcut.REPLICATE_PROXY.toString()));
                    } else if (VM.getCurrentVMNum() == 1) {
                        f = MultiVMRegionTestCase.this.getCache().createRegionFactory(MultiVMRegionTestCase.this.getRegionAttributes());
                        f.setDataPolicy(DataPolicy.NORMAL);
                    } else {
                        f = MultiVMRegionTestCase.this.getCache().createRegionFactory(MultiVMRegionTestCase.this.getRegionAttributes());
                    }
                    CCRegion = (LocalRegion)f.create(name);
                }
                catch (CacheException ex) {
                    DistributedTestCase.fail("While creating region", ex);
                }
            }
        };
        vm0.invoke(createRegion);
        vm1.invoke(createRegion);
        vm2.invoke(createRegion);
        vm3.invoke(createRegion);
        SerializableRunnable performOps = new SerializableRunnable("perform concurrent ops"){

            @Override
            public void run() {
                try {
                    MultiVMRegionTestCase.this.doOpsLoop(5000, true);
                }
                catch (CacheException e) {
                    DistributedTestCase.fail("while performing concurrent operations", e);
                }
                if (CCRegion.getScope().isDistributedNoAck()) {
                    MultiVMRegionTestCase.this.sendSerialMessageToAll();
                }
            }
        };
        AsyncInvocation a0 = vm0.invokeAsync(performOps);
        AsyncInvocation a1 = vm1.invokeAsync(performOps);
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            MultiVMRegionTestCase.fail((String)"sleep was interrupted");
        }
        this.waitForAsyncProcessing(a0, "");
        this.waitForAsyncProcessing(a1, "");
        Map r1Contents = (Map)vm1.invoke(this.getClass(), "getCCRegionContents");
        Map r2Contents = (Map)vm2.invoke(this.getClass(), "getCCRegionContents");
        Map r3Contents = (Map)vm3.invoke(this.getClass(), "getCCRegionContents");
        for (int i = 0; i < 10; ++i) {
            String key = "cckey" + i;
            MultiVMRegionTestCase.assertEquals((String)("region contents are not consistent for " + key), r2Contents.get(key), r3Contents.get(key));
            for (int subi = 1; subi < 3; ++subi) {
                String subkey = key + "-" + subi;
                if (!r2Contents.containsKey(subkey)) continue;
                MultiVMRegionTestCase.assertEquals((String)("region contents are not consistent for " + subkey), r2Contents.get(subkey), r3Contents.get(subkey));
            }
        }
        vm1.invoke(this.getClass(), "assertNoClearTimeouts");
        vm2.invoke(this.getClass(), "assertNoClearTimeouts");
        vm3.invoke(this.getClass(), "assertNoClearTimeouts");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void versionTestTombstones() {
        MultiVMRegionTestCase.disconnectAllFromDS();
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        int numEntries = 1000;
        long oldServerTimeout = TombstoneService.REPLICATED_TOMBSTONE_TIMEOUT;
        long oldClientTimeout = TombstoneService.CLIENT_TOMBSTONE_TIMEOUT;
        long oldExpiredTombstoneLimit = TombstoneService.EXPIRED_TOMBSTONE_LIMIT;
        boolean oldIdleExpiration = TombstoneService.IDLE_EXPIRATION;
        try {
            SerializableRunnable setTimeout = new SerializableRunnable(){

                @Override
                public void run() {
                    TombstoneService.REPLICATED_TOMBSTONE_TIMEOUT = 20000L;
                    TombstoneService.CLIENT_TOMBSTONE_TIMEOUT = 19000L;
                    TombstoneService.EXPIRED_TOMBSTONE_LIMIT = 1000L;
                    TombstoneService.IDLE_EXPIRATION = true;
                }
            };
            vm0.invoke(setTimeout);
            vm1.invoke(setTimeout);
            final String name = this.getUniqueName() + "-CC";
            SerializableRunnable createRegion = new SerializableRunnable("Create Region"){

                @Override
                public void run() {
                    try {
                        RegionFactory f = MultiVMRegionTestCase.this.getCache().createRegionFactory(MultiVMRegionTestCase.this.getRegionAttributes());
                        CCRegion = (LocalRegion)f.create(name);
                        for (int i = 0; i < 1000; ++i) {
                            CCRegion.put((Object)("cckey" + i), (Object)"ccvalue");
                        }
                        if (CCRegion.getScope().isDistributedNoAck()) {
                            MultiVMRegionTestCase.this.sendSerialMessageToAll();
                        }
                    }
                    catch (CacheException ex) {
                        DistributedTestCase.fail("While creating region", ex);
                    }
                }
            };
            vm0.invoke(createRegion);
            vm1.invoke(createRegion);
            vm0.invoke(new SerializableRunnable("destroy entries and check tombstone count"){

                @Override
                public void run() {
                    try {
                        for (int i = 0; i < 1000; ++i) {
                            CCRegion.destroy((Object)("cckey" + i));
                            TestCase.assertTrue((String)"entry should not exist", (!CCRegion.containsKey((Object)("cckey" + i)) ? 1 : 0) != 0);
                            TestCase.assertTrue((String)"entry should not contain a value", (!CCRegion.containsValueForKey((Object)("cckey" + i)) ? 1 : 0) != 0);
                        }
                        long count = CCRegion.getTombstoneCount();
                        TestCase.assertEquals((String)"expected 1000 tombstones", (long)1000L, (long)count);
                        TestCase.assertTrue((String)"region should not contain a tombstone", (!CCRegion.containsValue((Object)Token.TOMBSTONE) ? 1 : 0) != 0);
                        if (CCRegion.getScope().isDistributedNoAck()) {
                            MultiVMRegionTestCase.this.sendSerialMessageToAll();
                        }
                    }
                    catch (CacheException e) {
                        DistributedTestCase.fail("while performing destroy operations", e);
                    }
                }
            });
            vm1.invoke(new SerializableRunnable("check tombstone count(2)"){

                @Override
                public void run() {
                    final long count = CCRegion.getTombstoneCount();
                    TestCase.assertEquals((String)"expected 1000 tombstones", (long)1000L, (long)count);
                    DistributedTestCase.WaitCriterion waitForExpiration = new DistributedTestCase.WaitCriterion(){

                        @Override
                        public boolean done() {
                            return CCRegion.getTombstoneCount() == 0;
                        }

                        @Override
                        public String description() {
                            return "Waiting for all tombstones to expire.  There are now " + CCRegion.getTombstoneCount() + " tombstones left out of " + count + " initial tombstones";
                        }
                    };
                    DistributedTestCase.waitForCriterion(waitForExpiration, TombstoneService.REPLICATED_TOMBSTONE_TIMEOUT + 10000L, 1000L, true);
                }
            });
            vm0.invoke(new SerializableRunnable("create/destroy entries and check tombstone count"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    long count;
                    double oldLimit = TombstoneService.GC_MEMORY_THRESHOLD;
                    final long origCount = count = (long)CCRegion.getTombstoneCount();
                    try {
                        TombstoneService.GC_MEMORY_THRESHOLD = 0.0;
                        DistributedTestCase.WaitCriterion waitForExpiration = new DistributedTestCase.WaitCriterion(){

                            @Override
                            public boolean done() {
                                return CCRegion.getTombstoneCount() == 0;
                            }

                            @Override
                            public String description() {
                                return "Waiting for all tombstones to expire.  There are now " + CCRegion.getTombstoneCount() + " tombstones left out of " + origCount + " initial tombstones";
                            }
                        };
                        DistributedTestCase.waitForCriterion(waitForExpiration, TombstoneService.REPLICATED_TOMBSTONE_TIMEOUT + 10000L, 1000L, true);
                        for (int i = 0; i < 1000; ++i) {
                            CCRegion.getLogWriterI18n().fine("SWAP:doing create tombstone:" + CCRegion.getTombstoneCount());
                            CCRegion.create((Object)("cckey" + i), (Object)i);
                            CCRegion.getLogWriterI18n().fine("SWAP:doing destroy");
                            CCRegion.destroy((Object)("cckey" + i));
                        }
                        count = CCRegion.getTombstoneCount();
                        TestCase.assertEquals((String)"expected 1000 tombstones", (long)1000L, (long)count);
                        TestCase.assertEquals((int)0, (int)CCRegion.size());
                        afterCreates = 0;
                        AttributesMutator m = CCRegion.getAttributesMutator();
                        m.addCacheListener((CacheListener)new CacheListenerAdapter(){

                            public void afterCreate(EntryEvent event) {
                                ++afterCreates;
                            }
                        });
                        if (CCRegion.getScope().isDistributedNoAck()) {
                            MultiVMRegionTestCase.this.sendSerialMessageToAll();
                        }
                    }
                    catch (CacheException e) {
                        DistributedTestCase.fail("while performing create/destroy operations", e);
                    }
                    finally {
                        TombstoneService.GC_MEMORY_THRESHOLD = oldLimit;
                    }
                }
            });
            vm1.invoke(new SerializableRunnable("check tombstone count and install listener"){

                @Override
                public void run() {
                    long count = CCRegion.getTombstoneCount();
                    TestCase.assertEquals((String)"expected ten tombstones", (long)1000L, (long)count);
                    afterCreates = 0;
                    AttributesMutator m = CCRegion.getAttributesMutator();
                    m.addCacheListener((CacheListener)new CacheListenerAdapter(){

                        public void afterCreate(EntryEvent event) {
                            ++afterCreates;
                        }
                    });
                }
            });
            vm0.invoke(new SerializableRunnable("create entries and check afterCreate and tombstone count"){

                @Override
                public void run() {
                    try {
                        for (int i = 0; i < 1000; ++i) {
                            CCRegion.create((Object)("cckey" + i), (Object)i);
                        }
                        long count = CCRegion.getTombstoneCount();
                        TestCase.assertEquals((String)"expected zero tombstones", (long)0L, (long)count);
                        TestCase.assertEquals((String)"expected 1000 afterCreates", (int)1000, (int)afterCreates);
                        TestCase.assertEquals((int)1000, (int)CCRegion.size());
                        if (CCRegion.getScope().isDistributedNoAck()) {
                            MultiVMRegionTestCase.this.sendSerialMessageToAll();
                        }
                    }
                    catch (CacheException e) {
                        DistributedTestCase.fail("while performing create operations", e);
                    }
                }
            });
            vm1.invoke(new SerializableRunnable("check afterCreate and tombstone count"){

                @Override
                public void run() {
                    long count = CCRegion.getTombstoneCount();
                    TestCase.assertEquals((String)"expected zero tombstones", (long)0L, (long)count);
                    TestCase.assertEquals((String)"expected 1000 afterCreates", (int)1000, (int)afterCreates);
                    TestCase.assertEquals((int)1000, (int)CCRegion.size());
                    try {
                        Thread.sleep(TombstoneService.REPLICATED_TOMBSTONE_TIMEOUT + 5000L);
                    }
                    catch (InterruptedException e) {
                        TestCase.fail((String)"sleep was interrupted");
                    }
                    count = CCRegion.getTombstoneCount();
                    TestCase.assertEquals((String)"expected zero tombstones", (long)0L, (long)count);
                    TestCase.assertEquals((int)1000, (int)CCRegion.size());
                }
            });
            vm0.invoke(new SerializableRunnable("check region size and tombstone count"){

                @Override
                public void run() {
                    long count = CCRegion.getTombstoneCount();
                    TestCase.assertEquals((String)"expected all tombstones to be expired", (long)0L, (long)count);
                    TestCase.assertEquals((int)1000, (int)CCRegion.size());
                }
            });
        }
        catch (Throwable throwable) {
            SerializableRunnable resetTimeout = new SerializableRunnable(oldServerTimeout, oldClientTimeout, oldExpiredTombstoneLimit, oldIdleExpiration){
                final /* synthetic */ long val$oldServerTimeout;
                final /* synthetic */ long val$oldClientTimeout;
                final /* synthetic */ long val$oldExpiredTombstoneLimit;
                final /* synthetic */ boolean val$oldIdleExpiration;
                {
                    this.val$oldServerTimeout = l;
                    this.val$oldClientTimeout = l2;
                    this.val$oldExpiredTombstoneLimit = l3;
                    this.val$oldIdleExpiration = bl;
                }

                @Override
                public void run() {
                    TombstoneService.REPLICATED_TOMBSTONE_TIMEOUT = this.val$oldServerTimeout;
                    TombstoneService.CLIENT_TOMBSTONE_TIMEOUT = this.val$oldClientTimeout;
                    TombstoneService.EXPIRED_TOMBSTONE_LIMIT = this.val$oldExpiredTombstoneLimit;
                    TombstoneService.IDLE_EXPIRATION = this.val$oldIdleExpiration;
                }
            };
            vm0.invoke(resetTimeout);
            vm1.invoke(resetTimeout);
            throw throwable;
        }
        SerializableRunnable resetTimeout = new /* invalid duplicate definition of identical inner class */;
        vm0.invoke(resetTimeout);
        vm1.invoke(resetTimeout);
    }

    public void versionTestConcurrentEventsOnEmptyRegion() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        final String name = this.getUniqueName() + "-CC";
        SerializableRunnable createRegion = new SerializableRunnable("Create Region"){

            @Override
            public void run() {
                try {
                    RegionFactory f = VM.getCurrentVMNum() == 0 ? MultiVMRegionTestCase.this.getCache().createRegionFactory(MultiVMRegionTestCase.this.getRegionAttributes(RegionShortcut.REPLICATE_PROXY.toString())) : MultiVMRegionTestCase.this.getCache().createRegionFactory(MultiVMRegionTestCase.this.getRegionAttributes());
                    CCRegion = (LocalRegion)f.create(name);
                }
                catch (CacheException ex) {
                    DistributedTestCase.fail("While creating region", ex);
                }
            }
        };
        vm0.invoke(createRegion);
        vm1.invoke(createRegion);
        vm3.invoke(createRegion);
        SerializableRunnable performOps = new SerializableRunnable("perform concurrent ops"){

            @Override
            public void run() {
                try {
                    MultiVMRegionTestCase.this.doOpsLoop(5000, false);
                    MultiVMRegionTestCase.this.sendSerialMessageToAll();
                    if (CCRegion.getAttributes().getDataPolicy().withReplication()) {
                        long events = CCRegion.getCachePerfStats().getConflatedEventsCount();
                        TestCase.assertTrue((String)"expected some event conflation", (events > 0L ? 1 : 0) != 0);
                    }
                }
                catch (CacheException e) {
                    DistributedTestCase.fail("while performing concurrent operations", e);
                }
            }
        };
        AsyncInvocation a0 = vm0.invokeAsync(performOps);
        AsyncInvocation a1 = vm1.invokeAsync(performOps);
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            MultiVMRegionTestCase.fail((String)"sleep was interrupted");
        }
        vm2.invoke(createRegion);
        boolean a0failed = this.waitForAsyncProcessing(a0, "expected some event conflation");
        boolean a1failed = this.waitForAsyncProcessing(a1, "expected some event conflation");
        if (a0failed && a1failed) {
            MultiVMRegionTestCase.fail((String)("neither member saw event conflation - check stats for " + name));
        }
        Map r1Contents = (Map)vm1.invoke(this.getClass(), "getCCRegionContents");
        Map r2Contents = (Map)vm2.invoke(this.getClass(), "getCCRegionContents");
        Map r3Contents = (Map)vm3.invoke(this.getClass(), "getCCRegionContents");
        for (int i = 0; i < 10; ++i) {
            String key = "cckey" + i;
            MultiVMRegionTestCase.assertEquals((String)("region contents are not consistent for " + key), r1Contents.get(key), r2Contents.get(key));
            MultiVMRegionTestCase.assertEquals((String)("region contents are not consistent for " + key), r2Contents.get(key), r3Contents.get(key));
            for (int subi = 1; subi < 3; ++subi) {
                String subkey = key + "-" + subi;
                if (r1Contents.containsKey(subkey)) {
                    MultiVMRegionTestCase.assertEquals((String)("region contents are not consistent for " + subkey), r1Contents.get(subkey), r2Contents.get(subkey));
                    MultiVMRegionTestCase.assertEquals((String)("region contents are not consistent for " + subkey), r2Contents.get(subkey), r3Contents.get(subkey));
                    continue;
                }
                MultiVMRegionTestCase.assertTrue((!r2Contents.containsKey(subkey) ? 1 : 0) != 0);
                MultiVMRegionTestCase.assertTrue((!r3Contents.containsKey(subkey) ? 1 : 0) != 0);
            }
        }
    }

    void doOpsLoop(int runTimeMs, boolean includeClear) {
        MultiVMRegionTestCase.doOpsLoopNoFlush(runTimeMs, includeClear, true);
        if (CCRegion.getScope().isDistributedNoAck()) {
            this.sendSerialMessageToAll();
        }
    }

    public static void doOpsLoopNoFlush(int runTimeMs, boolean includeClear, boolean includePutAll) {
        long stopTime = System.currentTimeMillis() + (long)runTimeMs;
        Random ran = new Random(System.currentTimeMillis());
        String key = null;
        String value = null;
        String oldkey = null;
        String oldvalue = null;
        while (System.currentTimeMillis() < stopTime) {
            for (int i = 0; i < 10; ++i) {
                oldkey = key;
                oldvalue = value;
                int v = ran.nextInt();
                key = "cckey" + i;
                value = "ccvalue" + v;
                try {
                    switch (v & 7) {
                        case 0: {
                            CCRegion.put((Object)key, (Object)value);
                            break;
                        }
                        case 1: {
                            if (CCRegion.getAttributes().getDataPolicy().withReplication()) {
                                if (oldkey == null) break;
                                CCRegion.replace((Object)oldkey, (Object)oldvalue, (Object)value);
                                break;
                            }
                        }
                        case 2: {
                            v = ran.nextInt();
                            if (includePutAll && (v & 7) < 3) {
                                HashMap<String, String> map = new HashMap<String, String>();
                                map.put(key, value);
                                map.put(key + "-1", value);
                                map.put(key + "-2", value);
                                CCRegion.putAll(map);
                                break;
                            }
                            CCRegion.put((Object)key, (Object)value);
                            break;
                        }
                        case 3: {
                            if (CCRegion.getAttributes().getDataPolicy().withReplication()) {
                                if (oldkey == null) break;
                                CCRegion.remove((Object)oldkey, (Object)oldvalue);
                                break;
                            }
                        }
                        case 4: {
                            CCRegion.destroy((Object)key);
                            break;
                        }
                        case 5: {
                            if (includeClear) {
                                CCRegion.clear();
                                break;
                            }
                            if (CCRegion.getAttributes().getDataPolicy().withReplication()) {
                                if (oldkey == null) break;
                                CCRegion.putIfAbsent((Object)oldkey, (Object)value);
                                break;
                            }
                        }
                        case 6: {
                            CCRegion.invalidate((Object)key);
                        }
                    }
                    continue;
                }
                catch (EntryNotFoundException entryNotFoundException) {
                    // empty catch block
                }
            }
        }
    }

    public void versionTestConcurrentEventsOnNonReplicatedRegion() {
        Host host = Host.getHost(0);
        VM vm0 = host.getVM(0);
        VM vm1 = host.getVM(1);
        VM vm2 = host.getVM(2);
        VM vm3 = host.getVM(3);
        final boolean noAck = !this.getRegionAttributes().getScope().isAck();
        final String name = this.getUniqueName() + "-CC";
        SerializableRunnable createRegion = new SerializableRunnable("Create Region"){

            @Override
            public void run() {
                try {
                    RegionFactory f;
                    if (VM.getCurrentVMNum() == 0) {
                        f = MultiVMRegionTestCase.this.getCache().createRegionFactory(MultiVMRegionTestCase.this.getRegionAttributes(RegionShortcut.LOCAL.toString()));
                        f.setScope(MultiVMRegionTestCase.this.getRegionAttributes().getScope());
                    } else {
                        f = MultiVMRegionTestCase.this.getCache().createRegionFactory(MultiVMRegionTestCase.this.getRegionAttributes());
                    }
                    CCRegion = (LocalRegion)f.create(name);
                }
                catch (CacheException ex) {
                    DistributedTestCase.fail("While creating region", ex);
                }
            }
        };
        vm0.invoke(createRegion);
        vm1.invoke(createRegion);
        vm3.invoke(createRegion);
        SerializableRunnable performOps = new SerializableRunnable("perform concurrent ops"){

            @Override
            public void run() {
                try {
                    MultiVMRegionTestCase.this.doOpsLoop(5000, false);
                    MultiVMRegionTestCase.this.sendSerialMessageToAll();
                    if (CCRegion.getAttributes().getDataPolicy().withReplication()) {
                        long events = CCRegion.getCachePerfStats().getConflatedEventsCount();
                        TestCase.assertTrue((String)"expected some event conflation", (events > 0L ? 1 : 0) != 0);
                    }
                }
                catch (CacheException e) {
                    DistributedTestCase.fail("while performing concurrent operations", e);
                }
            }
        };
        AsyncInvocation a0 = vm0.invokeAsync(performOps);
        AsyncInvocation a1 = vm1.invokeAsync(performOps);
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            MultiVMRegionTestCase.fail((String)"sleep was interrupted");
        }
        vm2.invoke(createRegion);
        boolean a0failed = this.waitForAsyncProcessing(a0, "expected some event conflation");
        boolean a1failed = this.waitForAsyncProcessing(a1, "expected some event conflation");
        if (a0failed && a1failed) {
            MultiVMRegionTestCase.fail((String)("neither member saw event conflation - check stats for " + name));
        }
        Map r0Contents = (Map)vm0.invoke(this.getClass(), "getCCRegionContents");
        Map r1Contents = (Map)vm1.invoke(this.getClass(), "getCCRegionContents");
        Map r2Contents = (Map)vm2.invoke(this.getClass(), "getCCRegionContents");
        Map r3Contents = (Map)vm3.invoke(this.getClass(), "getCCRegionContents");
        for (int i = 0; i < 10; ++i) {
            String key = "cckey" + i;
            MultiVMRegionTestCase.assertEquals((String)"region contents are not consistent", r1Contents.get(key), r2Contents.get(key));
            MultiVMRegionTestCase.assertEquals((String)"region contents are not consistent", r2Contents.get(key), r3Contents.get(key));
            for (int subi = 1; subi < 3; ++subi) {
                String subkey = key + "-" + subi;
                if (r1Contents.containsKey(subkey)) {
                    MultiVMRegionTestCase.assertEquals((String)"region contents are not consistent", r1Contents.get(subkey), r2Contents.get(subkey));
                    MultiVMRegionTestCase.assertEquals((String)"region contents are not consistent", r2Contents.get(subkey), r3Contents.get(subkey));
                    if (!r0Contents.containsKey(subkey)) continue;
                    MultiVMRegionTestCase.assertEquals((String)"region contents are not consistent", r1Contents.get(subkey), r0Contents.get(subkey));
                    continue;
                }
                MultiVMRegionTestCase.assertTrue((!r2Contents.containsKey(subkey) ? 1 : 0) != 0);
                MultiVMRegionTestCase.assertTrue((!r3Contents.containsKey(subkey) ? 1 : 0) != 0);
                MultiVMRegionTestCase.assertTrue((!r0Contents.containsKey(subkey) ? 1 : 0) != 0);
            }
        }
        String loadKey = "loadKey";
        vm0.invoke(new SerializableRunnable("add cache loader and create destroyed entry"){

            @Override
            public void run() {
                CCRegion.getAttributesMutator().setCacheLoader(new CacheLoader(){

                    public void close() {
                    }

                    public Object load(LoaderHelper helper) throws CacheLoaderException {
                        DistributedTestCase.getLogWriter().info("The test CacheLoader has been invoked for key '" + helper.getKey() + "'");
                        return "loadedValue";
                    }
                });
                CCRegion.put((Object)"loadKey", (Object)"willbeLoadedInitialValue");
                CCRegion.destroy((Object)"loadKey");
                if (noAck) {
                    MultiVMRegionTestCase.this.sendSerialMessageToAll();
                }
            }
        });
        vm1.invoke(new SerializableRunnable("confirm tombstone"){

            @Override
            public void run() {
                TestCase.assertTrue((Token.TOMBSTONE == CCRegion.getRegionEntry((Object)"loadKey").getValueInVM((RegionEntryContext)CCRegion) ? 1 : 0) != 0);
            }
        });
        vm0.invoke(new SerializableRunnable("use cache loader"){

            @Override
            public void run() {
                TestCase.assertEquals((Object)"loadedValue", (Object)CCRegion.get((Object)"loadKey"));
                TestCase.assertEquals((int)3, (int)CCRegion.getRegionEntry((Object)"loadKey").getVersionStamp().getEntryVersion());
            }
        });
        if (!noAck) {
            vm1.invoke(new SerializableRunnable("verify version number"){

                @Override
                public void run() {
                    TestCase.assertEquals((Object)"loadedValue", (Object)CCRegion.get((Object)"loadKey"));
                    TestCase.assertEquals((int)3, (int)CCRegion.getRegionEntry((Object)"loadKey").getVersionStamp().getEntryVersion());
                }
            });
        }
    }

    public void versionTestGetAllWithVersions() {
        VM vm0 = Host.getHost(0).getVM(0);
        VM vm1 = Host.getHost(0).getVM(1);
        final String regionName = this.getUniqueName() + "CCRegion";
        SerializableRunnable createRegion = new SerializableRunnable("Create Region"){

            @Override
            public void run() {
                try {
                    RegionFactory f;
                    if (VM.getCurrentVMNum() == 0) {
                        f = MultiVMRegionTestCase.this.getCache().createRegionFactory(MultiVMRegionTestCase.this.getRegionAttributes(RegionShortcut.LOCAL.toString()));
                        f.setScope(MultiVMRegionTestCase.this.getRegionAttributes().getScope());
                    } else {
                        f = MultiVMRegionTestCase.this.getCache().createRegionFactory(MultiVMRegionTestCase.this.getRegionAttributes());
                    }
                    CCRegion = (LocalRegion)f.create(regionName);
                }
                catch (CacheException ex) {
                    DistributedTestCase.fail("While creating region", ex);
                }
            }
        };
        vm0.invoke(createRegion);
        vm1.invoke(createRegion);
        vm1.invoke(new SerializableRunnable("Populate region and perform some ops"){

            @Override
            public void run() {
                int i;
                for (i = 0; i < 100; ++i) {
                    CCRegion.put((Object)("cckey" + i), (Object)i);
                }
                for (i = 0; i < 100; ++i) {
                    CCRegion.put((Object)("cckey" + i), (Object)(i + 1));
                }
            }
        });
        vm0.invoke(new SerializableRunnable("Perform getAll"){

            @Override
            public void run() {
                LinkedList<String> keys = new LinkedList<String>();
                for (int i = 0; i < 100; ++i) {
                    keys.add("cckey" + i);
                }
                Map result = CCRegion.getAll(keys);
                TestCase.assertTrue((result.size() == keys.size() ? 1 : 0) != 0);
                LocalRegion r = CCRegion;
                for (int i = 0; i < 100; ++i) {
                    RegionEntry entry = r.getRegionEntry((Object)("cckey" + i));
                    int stamp = entry.getVersionStamp().getEntryVersion();
                    DistributedTestCase.getLogWriter().info("checking key cckey" + i + " having version " + stamp + " entry=" + entry);
                    TestCase.assertEquals((int)2, (int)stamp);
                    TestCase.assertEquals(result.get("cckey" + i), (Object)(i + 1));
                }
            }
        });
    }

    public void versionTestRegionVersionVectors() throws Exception {
        String local = DistributedTestCase.getIPLiteral();
        InternalDistributedMember server1 = new InternalDistributedMember(local, 101);
        InternalDistributedMember server2 = new InternalDistributedMember(local, 102);
        InternalDistributedMember server3 = new InternalDistributedMember(local, 103);
        InternalDistributedMember server4 = new InternalDistributedMember(local, 104);
        VMRegionVersionVector rv1 = null;
        rv1 = new VMRegionVersionVector(server1);
        rv1.recordVersion((VersionSource)server2, 1L);
        rv1.recordVersion((VersionSource)server2, 5L);
        rv1.recordVersion((VersionSource)server2, 8L);
        MultiVMRegionTestCase.getLogWriter().info("for test (a) formed this RVV: " + rv1.fullToString());
        MultiVMRegionTestCase.assertEquals((long)8L, (long)rv1.getVersionForMember((VersionSource)server2));
        MultiVMRegionTestCase.assertEquals((int)2, (int)rv1.getExceptionCount((VersionSource)server2));
        rv1.recordVersion((VersionSource)server2, 3L);
        MultiVMRegionTestCase.getLogWriter().info("for test (a) RVV is now: " + rv1.fullToString());
        MultiVMRegionTestCase.assertEquals((long)8L, (long)rv1.getVersionForMember((VersionSource)server2));
        MultiVMRegionTestCase.assertEquals((int)2, (int)rv1.getExceptionCount((VersionSource)server2));
        rv1.recordVersion((VersionSource)server2, 4L);
        rv1.recordVersion((VersionSource)server2, 2L);
        MultiVMRegionTestCase.getLogWriter().info("for test (a) RVV is now: " + rv1.fullToString());
        MultiVMRegionTestCase.assertEquals((int)1, (int)rv1.getExceptionCount((VersionSource)server2));
        rv1.recordVersion((VersionSource)server2, 6L);
        rv1.recordVersion((VersionSource)server2, 7L);
        MultiVMRegionTestCase.getLogWriter().info("for test (a) RVV is now: " + rv1.fullToString());
        MultiVMRegionTestCase.assertEquals((int)0, (int)rv1.getExceptionCount((VersionSource)server2));
        rv1 = new VMRegionVersionVector(server1);
        rv1.recordVersion((VersionSource)server2, 1L);
        rv1.recordVersion((VersionSource)server2, 5L);
        rv1.recordVersion((VersionSource)server2, 8L);
        rv1.recordVersion((VersionSource)server2, 10L);
        MultiVMRegionTestCase.getLogWriter().info("for test (b) formed this RVV: " + rv1.fullToString());
        MultiVMRegionTestCase.assertTrue((boolean)rv1.contains((VersionSource)server2, 1L));
        MultiVMRegionTestCase.assertTrue((boolean)rv1.contains((VersionSource)server2, 5L));
        MultiVMRegionTestCase.assertTrue((boolean)rv1.contains((VersionSource)server2, 8L));
        MultiVMRegionTestCase.assertTrue((boolean)rv1.contains((VersionSource)server2, 10L));
        MultiVMRegionTestCase.assertFalse((boolean)rv1.contains((VersionSource)server2, 2L));
        MultiVMRegionTestCase.assertFalse((boolean)rv1.contains((VersionSource)server2, 3L));
        MultiVMRegionTestCase.assertFalse((boolean)rv1.contains((VersionSource)server2, 4L));
        MultiVMRegionTestCase.assertFalse((boolean)rv1.contains((VersionSource)server2, 9L));
        MultiVMRegionTestCase.assertFalse((boolean)rv1.contains((VersionSource)server2, 11L));
        rv1.recordVersion((VersionSource)server2, 3L);
        MultiVMRegionTestCase.getLogWriter().info("for test (b) RVV is now: " + rv1.fullToString());
        MultiVMRegionTestCase.assertTrue((boolean)rv1.contains((VersionSource)server2, 3L));
        rv1.recordVersion((VersionSource)server2, 2L);
        MultiVMRegionTestCase.getLogWriter().info("for test (b) RVV is now: " + rv1.fullToString());
        MultiVMRegionTestCase.assertTrue((boolean)rv1.contains((VersionSource)server2, 2L));
        MultiVMRegionTestCase.assertTrue((boolean)rv1.contains((VersionSource)server2, 3L));
        rv1.recordVersion((VersionSource)server2, 4L);
        MultiVMRegionTestCase.getLogWriter().info("for test (b) RVV is now: " + rv1.fullToString());
        MultiVMRegionTestCase.assertTrue((boolean)rv1.contains((VersionSource)server2, 1L));
        MultiVMRegionTestCase.assertTrue((boolean)rv1.contains((VersionSource)server2, 2L));
        MultiVMRegionTestCase.assertTrue((boolean)rv1.contains((VersionSource)server2, 3L));
        MultiVMRegionTestCase.assertTrue((boolean)rv1.contains((VersionSource)server2, 4L));
        MultiVMRegionTestCase.assertTrue((boolean)rv1.contains((VersionSource)server2, 5L));
        rv1.recordVersion((VersionSource)server2, 11L);
        MultiVMRegionTestCase.getLogWriter().info("for test (b) RVV is now: " + rv1.fullToString());
        MultiVMRegionTestCase.assertTrue((boolean)rv1.contains((VersionSource)server2, 11L));
        MultiVMRegionTestCase.assertTrue((boolean)rv1.contains((VersionSource)server2, 10L));
        MultiVMRegionTestCase.getLogWriter().info("for test (b) RVV is now: " + rv1.fullToString());
        rv1.recordVersion((VersionSource)server2, 6L);
        MultiVMRegionTestCase.assertTrue((boolean)rv1.contains((VersionSource)server2, 2L));
        MultiVMRegionTestCase.assertTrue((boolean)rv1.contains((VersionSource)server2, 5L));
        MultiVMRegionTestCase.assertTrue((boolean)rv1.contains((VersionSource)server2, 6L));
        MultiVMRegionTestCase.assertFalse((boolean)rv1.contains((VersionSource)server2, 7L));
        MultiVMRegionTestCase.assertTrue((boolean)rv1.contains((VersionSource)server2, 8L));
        rv1.recordVersion((VersionSource)server2, 7L);
        MultiVMRegionTestCase.getLogWriter().info("for test (b) RVV is now: " + rv1.fullToString());
        MultiVMRegionTestCase.assertTrue((boolean)rv1.contains((VersionSource)server2, 7L));
        rv1.recordVersion((VersionSource)server2, 9L);
        MultiVMRegionTestCase.getLogWriter().info("for test (b) RVV is now: " + rv1.fullToString());
        MultiVMRegionTestCase.assertTrue((boolean)rv1.contains((VersionSource)server2, 9L));
        MultiVMRegionTestCase.assertTrue((rv1.getExceptionCount((VersionSource)server2) == 0 ? 1 : 0) != 0);
        MultiVMRegionTestCase.assertTrue((boolean)rv1.contains((VersionSource)server2, 8L));
        rv1 = new VMRegionVersionVector(server1);
        rv1.recordVersion((VersionSource)server2, 1L);
        rv1.recordVersion((VersionSource)server2, 4L);
        rv1.recordVersion((VersionSource)server2, 8L);
        rv1.recordVersion((VersionSource)server2, 9L);
        rv1.recordVersion((VersionSource)server2, 10L);
        rv1.recordVersion((VersionSource)server2, 11L);
        rv1.recordVersion((VersionSource)server2, 12L);
        rv1.recordVersion((VersionSource)server3, 2L);
        rv1.recordVersion((VersionSource)server3, 3L);
        rv1.recordVersion((VersionSource)server3, 4L);
        rv1.recordVersion((VersionSource)server3, 6L);
        rv1.recordVersion((VersionSource)server3, 7L);
        RegionVersionVector rv2 = rv1.getCloneForTransmission();
        MultiVMRegionTestCase.getLogWriter().info("rv1 is " + rv1.fullToString());
        MultiVMRegionTestCase.getLogWriter().info("rv2 is " + rv2.fullToString());
        MultiVMRegionTestCase.assertFalse((boolean)rv1.isNewerThanOrCanFillExceptionsFor(rv2));
        MultiVMRegionTestCase.assertFalse((boolean)rv2.isNewerThanOrCanFillExceptionsFor((RegionVersionVector)rv1));
        rv1.recordVersion((VersionSource)server2, 6L);
        MultiVMRegionTestCase.assertTrue((boolean)rv1.isNewerThanOrCanFillExceptionsFor(rv2));
        rv2.recordVersion((VersionSource)server2, 6L);
        MultiVMRegionTestCase.assertFalse((boolean)rv1.isNewerThanOrCanFillExceptionsFor(rv2));
        rv1.recordVersion((VersionSource)server2, 5L);
        MultiVMRegionTestCase.assertTrue((boolean)rv1.isNewerThanOrCanFillExceptionsFor(rv2));
        rv2.recordVersion((VersionSource)server2, 5L);
        MultiVMRegionTestCase.assertFalse((boolean)rv1.isNewerThanOrCanFillExceptionsFor(rv2));
        rv1.recordVersion((VersionSource)server2, 7L);
        MultiVMRegionTestCase.assertTrue((boolean)rv1.isNewerThanOrCanFillExceptionsFor(rv2));
        rv2.recordVersion((VersionSource)server2, 7L);
        MultiVMRegionTestCase.assertFalse((boolean)rv1.isNewerThanOrCanFillExceptionsFor(rv2));
        rv1.recordVersion((VersionSource)server3, 8L);
        MultiVMRegionTestCase.assertTrue((boolean)rv1.isNewerThanOrCanFillExceptionsFor(rv2));
        rv2.recordVersion((VersionSource)server3, 8L);
        MultiVMRegionTestCase.assertFalse((boolean)rv1.isNewerThanOrCanFillExceptionsFor(rv2));
        rv1.recordVersion((VersionSource)server3, 5L);
        MultiVMRegionTestCase.assertTrue((boolean)rv1.isNewerThanOrCanFillExceptionsFor(rv2));
        rv2.recordVersion((VersionSource)server3, 5L);
        MultiVMRegionTestCase.assertFalse((boolean)rv1.isNewerThanOrCanFillExceptionsFor(rv2));
        InternalDistributedMember server5 = new InternalDistributedMember(local, 105);
        rv1 = new VMRegionVersionVector(server1);
        rv1.recordVersion((VersionSource)server2, 1L);
        rv1.recordVersion((VersionSource)server3, 1L);
        rv1.recordVersion((VersionSource)server4, 1L);
        rv1.recordVersion((VersionSource)server5, 1L);
        rv1.memberDeparted(server2, false);
        rv1.memberDeparted(server4, true);
        MultiVMRegionTestCase.assertTrue((boolean)rv1.containsMember((VersionSource)server2));
        MultiVMRegionTestCase.assertTrue((boolean)rv1.containsMember((VersionSource)server3));
        MultiVMRegionTestCase.assertTrue((boolean)rv1.containsMember((VersionSource)server4));
        HashSet<InternalDistributedMember> retain = new HashSet<InternalDistributedMember>();
        retain.add(server2);
        retain.add(server3);
        retain.add(server5);
        rv1.removeOldMembers(retain);
        MultiVMRegionTestCase.assertFalse((boolean)rv1.containsMember((VersionSource)server4));
        rv1.memberDeparted(server3, false);
        InternalDistributedMember server6 = new InternalDistributedMember(local, 106);
        VMRegionVersionVector giiReceiverRVV = new VMRegionVersionVector(server6);
        rv2 = rv1.getCloneForTransmission();
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1000);
        DataOutputStream out = new DataOutputStream(baos);
        DataSerializer.writeObject((Object)rv2, (DataOutput)out);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        DataInputStream in = new DataInputStream(bais);
        RegionVersionVector transmittedVector = (RegionVersionVector)DataSerializer.readObject((DataInput)in);
        giiReceiverRVV.recordVersions(transmittedVector);
        MultiVMRegionTestCase.assertTrue((boolean)giiReceiverRVV.containsMember((VersionSource)server2));
        MultiVMRegionTestCase.assertTrue((boolean)giiReceiverRVV.containsMember((VersionSource)server5));
        MultiVMRegionTestCase.assertTrue((boolean)giiReceiverRVV.containsMember((VersionSource)server3));
        MultiVMRegionTestCase.assertTrue((boolean)giiReceiverRVV.isDepartedMember((VersionSource)server3));
        rv1 = new VMRegionVersionVector(server1);
        long bitSetRollPoint = RegionVersionHolder.BIT_SET_WIDTH + 1;
        long boundary = RegionVersionHolder.BIT_SET_WIDTH * 3 / 4;
        for (long i = 1L; i < boundary; ++i) {
            rv1.recordVersion((VersionSource)server2, i);
            MultiVMRegionTestCase.assertTrue((boolean)rv1.contains((VersionSource)server2, i));
        }
        MultiVMRegionTestCase.assertFalse((boolean)rv1.contains((VersionSource)server2, boundary + 1L));
        RegionVersionVector.DEBUG = true;
        rv1.setLogger(MultiVMRegionTestCase.getLogWriter());
        rv1.recordVersion((VersionSource)server2, bitSetRollPoint);
        rv1.recordVersion((VersionSource)server2, bitSetRollPoint + 1L);
        RegionVersionHolder h = (RegionVersionHolder)rv1.getMemberToVersion().get(server2);
        long versionBoundary = h.getBitSetVersionForTesting();
        MultiVMRegionTestCase.assertEquals((String)"expected holder bitset version to roll to this value", (long)(boundary - 1L), (long)versionBoundary);
        MultiVMRegionTestCase.assertFalse((boolean)rv1.contains((VersionSource)server2, bitSetRollPoint - 1L));
        MultiVMRegionTestCase.assertTrue((boolean)rv1.contains((VersionSource)server2, bitSetRollPoint));
        MultiVMRegionTestCase.assertTrue((boolean)rv1.contains((VersionSource)server2, bitSetRollPoint + 1L));
        MultiVMRegionTestCase.assertFalse((boolean)rv1.contains((VersionSource)server2, bitSetRollPoint + 2L));
        MultiVMRegionTestCase.assertTrue((boolean)rv1.contains((VersionSource)server2, boundary - 1L));
        MultiVMRegionTestCase.assertFalse((boolean)rv1.contains((VersionSource)server2, boundary));
        MultiVMRegionTestCase.assertFalse((boolean)rv1.contains((VersionSource)server2, boundary + 1L));
        MultiVMRegionTestCase.getLogWriter().info("testing merge for " + rv1.fullToString());
        MultiVMRegionTestCase.assertEquals((int)1, (int)rv1.getExceptionCount((VersionSource)server2));
        MultiVMRegionTestCase.assertFalse((boolean)rv1.contains((VersionSource)server2, bitSetRollPoint - 1L));
        MultiVMRegionTestCase.assertTrue((boolean)rv1.contains((VersionSource)server2, bitSetRollPoint));
        MultiVMRegionTestCase.assertTrue((boolean)rv1.contains((VersionSource)server2, bitSetRollPoint + 1L));
        MultiVMRegionTestCase.assertFalse((boolean)rv1.contains((VersionSource)server2, bitSetRollPoint + 2L));
    }

    protected boolean waitForAsyncProcessing(AsyncInvocation async, String expectedError) {
        boolean failed;
        block3: {
            failed = false;
            try {
                async.getResult();
            }
            catch (Throwable e) {
                Throwable e2;
                if (e.getCause() instanceof RMIException && (e2 = e.getCause()).getCause() instanceof AssertionFailedError && e2.getCause().getMessage().equals(expectedError)) {
                    failed = true;
                }
                if (failed) break block3;
                MultiVMRegionTestCase.fail("asyncInvocation 0 returned exception", e);
            }
        }
        return failed;
    }

    public static void assertNoClearTimeouts() {
        MultiVMRegionTestCase.assertEquals((String)"expected there to be no timeouts - something is broken", (int)0, (int)CCRegion.getCachePerfStats().getClearTimeouts());
    }

    public static void clearCCRegion() {
        CCRegion.clear();
    }

    public static Map getCCRegionContents() {
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        for (Region.Entry e : CCRegion.entrySet()) {
            result.put(e.getKey(), e.getValue());
        }
        return result;
    }

    public static byte[] getCCRegionVersionVector() throws Exception {
        InternalDistributedMember id = MultiVMRegionTestCase.getMemberId();
        int vm = VM.getCurrentVMNum();
        MultiVMRegionTestCase.getLogWriter().info("vm" + vm + " with id " + id + " copying " + CCRegion.getVersionVector().fullToString());
        RegionVersionVector vector = CCRegion.getVersionVector().getCloneForTransmission();
        MultiVMRegionTestCase.getLogWriter().info("clone is " + vector);
        HeapDataOutputStream dos = new HeapDataOutputStream(3000, Version.CURRENT);
        DataSerializer.writeObject((Object)vector, (DataOutput)dos);
        byte[] bytes = dos.toByteArray();
        MultiVMRegionTestCase.getLogWriter().info("serialized size is " + bytes.length);
        return bytes;
    }

    public static Map<String, VersionTag> getCCRegionVersions() {
        HashMap<String, VersionTag> result = new HashMap<String, VersionTag>();
        for (Region.Entry e : CCRegion.entrySet()) {
            result.put((String)e.getKey(), CCRegion.getRegionEntry(e.getKey()).getVersionStamp().asVersionTag());
        }
        return result;
    }

    public static InternalDistributedMember getMemberId() {
        return CCRegion.getDistributionManager().getDistributionManagerId();
    }

    static {
        hub = null;
    }

    static class DeltaValue
    implements Delta,
    Serializable {
        private String value;

        public DeltaValue() {
        }

        public DeltaValue(String value) {
            this.value = value;
        }

        public boolean hasDelta() {
            return true;
        }

        public void toDelta(DataOutput out) throws IOException {
            out.writeUTF(this.value);
        }

        public void fromDelta(DataInput in) throws IOException, InvalidDeltaException {
            this.value = in.readUTF();
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DeltaValue)) {
                return false;
            }
            return this.value.equals(((DeltaValue)obj).value);
        }

        public String toString() {
            return this.value;
        }
    }

    class CountingDistCacheListener
    extends CacheListenerAdapter {
        int aCreateCalls;
        int aUpdateCalls;
        int aInvalidateCalls;
        int aDestroyCalls;
        int aLocalDestroyCalls;
        int regionOps;
        EntryEvent lastEvent;

        CountingDistCacheListener() {
        }

        public void close() {
        }

        public synchronized void reset() {
            this.regionOps = 0;
            this.aDestroyCalls = 0;
            this.aInvalidateCalls = 0;
            this.aUpdateCalls = 0;
            this.aCreateCalls = 0;
            this.lastEvent = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterCreate(EntryEvent e) {
            if (e.isOriginRemote()) {
                CountingDistCacheListener countingDistCacheListener = this;
                synchronized (countingDistCacheListener) {
                    ++this.aCreateCalls;
                    this.lastEvent = e;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterUpdate(EntryEvent e) {
            if (e.isOriginRemote()) {
                CountingDistCacheListener countingDistCacheListener = this;
                synchronized (countingDistCacheListener) {
                    ++this.aUpdateCalls;
                    this.lastEvent = e;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterInvalidate(EntryEvent e) {
            if (e.isOriginRemote()) {
                CountingDistCacheListener countingDistCacheListener = this;
                synchronized (countingDistCacheListener) {
                    ++this.aInvalidateCalls;
                    this.lastEvent = e;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterDestroy(EntryEvent e) {
            if (e.isOriginRemote()) {
                CountingDistCacheListener countingDistCacheListener = this;
                synchronized (countingDistCacheListener) {
                    ++this.aDestroyCalls;
                    this.lastEvent = e;
                }
            }
        }

        public void afterRegionInvalidate(RegionEvent e) {
            ++this.regionOps;
        }

        public void afterRegionDestroy(RegionEvent e) {
            ++this.regionOps;
        }

        public synchronized void assertCount(int expectedCreate, int expectedUpdate, int expectedInvalidate, int expectedDestroy) {
            TestCase.assertEquals((int)expectedCreate, (int)this.aCreateCalls);
            TestCase.assertEquals((int)expectedUpdate, (int)this.aUpdateCalls);
            TestCase.assertEquals((int)expectedInvalidate, (int)this.aInvalidateCalls);
            TestCase.assertEquals((int)expectedDestroy, (int)this.aDestroyCalls);
            TestCase.assertEquals((int)0, (int)this.regionOps);
        }

        public synchronized EntryEvent getEntryEvent() {
            return this.lastEvent;
        }

        public synchronized void setEntryEvent(EntryEvent event) {
            this.lastEvent = event;
        }
    }

    public class MyTransactionListener
    implements TransactionListener {
        public volatile TransactionId expectedTxId;
        public volatile TransactionEvent lastEvent;
        public volatile int afterCommitCount;
        public volatile int afterFailedCommitCount;
        public volatile int afterRollbackCount;
        public volatile int closeCount;

        public void afterCommit(TransactionEvent event) {
            this.lastEvent = event;
            ++this.afterCommitCount;
        }

        public void afterFailedCommit(TransactionEvent event) {
            this.lastEvent = event;
            ++this.afterFailedCommitCount;
        }

        public void afterRollback(TransactionEvent event) {
            this.lastEvent = event;
            ++this.afterRollbackCount;
        }

        public void close() {
            ++this.closeCount;
        }

        public void reset() {
            this.afterCommitCount = 0;
            this.afterFailedCommitCount = 0;
            this.afterRollbackCount = 0;
            this.closeCount = 0;
        }

        public void checkAfterCommitCount(int expected) {
            TestCase.assertEquals((int)expected, (int)this.afterCommitCount);
        }

        public void assertCounts(int commitCount, int failedCommitCount, int rollbackCount, int closeCount1) {
            TestCase.assertEquals((int)commitCount, (int)this.afterCommitCount);
            TestCase.assertEquals((int)failedCommitCount, (int)this.afterFailedCommitCount);
            TestCase.assertEquals((int)rollbackCount, (int)this.afterRollbackCount);
            TestCase.assertEquals((int)closeCount1, (int)this.closeCount);
        }
    }

    static class DSLongWrapper
    extends LongWrapper
    implements DataSerializable {
        DSLongWrapper(long longValue) {
            super(longValue);
        }

        protected DSLongWrapper() {
            super(0L);
        }

        public void toData(DataOutput out) throws IOException {
            out.writeLong(this.longValue);
        }

        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            this.longValue = in.readLong();
        }

        static class DSLongWrapperInstantiator
        extends Instantiator {
            boolean wasInvoked = false;

            DSLongWrapperInstantiator(Class c, byte id) {
                super(c, (int)id);
            }

            DSLongWrapperInstantiator() {
                this(DSLongWrapper.class, 99);
            }

            public DataSerializable newInstance() {
                this.wasInvoked = true;
                return new DSLongWrapper();
            }
        }
    }

    static class LongWrapper {
        long longValue;

        LongWrapper(long longValue) {
            this.longValue = longValue;
        }

        public boolean equals(Object o) {
            if (o instanceof LongWrapper) {
                return ((LongWrapper)o).longValue == this.longValue;
            }
            return false;
        }

        static class LongWrapperSerializer
        extends DataSerializer {
            boolean wasInvoked = false;

            LongWrapperSerializer() {
            }

            public int getId() {
                return 121;
            }

            public Class[] getSupportedClasses() {
                return new Class[]{LongWrapper.class};
            }

            public boolean toData(Object o, DataOutput out) throws IOException {
                if (o instanceof LongWrapper) {
                    this.wasInvoked = true;
                    LongWrapper iw = (LongWrapper)o;
                    out.writeLong(iw.longValue);
                    return true;
                }
                return false;
            }

            public Object fromData(DataInput in) throws IOException, ClassNotFoundException {
                return new LongWrapper(in.readLong());
            }
        }
    }

    static class DSIntWrapper
    extends IntWrapper
    implements DataSerializable {
        DSIntWrapper(int intValue) {
            super(intValue);
        }

        protected DSIntWrapper() {
            super(0);
        }

        public void toData(DataOutput out) throws IOException {
            out.writeInt(this.intValue);
        }

        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            this.intValue = in.readInt();
        }

        static class DSIntWrapperInstantiator
        extends Instantiator {
            DSIntWrapperInstantiator() {
                this(DSIntWrapper.class, 76);
            }

            DSIntWrapperInstantiator(Class c, byte id) {
                super(c, (int)id);
            }

            public DataSerializable newInstance() {
                return new DSIntWrapper();
            }
        }
    }

    static class IntWrapper {
        int intValue;

        IntWrapper(int intValue) {
            this.intValue = intValue;
        }

        public boolean equals(Object o) {
            if (o instanceof IntWrapper) {
                return ((IntWrapper)o).intValue == this.intValue;
            }
            return false;
        }

        static class IntWrapperSerializer
        extends DataSerializer {
            boolean wasInvoked = false;

            IntWrapperSerializer() {
            }

            public int getId() {
                return 120;
            }

            public Class[] getSupportedClasses() {
                return new Class[]{IntWrapper.class};
            }

            public boolean toData(Object o, DataOutput out) throws IOException {
                if (o instanceof IntWrapper) {
                    this.wasInvoked = true;
                    IntWrapper iw = (IntWrapper)o;
                    out.writeInt(iw.intValue);
                    return true;
                }
                return false;
            }

            public Object fromData(DataInput in) throws IOException, ClassNotFoundException {
                return new IntWrapper(in.readInt());
            }
        }
    }

    static final class AddTen
    extends AbstractDelta
    implements Serializable {
        AddTen() {
        }

        private Object apply(Object oldValue) {
            if (oldValue instanceof String) {
                return (String)oldValue + " 10";
            }
            if (oldValue instanceof Integer) {
                return new Integer((Integer)oldValue + 10);
            }
            throw new IllegalStateException("unexpected old value");
        }

        public Object apply(Region<?, ?> region, Object key, Object oldValue, boolean prepareForOffHeap) {
            return this.apply(oldValue);
        }
    }
}

